// Copyright (c) 2018 The Jaeger Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package adaptive

import (
	"math"
	"strconv"
)

// TruncateFloat truncates float to 6 decimal positions and converts to string.
func TruncateFloat(v float64) string {
	return strconv.FormatFloat(v, 'f', 6, 64)
}

// FloatEquals compares two floats with 10 decimal positions precision.
func FloatEquals(a, b float64) bool {
	return math.Abs(a-b) < 1e-10
}
