// Code generated from specification version 7.0.0: DO NOT EDIT

package esapi

import (
	"context"
	"strconv"
	"strings"
	"time"
)

func newCatShardsFunc(t Transport) CatShards {
	return func(o ...func(*CatShardsRequest)) (*Response, error) {
		var r = CatShardsRequest{}
		for _, f := range o {
			f(&r)
		}
		return r.Do(r.ctx, t)
	}
}

// ----- API Definition -------------------------------------------------------

// CatShards provides a detailed view of shard allocation on nodes.
//
// See full documentation at http://www.elastic.co/guide/en/elasticsearch/reference/master/cat-shards.html.
//
type CatShards func(o ...func(*CatShardsRequest)) (*Response, error)

// CatShardsRequest configures the Cat Shards API request.
//
type CatShardsRequest struct {
	Index []string

	Bytes         string
	Format        string
	H             []string
	Help          *bool
	Local         *bool
	MasterTimeout time.Duration
	S             []string
	V             *bool

	Pretty     bool
	Human      bool
	ErrorTrace bool
	FilterPath []string

	ctx context.Context
}

// Do executes the request and returns response or error.
//
func (r CatShardsRequest) Do(ctx context.Context, transport Transport) (*Response, error) {
	var (
		method string
		path   strings.Builder
		params map[string]string
	)

	method = "GET"

	path.Grow(1 + len("_cat") + 1 + len("shards") + 1 + len(strings.Join(r.Index, ",")))
	path.WriteString("/")
	path.WriteString("_cat")
	path.WriteString("/")
	path.WriteString("shards")
	if len(r.Index) > 0 {
		path.WriteString("/")
		path.WriteString(strings.Join(r.Index, ","))
	}

	params = make(map[string]string)

	if r.Bytes != "" {
		params["bytes"] = r.Bytes
	}

	if r.Format != "" {
		params["format"] = r.Format
	}

	if len(r.H) > 0 {
		params["h"] = strings.Join(r.H, ",")
	}

	if r.Help != nil {
		params["help"] = strconv.FormatBool(*r.Help)
	}

	if r.Local != nil {
		params["local"] = strconv.FormatBool(*r.Local)
	}

	if r.MasterTimeout != 0 {
		params["master_timeout"] = formatDuration(r.MasterTimeout)
	}

	if len(r.S) > 0 {
		params["s"] = strings.Join(r.S, ",")
	}

	if r.V != nil {
		params["v"] = strconv.FormatBool(*r.V)
	}

	if r.Pretty {
		params["pretty"] = "true"
	}

	if r.Human {
		params["human"] = "true"
	}

	if r.ErrorTrace {
		params["error_trace"] = "true"
	}

	if len(r.FilterPath) > 0 {
		params["filter_path"] = strings.Join(r.FilterPath, ",")
	}

	req, _ := newRequest(method, path.String(), nil)

	if len(params) > 0 {
		q := req.URL.Query()
		for k, v := range params {
			q.Set(k, v)
		}
		req.URL.RawQuery = q.Encode()
	}

	if ctx != nil {
		req = req.WithContext(ctx)
	}

	res, err := transport.Perform(req)
	if err != nil {
		return nil, err
	}

	response := Response{
		StatusCode: res.StatusCode,
		Body:       res.Body,
		Header:     res.Header,
	}

	return &response, nil
}

// WithContext sets the request context.
//
func (f CatShards) WithContext(v context.Context) func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.ctx = v
	}
}

// WithIndex - a list of index names to limit the returned information.
//
func (f CatShards) WithIndex(v ...string) func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.Index = v
	}
}

// WithBytes - the unit in which to display byte values.
//
func (f CatShards) WithBytes(v string) func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.Bytes = v
	}
}

// WithFormat - a short version of the accept header, e.g. json, yaml.
//
func (f CatShards) WithFormat(v string) func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.Format = v
	}
}

// WithH - comma-separated list of column names to display.
//
func (f CatShards) WithH(v ...string) func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.H = v
	}
}

// WithHelp - return help information.
//
func (f CatShards) WithHelp(v bool) func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.Help = &v
	}
}

// WithLocal - return local information, do not retrieve the state from master node (default: false).
//
func (f CatShards) WithLocal(v bool) func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.Local = &v
	}
}

// WithMasterTimeout - explicit operation timeout for connection to master node.
//
func (f CatShards) WithMasterTimeout(v time.Duration) func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.MasterTimeout = v
	}
}

// WithS - comma-separated list of column names or column aliases to sort by.
//
func (f CatShards) WithS(v ...string) func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.S = v
	}
}

// WithV - verbose mode. display column headers.
//
func (f CatShards) WithV(v bool) func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.V = &v
	}
}

// WithPretty makes the response body pretty-printed.
//
func (f CatShards) WithPretty() func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.Pretty = true
	}
}

// WithHuman makes statistical values human-readable.
//
func (f CatShards) WithHuman() func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.Human = true
	}
}

// WithErrorTrace includes the stack trace for errors in the response body.
//
func (f CatShards) WithErrorTrace() func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.ErrorTrace = true
	}
}

// WithFilterPath filters the properties of the response body.
//
func (f CatShards) WithFilterPath(v ...string) func(*CatShardsRequest) {
	return func(r *CatShardsRequest) {
		r.FilterPath = v
	}
}
