package test

import (
	"fmt"
	"strconv"

	"github.com/quay/claircore"
)

func GenUniqueVulnerabilities(n int, updater string) []*claircore.Vulnerability {
	if n == 0 {
		return nil
	}
	vulns := []*claircore.Vulnerability{}
	for i := 0; i < n; i++ {
		vulns = append(vulns, &claircore.Vulnerability{
			ID:                 strconv.Itoa(i),
			Updater:            updater,
			Name:               fmt.Sprintf("test-vuln-%d", i),
			Description:        fmt.Sprintf("test-vuln-desc-%d", i),
			Links:              fmt.Sprintf("test-vuln-links-%d", i),
			Severity:           fmt.Sprintf("test-severity-%d", i),
			NormalizedSeverity: claircore.Unknown,
			ArchOperation:      claircore.OpEquals,
			Package: &claircore.Package{
				ID:      strconv.Itoa(i),
				Name:    fmt.Sprintf("package-%d", i),
				Version: fmt.Sprintf("version-%d", i),
				Arch:    fmt.Sprintf("arch-%d", i),
				Kind:    claircore.BINARY,
			},
			Dist: &claircore.Distribution{
				ID:              strconv.Itoa(i),
				Name:            fmt.Sprintf("dist-%d", i),
				Version:         fmt.Sprintf("version-%d", i),
				VersionCodeName: fmt.Sprintf("version%d", i),
				VersionID:       fmt.Sprintf("%d", i),
				Arch:            fmt.Sprintf("arch-%d", i),
				CPE:             WFN(i),
				PrettyName:      fmt.Sprintf("pretty-name-%d", i),
			},
			Repo: &claircore.Repository{
				ID:   strconv.Itoa(i),
				Name: fmt.Sprintf("repo-%d", i),
				Key:  fmt.Sprintf("key-%d", i),
				URI:  fmt.Sprintf("uri-%d", i),
			},
		})
	}

	return vulns
}
