"""
Add lifetime end indexes to tag tables.

Revision ID: b9045731c4de
Revises: e184af42242d
Create Date: 2019-02-14 17:18:40.474310
"""

# revision identifiers, used by Alembic.
revision = "b9045731c4de"
down_revision = "e184af42242d"


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(
        "repositorytag_repository_id_lifetime_end_ts",
        "repositorytag",
        ["repository_id", "lifetime_end_ts"],
        unique=False,
    )
    op.create_index(
        "tag_repository_id_lifetime_end_ms",
        "tag",
        ["repository_id", "lifetime_end_ms"],
        unique=False,
    )

    op.create_index(
        "repositorytag_repository_id_lifetime_start_ts",
        "repositorytag",
        ["repository_id", "lifetime_start_ts"],
        unique=False,
    )
    op.create_index(
        "tag_repository_id_lifetime_start_ms",
        "tag",
        ["repository_id", "lifetime_start_ms"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("tag_repository_id_lifetime_end_ms", table_name="tag")
    op.drop_index("repositorytag_repository_id_lifetime_end_ts", table_name="repositorytag")

    op.drop_index("tag_repository_id_lifetime_start_ms", table_name="tag")
    op.drop_index("repositorytag_repository_id_lifetime_start_ts", table_name="repositorytag")
    # ### end Alembic commands ###
