"""
Add RobotAccountMetadata table.

Revision ID: b547bc139ad8
Revises: 0cf50323c78b
Create Date: 2018-03-09 15:50:48.298880
"""

# revision identifiers, used by Alembic.
revision = "b547bc139ad8"
down_revision = "0cf50323c78b"

import sqlalchemy as sa
from util.migrate import UTF8CharField


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "robotaccountmetadata",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("robot_account_id", sa.Integer(), nullable=False),
        sa.Column("description", UTF8CharField(length=255), nullable=False),
        sa.Column("unstructured_json", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["robot_account_id"],
            ["user.id"],
            name=op.f("fk_robotaccountmetadata_robot_account_id_user"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_robotaccountmetadata")),
    )
    op.create_index(
        "robotaccountmetadata_robot_account_id",
        "robotaccountmetadata",
        ["robot_account_id"],
        unique=True,
    )
    # ### end Alembic commands ###

    # ### population of test data ### #
    tester.populate_table(
        "robotaccountmetadata",
        [
            ("robot_account_id", tester.TestDataType.Foreign("user")),
            ("description", tester.TestDataType.UTF8Char),
            ("unstructured_json", tester.TestDataType.JSON),
        ],
    )
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("robotaccountmetadata")
    # ### end Alembic commands ###
