"""
Add deleted namespace table.

Revision ID: b4c2d45bc132
Revises: 152edccba18c
Create Date: 2018-02-27 11:43:02.329941
"""

# revision identifiers, used by Alembic.
revision = "b4c2d45bc132"
down_revision = "152edccba18c"

import sqlalchemy as sa


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "deletednamespace",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("namespace_id", sa.Integer(), nullable=False),
        sa.Column("marked", sa.DateTime(), nullable=False),
        sa.Column("original_username", sa.String(length=255), nullable=False),
        sa.Column("original_email", sa.String(length=255), nullable=False),
        sa.Column("queue_id", sa.String(length=255), nullable=True),
        sa.ForeignKeyConstraint(
            ["namespace_id"], ["user.id"], name=op.f("fk_deletednamespace_namespace_id_user")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_deletednamespace")),
    )
    op.create_index(
        "deletednamespace_namespace_id", "deletednamespace", ["namespace_id"], unique=True
    )
    op.create_index(
        "deletednamespace_original_email", "deletednamespace", ["original_email"], unique=False
    )
    op.create_index(
        "deletednamespace_original_username",
        "deletednamespace",
        ["original_username"],
        unique=False,
    )
    op.create_index("deletednamespace_queue_id", "deletednamespace", ["queue_id"], unique=False)
    # ### end Alembic commands ###

    # ### population of test data ### #
    tester.populate_table(
        "deletednamespace",
        [
            ("namespace_id", tester.TestDataType.Foreign("user")),
            ("marked", tester.TestDataType.DateTime),
            ("original_username", tester.TestDataType.UTF8Char),
            ("original_email", tester.TestDataType.String),
            ("queue_id", tester.TestDataType.Foreign("queueitem")),
        ],
    )
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("deletednamespace")
    # ### end Alembic commands ###
