"""
Remove blob_index from ManifestBlob table.

Revision ID: eafdeadcebc7
Revises: 9093adccc784
Create Date: 2018-08-07 15:57:54.001225
"""

# revision identifiers, used by Alembic.
revision = "eafdeadcebc7"
down_revision = "9093adccc784"

import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("manifestblob_manifest_id_blob_index", table_name="manifestblob")
    op.drop_column("manifestblob", "blob_index")
    # ### end Alembic commands ###


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "manifestblob",
        sa.Column(
            "blob_index", mysql.INTEGER(display_width=11), autoincrement=False, nullable=True
        ),
    )
    op.create_index(
        "manifestblob_manifest_id_blob_index",
        "manifestblob",
        ["manifest_id", "blob_index"],
        unique=True,
    )
    # ### end Alembic commands ###
