"""
Add TagToRepositoryTag table.

Revision ID: 67f0abd172ae
Revises: 10f45ee2310b
Create Date: 2018-10-30 11:31:06.615488
"""

# revision identifiers, used by Alembic.
revision = "67f0abd172ae"
down_revision = "10f45ee2310b"

import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "tagtorepositorytag",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("repository_id", sa.Integer(), nullable=False),
        sa.Column("tag_id", sa.Integer(), nullable=False),
        sa.Column("repository_tag_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["repository_id"],
            ["repository.id"],
            name=op.f("fk_tagtorepositorytag_repository_id_repository"),
        ),
        sa.ForeignKeyConstraint(
            ["repository_tag_id"],
            ["repositorytag.id"],
            name=op.f("fk_tagtorepositorytag_repository_tag_id_repositorytag"),
        ),
        sa.ForeignKeyConstraint(
            ["tag_id"], ["tag.id"], name=op.f("fk_tagtorepositorytag_tag_id_tag")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_tagtorepositorytag")),
    )
    op.create_index(
        "tagtorepositorytag_repository_id", "tagtorepositorytag", ["repository_id"], unique=False
    )
    op.create_index(
        "tagtorepositorytag_repository_tag_id",
        "tagtorepositorytag",
        ["repository_tag_id"],
        unique=True,
    )
    op.create_index("tagtorepositorytag_tag_id", "tagtorepositorytag", ["tag_id"], unique=True)
    # ### end Alembic commands ###

    tester.populate_table(
        "tagtorepositorytag",
        [
            ("repository_id", tester.TestDataType.Foreign("repository")),
            ("tag_id", tester.TestDataType.Foreign("tag")),
            ("repository_tag_id", tester.TestDataType.Foreign("repositorytag")),
        ],
    )


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("tagtorepositorytag")
    # ### end Alembic commands ###
