"""
Add trust_enabled to repository.

Revision ID: ed01e313d3cb
Revises: c3d4b7ebcdf7
Create Date: 2017-04-14 17:38:03.319695
"""

# revision identifiers, used by Alembic.
revision = "ed01e313d3cb"
down_revision = "c3d4b7ebcdf7"

import sqlalchemy as sa


def upgrade(op, tables, tester):
    ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "repository",
        sa.Column(
            "trust_enabled", sa.Boolean(), nullable=False, server_default=sa.sql.expression.false()
        ),
    )
    ### end Alembic commands ###
    op.bulk_insert(
        tables.logentrykind,
        [
            {"name": "change_repo_trust"},
        ],
    )

    # ### population of test data ### #
    tester.populate_column("repository", "trust_enabled", tester.TestDataType.Boolean)
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("repository", "trust_enabled")
    ### end Alembic commands ###

    op.execute(
        tables.logentrykind.delete().where(
            tables.logentrykind.name == op.inline_literal("change_repo_trust")
        )
    )
