"""
Add NamespaceGeoRestriction table.

Revision ID: 54492a68a3cf
Revises: c00a1f15968b
Create Date: 2018-12-05 15:12:14.201116
"""

# revision identifiers, used by Alembic.
revision = "54492a68a3cf"
down_revision = "c00a1f15968b"

import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "namespacegeorestriction",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("namespace_id", sa.Integer(), nullable=False),
        sa.Column("added", sa.DateTime(), nullable=False),
        sa.Column("description", sa.String(length=255), nullable=False),
        sa.Column("unstructured_json", sa.Text(), nullable=False),
        sa.Column("restricted_region_iso_code", sa.String(length=255), nullable=False),
        sa.ForeignKeyConstraint(
            ["namespace_id"], ["user.id"], name=op.f("fk_namespacegeorestriction_namespace_id_user")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_namespacegeorestriction")),
    )
    op.create_index(
        "namespacegeorestriction_namespace_id",
        "namespacegeorestriction",
        ["namespace_id"],
        unique=False,
    )
    op.create_index(
        "namespacegeorestriction_namespace_id_restricted_region_iso_code",
        "namespacegeorestriction",
        ["namespace_id", "restricted_region_iso_code"],
        unique=True,
    )
    op.create_index(
        "namespacegeorestriction_restricted_region_iso_code",
        "namespacegeorestriction",
        ["restricted_region_iso_code"],
        unique=False,
    )
    # ### end Alembic commands ###

    tester.populate_table(
        "namespacegeorestriction",
        [
            ("namespace_id", tester.TestDataType.Foreign("user")),
            ("added", tester.TestDataType.DateTime),
            ("description", tester.TestDataType.String),
            ("unstructured_json", tester.TestDataType.JSON),
            ("restricted_region_iso_code", tester.TestDataType.String),
        ],
    )


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("namespacegeorestriction")
    # ### end Alembic commands ###
