"""
Add maximum build queue count setting to user table.

Revision ID: 152bb29a1bb3
Revises: 7367229b38d9
Create Date: 2018-02-20 13:34:34.902415
"""

# revision identifiers, used by Alembic.
revision = "152bb29a1bb3"
down_revision = "cbc8177760d9"

import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("user", sa.Column("maximum_queued_builds_count", sa.Integer(), nullable=True))
    # ### end Alembic commands ###

    # ### population of test data ### #
    tester.populate_column("user", "maximum_queued_builds_count", tester.TestDataType.Integer)
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("user", "maximum_queued_builds_count")
    # ### end Alembic commands ###
