# Weekly VPNkit dev report for 2017-05-15 to 2017-05-28 (weeks 20 and 21)

This report covers weekly developments in the [moby/vpnkit],
[mirage/ocaml-dns], [mirage/ocaml-hvsock], [djs55/ocaml-osx-dnssd],
[mirage/mirage-tcpip] and [djs55/ocaml-dns-forward] repositories. These form
the basis of the VPNKit toolkit used to translate container network traffic
into native platform socket calls on Windows and OSX.

VPNKit now has an experimental transparent HTTP proxy builtin, which lets it
proxy all outgoing traffic on port 80 at the HTTP level, and all outgoing
traffic on port 443 via `HTTP CONNECT`.  This has the advantage that the client
doesn't need to know it's being proxied so that if the client moves on the
network everything continues to work. ([moby/vpnkit#225] [@djs55]).

Scalability of VPNKit was also improved for a large number of connections,
and is now configurable via the `--listen-backlog <n>` flag.

Various spurious DNS failures were also fixed, leading to the release of
[mirage/ocaml-dns:0.20.1].

One area where we could use contributions in TCP/IP is with the test suite,
to help spot regressions in performance and retransmission behaviour.  Please
see [mirage/mirage-tcpip#140] or [mirage/mirage-tcpip#314] for more information,
as well as the [testing tcpip](http://canopy.mirage.io/Projects/test-tcpip) page
on the MirageOS dev wiki.

## PRs merged

- Add an experimental transparent HTTP proxy ([moby/vpnkit#225] [@djs55])
- Avoid logging spurious DNS AAAA lookup failures ([moby/vpnkit#226] [@djs55])
- Fix warnings, selectively re-enable `-warn-error` ([moby/vpnkit#222] [@djs55])
- Add command-line argument `--listen-backlog <n>` ([moby/vpnkit#223] [@djs55])
- Packaging: Update upstream packages ([moby/vpnkit#224] [@djs55])
- Update to Lwt.3.0.0 ([mirage/ocaml-dns#136] [@samoht])
- Update CHANGES ([mirage/ocaml-dns#140] [@samoht])
- Add missing `doc` field in opam file ([mirage/ocaml-dns#141] [@samoht])
- Test MTUs in TCP/IP ([mirage/mirage-tcpip#313] [@djs55])
- Switch to jbuilder and topkg for fast builds in hvsock ([mirage/ocaml-hvsock#53])

Other reports in this series can be browsed directly in the repository at
[moby/vpnkit:/reports](https://github.com/moby/vpnkit/tree/master/reports/).

[@djs55]: https://github.com/djs55
[@samoht]: https://github.com/samoht
[@talex5]: https://github.com/talex5
[@yomimono]: https://github.com/yomimono
[djs55/ocaml-dns-forward]: https://github.com/djs55/ocaml-dns-forward
[djs55/ocaml-osx-dnssd]: https://github.com/djs55/ocaml-osx-dnssd
[mirage/mirage-tcpip]: https://github.com/mirage/mirage-tcpip
[mirage/mirage-tcpip#140]: https://github.com/mirage/mirage-tcpip/issues/140
[mirage/mirage-tcpip#313]: https://github.com/mirage/mirage-tcpip/pull/313
[mirage/mirage-tcpip#314]: https://github.com/mirage/mirage-tcpip/issues/314
[mirage/mirage-tcpip#315]: https://github.com/mirage/mirage-tcpip/pull/315
[mirage/mirage-tcpip:v3.1.3]: https://github.com/mirage/mirage-tcpip/releases/tag/v3.1.3
[mirage/ocaml-dns]: https://github.com/mirage/ocaml-dns
[mirage/ocaml-dns#136]: https://github.com/mirage/ocaml-dns/pull/136
[mirage/ocaml-dns#139]: https://github.com/mirage/ocaml-dns/pull/139
[mirage/ocaml-dns#140]: https://github.com/mirage/ocaml-dns/pull/140
[mirage/ocaml-dns#141]: https://github.com/mirage/ocaml-dns/pull/141
[mirage/ocaml-dns:0.20.1]: https://github.com/mirage/ocaml-dns/releases/tag/0.20.1
[mirage/ocaml-hvsock]: https://github.com/mirage/ocaml-hvsock
[mirage/ocaml-hvsock#53]: https://github.com/mirage/ocaml-hvsock/pull/53
[moby/vpnkit]: https://github.com/moby/vpnkit
[moby/vpnkit#222]: https://github.com/moby/vpnkit/pull/222
[moby/vpnkit#223]: https://github.com/moby/vpnkit/pull/223
[moby/vpnkit#224]: https://github.com/moby/vpnkit/pull/224
[moby/vpnkit#219]: https://github.com/moby/vpnkit/pull/219
[moby/vpnkit#225]: https://github.com/moby/vpnkit/pull/225
[moby/vpnkit#226]: https://github.com/moby/vpnkit/pull/226

