# Weekly VPNKit dev report for 2017-04-24 to 2017-04-30 (week 17)

This report covers weekly developments in the [moby/vpnkit], [mirage/ocaml-dns],
[mirage/ocaml-hvsock], [djs55/ocaml-osx-dnssd] and [mirage/mirage-tcpip] repositories.

**TL;DR:** This week saw important bugfixes in preserving the order of DNS resource records and
TCP connection tracking, which have been causing network issues for users of VPNKit
via in Docker for Mac and Windows.

The project now has a new home in the [Moby Project](http://mobyproject.org) and the main
VPNKit repository was renamed to live in the new [moby/vpnkit] organisation. 
Several library releases were cut this week that included these fixes, in [mirage/ocaml-hvsock:v0.14.0],
[djs55/ocaml-osx-dnssd:v0.4] (and [djs55/ocaml-osx-dnssd:v0.3] as an intermediate release).

## PRs merged

- The port forwarding path has been made much more robust to connection floods.
  Now connections are closed synchronously to ensure prompt resource cleanup and logging.
  The number of maximum connections is also discovered dynamically rather than being hardcoded ([moby/vpnkit#214] [@djs55]).
- Avoid reversing and duplicating DNS RRs when quering the local resolver on macOS ([moby/vpnkit#216] [djs55/ocaml-osx-dnssd#6] [@djs55])

## PRs with activity

- [@hannesm] did a comprehensive review of the state of DNS name handling as he is writing a recursive name resolver, and there has been an active discussion about how to improve the DNS library in future releases ([mirage/ocaml-dns#137] [@MagnusS] [@yomimono] [@stedolan] [@hannesm] [@dsheets] [@djs55] [@avsm]).
- The MirageOS TCP/IP stack started sending packets with an oversized MTU on some backends such as virtio, so there has been discussion about how to fix it ([mirage/mirage-tcpip#309] [@hannesm] [@talex5] [@djs55] [@avsm] [@yomimono]).
- To help debugging, we are also restoring Git history to the Mirage TCP/IP stack, but this requires a rebase ([mirage/mirage-tcpip#270] [@yomimono] [@balrajsingh] [@avsm] [@samoht]).
- The Windows HyperV socket bindings are being prepared for a new release ([mirage/ocaml-hvsock#52]). 

## External Links or Blogs

- [Introducing the Moby Project](https://blog.docker.com/2017/04/introducing-the-moby-project/) to explain VPNKit's new home.

Other reports in this series can be browsed directly in the repository at [moby/vpnkit:/reports](https://github.com/moby/vpnkit/tree/master/reports/).

[@MagnusS]: https://github.com/MagnusS
[@avsm]: https://github.com/avsm
[@balrajsingh]: https://github.com/balrajsingh
[@djs55]: https://github.com/djs55
[@dsheets]: https://github.com/dsheets
[@hannesm]: https://github.com/hannesm
[@samoht]: https://github.com/samoht
[@stedolan]: https://github.com/stedolan
[@talex5]: https://github.com/talex5
[@yomimono]: https://github.com/yomimono
[djs55/ocaml-osx-dnssd]: https://github.com/djs55/ocaml-osx-dnssd
[djs55/ocaml-osx-dnssd#6]: https://github.com/djs55/ocaml-osx-dnssd/pull/6
[djs55/ocaml-osx-dnssd#7]: https://github.com/djs55/ocaml-osx-dnssd/pull/7
[djs55/ocaml-osx-dnssd:v0.3]: https://github.com/djs55/ocaml-osx-dnssd/releases/tag/v0.3
[djs55/ocaml-osx-dnssd:v0.4]: https://github.com/djs55/ocaml-osx-dnssd/releases/tag/v0.4
[mirage/mirage-tcpip]: https://github.com/mirage/mirage-tcpip
[mirage/mirage-tcpip#270]: https://github.com/mirage/mirage-tcpip/issues/270
[mirage/mirage-tcpip#309]: https://github.com/mirage/mirage-tcpip/pull/309
[mirage/mirage-tcpip#310]: https://github.com/mirage/mirage-tcpip/pull/310
[mirage/ocaml-dns]: https://github.com/mirage/ocaml-dns
[mirage/ocaml-dns#137]: https://github.com/mirage/ocaml-dns/issues/137
[mirage/ocaml-hvsock]: https://github.com/mirage/ocaml-hvsock
[mirage/ocaml-hvsock#52]: https://github.com/mirage/ocaml-hvsock/pull/52
[mirage/ocaml-hvsock:v0.14.0]: https://github.com/mirage/ocaml-hvsock/releases/tag/v0.14.0
[moby/vpnkit]: https://github.com/moby/vpnkit
[moby/vpnkit#214]: https://github.com/moby/vpnkit/pull/214
[moby/vpnkit#215]: https://github.com/moby/vpnkit/pull/215
[moby/vpnkit#216]: https://github.com/moby/vpnkit/pull/216

