package network

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// Access enumerates the values for access.
type Access string

const (
	// Allow ...
	Allow Access = "Allow"
	// Deny ...
	Deny Access = "Deny"
)

// PossibleAccessValues returns an array of possible values for the Access const type.
func PossibleAccessValues() []Access {
	return []Access{Allow, Deny}
}

// ApplicationGatewayBackendHealthServerHealth enumerates the values for application gateway backend health
// server health.
type ApplicationGatewayBackendHealthServerHealth string

const (
	// Down ...
	Down ApplicationGatewayBackendHealthServerHealth = "Down"
	// Draining ...
	Draining ApplicationGatewayBackendHealthServerHealth = "Draining"
	// Partial ...
	Partial ApplicationGatewayBackendHealthServerHealth = "Partial"
	// Unknown ...
	Unknown ApplicationGatewayBackendHealthServerHealth = "Unknown"
	// Up ...
	Up ApplicationGatewayBackendHealthServerHealth = "Up"
)

// PossibleApplicationGatewayBackendHealthServerHealthValues returns an array of possible values for the ApplicationGatewayBackendHealthServerHealth const type.
func PossibleApplicationGatewayBackendHealthServerHealthValues() []ApplicationGatewayBackendHealthServerHealth {
	return []ApplicationGatewayBackendHealthServerHealth{Down, Draining, Partial, Unknown, Up}
}

// ApplicationGatewayCookieBasedAffinity enumerates the values for application gateway cookie based affinity.
type ApplicationGatewayCookieBasedAffinity string

const (
	// Disabled ...
	Disabled ApplicationGatewayCookieBasedAffinity = "Disabled"
	// Enabled ...
	Enabled ApplicationGatewayCookieBasedAffinity = "Enabled"
)

// PossibleApplicationGatewayCookieBasedAffinityValues returns an array of possible values for the ApplicationGatewayCookieBasedAffinity const type.
func PossibleApplicationGatewayCookieBasedAffinityValues() []ApplicationGatewayCookieBasedAffinity {
	return []ApplicationGatewayCookieBasedAffinity{Disabled, Enabled}
}

// ApplicationGatewayFirewallMode enumerates the values for application gateway firewall mode.
type ApplicationGatewayFirewallMode string

const (
	// Detection ...
	Detection ApplicationGatewayFirewallMode = "Detection"
	// Prevention ...
	Prevention ApplicationGatewayFirewallMode = "Prevention"
)

// PossibleApplicationGatewayFirewallModeValues returns an array of possible values for the ApplicationGatewayFirewallMode const type.
func PossibleApplicationGatewayFirewallModeValues() []ApplicationGatewayFirewallMode {
	return []ApplicationGatewayFirewallMode{Detection, Prevention}
}

// ApplicationGatewayOperationalState enumerates the values for application gateway operational state.
type ApplicationGatewayOperationalState string

const (
	// Running ...
	Running ApplicationGatewayOperationalState = "Running"
	// Starting ...
	Starting ApplicationGatewayOperationalState = "Starting"
	// Stopped ...
	Stopped ApplicationGatewayOperationalState = "Stopped"
	// Stopping ...
	Stopping ApplicationGatewayOperationalState = "Stopping"
)

// PossibleApplicationGatewayOperationalStateValues returns an array of possible values for the ApplicationGatewayOperationalState const type.
func PossibleApplicationGatewayOperationalStateValues() []ApplicationGatewayOperationalState {
	return []ApplicationGatewayOperationalState{Running, Starting, Stopped, Stopping}
}

// ApplicationGatewayProtocol enumerates the values for application gateway protocol.
type ApplicationGatewayProtocol string

const (
	// HTTP ...
	HTTP ApplicationGatewayProtocol = "Http"
	// HTTPS ...
	HTTPS ApplicationGatewayProtocol = "Https"
)

// PossibleApplicationGatewayProtocolValues returns an array of possible values for the ApplicationGatewayProtocol const type.
func PossibleApplicationGatewayProtocolValues() []ApplicationGatewayProtocol {
	return []ApplicationGatewayProtocol{HTTP, HTTPS}
}

// ApplicationGatewayRequestRoutingRuleType enumerates the values for application gateway request routing rule
// type.
type ApplicationGatewayRequestRoutingRuleType string

const (
	// Basic ...
	Basic ApplicationGatewayRequestRoutingRuleType = "Basic"
	// PathBasedRouting ...
	PathBasedRouting ApplicationGatewayRequestRoutingRuleType = "PathBasedRouting"
)

// PossibleApplicationGatewayRequestRoutingRuleTypeValues returns an array of possible values for the ApplicationGatewayRequestRoutingRuleType const type.
func PossibleApplicationGatewayRequestRoutingRuleTypeValues() []ApplicationGatewayRequestRoutingRuleType {
	return []ApplicationGatewayRequestRoutingRuleType{Basic, PathBasedRouting}
}

// ApplicationGatewaySkuName enumerates the values for application gateway sku name.
type ApplicationGatewaySkuName string

const (
	// StandardLarge ...
	StandardLarge ApplicationGatewaySkuName = "Standard_Large"
	// StandardMedium ...
	StandardMedium ApplicationGatewaySkuName = "Standard_Medium"
	// StandardSmall ...
	StandardSmall ApplicationGatewaySkuName = "Standard_Small"
	// WAFLarge ...
	WAFLarge ApplicationGatewaySkuName = "WAF_Large"
	// WAFMedium ...
	WAFMedium ApplicationGatewaySkuName = "WAF_Medium"
)

// PossibleApplicationGatewaySkuNameValues returns an array of possible values for the ApplicationGatewaySkuName const type.
func PossibleApplicationGatewaySkuNameValues() []ApplicationGatewaySkuName {
	return []ApplicationGatewaySkuName{StandardLarge, StandardMedium, StandardSmall, WAFLarge, WAFMedium}
}

// ApplicationGatewaySslProtocol enumerates the values for application gateway ssl protocol.
type ApplicationGatewaySslProtocol string

const (
	// TLSv10 ...
	TLSv10 ApplicationGatewaySslProtocol = "TLSv1_0"
	// TLSv11 ...
	TLSv11 ApplicationGatewaySslProtocol = "TLSv1_1"
	// TLSv12 ...
	TLSv12 ApplicationGatewaySslProtocol = "TLSv1_2"
)

// PossibleApplicationGatewaySslProtocolValues returns an array of possible values for the ApplicationGatewaySslProtocol const type.
func PossibleApplicationGatewaySslProtocolValues() []ApplicationGatewaySslProtocol {
	return []ApplicationGatewaySslProtocol{TLSv10, TLSv11, TLSv12}
}

// ApplicationGatewayTier enumerates the values for application gateway tier.
type ApplicationGatewayTier string

const (
	// Standard ...
	Standard ApplicationGatewayTier = "Standard"
	// WAF ...
	WAF ApplicationGatewayTier = "WAF"
)

// PossibleApplicationGatewayTierValues returns an array of possible values for the ApplicationGatewayTier const type.
func PossibleApplicationGatewayTierValues() []ApplicationGatewayTier {
	return []ApplicationGatewayTier{Standard, WAF}
}

// AssociationType enumerates the values for association type.
type AssociationType string

const (
	// Associated ...
	Associated AssociationType = "Associated"
	// Contains ...
	Contains AssociationType = "Contains"
)

// PossibleAssociationTypeValues returns an array of possible values for the AssociationType const type.
func PossibleAssociationTypeValues() []AssociationType {
	return []AssociationType{Associated, Contains}
}

// AuthorizationUseStatus enumerates the values for authorization use status.
type AuthorizationUseStatus string

const (
	// Available ...
	Available AuthorizationUseStatus = "Available"
	// InUse ...
	InUse AuthorizationUseStatus = "InUse"
)

// PossibleAuthorizationUseStatusValues returns an array of possible values for the AuthorizationUseStatus const type.
func PossibleAuthorizationUseStatusValues() []AuthorizationUseStatus {
	return []AuthorizationUseStatus{Available, InUse}
}

// BgpPeerState enumerates the values for bgp peer state.
type BgpPeerState string

const (
	// BgpPeerStateConnected ...
	BgpPeerStateConnected BgpPeerState = "Connected"
	// BgpPeerStateConnecting ...
	BgpPeerStateConnecting BgpPeerState = "Connecting"
	// BgpPeerStateIdle ...
	BgpPeerStateIdle BgpPeerState = "Idle"
	// BgpPeerStateStopped ...
	BgpPeerStateStopped BgpPeerState = "Stopped"
	// BgpPeerStateUnknown ...
	BgpPeerStateUnknown BgpPeerState = "Unknown"
)

// PossibleBgpPeerStateValues returns an array of possible values for the BgpPeerState const type.
func PossibleBgpPeerStateValues() []BgpPeerState {
	return []BgpPeerState{BgpPeerStateConnected, BgpPeerStateConnecting, BgpPeerStateIdle, BgpPeerStateStopped, BgpPeerStateUnknown}
}

// ConnectionStatus enumerates the values for connection status.
type ConnectionStatus string

const (
	// ConnectionStatusConnected ...
	ConnectionStatusConnected ConnectionStatus = "Connected"
	// ConnectionStatusDegraded ...
	ConnectionStatusDegraded ConnectionStatus = "Degraded"
	// ConnectionStatusDisconnected ...
	ConnectionStatusDisconnected ConnectionStatus = "Disconnected"
	// ConnectionStatusUnknown ...
	ConnectionStatusUnknown ConnectionStatus = "Unknown"
)

// PossibleConnectionStatusValues returns an array of possible values for the ConnectionStatus const type.
func PossibleConnectionStatusValues() []ConnectionStatus {
	return []ConnectionStatus{ConnectionStatusConnected, ConnectionStatusDegraded, ConnectionStatusDisconnected, ConnectionStatusUnknown}
}

// DhGroup enumerates the values for dh group.
type DhGroup string

const (
	// DHGroup1 ...
	DHGroup1 DhGroup = "DHGroup1"
	// DHGroup14 ...
	DHGroup14 DhGroup = "DHGroup14"
	// DHGroup2 ...
	DHGroup2 DhGroup = "DHGroup2"
	// DHGroup2048 ...
	DHGroup2048 DhGroup = "DHGroup2048"
	// DHGroup24 ...
	DHGroup24 DhGroup = "DHGroup24"
	// ECP256 ...
	ECP256 DhGroup = "ECP256"
	// ECP384 ...
	ECP384 DhGroup = "ECP384"
	// None ...
	None DhGroup = "None"
)

// PossibleDhGroupValues returns an array of possible values for the DhGroup const type.
func PossibleDhGroupValues() []DhGroup {
	return []DhGroup{DHGroup1, DHGroup14, DHGroup2, DHGroup2048, DHGroup24, ECP256, ECP384, None}
}

// Direction enumerates the values for direction.
type Direction string

const (
	// Inbound ...
	Inbound Direction = "Inbound"
	// Outbound ...
	Outbound Direction = "Outbound"
)

// PossibleDirectionValues returns an array of possible values for the Direction const type.
func PossibleDirectionValues() []Direction {
	return []Direction{Inbound, Outbound}
}

// EffectiveRouteSource enumerates the values for effective route source.
type EffectiveRouteSource string

const (
	// EffectiveRouteSourceDefault ...
	EffectiveRouteSourceDefault EffectiveRouteSource = "Default"
	// EffectiveRouteSourceUnknown ...
	EffectiveRouteSourceUnknown EffectiveRouteSource = "Unknown"
	// EffectiveRouteSourceUser ...
	EffectiveRouteSourceUser EffectiveRouteSource = "User"
	// EffectiveRouteSourceVirtualNetworkGateway ...
	EffectiveRouteSourceVirtualNetworkGateway EffectiveRouteSource = "VirtualNetworkGateway"
)

// PossibleEffectiveRouteSourceValues returns an array of possible values for the EffectiveRouteSource const type.
func PossibleEffectiveRouteSourceValues() []EffectiveRouteSource {
	return []EffectiveRouteSource{EffectiveRouteSourceDefault, EffectiveRouteSourceUnknown, EffectiveRouteSourceUser, EffectiveRouteSourceVirtualNetworkGateway}
}

// EffectiveRouteState enumerates the values for effective route state.
type EffectiveRouteState string

const (
	// Active ...
	Active EffectiveRouteState = "Active"
	// Invalid ...
	Invalid EffectiveRouteState = "Invalid"
)

// PossibleEffectiveRouteStateValues returns an array of possible values for the EffectiveRouteState const type.
func PossibleEffectiveRouteStateValues() []EffectiveRouteState {
	return []EffectiveRouteState{Active, Invalid}
}

// ExpressRouteCircuitPeeringAdvertisedPublicPrefixState enumerates the values for express route circuit
// peering advertised public prefix state.
type ExpressRouteCircuitPeeringAdvertisedPublicPrefixState string

const (
	// Configured ...
	Configured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configured"
	// Configuring ...
	Configuring ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configuring"
	// NotConfigured ...
	NotConfigured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "NotConfigured"
	// ValidationNeeded ...
	ValidationNeeded ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "ValidationNeeded"
)

// PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues returns an array of possible values for the ExpressRouteCircuitPeeringAdvertisedPublicPrefixState const type.
func PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues() []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState {
	return []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState{Configured, Configuring, NotConfigured, ValidationNeeded}
}

// ExpressRouteCircuitPeeringState enumerates the values for express route circuit peering state.
type ExpressRouteCircuitPeeringState string

const (
	// ExpressRouteCircuitPeeringStateDisabled ...
	ExpressRouteCircuitPeeringStateDisabled ExpressRouteCircuitPeeringState = "Disabled"
	// ExpressRouteCircuitPeeringStateEnabled ...
	ExpressRouteCircuitPeeringStateEnabled ExpressRouteCircuitPeeringState = "Enabled"
)

// PossibleExpressRouteCircuitPeeringStateValues returns an array of possible values for the ExpressRouteCircuitPeeringState const type.
func PossibleExpressRouteCircuitPeeringStateValues() []ExpressRouteCircuitPeeringState {
	return []ExpressRouteCircuitPeeringState{ExpressRouteCircuitPeeringStateDisabled, ExpressRouteCircuitPeeringStateEnabled}
}

// ExpressRouteCircuitPeeringType enumerates the values for express route circuit peering type.
type ExpressRouteCircuitPeeringType string

const (
	// AzurePrivatePeering ...
	AzurePrivatePeering ExpressRouteCircuitPeeringType = "AzurePrivatePeering"
	// AzurePublicPeering ...
	AzurePublicPeering ExpressRouteCircuitPeeringType = "AzurePublicPeering"
	// MicrosoftPeering ...
	MicrosoftPeering ExpressRouteCircuitPeeringType = "MicrosoftPeering"
)

// PossibleExpressRouteCircuitPeeringTypeValues returns an array of possible values for the ExpressRouteCircuitPeeringType const type.
func PossibleExpressRouteCircuitPeeringTypeValues() []ExpressRouteCircuitPeeringType {
	return []ExpressRouteCircuitPeeringType{AzurePrivatePeering, AzurePublicPeering, MicrosoftPeering}
}

// ExpressRouteCircuitSkuFamily enumerates the values for express route circuit sku family.
type ExpressRouteCircuitSkuFamily string

const (
	// MeteredData ...
	MeteredData ExpressRouteCircuitSkuFamily = "MeteredData"
	// UnlimitedData ...
	UnlimitedData ExpressRouteCircuitSkuFamily = "UnlimitedData"
)

// PossibleExpressRouteCircuitSkuFamilyValues returns an array of possible values for the ExpressRouteCircuitSkuFamily const type.
func PossibleExpressRouteCircuitSkuFamilyValues() []ExpressRouteCircuitSkuFamily {
	return []ExpressRouteCircuitSkuFamily{MeteredData, UnlimitedData}
}

// ExpressRouteCircuitSkuTier enumerates the values for express route circuit sku tier.
type ExpressRouteCircuitSkuTier string

const (
	// ExpressRouteCircuitSkuTierPremium ...
	ExpressRouteCircuitSkuTierPremium ExpressRouteCircuitSkuTier = "Premium"
	// ExpressRouteCircuitSkuTierStandard ...
	ExpressRouteCircuitSkuTierStandard ExpressRouteCircuitSkuTier = "Standard"
)

// PossibleExpressRouteCircuitSkuTierValues returns an array of possible values for the ExpressRouteCircuitSkuTier const type.
func PossibleExpressRouteCircuitSkuTierValues() []ExpressRouteCircuitSkuTier {
	return []ExpressRouteCircuitSkuTier{ExpressRouteCircuitSkuTierPremium, ExpressRouteCircuitSkuTierStandard}
}

// IkeEncryption enumerates the values for ike encryption.
type IkeEncryption string

const (
	// AES128 ...
	AES128 IkeEncryption = "AES128"
	// AES192 ...
	AES192 IkeEncryption = "AES192"
	// AES256 ...
	AES256 IkeEncryption = "AES256"
	// DES ...
	DES IkeEncryption = "DES"
	// DES3 ...
	DES3 IkeEncryption = "DES3"
)

// PossibleIkeEncryptionValues returns an array of possible values for the IkeEncryption const type.
func PossibleIkeEncryptionValues() []IkeEncryption {
	return []IkeEncryption{AES128, AES192, AES256, DES, DES3}
}

// IkeIntegrity enumerates the values for ike integrity.
type IkeIntegrity string

const (
	// MD5 ...
	MD5 IkeIntegrity = "MD5"
	// SHA1 ...
	SHA1 IkeIntegrity = "SHA1"
	// SHA256 ...
	SHA256 IkeIntegrity = "SHA256"
	// SHA384 ...
	SHA384 IkeIntegrity = "SHA384"
)

// PossibleIkeIntegrityValues returns an array of possible values for the IkeIntegrity const type.
func PossibleIkeIntegrityValues() []IkeIntegrity {
	return []IkeIntegrity{MD5, SHA1, SHA256, SHA384}
}

// IPAllocationMethod enumerates the values for ip allocation method.
type IPAllocationMethod string

const (
	// Dynamic ...
	Dynamic IPAllocationMethod = "Dynamic"
	// Static ...
	Static IPAllocationMethod = "Static"
)

// PossibleIPAllocationMethodValues returns an array of possible values for the IPAllocationMethod const type.
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return []IPAllocationMethod{Dynamic, Static}
}

// IpsecEncryption enumerates the values for ipsec encryption.
type IpsecEncryption string

const (
	// IpsecEncryptionAES128 ...
	IpsecEncryptionAES128 IpsecEncryption = "AES128"
	// IpsecEncryptionAES192 ...
	IpsecEncryptionAES192 IpsecEncryption = "AES192"
	// IpsecEncryptionAES256 ...
	IpsecEncryptionAES256 IpsecEncryption = "AES256"
	// IpsecEncryptionDES ...
	IpsecEncryptionDES IpsecEncryption = "DES"
	// IpsecEncryptionDES3 ...
	IpsecEncryptionDES3 IpsecEncryption = "DES3"
	// IpsecEncryptionGCMAES128 ...
	IpsecEncryptionGCMAES128 IpsecEncryption = "GCMAES128"
	// IpsecEncryptionGCMAES192 ...
	IpsecEncryptionGCMAES192 IpsecEncryption = "GCMAES192"
	// IpsecEncryptionGCMAES256 ...
	IpsecEncryptionGCMAES256 IpsecEncryption = "GCMAES256"
	// IpsecEncryptionNone ...
	IpsecEncryptionNone IpsecEncryption = "None"
)

// PossibleIpsecEncryptionValues returns an array of possible values for the IpsecEncryption const type.
func PossibleIpsecEncryptionValues() []IpsecEncryption {
	return []IpsecEncryption{IpsecEncryptionAES128, IpsecEncryptionAES192, IpsecEncryptionAES256, IpsecEncryptionDES, IpsecEncryptionDES3, IpsecEncryptionGCMAES128, IpsecEncryptionGCMAES192, IpsecEncryptionGCMAES256, IpsecEncryptionNone}
}

// IpsecIntegrity enumerates the values for ipsec integrity.
type IpsecIntegrity string

const (
	// IpsecIntegrityGCMAES128 ...
	IpsecIntegrityGCMAES128 IpsecIntegrity = "GCMAES128"
	// IpsecIntegrityGCMAES192 ...
	IpsecIntegrityGCMAES192 IpsecIntegrity = "GCMAES192"
	// IpsecIntegrityGCMAES256 ...
	IpsecIntegrityGCMAES256 IpsecIntegrity = "GCMAES256"
	// IpsecIntegrityMD5 ...
	IpsecIntegrityMD5 IpsecIntegrity = "MD5"
	// IpsecIntegritySHA1 ...
	IpsecIntegritySHA1 IpsecIntegrity = "SHA1"
	// IpsecIntegritySHA256 ...
	IpsecIntegritySHA256 IpsecIntegrity = "SHA256"
)

// PossibleIpsecIntegrityValues returns an array of possible values for the IpsecIntegrity const type.
func PossibleIpsecIntegrityValues() []IpsecIntegrity {
	return []IpsecIntegrity{IpsecIntegrityGCMAES128, IpsecIntegrityGCMAES192, IpsecIntegrityGCMAES256, IpsecIntegrityMD5, IpsecIntegritySHA1, IpsecIntegritySHA256}
}

// IPVersion enumerates the values for ip version.
type IPVersion string

const (
	// IPv4 ...
	IPv4 IPVersion = "IPv4"
	// IPv6 ...
	IPv6 IPVersion = "IPv6"
)

// PossibleIPVersionValues returns an array of possible values for the IPVersion const type.
func PossibleIPVersionValues() []IPVersion {
	return []IPVersion{IPv4, IPv6}
}

// IssueType enumerates the values for issue type.
type IssueType string

const (
	// IssueTypeAgentStopped ...
	IssueTypeAgentStopped IssueType = "AgentStopped"
	// IssueTypeDNSResolution ...
	IssueTypeDNSResolution IssueType = "DnsResolution"
	// IssueTypeGuestFirewall ...
	IssueTypeGuestFirewall IssueType = "GuestFirewall"
	// IssueTypeNetworkSecurityRule ...
	IssueTypeNetworkSecurityRule IssueType = "NetworkSecurityRule"
	// IssueTypePlatform ...
	IssueTypePlatform IssueType = "Platform"
	// IssueTypePortThrottled ...
	IssueTypePortThrottled IssueType = "PortThrottled"
	// IssueTypeSocketBind ...
	IssueTypeSocketBind IssueType = "SocketBind"
	// IssueTypeUnknown ...
	IssueTypeUnknown IssueType = "Unknown"
	// IssueTypeUserDefinedRoute ...
	IssueTypeUserDefinedRoute IssueType = "UserDefinedRoute"
)

// PossibleIssueTypeValues returns an array of possible values for the IssueType const type.
func PossibleIssueTypeValues() []IssueType {
	return []IssueType{IssueTypeAgentStopped, IssueTypeDNSResolution, IssueTypeGuestFirewall, IssueTypeNetworkSecurityRule, IssueTypePlatform, IssueTypePortThrottled, IssueTypeSocketBind, IssueTypeUnknown, IssueTypeUserDefinedRoute}
}

// LoadDistribution enumerates the values for load distribution.
type LoadDistribution string

const (
	// Default ...
	Default LoadDistribution = "Default"
	// SourceIP ...
	SourceIP LoadDistribution = "SourceIP"
	// SourceIPProtocol ...
	SourceIPProtocol LoadDistribution = "SourceIPProtocol"
)

// PossibleLoadDistributionValues returns an array of possible values for the LoadDistribution const type.
func PossibleLoadDistributionValues() []LoadDistribution {
	return []LoadDistribution{Default, SourceIP, SourceIPProtocol}
}

// NextHopType enumerates the values for next hop type.
type NextHopType string

const (
	// NextHopTypeHyperNetGateway ...
	NextHopTypeHyperNetGateway NextHopType = "HyperNetGateway"
	// NextHopTypeInternet ...
	NextHopTypeInternet NextHopType = "Internet"
	// NextHopTypeNone ...
	NextHopTypeNone NextHopType = "None"
	// NextHopTypeVirtualAppliance ...
	NextHopTypeVirtualAppliance NextHopType = "VirtualAppliance"
	// NextHopTypeVirtualNetworkGateway ...
	NextHopTypeVirtualNetworkGateway NextHopType = "VirtualNetworkGateway"
	// NextHopTypeVnetLocal ...
	NextHopTypeVnetLocal NextHopType = "VnetLocal"
)

// PossibleNextHopTypeValues returns an array of possible values for the NextHopType const type.
func PossibleNextHopTypeValues() []NextHopType {
	return []NextHopType{NextHopTypeHyperNetGateway, NextHopTypeInternet, NextHopTypeNone, NextHopTypeVirtualAppliance, NextHopTypeVirtualNetworkGateway, NextHopTypeVnetLocal}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// Failed ...
	Failed OperationStatus = "Failed"
	// InProgress ...
	InProgress OperationStatus = "InProgress"
	// Succeeded ...
	Succeeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{Failed, InProgress, Succeeded}
}

// Origin enumerates the values for origin.
type Origin string

const (
	// OriginInbound ...
	OriginInbound Origin = "Inbound"
	// OriginLocal ...
	OriginLocal Origin = "Local"
	// OriginOutbound ...
	OriginOutbound Origin = "Outbound"
)

// PossibleOriginValues returns an array of possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{OriginInbound, OriginLocal, OriginOutbound}
}

// PcError enumerates the values for pc error.
type PcError string

const (
	// AgentStopped ...
	AgentStopped PcError = "AgentStopped"
	// CaptureFailed ...
	CaptureFailed PcError = "CaptureFailed"
	// InternalError ...
	InternalError PcError = "InternalError"
	// LocalFileFailed ...
	LocalFileFailed PcError = "LocalFileFailed"
	// StorageFailed ...
	StorageFailed PcError = "StorageFailed"
)

// PossiblePcErrorValues returns an array of possible values for the PcError const type.
func PossiblePcErrorValues() []PcError {
	return []PcError{AgentStopped, CaptureFailed, InternalError, LocalFileFailed, StorageFailed}
}

// PcProtocol enumerates the values for pc protocol.
type PcProtocol string

const (
	// Any ...
	Any PcProtocol = "Any"
	// TCP ...
	TCP PcProtocol = "TCP"
	// UDP ...
	UDP PcProtocol = "UDP"
)

// PossiblePcProtocolValues returns an array of possible values for the PcProtocol const type.
func PossiblePcProtocolValues() []PcProtocol {
	return []PcProtocol{Any, TCP, UDP}
}

// PcStatus enumerates the values for pc status.
type PcStatus string

const (
	// PcStatusError ...
	PcStatusError PcStatus = "Error"
	// PcStatusNotStarted ...
	PcStatusNotStarted PcStatus = "NotStarted"
	// PcStatusRunning ...
	PcStatusRunning PcStatus = "Running"
	// PcStatusStopped ...
	PcStatusStopped PcStatus = "Stopped"
	// PcStatusUnknown ...
	PcStatusUnknown PcStatus = "Unknown"
)

// PossiblePcStatusValues returns an array of possible values for the PcStatus const type.
func PossiblePcStatusValues() []PcStatus {
	return []PcStatus{PcStatusError, PcStatusNotStarted, PcStatusRunning, PcStatusStopped, PcStatusUnknown}
}

// PfsGroup enumerates the values for pfs group.
type PfsGroup string

const (
	// PfsGroupECP256 ...
	PfsGroupECP256 PfsGroup = "ECP256"
	// PfsGroupECP384 ...
	PfsGroupECP384 PfsGroup = "ECP384"
	// PfsGroupNone ...
	PfsGroupNone PfsGroup = "None"
	// PfsGroupPFS1 ...
	PfsGroupPFS1 PfsGroup = "PFS1"
	// PfsGroupPFS2 ...
	PfsGroupPFS2 PfsGroup = "PFS2"
	// PfsGroupPFS2048 ...
	PfsGroupPFS2048 PfsGroup = "PFS2048"
	// PfsGroupPFS24 ...
	PfsGroupPFS24 PfsGroup = "PFS24"
)

// PossiblePfsGroupValues returns an array of possible values for the PfsGroup const type.
func PossiblePfsGroupValues() []PfsGroup {
	return []PfsGroup{PfsGroupECP256, PfsGroupECP384, PfsGroupNone, PfsGroupPFS1, PfsGroupPFS2, PfsGroupPFS2048, PfsGroupPFS24}
}

// ProbeProtocol enumerates the values for probe protocol.
type ProbeProtocol string

const (
	// ProbeProtocolHTTP ...
	ProbeProtocolHTTP ProbeProtocol = "Http"
	// ProbeProtocolTCP ...
	ProbeProtocolTCP ProbeProtocol = "Tcp"
)

// PossibleProbeProtocolValues returns an array of possible values for the ProbeProtocol const type.
func PossibleProbeProtocolValues() []ProbeProtocol {
	return []ProbeProtocol{ProbeProtocolHTTP, ProbeProtocolTCP}
}

// ProcessorArchitecture enumerates the values for processor architecture.
type ProcessorArchitecture string

const (
	// Amd64 ...
	Amd64 ProcessorArchitecture = "Amd64"
	// X86 ...
	X86 ProcessorArchitecture = "X86"
)

// PossibleProcessorArchitectureValues returns an array of possible values for the ProcessorArchitecture const type.
func PossibleProcessorArchitectureValues() []ProcessorArchitecture {
	return []ProcessorArchitecture{Amd64, X86}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// ProtocolTCP ...
	ProtocolTCP Protocol = "TCP"
	// ProtocolUDP ...
	ProtocolUDP Protocol = "UDP"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{ProtocolTCP, ProtocolUDP}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// RouteNextHopType enumerates the values for route next hop type.
type RouteNextHopType string

const (
	// RouteNextHopTypeInternet ...
	RouteNextHopTypeInternet RouteNextHopType = "Internet"
	// RouteNextHopTypeNone ...
	RouteNextHopTypeNone RouteNextHopType = "None"
	// RouteNextHopTypeVirtualAppliance ...
	RouteNextHopTypeVirtualAppliance RouteNextHopType = "VirtualAppliance"
	// RouteNextHopTypeVirtualNetworkGateway ...
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = "VirtualNetworkGateway"
	// RouteNextHopTypeVnetLocal ...
	RouteNextHopTypeVnetLocal RouteNextHopType = "VnetLocal"
)

// PossibleRouteNextHopTypeValues returns an array of possible values for the RouteNextHopType const type.
func PossibleRouteNextHopTypeValues() []RouteNextHopType {
	return []RouteNextHopType{RouteNextHopTypeInternet, RouteNextHopTypeNone, RouteNextHopTypeVirtualAppliance, RouteNextHopTypeVirtualNetworkGateway, RouteNextHopTypeVnetLocal}
}

// SecurityRuleAccess enumerates the values for security rule access.
type SecurityRuleAccess string

const (
	// SecurityRuleAccessAllow ...
	SecurityRuleAccessAllow SecurityRuleAccess = "Allow"
	// SecurityRuleAccessDeny ...
	SecurityRuleAccessDeny SecurityRuleAccess = "Deny"
)

// PossibleSecurityRuleAccessValues returns an array of possible values for the SecurityRuleAccess const type.
func PossibleSecurityRuleAccessValues() []SecurityRuleAccess {
	return []SecurityRuleAccess{SecurityRuleAccessAllow, SecurityRuleAccessDeny}
}

// SecurityRuleDirection enumerates the values for security rule direction.
type SecurityRuleDirection string

const (
	// SecurityRuleDirectionInbound ...
	SecurityRuleDirectionInbound SecurityRuleDirection = "Inbound"
	// SecurityRuleDirectionOutbound ...
	SecurityRuleDirectionOutbound SecurityRuleDirection = "Outbound"
)

// PossibleSecurityRuleDirectionValues returns an array of possible values for the SecurityRuleDirection const type.
func PossibleSecurityRuleDirectionValues() []SecurityRuleDirection {
	return []SecurityRuleDirection{SecurityRuleDirectionInbound, SecurityRuleDirectionOutbound}
}

// SecurityRuleProtocol enumerates the values for security rule protocol.
type SecurityRuleProtocol string

const (
	// SecurityRuleProtocolAsterisk ...
	SecurityRuleProtocolAsterisk SecurityRuleProtocol = "*"
	// SecurityRuleProtocolTCP ...
	SecurityRuleProtocolTCP SecurityRuleProtocol = "Tcp"
	// SecurityRuleProtocolUDP ...
	SecurityRuleProtocolUDP SecurityRuleProtocol = "Udp"
)

// PossibleSecurityRuleProtocolValues returns an array of possible values for the SecurityRuleProtocol const type.
func PossibleSecurityRuleProtocolValues() []SecurityRuleProtocol {
	return []SecurityRuleProtocol{SecurityRuleProtocolAsterisk, SecurityRuleProtocolTCP, SecurityRuleProtocolUDP}
}

// ServiceProviderProvisioningState enumerates the values for service provider provisioning state.
type ServiceProviderProvisioningState string

const (
	// Deprovisioning ...
	Deprovisioning ServiceProviderProvisioningState = "Deprovisioning"
	// NotProvisioned ...
	NotProvisioned ServiceProviderProvisioningState = "NotProvisioned"
	// Provisioned ...
	Provisioned ServiceProviderProvisioningState = "Provisioned"
	// Provisioning ...
	Provisioning ServiceProviderProvisioningState = "Provisioning"
)

// PossibleServiceProviderProvisioningStateValues returns an array of possible values for the ServiceProviderProvisioningState const type.
func PossibleServiceProviderProvisioningStateValues() []ServiceProviderProvisioningState {
	return []ServiceProviderProvisioningState{Deprovisioning, NotProvisioned, Provisioned, Provisioning}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityError ...
	SeverityError Severity = "Error"
	// SeverityWarning ...
	SeverityWarning Severity = "Warning"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityError, SeverityWarning}
}

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TransportProtocolTCP ...
	TransportProtocolTCP TransportProtocol = "Tcp"
	// TransportProtocolUDP ...
	TransportProtocolUDP TransportProtocol = "Udp"
)

// PossibleTransportProtocolValues returns an array of possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{TransportProtocolTCP, TransportProtocolUDP}
}

// VirtualNetworkGatewayConnectionStatus enumerates the values for virtual network gateway connection status.
type VirtualNetworkGatewayConnectionStatus string

const (
	// VirtualNetworkGatewayConnectionStatusConnected ...
	VirtualNetworkGatewayConnectionStatusConnected VirtualNetworkGatewayConnectionStatus = "Connected"
	// VirtualNetworkGatewayConnectionStatusConnecting ...
	VirtualNetworkGatewayConnectionStatusConnecting VirtualNetworkGatewayConnectionStatus = "Connecting"
	// VirtualNetworkGatewayConnectionStatusNotConnected ...
	VirtualNetworkGatewayConnectionStatusNotConnected VirtualNetworkGatewayConnectionStatus = "NotConnected"
	// VirtualNetworkGatewayConnectionStatusUnknown ...
	VirtualNetworkGatewayConnectionStatusUnknown VirtualNetworkGatewayConnectionStatus = "Unknown"
)

// PossibleVirtualNetworkGatewayConnectionStatusValues returns an array of possible values for the VirtualNetworkGatewayConnectionStatus const type.
func PossibleVirtualNetworkGatewayConnectionStatusValues() []VirtualNetworkGatewayConnectionStatus {
	return []VirtualNetworkGatewayConnectionStatus{VirtualNetworkGatewayConnectionStatusConnected, VirtualNetworkGatewayConnectionStatusConnecting, VirtualNetworkGatewayConnectionStatusNotConnected, VirtualNetworkGatewayConnectionStatusUnknown}
}

// VirtualNetworkGatewayConnectionType enumerates the values for virtual network gateway connection type.
type VirtualNetworkGatewayConnectionType string

const (
	// ExpressRoute ...
	ExpressRoute VirtualNetworkGatewayConnectionType = "ExpressRoute"
	// IPsec ...
	IPsec VirtualNetworkGatewayConnectionType = "IPsec"
	// Vnet2Vnet ...
	Vnet2Vnet VirtualNetworkGatewayConnectionType = "Vnet2Vnet"
	// VPNClient ...
	VPNClient VirtualNetworkGatewayConnectionType = "VPNClient"
)

// PossibleVirtualNetworkGatewayConnectionTypeValues returns an array of possible values for the VirtualNetworkGatewayConnectionType const type.
func PossibleVirtualNetworkGatewayConnectionTypeValues() []VirtualNetworkGatewayConnectionType {
	return []VirtualNetworkGatewayConnectionType{ExpressRoute, IPsec, Vnet2Vnet, VPNClient}
}

// VirtualNetworkGatewaySkuName enumerates the values for virtual network gateway sku name.
type VirtualNetworkGatewaySkuName string

const (
	// VirtualNetworkGatewaySkuNameBasic ...
	VirtualNetworkGatewaySkuNameBasic VirtualNetworkGatewaySkuName = "Basic"
	// VirtualNetworkGatewaySkuNameHighPerformance ...
	VirtualNetworkGatewaySkuNameHighPerformance VirtualNetworkGatewaySkuName = "HighPerformance"
	// VirtualNetworkGatewaySkuNameStandard ...
	VirtualNetworkGatewaySkuNameStandard VirtualNetworkGatewaySkuName = "Standard"
	// VirtualNetworkGatewaySkuNameUltraPerformance ...
	VirtualNetworkGatewaySkuNameUltraPerformance VirtualNetworkGatewaySkuName = "UltraPerformance"
	// VirtualNetworkGatewaySkuNameVpnGw1 ...
	VirtualNetworkGatewaySkuNameVpnGw1 VirtualNetworkGatewaySkuName = "VpnGw1"
	// VirtualNetworkGatewaySkuNameVpnGw2 ...
	VirtualNetworkGatewaySkuNameVpnGw2 VirtualNetworkGatewaySkuName = "VpnGw2"
	// VirtualNetworkGatewaySkuNameVpnGw3 ...
	VirtualNetworkGatewaySkuNameVpnGw3 VirtualNetworkGatewaySkuName = "VpnGw3"
)

// PossibleVirtualNetworkGatewaySkuNameValues returns an array of possible values for the VirtualNetworkGatewaySkuName const type.
func PossibleVirtualNetworkGatewaySkuNameValues() []VirtualNetworkGatewaySkuName {
	return []VirtualNetworkGatewaySkuName{VirtualNetworkGatewaySkuNameBasic, VirtualNetworkGatewaySkuNameHighPerformance, VirtualNetworkGatewaySkuNameStandard, VirtualNetworkGatewaySkuNameUltraPerformance, VirtualNetworkGatewaySkuNameVpnGw1, VirtualNetworkGatewaySkuNameVpnGw2, VirtualNetworkGatewaySkuNameVpnGw3}
}

// VirtualNetworkGatewaySkuTier enumerates the values for virtual network gateway sku tier.
type VirtualNetworkGatewaySkuTier string

const (
	// VirtualNetworkGatewaySkuTierBasic ...
	VirtualNetworkGatewaySkuTierBasic VirtualNetworkGatewaySkuTier = "Basic"
	// VirtualNetworkGatewaySkuTierHighPerformance ...
	VirtualNetworkGatewaySkuTierHighPerformance VirtualNetworkGatewaySkuTier = "HighPerformance"
	// VirtualNetworkGatewaySkuTierStandard ...
	VirtualNetworkGatewaySkuTierStandard VirtualNetworkGatewaySkuTier = "Standard"
	// VirtualNetworkGatewaySkuTierUltraPerformance ...
	VirtualNetworkGatewaySkuTierUltraPerformance VirtualNetworkGatewaySkuTier = "UltraPerformance"
	// VirtualNetworkGatewaySkuTierVpnGw1 ...
	VirtualNetworkGatewaySkuTierVpnGw1 VirtualNetworkGatewaySkuTier = "VpnGw1"
	// VirtualNetworkGatewaySkuTierVpnGw2 ...
	VirtualNetworkGatewaySkuTierVpnGw2 VirtualNetworkGatewaySkuTier = "VpnGw2"
	// VirtualNetworkGatewaySkuTierVpnGw3 ...
	VirtualNetworkGatewaySkuTierVpnGw3 VirtualNetworkGatewaySkuTier = "VpnGw3"
)

// PossibleVirtualNetworkGatewaySkuTierValues returns an array of possible values for the VirtualNetworkGatewaySkuTier const type.
func PossibleVirtualNetworkGatewaySkuTierValues() []VirtualNetworkGatewaySkuTier {
	return []VirtualNetworkGatewaySkuTier{VirtualNetworkGatewaySkuTierBasic, VirtualNetworkGatewaySkuTierHighPerformance, VirtualNetworkGatewaySkuTierStandard, VirtualNetworkGatewaySkuTierUltraPerformance, VirtualNetworkGatewaySkuTierVpnGw1, VirtualNetworkGatewaySkuTierVpnGw2, VirtualNetworkGatewaySkuTierVpnGw3}
}

// VirtualNetworkGatewayType enumerates the values for virtual network gateway type.
type VirtualNetworkGatewayType string

const (
	// VirtualNetworkGatewayTypeExpressRoute ...
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = "ExpressRoute"
	// VirtualNetworkGatewayTypeVpn ...
	VirtualNetworkGatewayTypeVpn VirtualNetworkGatewayType = "Vpn"
)

// PossibleVirtualNetworkGatewayTypeValues returns an array of possible values for the VirtualNetworkGatewayType const type.
func PossibleVirtualNetworkGatewayTypeValues() []VirtualNetworkGatewayType {
	return []VirtualNetworkGatewayType{VirtualNetworkGatewayTypeExpressRoute, VirtualNetworkGatewayTypeVpn}
}

// VirtualNetworkPeeringState enumerates the values for virtual network peering state.
type VirtualNetworkPeeringState string

const (
	// Connected ...
	Connected VirtualNetworkPeeringState = "Connected"
	// Disconnected ...
	Disconnected VirtualNetworkPeeringState = "Disconnected"
	// Initiated ...
	Initiated VirtualNetworkPeeringState = "Initiated"
)

// PossibleVirtualNetworkPeeringStateValues returns an array of possible values for the VirtualNetworkPeeringState const type.
func PossibleVirtualNetworkPeeringStateValues() []VirtualNetworkPeeringState {
	return []VirtualNetworkPeeringState{Connected, Disconnected, Initiated}
}

// VpnType enumerates the values for vpn type.
type VpnType string

const (
	// PolicyBased ...
	PolicyBased VpnType = "PolicyBased"
	// RouteBased ...
	RouteBased VpnType = "RouteBased"
)

// PossibleVpnTypeValues returns an array of possible values for the VpnType const type.
func PossibleVpnTypeValues() []VpnType {
	return []VpnType{PolicyBased, RouteBased}
}

// AddressSpace addressSpace contains an array of IP address ranges that can be used by subnets of the virtual
// network.
type AddressSpace struct {
	// AddressPrefixes - A list of address blocks reserved for this virtual network in CIDR notation.
	AddressPrefixes *[]string `json:"addressPrefixes,omitempty"`
}

// ApplicationGateway application gateway resource
type ApplicationGateway struct {
	autorest.Response                   `json:"-"`
	*ApplicationGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationGateway.
func (ag ApplicationGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ag.ApplicationGatewayPropertiesFormat != nil {
		objectMap["properties"] = ag.ApplicationGatewayPropertiesFormat
	}
	if ag.Etag != nil {
		objectMap["etag"] = ag.Etag
	}
	if ag.ID != nil {
		objectMap["id"] = ag.ID
	}
	if ag.Name != nil {
		objectMap["name"] = ag.Name
	}
	if ag.Type != nil {
		objectMap["type"] = ag.Type
	}
	if ag.Location != nil {
		objectMap["location"] = ag.Location
	}
	if ag.Tags != nil {
		objectMap["tags"] = ag.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGateway struct.
func (ag *ApplicationGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPropertiesFormat ApplicationGatewayPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				ag.ApplicationGatewayPropertiesFormat = &applicationGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ag.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ag.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ag.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ag.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ag.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ag.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationGatewayAuthenticationCertificate authentication certificates of an application gateway.
type ApplicationGatewayAuthenticationCertificate struct {
	*ApplicationGatewayAuthenticationCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayAuthenticationCertificate.
func (agac ApplicationGatewayAuthenticationCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agac.ApplicationGatewayAuthenticationCertificatePropertiesFormat != nil {
		objectMap["properties"] = agac.ApplicationGatewayAuthenticationCertificatePropertiesFormat
	}
	if agac.Name != nil {
		objectMap["name"] = agac.Name
	}
	if agac.Etag != nil {
		objectMap["etag"] = agac.Etag
	}
	if agac.ID != nil {
		objectMap["id"] = agac.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayAuthenticationCertificate struct.
func (agac *ApplicationGatewayAuthenticationCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayAuthenticationCertificatePropertiesFormat ApplicationGatewayAuthenticationCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayAuthenticationCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agac.ApplicationGatewayAuthenticationCertificatePropertiesFormat = &applicationGatewayAuthenticationCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agac.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agac.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agac.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayAuthenticationCertificatePropertiesFormat authentication certificates properties of an
// application gateway.
type ApplicationGatewayAuthenticationCertificatePropertiesFormat struct {
	// Data - Certificate public data.
	Data *string `json:"data,omitempty"`
	// ProvisioningState - Provisioning state of the authentication certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayAvailableWafRuleSetsResult response for ApplicationGatewayAvailableWafRuleSets API service
// call.
type ApplicationGatewayAvailableWafRuleSetsResult struct {
	autorest.Response `json:"-"`
	// Value - The list of application gateway rule sets.
	Value *[]ApplicationGatewayFirewallRuleSet `json:"value,omitempty"`
}

// ApplicationGatewayBackendAddress backend address of an application gateway.
type ApplicationGatewayBackendAddress struct {
	// Fqdn - Fully qualified domain name (FQDN).
	Fqdn *string `json:"fqdn,omitempty"`
	// IPAddress - IP address
	IPAddress *string `json:"ipAddress,omitempty"`
}

// ApplicationGatewayBackendAddressPool backend Address Pool of an application gateway.
type ApplicationGatewayBackendAddressPool struct {
	*ApplicationGatewayBackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - Resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendAddressPool.
func (agbap ApplicationGatewayBackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat != nil {
		objectMap["properties"] = agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat
	}
	if agbap.Name != nil {
		objectMap["name"] = agbap.Name
	}
	if agbap.Etag != nil {
		objectMap["etag"] = agbap.Etag
	}
	if agbap.ID != nil {
		objectMap["id"] = agbap.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendAddressPool struct.
func (agbap *ApplicationGatewayBackendAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendAddressPoolPropertiesFormat ApplicationGatewayBackendAddressPoolPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendAddressPoolPropertiesFormat)
				if err != nil {
					return err
				}
				agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat = &applicationGatewayBackendAddressPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbap.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbap.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbap.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayBackendAddressPoolPropertiesFormat properties of Backend Address Pool of an application
// gateway.
type ApplicationGatewayBackendAddressPoolPropertiesFormat struct {
	// BackendIPConfigurations - Collection of references to IPs defined in network interfaces.
	BackendIPConfigurations *[]InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`
	// BackendAddresses - Backend addresses
	BackendAddresses *[]ApplicationGatewayBackendAddress `json:"backendAddresses,omitempty"`
	// ProvisioningState - Provisioning state of the backend address pool resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayBackendHealth list of ApplicationGatewayBackendHealthPool resources.
type ApplicationGatewayBackendHealth struct {
	autorest.Response   `json:"-"`
	BackendAddressPools *[]ApplicationGatewayBackendHealthPool `json:"backendAddressPools,omitempty"`
}

// ApplicationGatewayBackendHealthHTTPSettings application gateway BackendHealthHttp settings.
type ApplicationGatewayBackendHealthHTTPSettings struct {
	// BackendHTTPSettings - Reference of an ApplicationGatewayBackendHttpSettings resource.
	BackendHTTPSettings *ApplicationGatewayBackendHTTPSettings `json:"backendHttpSettings,omitempty"`
	// Servers - List of ApplicationGatewayBackendHealthServer resources.
	Servers *[]ApplicationGatewayBackendHealthServer `json:"servers,omitempty"`
}

// ApplicationGatewayBackendHealthPool application gateway BackendHealth pool.
type ApplicationGatewayBackendHealthPool struct {
	// BackendAddressPool - Reference of an ApplicationGatewayBackendAddressPool resource.
	BackendAddressPool *ApplicationGatewayBackendAddressPool `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettingsCollection - List of ApplicationGatewayBackendHealthHttpSettings resources.
	BackendHTTPSettingsCollection *[]ApplicationGatewayBackendHealthHTTPSettings `json:"backendHttpSettingsCollection,omitempty"`
}

// ApplicationGatewayBackendHealthServer application gateway backendhealth http settings.
type ApplicationGatewayBackendHealthServer struct {
	// Address - IP address or FQDN of backend server.
	Address *string `json:"address,omitempty"`
	// IPConfiguration - Reference of IP configuration of backend server.
	IPConfiguration *SubResource `json:"ipConfiguration,omitempty"`
	// Health - Health of backend server. Possible values include: 'Unknown', 'Up', 'Down', 'Partial', 'Draining'
	Health ApplicationGatewayBackendHealthServerHealth `json:"health,omitempty"`
}

// ApplicationGatewayBackendHTTPSettings backend address pool settings of an application gateway.
type ApplicationGatewayBackendHTTPSettings struct {
	*ApplicationGatewayBackendHTTPSettingsPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendHTTPSettings.
func (agbhs ApplicationGatewayBackendHTTPSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat != nil {
		objectMap["properties"] = agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat
	}
	if agbhs.Name != nil {
		objectMap["name"] = agbhs.Name
	}
	if agbhs.Etag != nil {
		objectMap["etag"] = agbhs.Etag
	}
	if agbhs.ID != nil {
		objectMap["id"] = agbhs.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendHTTPSettings struct.
func (agbhs *ApplicationGatewayBackendHTTPSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendHTTPSettingsPropertiesFormat ApplicationGatewayBackendHTTPSettingsPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendHTTPSettingsPropertiesFormat)
				if err != nil {
					return err
				}
				agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat = &applicationGatewayBackendHTTPSettingsPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbhs.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbhs.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbhs.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayBackendHTTPSettingsPropertiesFormat properties of Backend address pool settings of an
// application gateway.
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat struct {
	// Port - Port
	Port *int32 `json:"port,omitempty"`
	// Protocol - Protocol. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// CookieBasedAffinity - Cookie based affinity. Possible values include: 'Enabled', 'Disabled'
	CookieBasedAffinity ApplicationGatewayCookieBasedAffinity `json:"cookieBasedAffinity,omitempty"`
	// RequestTimeout - Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
	RequestTimeout *int32 `json:"requestTimeout,omitempty"`
	// Probe - Probe resource of an application gateway.
	Probe *SubResource `json:"probe,omitempty"`
	// AuthenticationCertificates - Array of references to application gateway authentication certificates.
	AuthenticationCertificates *[]SubResource `json:"authenticationCertificates,omitempty"`
	// ProvisioningState - Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ConnectionDraining - Connection draining of the backend http settings resource.
	ConnectionDraining *ApplicationGatewayConnectionDraining `json:"connectionDraining,omitempty"`
}

// ApplicationGatewayConnectionDraining connection draining allows open connections to a backend server to be
// active for a specified time after the backend server got removed from the configuration.
type ApplicationGatewayConnectionDraining struct {
	// Enabled - Whether connection draining is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// DrainTimeoutInSec - The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
	DrainTimeoutInSec *int32 `json:"drainTimeoutInSec,omitempty"`
}

// ApplicationGatewayFirewallDisabledRuleGroup allows to disable rules within a rule group or an entire rule group.
type ApplicationGatewayFirewallDisabledRuleGroup struct {
	// RuleGroupName - The name of the rule group that will be disabled.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`
	// Rules - The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
	Rules *[]int32 `json:"rules,omitempty"`
}

// ApplicationGatewayFirewallRule a web application firewall rule.
type ApplicationGatewayFirewallRule struct {
	// RuleID - The identifier of the web application firewall rule.
	RuleID *int32 `json:"ruleId,omitempty"`
	// Description - The description of the web application firewall rule.
	Description *string `json:"description,omitempty"`
}

// ApplicationGatewayFirewallRuleGroup a web application firewall rule group.
type ApplicationGatewayFirewallRuleGroup struct {
	// RuleGroupName - The name of the web application firewall rule group.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`
	// Description - The description of the web application firewall rule group.
	Description *string `json:"description,omitempty"`
	// Rules - The rules of the web application firewall rule group.
	Rules *[]ApplicationGatewayFirewallRule `json:"rules,omitempty"`
}

// ApplicationGatewayFirewallRuleSet a web application firewall rule set.
type ApplicationGatewayFirewallRuleSet struct {
	*ApplicationGatewayFirewallRuleSetPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFirewallRuleSet.
func (agfrs ApplicationGatewayFirewallRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfrs.ApplicationGatewayFirewallRuleSetPropertiesFormat != nil {
		objectMap["properties"] = agfrs.ApplicationGatewayFirewallRuleSetPropertiesFormat
	}
	if agfrs.ID != nil {
		objectMap["id"] = agfrs.ID
	}
	if agfrs.Name != nil {
		objectMap["name"] = agfrs.Name
	}
	if agfrs.Type != nil {
		objectMap["type"] = agfrs.Type
	}
	if agfrs.Location != nil {
		objectMap["location"] = agfrs.Location
	}
	if agfrs.Tags != nil {
		objectMap["tags"] = agfrs.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFirewallRuleSet struct.
func (agfrs *ApplicationGatewayFirewallRuleSet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFirewallRuleSetPropertiesFormat ApplicationGatewayFirewallRuleSetPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFirewallRuleSetPropertiesFormat)
				if err != nil {
					return err
				}
				agfrs.ApplicationGatewayFirewallRuleSetPropertiesFormat = &applicationGatewayFirewallRuleSetPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfrs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfrs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agfrs.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				agfrs.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agfrs.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationGatewayFirewallRuleSetPropertiesFormat properties of the web application firewall rule set.
type ApplicationGatewayFirewallRuleSetPropertiesFormat struct {
	// ProvisioningState - The provisioning state of the web application firewall rule set.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// RuleSetType - The type of the web application firewall rule set.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - The version of the web application firewall rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
	// RuleGroups - The rule groups of the web application firewall rule set.
	RuleGroups *[]ApplicationGatewayFirewallRuleGroup `json:"ruleGroups,omitempty"`
}

// ApplicationGatewayFrontendIPConfiguration frontend IP configuration of an application gateway.
type ApplicationGatewayFrontendIPConfiguration struct {
	*ApplicationGatewayFrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendIPConfiguration.
func (agfic ApplicationGatewayFrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat
	}
	if agfic.Name != nil {
		objectMap["name"] = agfic.Name
	}
	if agfic.Etag != nil {
		objectMap["etag"] = agfic.Etag
	}
	if agfic.ID != nil {
		objectMap["id"] = agfic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFrontendIPConfiguration struct.
func (agfic *ApplicationGatewayFrontendIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFrontendIPConfigurationPropertiesFormat ApplicationGatewayFrontendIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFrontendIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat = &applicationGatewayFrontendIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agfic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfic.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayFrontendIPConfigurationPropertiesFormat properties of Frontend IP configuration of an
// application gateway.
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - PrivateIPAddress of the network interface IP Configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - PrivateIP allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Reference of the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Reference of the PublicIP resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - Provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayFrontendPort frontend port of an application gateway.
type ApplicationGatewayFrontendPort struct {
	*ApplicationGatewayFrontendPortPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendPort.
func (agfp ApplicationGatewayFrontendPort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfp.ApplicationGatewayFrontendPortPropertiesFormat != nil {
		objectMap["properties"] = agfp.ApplicationGatewayFrontendPortPropertiesFormat
	}
	if agfp.Name != nil {
		objectMap["name"] = agfp.Name
	}
	if agfp.Etag != nil {
		objectMap["etag"] = agfp.Etag
	}
	if agfp.ID != nil {
		objectMap["id"] = agfp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFrontendPort struct.
func (agfp *ApplicationGatewayFrontendPort) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFrontendPortPropertiesFormat ApplicationGatewayFrontendPortPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFrontendPortPropertiesFormat)
				if err != nil {
					return err
				}
				agfp.ApplicationGatewayFrontendPortPropertiesFormat = &applicationGatewayFrontendPortPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agfp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayFrontendPortPropertiesFormat properties of Frontend port of an application gateway.
type ApplicationGatewayFrontendPortPropertiesFormat struct {
	// Port - Frontend port
	Port *int32 `json:"port,omitempty"`
	// ProvisioningState - Provisioning state of the frontend port resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayHTTPListener http listener of an application gateway.
type ApplicationGatewayHTTPListener struct {
	*ApplicationGatewayHTTPListenerPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayHTTPListener.
func (aghl ApplicationGatewayHTTPListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aghl.ApplicationGatewayHTTPListenerPropertiesFormat != nil {
		objectMap["properties"] = aghl.ApplicationGatewayHTTPListenerPropertiesFormat
	}
	if aghl.Name != nil {
		objectMap["name"] = aghl.Name
	}
	if aghl.Etag != nil {
		objectMap["etag"] = aghl.Etag
	}
	if aghl.ID != nil {
		objectMap["id"] = aghl.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayHTTPListener struct.
func (aghl *ApplicationGatewayHTTPListener) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayHTTPListenerPropertiesFormat ApplicationGatewayHTTPListenerPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayHTTPListenerPropertiesFormat)
				if err != nil {
					return err
				}
				aghl.ApplicationGatewayHTTPListenerPropertiesFormat = &applicationGatewayHTTPListenerPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aghl.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				aghl.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aghl.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayHTTPListenerPropertiesFormat properties of HTTP listener of an application gateway.
type ApplicationGatewayHTTPListenerPropertiesFormat struct {
	// FrontendIPConfiguration - Frontend IP configuration resource of an application gateway.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// FrontendPort - Frontend port resource of an application gateway.
	FrontendPort *SubResource `json:"frontendPort,omitempty"`
	// Protocol - Protocol. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// HostName - Host name of HTTP listener.
	HostName *string `json:"hostName,omitempty"`
	// SslCertificate - SSL certificate resource of an application gateway.
	SslCertificate *SubResource `json:"sslCertificate,omitempty"`
	// RequireServerNameIndication - Applicable only if protocol is https. Enables SNI for multi-hosting.
	RequireServerNameIndication *bool `json:"requireServerNameIndication,omitempty"`
	// ProvisioningState - Provisioning state of the HTTP listener resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayIPConfiguration IP configuration of an application gateway. Currently 1 public and 1 private
// IP configuration is allowed.
type ApplicationGatewayIPConfiguration struct {
	*ApplicationGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayIPConfiguration.
func (agic ApplicationGatewayIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agic.ApplicationGatewayIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agic.ApplicationGatewayIPConfigurationPropertiesFormat
	}
	if agic.Name != nil {
		objectMap["name"] = agic.Name
	}
	if agic.Etag != nil {
		objectMap["etag"] = agic.Etag
	}
	if agic.ID != nil {
		objectMap["id"] = agic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayIPConfiguration struct.
func (agic *ApplicationGatewayIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayIPConfigurationPropertiesFormat ApplicationGatewayIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agic.ApplicationGatewayIPConfigurationPropertiesFormat = &applicationGatewayIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agic.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayIPConfigurationPropertiesFormat properties of IP configuration of an application gateway.
type ApplicationGatewayIPConfigurationPropertiesFormat struct {
	// Subnet - Reference of the subnet resource. A subnet from where application gateway gets its private address.
	Subnet *SubResource `json:"subnet,omitempty"`
	// ProvisioningState - Provisioning state of the application gateway subnet resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayListResult response for ListApplicationGateways API service call.
type ApplicationGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - List of an application gateways in a resource group.
	Value *[]ApplicationGateway `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationGatewayListResultIterator provides access to a complete listing of ApplicationGateway values.
type ApplicationGatewayListResultIterator struct {
	i    int
	page ApplicationGatewayListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGatewayListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationGatewayListResultIterator) Response() ApplicationGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGatewayListResultIterator) Value() ApplicationGateway {
	if !iter.page.NotDone() {
		return ApplicationGateway{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (aglr ApplicationGatewayListResult) IsEmpty() bool {
	return aglr.Value == nil || len(*aglr.Value) == 0
}

// applicationGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aglr ApplicationGatewayListResult) applicationGatewayListResultPreparer() (*http.Request, error) {
	if aglr.NextLink == nil || len(to.String(aglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aglr.NextLink)))
}

// ApplicationGatewayListResultPage contains a page of ApplicationGateway values.
type ApplicationGatewayListResultPage struct {
	fn   func(ApplicationGatewayListResult) (ApplicationGatewayListResult, error)
	aglr ApplicationGatewayListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGatewayListResultPage) Next() error {
	next, err := page.fn(page.aglr)
	if err != nil {
		return err
	}
	page.aglr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGatewayListResultPage) NotDone() bool {
	return !page.aglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationGatewayListResultPage) Response() ApplicationGatewayListResult {
	return page.aglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGatewayListResultPage) Values() []ApplicationGateway {
	if page.aglr.IsEmpty() {
		return nil
	}
	return *page.aglr.Value
}

// ApplicationGatewayPathRule path rule of URL path map of an application gateway.
type ApplicationGatewayPathRule struct {
	*ApplicationGatewayPathRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPathRule.
func (agpr ApplicationGatewayPathRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpr.ApplicationGatewayPathRulePropertiesFormat != nil {
		objectMap["properties"] = agpr.ApplicationGatewayPathRulePropertiesFormat
	}
	if agpr.Name != nil {
		objectMap["name"] = agpr.Name
	}
	if agpr.Etag != nil {
		objectMap["etag"] = agpr.Etag
	}
	if agpr.ID != nil {
		objectMap["id"] = agpr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayPathRule struct.
func (agpr *ApplicationGatewayPathRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPathRulePropertiesFormat ApplicationGatewayPathRulePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayPathRulePropertiesFormat)
				if err != nil {
					return err
				}
				agpr.ApplicationGatewayPathRulePropertiesFormat = &applicationGatewayPathRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agpr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agpr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agpr.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayPathRulePropertiesFormat properties of probe of an application gateway.
type ApplicationGatewayPathRulePropertiesFormat struct {
	// Paths - Path rules of URL path map.
	Paths *[]string `json:"paths,omitempty"`
	// BackendAddressPool - Backend address pool resource of URL path map.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Backend http settings resource of URL path map.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	// ProvisioningState - Path rule of URL path map resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayProbe probe of the application gateway.
type ApplicationGatewayProbe struct {
	*ApplicationGatewayProbePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayProbe.
func (agp ApplicationGatewayProbe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agp.ApplicationGatewayProbePropertiesFormat != nil {
		objectMap["properties"] = agp.ApplicationGatewayProbePropertiesFormat
	}
	if agp.Name != nil {
		objectMap["name"] = agp.Name
	}
	if agp.Etag != nil {
		objectMap["etag"] = agp.Etag
	}
	if agp.ID != nil {
		objectMap["id"] = agp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayProbe struct.
func (agp *ApplicationGatewayProbe) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayProbePropertiesFormat ApplicationGatewayProbePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayProbePropertiesFormat)
				if err != nil {
					return err
				}
				agp.ApplicationGatewayProbePropertiesFormat = &applicationGatewayProbePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayProbePropertiesFormat properties of probe of an application gateway.
type ApplicationGatewayProbePropertiesFormat struct {
	// Protocol - Protocol. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// Host - Host name to send the probe to.
	Host *string `json:"host,omitempty"`
	// Path - Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>
	Path *string `json:"path,omitempty"`
	// Interval - The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
	Interval *int32 `json:"interval,omitempty"`
	// Timeout - the probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// UnhealthyThreshold - The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
	UnhealthyThreshold *int32 `json:"unhealthyThreshold,omitempty"`
	// ProvisioningState - Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayPropertiesFormat properties of the application gateway.
type ApplicationGatewayPropertiesFormat struct {
	// Sku - SKU of the application gateway resource.
	Sku *ApplicationGatewaySku `json:"sku,omitempty"`
	// SslPolicy - SSL policy of the application gateway resource.
	SslPolicy *ApplicationGatewaySslPolicy `json:"sslPolicy,omitempty"`
	// OperationalState - Operational state of the application gateway resource. Possible values include: 'Stopped', 'Starting', 'Running', 'Stopping'
	OperationalState ApplicationGatewayOperationalState `json:"operationalState,omitempty"`
	// GatewayIPConfigurations - Subnets of application the gateway resource.
	GatewayIPConfigurations *[]ApplicationGatewayIPConfiguration `json:"gatewayIPConfigurations,omitempty"`
	// AuthenticationCertificates - Authentication certificates of the application gateway resource.
	AuthenticationCertificates *[]ApplicationGatewayAuthenticationCertificate `json:"authenticationCertificates,omitempty"`
	// SslCertificates - SSL certificates of the application gateway resource.
	SslCertificates *[]ApplicationGatewaySslCertificate `json:"sslCertificates,omitempty"`
	// FrontendIPConfigurations - Frontend IP addresses of the application gateway resource.
	FrontendIPConfigurations *[]ApplicationGatewayFrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	// FrontendPorts - Frontend ports of the application gateway resource.
	FrontendPorts *[]ApplicationGatewayFrontendPort `json:"frontendPorts,omitempty"`
	// Probes - Probes of the application gateway resource.
	Probes *[]ApplicationGatewayProbe `json:"probes,omitempty"`
	// BackendAddressPools - Backend address pool of the application gateway resource.
	BackendAddressPools *[]ApplicationGatewayBackendAddressPool `json:"backendAddressPools,omitempty"`
	// BackendHTTPSettingsCollection - Backend http settings of the application gateway resource.
	BackendHTTPSettingsCollection *[]ApplicationGatewayBackendHTTPSettings `json:"backendHttpSettingsCollection,omitempty"`
	// HTTPListeners - Http listeners of the application gateway resource.
	HTTPListeners *[]ApplicationGatewayHTTPListener `json:"httpListeners,omitempty"`
	// URLPathMaps - URL path map of the application gateway resource.
	URLPathMaps *[]ApplicationGatewayURLPathMap `json:"urlPathMaps,omitempty"`
	// RequestRoutingRules - Request routing rules of the application gateway resource.
	RequestRoutingRules *[]ApplicationGatewayRequestRoutingRule `json:"requestRoutingRules,omitempty"`
	// WebApplicationFirewallConfiguration - Web application firewall configuration.
	WebApplicationFirewallConfiguration *ApplicationGatewayWebApplicationFirewallConfiguration `json:"webApplicationFirewallConfiguration,omitempty"`
	// ResourceGUID - Resource GUID property of the application gateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Provisioning state of the application gateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayRequestRoutingRule request routing rule of an application gateway.
type ApplicationGatewayRequestRoutingRule struct {
	*ApplicationGatewayRequestRoutingRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRequestRoutingRule.
func (agrrr ApplicationGatewayRequestRoutingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat != nil {
		objectMap["properties"] = agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat
	}
	if agrrr.Name != nil {
		objectMap["name"] = agrrr.Name
	}
	if agrrr.Etag != nil {
		objectMap["etag"] = agrrr.Etag
	}
	if agrrr.ID != nil {
		objectMap["id"] = agrrr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayRequestRoutingRule struct.
func (agrrr *ApplicationGatewayRequestRoutingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayRequestRoutingRulePropertiesFormat ApplicationGatewayRequestRoutingRulePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayRequestRoutingRulePropertiesFormat)
				if err != nil {
					return err
				}
				agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat = &applicationGatewayRequestRoutingRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agrrr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agrrr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agrrr.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayRequestRoutingRulePropertiesFormat properties of request routing rule of the application
// gateway.
type ApplicationGatewayRequestRoutingRulePropertiesFormat struct {
	// RuleType - Rule type. Possible values include: 'Basic', 'PathBasedRouting'
	RuleType ApplicationGatewayRequestRoutingRuleType `json:"ruleType,omitempty"`
	// BackendAddressPool - Backend address pool resource of the application gateway.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Frontend port resource of the application gateway.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	// HTTPListener - Http listener resource of the application gateway.
	HTTPListener *SubResource `json:"httpListener,omitempty"`
	// URLPathMap - URL path map resource of the application gateway.
	URLPathMap *SubResource `json:"urlPathMap,omitempty"`
	// ProvisioningState - Provisioning state of the request routing rule resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewaysBackendHealthFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysBackendHealthFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ApplicationGatewaysBackendHealthFuture) Result(client ApplicationGatewaysClient) (agbh ApplicationGatewayBackendHealth, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysBackendHealthFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return agbh, azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysBackendHealthFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		agbh, err = client.BackendHealthResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysBackendHealthFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysBackendHealthFuture", "Result", resp, "Failure sending request")
		return
	}
	agbh, err = client.BackendHealthResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysBackendHealthFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ApplicationGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ApplicationGatewaysCreateOrUpdateFuture) Result(client ApplicationGatewaysClient) (ag ApplicationGateway, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ag, azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ag, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	ag, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ApplicationGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationGatewaysDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ApplicationGatewaysDeleteFuture) Result(client ApplicationGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ApplicationGatewaySku SKU of an application gateway
type ApplicationGatewaySku struct {
	// Name - Name of an application gateway SKU. Possible values include: 'StandardSmall', 'StandardMedium', 'StandardLarge', 'WAFMedium', 'WAFLarge'
	Name ApplicationGatewaySkuName `json:"name,omitempty"`
	// Tier - Tier of an application gateway. Possible values include: 'Standard', 'WAF'
	Tier ApplicationGatewayTier `json:"tier,omitempty"`
	// Capacity - Capacity (instance count) of an application gateway.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ApplicationGatewaySslCertificate SSL certificates of an application gateway.
type ApplicationGatewaySslCertificate struct {
	*ApplicationGatewaySslCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewaySslCertificate.
func (agsc ApplicationGatewaySslCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agsc.ApplicationGatewaySslCertificatePropertiesFormat != nil {
		objectMap["properties"] = agsc.ApplicationGatewaySslCertificatePropertiesFormat
	}
	if agsc.Name != nil {
		objectMap["name"] = agsc.Name
	}
	if agsc.Etag != nil {
		objectMap["etag"] = agsc.Etag
	}
	if agsc.ID != nil {
		objectMap["id"] = agsc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewaySslCertificate struct.
func (agsc *ApplicationGatewaySslCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewaySslCertificatePropertiesFormat ApplicationGatewaySslCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewaySslCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agsc.ApplicationGatewaySslCertificatePropertiesFormat = &applicationGatewaySslCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agsc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agsc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agsc.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewaySslCertificatePropertiesFormat properties of SSL certificates of an application gateway.
type ApplicationGatewaySslCertificatePropertiesFormat struct {
	// Data - Base-64 encoded pfx certificate. Only applicable in PUT Request.
	Data *string `json:"data,omitempty"`
	// Password - Password for the pfx file specified in data. Only applicable in PUT request.
	Password *string `json:"password,omitempty"`
	// PublicCertData - Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
	PublicCertData *string `json:"publicCertData,omitempty"`
	// ProvisioningState - Provisioning state of the SSL certificate resource Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewaySslPolicy application gateway SSL policy.
type ApplicationGatewaySslPolicy struct {
	// DisabledSslProtocols - SSL protocols to be disabled on application gateway.
	DisabledSslProtocols *[]ApplicationGatewaySslProtocol `json:"disabledSslProtocols,omitempty"`
}

// ApplicationGatewaysStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationGatewaysStartFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ApplicationGatewaysStartFuture) Result(client ApplicationGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysStartFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.StartResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStartFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStartFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.StartResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStartFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ApplicationGatewaysStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationGatewaysStopFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ApplicationGatewaysStopFuture) Result(client ApplicationGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysStopFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.StopResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStopFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStopFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.StopResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStopFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ApplicationGatewayURLPathMap urlPathMaps give a url path to the backend mapping information for
// PathBasedRouting.
type ApplicationGatewayURLPathMap struct {
	*ApplicationGatewayURLPathMapPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayURLPathMap.
func (agupm ApplicationGatewayURLPathMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agupm.ApplicationGatewayURLPathMapPropertiesFormat != nil {
		objectMap["properties"] = agupm.ApplicationGatewayURLPathMapPropertiesFormat
	}
	if agupm.Name != nil {
		objectMap["name"] = agupm.Name
	}
	if agupm.Etag != nil {
		objectMap["etag"] = agupm.Etag
	}
	if agupm.ID != nil {
		objectMap["id"] = agupm.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayURLPathMap struct.
func (agupm *ApplicationGatewayURLPathMap) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayURLPathMapPropertiesFormat ApplicationGatewayURLPathMapPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayURLPathMapPropertiesFormat)
				if err != nil {
					return err
				}
				agupm.ApplicationGatewayURLPathMapPropertiesFormat = &applicationGatewayURLPathMapPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agupm.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agupm.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agupm.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayURLPathMapPropertiesFormat properties of UrlPathMap of the application gateway.
type ApplicationGatewayURLPathMapPropertiesFormat struct {
	// DefaultBackendAddressPool - Default backend address pool resource of URL path map.
	DefaultBackendAddressPool *SubResource `json:"defaultBackendAddressPool,omitempty"`
	// DefaultBackendHTTPSettings - Default backend http settings resource of URL path map.
	DefaultBackendHTTPSettings *SubResource `json:"defaultBackendHttpSettings,omitempty"`
	// PathRules - Path rule of URL path map resource.
	PathRules *[]ApplicationGatewayPathRule `json:"pathRules,omitempty"`
	// ProvisioningState - Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayWebApplicationFirewallConfiguration application gateway web application firewall
// configuration.
type ApplicationGatewayWebApplicationFirewallConfiguration struct {
	// Enabled - Whether the web application firewall is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// FirewallMode - Web application firewall mode. Possible values include: 'Detection', 'Prevention'
	FirewallMode ApplicationGatewayFirewallMode `json:"firewallMode,omitempty"`
	// RuleSetType - The type of the web application firewall rule set. Possible values are: 'OWASP'.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - The version of the rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
	// DisabledRuleGroups - The disabled rule groups.
	DisabledRuleGroups *[]ApplicationGatewayFirewallDisabledRuleGroup `json:"disabledRuleGroups,omitempty"`
}

// AuthorizationListResult response for ListAuthorizations API service call retrieves all authorizations that
// belongs to an ExpressRouteCircuit.
type AuthorizationListResult struct {
	autorest.Response `json:"-"`
	// Value - The authorizations in an ExpressRoute Circuit.
	Value *[]ExpressRouteCircuitAuthorization `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AuthorizationListResultIterator provides access to a complete listing of ExpressRouteCircuitAuthorization
// values.
type AuthorizationListResultIterator struct {
	i    int
	page AuthorizationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AuthorizationListResultIterator) Response() AuthorizationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationListResultIterator) Value() ExpressRouteCircuitAuthorization {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitAuthorization{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AuthorizationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// authorizationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AuthorizationListResult) authorizationListResultPreparer() (*http.Request, error) {
	if alr.NextLink == nil || len(to.String(alr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AuthorizationListResultPage contains a page of ExpressRouteCircuitAuthorization values.
type AuthorizationListResultPage struct {
	fn  func(AuthorizationListResult) (AuthorizationListResult, error)
	alr AuthorizationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationListResultPage) Next() error {
	next, err := page.fn(page.alr)
	if err != nil {
		return err
	}
	page.alr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AuthorizationListResultPage) Response() AuthorizationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationListResultPage) Values() []ExpressRouteCircuitAuthorization {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// AuthorizationPropertiesFormat ...
type AuthorizationPropertiesFormat struct {
	// AuthorizationKey - The authorization key.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// AuthorizationUseStatus - AuthorizationUseStatus. Possible values are: 'Available' and 'InUse'. Possible values include: 'Available', 'InUse'
	AuthorizationUseStatus AuthorizationUseStatus `json:"authorizationUseStatus,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// AzureAsyncOperationResult the response body contains the status of the specified asynchronous operation,
// indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct from the
// HTTP status code returned for the Get Operation Status operation itself. If the asynchronous operation
// succeeded, the response body includes the HTTP status code for the successful request. If the asynchronous
// operation failed, the response body includes the HTTP status code for the failed request and error information
// regarding the failure.
type AzureAsyncOperationResult struct {
	// Status - Status of the Azure async operation. Possible values are: 'InProgress', 'Succeeded', and 'Failed'. Possible values include: 'InProgress', 'Succeeded', 'Failed'
	Status OperationStatus `json:"status,omitempty"`
	Error  *Error          `json:"error,omitempty"`
}

// BackendAddressPool pool of backend IP addresses.
type BackendAddressPool struct {
	*BackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendAddressPool.
func (bap BackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bap.BackendAddressPoolPropertiesFormat != nil {
		objectMap["properties"] = bap.BackendAddressPoolPropertiesFormat
	}
	if bap.Name != nil {
		objectMap["name"] = bap.Name
	}
	if bap.Etag != nil {
		objectMap["etag"] = bap.Etag
	}
	if bap.ID != nil {
		objectMap["id"] = bap.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackendAddressPool struct.
func (bap *BackendAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backendAddressPoolPropertiesFormat BackendAddressPoolPropertiesFormat
				err = json.Unmarshal(*v, &backendAddressPoolPropertiesFormat)
				if err != nil {
					return err
				}
				bap.BackendAddressPoolPropertiesFormat = &backendAddressPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bap.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bap.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bap.ID = &ID
			}
		}
	}

	return nil
}

// BackendAddressPoolPropertiesFormat properties of the backend address pool.
type BackendAddressPoolPropertiesFormat struct {
	// BackendIPConfigurations - Gets collection of references to IP addresses defined in network interfaces.
	BackendIPConfigurations *[]InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`
	// LoadBalancingRules - Gets load balancing rules that use this backend address pool.
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// OutboundNatRule - Gets outbound rules that use this backend address pool.
	OutboundNatRule *SubResource `json:"outboundNatRule,omitempty"`
	// ProvisioningState - Get provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// BGPCommunity contains bgp community information offered in Service Community resources.
type BGPCommunity struct {
	// ServiceSupportedRegion - The region which the service support. e.g. For O365, region is Global.
	ServiceSupportedRegion *string `json:"serviceSupportedRegion,omitempty"`
	// CommunityName - The name of the bgp community. e.g. Skype.
	CommunityName *string `json:"communityName,omitempty"`
	// CommunityValue - The value of the bgp community. For more information: https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
	CommunityValue *string `json:"communityValue,omitempty"`
	// CommunityPrefixes - The prefixes that the bgp community contains.
	CommunityPrefixes *[]string `json:"communityPrefixes,omitempty"`
}

// BgpPeerStatus BGP peer status details
type BgpPeerStatus struct {
	// LocalAddress - The virtual network gateway's local address
	LocalAddress *string `json:"localAddress,omitempty"`
	// Neighbor - The remote BGP peer
	Neighbor *string `json:"neighbor,omitempty"`
	// Asn - The autonomous system number of the remote BGP peer
	Asn *int32 `json:"asn,omitempty"`
	// State - The BGP peer state. Possible values include: 'BgpPeerStateUnknown', 'BgpPeerStateStopped', 'BgpPeerStateIdle', 'BgpPeerStateConnecting', 'BgpPeerStateConnected'
	State BgpPeerState `json:"state,omitempty"`
	// ConnectedDuration - For how long the peering has been up
	ConnectedDuration *string `json:"connectedDuration,omitempty"`
	// RoutesReceived - The number of routes learned from this peer
	RoutesReceived *int64 `json:"routesReceived,omitempty"`
	// MessagesSent - The number of BGP messages sent
	MessagesSent *int64 `json:"messagesSent,omitempty"`
	// MessagesReceived - The number of BGP messages received
	MessagesReceived *int64 `json:"messagesReceived,omitempty"`
}

// BgpPeerStatusListResult response for list BGP peer status API service call
type BgpPeerStatusListResult struct {
	autorest.Response `json:"-"`
	// Value - List of BGP peers
	Value *[]BgpPeerStatus `json:"value,omitempty"`
}

// BgpServiceCommunity service Community Properties.
type BgpServiceCommunity struct {
	*BgpServiceCommunityPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BgpServiceCommunity.
func (bsc BgpServiceCommunity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsc.BgpServiceCommunityPropertiesFormat != nil {
		objectMap["properties"] = bsc.BgpServiceCommunityPropertiesFormat
	}
	if bsc.ID != nil {
		objectMap["id"] = bsc.ID
	}
	if bsc.Name != nil {
		objectMap["name"] = bsc.Name
	}
	if bsc.Type != nil {
		objectMap["type"] = bsc.Type
	}
	if bsc.Location != nil {
		objectMap["location"] = bsc.Location
	}
	if bsc.Tags != nil {
		objectMap["tags"] = bsc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BgpServiceCommunity struct.
func (bsc *BgpServiceCommunity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bgpServiceCommunityPropertiesFormat BgpServiceCommunityPropertiesFormat
				err = json.Unmarshal(*v, &bgpServiceCommunityPropertiesFormat)
				if err != nil {
					return err
				}
				bsc.BgpServiceCommunityPropertiesFormat = &bgpServiceCommunityPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bsc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bsc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bsc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bsc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bsc.Tags = tags
			}
		}
	}

	return nil
}

// BgpServiceCommunityListResult response for the ListServiceCommunity API service call.
type BgpServiceCommunityListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of service community resources.
	Value *[]BgpServiceCommunity `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BgpServiceCommunityListResultIterator provides access to a complete listing of BgpServiceCommunity values.
type BgpServiceCommunityListResultIterator struct {
	i    int
	page BgpServiceCommunityListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BgpServiceCommunityListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BgpServiceCommunityListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BgpServiceCommunityListResultIterator) Response() BgpServiceCommunityListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BgpServiceCommunityListResultIterator) Value() BgpServiceCommunity {
	if !iter.page.NotDone() {
		return BgpServiceCommunity{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (bsclr BgpServiceCommunityListResult) IsEmpty() bool {
	return bsclr.Value == nil || len(*bsclr.Value) == 0
}

// bgpServiceCommunityListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bsclr BgpServiceCommunityListResult) bgpServiceCommunityListResultPreparer() (*http.Request, error) {
	if bsclr.NextLink == nil || len(to.String(bsclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bsclr.NextLink)))
}

// BgpServiceCommunityListResultPage contains a page of BgpServiceCommunity values.
type BgpServiceCommunityListResultPage struct {
	fn    func(BgpServiceCommunityListResult) (BgpServiceCommunityListResult, error)
	bsclr BgpServiceCommunityListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BgpServiceCommunityListResultPage) Next() error {
	next, err := page.fn(page.bsclr)
	if err != nil {
		return err
	}
	page.bsclr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BgpServiceCommunityListResultPage) NotDone() bool {
	return !page.bsclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BgpServiceCommunityListResultPage) Response() BgpServiceCommunityListResult {
	return page.bsclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BgpServiceCommunityListResultPage) Values() []BgpServiceCommunity {
	if page.bsclr.IsEmpty() {
		return nil
	}
	return *page.bsclr.Value
}

// BgpServiceCommunityPropertiesFormat properties of Service Community.
type BgpServiceCommunityPropertiesFormat struct {
	// ServiceName - The name of the bgp community. e.g. Skype.
	ServiceName *string `json:"serviceName,omitempty"`
	// BgpCommunities - Get a list of bgp communities.
	BgpCommunities *[]BGPCommunity `json:"bgpCommunities,omitempty"`
}

// BgpSettings BGP settings details
type BgpSettings struct {
	// Asn - The BGP speaker's ASN.
	Asn *int64 `json:"asn,omitempty"`
	// BgpPeeringAddress - The BGP peering address and BGP identifier of this BGP speaker.
	BgpPeeringAddress *string `json:"bgpPeeringAddress,omitempty"`
	// PeerWeight - The weight added to routes learned from this BGP speaker.
	PeerWeight *int32 `json:"peerWeight,omitempty"`
}

// ConnectionResetSharedKey the virtual network connection reset shared key
type ConnectionResetSharedKey struct {
	autorest.Response `json:"-"`
	// KeyLength - The virtual network connection reset shared key length, should between 1 and 128.
	KeyLength *int32 `json:"keyLength,omitempty"`
}

// ConnectionSharedKey response for GetConnectionSharedKey API service call
type ConnectionSharedKey struct {
	autorest.Response `json:"-"`
	// Value - The virtual network connection shared key value.
	Value *string `json:"value,omitempty"`
}

// ConnectivityDestination parameters that define destination of connection.
type ConnectivityDestination struct {
	// ResourceID - The ID of the resource to which a connection attempt will be made.
	ResourceID *string `json:"resourceId,omitempty"`
	// Address - The IP address or URI the resource to which a connection attempt will be made.
	Address *string `json:"address,omitempty"`
	// Port - Port on which check connectivity will be performed.
	Port *int32 `json:"port,omitempty"`
}

// ConnectivityHop information about a hop between the source and the destination.
type ConnectivityHop struct {
	// Type - The type of the hop.
	Type *string `json:"type,omitempty"`
	// ID - The ID of the hop.
	ID *string `json:"id,omitempty"`
	// Address - The IP address of the hop.
	Address *string `json:"address,omitempty"`
	// ResourceID - The ID of the resource corresponding to this hop.
	ResourceID *string `json:"resourceId,omitempty"`
	// NextHopIds - List of next hop identifiers.
	NextHopIds *[]string `json:"nextHopIds,omitempty"`
	// Issues - List of issues.
	Issues *[]ConnectivityIssue `json:"issues,omitempty"`
}

// ConnectivityInformation information on the connectivity status.
type ConnectivityInformation struct {
	autorest.Response `json:"-"`
	// Hops - List of hops between the source and the destination.
	Hops *[]ConnectivityHop `json:"hops,omitempty"`
	// ConnectionStatus - The connection status. Possible values include: 'ConnectionStatusUnknown', 'ConnectionStatusConnected', 'ConnectionStatusDisconnected', 'ConnectionStatusDegraded'
	ConnectionStatus ConnectionStatus `json:"connectionStatus,omitempty"`
	// AvgLatencyInMs - Average latency in milliseconds.
	AvgLatencyInMs *int32 `json:"avgLatencyInMs,omitempty"`
	// MinLatencyInMs - Minimum latency in milliseconds.
	MinLatencyInMs *int32 `json:"minLatencyInMs,omitempty"`
	// MaxLatencyInMs - Maximum latency in milliseconds.
	MaxLatencyInMs *int32 `json:"maxLatencyInMs,omitempty"`
	// ProbesSent - Total number of probes sent.
	ProbesSent *int32 `json:"probesSent,omitempty"`
	// ProbesFailed - Number of failed probes.
	ProbesFailed *int32 `json:"probesFailed,omitempty"`
}

// ConnectivityIssue information about an issue encountered in the process of checking for connectivity.
type ConnectivityIssue struct {
	// Origin - The origin of the issue. Possible values include: 'OriginLocal', 'OriginInbound', 'OriginOutbound'
	Origin Origin `json:"origin,omitempty"`
	// Severity - The severity of the issue. Possible values include: 'SeverityError', 'SeverityWarning'
	Severity Severity `json:"severity,omitempty"`
	// Type - The type of issue. Possible values include: 'IssueTypeUnknown', 'IssueTypeAgentStopped', 'IssueTypeGuestFirewall', 'IssueTypeDNSResolution', 'IssueTypeSocketBind', 'IssueTypeNetworkSecurityRule', 'IssueTypeUserDefinedRoute', 'IssueTypePortThrottled', 'IssueTypePlatform'
	Type IssueType `json:"type,omitempty"`
	// Context - Provides additional context on the issue.
	Context *[]map[string]*string `json:"context,omitempty"`
}

// ConnectivityParameters parameters that determine how the connectivity check will be performed.
type ConnectivityParameters struct {
	Source      *ConnectivitySource      `json:"source,omitempty"`
	Destination *ConnectivityDestination `json:"destination,omitempty"`
}

// ConnectivitySource parameters that define the source of the connection.
type ConnectivitySource struct {
	// ResourceID - The ID of the resource from which a connectivity check will be initiated.
	ResourceID *string `json:"resourceId,omitempty"`
	// Port - The source port from which a connectivity check will be performed.
	Port *int32 `json:"port,omitempty"`
}

// DhcpOptions dhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network.
// Standard DHCP option for a subnet overrides VNET DHCP options.
type DhcpOptions struct {
	// DNSServers - The list of DNS servers IP addresses.
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// DNSNameAvailabilityResult response for the CheckDnsNameAvailability API service call.
type DNSNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Available - Domain availability (True/False).
	Available *bool `json:"available,omitempty"`
}

// EffectiveNetworkSecurityGroup effective network security group.
type EffectiveNetworkSecurityGroup struct {
	// NetworkSecurityGroup - The ID of network security group that is applied.
	NetworkSecurityGroup *SubResource                              `json:"networkSecurityGroup,omitempty"`
	Association          *EffectiveNetworkSecurityGroupAssociation `json:"association,omitempty"`
	// EffectiveSecurityRules - A collection of effective security rules.
	EffectiveSecurityRules *[]EffectiveNetworkSecurityRule `json:"effectiveSecurityRules,omitempty"`
}

// EffectiveNetworkSecurityGroupAssociation the effective network security group association.
type EffectiveNetworkSecurityGroupAssociation struct {
	// Subnet - The ID of the subnet if assigned.
	Subnet *SubResource `json:"subnet,omitempty"`
	// NetworkInterface - The ID of the network interface if assigned.
	NetworkInterface *SubResource `json:"networkInterface,omitempty"`
}

// EffectiveNetworkSecurityGroupListResult response for list effective network security groups API service call.
type EffectiveNetworkSecurityGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of effective network security groups.
	Value *[]EffectiveNetworkSecurityGroup `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EffectiveNetworkSecurityRule effective network security rules.
type EffectiveNetworkSecurityRule struct {
	// Name - The name of the security rule specified by the user (if created by the user).
	Name *string `json:"name,omitempty"`
	// Protocol - The network protocol this rule applies to. Possible values are: 'Tcp', 'Udp', and '*'. Possible values include: 'SecurityRuleProtocolTCP', 'SecurityRuleProtocolUDP', 'SecurityRuleProtocolAsterisk'
	Protocol SecurityRuleProtocol `json:"protocol,omitempty"`
	// SourcePortRange - The source port or range.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`
	// DestinationPortRange - The destination port or range.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`
	// SourceAddressPrefix - The source address prefix.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// DestinationAddressPrefix - The destination address prefix.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`
	// ExpandedSourceAddressPrefix - The expanded source address prefix.
	ExpandedSourceAddressPrefix *[]string `json:"expandedSourceAddressPrefix,omitempty"`
	// ExpandedDestinationAddressPrefix - Expanded destination address prefix.
	ExpandedDestinationAddressPrefix *[]string `json:"expandedDestinationAddressPrefix,omitempty"`
	// Access - Whether network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'. Possible values include: 'SecurityRuleAccessAllow', 'SecurityRuleAccessDeny'
	Access SecurityRuleAccess `json:"access,omitempty"`
	// Priority - The priority of the rule.
	Priority *int32 `json:"priority,omitempty"`
	// Direction - The direction of the rule. Possible values are: 'Inbound and Outbound'. Possible values include: 'SecurityRuleDirectionInbound', 'SecurityRuleDirectionOutbound'
	Direction SecurityRuleDirection `json:"direction,omitempty"`
}

// EffectiveRoute effective Route
type EffectiveRoute struct {
	// Name - The name of the user defined route. This is optional.
	Name *string `json:"name,omitempty"`
	// Source - Who created the route. Possible values are: 'Unknown', 'User', 'VirtualNetworkGateway', and 'Default'. Possible values include: 'EffectiveRouteSourceUnknown', 'EffectiveRouteSourceUser', 'EffectiveRouteSourceVirtualNetworkGateway', 'EffectiveRouteSourceDefault'
	Source EffectiveRouteSource `json:"source,omitempty"`
	// State - The value of effective route. Possible values are: 'Active' and 'Invalid'. Possible values include: 'Active', 'Invalid'
	State EffectiveRouteState `json:"state,omitempty"`
	// AddressPrefix - The address prefixes of the effective routes in CIDR notation.
	AddressPrefix *[]string `json:"addressPrefix,omitempty"`
	// NextHopIPAddress - The IP address of the next hop of the effective route.
	NextHopIPAddress *[]string `json:"nextHopIpAddress,omitempty"`
	// NextHopType - The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Possible values include: 'RouteNextHopTypeVirtualNetworkGateway', 'RouteNextHopTypeVnetLocal', 'RouteNextHopTypeInternet', 'RouteNextHopTypeVirtualAppliance', 'RouteNextHopTypeNone'
	NextHopType RouteNextHopType `json:"nextHopType,omitempty"`
}

// EffectiveRouteListResult response for list effective route API service call.
type EffectiveRouteListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of effective routes.
	Value *[]EffectiveRoute `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Error ...
type Error struct {
	Code       *string         `json:"code,omitempty"`
	Message    *string         `json:"message,omitempty"`
	Target     *string         `json:"target,omitempty"`
	Details    *[]ErrorDetails `json:"details,omitempty"`
	InnerError *string         `json:"innerError,omitempty"`
}

// ErrorDetails ...
type ErrorDetails struct {
	Code    *string `json:"code,omitempty"`
	Target  *string `json:"target,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ExpressRouteCircuit expressRouteCircuit resource
type ExpressRouteCircuit struct {
	autorest.Response `json:"-"`
	// Sku - The SKU.
	Sku                                  *ExpressRouteCircuitSku `json:"sku,omitempty"`
	*ExpressRouteCircuitPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuit.
func (erc ExpressRouteCircuit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erc.Sku != nil {
		objectMap["sku"] = erc.Sku
	}
	if erc.ExpressRouteCircuitPropertiesFormat != nil {
		objectMap["properties"] = erc.ExpressRouteCircuitPropertiesFormat
	}
	if erc.Etag != nil {
		objectMap["etag"] = erc.Etag
	}
	if erc.ID != nil {
		objectMap["id"] = erc.ID
	}
	if erc.Name != nil {
		objectMap["name"] = erc.Name
	}
	if erc.Type != nil {
		objectMap["type"] = erc.Type
	}
	if erc.Location != nil {
		objectMap["location"] = erc.Location
	}
	if erc.Tags != nil {
		objectMap["tags"] = erc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuit struct.
func (erc *ExpressRouteCircuit) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku ExpressRouteCircuitSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				erc.Sku = &sku
			}
		case "properties":
			if v != nil {
				var expressRouteCircuitPropertiesFormat ExpressRouteCircuitPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitPropertiesFormat)
				if err != nil {
					return err
				}
				erc.ExpressRouteCircuitPropertiesFormat = &expressRouteCircuitPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erc.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteCircuitArpTable the ARP table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitArpTable struct {
	// Age - Age
	Age *int32 `json:"age,omitempty"`
	// Interface - Interface
	Interface *string `json:"interface,omitempty"`
	// IPAddress - The IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// MacAddress - The MAC address.
	MacAddress *string `json:"macAddress,omitempty"`
}

// ExpressRouteCircuitAuthorization authorization in an ExpressRouteCircuit resource.
type ExpressRouteCircuitAuthorization struct {
	autorest.Response              `json:"-"`
	*AuthorizationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitAuthorization.
func (erca ExpressRouteCircuitAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erca.AuthorizationPropertiesFormat != nil {
		objectMap["properties"] = erca.AuthorizationPropertiesFormat
	}
	if erca.Name != nil {
		objectMap["name"] = erca.Name
	}
	if erca.Etag != nil {
		objectMap["etag"] = erca.Etag
	}
	if erca.ID != nil {
		objectMap["id"] = erca.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitAuthorization struct.
func (erca *ExpressRouteCircuitAuthorization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var authorizationPropertiesFormat AuthorizationPropertiesFormat
				err = json.Unmarshal(*v, &authorizationPropertiesFormat)
				if err != nil {
					return err
				}
				erca.AuthorizationPropertiesFormat = &authorizationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erca.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erca.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erca.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture) Result(client ExpressRouteCircuitAuthorizationsClient) (erca ExpressRouteCircuitAuthorization, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return erca, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		erca, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	erca, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ExpressRouteCircuitAuthorizationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitAuthorizationsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitAuthorizationsDeleteFuture) Result(client ExpressRouteCircuitAuthorizationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitAuthorizationsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ExpressRouteCircuitListResult response for ListExpressRouteCircuit API service call.
type ExpressRouteCircuitListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRouteCircuits in a resource group.
	Value *[]ExpressRouteCircuit `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitListResultIterator provides access to a complete listing of ExpressRouteCircuit values.
type ExpressRouteCircuitListResultIterator struct {
	i    int
	page ExpressRouteCircuitListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitListResultIterator) Response() ExpressRouteCircuitListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitListResultIterator) Value() ExpressRouteCircuit {
	if !iter.page.NotDone() {
		return ExpressRouteCircuit{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (erclr ExpressRouteCircuitListResult) IsEmpty() bool {
	return erclr.Value == nil || len(*erclr.Value) == 0
}

// expressRouteCircuitListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erclr ExpressRouteCircuitListResult) expressRouteCircuitListResultPreparer() (*http.Request, error) {
	if erclr.NextLink == nil || len(to.String(erclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erclr.NextLink)))
}

// ExpressRouteCircuitListResultPage contains a page of ExpressRouteCircuit values.
type ExpressRouteCircuitListResultPage struct {
	fn    func(ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)
	erclr ExpressRouteCircuitListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitListResultPage) Next() error {
	next, err := page.fn(page.erclr)
	if err != nil {
		return err
	}
	page.erclr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitListResultPage) NotDone() bool {
	return !page.erclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitListResultPage) Response() ExpressRouteCircuitListResult {
	return page.erclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitListResultPage) Values() []ExpressRouteCircuit {
	if page.erclr.IsEmpty() {
		return nil
	}
	return *page.erclr.Value
}

// ExpressRouteCircuitPeering peering in an ExpressRouteCircuit resource.
type ExpressRouteCircuitPeering struct {
	autorest.Response                           `json:"-"`
	*ExpressRouteCircuitPeeringPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitPeering.
func (ercp ExpressRouteCircuitPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercp.ExpressRouteCircuitPeeringPropertiesFormat != nil {
		objectMap["properties"] = ercp.ExpressRouteCircuitPeeringPropertiesFormat
	}
	if ercp.Name != nil {
		objectMap["name"] = ercp.Name
	}
	if ercp.Etag != nil {
		objectMap["etag"] = ercp.Etag
	}
	if ercp.ID != nil {
		objectMap["id"] = ercp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitPeering struct.
func (ercp *ExpressRouteCircuitPeering) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteCircuitPeeringPropertiesFormat ExpressRouteCircuitPeeringPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitPeeringPropertiesFormat)
				if err != nil {
					return err
				}
				ercp.ExpressRouteCircuitPeeringPropertiesFormat = &expressRouteCircuitPeeringPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ercp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ercp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ercp.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCircuitPeeringConfig specifies the peering configuration.
type ExpressRouteCircuitPeeringConfig struct {
	// AdvertisedPublicPrefixes - The reference of AdvertisedPublicPrefixes.
	AdvertisedPublicPrefixes *[]string `json:"advertisedPublicPrefixes,omitempty"`
	// AdvertisedPublicPrefixesState - AdvertisedPublicPrefixState of the Peering resource. Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'. Possible values include: 'NotConfigured', 'Configuring', 'Configured', 'ValidationNeeded'
	AdvertisedPublicPrefixesState ExpressRouteCircuitPeeringAdvertisedPublicPrefixState `json:"advertisedPublicPrefixesState,omitempty"`
	// CustomerASN - The CustomerASN of the peering.
	CustomerASN *int32 `json:"customerASN,omitempty"`
	// RoutingRegistryName - The RoutingRegistryName of the configuration.
	RoutingRegistryName *string `json:"routingRegistryName,omitempty"`
}

// ExpressRouteCircuitPeeringListResult response for ListPeering API service call retrieves all peerings that
// belong to an ExpressRouteCircuit.
type ExpressRouteCircuitPeeringListResult struct {
	autorest.Response `json:"-"`
	// Value - The peerings in an express route circuit.
	Value *[]ExpressRouteCircuitPeering `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitPeeringListResultIterator provides access to a complete listing of ExpressRouteCircuitPeering
// values.
type ExpressRouteCircuitPeeringListResultIterator struct {
	i    int
	page ExpressRouteCircuitPeeringListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitPeeringListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitPeeringListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitPeeringListResultIterator) Response() ExpressRouteCircuitPeeringListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitPeeringListResultIterator) Value() ExpressRouteCircuitPeering {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitPeering{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ercplr ExpressRouteCircuitPeeringListResult) IsEmpty() bool {
	return ercplr.Value == nil || len(*ercplr.Value) == 0
}

// expressRouteCircuitPeeringListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercplr ExpressRouteCircuitPeeringListResult) expressRouteCircuitPeeringListResultPreparer() (*http.Request, error) {
	if ercplr.NextLink == nil || len(to.String(ercplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercplr.NextLink)))
}

// ExpressRouteCircuitPeeringListResultPage contains a page of ExpressRouteCircuitPeering values.
type ExpressRouteCircuitPeeringListResultPage struct {
	fn     func(ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)
	ercplr ExpressRouteCircuitPeeringListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitPeeringListResultPage) Next() error {
	next, err := page.fn(page.ercplr)
	if err != nil {
		return err
	}
	page.ercplr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitPeeringListResultPage) NotDone() bool {
	return !page.ercplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitPeeringListResultPage) Response() ExpressRouteCircuitPeeringListResult {
	return page.ercplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitPeeringListResultPage) Values() []ExpressRouteCircuitPeering {
	if page.ercplr.IsEmpty() {
		return nil
	}
	return *page.ercplr.Value
}

// ExpressRouteCircuitPeeringPropertiesFormat ...
type ExpressRouteCircuitPeeringPropertiesFormat struct {
	// PeeringType - The PeeringType. Possible values are: 'AzurePublicPeering', 'AzurePrivatePeering', and 'MicrosoftPeering'. Possible values include: 'AzurePublicPeering', 'AzurePrivatePeering', 'MicrosoftPeering'
	PeeringType ExpressRouteCircuitPeeringType `json:"peeringType,omitempty"`
	// State - The state of peering. Possible values are: 'Disabled' and 'Enabled'. Possible values include: 'ExpressRouteCircuitPeeringStateDisabled', 'ExpressRouteCircuitPeeringStateEnabled'
	State ExpressRouteCircuitPeeringState `json:"state,omitempty"`
	// AzureASN - The Azure ASN.
	AzureASN *int32 `json:"azureASN,omitempty"`
	// PeerASN - The peer ASN.
	PeerASN *int32 `json:"peerASN,omitempty"`
	// PrimaryPeerAddressPrefix - The primary address prefix.
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`
	// SecondaryPeerAddressPrefix - The secondary address prefix.
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`
	// PrimaryAzurePort - The primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty"`
	// SecondaryAzurePort - The secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty"`
	// SharedKey - The shared key.
	SharedKey *string `json:"sharedKey,omitempty"`
	// VlanID - The VLAN ID.
	VlanID *int32 `json:"vlanId,omitempty"`
	// MicrosoftPeeringConfig - The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`
	// Stats - Gets peering stats.
	Stats *ExpressRouteCircuitStats `json:"stats,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// GatewayManagerEtag - The GatewayManager Etag.
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`
	// LastModifiedBy - Gets whether the provider or the customer last modified the peering.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// RouteFilter - The reference of the RouteFilter resource.
	RouteFilter *RouteFilter `json:"routeFilter,omitempty"`
	// Ipv6PeeringConfig - The IPv6 peering configuration.
	Ipv6PeeringConfig *Ipv6ExpressRouteCircuitPeeringConfig `json:"ipv6PeeringConfig,omitempty"`
}

// ExpressRouteCircuitPeeringsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitPeeringsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitPeeringsCreateOrUpdateFuture) Result(client ExpressRouteCircuitPeeringsClient) (ercp ExpressRouteCircuitPeering, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ercp, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ercp, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	ercp, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ExpressRouteCircuitPeeringsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitPeeringsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitPeeringsDeleteFuture) Result(client ExpressRouteCircuitPeeringsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitPeeringsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ExpressRouteCircuitPropertiesFormat properties of ExpressRouteCircuit.
type ExpressRouteCircuitPropertiesFormat struct {
	// AllowClassicOperations - Allow classic operations
	AllowClassicOperations *bool `json:"allowClassicOperations,omitempty"`
	// CircuitProvisioningState - The CircuitProvisioningState state of the resource.
	CircuitProvisioningState *string `json:"circuitProvisioningState,omitempty"`
	// ServiceProviderProvisioningState - The ServiceProviderProvisioningState state of the resource. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned', and 'Deprovisioning'. Possible values include: 'NotProvisioned', 'Provisioning', 'Provisioned', 'Deprovisioning'
	ServiceProviderProvisioningState ServiceProviderProvisioningState `json:"serviceProviderProvisioningState,omitempty"`
	// Authorizations - The list of authorizations.
	Authorizations *[]ExpressRouteCircuitAuthorization `json:"authorizations,omitempty"`
	// Peerings - The list of peerings.
	Peerings *[]ExpressRouteCircuitPeering `json:"peerings,omitempty"`
	// ServiceKey - The ServiceKey.
	ServiceKey *string `json:"serviceKey,omitempty"`
	// ServiceProviderNotes - The ServiceProviderNotes.
	ServiceProviderNotes *string `json:"serviceProviderNotes,omitempty"`
	// ServiceProviderProperties - The ServiceProviderProperties.
	ServiceProviderProperties *ExpressRouteCircuitServiceProviderProperties `json:"serviceProviderProperties,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// GatewayManagerEtag - The GatewayManager Etag.
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`
}

// ExpressRouteCircuitRoutesTable the routes table associated with the ExpressRouteCircuit
type ExpressRouteCircuitRoutesTable struct {
	// NetworkProperty - network
	NetworkProperty *string `json:"network,omitempty"`
	// NextHop - nextHop
	NextHop *string `json:"nextHop,omitempty"`
	// LocPrf - locPrf
	LocPrf *string `json:"locPrf,omitempty"`
	// Weight - weight.
	Weight *int32 `json:"weight,omitempty"`
	// Path - path
	Path *string `json:"path,omitempty"`
}

// ExpressRouteCircuitRoutesTableSummary the routes table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitRoutesTableSummary struct {
	// Neighbor - Neighbor
	Neighbor *string `json:"neighbor,omitempty"`
	// V - BGP version number spoken to the neighbor.
	V *int32 `json:"v,omitempty"`
	// As - Autonomous system number.
	As *int32 `json:"as,omitempty"`
	// UpDown - The length of time that the BGP session has been in the Established state, or the current status if not in the Established state.
	UpDown *string `json:"upDown,omitempty"`
	// StatePfxRcd - Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group.
	StatePfxRcd *string `json:"statePfxRcd,omitempty"`
}

// ExpressRouteCircuitsArpTableListResult response for ListArpTable associated with the Express Route Circuits API.
type ExpressRouteCircuitsArpTableListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets list of the ARP table.
	Value *[]ExpressRouteCircuitArpTable `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitsCreateOrUpdateFuture) Result(client ExpressRouteCircuitsClient) (erc ExpressRouteCircuit, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return erc, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		erc, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	erc, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ExpressRouteCircuitsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExpressRouteCircuitsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitsDeleteFuture) Result(client ExpressRouteCircuitsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ExpressRouteCircuitServiceProviderProperties contains ServiceProviderProperties in an ExpressRouteCircuit.
type ExpressRouteCircuitServiceProviderProperties struct {
	// ServiceProviderName - The serviceProviderName.
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
	// PeeringLocation - The peering location.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// BandwidthInMbps - The BandwidthInMbps.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`
}

// ExpressRouteCircuitSku contains SKU in an ExpressRouteCircuit.
type ExpressRouteCircuitSku struct {
	// Name - The name of the SKU.
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the SKU. Possible values are 'Standard' and 'Premium'. Possible values include: 'ExpressRouteCircuitSkuTierStandard', 'ExpressRouteCircuitSkuTierPremium'
	Tier ExpressRouteCircuitSkuTier `json:"tier,omitempty"`
	// Family - The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'. Possible values include: 'UnlimitedData', 'MeteredData'
	Family ExpressRouteCircuitSkuFamily `json:"family,omitempty"`
}

// ExpressRouteCircuitsListArpTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsListArpTableFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitsListArpTableFuture) Result(client ExpressRouteCircuitsClient) (ercatlr ExpressRouteCircuitsArpTableListResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListArpTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ercatlr, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsListArpTableFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ercatlr, err = client.ListArpTableResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListArpTableFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListArpTableFuture", "Result", resp, "Failure sending request")
		return
	}
	ercatlr, err = client.ListArpTableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListArpTableFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ExpressRouteCircuitsListRoutesTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsListRoutesTableFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitsListRoutesTableFuture) Result(client ExpressRouteCircuitsClient) (ercrtlr ExpressRouteCircuitsRoutesTableListResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListRoutesTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ercrtlr, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsListRoutesTableFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ercrtlr, err = client.ListRoutesTableResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListRoutesTableFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListRoutesTableFuture", "Result", resp, "Failure sending request")
		return
	}
	ercrtlr, err = client.ListRoutesTableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListRoutesTableFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ExpressRouteCircuitsListRoutesTableSummaryFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsListRoutesTableSummaryFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitsListRoutesTableSummaryFuture) Result(client ExpressRouteCircuitsClient) (ercrtslr ExpressRouteCircuitsRoutesTableSummaryListResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListRoutesTableSummaryFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ercrtslr, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsListRoutesTableSummaryFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ercrtslr, err = client.ListRoutesTableSummaryResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListRoutesTableSummaryFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListRoutesTableSummaryFuture", "Result", resp, "Failure sending request")
		return
	}
	ercrtslr, err = client.ListRoutesTableSummaryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListRoutesTableSummaryFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ExpressRouteCircuitsRoutesTableListResult response for ListRoutesTable associated with the Express Route
// Circuits API.
type ExpressRouteCircuitsRoutesTableListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of routes table.
	Value *[]ExpressRouteCircuitRoutesTable `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsRoutesTableSummaryListResult response for ListRoutesTable associated with the Express Route
// Circuits API.
type ExpressRouteCircuitsRoutesTableSummaryListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of the routes table.
	Value *[]ExpressRouteCircuitRoutesTableSummary `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitStats contains stats associated with the peering.
type ExpressRouteCircuitStats struct {
	autorest.Response `json:"-"`
	// PrimarybytesIn - Gets BytesIn of the peering.
	PrimarybytesIn *int64 `json:"primarybytesIn,omitempty"`
	// PrimarybytesOut - Gets BytesOut of the peering.
	PrimarybytesOut *int64 `json:"primarybytesOut,omitempty"`
	// SecondarybytesIn - Gets BytesIn of the peering.
	SecondarybytesIn *int64 `json:"secondarybytesIn,omitempty"`
	// SecondarybytesOut - Gets BytesOut of the peering.
	SecondarybytesOut *int64 `json:"secondarybytesOut,omitempty"`
}

// ExpressRouteServiceProvider a ExpressRouteResourceProvider object.
type ExpressRouteServiceProvider struct {
	*ExpressRouteServiceProviderPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteServiceProvider.
func (ersp ExpressRouteServiceProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ersp.ExpressRouteServiceProviderPropertiesFormat != nil {
		objectMap["properties"] = ersp.ExpressRouteServiceProviderPropertiesFormat
	}
	if ersp.ID != nil {
		objectMap["id"] = ersp.ID
	}
	if ersp.Name != nil {
		objectMap["name"] = ersp.Name
	}
	if ersp.Type != nil {
		objectMap["type"] = ersp.Type
	}
	if ersp.Location != nil {
		objectMap["location"] = ersp.Location
	}
	if ersp.Tags != nil {
		objectMap["tags"] = ersp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteServiceProvider struct.
func (ersp *ExpressRouteServiceProvider) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteServiceProviderPropertiesFormat ExpressRouteServiceProviderPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteServiceProviderPropertiesFormat)
				if err != nil {
					return err
				}
				ersp.ExpressRouteServiceProviderPropertiesFormat = &expressRouteServiceProviderPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ersp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ersp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ersp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ersp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ersp.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteServiceProviderBandwidthsOffered contains bandwidths offered in ExpressRouteServiceProvider
// resources.
type ExpressRouteServiceProviderBandwidthsOffered struct {
	// OfferName - The OfferName.
	OfferName *string `json:"offerName,omitempty"`
	// ValueInMbps - The ValueInMbps.
	ValueInMbps *int32 `json:"valueInMbps,omitempty"`
}

// ExpressRouteServiceProviderListResult response for the ListExpressRouteServiceProvider API service call.
type ExpressRouteServiceProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRouteResourceProvider resources.
	Value *[]ExpressRouteServiceProvider `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteServiceProviderListResultIterator provides access to a complete listing of
// ExpressRouteServiceProvider values.
type ExpressRouteServiceProviderListResultIterator struct {
	i    int
	page ExpressRouteServiceProviderListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteServiceProviderListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteServiceProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteServiceProviderListResultIterator) Response() ExpressRouteServiceProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteServiceProviderListResultIterator) Value() ExpressRouteServiceProvider {
	if !iter.page.NotDone() {
		return ExpressRouteServiceProvider{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ersplr ExpressRouteServiceProviderListResult) IsEmpty() bool {
	return ersplr.Value == nil || len(*ersplr.Value) == 0
}

// expressRouteServiceProviderListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ersplr ExpressRouteServiceProviderListResult) expressRouteServiceProviderListResultPreparer() (*http.Request, error) {
	if ersplr.NextLink == nil || len(to.String(ersplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ersplr.NextLink)))
}

// ExpressRouteServiceProviderListResultPage contains a page of ExpressRouteServiceProvider values.
type ExpressRouteServiceProviderListResultPage struct {
	fn     func(ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)
	ersplr ExpressRouteServiceProviderListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteServiceProviderListResultPage) Next() error {
	next, err := page.fn(page.ersplr)
	if err != nil {
		return err
	}
	page.ersplr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteServiceProviderListResultPage) NotDone() bool {
	return !page.ersplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteServiceProviderListResultPage) Response() ExpressRouteServiceProviderListResult {
	return page.ersplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteServiceProviderListResultPage) Values() []ExpressRouteServiceProvider {
	if page.ersplr.IsEmpty() {
		return nil
	}
	return *page.ersplr.Value
}

// ExpressRouteServiceProviderPropertiesFormat properties of ExpressRouteServiceProvider.
type ExpressRouteServiceProviderPropertiesFormat struct {
	// PeeringLocations - Get a list of peering locations.
	PeeringLocations *[]string `json:"peeringLocations,omitempty"`
	// BandwidthsOffered - Gets bandwidths offered.
	BandwidthsOffered *[]ExpressRouteServiceProviderBandwidthsOffered `json:"bandwidthsOffered,omitempty"`
	// ProvisioningState - Gets the provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// FlowLogInformation information on the configuration of flow log.
type FlowLogInformation struct {
	autorest.Response `json:"-"`
	// TargetResourceID - The ID of the resource to configure for flow logging.
	TargetResourceID   *string `json:"targetResourceId,omitempty"`
	*FlowLogProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for FlowLogInformation.
func (fli FlowLogInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fli.TargetResourceID != nil {
		objectMap["targetResourceId"] = fli.TargetResourceID
	}
	if fli.FlowLogProperties != nil {
		objectMap["properties"] = fli.FlowLogProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FlowLogInformation struct.
func (fli *FlowLogInformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "targetResourceId":
			if v != nil {
				var targetResourceID string
				err = json.Unmarshal(*v, &targetResourceID)
				if err != nil {
					return err
				}
				fli.TargetResourceID = &targetResourceID
			}
		case "properties":
			if v != nil {
				var flowLogProperties FlowLogProperties
				err = json.Unmarshal(*v, &flowLogProperties)
				if err != nil {
					return err
				}
				fli.FlowLogProperties = &flowLogProperties
			}
		}
	}

	return nil
}

// FlowLogProperties parameters that define the configuration of flow log.
type FlowLogProperties struct {
	// StorageID - ID of the storage account which is used to store the flow log.
	StorageID *string `json:"storageId,omitempty"`
	// Enabled - Flag to enable/disable flow logging.
	Enabled         *bool                      `json:"enabled,omitempty"`
	RetentionPolicy *RetentionPolicyParameters `json:"retentionPolicy,omitempty"`
}

// FlowLogStatusParameters parameters that define a resource to query flow log status.
type FlowLogStatusParameters struct {
	// TargetResourceID - The target resource where getting the flow logging status.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// FrontendIPConfiguration frontend IP address of the load balancer.
type FrontendIPConfiguration struct {
	*FrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for FrontendIPConfiguration.
func (fic FrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fic.FrontendIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = fic.FrontendIPConfigurationPropertiesFormat
	}
	if fic.Name != nil {
		objectMap["name"] = fic.Name
	}
	if fic.Etag != nil {
		objectMap["etag"] = fic.Etag
	}
	if fic.ID != nil {
		objectMap["id"] = fic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FrontendIPConfiguration struct.
func (fic *FrontendIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var frontendIPConfigurationPropertiesFormat FrontendIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &frontendIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				fic.FrontendIPConfigurationPropertiesFormat = &frontendIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fic.ID = &ID
			}
		}
	}

	return nil
}

// FrontendIPConfigurationPropertiesFormat properties of Frontend IP Configuration of the load balancer.
type FrontendIPConfigurationPropertiesFormat struct {
	// InboundNatRules - Read only. Inbound rules URIs that use this frontend IP.
	InboundNatRules *[]SubResource `json:"inboundNatRules,omitempty"`
	// InboundNatPools - Read only. Inbound pools URIs that use this frontend IP.
	InboundNatPools *[]SubResource `json:"inboundNatPools,omitempty"`
	// OutboundNatRules - Read only. Outbound rules URIs that use this frontend IP.
	OutboundNatRules *[]SubResource `json:"outboundNatRules,omitempty"`
	// LoadBalancingRules - Gets load balancing rules URIs that use this frontend IP.
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// PrivateIPAddress - The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The Private IP allocation method. Possible values are: 'Static' and 'Dynamic'. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - The reference of the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`
	// PublicIPAddress - The reference of the Public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// GatewayRoute gateway routing details
type GatewayRoute struct {
	// LocalAddress - The gateway's local address
	LocalAddress *string `json:"localAddress,omitempty"`
	// NetworkProperty - The route's network prefix
	NetworkProperty *string `json:"network,omitempty"`
	// NextHop - The route's next hop
	NextHop *string `json:"nextHop,omitempty"`
	// SourcePeer - The peer this route was learned from
	SourcePeer *string `json:"sourcePeer,omitempty"`
	// Origin - The source this route was learned from
	Origin *string `json:"origin,omitempty"`
	// AsPath - The route's AS path sequence
	AsPath *string `json:"asPath,omitempty"`
	// Weight - The route's weight
	Weight *int32 `json:"weight,omitempty"`
}

// GatewayRouteListResult list of virtual network gateway routes
type GatewayRouteListResult struct {
	autorest.Response `json:"-"`
	// Value - List of gateway routes
	Value *[]GatewayRoute `json:"value,omitempty"`
}

// InboundNatPool inbound NAT pool of the load balancer.
type InboundNatPool struct {
	*InboundNatPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatPool.
func (inp InboundNatPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inp.InboundNatPoolPropertiesFormat != nil {
		objectMap["properties"] = inp.InboundNatPoolPropertiesFormat
	}
	if inp.Name != nil {
		objectMap["name"] = inp.Name
	}
	if inp.Etag != nil {
		objectMap["etag"] = inp.Etag
	}
	if inp.ID != nil {
		objectMap["id"] = inp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InboundNatPool struct.
func (inp *InboundNatPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundNatPoolPropertiesFormat InboundNatPoolPropertiesFormat
				err = json.Unmarshal(*v, &inboundNatPoolPropertiesFormat)
				if err != nil {
					return err
				}
				inp.InboundNatPoolPropertiesFormat = &inboundNatPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				inp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				inp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				inp.ID = &ID
			}
		}
	}

	return nil
}

// InboundNatPoolPropertiesFormat properties of Inbound NAT pool.
type InboundNatPoolPropertiesFormat struct {
	// FrontendIPConfiguration - A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// Protocol - The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPortRangeStart - The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`
	// FrontendPortRangeEnd - The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`
	// BackendPort - The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// ProvisioningState - Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// InboundNatRule inbound NAT rule of the load balancer.
type InboundNatRule struct {
	*InboundNatRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatRule.
func (inr InboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inr.InboundNatRulePropertiesFormat != nil {
		objectMap["properties"] = inr.InboundNatRulePropertiesFormat
	}
	if inr.Name != nil {
		objectMap["name"] = inr.Name
	}
	if inr.Etag != nil {
		objectMap["etag"] = inr.Etag
	}
	if inr.ID != nil {
		objectMap["id"] = inr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InboundNatRule struct.
func (inr *InboundNatRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundNatRulePropertiesFormat InboundNatRulePropertiesFormat
				err = json.Unmarshal(*v, &inboundNatRulePropertiesFormat)
				if err != nil {
					return err
				}
				inr.InboundNatRulePropertiesFormat = &inboundNatRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				inr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				inr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				inr.ID = &ID
			}
		}
	}

	return nil
}

// InboundNatRulePropertiesFormat properties of the inbound NAT rule.
type InboundNatRulePropertiesFormat struct {
	// FrontendIPConfiguration - A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// BackendIPConfiguration - A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backed IP.
	BackendIPConfiguration *InterfaceIPConfiguration `json:"backendIPConfiguration,omitempty"`
	// Protocol - The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPort - The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - The port used for the internal endpoint. Acceptable values range from 1 to 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Interface a network interface in a resource group.
type Interface struct {
	autorest.Response          `json:"-"`
	*InterfacePropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Interface.
func (i Interface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.InterfacePropertiesFormat != nil {
		objectMap["properties"] = i.InterfacePropertiesFormat
	}
	if i.Etag != nil {
		objectMap["etag"] = i.Etag
	}
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Name != nil {
		objectMap["name"] = i.Name
	}
	if i.Type != nil {
		objectMap["type"] = i.Type
	}
	if i.Location != nil {
		objectMap["location"] = i.Location
	}
	if i.Tags != nil {
		objectMap["tags"] = i.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Interface struct.
func (i *Interface) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfacePropertiesFormat InterfacePropertiesFormat
				err = json.Unmarshal(*v, &interfacePropertiesFormat)
				if err != nil {
					return err
				}
				i.InterfacePropertiesFormat = &interfacePropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				i.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				i.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				i.Tags = tags
			}
		}
	}

	return nil
}

// InterfaceAssociation network interface and its custom security rules.
type InterfaceAssociation struct {
	// ID - Network interface ID.
	ID *string `json:"id,omitempty"`
	// SecurityRules - Collection of custom security rules.
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
}

// InterfaceDNSSettings DNS settings of a network interface.
type InterfaceDNSSettings struct {
	// DNSServers - List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
	DNSServers *[]string `json:"dnsServers,omitempty"`
	// AppliedDNSServers - If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs.
	AppliedDNSServers *[]string `json:"appliedDnsServers,omitempty"`
	// InternalDNSNameLabel - Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
	InternalDNSNameLabel *string `json:"internalDnsNameLabel,omitempty"`
	// InternalFqdn - Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
	InternalFqdn *string `json:"internalFqdn,omitempty"`
	// InternalDomainNameSuffix - Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix.
	InternalDomainNameSuffix *string `json:"internalDomainNameSuffix,omitempty"`
}

// InterfaceIPConfiguration iPConfiguration in a network interface.
type InterfaceIPConfiguration struct {
	*InterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceIPConfiguration.
func (iic InterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iic.InterfaceIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = iic.InterfaceIPConfigurationPropertiesFormat
	}
	if iic.Name != nil {
		objectMap["name"] = iic.Name
	}
	if iic.Etag != nil {
		objectMap["etag"] = iic.Etag
	}
	if iic.ID != nil {
		objectMap["id"] = iic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InterfaceIPConfiguration struct.
func (iic *InterfaceIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfaceIPConfigurationPropertiesFormat InterfaceIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &interfaceIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				iic.InterfaceIPConfigurationPropertiesFormat = &interfaceIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				iic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iic.ID = &ID
			}
		}
	}

	return nil
}

// InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
type InterfaceIPConfigurationPropertiesFormat struct {
	// ApplicationGatewayBackendAddressPools - The reference of ApplicationGatewayBackendAddressPool resource.
	ApplicationGatewayBackendAddressPools *[]ApplicationGatewayBackendAddressPool `json:"applicationGatewayBackendAddressPools,omitempty"`
	// LoadBalancerBackendAddressPools - The reference of LoadBalancerBackendAddressPool resource.
	LoadBalancerBackendAddressPools *[]BackendAddressPool `json:"loadBalancerBackendAddressPools,omitempty"`
	// LoadBalancerInboundNatRules - A list of references of LoadBalancerInboundNatRules.
	LoadBalancerInboundNatRules *[]InboundNatRule `json:"loadBalancerInboundNatRules,omitempty"`
	PrivateIPAddress            *string           `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - Defines how a private IP address is assigned. Possible values are: 'Static' and 'Dynamic'. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// PrivateIPAddressVersion - Available from Api-Version 2016-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'. Possible values include: 'IPv4', 'IPv6'
	PrivateIPAddressVersion IPVersion `json:"privateIPAddressVersion,omitempty"`
	Subnet                  *Subnet   `json:"subnet,omitempty"`
	// Primary - Gets whether this is a primary customer address on the network interface.
	Primary           *bool            `json:"primary,omitempty"`
	PublicIPAddress   *PublicIPAddress `json:"publicIPAddress,omitempty"`
	ProvisioningState *string          `json:"provisioningState,omitempty"`
}

// InterfaceListResult response for the ListNetworkInterface API service call.
type InterfaceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of network interfaces in a resource group.
	Value *[]Interface `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InterfaceListResultIterator provides access to a complete listing of Interface values.
type InterfaceListResultIterator struct {
	i    int
	page InterfaceListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InterfaceListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InterfaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InterfaceListResultIterator) Response() InterfaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InterfaceListResultIterator) Value() Interface {
	if !iter.page.NotDone() {
		return Interface{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InterfaceListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// interfaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InterfaceListResult) interfaceListResultPreparer() (*http.Request, error) {
	if ilr.NextLink == nil || len(to.String(ilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InterfaceListResultPage contains a page of Interface values.
type InterfaceListResultPage struct {
	fn  func(InterfaceListResult) (InterfaceListResult, error)
	ilr InterfaceListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InterfaceListResultPage) Next() error {
	next, err := page.fn(page.ilr)
	if err != nil {
		return err
	}
	page.ilr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InterfaceListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InterfaceListResultPage) Response() InterfaceListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InterfaceListResultPage) Values() []Interface {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// InterfacePropertiesFormat networkInterface properties.
type InterfacePropertiesFormat struct {
	// VirtualMachine - The reference of a virtual machine.
	VirtualMachine *SubResource `json:"virtualMachine,omitempty"`
	// NetworkSecurityGroup - The reference of the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`
	// IPConfigurations - A list of IPConfigurations of the network interface.
	IPConfigurations *[]InterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	// DNSSettings - The DNS settings in network interface.
	DNSSettings *InterfaceDNSSettings `json:"dnsSettings,omitempty"`
	// MacAddress - The MAC address of the network interface.
	MacAddress *string `json:"macAddress,omitempty"`
	// Primary - Gets whether this is a primary network interface on a virtual machine.
	Primary *bool `json:"primary,omitempty"`
	// EnableAcceleratedNetworking - If the network interface is accelerated networking enabled.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`
	// EnableIPForwarding - Indicates whether IP forwarding is enabled on this network interface.
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`
	// ResourceGUID - The resource GUID property of the network interface resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// InterfacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InterfacesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future InterfacesCreateOrUpdateFuture) Result(client InterfacesClient) (i Interface, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return i, azure.NewAsyncOpIncompleteError("network.InterfacesCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		i, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InterfacesCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	i, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// InterfacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type InterfacesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future InterfacesDeleteFuture) Result(client InterfacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.InterfacesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InterfacesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// InterfacesGetEffectiveRouteTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InterfacesGetEffectiveRouteTableFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future InterfacesGetEffectiveRouteTableFuture) Result(client InterfacesClient) (erlr EffectiveRouteListResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesGetEffectiveRouteTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return erlr, azure.NewAsyncOpIncompleteError("network.InterfacesGetEffectiveRouteTableFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		erlr, err = client.GetEffectiveRouteTableResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InterfacesGetEffectiveRouteTableFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesGetEffectiveRouteTableFuture", "Result", resp, "Failure sending request")
		return
	}
	erlr, err = client.GetEffectiveRouteTableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesGetEffectiveRouteTableFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// InterfacesListEffectiveNetworkSecurityGroupsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InterfacesListEffectiveNetworkSecurityGroupsFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future InterfacesListEffectiveNetworkSecurityGroupsFuture) Result(client InterfacesClient) (ensglr EffectiveNetworkSecurityGroupListResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesListEffectiveNetworkSecurityGroupsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ensglr, azure.NewAsyncOpIncompleteError("network.InterfacesListEffectiveNetworkSecurityGroupsFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ensglr, err = client.ListEffectiveNetworkSecurityGroupsResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InterfacesListEffectiveNetworkSecurityGroupsFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesListEffectiveNetworkSecurityGroupsFuture", "Result", resp, "Failure sending request")
		return
	}
	ensglr, err = client.ListEffectiveNetworkSecurityGroupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesListEffectiveNetworkSecurityGroupsFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// IPAddressAvailabilityResult response for CheckIPAddressAvailability API service call
type IPAddressAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Available - Private IP address availability.
	Available *bool `json:"available,omitempty"`
	// AvailableIPAddresses - Contains other available private IP addresses if the asked for address is taken.
	AvailableIPAddresses *[]string `json:"availableIPAddresses,omitempty"`
}

// IPConfiguration iPConfiguration
type IPConfiguration struct {
	*IPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for IPConfiguration.
func (ic IPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ic.IPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = ic.IPConfigurationPropertiesFormat
	}
	if ic.Name != nil {
		objectMap["name"] = ic.Name
	}
	if ic.Etag != nil {
		objectMap["etag"] = ic.Etag
	}
	if ic.ID != nil {
		objectMap["id"] = ic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IPConfiguration struct.
func (ic *IPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var IPConfigurationPropertiesFormat IPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &IPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				ic.IPConfigurationPropertiesFormat = &IPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ic.ID = &ID
			}
		}
	}

	return nil
}

// IPConfigurationPropertiesFormat properties of IP configuration.
type IPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The private IP allocation method. Possible values are 'Static' and 'Dynamic'. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - The reference of the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`
	// PublicIPAddress - The reference of the public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// IpsecPolicy an IPSec Policy configuration for a virtual network gateway connection
type IpsecPolicy struct {
	// SaLifeTimeSeconds - The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
	SaLifeTimeSeconds *int32 `json:"saLifeTimeSeconds,omitempty"`
	// SaDataSizeKilobytes - The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
	SaDataSizeKilobytes *int32 `json:"saDataSizeKilobytes,omitempty"`
	// IpsecEncryption - The IPSec encryption algorithm (IKE phase 1). Possible values include: 'IpsecEncryptionNone', 'IpsecEncryptionDES', 'IpsecEncryptionDES3', 'IpsecEncryptionAES128', 'IpsecEncryptionAES192', 'IpsecEncryptionAES256', 'IpsecEncryptionGCMAES128', 'IpsecEncryptionGCMAES192', 'IpsecEncryptionGCMAES256'
	IpsecEncryption IpsecEncryption `json:"ipsecEncryption,omitempty"`
	// IpsecIntegrity - The IPSec integrity algorithm (IKE phase 1). Possible values include: 'IpsecIntegrityMD5', 'IpsecIntegritySHA1', 'IpsecIntegritySHA256', 'IpsecIntegrityGCMAES128', 'IpsecIntegrityGCMAES192', 'IpsecIntegrityGCMAES256'
	IpsecIntegrity IpsecIntegrity `json:"ipsecIntegrity,omitempty"`
	// IkeEncryption - The IKE encryption algorithm (IKE phase 2). Possible values include: 'DES', 'DES3', 'AES128', 'AES192', 'AES256'
	IkeEncryption IkeEncryption `json:"ikeEncryption,omitempty"`
	// IkeIntegrity - The IKE integrity algorithm (IKE phase 2). Possible values include: 'MD5', 'SHA1', 'SHA256', 'SHA384'
	IkeIntegrity IkeIntegrity `json:"ikeIntegrity,omitempty"`
	// DhGroup - The DH Groups used in IKE Phase 1 for initial SA. Possible values include: 'None', 'DHGroup1', 'DHGroup2', 'DHGroup14', 'DHGroup2048', 'ECP256', 'ECP384', 'DHGroup24'
	DhGroup DhGroup `json:"dhGroup,omitempty"`
	// PfsGroup - The DH Groups used in IKE Phase 2 for new child SA. Possible values include: 'PfsGroupNone', 'PfsGroupPFS1', 'PfsGroupPFS2', 'PfsGroupPFS2048', 'PfsGroupECP256', 'PfsGroupECP384', 'PfsGroupPFS24'
	PfsGroup PfsGroup `json:"pfsGroup,omitempty"`
}

// Ipv6ExpressRouteCircuitPeeringConfig contains IPv6 peering config.
type Ipv6ExpressRouteCircuitPeeringConfig struct {
	// PrimaryPeerAddressPrefix - The primary address prefix.
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`
	// SecondaryPeerAddressPrefix - The secondary address prefix.
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`
	// MicrosoftPeeringConfig - The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`
	// RouteFilter - The reference of the RouteFilter resource.
	RouteFilter *RouteFilter `json:"routeFilter,omitempty"`
	// State - The state of peering. Possible values are: 'Disabled' and 'Enabled'. Possible values include: 'ExpressRouteCircuitPeeringStateDisabled', 'ExpressRouteCircuitPeeringStateEnabled'
	State ExpressRouteCircuitPeeringState `json:"state,omitempty"`
}

// LoadBalancer loadBalancer resource
type LoadBalancer struct {
	autorest.Response             `json:"-"`
	*LoadBalancerPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LoadBalancer.
func (lb LoadBalancer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lb.LoadBalancerPropertiesFormat != nil {
		objectMap["properties"] = lb.LoadBalancerPropertiesFormat
	}
	if lb.Etag != nil {
		objectMap["etag"] = lb.Etag
	}
	if lb.ID != nil {
		objectMap["id"] = lb.ID
	}
	if lb.Name != nil {
		objectMap["name"] = lb.Name
	}
	if lb.Type != nil {
		objectMap["type"] = lb.Type
	}
	if lb.Location != nil {
		objectMap["location"] = lb.Location
	}
	if lb.Tags != nil {
		objectMap["tags"] = lb.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoadBalancer struct.
func (lb *LoadBalancer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loadBalancerPropertiesFormat LoadBalancerPropertiesFormat
				err = json.Unmarshal(*v, &loadBalancerPropertiesFormat)
				if err != nil {
					return err
				}
				lb.LoadBalancerPropertiesFormat = &loadBalancerPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lb.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lb.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lb.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lb.Tags = tags
			}
		}
	}

	return nil
}

// LoadBalancerListResult response for ListLoadBalancers API service call.
type LoadBalancerListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of load balancers in a resource group.
	Value *[]LoadBalancer `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LoadBalancerListResultIterator provides access to a complete listing of LoadBalancer values.
type LoadBalancerListResultIterator struct {
	i    int
	page LoadBalancerListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoadBalancerListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoadBalancerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoadBalancerListResultIterator) Response() LoadBalancerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoadBalancerListResultIterator) Value() LoadBalancer {
	if !iter.page.NotDone() {
		return LoadBalancer{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lblr LoadBalancerListResult) IsEmpty() bool {
	return lblr.Value == nil || len(*lblr.Value) == 0
}

// loadBalancerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lblr LoadBalancerListResult) loadBalancerListResultPreparer() (*http.Request, error) {
	if lblr.NextLink == nil || len(to.String(lblr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lblr.NextLink)))
}

// LoadBalancerListResultPage contains a page of LoadBalancer values.
type LoadBalancerListResultPage struct {
	fn   func(LoadBalancerListResult) (LoadBalancerListResult, error)
	lblr LoadBalancerListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoadBalancerListResultPage) Next() error {
	next, err := page.fn(page.lblr)
	if err != nil {
		return err
	}
	page.lblr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoadBalancerListResultPage) NotDone() bool {
	return !page.lblr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoadBalancerListResultPage) Response() LoadBalancerListResult {
	return page.lblr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoadBalancerListResultPage) Values() []LoadBalancer {
	if page.lblr.IsEmpty() {
		return nil
	}
	return *page.lblr.Value
}

// LoadBalancerPropertiesFormat properties of the load balancer.
type LoadBalancerPropertiesFormat struct {
	// FrontendIPConfigurations - Object representing the frontend IPs to be used for the load balancer
	FrontendIPConfigurations *[]FrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	// BackendAddressPools - Collection of backend address pools used by a load balancer
	BackendAddressPools *[]BackendAddressPool `json:"backendAddressPools,omitempty"`
	// LoadBalancingRules - Object collection representing the load balancing rules Gets the provisioning
	LoadBalancingRules *[]LoadBalancingRule `json:"loadBalancingRules,omitempty"`
	// Probes - Collection of probe objects used in the load balancer
	Probes *[]Probe `json:"probes,omitempty"`
	// InboundNatRules - Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
	InboundNatRules *[]InboundNatRule `json:"inboundNatRules,omitempty"`
	// InboundNatPools - Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
	InboundNatPools *[]InboundNatPool `json:"inboundNatPools,omitempty"`
	// OutboundNatRules - The outbound NAT rules.
	OutboundNatRules *[]OutboundNatRule `json:"outboundNatRules,omitempty"`
	// ResourceGUID - The resource GUID property of the load balancer resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LoadBalancersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LoadBalancersCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future LoadBalancersCreateOrUpdateFuture) Result(client LoadBalancersClient) (lb LoadBalancer, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return lb, azure.NewAsyncOpIncompleteError("network.LoadBalancersCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		lb, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.LoadBalancersCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	lb, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// LoadBalancersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type LoadBalancersDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future LoadBalancersDeleteFuture) Result(client LoadBalancersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.LoadBalancersDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.LoadBalancersDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// LoadBalancingRule a load balancing rule for a load balancer.
type LoadBalancingRule struct {
	*LoadBalancingRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancingRule.
func (lbr LoadBalancingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lbr.LoadBalancingRulePropertiesFormat != nil {
		objectMap["properties"] = lbr.LoadBalancingRulePropertiesFormat
	}
	if lbr.Name != nil {
		objectMap["name"] = lbr.Name
	}
	if lbr.Etag != nil {
		objectMap["etag"] = lbr.Etag
	}
	if lbr.ID != nil {
		objectMap["id"] = lbr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoadBalancingRule struct.
func (lbr *LoadBalancingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loadBalancingRulePropertiesFormat LoadBalancingRulePropertiesFormat
				err = json.Unmarshal(*v, &loadBalancingRulePropertiesFormat)
				if err != nil {
					return err
				}
				lbr.LoadBalancingRulePropertiesFormat = &loadBalancingRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lbr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lbr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lbr.ID = &ID
			}
		}
	}

	return nil
}

// LoadBalancingRulePropertiesFormat properties of the load balancer.
type LoadBalancingRulePropertiesFormat struct {
	// FrontendIPConfiguration - A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// BackendAddressPool - A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// Probe - The reference of the load balancer probe used by the load balancing rule.
	Probe *SubResource `json:"probe,omitempty"`
	// Protocol - The transport protocol for the external endpoint. Possible values are 'Udp' or 'Tcp'. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// LoadDistribution - The load distribution policy for this rule. Possible values are 'Default', 'SourceIP', and 'SourceIPProtocol'. Possible values include: 'Default', 'SourceIP', 'SourceIPProtocol'
	LoadDistribution LoadDistribution `json:"loadDistribution,omitempty"`
	// FrontendPort - The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// ProvisioningState - Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LocalNetworkGateway a common class for general resource information
type LocalNetworkGateway struct {
	autorest.Response                    `json:"-"`
	*LocalNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LocalNetworkGateway.
func (lng LocalNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lng.LocalNetworkGatewayPropertiesFormat != nil {
		objectMap["properties"] = lng.LocalNetworkGatewayPropertiesFormat
	}
	if lng.Etag != nil {
		objectMap["etag"] = lng.Etag
	}
	if lng.ID != nil {
		objectMap["id"] = lng.ID
	}
	if lng.Name != nil {
		objectMap["name"] = lng.Name
	}
	if lng.Type != nil {
		objectMap["type"] = lng.Type
	}
	if lng.Location != nil {
		objectMap["location"] = lng.Location
	}
	if lng.Tags != nil {
		objectMap["tags"] = lng.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LocalNetworkGateway struct.
func (lng *LocalNetworkGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var localNetworkGatewayPropertiesFormat LocalNetworkGatewayPropertiesFormat
				err = json.Unmarshal(*v, &localNetworkGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				lng.LocalNetworkGatewayPropertiesFormat = &localNetworkGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lng.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lng.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lng.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lng.Tags = tags
			}
		}
	}

	return nil
}

// LocalNetworkGatewayListResult response for ListLocalNetworkGateways API service call.
type LocalNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of local network gateways that exists in a resource group.
	Value *[]LocalNetworkGateway `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LocalNetworkGatewayListResultIterator provides access to a complete listing of LocalNetworkGateway values.
type LocalNetworkGatewayListResultIterator struct {
	i    int
	page LocalNetworkGatewayListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LocalNetworkGatewayListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LocalNetworkGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LocalNetworkGatewayListResultIterator) Response() LocalNetworkGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LocalNetworkGatewayListResultIterator) Value() LocalNetworkGateway {
	if !iter.page.NotDone() {
		return LocalNetworkGateway{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lnglr LocalNetworkGatewayListResult) IsEmpty() bool {
	return lnglr.Value == nil || len(*lnglr.Value) == 0
}

// localNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lnglr LocalNetworkGatewayListResult) localNetworkGatewayListResultPreparer() (*http.Request, error) {
	if lnglr.NextLink == nil || len(to.String(lnglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lnglr.NextLink)))
}

// LocalNetworkGatewayListResultPage contains a page of LocalNetworkGateway values.
type LocalNetworkGatewayListResultPage struct {
	fn    func(LocalNetworkGatewayListResult) (LocalNetworkGatewayListResult, error)
	lnglr LocalNetworkGatewayListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LocalNetworkGatewayListResultPage) Next() error {
	next, err := page.fn(page.lnglr)
	if err != nil {
		return err
	}
	page.lnglr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LocalNetworkGatewayListResultPage) NotDone() bool {
	return !page.lnglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LocalNetworkGatewayListResultPage) Response() LocalNetworkGatewayListResult {
	return page.lnglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LocalNetworkGatewayListResultPage) Values() []LocalNetworkGateway {
	if page.lnglr.IsEmpty() {
		return nil
	}
	return *page.lnglr.Value
}

// LocalNetworkGatewayPropertiesFormat localNetworkGateway properties
type LocalNetworkGatewayPropertiesFormat struct {
	// LocalNetworkAddressSpace - Local network site address space.
	LocalNetworkAddressSpace *AddressSpace `json:"localNetworkAddressSpace,omitempty"`
	// GatewayIPAddress - IP address of local network gateway.
	GatewayIPAddress *string `json:"gatewayIpAddress,omitempty"`
	// BgpSettings - Local network gateway's BGP speaker settings.
	BgpSettings *BgpSettings `json:"bgpSettings,omitempty"`
	// ResourceGUID - The resource GUID property of the LocalNetworkGateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the LocalNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LocalNetworkGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LocalNetworkGatewaysCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future LocalNetworkGatewaysCreateOrUpdateFuture) Result(client LocalNetworkGatewaysClient) (lng LocalNetworkGateway, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return lng, azure.NewAsyncOpIncompleteError("network.LocalNetworkGatewaysCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		lng, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	lng, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// LocalNetworkGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LocalNetworkGatewaysDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future LocalNetworkGatewaysDeleteFuture) Result(client LocalNetworkGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.LocalNetworkGatewaysDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// NextHopParameters parameters that define the source and destination endpoint.
type NextHopParameters struct {
	// TargetResourceID - The resource identifier of the target resource against which the action is to be performed.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// SourceIPAddress - The source IP address.
	SourceIPAddress *string `json:"sourceIPAddress,omitempty"`
	// DestinationIPAddress - The destination IP address.
	DestinationIPAddress *string `json:"destinationIPAddress,omitempty"`
	// TargetNicResourceID - The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of the nics, then this parameter must be specified. Otherwise optional).
	TargetNicResourceID *string `json:"targetNicResourceId,omitempty"`
}

// NextHopResult the information about next hop from the specified VM.
type NextHopResult struct {
	autorest.Response `json:"-"`
	// NextHopType - Next hop type. Possible values include: 'NextHopTypeInternet', 'NextHopTypeVirtualAppliance', 'NextHopTypeVirtualNetworkGateway', 'NextHopTypeVnetLocal', 'NextHopTypeHyperNetGateway', 'NextHopTypeNone'
	NextHopType NextHopType `json:"nextHopType,omitempty"`
	// NextHopIPAddress - Next hop IP Address
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`
	// RouteTableID - The resource identifier for the route table associated with the route being returned. If the route being returned does not correspond to any user created routes then this field will be the string 'System Route'.
	RouteTableID *string `json:"routeTableId,omitempty"`
}

// OutboundNatRule outbound NAT pool of the load balancer.
type OutboundNatRule struct {
	*OutboundNatRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundNatRule.
func (onr OutboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if onr.OutboundNatRulePropertiesFormat != nil {
		objectMap["properties"] = onr.OutboundNatRulePropertiesFormat
	}
	if onr.Name != nil {
		objectMap["name"] = onr.Name
	}
	if onr.Etag != nil {
		objectMap["etag"] = onr.Etag
	}
	if onr.ID != nil {
		objectMap["id"] = onr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OutboundNatRule struct.
func (onr *OutboundNatRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var outboundNatRulePropertiesFormat OutboundNatRulePropertiesFormat
				err = json.Unmarshal(*v, &outboundNatRulePropertiesFormat)
				if err != nil {
					return err
				}
				onr.OutboundNatRulePropertiesFormat = &outboundNatRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				onr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				onr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				onr.ID = &ID
			}
		}
	}

	return nil
}

// OutboundNatRulePropertiesFormat outbound NAT pool of the load balancer.
type OutboundNatRulePropertiesFormat struct {
	// AllocatedOutboundPorts - The number of outbound ports to be used for NAT.
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`
	// FrontendIPConfigurations - The Frontend IP addresses of the load balancer.
	FrontendIPConfigurations *[]SubResource `json:"frontendIPConfigurations,omitempty"`
	// BackendAddressPool - A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// ProvisioningState - Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// PacketCapture parameters that define the create packet capture operation.
type PacketCapture struct {
	*PacketCaptureParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PacketCapture.
func (pc PacketCapture) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.PacketCaptureParameters != nil {
		objectMap["properties"] = pc.PacketCaptureParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PacketCapture struct.
func (pc *PacketCapture) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var packetCaptureParameters PacketCaptureParameters
				err = json.Unmarshal(*v, &packetCaptureParameters)
				if err != nil {
					return err
				}
				pc.PacketCaptureParameters = &packetCaptureParameters
			}
		}
	}

	return nil
}

// PacketCaptureFilter filter that is applied to packet capture request. Multiple filters can be applied.
type PacketCaptureFilter struct {
	// Protocol - Protocol to be filtered on. Possible values include: 'TCP', 'UDP', 'Any'
	Protocol PcProtocol `json:"protocol,omitempty"`
	// LocalIPAddress - Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
	LocalIPAddress *string `json:"localIPAddress,omitempty"`
	// RemoteIPAddress - Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
	RemoteIPAddress *string `json:"remoteIPAddress,omitempty"`
	// LocalPort - Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
	LocalPort *string `json:"localPort,omitempty"`
	// RemotePort - Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
	RemotePort *string `json:"remotePort,omitempty"`
}

// PacketCaptureListResult list of packet capture sessions.
type PacketCaptureListResult struct {
	autorest.Response `json:"-"`
	// Value - Information about packet capture sessions.
	Value *[]PacketCaptureResult `json:"value,omitempty"`
}

// PacketCaptureParameters parameters that define the create packet capture operation.
type PacketCaptureParameters struct {
	// Target - The ID of the targeted resource, only VM is currently supported.
	Target *string `json:"target,omitempty"`
	// BytesToCapturePerPacket - Number of bytes captured per packet, the remaining bytes are truncated.
	BytesToCapturePerPacket *int32 `json:"bytesToCapturePerPacket,omitempty"`
	// TotalBytesPerSession - Maximum size of the capture output.
	TotalBytesPerSession *int32 `json:"totalBytesPerSession,omitempty"`
	// TimeLimitInSeconds - Maximum duration of the capture session in seconds.
	TimeLimitInSeconds *int32                        `json:"timeLimitInSeconds,omitempty"`
	StorageLocation    *PacketCaptureStorageLocation `json:"storageLocation,omitempty"`
	Filters            *[]PacketCaptureFilter        `json:"filters,omitempty"`
}

// PacketCaptureQueryStatusResult status of packet capture session.
type PacketCaptureQueryStatusResult struct {
	autorest.Response `json:"-"`
	// Name - The name of the packet capture resource.
	Name *string `json:"name,omitempty"`
	// ID - The ID of the packet capture resource.
	ID *string `json:"id,omitempty"`
	// CaptureStartTime - The start time of the packet capture session.
	CaptureStartTime *date.Time `json:"captureStartTime,omitempty"`
	// PacketCaptureStatus - The status of the packet capture session. Possible values include: 'PcStatusNotStarted', 'PcStatusRunning', 'PcStatusStopped', 'PcStatusError', 'PcStatusUnknown'
	PacketCaptureStatus PcStatus `json:"packetCaptureStatus,omitempty"`
	// StopReason - The reason the current packet capture session was stopped.
	StopReason *string `json:"stopReason,omitempty"`
	// PacketCaptureError - List of errors of packet capture session.
	PacketCaptureError *[]PcError `json:"packetCaptureError,omitempty"`
}

// PacketCaptureResult information about packet capture session.
type PacketCaptureResult struct {
	autorest.Response `json:"-"`
	// Name - Name of the packet capture session.
	Name *string `json:"name,omitempty"`
	// ID - ID of the packet capture operation.
	ID                             *string `json:"id,omitempty"`
	Etag                           *string `json:"etag,omitempty"`
	*PacketCaptureResultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PacketCaptureResult.
func (pcr PacketCaptureResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcr.Name != nil {
		objectMap["name"] = pcr.Name
	}
	if pcr.ID != nil {
		objectMap["id"] = pcr.ID
	}
	if pcr.Etag != nil {
		objectMap["etag"] = pcr.Etag
	}
	if pcr.PacketCaptureResultProperties != nil {
		objectMap["properties"] = pcr.PacketCaptureResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PacketCaptureResult struct.
func (pcr *PacketCaptureResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pcr.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pcr.ID = &ID
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pcr.Etag = &etag
			}
		case "properties":
			if v != nil {
				var packetCaptureResultProperties PacketCaptureResultProperties
				err = json.Unmarshal(*v, &packetCaptureResultProperties)
				if err != nil {
					return err
				}
				pcr.PacketCaptureResultProperties = &packetCaptureResultProperties
			}
		}
	}

	return nil
}

// PacketCaptureResultProperties describes the properties of a packet capture session.
type PacketCaptureResultProperties struct {
	// ProvisioningState - The provisioning state of the packet capture session. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Target - The ID of the targeted resource, only VM is currently supported.
	Target *string `json:"target,omitempty"`
	// BytesToCapturePerPacket - Number of bytes captured per packet, the remaining bytes are truncated.
	BytesToCapturePerPacket *int32 `json:"bytesToCapturePerPacket,omitempty"`
	// TotalBytesPerSession - Maximum size of the capture output.
	TotalBytesPerSession *int32 `json:"totalBytesPerSession,omitempty"`
	// TimeLimitInSeconds - Maximum duration of the capture session in seconds.
	TimeLimitInSeconds *int32                        `json:"timeLimitInSeconds,omitempty"`
	StorageLocation    *PacketCaptureStorageLocation `json:"storageLocation,omitempty"`
	Filters            *[]PacketCaptureFilter        `json:"filters,omitempty"`
}

// PacketCapturesCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type PacketCapturesCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future PacketCapturesCreateFuture) Result(client PacketCapturesClient) (pcr PacketCaptureResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PacketCapturesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return pcr, azure.NewAsyncOpIncompleteError("network.PacketCapturesCreateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		pcr, err = client.CreateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.PacketCapturesCreateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PacketCapturesCreateFuture", "Result", resp, "Failure sending request")
		return
	}
	pcr, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PacketCapturesCreateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PacketCapturesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type PacketCapturesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future PacketCapturesDeleteFuture) Result(client PacketCapturesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PacketCapturesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.PacketCapturesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.PacketCapturesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PacketCapturesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PacketCapturesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PacketCapturesGetStatusFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PacketCapturesGetStatusFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future PacketCapturesGetStatusFuture) Result(client PacketCapturesClient) (pcqsr PacketCaptureQueryStatusResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PacketCapturesGetStatusFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return pcqsr, azure.NewAsyncOpIncompleteError("network.PacketCapturesGetStatusFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		pcqsr, err = client.GetStatusResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.PacketCapturesGetStatusFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PacketCapturesGetStatusFuture", "Result", resp, "Failure sending request")
		return
	}
	pcqsr, err = client.GetStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PacketCapturesGetStatusFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PacketCapturesStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type PacketCapturesStopFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future PacketCapturesStopFuture) Result(client PacketCapturesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PacketCapturesStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.PacketCapturesStopFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.StopResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.PacketCapturesStopFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PacketCapturesStopFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.StopResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PacketCapturesStopFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PacketCaptureStorageLocation describes the storage location for a packet capture session.
type PacketCaptureStorageLocation struct {
	// StorageID - The ID of the storage account to save the packet capture session. Required if no local file path is provided.
	StorageID *string `json:"storageId,omitempty"`
	// StoragePath - The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
	StoragePath *string `json:"storagePath,omitempty"`
	// FilePath - A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
	FilePath *string `json:"filePath,omitempty"`
}

// PatchRouteFilter route Filter Resource.
type PatchRouteFilter struct {
	*RouteFilterPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchRouteFilter.
func (prf PatchRouteFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prf.RouteFilterPropertiesFormat != nil {
		objectMap["properties"] = prf.RouteFilterPropertiesFormat
	}
	if prf.Name != nil {
		objectMap["name"] = prf.Name
	}
	if prf.Etag != nil {
		objectMap["etag"] = prf.Etag
	}
	if prf.Type != nil {
		objectMap["type"] = prf.Type
	}
	if prf.Tags != nil {
		objectMap["tags"] = prf.Tags
	}
	if prf.ID != nil {
		objectMap["id"] = prf.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PatchRouteFilter struct.
func (prf *PatchRouteFilter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeFilterPropertiesFormat RouteFilterPropertiesFormat
				err = json.Unmarshal(*v, &routeFilterPropertiesFormat)
				if err != nil {
					return err
				}
				prf.RouteFilterPropertiesFormat = &routeFilterPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				prf.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				prf.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				prf.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				prf.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				prf.ID = &ID
			}
		}
	}

	return nil
}

// PatchRouteFilterRule route Filter Rule Resource
type PatchRouteFilterRule struct {
	*RouteFilterRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchRouteFilterRule.
func (prfr PatchRouteFilterRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prfr.RouteFilterRulePropertiesFormat != nil {
		objectMap["properties"] = prfr.RouteFilterRulePropertiesFormat
	}
	if prfr.Name != nil {
		objectMap["name"] = prfr.Name
	}
	if prfr.Etag != nil {
		objectMap["etag"] = prfr.Etag
	}
	if prfr.Tags != nil {
		objectMap["tags"] = prfr.Tags
	}
	if prfr.ID != nil {
		objectMap["id"] = prfr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PatchRouteFilterRule struct.
func (prfr *PatchRouteFilterRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeFilterRulePropertiesFormat RouteFilterRulePropertiesFormat
				err = json.Unmarshal(*v, &routeFilterRulePropertiesFormat)
				if err != nil {
					return err
				}
				prfr.RouteFilterRulePropertiesFormat = &routeFilterRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				prfr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				prfr.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				prfr.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				prfr.ID = &ID
			}
		}
	}

	return nil
}

// Probe a load balancer probe.
type Probe struct {
	*ProbePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Probe.
func (p Probe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProbePropertiesFormat != nil {
		objectMap["properties"] = p.ProbePropertiesFormat
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.Etag != nil {
		objectMap["etag"] = p.Etag
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Probe struct.
func (p *Probe) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var probePropertiesFormat ProbePropertiesFormat
				err = json.Unmarshal(*v, &probePropertiesFormat)
				if err != nil {
					return err
				}
				p.ProbePropertiesFormat = &probePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				p.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		}
	}

	return nil
}

// ProbePropertiesFormat ...
type ProbePropertiesFormat struct {
	// LoadBalancingRules - The load balancer rules that use this probe.
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// Protocol - The protocol of the end point. Possible values are: 'Http' or 'Tcp'. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' is specified, a 200 OK response from the specifies URI is required for the probe to be successful. Possible values include: 'ProbeProtocolHTTP', 'ProbeProtocolTCP'
	Protocol ProbeProtocol `json:"protocol,omitempty"`
	// Port - The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
	Port *int32 `json:"port,omitempty"`
	// IntervalInSeconds - The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
	// NumberOfProbes - The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
	NumberOfProbes *int32 `json:"numberOfProbes,omitempty"`
	// RequestPath - The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
	RequestPath *string `json:"requestPath,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// PublicIPAddress public IP address resource.
type PublicIPAddress struct {
	autorest.Response                `json:"-"`
	*PublicIPAddressPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PublicIPAddress.
func (pia PublicIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pia.PublicIPAddressPropertiesFormat != nil {
		objectMap["properties"] = pia.PublicIPAddressPropertiesFormat
	}
	if pia.Etag != nil {
		objectMap["etag"] = pia.Etag
	}
	if pia.ID != nil {
		objectMap["id"] = pia.ID
	}
	if pia.Name != nil {
		objectMap["name"] = pia.Name
	}
	if pia.Type != nil {
		objectMap["type"] = pia.Type
	}
	if pia.Location != nil {
		objectMap["location"] = pia.Location
	}
	if pia.Tags != nil {
		objectMap["tags"] = pia.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PublicIPAddress struct.
func (pia *PublicIPAddress) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var publicIPAddressPropertiesFormat PublicIPAddressPropertiesFormat
				err = json.Unmarshal(*v, &publicIPAddressPropertiesFormat)
				if err != nil {
					return err
				}
				pia.PublicIPAddressPropertiesFormat = &publicIPAddressPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pia.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pia.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pia.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pia.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pia.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pia.Tags = tags
			}
		}
	}

	return nil
}

// PublicIPAddressDNSSettings contains FQDN of the DNS record associated with the public IP address
type PublicIPAddressDNSSettings struct {
	// DomainNameLabel - Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
	// Fqdn - Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
	Fqdn *string `json:"fqdn,omitempty"`
	// ReverseFqdn - Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
	ReverseFqdn *string `json:"reverseFqdn,omitempty"`
}

// PublicIPAddressesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PublicIPAddressesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future PublicIPAddressesCreateOrUpdateFuture) Result(client PublicIPAddressesClient) (pia PublicIPAddress, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return pia, azure.NewAsyncOpIncompleteError("network.PublicIPAddressesCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		pia, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.PublicIPAddressesCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	pia, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PublicIPAddressesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PublicIPAddressesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future PublicIPAddressesDeleteFuture) Result(client PublicIPAddressesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.PublicIPAddressesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.PublicIPAddressesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PublicIPAddressListResult response for ListPublicIpAddresses API service call.
type PublicIPAddressListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of public IP addresses that exists in a resource group.
	Value *[]PublicIPAddress `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PublicIPAddressListResultIterator provides access to a complete listing of PublicIPAddress values.
type PublicIPAddressListResultIterator struct {
	i    int
	page PublicIPAddressListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PublicIPAddressListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PublicIPAddressListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PublicIPAddressListResultIterator) Response() PublicIPAddressListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PublicIPAddressListResultIterator) Value() PublicIPAddress {
	if !iter.page.NotDone() {
		return PublicIPAddress{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (pialr PublicIPAddressListResult) IsEmpty() bool {
	return pialr.Value == nil || len(*pialr.Value) == 0
}

// publicIPAddressListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pialr PublicIPAddressListResult) publicIPAddressListResultPreparer() (*http.Request, error) {
	if pialr.NextLink == nil || len(to.String(pialr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pialr.NextLink)))
}

// PublicIPAddressListResultPage contains a page of PublicIPAddress values.
type PublicIPAddressListResultPage struct {
	fn    func(PublicIPAddressListResult) (PublicIPAddressListResult, error)
	pialr PublicIPAddressListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PublicIPAddressListResultPage) Next() error {
	next, err := page.fn(page.pialr)
	if err != nil {
		return err
	}
	page.pialr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PublicIPAddressListResultPage) NotDone() bool {
	return !page.pialr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PublicIPAddressListResultPage) Response() PublicIPAddressListResult {
	return page.pialr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PublicIPAddressListResultPage) Values() []PublicIPAddress {
	if page.pialr.IsEmpty() {
		return nil
	}
	return *page.pialr.Value
}

// PublicIPAddressPropertiesFormat public IP address properties.
type PublicIPAddressPropertiesFormat struct {
	// PublicIPAllocationMethod - The public IP allocation method. Possible values are: 'Static' and 'Dynamic'. Possible values include: 'Static', 'Dynamic'
	PublicIPAllocationMethod IPAllocationMethod `json:"publicIPAllocationMethod,omitempty"`
	// PublicIPAddressVersion - The public IP address version. Possible values are: 'IPv4' and 'IPv6'. Possible values include: 'IPv4', 'IPv6'
	PublicIPAddressVersion IPVersion        `json:"publicIPAddressVersion,omitempty"`
	IPConfiguration        *IPConfiguration `json:"ipConfiguration,omitempty"`
	// DNSSettings - The FQDN of the DNS record associated with the public IP address.
	DNSSettings *PublicIPAddressDNSSettings `json:"dnsSettings,omitempty"`
	IPAddress   *string                     `json:"ipAddress,omitempty"`
	// IdleTimeoutInMinutes - The idle timeout of the public IP address.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// ResourceGUID - The resource GUID property of the public IP resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// QueryTroubleshootingParameters parameters that define the resource to query the troubleshooting result.
type QueryTroubleshootingParameters struct {
	// TargetResourceID - The target resource ID to query the troubleshooting result.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// Resource ...
type Resource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceNavigationLink resourceNavigationLink resource.
type ResourceNavigationLink struct {
	*ResourceNavigationLinkFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceNavigationLink.
func (rnl ResourceNavigationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rnl.ResourceNavigationLinkFormat != nil {
		objectMap["properties"] = rnl.ResourceNavigationLinkFormat
	}
	if rnl.Name != nil {
		objectMap["name"] = rnl.Name
	}
	if rnl.Etag != nil {
		objectMap["etag"] = rnl.Etag
	}
	if rnl.ID != nil {
		objectMap["id"] = rnl.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceNavigationLink struct.
func (rnl *ResourceNavigationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var resourceNavigationLinkFormat ResourceNavigationLinkFormat
				err = json.Unmarshal(*v, &resourceNavigationLinkFormat)
				if err != nil {
					return err
				}
				rnl.ResourceNavigationLinkFormat = &resourceNavigationLinkFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rnl.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rnl.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rnl.ID = &ID
			}
		}
	}

	return nil
}

// ResourceNavigationLinkFormat properties of ResourceNavigationLink.
type ResourceNavigationLinkFormat struct {
	// LinkedResourceType - Resource type of the linked resource.
	LinkedResourceType *string `json:"linkedResourceType,omitempty"`
	// Link - Link to the external resource
	Link *string `json:"link,omitempty"`
	// ProvisioningState - Provisioning state of the ResourceNavigationLink resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// RetentionPolicyParameters parameters that define the retention policy for flow log.
type RetentionPolicyParameters struct {
	// Days - Number of days to retain flow log records.
	Days *int32 `json:"days,omitempty"`
	// Enabled - Flag to enable/disable retention.
	Enabled *bool `json:"enabled,omitempty"`
}

// Route route resource
type Route struct {
	autorest.Response      `json:"-"`
	*RoutePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Route.
func (r Route) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RoutePropertiesFormat != nil {
		objectMap["properties"] = r.RoutePropertiesFormat
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Route struct.
func (r *Route) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routePropertiesFormat RoutePropertiesFormat
				err = json.Unmarshal(*v, &routePropertiesFormat)
				if err != nil {
					return err
				}
				r.RoutePropertiesFormat = &routePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				r.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		}
	}

	return nil
}

// RouteFilter route Filter Resource.
type RouteFilter struct {
	autorest.Response            `json:"-"`
	*RouteFilterPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RouteFilter.
func (rf RouteFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rf.RouteFilterPropertiesFormat != nil {
		objectMap["properties"] = rf.RouteFilterPropertiesFormat
	}
	if rf.Etag != nil {
		objectMap["etag"] = rf.Etag
	}
	if rf.ID != nil {
		objectMap["id"] = rf.ID
	}
	if rf.Name != nil {
		objectMap["name"] = rf.Name
	}
	if rf.Type != nil {
		objectMap["type"] = rf.Type
	}
	if rf.Location != nil {
		objectMap["location"] = rf.Location
	}
	if rf.Tags != nil {
		objectMap["tags"] = rf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RouteFilter struct.
func (rf *RouteFilter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeFilterPropertiesFormat RouteFilterPropertiesFormat
				err = json.Unmarshal(*v, &routeFilterPropertiesFormat)
				if err != nil {
					return err
				}
				rf.RouteFilterPropertiesFormat = &routeFilterPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rf.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rf.Tags = tags
			}
		}
	}

	return nil
}

// RouteFilterListResult response for the ListRouteFilters API service call.
type RouteFilterListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of route filters in a resource group.
	Value *[]RouteFilter `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RouteFilterListResultIterator provides access to a complete listing of RouteFilter values.
type RouteFilterListResultIterator struct {
	i    int
	page RouteFilterListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteFilterListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteFilterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteFilterListResultIterator) Response() RouteFilterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteFilterListResultIterator) Value() RouteFilter {
	if !iter.page.NotDone() {
		return RouteFilter{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rflr RouteFilterListResult) IsEmpty() bool {
	return rflr.Value == nil || len(*rflr.Value) == 0
}

// routeFilterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rflr RouteFilterListResult) routeFilterListResultPreparer() (*http.Request, error) {
	if rflr.NextLink == nil || len(to.String(rflr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rflr.NextLink)))
}

// RouteFilterListResultPage contains a page of RouteFilter values.
type RouteFilterListResultPage struct {
	fn   func(RouteFilterListResult) (RouteFilterListResult, error)
	rflr RouteFilterListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteFilterListResultPage) Next() error {
	next, err := page.fn(page.rflr)
	if err != nil {
		return err
	}
	page.rflr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteFilterListResultPage) NotDone() bool {
	return !page.rflr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteFilterListResultPage) Response() RouteFilterListResult {
	return page.rflr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteFilterListResultPage) Values() []RouteFilter {
	if page.rflr.IsEmpty() {
		return nil
	}
	return *page.rflr.Value
}

// RouteFilterPropertiesFormat route Filter Resource
type RouteFilterPropertiesFormat struct {
	// Rules - Collection of RouteFilterRules contained within a route filter.
	Rules *[]RouteFilterRule `json:"rules,omitempty"`
	// Peerings - A collection of references to express route circuit peerings.
	Peerings *[]ExpressRouteCircuitPeering `json:"peerings,omitempty"`
	// ProvisioningState - The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// RouteFilterRule route Filter Rule Resource
type RouteFilterRule struct {
	autorest.Response                `json:"-"`
	*RouteFilterRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for RouteFilterRule.
func (rfr RouteFilterRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rfr.RouteFilterRulePropertiesFormat != nil {
		objectMap["properties"] = rfr.RouteFilterRulePropertiesFormat
	}
	if rfr.Name != nil {
		objectMap["name"] = rfr.Name
	}
	if rfr.Location != nil {
		objectMap["location"] = rfr.Location
	}
	if rfr.Etag != nil {
		objectMap["etag"] = rfr.Etag
	}
	if rfr.Tags != nil {
		objectMap["tags"] = rfr.Tags
	}
	if rfr.ID != nil {
		objectMap["id"] = rfr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RouteFilterRule struct.
func (rfr *RouteFilterRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeFilterRulePropertiesFormat RouteFilterRulePropertiesFormat
				err = json.Unmarshal(*v, &routeFilterRulePropertiesFormat)
				if err != nil {
					return err
				}
				rfr.RouteFilterRulePropertiesFormat = &routeFilterRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rfr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rfr.Location = &location
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rfr.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rfr.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rfr.ID = &ID
			}
		}
	}

	return nil
}

// RouteFilterRuleListResult response for the ListRouteFilterRules API service call
type RouteFilterRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of RouteFilterRules in a resource group.
	Value *[]RouteFilterRule `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RouteFilterRuleListResultIterator provides access to a complete listing of RouteFilterRule values.
type RouteFilterRuleListResultIterator struct {
	i    int
	page RouteFilterRuleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteFilterRuleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteFilterRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteFilterRuleListResultIterator) Response() RouteFilterRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteFilterRuleListResultIterator) Value() RouteFilterRule {
	if !iter.page.NotDone() {
		return RouteFilterRule{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rfrlr RouteFilterRuleListResult) IsEmpty() bool {
	return rfrlr.Value == nil || len(*rfrlr.Value) == 0
}

// routeFilterRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rfrlr RouteFilterRuleListResult) routeFilterRuleListResultPreparer() (*http.Request, error) {
	if rfrlr.NextLink == nil || len(to.String(rfrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rfrlr.NextLink)))
}

// RouteFilterRuleListResultPage contains a page of RouteFilterRule values.
type RouteFilterRuleListResultPage struct {
	fn    func(RouteFilterRuleListResult) (RouteFilterRuleListResult, error)
	rfrlr RouteFilterRuleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteFilterRuleListResultPage) Next() error {
	next, err := page.fn(page.rfrlr)
	if err != nil {
		return err
	}
	page.rfrlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteFilterRuleListResultPage) NotDone() bool {
	return !page.rfrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteFilterRuleListResultPage) Response() RouteFilterRuleListResult {
	return page.rfrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteFilterRuleListResultPage) Values() []RouteFilterRule {
	if page.rfrlr.IsEmpty() {
		return nil
	}
	return *page.rfrlr.Value
}

// RouteFilterRulePropertiesFormat route Filter Rule Resource
type RouteFilterRulePropertiesFormat struct {
	// Access - The access type of the rule. Valid values are: 'Allow', 'Deny'. Possible values include: 'Allow', 'Deny'
	Access Access `json:"access,omitempty"`
	// RouteFilterRuleType - The rule type of the rule. Valid value is: 'Community'
	RouteFilterRuleType *string `json:"routeFilterRuleType,omitempty"`
	// Communities - The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020']
	Communities *[]string `json:"communities,omitempty"`
	// ProvisioningState - The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// RouteFilterRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteFilterRulesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RouteFilterRulesCreateOrUpdateFuture) Result(client RouteFilterRulesClient) (rfr RouteFilterRule, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFilterRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return rfr, azure.NewAsyncOpIncompleteError("network.RouteFilterRulesCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		rfr, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RouteFilterRulesCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFilterRulesCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	rfr, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFilterRulesCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// RouteFilterRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteFilterRulesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RouteFilterRulesDeleteFuture) Result(client RouteFilterRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFilterRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.RouteFilterRulesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RouteFilterRulesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFilterRulesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFilterRulesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// RouteFilterRulesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteFilterRulesUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RouteFilterRulesUpdateFuture) Result(client RouteFilterRulesClient) (rfr RouteFilterRule, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFilterRulesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return rfr, azure.NewAsyncOpIncompleteError("network.RouteFilterRulesUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		rfr, err = client.UpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RouteFilterRulesUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFilterRulesUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	rfr, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFilterRulesUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// RouteFiltersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteFiltersCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RouteFiltersCreateOrUpdateFuture) Result(client RouteFiltersClient) (rf RouteFilter, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFiltersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return rf, azure.NewAsyncOpIncompleteError("network.RouteFiltersCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		rf, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RouteFiltersCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFiltersCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	rf, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFiltersCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// RouteFiltersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RouteFiltersDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RouteFiltersDeleteFuture) Result(client RouteFiltersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFiltersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.RouteFiltersDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RouteFiltersDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFiltersDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFiltersDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// RouteFiltersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RouteFiltersUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RouteFiltersUpdateFuture) Result(client RouteFiltersClient) (rf RouteFilter, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFiltersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return rf, azure.NewAsyncOpIncompleteError("network.RouteFiltersUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		rf, err = client.UpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RouteFiltersUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFiltersUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	rf, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteFiltersUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// RouteListResult response for the ListRoute API service call
type RouteListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of routes in a resource group.
	Value *[]Route `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RouteListResultIterator provides access to a complete listing of Route values.
type RouteListResultIterator struct {
	i    int
	page RouteListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteListResultIterator) Response() RouteListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteListResultIterator) Value() Route {
	if !iter.page.NotDone() {
		return Route{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RouteListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// routeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RouteListResult) routeListResultPreparer() (*http.Request, error) {
	if rlr.NextLink == nil || len(to.String(rlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RouteListResultPage contains a page of Route values.
type RouteListResultPage struct {
	fn  func(RouteListResult) (RouteListResult, error)
	rlr RouteListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteListResultPage) Next() error {
	next, err := page.fn(page.rlr)
	if err != nil {
		return err
	}
	page.rlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteListResultPage) Response() RouteListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteListResultPage) Values() []Route {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// RoutePropertiesFormat route resource
type RoutePropertiesFormat struct {
	// AddressPrefix - The destination CIDR to which the route applies.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// NextHopType - The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Possible values include: 'RouteNextHopTypeVirtualNetworkGateway', 'RouteNextHopTypeVnetLocal', 'RouteNextHopTypeInternet', 'RouteNextHopTypeVirtualAppliance', 'RouteNextHopTypeNone'
	NextHopType RouteNextHopType `json:"nextHopType,omitempty"`
	// NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`
	// ProvisioningState - The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// RoutesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RoutesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RoutesCreateOrUpdateFuture) Result(client RoutesClient) (r Route, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return r, azure.NewAsyncOpIncompleteError("network.RoutesCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		r, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RoutesCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	r, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// RoutesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RoutesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RoutesDeleteFuture) Result(client RoutesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.RoutesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RoutesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// RouteTable route table resource.
type RouteTable struct {
	autorest.Response           `json:"-"`
	*RouteTablePropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RouteTable.
func (rt RouteTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.RouteTablePropertiesFormat != nil {
		objectMap["properties"] = rt.RouteTablePropertiesFormat
	}
	if rt.Etag != nil {
		objectMap["etag"] = rt.Etag
	}
	if rt.ID != nil {
		objectMap["id"] = rt.ID
	}
	if rt.Name != nil {
		objectMap["name"] = rt.Name
	}
	if rt.Type != nil {
		objectMap["type"] = rt.Type
	}
	if rt.Location != nil {
		objectMap["location"] = rt.Location
	}
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RouteTable struct.
func (rt *RouteTable) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeTablePropertiesFormat RouteTablePropertiesFormat
				err = json.Unmarshal(*v, &routeTablePropertiesFormat)
				if err != nil {
					return err
				}
				rt.RouteTablePropertiesFormat = &routeTablePropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rt.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rt.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rt.Tags = tags
			}
		}
	}

	return nil
}

// RouteTableListResult response for the ListRouteTable API service call.
type RouteTableListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of route tables in a resource group.
	Value *[]RouteTable `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RouteTableListResultIterator provides access to a complete listing of RouteTable values.
type RouteTableListResultIterator struct {
	i    int
	page RouteTableListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteTableListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteTableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteTableListResultIterator) Response() RouteTableListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteTableListResultIterator) Value() RouteTable {
	if !iter.page.NotDone() {
		return RouteTable{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rtlr RouteTableListResult) IsEmpty() bool {
	return rtlr.Value == nil || len(*rtlr.Value) == 0
}

// routeTableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rtlr RouteTableListResult) routeTableListResultPreparer() (*http.Request, error) {
	if rtlr.NextLink == nil || len(to.String(rtlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rtlr.NextLink)))
}

// RouteTableListResultPage contains a page of RouteTable values.
type RouteTableListResultPage struct {
	fn   func(RouteTableListResult) (RouteTableListResult, error)
	rtlr RouteTableListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteTableListResultPage) Next() error {
	next, err := page.fn(page.rtlr)
	if err != nil {
		return err
	}
	page.rtlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteTableListResultPage) NotDone() bool {
	return !page.rtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteTableListResultPage) Response() RouteTableListResult {
	return page.rtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteTableListResultPage) Values() []RouteTable {
	if page.rtlr.IsEmpty() {
		return nil
	}
	return *page.rtlr.Value
}

// RouteTablePropertiesFormat route Table resource
type RouteTablePropertiesFormat struct {
	// Routes - Collection of routes contained within a route table.
	Routes *[]Route `json:"routes,omitempty"`
	// Subnets - A collection of references to subnets.
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// ProvisioningState - The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// RouteTablesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteTablesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RouteTablesCreateOrUpdateFuture) Result(client RouteTablesClient) (rt RouteTable, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return rt, azure.NewAsyncOpIncompleteError("network.RouteTablesCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		rt, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RouteTablesCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	rt, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// RouteTablesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RouteTablesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RouteTablesDeleteFuture) Result(client RouteTablesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.RouteTablesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RouteTablesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// SecurityGroup networkSecurityGroup resource.
type SecurityGroup struct {
	autorest.Response              `json:"-"`
	*SecurityGroupPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SecurityGroup.
func (sg SecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sg.SecurityGroupPropertiesFormat != nil {
		objectMap["properties"] = sg.SecurityGroupPropertiesFormat
	}
	if sg.Etag != nil {
		objectMap["etag"] = sg.Etag
	}
	if sg.ID != nil {
		objectMap["id"] = sg.ID
	}
	if sg.Name != nil {
		objectMap["name"] = sg.Name
	}
	if sg.Type != nil {
		objectMap["type"] = sg.Type
	}
	if sg.Location != nil {
		objectMap["location"] = sg.Location
	}
	if sg.Tags != nil {
		objectMap["tags"] = sg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecurityGroup struct.
func (sg *SecurityGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityGroupPropertiesFormat SecurityGroupPropertiesFormat
				err = json.Unmarshal(*v, &securityGroupPropertiesFormat)
				if err != nil {
					return err
				}
				sg.SecurityGroupPropertiesFormat = &securityGroupPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sg.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sg.Tags = tags
			}
		}
	}

	return nil
}

// SecurityGroupListResult response for ListNetworkSecurityGroups API service call.
type SecurityGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of NetworkSecurityGroup resources.
	Value *[]SecurityGroup `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecurityGroupListResultIterator provides access to a complete listing of SecurityGroup values.
type SecurityGroupListResultIterator struct {
	i    int
	page SecurityGroupListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecurityGroupListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecurityGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecurityGroupListResultIterator) Response() SecurityGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecurityGroupListResultIterator) Value() SecurityGroup {
	if !iter.page.NotDone() {
		return SecurityGroup{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (sglr SecurityGroupListResult) IsEmpty() bool {
	return sglr.Value == nil || len(*sglr.Value) == 0
}

// securityGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sglr SecurityGroupListResult) securityGroupListResultPreparer() (*http.Request, error) {
	if sglr.NextLink == nil || len(to.String(sglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sglr.NextLink)))
}

// SecurityGroupListResultPage contains a page of SecurityGroup values.
type SecurityGroupListResultPage struct {
	fn   func(SecurityGroupListResult) (SecurityGroupListResult, error)
	sglr SecurityGroupListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecurityGroupListResultPage) Next() error {
	next, err := page.fn(page.sglr)
	if err != nil {
		return err
	}
	page.sglr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecurityGroupListResultPage) NotDone() bool {
	return !page.sglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecurityGroupListResultPage) Response() SecurityGroupListResult {
	return page.sglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecurityGroupListResultPage) Values() []SecurityGroup {
	if page.sglr.IsEmpty() {
		return nil
	}
	return *page.sglr.Value
}

// SecurityGroupNetworkInterface network interface and all its associated security rules.
type SecurityGroupNetworkInterface struct {
	// ID - ID of the network interface.
	ID                       *string                   `json:"id,omitempty"`
	SecurityRuleAssociations *SecurityRuleAssociations `json:"securityRuleAssociations,omitempty"`
}

// SecurityGroupPropertiesFormat network Security Group resource.
type SecurityGroupPropertiesFormat struct {
	// SecurityRules - A collection of security rules of the network security group.
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
	// DefaultSecurityRules - The default security rules of network security group.
	DefaultSecurityRules *[]SecurityRule `json:"defaultSecurityRules,omitempty"`
	// NetworkInterfaces - A collection of references to network interfaces.
	NetworkInterfaces *[]Interface `json:"networkInterfaces,omitempty"`
	// Subnets - A collection of references to subnets.
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// ResourceGUID - The resource GUID property of the network security group resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// SecurityGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityGroupsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SecurityGroupsCreateOrUpdateFuture) Result(client SecurityGroupsClient) (sg SecurityGroup, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sg, azure.NewAsyncOpIncompleteError("network.SecurityGroupsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sg, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SecurityGroupsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	sg, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// SecurityGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SecurityGroupsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SecurityGroupsDeleteFuture) Result(client SecurityGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.SecurityGroupsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SecurityGroupsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// SecurityGroupViewParameters parameters that define the VM to check security groups for.
type SecurityGroupViewParameters struct {
	// TargetResourceID - ID of the target VM.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// SecurityGroupViewResult the information about security rules applied to the specified VM.
type SecurityGroupViewResult struct {
	autorest.Response `json:"-"`
	// NetworkInterfaces - List of network interfaces on the specified VM.
	NetworkInterfaces *[]SecurityGroupNetworkInterface `json:"networkInterfaces,omitempty"`
}

// SecurityRule network security rule.
type SecurityRule struct {
	autorest.Response             `json:"-"`
	*SecurityRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityRule.
func (sr SecurityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.SecurityRulePropertiesFormat != nil {
		objectMap["properties"] = sr.SecurityRulePropertiesFormat
	}
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.Etag != nil {
		objectMap["etag"] = sr.Etag
	}
	if sr.ID != nil {
		objectMap["id"] = sr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecurityRule struct.
func (sr *SecurityRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityRulePropertiesFormat SecurityRulePropertiesFormat
				err = json.Unmarshal(*v, &securityRulePropertiesFormat)
				if err != nil {
					return err
				}
				sr.SecurityRulePropertiesFormat = &securityRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		}
	}

	return nil
}

// SecurityRuleAssociations all security rules associated with the network interface.
type SecurityRuleAssociations struct {
	NetworkInterfaceAssociation *InterfaceAssociation `json:"networkInterfaceAssociation,omitempty"`
	SubnetAssociation           *SubnetAssociation    `json:"subnetAssociation,omitempty"`
	// DefaultSecurityRules - Collection of default security rules of the network security group.
	DefaultSecurityRules *[]SecurityRule `json:"defaultSecurityRules,omitempty"`
	// EffectiveSecurityRules - Collection of effective security rules.
	EffectiveSecurityRules *[]EffectiveNetworkSecurityRule `json:"effectiveSecurityRules,omitempty"`
}

// SecurityRuleListResult response for ListSecurityRule API service call. Retrieves all security rules that belongs
// to a network security group.
type SecurityRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The security rules in a network security group.
	Value *[]SecurityRule `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecurityRuleListResultIterator provides access to a complete listing of SecurityRule values.
type SecurityRuleListResultIterator struct {
	i    int
	page SecurityRuleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecurityRuleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecurityRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecurityRuleListResultIterator) Response() SecurityRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecurityRuleListResultIterator) Value() SecurityRule {
	if !iter.page.NotDone() {
		return SecurityRule{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (srlr SecurityRuleListResult) IsEmpty() bool {
	return srlr.Value == nil || len(*srlr.Value) == 0
}

// securityRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srlr SecurityRuleListResult) securityRuleListResultPreparer() (*http.Request, error) {
	if srlr.NextLink == nil || len(to.String(srlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srlr.NextLink)))
}

// SecurityRuleListResultPage contains a page of SecurityRule values.
type SecurityRuleListResultPage struct {
	fn   func(SecurityRuleListResult) (SecurityRuleListResult, error)
	srlr SecurityRuleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecurityRuleListResultPage) Next() error {
	next, err := page.fn(page.srlr)
	if err != nil {
		return err
	}
	page.srlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecurityRuleListResultPage) NotDone() bool {
	return !page.srlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecurityRuleListResultPage) Response() SecurityRuleListResult {
	return page.srlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecurityRuleListResultPage) Values() []SecurityRule {
	if page.srlr.IsEmpty() {
		return nil
	}
	return *page.srlr.Value
}

// SecurityRulePropertiesFormat ...
type SecurityRulePropertiesFormat struct {
	// Description - A description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`
	// Protocol - Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'. Possible values include: 'SecurityRuleProtocolTCP', 'SecurityRuleProtocolUDP', 'SecurityRuleProtocolAsterisk'
	Protocol SecurityRuleProtocol `json:"protocol,omitempty"`
	// SourcePortRange - The source port or range. Integer or range between 0 and 65535. Asterix '*' can also be used to match all ports.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`
	// DestinationPortRange - The destination port or range. Integer or range between 0 and 65535. Asterix '*' can also be used to match all ports.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`
	// SourceAddressPrefix - The CIDR or source IP range. Asterix '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// DestinationAddressPrefix - The destination address prefix. CIDR or source IP range. Asterix '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`
	// Access - The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'. Possible values include: 'SecurityRuleAccessAllow', 'SecurityRuleAccessDeny'
	Access SecurityRuleAccess `json:"access,omitempty"`
	// Priority - The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32 `json:"priority,omitempty"`
	// Direction - The direction of the rule. The direction specifies if rule will be evaluated on incoming or outcoming traffic. Possible values are: 'Inbound' and 'Outbound'. Possible values include: 'SecurityRuleDirectionInbound', 'SecurityRuleDirectionOutbound'
	Direction SecurityRuleDirection `json:"direction,omitempty"`
	// ProvisioningState - The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// SecurityRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityRulesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SecurityRulesCreateOrUpdateFuture) Result(client SecurityRulesClient) (sr SecurityRule, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sr, azure.NewAsyncOpIncompleteError("network.SecurityRulesCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sr, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SecurityRulesCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	sr, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// SecurityRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SecurityRulesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SecurityRulesDeleteFuture) Result(client SecurityRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.SecurityRulesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SecurityRulesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// Subnet subnet in a virtual network resource.
type Subnet struct {
	autorest.Response       `json:"-"`
	*SubnetPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Subnet.
func (s Subnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SubnetPropertiesFormat != nil {
		objectMap["properties"] = s.SubnetPropertiesFormat
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Etag != nil {
		objectMap["etag"] = s.Etag
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Subnet struct.
func (s *Subnet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subnetPropertiesFormat SubnetPropertiesFormat
				err = json.Unmarshal(*v, &subnetPropertiesFormat)
				if err != nil {
					return err
				}
				s.SubnetPropertiesFormat = &subnetPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				s.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		}
	}

	return nil
}

// SubnetAssociation network interface and its custom security rules.
type SubnetAssociation struct {
	// ID - Subnet ID.
	ID *string `json:"id,omitempty"`
	// SecurityRules - Collection of custom security rules.
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
}

// SubnetListResult response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network
type SubnetListResult struct {
	autorest.Response `json:"-"`
	// Value - The subnets in a virtual network.
	Value *[]Subnet `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubnetListResultIterator provides access to a complete listing of Subnet values.
type SubnetListResultIterator struct {
	i    int
	page SubnetListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubnetListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubnetListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubnetListResultIterator) Response() SubnetListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubnetListResultIterator) Value() Subnet {
	if !iter.page.NotDone() {
		return Subnet{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SubnetListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// subnetListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SubnetListResult) subnetListResultPreparer() (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SubnetListResultPage contains a page of Subnet values.
type SubnetListResultPage struct {
	fn  func(SubnetListResult) (SubnetListResult, error)
	slr SubnetListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubnetListResultPage) Next() error {
	next, err := page.fn(page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubnetListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubnetListResultPage) Response() SubnetListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubnetListResultPage) Values() []Subnet {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// SubnetPropertiesFormat ...
type SubnetPropertiesFormat struct {
	// AddressPrefix - The address prefix for the subnet.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// NetworkSecurityGroup - The reference of the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`
	// RouteTable - The reference of the RouteTable resource.
	RouteTable *RouteTable `json:"routeTable,omitempty"`
	// IPConfigurations - Gets an array of references to the network interface IP configurations using subnet.
	IPConfigurations *[]IPConfiguration `json:"ipConfigurations,omitempty"`
	// ResourceNavigationLinks - Gets an array of references to the external resources using subnet.
	ResourceNavigationLinks *[]ResourceNavigationLink `json:"resourceNavigationLinks,omitempty"`
	// ProvisioningState - The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// SubnetsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubnetsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SubnetsCreateOrUpdateFuture) Result(client SubnetsClient) (s Subnet, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return s, azure.NewAsyncOpIncompleteError("network.SubnetsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		s, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SubnetsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	s, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// SubnetsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SubnetsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SubnetsDeleteFuture) Result(client SubnetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.SubnetsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SubnetsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// SubResource ...
type SubResource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// Topology topology of the specified resource group.
type Topology struct {
	autorest.Response `json:"-"`
	// ID - GUID representing the operation id.
	ID *string `json:"id,omitempty"`
	// CreatedDateTime - The datetime when the topology was initially created for the resource group.
	CreatedDateTime *date.Time `json:"createdDateTime,omitempty"`
	// LastModified - The datetime when the topology was last modified.
	LastModified *date.Time          `json:"lastModified,omitempty"`
	Resources    *[]TopologyResource `json:"resources,omitempty"`
}

// TopologyAssociation resources that have an association with the parent resource.
type TopologyAssociation struct {
	// Name - The name of the resource that is associated with the parent resource.
	Name *string `json:"name,omitempty"`
	// ResourceID - The ID of the resource that is associated with the parent resource.
	ResourceID *string `json:"resourceId,omitempty"`
	// AssociationType - The association type of the child resource to the parent resource. Possible values include: 'Associated', 'Contains'
	AssociationType AssociationType `json:"associationType,omitempty"`
}

// TopologyParameters parameters that define the representation of topology.
type TopologyParameters struct {
	// TargetResourceGroupName - The name of the target resource group to perform topology on.
	TargetResourceGroupName *string `json:"targetResourceGroupName,omitempty"`
}

// TopologyResource the network resource topology information for the given resource group.
type TopologyResource struct {
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - ID of the resource.
	ID *string `json:"id,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Associations - Holds the associations the resource has with other resources in the resource group.
	Associations *[]TopologyAssociation `json:"associations,omitempty"`
}

// TroubleshootingDetails information gained from troubleshooting of specified resource.
type TroubleshootingDetails struct {
	// ID - The id of the get troubleshoot operation.
	ID *string `json:"id,omitempty"`
	// ReasonType - Reason type of failure.
	ReasonType *string `json:"reasonType,omitempty"`
	// Summary - A summary of troubleshooting.
	Summary *string `json:"summary,omitempty"`
	// Detail - Details on troubleshooting results.
	Detail *string `json:"detail,omitempty"`
	// RecommendedActions - List of recommended actions.
	RecommendedActions *[]TroubleshootingRecommendedActions `json:"recommendedActions,omitempty"`
}

// TroubleshootingParameters parameters that define the resource to troubleshoot.
type TroubleshootingParameters struct {
	// TargetResourceID - The target resource to troubleshoot.
	TargetResourceID           *string `json:"targetResourceId,omitempty"`
	*TroubleshootingProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TroubleshootingParameters.
func (tp TroubleshootingParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.TargetResourceID != nil {
		objectMap["targetResourceId"] = tp.TargetResourceID
	}
	if tp.TroubleshootingProperties != nil {
		objectMap["properties"] = tp.TroubleshootingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TroubleshootingParameters struct.
func (tp *TroubleshootingParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "targetResourceId":
			if v != nil {
				var targetResourceID string
				err = json.Unmarshal(*v, &targetResourceID)
				if err != nil {
					return err
				}
				tp.TargetResourceID = &targetResourceID
			}
		case "properties":
			if v != nil {
				var troubleshootingProperties TroubleshootingProperties
				err = json.Unmarshal(*v, &troubleshootingProperties)
				if err != nil {
					return err
				}
				tp.TroubleshootingProperties = &troubleshootingProperties
			}
		}
	}

	return nil
}

// TroubleshootingProperties storage location provided for troubleshoot.
type TroubleshootingProperties struct {
	// StorageID - The ID for the storage account to save the troubleshoot result.
	StorageID *string `json:"storageId,omitempty"`
	// StoragePath - The path to the blob to save the troubleshoot result in.
	StoragePath *string `json:"storagePath,omitempty"`
}

// TroubleshootingRecommendedActions recommended actions based on discovered issues.
type TroubleshootingRecommendedActions struct {
	// ActionID - ID of the recommended action.
	ActionID *string `json:"actionId,omitempty"`
	// ActionText - Description of recommended actions.
	ActionText *string `json:"actionText,omitempty"`
	// ActionURI - The uri linking to a documentation for the recommended troubleshooting actions.
	ActionURI *string `json:"actionUri,omitempty"`
	// ActionURIText - The information from the URI for the recommended troubleshooting actions.
	ActionURIText *string `json:"actionUriText,omitempty"`
}

// TroubleshootingResult troubleshooting information gained from specified resource.
type TroubleshootingResult struct {
	autorest.Response `json:"-"`
	// StartTime - The start time of the troubleshooting.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the troubleshooting.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Code - The result code of the troubleshooting.
	Code *string `json:"code,omitempty"`
	// Results - Information from troubleshooting.
	Results *[]TroubleshootingDetails `json:"results,omitempty"`
}

// TunnelConnectionHealth virtualNetworkGatewayConnection properties
type TunnelConnectionHealth struct {
	// Tunnel - Tunnel name.
	Tunnel *string `json:"tunnel,omitempty"`
	// ConnectionStatus - Virtual network Gateway connection status. Possible values include: 'VirtualNetworkGatewayConnectionStatusUnknown', 'VirtualNetworkGatewayConnectionStatusConnecting', 'VirtualNetworkGatewayConnectionStatusConnected', 'VirtualNetworkGatewayConnectionStatusNotConnected'
	ConnectionStatus VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty"`
	// IngressBytesTransferred - The Ingress Bytes Transferred in this connection
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty"`
	// EgressBytesTransferred - The Egress Bytes Transferred in this connection
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty"`
	// LastConnectionEstablishedUtcTime - The time at which connection was established in Utc format.
	LastConnectionEstablishedUtcTime *string `json:"lastConnectionEstablishedUtcTime,omitempty"`
}

// Usage describes network resource usage.
type Usage struct {
	// Unit - An enum describing the unit of measurement.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - The current value of the usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - The limit of usage.
	Limit *int64 `json:"limit,omitempty"`
	// Name - The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// UsageName the usage names.
type UsageName struct {
	// Value - A string describing the resource name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - A localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UsagesListResult the list usages operation response.
type UsagesListResult struct {
	autorest.Response `json:"-"`
	// Value - The list network resource usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UsagesListResultIterator provides access to a complete listing of Usage values.
type UsagesListResultIterator struct {
	i    int
	page UsagesListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsagesListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsagesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsagesListResultIterator) Response() UsagesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsagesListResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ulr UsagesListResult) IsEmpty() bool {
	return ulr.Value == nil || len(*ulr.Value) == 0
}

// usagesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ulr UsagesListResult) usagesListResultPreparer() (*http.Request, error) {
	if ulr.NextLink == nil || len(to.String(ulr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ulr.NextLink)))
}

// UsagesListResultPage contains a page of Usage values.
type UsagesListResultPage struct {
	fn  func(UsagesListResult) (UsagesListResult, error)
	ulr UsagesListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsagesListResultPage) Next() error {
	next, err := page.fn(page.ulr)
	if err != nil {
		return err
	}
	page.ulr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsagesListResultPage) NotDone() bool {
	return !page.ulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsagesListResultPage) Response() UsagesListResult {
	return page.ulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsagesListResultPage) Values() []Usage {
	if page.ulr.IsEmpty() {
		return nil
	}
	return *page.ulr.Value
}

// VerificationIPFlowParameters parameters that define the IP flow to be verified.
type VerificationIPFlowParameters struct {
	// TargetResourceID - The ID of the target resource to perform next-hop on.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// Direction - The direction of the packet represented as a 5-tuple. Possible values include: 'Inbound', 'Outbound'
	Direction Direction `json:"direction,omitempty"`
	// Protocol - Protocol to be verified on. Possible values include: 'ProtocolTCP', 'ProtocolUDP'
	Protocol Protocol `json:"protocol,omitempty"`
	// LocalPort - The local port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port, which depends on the direction.
	LocalPort *string `json:"localPort,omitempty"`
	// RemotePort - The remote port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port, which depends on the direction.
	RemotePort *string `json:"remotePort,omitempty"`
	// LocalIPAddress - The local IP address. Acceptable values are valid IPv4 addresses.
	LocalIPAddress *string `json:"localIPAddress,omitempty"`
	// RemoteIPAddress - The remote IP address. Acceptable values are valid IPv4 addresses.
	RemoteIPAddress *string `json:"remoteIPAddress,omitempty"`
	// TargetNicResourceID - The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of them, then this parameter must be specified. Otherwise optional).
	TargetNicResourceID *string `json:"targetNicResourceId,omitempty"`
}

// VerificationIPFlowResult results of IP flow verification on the target resource.
type VerificationIPFlowResult struct {
	autorest.Response `json:"-"`
	// Access - Indicates whether the traffic is allowed or denied. Possible values include: 'Allow', 'Deny'
	Access Access `json:"access,omitempty"`
	// RuleName - Name of the rule. If input is not matched against any security rule, it is not displayed.
	RuleName *string `json:"ruleName,omitempty"`
}

// VirtualNetwork virtual Network resource.
type VirtualNetwork struct {
	autorest.Response               `json:"-"`
	*VirtualNetworkPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetwork.
func (vn VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vn.VirtualNetworkPropertiesFormat != nil {
		objectMap["properties"] = vn.VirtualNetworkPropertiesFormat
	}
	if vn.Etag != nil {
		objectMap["etag"] = vn.Etag
	}
	if vn.ID != nil {
		objectMap["id"] = vn.ID
	}
	if vn.Name != nil {
		objectMap["name"] = vn.Name
	}
	if vn.Type != nil {
		objectMap["type"] = vn.Type
	}
	if vn.Location != nil {
		objectMap["location"] = vn.Location
	}
	if vn.Tags != nil {
		objectMap["tags"] = vn.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetwork struct.
func (vn *VirtualNetwork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkPropertiesFormat VirtualNetworkPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkPropertiesFormat)
				if err != nil {
					return err
				}
				vn.VirtualNetworkPropertiesFormat = &virtualNetworkPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vn.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vn.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vn.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vn.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkGateway a common class for general resource information
type VirtualNetworkGateway struct {
	autorest.Response                      `json:"-"`
	*VirtualNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGateway.
func (vng VirtualNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vng.VirtualNetworkGatewayPropertiesFormat != nil {
		objectMap["properties"] = vng.VirtualNetworkGatewayPropertiesFormat
	}
	if vng.Etag != nil {
		objectMap["etag"] = vng.Etag
	}
	if vng.ID != nil {
		objectMap["id"] = vng.ID
	}
	if vng.Name != nil {
		objectMap["name"] = vng.Name
	}
	if vng.Type != nil {
		objectMap["type"] = vng.Type
	}
	if vng.Location != nil {
		objectMap["location"] = vng.Location
	}
	if vng.Tags != nil {
		objectMap["tags"] = vng.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGateway struct.
func (vng *VirtualNetworkGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayPropertiesFormat VirtualNetworkGatewayPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				vng.VirtualNetworkGatewayPropertiesFormat = &virtualNetworkGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vng.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vng.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vng.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vng.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkGatewayConnection a common class for general resource information
type VirtualNetworkGatewayConnection struct {
	autorest.Response                                `json:"-"`
	*VirtualNetworkGatewayConnectionPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGatewayConnection.
func (vngc VirtualNetworkGatewayConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vngc.VirtualNetworkGatewayConnectionPropertiesFormat != nil {
		objectMap["properties"] = vngc.VirtualNetworkGatewayConnectionPropertiesFormat
	}
	if vngc.Etag != nil {
		objectMap["etag"] = vngc.Etag
	}
	if vngc.ID != nil {
		objectMap["id"] = vngc.ID
	}
	if vngc.Name != nil {
		objectMap["name"] = vngc.Name
	}
	if vngc.Type != nil {
		objectMap["type"] = vngc.Type
	}
	if vngc.Location != nil {
		objectMap["location"] = vngc.Location
	}
	if vngc.Tags != nil {
		objectMap["tags"] = vngc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGatewayConnection struct.
func (vngc *VirtualNetworkGatewayConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayConnectionPropertiesFormat VirtualNetworkGatewayConnectionPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayConnectionPropertiesFormat)
				if err != nil {
					return err
				}
				vngc.VirtualNetworkGatewayConnectionPropertiesFormat = &virtualNetworkGatewayConnectionPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vngc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vngc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vngc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vngc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vngc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vngc.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkGatewayConnectionListResult response for the ListVirtualNetworkGatewayConnections API service call
type VirtualNetworkGatewayConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of VirtualNetworkGatewayConnection resources that exists in a resource group.
	Value *[]VirtualNetworkGatewayConnection `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkGatewayConnectionListResultIterator provides access to a complete listing of
// VirtualNetworkGatewayConnection values.
type VirtualNetworkGatewayConnectionListResultIterator struct {
	i    int
	page VirtualNetworkGatewayConnectionListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkGatewayConnectionListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkGatewayConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkGatewayConnectionListResultIterator) Response() VirtualNetworkGatewayConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkGatewayConnectionListResultIterator) Value() VirtualNetworkGatewayConnection {
	if !iter.page.NotDone() {
		return VirtualNetworkGatewayConnection{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (vngclr VirtualNetworkGatewayConnectionListResult) IsEmpty() bool {
	return vngclr.Value == nil || len(*vngclr.Value) == 0
}

// virtualNetworkGatewayConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vngclr VirtualNetworkGatewayConnectionListResult) virtualNetworkGatewayConnectionListResultPreparer() (*http.Request, error) {
	if vngclr.NextLink == nil || len(to.String(vngclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vngclr.NextLink)))
}

// VirtualNetworkGatewayConnectionListResultPage contains a page of VirtualNetworkGatewayConnection values.
type VirtualNetworkGatewayConnectionListResultPage struct {
	fn     func(VirtualNetworkGatewayConnectionListResult) (VirtualNetworkGatewayConnectionListResult, error)
	vngclr VirtualNetworkGatewayConnectionListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkGatewayConnectionListResultPage) Next() error {
	next, err := page.fn(page.vngclr)
	if err != nil {
		return err
	}
	page.vngclr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkGatewayConnectionListResultPage) NotDone() bool {
	return !page.vngclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkGatewayConnectionListResultPage) Response() VirtualNetworkGatewayConnectionListResult {
	return page.vngclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkGatewayConnectionListResultPage) Values() []VirtualNetworkGatewayConnection {
	if page.vngclr.IsEmpty() {
		return nil
	}
	return *page.vngclr.Value
}

// VirtualNetworkGatewayConnectionPropertiesFormat virtualNetworkGatewayConnection properties
type VirtualNetworkGatewayConnectionPropertiesFormat struct {
	// AuthorizationKey - The authorizationKey.
	AuthorizationKey       *string                `json:"authorizationKey,omitempty"`
	VirtualNetworkGateway1 *VirtualNetworkGateway `json:"virtualNetworkGateway1,omitempty"`
	VirtualNetworkGateway2 *VirtualNetworkGateway `json:"virtualNetworkGateway2,omitempty"`
	LocalNetworkGateway2   *LocalNetworkGateway   `json:"localNetworkGateway2,omitempty"`
	// ConnectionType - Gateway connection type. Possible values are: 'Ipsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Possible values include: 'IPsec', 'Vnet2Vnet', 'ExpressRoute', 'VPNClient'
	ConnectionType VirtualNetworkGatewayConnectionType `json:"connectionType,omitempty"`
	// RoutingWeight - The routing weight.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`
	// SharedKey - The IPSec shared key.
	SharedKey *string `json:"sharedKey,omitempty"`
	// ConnectionStatus - Virtual network Gateway connection status. Possible values are 'Unknown', 'Connecting', 'Connected' and 'NotConnected'. Possible values include: 'VirtualNetworkGatewayConnectionStatusUnknown', 'VirtualNetworkGatewayConnectionStatusConnecting', 'VirtualNetworkGatewayConnectionStatusConnected', 'VirtualNetworkGatewayConnectionStatusNotConnected'
	ConnectionStatus VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty"`
	// TunnelConnectionStatus - Collection of all tunnels' connection health status.
	TunnelConnectionStatus *[]TunnelConnectionHealth `json:"tunnelConnectionStatus,omitempty"`
	// EgressBytesTransferred - The egress bytes transferred in this connection.
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty"`
	// IngressBytesTransferred - The ingress bytes transferred in this connection.
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty"`
	// Peer - The reference to peerings resource.
	Peer *SubResource `json:"peer,omitempty"`
	// EnableBgp - EnableBgp flag
	EnableBgp *bool `json:"enableBgp,omitempty"`
	// UsePolicyBasedTrafficSelectors - Enable policy-based traffic selectors.
	UsePolicyBasedTrafficSelectors *bool `json:"usePolicyBasedTrafficSelectors,omitempty"`
	// IpsecPolicies - The IPSec Policies to be considered by this connection.
	IpsecPolicies *[]IpsecPolicy `json:"ipsecPolicies,omitempty"`
	// ResourceGUID - The resource GUID property of the VirtualNetworkGatewayConnection resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the VirtualNetworkGatewayConnection resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewayConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type VirtualNetworkGatewayConnectionsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewayConnectionsCreateOrUpdateFuture) Result(client VirtualNetworkGatewayConnectionsClient) (vngc VirtualNetworkGatewayConnection, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return vngc, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		vngc, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	vngc, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkGatewayConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewayConnectionsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewayConnectionsDeleteFuture) Result(client VirtualNetworkGatewayConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewayConnectionsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkGatewayConnectionsResetSharedKeyFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type VirtualNetworkGatewayConnectionsResetSharedKeyFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewayConnectionsResetSharedKeyFuture) Result(client VirtualNetworkGatewayConnectionsClient) (crsk ConnectionResetSharedKey, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return crsk, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		crsk, err = client.ResetSharedKeyResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture", "Result", resp, "Failure sending request")
		return
	}
	crsk, err = client.ResetSharedKeyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkGatewayConnectionsSetSharedKeyFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewayConnectionsSetSharedKeyFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewayConnectionsSetSharedKeyFuture) Result(client VirtualNetworkGatewayConnectionsClient) (csk ConnectionSharedKey, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return csk, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		csk, err = client.SetSharedKeyResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture", "Result", resp, "Failure sending request")
		return
	}
	csk, err = client.SetSharedKeyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkGatewayIPConfiguration IP configuration for virtual network gateway
type VirtualNetworkGatewayIPConfiguration struct {
	*VirtualNetworkGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGatewayIPConfiguration.
func (vngic VirtualNetworkGatewayIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vngic.VirtualNetworkGatewayIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = vngic.VirtualNetworkGatewayIPConfigurationPropertiesFormat
	}
	if vngic.Name != nil {
		objectMap["name"] = vngic.Name
	}
	if vngic.Etag != nil {
		objectMap["etag"] = vngic.Etag
	}
	if vngic.ID != nil {
		objectMap["id"] = vngic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGatewayIPConfiguration struct.
func (vngic *VirtualNetworkGatewayIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayIPConfigurationPropertiesFormat VirtualNetworkGatewayIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				vngic.VirtualNetworkGatewayIPConfigurationPropertiesFormat = &virtualNetworkGatewayIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vngic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vngic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vngic.ID = &ID
			}
		}
	}

	return nil
}

// VirtualNetworkGatewayIPConfigurationPropertiesFormat properties of VirtualNetworkGatewayIPConfiguration
type VirtualNetworkGatewayIPConfigurationPropertiesFormat struct {
	// PrivateIPAllocationMethod - The private IP allocation method. Possible values are: 'Static' and 'Dynamic'. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - The reference of the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - The reference of the public IP resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewayListResult response for the ListVirtualNetworkGateways API service call.
type VirtualNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of VirtualNetworkGateway resources that exists in a resource group.
	Value *[]VirtualNetworkGateway `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkGatewayListResultIterator provides access to a complete listing of VirtualNetworkGateway values.
type VirtualNetworkGatewayListResultIterator struct {
	i    int
	page VirtualNetworkGatewayListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkGatewayListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkGatewayListResultIterator) Response() VirtualNetworkGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkGatewayListResultIterator) Value() VirtualNetworkGateway {
	if !iter.page.NotDone() {
		return VirtualNetworkGateway{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (vnglr VirtualNetworkGatewayListResult) IsEmpty() bool {
	return vnglr.Value == nil || len(*vnglr.Value) == 0
}

// virtualNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnglr VirtualNetworkGatewayListResult) virtualNetworkGatewayListResultPreparer() (*http.Request, error) {
	if vnglr.NextLink == nil || len(to.String(vnglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnglr.NextLink)))
}

// VirtualNetworkGatewayListResultPage contains a page of VirtualNetworkGateway values.
type VirtualNetworkGatewayListResultPage struct {
	fn    func(VirtualNetworkGatewayListResult) (VirtualNetworkGatewayListResult, error)
	vnglr VirtualNetworkGatewayListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkGatewayListResultPage) Next() error {
	next, err := page.fn(page.vnglr)
	if err != nil {
		return err
	}
	page.vnglr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkGatewayListResultPage) NotDone() bool {
	return !page.vnglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkGatewayListResultPage) Response() VirtualNetworkGatewayListResult {
	return page.vnglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkGatewayListResultPage) Values() []VirtualNetworkGateway {
	if page.vnglr.IsEmpty() {
		return nil
	}
	return *page.vnglr.Value
}

// VirtualNetworkGatewayPropertiesFormat virtualNetworkGateway properties
type VirtualNetworkGatewayPropertiesFormat struct {
	// IPConfigurations - IP configurations for virtual network gateway.
	IPConfigurations *[]VirtualNetworkGatewayIPConfiguration `json:"ipConfigurations,omitempty"`
	// GatewayType - The type of this virtual network gateway. Possible values are: 'Vpn' and 'ExpressRoute'. Possible values include: 'VirtualNetworkGatewayTypeVpn', 'VirtualNetworkGatewayTypeExpressRoute'
	GatewayType VirtualNetworkGatewayType `json:"gatewayType,omitempty"`
	// VpnType - The type of this virtual network gateway. Possible values are: 'PolicyBased' and 'RouteBased'. Possible values include: 'PolicyBased', 'RouteBased'
	VpnType VpnType `json:"vpnType,omitempty"`
	// EnableBgp - Whether BGP is enabled for this virtual network gateway or not.
	EnableBgp *bool `json:"enableBgp,omitempty"`
	// ActiveActive - ActiveActive flag
	ActiveActive *bool `json:"activeActive,omitempty"`
	// GatewayDefaultSite - The reference of the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
	GatewayDefaultSite *SubResource `json:"gatewayDefaultSite,omitempty"`
	// Sku - The reference of the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
	Sku *VirtualNetworkGatewaySku `json:"sku,omitempty"`
	// VpnClientConfiguration - The reference of the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
	VpnClientConfiguration *VpnClientConfiguration `json:"vpnClientConfiguration,omitempty"`
	// BgpSettings - Virtual network gateway's BGP speaker settings.
	BgpSettings *BgpSettings `json:"bgpSettings,omitempty"`
	// ResourceGUID - The resource GUID property of the VirtualNetworkGateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the VirtualNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewaysCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewaysCreateOrUpdateFuture) Result(client VirtualNetworkGatewaysClient) (vng VirtualNetworkGateway, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return vng, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		vng, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	vng, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworkGatewaysDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewaysDeleteFuture) Result(client VirtualNetworkGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkGatewaysGetAdvertisedRoutesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewaysGetAdvertisedRoutesFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewaysGetAdvertisedRoutesFuture) Result(client VirtualNetworkGatewaysClient) (grlr GatewayRouteListResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGetAdvertisedRoutesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return grlr, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysGetAdvertisedRoutesFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		grlr, err = client.GetAdvertisedRoutesResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGetAdvertisedRoutesFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGetAdvertisedRoutesFuture", "Result", resp, "Failure sending request")
		return
	}
	grlr, err = client.GetAdvertisedRoutesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGetAdvertisedRoutesFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkGatewaysGetBgpPeerStatusFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewaysGetBgpPeerStatusFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewaysGetBgpPeerStatusFuture) Result(client VirtualNetworkGatewaysClient) (bpslr BgpPeerStatusListResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGetBgpPeerStatusFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return bpslr, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysGetBgpPeerStatusFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		bpslr, err = client.GetBgpPeerStatusResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGetBgpPeerStatusFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGetBgpPeerStatusFuture", "Result", resp, "Failure sending request")
		return
	}
	bpslr, err = client.GetBgpPeerStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGetBgpPeerStatusFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkGatewaysGetLearnedRoutesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewaysGetLearnedRoutesFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewaysGetLearnedRoutesFuture) Result(client VirtualNetworkGatewaysClient) (grlr GatewayRouteListResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGetLearnedRoutesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return grlr, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysGetLearnedRoutesFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		grlr, err = client.GetLearnedRoutesResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGetLearnedRoutesFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGetLearnedRoutesFuture", "Result", resp, "Failure sending request")
		return
	}
	grlr, err = client.GetLearnedRoutesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGetLearnedRoutesFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkGatewaySku virtualNetworkGatewaySku details
type VirtualNetworkGatewaySku struct {
	// Name - Gateway SKU name. Possible values include: 'VirtualNetworkGatewaySkuNameBasic', 'VirtualNetworkGatewaySkuNameHighPerformance', 'VirtualNetworkGatewaySkuNameStandard', 'VirtualNetworkGatewaySkuNameUltraPerformance', 'VirtualNetworkGatewaySkuNameVpnGw1', 'VirtualNetworkGatewaySkuNameVpnGw2', 'VirtualNetworkGatewaySkuNameVpnGw3'
	Name VirtualNetworkGatewaySkuName `json:"name,omitempty"`
	// Tier - Gateway SKU tier. Possible values include: 'VirtualNetworkGatewaySkuTierBasic', 'VirtualNetworkGatewaySkuTierHighPerformance', 'VirtualNetworkGatewaySkuTierStandard', 'VirtualNetworkGatewaySkuTierUltraPerformance', 'VirtualNetworkGatewaySkuTierVpnGw1', 'VirtualNetworkGatewaySkuTierVpnGw2', 'VirtualNetworkGatewaySkuTierVpnGw3'
	Tier VirtualNetworkGatewaySkuTier `json:"tier,omitempty"`
	// Capacity - The capacity.
	Capacity *int32 `json:"capacity,omitempty"`
}

// VirtualNetworkGatewaysResetFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworkGatewaysResetFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewaysResetFuture) Result(client VirtualNetworkGatewaysClient) (vng VirtualNetworkGateway, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysResetFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return vng, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysResetFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		vng, err = client.ResetResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysResetFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysResetFuture", "Result", resp, "Failure sending request")
		return
	}
	vng, err = client.ResetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysResetFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkListResult response for the ListVirtualNetworks API service call.
type VirtualNetworkListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of VirtualNetwork resources in a resource group.
	Value *[]VirtualNetwork `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkListResultIterator provides access to a complete listing of VirtualNetwork values.
type VirtualNetworkListResultIterator struct {
	i    int
	page VirtualNetworkListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkListResultIterator) Response() VirtualNetworkListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkListResultIterator) Value() VirtualNetwork {
	if !iter.page.NotDone() {
		return VirtualNetwork{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (vnlr VirtualNetworkListResult) IsEmpty() bool {
	return vnlr.Value == nil || len(*vnlr.Value) == 0
}

// virtualNetworkListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnlr VirtualNetworkListResult) virtualNetworkListResultPreparer() (*http.Request, error) {
	if vnlr.NextLink == nil || len(to.String(vnlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnlr.NextLink)))
}

// VirtualNetworkListResultPage contains a page of VirtualNetwork values.
type VirtualNetworkListResultPage struct {
	fn   func(VirtualNetworkListResult) (VirtualNetworkListResult, error)
	vnlr VirtualNetworkListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkListResultPage) Next() error {
	next, err := page.fn(page.vnlr)
	if err != nil {
		return err
	}
	page.vnlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkListResultPage) NotDone() bool {
	return !page.vnlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkListResultPage) Response() VirtualNetworkListResult {
	return page.vnlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkListResultPage) Values() []VirtualNetwork {
	if page.vnlr.IsEmpty() {
		return nil
	}
	return *page.vnlr.Value
}

// VirtualNetworkListUsageResult response for the virtual networks GetUsage API service call.
type VirtualNetworkListUsageResult struct {
	autorest.Response `json:"-"`
	// Value - VirtualNetwork usage stats.
	Value *[]VirtualNetworkUsage `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkListUsageResultIterator provides access to a complete listing of VirtualNetworkUsage values.
type VirtualNetworkListUsageResultIterator struct {
	i    int
	page VirtualNetworkListUsageResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkListUsageResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkListUsageResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkListUsageResultIterator) Response() VirtualNetworkListUsageResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkListUsageResultIterator) Value() VirtualNetworkUsage {
	if !iter.page.NotDone() {
		return VirtualNetworkUsage{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (vnlur VirtualNetworkListUsageResult) IsEmpty() bool {
	return vnlur.Value == nil || len(*vnlur.Value) == 0
}

// virtualNetworkListUsageResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnlur VirtualNetworkListUsageResult) virtualNetworkListUsageResultPreparer() (*http.Request, error) {
	if vnlur.NextLink == nil || len(to.String(vnlur.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnlur.NextLink)))
}

// VirtualNetworkListUsageResultPage contains a page of VirtualNetworkUsage values.
type VirtualNetworkListUsageResultPage struct {
	fn    func(VirtualNetworkListUsageResult) (VirtualNetworkListUsageResult, error)
	vnlur VirtualNetworkListUsageResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkListUsageResultPage) Next() error {
	next, err := page.fn(page.vnlur)
	if err != nil {
		return err
	}
	page.vnlur = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkListUsageResultPage) NotDone() bool {
	return !page.vnlur.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkListUsageResultPage) Response() VirtualNetworkListUsageResult {
	return page.vnlur
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkListUsageResultPage) Values() []VirtualNetworkUsage {
	if page.vnlur.IsEmpty() {
		return nil
	}
	return *page.vnlur.Value
}

// VirtualNetworkPeering peerings in a virtual network resource.
type VirtualNetworkPeering struct {
	autorest.Response                      `json:"-"`
	*VirtualNetworkPeeringPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkPeering.
func (vnp VirtualNetworkPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnp.VirtualNetworkPeeringPropertiesFormat != nil {
		objectMap["properties"] = vnp.VirtualNetworkPeeringPropertiesFormat
	}
	if vnp.Name != nil {
		objectMap["name"] = vnp.Name
	}
	if vnp.Etag != nil {
		objectMap["etag"] = vnp.Etag
	}
	if vnp.ID != nil {
		objectMap["id"] = vnp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkPeering struct.
func (vnp *VirtualNetworkPeering) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkPeeringPropertiesFormat VirtualNetworkPeeringPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkPeeringPropertiesFormat)
				if err != nil {
					return err
				}
				vnp.VirtualNetworkPeeringPropertiesFormat = &virtualNetworkPeeringPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vnp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vnp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vnp.ID = &ID
			}
		}
	}

	return nil
}

// VirtualNetworkPeeringListResult response for ListSubnets API service call. Retrieves all subnets that belong to
// a virtual network.
type VirtualNetworkPeeringListResult struct {
	autorest.Response `json:"-"`
	// Value - The peerings in a virtual network.
	Value *[]VirtualNetworkPeering `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkPeeringListResultIterator provides access to a complete listing of VirtualNetworkPeering values.
type VirtualNetworkPeeringListResultIterator struct {
	i    int
	page VirtualNetworkPeeringListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkPeeringListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkPeeringListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkPeeringListResultIterator) Response() VirtualNetworkPeeringListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkPeeringListResultIterator) Value() VirtualNetworkPeering {
	if !iter.page.NotDone() {
		return VirtualNetworkPeering{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (vnplr VirtualNetworkPeeringListResult) IsEmpty() bool {
	return vnplr.Value == nil || len(*vnplr.Value) == 0
}

// virtualNetworkPeeringListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnplr VirtualNetworkPeeringListResult) virtualNetworkPeeringListResultPreparer() (*http.Request, error) {
	if vnplr.NextLink == nil || len(to.String(vnplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnplr.NextLink)))
}

// VirtualNetworkPeeringListResultPage contains a page of VirtualNetworkPeering values.
type VirtualNetworkPeeringListResultPage struct {
	fn    func(VirtualNetworkPeeringListResult) (VirtualNetworkPeeringListResult, error)
	vnplr VirtualNetworkPeeringListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkPeeringListResultPage) Next() error {
	next, err := page.fn(page.vnplr)
	if err != nil {
		return err
	}
	page.vnplr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkPeeringListResultPage) NotDone() bool {
	return !page.vnplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkPeeringListResultPage) Response() VirtualNetworkPeeringListResult {
	return page.vnplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkPeeringListResultPage) Values() []VirtualNetworkPeering {
	if page.vnplr.IsEmpty() {
		return nil
	}
	return *page.vnplr.Value
}

// VirtualNetworkPeeringPropertiesFormat ...
type VirtualNetworkPeeringPropertiesFormat struct {
	// AllowVirtualNetworkAccess - Whether the VMs in the linked virtual network space would be able to access all the VMs in local Virtual network space.
	AllowVirtualNetworkAccess *bool `json:"allowVirtualNetworkAccess,omitempty"`
	// AllowForwardedTraffic - Whether the forwarded traffic from the VMs in the remote virtual network will be allowed/disallowed.
	AllowForwardedTraffic *bool `json:"allowForwardedTraffic,omitempty"`
	// AllowGatewayTransit - If gateway links can be used in remote virtual networking to link to this virtual network.
	AllowGatewayTransit *bool `json:"allowGatewayTransit,omitempty"`
	// UseRemoteGateways - If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
	UseRemoteGateways *bool `json:"useRemoteGateways,omitempty"`
	// RemoteVirtualNetwork - The reference of the remote virtual network.
	RemoteVirtualNetwork *SubResource `json:"remoteVirtualNetwork,omitempty"`
	// PeeringState - The status of the virtual network peering. Possible values are 'Initiated', 'Connected', and 'Disconnected'. Possible values include: 'Initiated', 'Connected', 'Disconnected'
	PeeringState VirtualNetworkPeeringState `json:"peeringState,omitempty"`
	// ProvisioningState - The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworkPeeringsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkPeeringsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkPeeringsCreateOrUpdateFuture) Result(client VirtualNetworkPeeringsClient) (vnp VirtualNetworkPeering, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkPeeringsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return vnp, azure.NewAsyncOpIncompleteError("network.VirtualNetworkPeeringsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		vnp, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkPeeringsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkPeeringsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	vnp, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkPeeringsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkPeeringsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworkPeeringsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkPeeringsDeleteFuture) Result(client VirtualNetworkPeeringsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkPeeringsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.VirtualNetworkPeeringsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkPeeringsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkPeeringsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkPeeringsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkPropertiesFormat ...
type VirtualNetworkPropertiesFormat struct {
	// AddressSpace - The AddressSpace that contains an array of IP address ranges that can be used by subnets.
	AddressSpace *AddressSpace `json:"addressSpace,omitempty"`
	// DhcpOptions - The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network.
	DhcpOptions *DhcpOptions `json:"dhcpOptions,omitempty"`
	// Subnets - A list of subnets in a Virtual Network.
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// VirtualNetworkPeerings - A list of peerings in a Virtual Network.
	VirtualNetworkPeerings *[]VirtualNetworkPeering `json:"virtualNetworkPeerings,omitempty"`
	// ResourceGUID - The resourceGuid property of the Virtual Network resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworksCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworksCreateOrUpdateFuture) Result(client VirtualNetworksClient) (vn VirtualNetwork, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return vn, azure.NewAsyncOpIncompleteError("network.VirtualNetworksCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		vn, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworksCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	vn, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworksDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworksDeleteFuture) Result(client VirtualNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.VirtualNetworksDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworksDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// VirtualNetworkUsage usage details for subnet.
type VirtualNetworkUsage struct {
	// CurrentValue - Indicates number of IPs used from the Subnet.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// ID - Subnet identifier.
	ID *string `json:"id,omitempty"`
	// Limit - Indicates the size of the subnet.
	Limit *float64 `json:"limit,omitempty"`
	// Name - The name containing common and localized value for usage.
	Name *VirtualNetworkUsageName `json:"name,omitempty"`
	// Unit - Usage units. Returns 'Count'
	Unit *string `json:"unit,omitempty"`
}

// VirtualNetworkUsageName usage strings container.
type VirtualNetworkUsageName struct {
	// LocalizedValue - Localized subnet size and usage string.
	LocalizedValue *string `json:"localizedValue,omitempty"`
	// Value - Subnet size and usage string.
	Value *string `json:"value,omitempty"`
}

// VpnClientConfiguration vpnClientConfiguration for P2S client.
type VpnClientConfiguration struct {
	// VpnClientAddressPool - The reference of the address space resource which represents Address space for P2S VpnClient.
	VpnClientAddressPool *AddressSpace `json:"vpnClientAddressPool,omitempty"`
	// VpnClientRootCertificates - VpnClientRootCertificate for virtual network gateway.
	VpnClientRootCertificates *[]VpnClientRootCertificate `json:"vpnClientRootCertificates,omitempty"`
	// VpnClientRevokedCertificates - VpnClientRevokedCertificate for Virtual network gateway.
	VpnClientRevokedCertificates *[]VpnClientRevokedCertificate `json:"vpnClientRevokedCertificates,omitempty"`
}

// VpnClientParameters vpn Client Parameters for package generation
type VpnClientParameters struct {
	// ProcessorArchitecture - VPN client Processor Architecture. Possible values are: 'AMD64' and 'X86'. Possible values include: 'Amd64', 'X86'
	ProcessorArchitecture ProcessorArchitecture `json:"processorArchitecture,omitempty"`
}

// VpnClientRevokedCertificate VPN client revoked certificate of virtual network gateway.
type VpnClientRevokedCertificate struct {
	*VpnClientRevokedCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VpnClientRevokedCertificate.
func (vcrc VpnClientRevokedCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcrc.VpnClientRevokedCertificatePropertiesFormat != nil {
		objectMap["properties"] = vcrc.VpnClientRevokedCertificatePropertiesFormat
	}
	if vcrc.Name != nil {
		objectMap["name"] = vcrc.Name
	}
	if vcrc.Etag != nil {
		objectMap["etag"] = vcrc.Etag
	}
	if vcrc.ID != nil {
		objectMap["id"] = vcrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VpnClientRevokedCertificate struct.
func (vcrc *VpnClientRevokedCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vpnClientRevokedCertificatePropertiesFormat VpnClientRevokedCertificatePropertiesFormat
				err = json.Unmarshal(*v, &vpnClientRevokedCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				vcrc.VpnClientRevokedCertificatePropertiesFormat = &vpnClientRevokedCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vcrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vcrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vcrc.ID = &ID
			}
		}
	}

	return nil
}

// VpnClientRevokedCertificatePropertiesFormat properties of the revoked VPN client certificate of virtual network
// gateway.
type VpnClientRevokedCertificatePropertiesFormat struct {
	// Thumbprint - The revoked VPN client certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ProvisioningState - The provisioning state of the VPN client revoked certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VpnClientRootCertificate VPN client root certificate of virtual network gateway
type VpnClientRootCertificate struct {
	*VpnClientRootCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VpnClientRootCertificate.
func (vcrc VpnClientRootCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcrc.VpnClientRootCertificatePropertiesFormat != nil {
		objectMap["properties"] = vcrc.VpnClientRootCertificatePropertiesFormat
	}
	if vcrc.Name != nil {
		objectMap["name"] = vcrc.Name
	}
	if vcrc.Etag != nil {
		objectMap["etag"] = vcrc.Etag
	}
	if vcrc.ID != nil {
		objectMap["id"] = vcrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VpnClientRootCertificate struct.
func (vcrc *VpnClientRootCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vpnClientRootCertificatePropertiesFormat VpnClientRootCertificatePropertiesFormat
				err = json.Unmarshal(*v, &vpnClientRootCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				vcrc.VpnClientRootCertificatePropertiesFormat = &vpnClientRootCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vcrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vcrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vcrc.ID = &ID
			}
		}
	}

	return nil
}

// VpnClientRootCertificatePropertiesFormat properties of SSL certificates of application gateway
type VpnClientRootCertificatePropertiesFormat struct {
	// PublicCertData - The certificate public data.
	PublicCertData *string `json:"publicCertData,omitempty"`
	// ProvisioningState - The provisioning state of the VPN client root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Watcher network watcher in a resource group.
type Watcher struct {
	autorest.Response `json:"-"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag                     *string `json:"etag,omitempty"`
	*WatcherPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Watcher.
func (w Watcher) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.Etag != nil {
		objectMap["etag"] = w.Etag
	}
	if w.WatcherPropertiesFormat != nil {
		objectMap["properties"] = w.WatcherPropertiesFormat
	}
	if w.ID != nil {
		objectMap["id"] = w.ID
	}
	if w.Name != nil {
		objectMap["name"] = w.Name
	}
	if w.Type != nil {
		objectMap["type"] = w.Type
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Watcher struct.
func (w *Watcher) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				w.Etag = &etag
			}
		case "properties":
			if v != nil {
				var watcherPropertiesFormat WatcherPropertiesFormat
				err = json.Unmarshal(*v, &watcherPropertiesFormat)
				if err != nil {
					return err
				}
				w.WatcherPropertiesFormat = &watcherPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		}
	}

	return nil
}

// WatcherListResult list of network watcher resources.
type WatcherListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Watcher `json:"value,omitempty"`
}

// WatcherPropertiesFormat the network watcher properties.
type WatcherPropertiesFormat struct {
	// ProvisioningState - The provisioning state of the resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// WatchersCheckConnectivityFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WatchersCheckConnectivityFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future WatchersCheckConnectivityFuture) Result(client WatchersClient) (ci ConnectivityInformation, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersCheckConnectivityFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ci, azure.NewAsyncOpIncompleteError("network.WatchersCheckConnectivityFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ci, err = client.CheckConnectivityResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.WatchersCheckConnectivityFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersCheckConnectivityFuture", "Result", resp, "Failure sending request")
		return
	}
	ci, err = client.CheckConnectivityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersCheckConnectivityFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// WatchersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type WatchersDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future WatchersDeleteFuture) Result(client WatchersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.WatchersDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.WatchersDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// WatchersGetFlowLogStatusFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WatchersGetFlowLogStatusFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future WatchersGetFlowLogStatusFuture) Result(client WatchersClient) (fli FlowLogInformation, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetFlowLogStatusFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return fli, azure.NewAsyncOpIncompleteError("network.WatchersGetFlowLogStatusFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		fli, err = client.GetFlowLogStatusResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.WatchersGetFlowLogStatusFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetFlowLogStatusFuture", "Result", resp, "Failure sending request")
		return
	}
	fli, err = client.GetFlowLogStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetFlowLogStatusFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// WatchersGetNextHopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type WatchersGetNextHopFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future WatchersGetNextHopFuture) Result(client WatchersClient) (nhr NextHopResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetNextHopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return nhr, azure.NewAsyncOpIncompleteError("network.WatchersGetNextHopFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		nhr, err = client.GetNextHopResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.WatchersGetNextHopFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetNextHopFuture", "Result", resp, "Failure sending request")
		return
	}
	nhr, err = client.GetNextHopResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetNextHopFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// WatchersGetTroubleshootingFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WatchersGetTroubleshootingFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future WatchersGetTroubleshootingFuture) Result(client WatchersClient) (tr TroubleshootingResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetTroubleshootingFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return tr, azure.NewAsyncOpIncompleteError("network.WatchersGetTroubleshootingFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		tr, err = client.GetTroubleshootingResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.WatchersGetTroubleshootingFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetTroubleshootingFuture", "Result", resp, "Failure sending request")
		return
	}
	tr, err = client.GetTroubleshootingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetTroubleshootingFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// WatchersGetTroubleshootingResultFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WatchersGetTroubleshootingResultFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future WatchersGetTroubleshootingResultFuture) Result(client WatchersClient) (tr TroubleshootingResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetTroubleshootingResultFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return tr, azure.NewAsyncOpIncompleteError("network.WatchersGetTroubleshootingResultFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		tr, err = client.GetTroubleshootingResultResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.WatchersGetTroubleshootingResultFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetTroubleshootingResultFuture", "Result", resp, "Failure sending request")
		return
	}
	tr, err = client.GetTroubleshootingResultResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetTroubleshootingResultFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// WatchersGetVMSecurityRulesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WatchersGetVMSecurityRulesFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future WatchersGetVMSecurityRulesFuture) Result(client WatchersClient) (sgvr SecurityGroupViewResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetVMSecurityRulesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sgvr, azure.NewAsyncOpIncompleteError("network.WatchersGetVMSecurityRulesFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sgvr, err = client.GetVMSecurityRulesResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.WatchersGetVMSecurityRulesFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetVMSecurityRulesFuture", "Result", resp, "Failure sending request")
		return
	}
	sgvr, err = client.GetVMSecurityRulesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersGetVMSecurityRulesFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// WatchersSetFlowLogConfigurationFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WatchersSetFlowLogConfigurationFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future WatchersSetFlowLogConfigurationFuture) Result(client WatchersClient) (fli FlowLogInformation, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersSetFlowLogConfigurationFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return fli, azure.NewAsyncOpIncompleteError("network.WatchersSetFlowLogConfigurationFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		fli, err = client.SetFlowLogConfigurationResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.WatchersSetFlowLogConfigurationFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersSetFlowLogConfigurationFuture", "Result", resp, "Failure sending request")
		return
	}
	fli, err = client.SetFlowLogConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersSetFlowLogConfigurationFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// WatchersVerifyIPFlowFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type WatchersVerifyIPFlowFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future WatchersVerifyIPFlowFuture) Result(client WatchersClient) (vifr VerificationIPFlowResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersVerifyIPFlowFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return vifr, azure.NewAsyncOpIncompleteError("network.WatchersVerifyIPFlowFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		vifr, err = client.VerifyIPFlowResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.WatchersVerifyIPFlowFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersVerifyIPFlowFuture", "Result", resp, "Failure sending request")
		return
	}
	vifr, err = client.VerifyIPFlowResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.WatchersVerifyIPFlowFuture", "Result", resp, "Failure responding to request")
	}
	return
}
