// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/streetview/publish/v1/rpcmessages.proto

package publish

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Specifies which view of the [Photo][google.streetview.publish.v1.Photo]
// to include in the response.
type PhotoView int32

const (
	// Server reponses do not include the download URL for the photo bytes.
	// The default value.
	PhotoView_BASIC PhotoView = 0
	// Server responses include the download URL for the photo bytes.
	PhotoView_INCLUDE_DOWNLOAD_URL PhotoView = 1
)

// Enum value maps for PhotoView.
var (
	PhotoView_name = map[int32]string{
		0: "BASIC",
		1: "INCLUDE_DOWNLOAD_URL",
	}
	PhotoView_value = map[string]int32{
		"BASIC":                0,
		"INCLUDE_DOWNLOAD_URL": 1,
	}
)

func (x PhotoView) Enum() *PhotoView {
	p := new(PhotoView)
	*p = x
	return p
}

func (x PhotoView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PhotoView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_streetview_publish_v1_rpcmessages_proto_enumTypes[0].Descriptor()
}

func (PhotoView) Type() protoreflect.EnumType {
	return &file_google_streetview_publish_v1_rpcmessages_proto_enumTypes[0]
}

func (x PhotoView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PhotoView.Descriptor instead.
func (PhotoView) EnumDescriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{0}
}

// Request to create a [Photo][google.streetview.publish.v1.Photo].
type CreatePhotoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Photo to create.
	Photo *Photo `protobuf:"bytes,1,opt,name=photo,proto3" json:"photo,omitempty"`
}

func (x *CreatePhotoRequest) Reset() {
	*x = CreatePhotoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePhotoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePhotoRequest) ProtoMessage() {}

func (x *CreatePhotoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePhotoRequest.ProtoReflect.Descriptor instead.
func (*CreatePhotoRequest) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{0}
}

func (x *CreatePhotoRequest) GetPhoto() *Photo {
	if x != nil {
		return x.Photo
	}
	return nil
}

// Request to get a [Photo][google.streetview.publish.v1.Photo].
//
// By default
//
// * does not return the download URL for the photo bytes.
//
// Parameters:
//
// * `view` controls if the download URL for the photo bytes is returned.
type GetPhotoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the [Photo][google.streetview.publish.v1.Photo].
	PhotoId string `protobuf:"bytes,1,opt,name=photo_id,json=photoId,proto3" json:"photo_id,omitempty"`
	// Specifies if a download URL for the photo bytes should be returned in the
	// [Photo][google.streetview.publish.v1.Photo] response.
	View PhotoView `protobuf:"varint,2,opt,name=view,proto3,enum=google.streetview.publish.v1.PhotoView" json:"view,omitempty"`
	// The BCP-47 language code, such as "en-US" or "sr-Latn". For more
	// information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	// If language_code is unspecified, the user's language preference for Google
	// services is used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *GetPhotoRequest) Reset() {
	*x = GetPhotoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPhotoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPhotoRequest) ProtoMessage() {}

func (x *GetPhotoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPhotoRequest.ProtoReflect.Descriptor instead.
func (*GetPhotoRequest) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{1}
}

func (x *GetPhotoRequest) GetPhotoId() string {
	if x != nil {
		return x.PhotoId
	}
	return ""
}

func (x *GetPhotoRequest) GetView() PhotoView {
	if x != nil {
		return x.View
	}
	return PhotoView_BASIC
}

func (x *GetPhotoRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Request to get one or more [Photos][google.streetview.publish.v1.Photo].
// By default
//
// * does not return the download URL for the photo bytes.
//
// Parameters:
//
// * `view` controls if the download URL for the photo bytes is returned.
type BatchGetPhotosRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. IDs of the [Photos][google.streetview.publish.v1.Photo]. HTTP GET
	// requests require the following syntax for the URL query parameter:
	// `photoIds=<id1>&photoIds=<id2>&...`.
	PhotoIds []string `protobuf:"bytes,1,rep,name=photo_ids,json=photoIds,proto3" json:"photo_ids,omitempty"`
	// Specifies if a download URL for the photo bytes should be returned in the
	// Photo response.
	View PhotoView `protobuf:"varint,2,opt,name=view,proto3,enum=google.streetview.publish.v1.PhotoView" json:"view,omitempty"`
	// The BCP-47 language code, such as "en-US" or "sr-Latn". For more
	// information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	// If language_code is unspecified, the user's language preference for Google
	// services is used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *BatchGetPhotosRequest) Reset() {
	*x = BatchGetPhotosRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetPhotosRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetPhotosRequest) ProtoMessage() {}

func (x *BatchGetPhotosRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetPhotosRequest.ProtoReflect.Descriptor instead.
func (*BatchGetPhotosRequest) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{2}
}

func (x *BatchGetPhotosRequest) GetPhotoIds() []string {
	if x != nil {
		return x.PhotoIds
	}
	return nil
}

func (x *BatchGetPhotosRequest) GetView() PhotoView {
	if x != nil {
		return x.View
	}
	return PhotoView_BASIC
}

func (x *BatchGetPhotosRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Response to batch get of [Photos][google.streetview.publish.v1.Photo].
type BatchGetPhotosResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of results for each individual
	// [Photo][google.streetview.publish.v1.Photo] requested, in the same order as
	// the requests in
	// [BatchGetPhotos][google.streetview.publish.v1.StreetViewPublishService.BatchGetPhotos].
	Results []*PhotoResponse `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *BatchGetPhotosResponse) Reset() {
	*x = BatchGetPhotosResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetPhotosResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetPhotosResponse) ProtoMessage() {}

func (x *BatchGetPhotosResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetPhotosResponse.ProtoReflect.Descriptor instead.
func (*BatchGetPhotosResponse) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{3}
}

func (x *BatchGetPhotosResponse) GetResults() []*PhotoResponse {
	if x != nil {
		return x.Results
	}
	return nil
}

// Response payload for a single
// [Photo][google.streetview.publish.v1.Photo]
// in batch operations including
// [BatchGetPhotos][google.streetview.publish.v1.StreetViewPublishService.BatchGetPhotos]
// and
// [BatchUpdatePhotos][google.streetview.publish.v1.StreetViewPublishService.BatchUpdatePhotos].
type PhotoResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status for the operation to get or update a single photo in the batch
	// request.
	Status *status.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// The [Photo][google.streetview.publish.v1.Photo] resource, if the request
	// was successful.
	Photo *Photo `protobuf:"bytes,2,opt,name=photo,proto3" json:"photo,omitempty"`
}

func (x *PhotoResponse) Reset() {
	*x = PhotoResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhotoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhotoResponse) ProtoMessage() {}

func (x *PhotoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhotoResponse.ProtoReflect.Descriptor instead.
func (*PhotoResponse) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{4}
}

func (x *PhotoResponse) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *PhotoResponse) GetPhoto() *Photo {
	if x != nil {
		return x.Photo
	}
	return nil
}

// Request to list all photos that belong to the user sending the request.
//
// By default
//
// * does not return the download URL for the photo bytes.
//
// Parameters:
//
// * `view` controls if the download URL for the photo bytes is returned.
// * `pageSize` determines the maximum number of photos to return.
// * `pageToken` is the next page token value returned from a previous
// [ListPhotos][google.streetview.publish.v1.StreetViewPublishService.ListPhotos]
//     request, if any.
// * `filter` allows filtering by a given parameter. 'placeId' is the only
// parameter supported at the moment.
type ListPhotosRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies if a download URL for the photos bytes should be returned in the
	// Photos response.
	View PhotoView `protobuf:"varint,1,opt,name=view,proto3,enum=google.streetview.publish.v1.PhotoView" json:"view,omitempty"`
	// The maximum number of photos to return.
	// `pageSize` must be non-negative. If `pageSize` is zero or is not provided,
	// the default page size of 100 is used.
	// The number of photos returned in the response may be less than `pageSize`
	// if the number of photos that belong to the user is less than `pageSize`.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The
	// [nextPageToken][google.streetview.publish.v1.ListPhotosResponse.next_page_token]
	// value returned from a previous
	// [ListPhotos][google.streetview.publish.v1.StreetViewPublishService.ListPhotos]
	// request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The filter expression. For example: `placeId=ChIJj61dQgK6j4AR4GeTYWZsKWw`.
	//
	// The only filter supported at the moment is `placeId`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// The BCP-47 language code, such as "en-US" or "sr-Latn". For more
	// information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	// If language_code is unspecified, the user's language preference for Google
	// services is used.
	LanguageCode string `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListPhotosRequest) Reset() {
	*x = ListPhotosRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPhotosRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPhotosRequest) ProtoMessage() {}

func (x *ListPhotosRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPhotosRequest.ProtoReflect.Descriptor instead.
func (*ListPhotosRequest) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{5}
}

func (x *ListPhotosRequest) GetView() PhotoView {
	if x != nil {
		return x.View
	}
	return PhotoView_BASIC
}

func (x *ListPhotosRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPhotosRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPhotosRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPhotosRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Response to list all photos that belong to a user.
type ListPhotosResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of photos. The
	// [pageSize][google.streetview.publish.v1.ListPhotosRequest.page_size] field
	// in the request determines the number of items returned.
	Photos []*Photo `protobuf:"bytes,1,rep,name=photos,proto3" json:"photos,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPhotosResponse) Reset() {
	*x = ListPhotosResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPhotosResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPhotosResponse) ProtoMessage() {}

func (x *ListPhotosResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPhotosResponse.ProtoReflect.Descriptor instead.
func (*ListPhotosResponse) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{6}
}

func (x *ListPhotosResponse) GetPhotos() []*Photo {
	if x != nil {
		return x.Photos
	}
	return nil
}

func (x *ListPhotosResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to update the metadata of a
// [Photo][google.streetview.publish.v1.Photo]. Updating the pixels of a photo
// is not supported.
type UpdatePhotoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. [Photo][google.streetview.publish.v1.Photo] object containing the
	// new metadata.
	Photo *Photo `protobuf:"bytes,1,opt,name=photo,proto3" json:"photo,omitempty"`
	// Mask that identifies fields on the photo metadata to update.
	// If not present, the old [Photo][google.streetview.publish.v1.Photo]
	// metadata is entirely replaced with the
	// new [Photo][google.streetview.publish.v1.Photo] metadata in this request.
	// The update fails if invalid fields are specified. Multiple fields can be
	// specified in a comma-delimited list.
	//
	// The following fields are valid:
	//
	// * `pose.heading`
	// * `pose.latLngPair`
	// * `pose.pitch`
	// * `pose.roll`
	// * `pose.level`
	// * `pose.altitude`
	// * `connections`
	// * `places`
	//
	//
	// <aside class="note"><b>Note:</b>  When
	// [updateMask][google.streetview.publish.v1.UpdatePhotoRequest.update_mask]
	// contains repeated fields, the entire set of repeated values get replaced
	// with the new contents. For example, if
	// [updateMask][google.streetview.publish.v1.UpdatePhotoRequest.update_mask]
	// contains `connections` and `UpdatePhotoRequest.photo.connections` is empty,
	// all connections are removed.</aside>
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePhotoRequest) Reset() {
	*x = UpdatePhotoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePhotoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePhotoRequest) ProtoMessage() {}

func (x *UpdatePhotoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePhotoRequest.ProtoReflect.Descriptor instead.
func (*UpdatePhotoRequest) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{7}
}

func (x *UpdatePhotoRequest) GetPhoto() *Photo {
	if x != nil {
		return x.Photo
	}
	return nil
}

func (x *UpdatePhotoRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to update the metadata of photos.
// Updating the pixels of photos is not supported.
type BatchUpdatePhotosRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of
	// [UpdatePhotoRequests][google.streetview.publish.v1.UpdatePhotoRequest].
	UpdatePhotoRequests []*UpdatePhotoRequest `protobuf:"bytes,1,rep,name=update_photo_requests,json=updatePhotoRequests,proto3" json:"update_photo_requests,omitempty"`
}

func (x *BatchUpdatePhotosRequest) Reset() {
	*x = BatchUpdatePhotosRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdatePhotosRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdatePhotosRequest) ProtoMessage() {}

func (x *BatchUpdatePhotosRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdatePhotosRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdatePhotosRequest) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{8}
}

func (x *BatchUpdatePhotosRequest) GetUpdatePhotoRequests() []*UpdatePhotoRequest {
	if x != nil {
		return x.UpdatePhotoRequests
	}
	return nil
}

// Response to batch update of metadata of one or more
// [Photos][google.streetview.publish.v1.Photo].
type BatchUpdatePhotosResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of results for each individual
	// [Photo][google.streetview.publish.v1.Photo] updated, in the same order as
	// the request.
	Results []*PhotoResponse `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *BatchUpdatePhotosResponse) Reset() {
	*x = BatchUpdatePhotosResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdatePhotosResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdatePhotosResponse) ProtoMessage() {}

func (x *BatchUpdatePhotosResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdatePhotosResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdatePhotosResponse) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{9}
}

func (x *BatchUpdatePhotosResponse) GetResults() []*PhotoResponse {
	if x != nil {
		return x.Results
	}
	return nil
}

// Request to delete a [Photo][google.streetview.publish.v1.Photo].
type DeletePhotoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the [Photo][google.streetview.publish.v1.Photo].
	PhotoId string `protobuf:"bytes,1,opt,name=photo_id,json=photoId,proto3" json:"photo_id,omitempty"`
}

func (x *DeletePhotoRequest) Reset() {
	*x = DeletePhotoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePhotoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePhotoRequest) ProtoMessage() {}

func (x *DeletePhotoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePhotoRequest.ProtoReflect.Descriptor instead.
func (*DeletePhotoRequest) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{10}
}

func (x *DeletePhotoRequest) GetPhotoId() string {
	if x != nil {
		return x.PhotoId
	}
	return ""
}

// Request to delete multiple [Photos][google.streetview.publish.v1.Photo].
type BatchDeletePhotosRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. IDs of the [Photos][google.streetview.publish.v1.Photo]. HTTP
	// GET requests require the following syntax for the URL query parameter:
	// `photoIds=<id1>&photoIds=<id2>&...`.
	PhotoIds []string `protobuf:"bytes,1,rep,name=photo_ids,json=photoIds,proto3" json:"photo_ids,omitempty"`
}

func (x *BatchDeletePhotosRequest) Reset() {
	*x = BatchDeletePhotosRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeletePhotosRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeletePhotosRequest) ProtoMessage() {}

func (x *BatchDeletePhotosRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeletePhotosRequest.ProtoReflect.Descriptor instead.
func (*BatchDeletePhotosRequest) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{11}
}

func (x *BatchDeletePhotosRequest) GetPhotoIds() []string {
	if x != nil {
		return x.PhotoIds
	}
	return nil
}

// Response to batch delete of one or more
// [Photos][google.streetview.publish.v1.Photo].
type BatchDeletePhotosResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status for the operation to delete a single
	// [Photo][google.streetview.publish.v1.Photo] in the batch request.
	Status []*status.Status `protobuf:"bytes,1,rep,name=status,proto3" json:"status,omitempty"`
}

func (x *BatchDeletePhotosResponse) Reset() {
	*x = BatchDeletePhotosResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeletePhotosResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeletePhotosResponse) ProtoMessage() {}

func (x *BatchDeletePhotosResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeletePhotosResponse.ProtoReflect.Descriptor instead.
func (*BatchDeletePhotosResponse) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP(), []int{12}
}

func (x *BatchDeletePhotosResponse) GetStatus() []*status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

var File_google_streetview_publish_v1_rpcmessages_proto protoreflect.FileDescriptor

var file_google_streetview_publish_v1_rpcmessages_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76,
	0x69, 0x65, 0x77, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x72,
	0x70, 0x63, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76,
	0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4f, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a,
	0x05, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77,
	0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x74,
	0x6f, 0x52, 0x05, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x22, 0x8e, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74,
	0x50, 0x68, 0x6f, 0x74, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08,
	0x70, 0x68, 0x6f, 0x74, 0x6f, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x70, 0x68, 0x6f, 0x74, 0x6f, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04,
	0x76, 0x69, 0x65, 0x77, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x15, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x49, 0x64, 0x73,
	0x12, 0x3b, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69,
	0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68,
	0x6f, 0x74, 0x6f, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x23, 0x0a,
	0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x22, 0x5f, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x50, 0x68,
	0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x07,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65,
	0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f,
	0x74, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x22, 0x76, 0x0a, 0x0d, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x39, 0x0a, 0x05, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76,
	0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x68, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x22, 0xc9, 0x01, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3b, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76,
	0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x68, 0x6f, 0x74, 0x6f, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x79, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a,
	0x06, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65,
	0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f,
	0x74, 0x6f, 0x52, 0x06, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x8c, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x6f,
	0x74, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x05, 0x70, 0x68, 0x6f,
	0x74, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x70,
	0x68, 0x6f, 0x74, 0x6f, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0x80, 0x01, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x64,
	0x0a, 0x15, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65,
	0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x13, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x22, 0x62, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x45, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65,
	0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52,
	0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x2f, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19,
	0x0a, 0x08, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x49, 0x64, 0x22, 0x37, 0x0a, 0x18, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x49,
	0x64, 0x73, 0x22, 0x47, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2a, 0x30, 0x0a, 0x09, 0x50,
	0x68, 0x6f, 0x74, 0x6f, 0x56, 0x69, 0x65, 0x77, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49,
	0x43, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x5f, 0x44,
	0x4f, 0x57, 0x4e, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x55, 0x52, 0x4c, 0x10, 0x01, 0x42, 0x8d, 0x01,
	0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f,
	0x2e, 0x75, 0x67, 0x63, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x42, 0x1c, 0x53, 0x74, 0x72, 0x65,
	0x65, 0x74, 0x56, 0x69, 0x65, 0x77, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x70, 0x63,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x5a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x2f, 0x76, 0x31, 0x3b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_streetview_publish_v1_rpcmessages_proto_rawDescOnce sync.Once
	file_google_streetview_publish_v1_rpcmessages_proto_rawDescData = file_google_streetview_publish_v1_rpcmessages_proto_rawDesc
)

func file_google_streetview_publish_v1_rpcmessages_proto_rawDescGZIP() []byte {
	file_google_streetview_publish_v1_rpcmessages_proto_rawDescOnce.Do(func() {
		file_google_streetview_publish_v1_rpcmessages_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_streetview_publish_v1_rpcmessages_proto_rawDescData)
	})
	return file_google_streetview_publish_v1_rpcmessages_proto_rawDescData
}

var file_google_streetview_publish_v1_rpcmessages_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_streetview_publish_v1_rpcmessages_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_streetview_publish_v1_rpcmessages_proto_goTypes = []interface{}{
	(PhotoView)(0),                    // 0: google.streetview.publish.v1.PhotoView
	(*CreatePhotoRequest)(nil),        // 1: google.streetview.publish.v1.CreatePhotoRequest
	(*GetPhotoRequest)(nil),           // 2: google.streetview.publish.v1.GetPhotoRequest
	(*BatchGetPhotosRequest)(nil),     // 3: google.streetview.publish.v1.BatchGetPhotosRequest
	(*BatchGetPhotosResponse)(nil),    // 4: google.streetview.publish.v1.BatchGetPhotosResponse
	(*PhotoResponse)(nil),             // 5: google.streetview.publish.v1.PhotoResponse
	(*ListPhotosRequest)(nil),         // 6: google.streetview.publish.v1.ListPhotosRequest
	(*ListPhotosResponse)(nil),        // 7: google.streetview.publish.v1.ListPhotosResponse
	(*UpdatePhotoRequest)(nil),        // 8: google.streetview.publish.v1.UpdatePhotoRequest
	(*BatchUpdatePhotosRequest)(nil),  // 9: google.streetview.publish.v1.BatchUpdatePhotosRequest
	(*BatchUpdatePhotosResponse)(nil), // 10: google.streetview.publish.v1.BatchUpdatePhotosResponse
	(*DeletePhotoRequest)(nil),        // 11: google.streetview.publish.v1.DeletePhotoRequest
	(*BatchDeletePhotosRequest)(nil),  // 12: google.streetview.publish.v1.BatchDeletePhotosRequest
	(*BatchDeletePhotosResponse)(nil), // 13: google.streetview.publish.v1.BatchDeletePhotosResponse
	(*Photo)(nil),                     // 14: google.streetview.publish.v1.Photo
	(*status.Status)(nil),             // 15: google.rpc.Status
	(*field_mask.FieldMask)(nil),      // 16: google.protobuf.FieldMask
}
var file_google_streetview_publish_v1_rpcmessages_proto_depIdxs = []int32{
	14, // 0: google.streetview.publish.v1.CreatePhotoRequest.photo:type_name -> google.streetview.publish.v1.Photo
	0,  // 1: google.streetview.publish.v1.GetPhotoRequest.view:type_name -> google.streetview.publish.v1.PhotoView
	0,  // 2: google.streetview.publish.v1.BatchGetPhotosRequest.view:type_name -> google.streetview.publish.v1.PhotoView
	5,  // 3: google.streetview.publish.v1.BatchGetPhotosResponse.results:type_name -> google.streetview.publish.v1.PhotoResponse
	15, // 4: google.streetview.publish.v1.PhotoResponse.status:type_name -> google.rpc.Status
	14, // 5: google.streetview.publish.v1.PhotoResponse.photo:type_name -> google.streetview.publish.v1.Photo
	0,  // 6: google.streetview.publish.v1.ListPhotosRequest.view:type_name -> google.streetview.publish.v1.PhotoView
	14, // 7: google.streetview.publish.v1.ListPhotosResponse.photos:type_name -> google.streetview.publish.v1.Photo
	14, // 8: google.streetview.publish.v1.UpdatePhotoRequest.photo:type_name -> google.streetview.publish.v1.Photo
	16, // 9: google.streetview.publish.v1.UpdatePhotoRequest.update_mask:type_name -> google.protobuf.FieldMask
	8,  // 10: google.streetview.publish.v1.BatchUpdatePhotosRequest.update_photo_requests:type_name -> google.streetview.publish.v1.UpdatePhotoRequest
	5,  // 11: google.streetview.publish.v1.BatchUpdatePhotosResponse.results:type_name -> google.streetview.publish.v1.PhotoResponse
	15, // 12: google.streetview.publish.v1.BatchDeletePhotosResponse.status:type_name -> google.rpc.Status
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_streetview_publish_v1_rpcmessages_proto_init() }
func file_google_streetview_publish_v1_rpcmessages_proto_init() {
	if File_google_streetview_publish_v1_rpcmessages_proto != nil {
		return
	}
	file_google_streetview_publish_v1_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePhotoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPhotoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetPhotosRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetPhotosResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhotoResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPhotosRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPhotosResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePhotoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdatePhotosRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdatePhotosResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePhotoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeletePhotosRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_rpcmessages_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeletePhotosResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_streetview_publish_v1_rpcmessages_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_streetview_publish_v1_rpcmessages_proto_goTypes,
		DependencyIndexes: file_google_streetview_publish_v1_rpcmessages_proto_depIdxs,
		EnumInfos:         file_google_streetview_publish_v1_rpcmessages_proto_enumTypes,
		MessageInfos:      file_google_streetview_publish_v1_rpcmessages_proto_msgTypes,
	}.Build()
	File_google_streetview_publish_v1_rpcmessages_proto = out.File
	file_google_streetview_publish_v1_rpcmessages_proto_rawDesc = nil
	file_google_streetview_publish_v1_rpcmessages_proto_goTypes = nil
	file_google_streetview_publish_v1_rpcmessages_proto_depIdxs = nil
}
