package eventhub

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// Listen ...
	Listen AccessRights = "Listen"
	// Manage ...
	Manage AccessRights = "Manage"
	// Send ...
	Send AccessRights = "Send"
)

// PossibleAccessRightsValues returns an array of possible values for the AccessRights const type.
func PossibleAccessRightsValues() []AccessRights {
	return []AccessRights{Listen, Manage, Send}
}

// EntityStatus enumerates the values for entity status.
type EntityStatus string

const (
	// Active ...
	Active EntityStatus = "Active"
	// Creating ...
	Creating EntityStatus = "Creating"
	// Deleting ...
	Deleting EntityStatus = "Deleting"
	// Disabled ...
	Disabled EntityStatus = "Disabled"
	// ReceiveDisabled ...
	ReceiveDisabled EntityStatus = "ReceiveDisabled"
	// Renaming ...
	Renaming EntityStatus = "Renaming"
	// Restoring ...
	Restoring EntityStatus = "Restoring"
	// SendDisabled ...
	SendDisabled EntityStatus = "SendDisabled"
	// Unknown ...
	Unknown EntityStatus = "Unknown"
)

// PossibleEntityStatusValues returns an array of possible values for the EntityStatus const type.
func PossibleEntityStatusValues() []EntityStatus {
	return []EntityStatus{Active, Creating, Deleting, Disabled, ReceiveDisabled, Renaming, Restoring, SendDisabled, Unknown}
}

// NamespaceState enumerates the values for namespace state.
type NamespaceState string

const (
	// NamespaceStateActivating ...
	NamespaceStateActivating NamespaceState = "Activating"
	// NamespaceStateActive ...
	NamespaceStateActive NamespaceState = "Active"
	// NamespaceStateCreated ...
	NamespaceStateCreated NamespaceState = "Created"
	// NamespaceStateCreating ...
	NamespaceStateCreating NamespaceState = "Creating"
	// NamespaceStateDisabled ...
	NamespaceStateDisabled NamespaceState = "Disabled"
	// NamespaceStateDisabling ...
	NamespaceStateDisabling NamespaceState = "Disabling"
	// NamespaceStateEnabling ...
	NamespaceStateEnabling NamespaceState = "Enabling"
	// NamespaceStateFailed ...
	NamespaceStateFailed NamespaceState = "Failed"
	// NamespaceStateRemoved ...
	NamespaceStateRemoved NamespaceState = "Removed"
	// NamespaceStateRemoving ...
	NamespaceStateRemoving NamespaceState = "Removing"
	// NamespaceStateSoftDeleted ...
	NamespaceStateSoftDeleted NamespaceState = "SoftDeleted"
	// NamespaceStateSoftDeleting ...
	NamespaceStateSoftDeleting NamespaceState = "SoftDeleting"
	// NamespaceStateUnknown ...
	NamespaceStateUnknown NamespaceState = "Unknown"
)

// PossibleNamespaceStateValues returns an array of possible values for the NamespaceState const type.
func PossibleNamespaceStateValues() []NamespaceState {
	return []NamespaceState{NamespaceStateActivating, NamespaceStateActive, NamespaceStateCreated, NamespaceStateCreating, NamespaceStateDisabled, NamespaceStateDisabling, NamespaceStateEnabling, NamespaceStateFailed, NamespaceStateRemoved, NamespaceStateRemoving, NamespaceStateSoftDeleted, NamespaceStateSoftDeleting, NamespaceStateUnknown}
}

// Policykey enumerates the values for policykey.
type Policykey string

const (
	// PrimaryKey ...
	PrimaryKey Policykey = "PrimaryKey"
	// SecondaryKey ...
	SecondaryKey Policykey = "SecondaryKey"
)

// PossiblePolicykeyValues returns an array of possible values for the Policykey const type.
func PossiblePolicykeyValues() []Policykey {
	return []Policykey{PrimaryKey, SecondaryKey}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic ...
	Basic SkuName = "Basic"
	// Standard ...
	Standard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{Basic, Standard}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBasic ...
	SkuTierBasic SkuTier = "Basic"
	// SkuTierPremium ...
	SkuTierPremium SkuTier = "Premium"
	// SkuTierStandard ...
	SkuTierStandard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierBasic, SkuTierPremium, SkuTierStandard}
}

// UnavailableReason enumerates the values for unavailable reason.
type UnavailableReason string

const (
	// InvalidName ...
	InvalidName UnavailableReason = "InvalidName"
	// NameInLockdown ...
	NameInLockdown UnavailableReason = "NameInLockdown"
	// NameInUse ...
	NameInUse UnavailableReason = "NameInUse"
	// None ...
	None UnavailableReason = "None"
	// SubscriptionIsDisabled ...
	SubscriptionIsDisabled UnavailableReason = "SubscriptionIsDisabled"
	// TooManyNamespaceInCurrentSubscription ...
	TooManyNamespaceInCurrentSubscription UnavailableReason = "TooManyNamespaceInCurrentSubscription"
)

// PossibleUnavailableReasonValues returns an array of possible values for the UnavailableReason const type.
func PossibleUnavailableReasonValues() []UnavailableReason {
	return []UnavailableReason{InvalidName, NameInLockdown, NameInUse, None, SubscriptionIsDisabled, TooManyNamespaceInCurrentSubscription}
}

// CheckNameAvailabilityParameter parameter supplied to check Namespace name availability operation
type CheckNameAvailabilityParameter struct {
	// Name - Name to check the namespace name availability
	Name *string `json:"name,omitempty"`
}

// CheckNameAvailabilityResult the Result of the CheckNameAvailability operation
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - Value indicating Namespace is availability, true if the Namespace is available; otherwise, false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason for unavailability of a Namespace. Possible values include: 'None', 'InvalidName', 'SubscriptionIsDisabled', 'NameInUse', 'NameInLockdown', 'TooManyNamespaceInCurrentSubscription'
	Reason UnavailableReason `json:"reason,omitempty"`
	// Message - The detailed info regarding the reason associated with the Namespace.
	Message *string `json:"message,omitempty"`
}

// ConsumerGroupCreateOrUpdateParameters parameters supplied to the Create Or Update Consumer Group operation.
type ConsumerGroupCreateOrUpdateParameters struct {
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - ARM type of the Namespace.
	Type *string `json:"type,omitempty"`
	// Name - Name of the consumer group.
	Name                     *string `json:"name,omitempty"`
	*ConsumerGroupProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConsumerGroupCreateOrUpdateParameters.
func (cgcoup ConsumerGroupCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cgcoup.Location != nil {
		objectMap["location"] = cgcoup.Location
	}
	if cgcoup.Type != nil {
		objectMap["type"] = cgcoup.Type
	}
	if cgcoup.Name != nil {
		objectMap["name"] = cgcoup.Name
	}
	if cgcoup.ConsumerGroupProperties != nil {
		objectMap["properties"] = cgcoup.ConsumerGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConsumerGroupCreateOrUpdateParameters struct.
func (cgcoup *ConsumerGroupCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cgcoup.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cgcoup.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cgcoup.Name = &name
			}
		case "properties":
			if v != nil {
				var consumerGroupProperties ConsumerGroupProperties
				err = json.Unmarshal(*v, &consumerGroupProperties)
				if err != nil {
					return err
				}
				cgcoup.ConsumerGroupProperties = &consumerGroupProperties
			}
		}
	}

	return nil
}

// ConsumerGroupListResult the result to the List Consumer Group operation.
type ConsumerGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Consumer Group operation.
	Value *[]ConsumerGroupResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Consumer Group
	NextLink *string `json:"nextLink,omitempty"`
}

// ConsumerGroupListResultIterator provides access to a complete listing of ConsumerGroupResource values.
type ConsumerGroupListResultIterator struct {
	i    int
	page ConsumerGroupListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConsumerGroupListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConsumerGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConsumerGroupListResultIterator) Response() ConsumerGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConsumerGroupListResultIterator) Value() ConsumerGroupResource {
	if !iter.page.NotDone() {
		return ConsumerGroupResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (cglr ConsumerGroupListResult) IsEmpty() bool {
	return cglr.Value == nil || len(*cglr.Value) == 0
}

// consumerGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cglr ConsumerGroupListResult) consumerGroupListResultPreparer() (*http.Request, error) {
	if cglr.NextLink == nil || len(to.String(cglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cglr.NextLink)))
}

// ConsumerGroupListResultPage contains a page of ConsumerGroupResource values.
type ConsumerGroupListResultPage struct {
	fn   func(ConsumerGroupListResult) (ConsumerGroupListResult, error)
	cglr ConsumerGroupListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConsumerGroupListResultPage) Next() error {
	next, err := page.fn(page.cglr)
	if err != nil {
		return err
	}
	page.cglr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConsumerGroupListResultPage) NotDone() bool {
	return !page.cglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConsumerGroupListResultPage) Response() ConsumerGroupListResult {
	return page.cglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConsumerGroupListResultPage) Values() []ConsumerGroupResource {
	if page.cglr.IsEmpty() {
		return nil
	}
	return *page.cglr.Value
}

// ConsumerGroupProperties properties supplied to the Create Or Update Consumer Group operation.
type ConsumerGroupProperties struct {
	// CreatedAt - Exact time the message was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// EventHubPath - The path of the Event Hub.
	EventHubPath *string `json:"eventHubPath,omitempty"`
	// UpdatedAt - The exact time the message was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// UserMetadata - The user metadata.
	UserMetadata *string `json:"userMetadata,omitempty"`
}

// ConsumerGroupResource single item in List or Get Consumer group operation
type ConsumerGroupResource struct {
	autorest.Response        `json:"-"`
	*ConsumerGroupProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConsumerGroupResource.
func (cgr ConsumerGroupResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cgr.ConsumerGroupProperties != nil {
		objectMap["properties"] = cgr.ConsumerGroupProperties
	}
	if cgr.ID != nil {
		objectMap["id"] = cgr.ID
	}
	if cgr.Name != nil {
		objectMap["name"] = cgr.Name
	}
	if cgr.Location != nil {
		objectMap["location"] = cgr.Location
	}
	if cgr.Type != nil {
		objectMap["type"] = cgr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConsumerGroupResource struct.
func (cgr *ConsumerGroupResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var consumerGroupProperties ConsumerGroupProperties
				err = json.Unmarshal(*v, &consumerGroupProperties)
				if err != nil {
					return err
				}
				cgr.ConsumerGroupProperties = &consumerGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cgr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cgr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cgr.Type = &typeVar
			}
		}
	}

	return nil
}

// CreateOrUpdateParameters parameters supplied to the Create Or Update Event Hub operation.
type CreateOrUpdateParameters struct {
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - ARM type of the Namespace.
	Type *string `json:"type,omitempty"`
	// Name - Name of the Event Hub.
	Name        *string `json:"name,omitempty"`
	*Properties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateOrUpdateParameters.
func (coup CreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coup.Location != nil {
		objectMap["location"] = coup.Location
	}
	if coup.Type != nil {
		objectMap["type"] = coup.Type
	}
	if coup.Name != nil {
		objectMap["name"] = coup.Name
	}
	if coup.Properties != nil {
		objectMap["properties"] = coup.Properties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateOrUpdateParameters struct.
func (coup *CreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				coup.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				coup.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				coup.Name = &name
			}
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				coup.Properties = &properties
			}
		}
	}

	return nil
}

// ListResult the result of the List EventHubs operation.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List EventHubs operation.
	Value *[]ResourceType `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of EventHubs.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of ResourceType values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() ResourceType {
	if !iter.page.NotDone() {
		return ResourceType{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer() (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of ResourceType values.
type ListResultPage struct {
	fn func(ListResult) (ListResult, error)
	lr ListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) Next() error {
	next, err := page.fn(page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []ResourceType {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// NamespaceCreateOrUpdateParameters parameters supplied to the Create Or Update Namespace operation.
type NamespaceCreateOrUpdateParameters struct {
	// Location - Namespace location.
	Location *string `json:"location,omitempty"`
	Sku      *Sku    `json:"sku,omitempty"`
	// Tags - Namespace tags.
	Tags                 map[string]*string `json:"tags"`
	*NamespaceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespaceCreateOrUpdateParameters.
func (ncoup NamespaceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ncoup.Location != nil {
		objectMap["location"] = ncoup.Location
	}
	if ncoup.Sku != nil {
		objectMap["sku"] = ncoup.Sku
	}
	if ncoup.Tags != nil {
		objectMap["tags"] = ncoup.Tags
	}
	if ncoup.NamespaceProperties != nil {
		objectMap["properties"] = ncoup.NamespaceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NamespaceCreateOrUpdateParameters struct.
func (ncoup *NamespaceCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ncoup.Location = &location
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ncoup.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ncoup.Tags = tags
			}
		case "properties":
			if v != nil {
				var namespaceProperties NamespaceProperties
				err = json.Unmarshal(*v, &namespaceProperties)
				if err != nil {
					return err
				}
				ncoup.NamespaceProperties = &namespaceProperties
			}
		}
	}

	return nil
}

// NamespaceListResult the response of the List Namespace operation.
type NamespaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Namespace operation.
	Value *[]NamespaceResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of namespaces.
	NextLink *string `json:"nextLink,omitempty"`
}

// NamespaceListResultIterator provides access to a complete listing of NamespaceResource values.
type NamespaceListResultIterator struct {
	i    int
	page NamespaceListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NamespaceListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NamespaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NamespaceListResultIterator) Response() NamespaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NamespaceListResultIterator) Value() NamespaceResource {
	if !iter.page.NotDone() {
		return NamespaceResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (nlr NamespaceListResult) IsEmpty() bool {
	return nlr.Value == nil || len(*nlr.Value) == 0
}

// namespaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nlr NamespaceListResult) namespaceListResultPreparer() (*http.Request, error) {
	if nlr.NextLink == nil || len(to.String(nlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nlr.NextLink)))
}

// NamespaceListResultPage contains a page of NamespaceResource values.
type NamespaceListResultPage struct {
	fn  func(NamespaceListResult) (NamespaceListResult, error)
	nlr NamespaceListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NamespaceListResultPage) Next() error {
	next, err := page.fn(page.nlr)
	if err != nil {
		return err
	}
	page.nlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NamespaceListResultPage) NotDone() bool {
	return !page.nlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NamespaceListResultPage) Response() NamespaceListResult {
	return page.nlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NamespaceListResultPage) Values() []NamespaceResource {
	if page.nlr.IsEmpty() {
		return nil
	}
	return *page.nlr.Value
}

// NamespaceProperties properties of the Namespace supplied for create or update Namespace operation
type NamespaceProperties struct {
	// Status - State of the Namespace. Possible values include: 'NamespaceStateUnknown', 'NamespaceStateCreating', 'NamespaceStateCreated', 'NamespaceStateActivating', 'NamespaceStateEnabling', 'NamespaceStateActive', 'NamespaceStateDisabling', 'NamespaceStateDisabled', 'NamespaceStateSoftDeleting', 'NamespaceStateSoftDeleted', 'NamespaceStateRemoving', 'NamespaceStateRemoved', 'NamespaceStateFailed'
	Status NamespaceState `json:"status,omitempty"`
	// ProvisioningState - Provisioning state of the Namespace.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// CreatedAt - The time the Namespace was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - The time the Namespace was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// ServiceBusEndpoint - Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty"`
	// MetricID - Identifier for Azure Insights metrics
	MetricID *string `json:"metricId,omitempty"`
	// Enabled - Specifies whether this instance is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// NamespaceResource single Namespace item in List or Get Operation
type NamespaceResource struct {
	autorest.Response    `json:"-"`
	Sku                  *Sku `json:"sku,omitempty"`
	*NamespaceProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespaceResource.
func (nr NamespaceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nr.Sku != nil {
		objectMap["sku"] = nr.Sku
	}
	if nr.NamespaceProperties != nil {
		objectMap["properties"] = nr.NamespaceProperties
	}
	if nr.Tags != nil {
		objectMap["tags"] = nr.Tags
	}
	if nr.ID != nil {
		objectMap["id"] = nr.ID
	}
	if nr.Name != nil {
		objectMap["name"] = nr.Name
	}
	if nr.Location != nil {
		objectMap["location"] = nr.Location
	}
	if nr.Type != nil {
		objectMap["type"] = nr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NamespaceResource struct.
func (nr *NamespaceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				nr.Sku = &sku
			}
		case "properties":
			if v != nil {
				var namespaceProperties NamespaceProperties
				err = json.Unmarshal(*v, &namespaceProperties)
				if err != nil {
					return err
				}
				nr.NamespaceProperties = &namespaceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				nr.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				nr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nr.Type = &typeVar
			}
		}
	}

	return nil
}

// NamespacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type NamespacesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future NamespacesCreateOrUpdateFuture) Result(client NamespacesClient) (nr NamespaceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventhub.NamespacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return nr, azure.NewAsyncOpIncompleteError("eventhub.NamespacesCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		nr, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventhub.NamespacesCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventhub.NamespacesCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	nr, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventhub.NamespacesCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// NamespacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type NamespacesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future NamespacesDeleteFuture) Result(client NamespacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventhub.NamespacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("eventhub.NamespacesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventhub.NamespacesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventhub.NamespacesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventhub.NamespacesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// NamespaceUpdateParameter parameters supplied to the Patch/update Namespace operation.
type NamespaceUpdateParameter struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created Namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespaceUpdateParameter.
func (nup NamespaceUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nup.Tags != nil {
		objectMap["tags"] = nup.Tags
	}
	if nup.Sku != nil {
		objectMap["sku"] = nup.Sku
	}
	return json.Marshal(objectMap)
}

// Operation a Event Hub REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.EventHub
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list Event Hub operations. It contains a list of operations and a
// URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Event Hub operations supported by the Microsoft.EventHub resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Properties properties supplied to the Create Or Update Event Hub operation.
type Properties struct {
	// CreatedAt - Exact time the Event Hub was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// MessageRetentionInDays - Number of days to retain the events for this Event Hub.
	MessageRetentionInDays *int64 `json:"messageRetentionInDays,omitempty"`
	// PartitionCount - Number of partitions created for the Event Hub.
	PartitionCount *int64 `json:"partitionCount,omitempty"`
	// PartitionIds - Current number of shards on the Event Hub.
	PartitionIds *[]string `json:"partitionIds,omitempty"`
	// Status - Enumerates the possible values for the status of the Event Hub. Possible values include: 'Active', 'Disabled', 'Restoring', 'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting', 'Renaming', 'Unknown'
	Status EntityStatus `json:"status,omitempty"`
	// UpdatedAt - The exact time the message was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
}

// RegenerateKeysParameters parameters supplied to the Regenerate Authorization Rule keys operation.
type RegenerateKeysParameters struct {
	// Policykey - Key that needs to be regenerated. Possible values include: 'PrimaryKey', 'SecondaryKey'
	Policykey Policykey `json:"policykey,omitempty"`
}

// Resource the Resource definition
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// ResourceListKeys namespace/EventHub Connection String
type ResourceListKeys struct {
	autorest.Response `json:"-"`
	// PrimaryConnectionString - Primary connection string of the created Namespace AuthorizationRule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`
	// SecondaryConnectionString - Secondary connection string of the created Namespace AuthorizationRule.
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
	// PrimaryKey - A base64-encoded 256-bit primary key for signing and validating the SAS token.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - A base64-encoded 256-bit primary key for signing and validating the SAS token.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// KeyName - A string that describes the AuthorizationRule.
	KeyName *string `json:"keyName,omitempty"`
}

// ResourceType single item in List or Get Event Hub operation
type ResourceType struct {
	autorest.Response `json:"-"`
	*Properties       `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceType.
func (rt ResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.Properties != nil {
		objectMap["properties"] = rt.Properties
	}
	if rt.ID != nil {
		objectMap["id"] = rt.ID
	}
	if rt.Name != nil {
		objectMap["name"] = rt.Name
	}
	if rt.Location != nil {
		objectMap["location"] = rt.Location
	}
	if rt.Type != nil {
		objectMap["type"] = rt.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceType struct.
func (rt *ResourceType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				rt.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rt.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rt.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rt.Type = &typeVar
			}
		}
	}

	return nil
}

// SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters supplied to the Create Or Update Authorization
// Rules operation.
type SharedAccessAuthorizationRuleCreateOrUpdateParameters struct {
	// Location - Data center location.
	Location *string `json:"location,omitempty"`
	// Name - Name of the AuthorizationRule.
	Name                                     *string `json:"name,omitempty"`
	*SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedAccessAuthorizationRuleCreateOrUpdateParameters.
func (saarcoup SharedAccessAuthorizationRuleCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saarcoup.Location != nil {
		objectMap["location"] = saarcoup.Location
	}
	if saarcoup.Name != nil {
		objectMap["name"] = saarcoup.Name
	}
	if saarcoup.SharedAccessAuthorizationRuleProperties != nil {
		objectMap["properties"] = saarcoup.SharedAccessAuthorizationRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SharedAccessAuthorizationRuleCreateOrUpdateParameters struct.
func (saarcoup *SharedAccessAuthorizationRuleCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				saarcoup.Location = &location
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				saarcoup.Name = &name
			}
		case "properties":
			if v != nil {
				var sharedAccessAuthorizationRuleProperties SharedAccessAuthorizationRuleProperties
				err = json.Unmarshal(*v, &sharedAccessAuthorizationRuleProperties)
				if err != nil {
					return err
				}
				saarcoup.SharedAccessAuthorizationRuleProperties = &sharedAccessAuthorizationRuleProperties
			}
		}
	}

	return nil
}

// SharedAccessAuthorizationRuleListResult the response from the List Namespace operation.
type SharedAccessAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Authorization Rules operation.
	Value *[]SharedAccessAuthorizationRuleResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains an incomplete list of Authorization Rules
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedAccessAuthorizationRuleListResultIterator provides access to a complete listing of
// SharedAccessAuthorizationRuleResource values.
type SharedAccessAuthorizationRuleListResultIterator struct {
	i    int
	page SharedAccessAuthorizationRuleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedAccessAuthorizationRuleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedAccessAuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedAccessAuthorizationRuleListResultIterator) Response() SharedAccessAuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedAccessAuthorizationRuleListResultIterator) Value() SharedAccessAuthorizationRuleResource {
	if !iter.page.NotDone() {
		return SharedAccessAuthorizationRuleResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (saarlr SharedAccessAuthorizationRuleListResult) IsEmpty() bool {
	return saarlr.Value == nil || len(*saarlr.Value) == 0
}

// sharedAccessAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (saarlr SharedAccessAuthorizationRuleListResult) sharedAccessAuthorizationRuleListResultPreparer() (*http.Request, error) {
	if saarlr.NextLink == nil || len(to.String(saarlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(saarlr.NextLink)))
}

// SharedAccessAuthorizationRuleListResultPage contains a page of SharedAccessAuthorizationRuleResource values.
type SharedAccessAuthorizationRuleListResultPage struct {
	fn     func(SharedAccessAuthorizationRuleListResult) (SharedAccessAuthorizationRuleListResult, error)
	saarlr SharedAccessAuthorizationRuleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedAccessAuthorizationRuleListResultPage) Next() error {
	next, err := page.fn(page.saarlr)
	if err != nil {
		return err
	}
	page.saarlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedAccessAuthorizationRuleListResultPage) NotDone() bool {
	return !page.saarlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedAccessAuthorizationRuleListResultPage) Response() SharedAccessAuthorizationRuleListResult {
	return page.saarlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedAccessAuthorizationRuleListResultPage) Values() []SharedAccessAuthorizationRuleResource {
	if page.saarlr.IsEmpty() {
		return nil
	}
	return *page.saarlr.Value
}

// SharedAccessAuthorizationRuleProperties properties supplied to create or update SharedAccessAuthorizationRule
type SharedAccessAuthorizationRuleProperties struct {
	// Rights - The rights associated with the rule.
	Rights *[]AccessRights `json:"rights,omitempty"`
}

// SharedAccessAuthorizationRuleResource single item in a List or Get AuthorizationRule operation
type SharedAccessAuthorizationRuleResource struct {
	autorest.Response                        `json:"-"`
	*SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedAccessAuthorizationRuleResource.
func (saarr SharedAccessAuthorizationRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saarr.SharedAccessAuthorizationRuleProperties != nil {
		objectMap["properties"] = saarr.SharedAccessAuthorizationRuleProperties
	}
	if saarr.ID != nil {
		objectMap["id"] = saarr.ID
	}
	if saarr.Name != nil {
		objectMap["name"] = saarr.Name
	}
	if saarr.Location != nil {
		objectMap["location"] = saarr.Location
	}
	if saarr.Type != nil {
		objectMap["type"] = saarr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SharedAccessAuthorizationRuleResource struct.
func (saarr *SharedAccessAuthorizationRuleResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sharedAccessAuthorizationRuleProperties SharedAccessAuthorizationRuleProperties
				err = json.Unmarshal(*v, &sharedAccessAuthorizationRuleProperties)
				if err != nil {
					return err
				}
				saarr.SharedAccessAuthorizationRuleProperties = &sharedAccessAuthorizationRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				saarr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				saarr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				saarr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				saarr.Type = &typeVar
			}
		}
	}

	return nil
}

// Sku SKU parameters supplied to the create Namespace operation
type Sku struct {
	// Name - Name of this SKU. Possible values include: 'Basic', 'Standard'
	Name SkuName `json:"name,omitempty"`
	// Tier - The billing tier of this particular SKU. Possible values include: 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Capacity - The Event Hubs throughput units.
	Capacity *int32 `json:"capacity,omitempty"`
}

// TrackedResource definition of Resource
type TrackedResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.ID != nil {
		objectMap["id"] = tr.ID
	}
	if tr.Name != nil {
		objectMap["name"] = tr.Name
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Type != nil {
		objectMap["type"] = tr.Type
	}
	return json.Marshal(objectMap)
}
