/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/tektoncd/pipeline/pkg/apis/pipeline/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// RunLister helps list Runs.
type RunLister interface {
	// List lists all Runs in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.Run, err error)
	// Runs returns an object that can list and get Runs.
	Runs(namespace string) RunNamespaceLister
	RunListerExpansion
}

// runLister implements the RunLister interface.
type runLister struct {
	indexer cache.Indexer
}

// NewRunLister returns a new RunLister.
func NewRunLister(indexer cache.Indexer) RunLister {
	return &runLister{indexer: indexer}
}

// List lists all Runs in the indexer.
func (s *runLister) List(selector labels.Selector) (ret []*v1alpha1.Run, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Run))
	})
	return ret, err
}

// Runs returns an object that can list and get Runs.
func (s *runLister) Runs(namespace string) RunNamespaceLister {
	return runNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// RunNamespaceLister helps list and get Runs.
type RunNamespaceLister interface {
	// List lists all Runs in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.Run, err error)
	// Get retrieves the Run from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.Run, error)
	RunNamespaceListerExpansion
}

// runNamespaceLister implements the RunNamespaceLister
// interface.
type runNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Runs in the indexer for a given namespace.
func (s runNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.Run, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Run))
	})
	return ret, err
}

// Get retrieves the Run from the indexer for a given namespace and name.
func (s runNamespaceLister) Get(name string) (*v1alpha1.Run, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("run"), name)
	}
	return obj.(*v1alpha1.Run), nil
}
