/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/tektoncd/operator/pkg/apis/operator/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeTektonPipelines implements TektonPipelineInterface
type FakeTektonPipelines struct {
	Fake *FakeOperatorV1alpha1
}

var tektonpipelinesResource = schema.GroupVersionResource{Group: "operator.tekton.dev", Version: "v1alpha1", Resource: "tektonpipelines"}

var tektonpipelinesKind = schema.GroupVersionKind{Group: "operator.tekton.dev", Version: "v1alpha1", Kind: "TektonPipeline"}

// Get takes name of the tektonPipeline, and returns the corresponding tektonPipeline object, and an error if there is any.
func (c *FakeTektonPipelines) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.TektonPipeline, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(tektonpipelinesResource, name), &v1alpha1.TektonPipeline{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonPipeline), err
}

// List takes label and field selectors, and returns the list of TektonPipelines that match those selectors.
func (c *FakeTektonPipelines) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.TektonPipelineList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(tektonpipelinesResource, tektonpipelinesKind, opts), &v1alpha1.TektonPipelineList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.TektonPipelineList{ListMeta: obj.(*v1alpha1.TektonPipelineList).ListMeta}
	for _, item := range obj.(*v1alpha1.TektonPipelineList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested tektonPipelines.
func (c *FakeTektonPipelines) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(tektonpipelinesResource, opts))
}

// Create takes the representation of a tektonPipeline and creates it.  Returns the server's representation of the tektonPipeline, and an error, if there is any.
func (c *FakeTektonPipelines) Create(ctx context.Context, tektonPipeline *v1alpha1.TektonPipeline, opts v1.CreateOptions) (result *v1alpha1.TektonPipeline, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(tektonpipelinesResource, tektonPipeline), &v1alpha1.TektonPipeline{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonPipeline), err
}

// Update takes the representation of a tektonPipeline and updates it. Returns the server's representation of the tektonPipeline, and an error, if there is any.
func (c *FakeTektonPipelines) Update(ctx context.Context, tektonPipeline *v1alpha1.TektonPipeline, opts v1.UpdateOptions) (result *v1alpha1.TektonPipeline, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(tektonpipelinesResource, tektonPipeline), &v1alpha1.TektonPipeline{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonPipeline), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeTektonPipelines) UpdateStatus(ctx context.Context, tektonPipeline *v1alpha1.TektonPipeline, opts v1.UpdateOptions) (*v1alpha1.TektonPipeline, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(tektonpipelinesResource, "status", tektonPipeline), &v1alpha1.TektonPipeline{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonPipeline), err
}

// Delete takes name of the tektonPipeline and deletes it. Returns an error if one occurs.
func (c *FakeTektonPipelines) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(tektonpipelinesResource, name), &v1alpha1.TektonPipeline{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeTektonPipelines) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(tektonpipelinesResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.TektonPipelineList{})
	return err
}

// Patch applies the patch and returns the patched tektonPipeline.
func (c *FakeTektonPipelines) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TektonPipeline, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(tektonpipelinesResource, name, pt, data, subresources...), &v1alpha1.TektonPipeline{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonPipeline), err
}
