// Code generated by goa v3.4.0, DO NOT EDIT.
//
// resource HTTP server types
//
// Command:
// $ goa gen github.com/tektoncd/hub/api/design

package server

import (
	resource "github.com/tektoncd/hub/api/gen/resource"
	resourceviews "github.com/tektoncd/hub/api/gen/resource/views"
	goa "goa.design/goa/v3/pkg"
)

// ListResponseBody is the type of the "resource" service "List" endpoint HTTP
// response body.
type ListResponseBody struct {
	Data ResourceDataResponseBodyWithoutVersionCollection `form:"data" json:"data" xml:"data"`
}

// VersionsByIDResponseBody is the type of the "resource" service
// "VersionsByID" endpoint HTTP response body.
type VersionsByIDResponseBody struct {
	Data *VersionsResponseBody `form:"data" json:"data" xml:"data"`
}

// VersionsByIDInternalErrorResponseBody is the type of the "resource" service
// "VersionsByID" endpoint HTTP response body for the "internal-error" error.
type VersionsByIDInternalErrorResponseBody struct {
	// Name is the name of this class of errors.
	Name string `form:"name" json:"name" xml:"name"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID string `form:"id" json:"id" xml:"id"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message string `form:"message" json:"message" xml:"message"`
	// Is the error temporary?
	Temporary bool `form:"temporary" json:"temporary" xml:"temporary"`
	// Is the error a timeout?
	Timeout bool `form:"timeout" json:"timeout" xml:"timeout"`
	// Is the error a server-side fault?
	Fault bool `form:"fault" json:"fault" xml:"fault"`
}

// VersionsByIDNotFoundResponseBody is the type of the "resource" service
// "VersionsByID" endpoint HTTP response body for the "not-found" error.
type VersionsByIDNotFoundResponseBody struct {
	// Name is the name of this class of errors.
	Name string `form:"name" json:"name" xml:"name"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID string `form:"id" json:"id" xml:"id"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message string `form:"message" json:"message" xml:"message"`
	// Is the error temporary?
	Temporary bool `form:"temporary" json:"temporary" xml:"temporary"`
	// Is the error a timeout?
	Timeout bool `form:"timeout" json:"timeout" xml:"timeout"`
	// Is the error a server-side fault?
	Fault bool `form:"fault" json:"fault" xml:"fault"`
}

// ResourceDataResponseBodyWithoutVersionCollection is used to define fields on
// response body types.
type ResourceDataResponseBodyWithoutVersionCollection []*ResourceDataResponseBodyWithoutVersion

// ResourceDataResponseBodyWithoutVersion is used to define fields on response
// body types.
type ResourceDataResponseBodyWithoutVersion struct {
	// ID is the unique id of the resource
	ID uint `form:"id" json:"id" xml:"id"`
	// Name of resource
	Name string `form:"name" json:"name" xml:"name"`
	// Type of catalog to which resource belongs
	Catalog *CatalogResponseBodyMin `form:"catalog" json:"catalog" xml:"catalog"`
	// Categories related to resource
	Categories []*CategoryResponseBody `form:"categories" json:"categories" xml:"categories"`
	// Kind of resource
	Kind string `form:"kind" json:"kind" xml:"kind"`
	// Url path of the resource in hub
	HubURLPath string `form:"hubURLPath" json:"hubURLPath" xml:"hubURLPath"`
	// Latest version of resource
	LatestVersion *ResourceVersionDataResponseBodyWithoutResource `form:"latestVersion" json:"latestVersion" xml:"latestVersion"`
	// Tags related to resource
	Tags []*TagResponseBody `form:"tags" json:"tags" xml:"tags"`
	// Platforms related to resource
	Platforms []*PlatformResponseBody `form:"platforms" json:"platforms" xml:"platforms"`
	// Rating of resource
	Rating float64 `form:"rating" json:"rating" xml:"rating"`
}

// CatalogResponseBodyMin is used to define fields on response body types.
type CatalogResponseBodyMin struct {
	// ID is the unique id of the catalog
	ID uint `form:"id" json:"id" xml:"id"`
	// Name of catalog
	Name string `form:"name" json:"name" xml:"name"`
	// Type of catalog
	Type string `form:"type" json:"type" xml:"type"`
}

// CategoryResponseBody is used to define fields on response body types.
type CategoryResponseBody struct {
	// ID is the unique id of the category
	ID uint `form:"id" json:"id" xml:"id"`
	// Name of category
	Name string `form:"name" json:"name" xml:"name"`
}

// ResourceVersionDataResponseBodyWithoutResource is used to define fields on
// response body types.
type ResourceVersionDataResponseBodyWithoutResource struct {
	// ID is the unique id of resource's version
	ID uint `form:"id" json:"id" xml:"id"`
	// Version of resource
	Version string `form:"version" json:"version" xml:"version"`
	// Display name of version
	DisplayName string `form:"displayName" json:"displayName" xml:"displayName"`
	// Deprecation status of a version
	Deprecated *bool `form:"deprecated,omitempty" json:"deprecated,omitempty" xml:"deprecated,omitempty"`
	// Description of version
	Description string `form:"description" json:"description" xml:"description"`
	// Minimum pipelines version the resource's version is compatible with
	MinPipelinesVersion string `form:"minPipelinesVersion" json:"minPipelinesVersion" xml:"minPipelinesVersion"`
	// Raw URL of resource's yaml file of the version
	RawURL string `form:"rawURL" json:"rawURL" xml:"rawURL"`
	// Web URL of resource's yaml file of the version
	WebURL string `form:"webURL" json:"webURL" xml:"webURL"`
	// Url path of the resource in hub
	HubURLPath string `form:"hubURLPath" json:"hubURLPath" xml:"hubURLPath"`
	// Timestamp when version was last updated
	UpdatedAt string `form:"updatedAt" json:"updatedAt" xml:"updatedAt"`
	// Platforms related to resource version
	Platforms []*PlatformResponseBody `form:"platforms" json:"platforms" xml:"platforms"`
}

// PlatformResponseBody is used to define fields on response body types.
type PlatformResponseBody struct {
	// ID is the unique id of platform
	ID uint `form:"id" json:"id" xml:"id"`
	// Name of platform
	Name string `form:"name" json:"name" xml:"name"`
}

// TagResponseBody is used to define fields on response body types.
type TagResponseBody struct {
	// ID is the unique id of tag
	ID uint `form:"id" json:"id" xml:"id"`
	// Name of tag
	Name string `form:"name" json:"name" xml:"name"`
}

// VersionsResponseBody is used to define fields on response body types.
type VersionsResponseBody struct {
	// Latest Version of resource
	Latest *ResourceVersionDataResponseBodyMin `form:"latest" json:"latest" xml:"latest"`
	// List of all versions of resource
	Versions []*ResourceVersionDataResponseBodyMin `form:"versions" json:"versions" xml:"versions"`
}

// ResourceVersionDataResponseBodyMin is used to define fields on response body
// types.
type ResourceVersionDataResponseBodyMin struct {
	// ID is the unique id of resource's version
	ID uint `form:"id" json:"id" xml:"id"`
	// Version of resource
	Version string `form:"version" json:"version" xml:"version"`
	// Raw URL of resource's yaml file of the version
	RawURL string `form:"rawURL" json:"rawURL" xml:"rawURL"`
	// Web URL of resource's yaml file of the version
	WebURL string `form:"webURL" json:"webURL" xml:"webURL"`
	// Url path of the resource in hub
	HubURLPath string `form:"hubURLPath" json:"hubURLPath" xml:"hubURLPath"`
	// Platforms related to resource version
	Platforms []*PlatformResponseBody `form:"platforms" json:"platforms" xml:"platforms"`
}

// NewListResponseBody builds the HTTP response body from the result of the
// "List" endpoint of the "resource" service.
func NewListResponseBody(res *resourceviews.ResourcesView) *ListResponseBody {
	body := &ListResponseBody{}
	if res.Data != nil {
		body.Data = make([]*ResourceDataResponseBodyWithoutVersion, len(res.Data))
		for i, val := range res.Data {
			body.Data[i] = marshalResourceviewsResourceDataViewToResourceDataResponseBodyWithoutVersion(val)
		}
	}
	return body
}

// NewVersionsByIDResponseBody builds the HTTP response body from the result of
// the "VersionsByID" endpoint of the "resource" service.
func NewVersionsByIDResponseBody(res *resourceviews.ResourceVersionsView) *VersionsByIDResponseBody {
	body := &VersionsByIDResponseBody{}
	if res.Data != nil {
		body.Data = marshalResourceviewsVersionsViewToVersionsResponseBody(res.Data)
	}
	return body
}

// NewVersionsByIDInternalErrorResponseBody builds the HTTP response body from
// the result of the "VersionsByID" endpoint of the "resource" service.
func NewVersionsByIDInternalErrorResponseBody(res *goa.ServiceError) *VersionsByIDInternalErrorResponseBody {
	body := &VersionsByIDInternalErrorResponseBody{
		Name:      res.Name,
		ID:        res.ID,
		Message:   res.Message,
		Temporary: res.Temporary,
		Timeout:   res.Timeout,
		Fault:     res.Fault,
	}
	return body
}

// NewVersionsByIDNotFoundResponseBody builds the HTTP response body from the
// result of the "VersionsByID" endpoint of the "resource" service.
func NewVersionsByIDNotFoundResponseBody(res *goa.ServiceError) *VersionsByIDNotFoundResponseBody {
	body := &VersionsByIDNotFoundResponseBody{
		Name:      res.Name,
		ID:        res.ID,
		Message:   res.Message,
		Temporary: res.Temporary,
		Timeout:   res.Timeout,
		Fault:     res.Fault,
	}
	return body
}

// NewVersionsByIDPayload builds a resource service VersionsByID endpoint
// payload.
func NewVersionsByIDPayload(id uint) *resource.VersionsByIDPayload {
	v := &resource.VersionsByIDPayload{}
	v.ID = id

	return v
}
