/*
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package bitbucketv1

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/url"
	"strings"

	"github.com/mitchellh/mapstructure"
)

// DefaultAPIService default service
type DefaultApiService service

/*AddGroupToUser &lt;strong&gt;Deprecated since 2.10&lt;/strong&gt;. Use /rest/users/add-groups instead.  &lt;p&gt;  Add a user to a group. This is very similar to &lt;code&gt;groups/add-user&lt;/code&gt;, but with the &lt;em&gt;context&lt;/em&gt; and  &lt;em&gt;itemName&lt;/em&gt; attributes of the supplied request entity reversed. On the face of it this may appear  redundant, but it facilitates a specific UI component in Stash.  &lt;p&gt;  In the request entity, the &lt;em&gt;context&lt;/em&gt; attribute is the user and the &lt;em&gt;itemName&lt;/em&gt; is the group.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) AddGroupToUser() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/users/add-group"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* AddUserToGroup
&lt;strong&gt;Deprecated since 2.10&lt;/strong&gt;. Use /rest/users/add-groups instead.  &lt;p&gt;  Add a user to a group.  &lt;p&gt;  In the request entity, the &lt;em&gt;context&lt;/em&gt; attribute is the group and the &lt;em&gt;itemName&lt;/em&gt; is the user.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) AddUserToGroup() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/groups/add-user"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* AddUserToGroups
Add a user to one or more groups.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) AddUserToGroups(name string, groups []string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	localVarPostBody = map[string]interface{}{
		"user":   name,
		"groups": groups,
	}

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/users/add-groups"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
Add multiple users to a group.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) AddUsersToGroup() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/groups/add-users"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Approve a pull request as the current user. Implicitly adds the user as a participant if they are not already.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.  &lt;p&gt;  &lt;strong&gt;Deprecated since 4.2&lt;/strong&gt;. Use  /rest/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug} instead

@param pullRequestId the id of the pull request within the repository
@return */
func (a *DefaultApiService) Approve(projectKey, repositorySlug string, pullRequestID int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/approve"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Assigns a participant to an explicit role in pull request. Currently only the REVIEWER role may be assigned.  &lt;p&gt;  If the user is not yet a participant in the pull request, they are made one and assigned the supplied role.  &lt;p&gt;  If the user is already a participant in the pull request, their previous role is replaced with the supplied role  unless they are already assigned the AUTHOR role which cannot be changed and will result in a Bad Request (400)  response code.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_WRITE&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

@param pullRequestId the id of the pull request within the repository
@return */
func (a *DefaultApiService) AssignParticipantRole(projectKey, repositorySlug string, pullRequestID int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Test whether a pull request can be merged.  &lt;p&gt;  A pull request may not be merged if:  &lt;ul&gt;      &lt;li&gt;there are conflicts that need to be manually resolved before merging; and/or&lt;/li&gt;      &lt;li&gt;one or more merge checks have vetoed the merge.&lt;/li&gt;  &lt;/ul&gt;  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

@param pullRequestId the ID of the pull request within the repository
@return */
func (a *DefaultApiService) CanMerge(projectKey, repositorySlug string, pullRequestID int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/merge"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Clears the server email address.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) ClearSenderAddress() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/mail-server/sender-address"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Clears any CAPTCHA challenge that may constrain the user with the supplied username when they authenticate.  Additionally any counter or metric that contributed towards the user being issued the CAPTCHA challenge  (for instance too many consecutive failed logins) will also be reset.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource, and may not clear  the CAPTCHA of a user with greater permissions than themselves.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string)
 @return */
func (a *DefaultApiService) ClearUserCaptchaChallenge(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/users/captcha"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the total number of {@link TaskState#OPEN open} and  {@link TaskState#RESOLVED resolved} tasks associated with a pull request.

@return */
func (a *DefaultApiService) CountPullRequestTasks(projectKey, repositorySlug string, pullRequestId int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/tasks/count"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Create a new pull request between two branches. The branches may be in the same repository, or different ones.  When using different repositories, they must still be in the same {@link Repository#getHierarchyId() hierarchy}.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the \&quot;from\&quot; and \&quot;to\&quot;repositories to  call this resource.

@return */
func (a *DefaultApiService) Create(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var pullRequest PullRequest

	err := mapstructure.Decode(localVarOptionals, &pullRequest)
	if err != nil {
		return nil, err
	}

	return a.CreatePullRequest(projectKey, repositorySlug, pullRequest)
}

/* DefaultApiService
CreatePullRequest a new pull request between two branches. The branches may be in the same repository, or different ones.  When using different repositories, they must still be in the same {@link Repository#getHierarchyId() hierarchy}.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the \&quot;from\&quot; and \&quot;to\&quot;repositories to  call this resource.

@return */
func (a *DefaultApiService) CreatePullRequest(projectKey, repositorySlug string, pullRequest PullRequest) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	localVarPostBody, err := json.Marshal(pullRequest)
	if err != nil {
		return nil, err
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Creates a branch using the information provided in the {@link RestCreateBranchRequest request}  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_WRITE&lt;/strong&gt; permission for the context repository to call  this resource.

@return */
func (a *DefaultApiService) CreateBranch(projectKey, repositorySlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Add a new comment.  &lt;p&gt;  Comments can be added in a few places by setting different attributes:  &lt;p&gt;  General commit comment:   &lt;pre&gt;      {          \&quot;text\&quot;: \&quot;An insightful general comment on a commit.\&quot;      }      &lt;/pre&gt;   Reply to a comment:   &lt;pre&gt;      {          \&quot;text\&quot;: \&quot;A measured reply.\&quot;,          \&quot;parent\&quot;: {              \&quot;id\&quot;: 1          }      }      &lt;/pre&gt;   General file comment:   &lt;pre&gt;      {          \&quot;text\&quot;: \&quot;An insightful general comment on a file.\&quot;,          \&quot;anchor\&quot;: {              \&quot;diffType\&quot;: \&quot;COMMIT\&quot;,              \&quot;fromHash\&quot;: \&quot;6df3858eeb9a53a911cd17e66a9174d44ffb02cd\&quot;,              \&quot;path\&quot;: \&quot;path/to/file\&quot;,              \&quot;srcPath\&quot;: \&quot;path/to/file\&quot;,              \&quot;toHash\&quot;: \&quot;04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b\&quot;          }      }      &lt;/pre&gt;   File line comment:   &lt;pre&gt;      {          \&quot;text\&quot;: \&quot;A pithy comment on a particular line within a file.\&quot;,          \&quot;anchor\&quot;: {              \&quot;diffType\&quot;: \&quot;COMMIT\&quot;,              \&quot;line\&quot;: 1,              \&quot;lineType\&quot;: \&quot;CONTEXT\&quot;,              \&quot;fileType\&quot;: \&quot;FROM\&quot;,              \&quot;fromHash\&quot;: \&quot;6df3858eeb9a53a911cd17e66a9174d44ffb02cd\&quot;,              \&quot;path\&quot;: \&quot;path/to/file\&quot;,              \&quot;srcPath\&quot;: \&quot;path/to/file\&quot;,              \&quot;toHash\&quot;: \&quot;04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b\&quot;      }      }      &lt;/pre&gt;  &lt;strong&gt;Note: general file comments are an experimental feature and may change in the near future!&lt;/strong&gt;  &lt;p&gt;  For file and line comments, &#39;path&#39; refers to the path of the file to which the comment should be applied and  &#39;srcPath&#39; refers to the path the that file used to have (only required for copies and moves). Also,  fromHash and toHash refer to the sinceId / untilId (respectively) used to produce the diff on which the comment  was added. Finally diffType refers to the type of diff the comment was added on.  &lt;p&gt;  For line comments, &#39;line&#39; refers to the line in the diff that the comment should apply to. &#39;lineType&#39; refers to  the type of diff hunk, which can be:  &lt;ul&gt;      &lt;li&gt;&#39;ADDED&#39; - for an added line;&lt;/li&gt;      &lt;li&gt;&#39;REMOVED&#39; - for a removed line; or&lt;/li&gt;      &lt;li&gt;&#39;CONTEXT&#39; - for a line that was unmodified but is in the vicinity of the diff.&lt;/li&gt;  &lt;/ul&gt;  &#39;fileType&#39; refers to the file of the diff to which the anchor should be attached - which is of relevance when  displaying the diff in a side-by-side way. Currently the supported values are:  &lt;ul&gt;      &lt;li&gt;&#39;FROM&#39; - the source file of the diff&lt;/li&gt;      &lt;li&gt;&#39;TO&#39; - the destination file of the diff&lt;/li&gt;  &lt;/ul&gt;  If the current user is not a participant the user is added as one and updated to watch the commit.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that the commit  is in to call this resource.

 @param commitId the commit to which the comments must be anchored
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "since" (string) For a merge commit, a parent can be provided to specify which diff the comments should be on. For                  a commit range, a {@code sinceId} can be provided to specify where the comments should be                  anchored from.
 @return */
func (a *DefaultApiService) CreateComment(projectKey, repositorySlug string, commitId string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	return a.CreateCommentWithComment(projectKey, repositorySlug, commitId, Comment{}, localVarOptionals)
}

func (a *DefaultApiService) CreateCommentWithComment(projectKey, repositorySlug string, commitId string, comment Comment, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	var err error
	localVarPostBody, err = json.Marshal(comment)
	if err != nil {
		return nil, err
	}

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["since"], "string", "since"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["since"].(string); localVarOk {
		localVarQueryParams.Add("since", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Add a new comment.  &lt;p&gt;  Comments can be added in a few places by setting different attributes:  &lt;p&gt;  General pull request comment:   &lt;pre&gt;      {          \&quot;text\&quot;: \&quot;An insightful general comment on a pull request.\&quot;      }      &lt;/pre&gt;   Reply to a comment:   &lt;pre&gt;      {          \&quot;text\&quot;: \&quot;A measured reply.\&quot;,          \&quot;parent\&quot;: {              \&quot;id\&quot;: 1          }      }      &lt;/pre&gt;   General file comment:   &lt;pre&gt;      {          \&quot;text\&quot;: \&quot;An insightful general comment on a file.\&quot;,          \&quot;anchor\&quot;: {              \&quot;diffType\&quot;: \&quot;RANGE\&quot;,              \&quot;fromHash\&quot;: \&quot;6df3858eeb9a53a911cd17e66a9174d44ffb02cd\&quot;,              \&quot;path\&quot;: \&quot;path/to/file\&quot;,              \&quot;srcPath\&quot;: \&quot;path/to/file\&quot;,              \&quot;toHash\&quot;: \&quot;04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b\&quot;          }      }      &lt;/pre&gt;   File line comment:   &lt;pre&gt;      {          \&quot;text\&quot;: \&quot;A pithy comment on a particular line within a file.\&quot;,          \&quot;anchor\&quot;: {              \&quot;diffType\&quot;: \&quot;COMMIT\&quot;,              \&quot;line\&quot;: 1,              \&quot;lineType\&quot;: \&quot;CONTEXT\&quot;,              \&quot;fileType\&quot;: \&quot;FROM\&quot;,              \&quot;fromHash\&quot;: \&quot;6df3858eeb9a53a911cd17e66a9174d44ffb02cd\&quot;,              \&quot;path\&quot;: \&quot;path/to/file\&quot;,              \&quot;srcPath\&quot;: \&quot;path/to/file\&quot;,              \&quot;toHash\&quot;: \&quot;04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b\&quot;          }      }      &lt;/pre&gt;  &lt;p&gt;  For file and line comments, &#39;path&#39; refers to the path of the file to which the comment should be applied and  &#39;srcPath&#39; refers to the path the that file used to have (only required for copies and moves). Also,  fromHash and toHash refer to the sinceId / untilId (respectively) used to produce the diff on which the comment  was added. Finally diffType refers to the type of diff the comment was added on. For backwards compatibility  purposes if no diffType is provided and no fromHash/toHash pair is provided the diffType will be resolved to  &#39;EFFECTIVE&#39;. In any other cases the diffType is REQUIRED.  &lt;p&gt;  For line comments, &#39;line&#39; refers to the line in the diff that the comment should apply to. &#39;lineType&#39; refers to  the type of diff hunk, which can be:  &lt;ul&gt;      &lt;li&gt;&#39;ADDED&#39; - for an added line;&lt;/li&gt;      &lt;li&gt;&#39;REMOVED&#39; - for a removed line; or&lt;/li&gt;      &lt;li&gt;&#39;CONTEXT&#39; - for a line that was unmodified but is in the vicinity of the diff.&lt;/li&gt;  &lt;/ul&gt;  &#39;fileType&#39; refers to the file of the diff to which the anchor should be attached - which is of relevance when  displaying the diff in a side-by-side way. Currently the supported values are:  &lt;ul&gt;      &lt;li&gt;&#39;FROM&#39; - the source file of the diff&lt;/li&gt;      &lt;li&gt;&#39;TO&#39; - the destination file of the diff&lt;/li&gt;  &lt;/ul&gt;  If the current user is not a participant the user is added as a watcher of the pull request.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

@return */
func (a *DefaultApiService) CreatePullRequestComment(projectKey, repositorySlug string, pullRequestID int, comment Comment, localVarHTTPContentTypes []string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarFileName   string
		localVarFileBytes  []byte
	)

	localVarPostBody, err := json.Marshal(comment)
	if err != nil {
		return nil, err
	}

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Create a new group.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) Name of the group.
 @return */
func (a *DefaultApiService) CreateGroup(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/groups"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Create a new project.  &lt;p&gt;  To include a custom avatar for the project, the project definition should contain an additional attribute with  the key &lt;code&gt;avatar&lt;/code&gt; and the value a data URI containing Base64-encoded image data. The URI should be in  the following format:  &lt;pre&gt;      data:(content type, e.g. image/png);base64,(data)  &lt;/pre&gt;  If the data is not Base64-encoded, or if a character set is defined in the URI, or the URI is otherwise invalid,  &lt;em&gt;project creation will fail&lt;/em&gt;.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_CREATE&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) CreateProject(localVarPostBody Project) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Create a new repository. Requires an existing project in which this repository will be created.  The only parameters which will be used are name and scmId.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the context project to call this  resource.

@param projectKey the parent project key
@return */
func (a *DefaultApiService) CreateRepository(projectKey string, repository Repository) (*APIResponse, error) {

	localVarPostBody, err := json.Marshal(repository)
	if err != nil {
		return nil, err
	}

	return a.CreateRepositoryWithOptions(projectKey, localVarPostBody, []string{"application/json"})
}

func (a *DefaultApiService) CreateRepositoryWithOptions(projectKey string, localVarPostBody interface{}, localVarHTTPContentTypes []string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

func (a *DefaultApiService) CreatePullRequestWithOptions(projectKey, repo string, localVarPostBody interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod       = strings.ToUpper("Post")
		localVarFileName         string
		localVarFileBytes        []byte
		localVarHTTPContentTypes = []string{"application/json"}
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repo), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Creates a tag using the information provided in the {@link RestCreateTagRequest request}  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_WRITE&lt;/strong&gt; permission for the context repository to call this  resource.

@return */
func (a *DefaultApiService) CreateTag(projectKey, repositorySlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/tags"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Create a new task.

@return */
func (a *DefaultApiService) CreateTask() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/tasks"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Creates a new user from the assembled query parameters.  &lt;p&gt;  The default group can be used to control initial permissions for new users, such as granting users the ability  to login or providing read access to certain projects or repositories. If the user is not added to the default  group, they may not be able to login after their account is created until explicit permissions are configured.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) the username for the new user
	 @param "password" (string) the password for the new user
	 @param "displayName" (string) the display name for the new user
	 @param "emailAddress" (string) the e-mail address for the new user
	 @param "addToDefaultGroup" (bool) &lt;code&gt;true&lt;/code&gt; to add the user to the default group, which can be used to grant them                           a set of initial permissions; otherwise, &lt;code&gt;false&lt;/code&gt; to not add them to a group
	 @param "notify" (string) if present and not &lt;code&gt;false&lt;/code&gt; instead of requiring a password,                           the create user will be notified via email their account has been created and requires                           a password to be reset. This option can only be used if a mail server has been configured
 @return */
func (a *DefaultApiService) CreateUser(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/users"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["password"], "string", "password"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["displayName"], "string", "displayName"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["emailAddress"], "string", "emailAddress"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["addToDefaultGroup"], "bool", "addToDefaultGroup"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["notify"], "string", "notify"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["password"].(string); localVarOk {
		localVarQueryParams.Add("password", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["displayName"].(string); localVarOk {
		localVarQueryParams.Add("displayName", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["emailAddress"].(string); localVarOk {
		localVarQueryParams.Add("emailAddress", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["addToDefaultGroup"].(bool); localVarOk {
		localVarQueryParams.Add("addToDefaultGroup", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["notify"].(string); localVarOk {
		localVarQueryParams.Add("notify", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	// No body parsing (a successful 204 response has no content)
	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
Create a webhook for the repository specified via the URL.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

@return */
func (a *DefaultApiService) CreateWebhook(projectKey, repositorySlug string, localVarPostBody interface{}, localVarHTTPContentTypes []string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Decline a pull request.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

 @param pullRequestId
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "version" (int32) the current version of the pull request. If the server&#39;s version isn&#39;t the same as the specified                 version the operation will fail. To determine the current version of the pull request it should be                 fetched from the server prior to this operation. Look for the &#39;version&#39; attribute in the returned                 JSON structure.
 @return */
func (a *DefaultApiService) Decline(projectKey, repositorySlug string, pullRequestID int64, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/decline"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["version"], "int32", "version"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["version"].(int32); localVarOk {
		localVarQueryParams.Add("version", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Deletes a pull request.  &lt;p&gt;  To call this resource, users must be authenticated and have permission to view the pull request.  Additionally, they must:  &lt;ul&gt;      &lt;li&gt;          be the pull request author, if the system is configured to allow authors to delete their own          pull requests (this is the default) OR      &lt;/li&gt;      &lt;li&gt;have repository administrator permission for the repository the pull request is targeting&lt;/li&gt;  &lt;/ul&gt;   A body containing the version of the pull request must be provided with this request.   &lt;pre&gt;&lt;code&gt;{ \&quot;version\&quot;: 1 }&lt;/code&gt;&lt;/pre&gt;

@param pullRequestId the ID of the pull request within the repository
@return */
func (a *DefaultApiService) DeletePullRequest(projectKey, repositorySlug string, pullRequestID int64) (*APIResponse, error) {
	return a.Delete(projectKey, repositorySlug, pullRequestID)
}

/* DefaultApiService
Deletes a pull request.  &lt;p&gt;  To call this resource, users must be authenticated and have permission to view the pull request.  Additionally, they must:  &lt;ul&gt;      &lt;li&gt;          be the pull request author, if the system is configured to allow authors to delete their own          pull requests (this is the default) OR      &lt;/li&gt;      &lt;li&gt;have repository administrator permission for the repository the pull request is targeting&lt;/li&gt;  &lt;/ul&gt;   A body containing the version of the pull request must be provided with this request.   &lt;pre&gt;&lt;code&gt;{ \&quot;version\&quot;: 1 }&lt;/code&gt;&lt;/pre&gt;

@param pullRequestId the ID of the pull request within the repository
@return */
func (a *DefaultApiService) Delete(projectKey, repositorySlug string, pullRequestID int64) (*APIResponse, error) {
	return a.DeleteWithVersion(projectKey, repositorySlug, pullRequestID, 0)
}

/* DefaultApiService
Deletes a pull request.  &lt;p&gt;  To call this resource, users must be authenticated and have permission to view the pull request.  Additionally, they must:  &lt;ul&gt;      &lt;li&gt;          be the pull request author, if the system is configured to allow authors to delete their own          pull requests (this is the default) OR      &lt;/li&gt;      &lt;li&gt;have repository administrator permission for the repository the pull request is targeting&lt;/li&gt;  &lt;/ul&gt;   A body containing the version of the pull request must be provided with this request.   &lt;pre&gt;&lt;code&gt;{ \&quot;version\&quot;: 1 }&lt;/code&gt;&lt;/pre&gt;

@param pullRequestId the ID of the pull request within the repository
@return */
func (a *DefaultApiService) DeleteWithVersion(projectKey, repositorySlug string, pullRequestID, version int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	localVarPostBody = map[string]interface{}{
		"version": version,
	}

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
Delete the avatar associated to a user.  &lt;p&gt;  Users are always allowed to delete their own avatar. To delete someone else&#39;s avatar the authenticated user must  have global &lt;strong&gt;ADMIN&lt;/strong&gt; permission, or global &lt;strong&gt;SYS_ADMIN&lt;/strong&gt; permission to update a  &lt;strong&gt;SYS_ADMIN&lt;/strong&gt; user&#39;s avatar.

@return */
func (a *DefaultApiService) DeleteAvatar(userSlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/users/{userSlug}/avatar.png"
	localVarPath = strings.Replace(localVarPath, "{"+"userSlug"+"}", fmt.Sprintf("%v", userSlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Delete a commit comment. Anyone can delete their own comment. Only users with &lt;strong&gt;REPO_ADMIN&lt;/strong&gt;  and above may delete comments created by other users. Comments which have replies &lt;i&gt;may not be deleted&lt;/i&gt;,  regardless of the user&#39;s granted permissions.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that the commit  is in to call this resource.

 @param commitId the commit to which the comments must be anchored
 @param commentId the ID of the comment to retrieve
 @param commitId2 the &lt;i&gt;full {@link Commit#getId() ID}&lt;/i&gt; of the commit within the repository
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "version" (int32) The expected version of the comment. This must match the server&#39;s version of the comment or                   the delete will fail. To determine the current version of the comment, the comment should be                   fetched from the server prior to the delete. Look for the &#39;version&#39; attribute in the returned                   JSON structure.
 @return */
func (a *DefaultApiService) DeleteComment(projectKey, repositorySlug string, commitId string, commentId int64, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commentId"+"}", fmt.Sprintf("%v", commentId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["version"], "int32", "version"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["version"].(int32); localVarOk {
		localVarQueryParams.Add("version", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Delete a pull request comment. Anyone can delete their own comment. Only users with &lt;strong&gt;REPO_ADMIN&lt;/strong&gt;  and above may delete comments created by other users.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

 @param commentId the id of the comment to retrieve
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "version" (int32) The expected version of the comment. This must match the server&#39;s version of the comment or                     the delete will fail. To determine the current version of the comment, the comment should be                     fetched from the server prior to the delete. Look for the &#39;version&#39; attribute in the                     returned JSON structure.
 @return */
func (a *DefaultApiService) DeleteComment_2(projectKey, repositorySlug string, pullRequestId, commentId int64, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestId), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commentId"+"}", fmt.Sprintf("%v", commentId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["version"], "int32", "version"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["version"].(int32); localVarOk {
		localVarQueryParams.Add("version", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Deletes the specified group, removing them from the system. This also removes any permissions that may have been  granted to the group.  &lt;p&gt;  A user may not delete the last group that is granting them administrative permissions, or a group with greater  permissions than themselves.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) the name identifying the group to delete
 @return */
func (a *DefaultApiService) DeleteGroup(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/groups"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Deletes the current mail configuration.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;SYS_ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) DeleteMailConfig() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/mail-server"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Delete the project matching the supplied &lt;strong&gt;projectKey&lt;/strong&gt;.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project to call this  resource.

@return */
func (a *DefaultApiService) DeleteProject(projectKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Schedule the repository matching the supplied &lt;strong&gt;projectKey&lt;/strong&gt; and &lt;strong&gt;repositorySlug&lt;/strong&gt; to  be deleted. If the request repository is not present  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

@param projectKey the parent project key
@param projectKey2 the parent project key
@param repositorySlug the repository slug
@return */
func (a *DefaultApiService) DeleteRepository(projectKey, repositorySlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Delete repository hook configuration for the supplied &lt;strong&gt;hookKey&lt;/strong&gt; and &lt;strong&gt;repositorySlug&lt;/strong&gt;  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

@param hookKey
@return */
func (a *DefaultApiService) DeleteRepositoryHook(projectKey, repositorySlug string, hookKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"hookKey"+"}", fmt.Sprintf("%v", hookKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Delete a task.  &lt;p&gt;  Note that only the task&#39;s creator, the context&#39;s author or an admin of the context&#39;s repository can delete a  task. (For a pull request task, those are the task&#39;s creator, the pull request&#39;s author or an admin on the  repository containing the pull request). Additionally a task cannot be deleted if it has already been resolved.

@param taskId the id identifying the task to delete
@return */
func (a *DefaultApiService) DeleteTask(taskId int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/tasks/{taskId}"
	localVarPath = strings.Replace(localVarPath, "{"+"taskId"+"}", fmt.Sprintf("%v", taskId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Deletes the specified user, removing them from the system. This also removes any permissions that may have been  granted to the user.  &lt;p&gt;  A user may not delete themselves, and a user with &lt;strong&gt;ADMIN&lt;/strong&gt; permissions may not delete a user with  &lt;strong&gt;SYS_ADMIN&lt;/strong&gt;permissions.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) the username identifying the user to delete
 @return */
func (a *DefaultApiService) DeleteUser(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/users"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Delete a webhook for the repository specified via the URL.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

@param webhookId the existing webhook id
@return */
func (a *DefaultApiService) DeleteWebhook(projectKey, repositorySlug string, webhookId int32) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"webhookId"+"}", fmt.Sprintf("%v", webhookId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
Disable a repository hook for this repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

@param hookKey
@return */
func (a *DefaultApiService) DisableHook(projectKey, repositorySlug string, hookKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/enabled"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"hookKey"+"}", fmt.Sprintf("%v", hookKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Disable a repository hook for this project.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project to call this  resource.

@param hookKey
@return */
func (a *DefaultApiService) DisableHook_3(projectKey, hookKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/enabled"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"hookKey"+"}", fmt.Sprintf("%v", hookKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the content of &lt;code&gt;path&lt;/code&gt;, on the given &lt;code&gt;repository&lt;/code&gt; and &lt;code&gt;branch&lt;/code&gt;.  &lt;p&gt;  This resource accepts PUT multipart form data, containing the file in a form-field named &lt;code&gt;content&lt;/code&gt;.  &lt;p&gt;  An example &lt;a href&#x3D;\&quot;http://curl.haxx.se/\&quot;&gt;curl&lt;/a&gt; request to update &#39;README.md&#39; would be:  &lt;pre&gt;  curl -X PUT -u username:password -F content&#x3D;@README.md  -F &#39;message&#x3D;Updated using file-edit REST API&#39;  -F branch&#x3D;master -F  sourceCommitId&#x3D;5636641a50b   http://example.com/rest/api/latest/projects/PROJECT_1/repos/repo_1/browse/README.md  &lt;/pre&gt;  &lt;p&gt;  &lt;ui&gt;  &lt;li&gt;branch:  the branch on which the &lt;code&gt;path&lt;/code&gt; should be modified or created&lt;/li&gt;  &lt;li&gt;content: the full content of the file at &lt;code&gt;path&lt;/code&gt; &lt;/li&gt;  &lt;li&gt;message: the message associated with this change, to be used as the commit message.  Or null if the default message should be used.&lt;/li&gt;  &lt;li&gt;sourceCommitId: the commit ID of the file before it was edited, used to identify if  content has changed. Or null if this is a new file&lt;/li&gt;  &lt;/ui&gt;  &lt;p&gt;  The file can be updated or created on a new branch. In this case, the &lt;code&gt;sourceBranch&lt;/code&gt; parameter should  be provided to identify the starting point for the new branch and the &lt;code&gt;branch&lt;/code&gt; parameter identifies  the branch to create the new commit on.

@param path the file path to retrieve content from
@return */
func (a *DefaultApiService) EditFile(projectKey, repositorySlug, path string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/browse/{path}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", fmt.Sprintf("%v", path), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Enable a repository hook for this repository and optionally apply new configuration.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.  &lt;p&gt;  A JSON document may be provided to use as the settings for the hook. These structure and validity of  the document is decided by the plugin providing the hook.

 @param hookKey
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "contentLength" (int32)
 @return */
func (a *DefaultApiService) EnableHook(projectKey, repositorySlug, hookKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/enabled"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"hookKey"+"}", fmt.Sprintf("%v", hookKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["contentLength"], "int32", "contentLength"); err != nil {
		return nil, err
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if localVarTempParam, localVarOk := localVarOptionals["contentLength"].(int32); localVarOk {
		localVarHeaderParams["Content-Length"] = parameterToString(localVarTempParam, "")
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Enable a repository hook for this project and optionally apply new configuration.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project to call this  resource.  &lt;p&gt;  A JSON document may be provided to use as the settings for the hook. These structure and validity of  the document is decided by the plugin providing the hook.

 @param hookKey
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "contentLength" (int32)
 @return */
func (a *DefaultApiService) EnableHook_4(projectKey, repositorySlug, hookKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	return a.EnableHook_4_WithOptions(projectKey, hookKey, localVarOptionals, nil)
}

/* DefaultApiService
For certain hooks (like "com.atlassian.bitbucket.server.bitbucket-bundled-hooks:requiredApproversMergeHook"), a request body with "requiredCount" and an integer value is necessary.

@param localVarPostBody (nil or map[string]interface{})
@return */
func (a *DefaultApiService) EnableHook_4_WithOptions(projectKey, hookKey string, localVarOptionals map[string]interface{}, localVarPostBody interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/enabled"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"hookKey"+"}", fmt.Sprintf("%v", hookKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["contentLength"], "int32", "contentLength"); err != nil {
		return nil, err
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if localVarTempParam, localVarOk := localVarOptionals["contentLength"].(int32); localVarOk {
		localVarHeaderParams["Content-Length"] = parameterToString(localVarTempParam, "")
	}

	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieves a list of groups the specified user is a member of.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;LICENSED_USER&lt;/strong&gt; permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "context" (string) the user which should be used to locate groups
	 @param "filter" (string) if specified only groups with names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) FindGroupsForUser(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/users/more-members"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["context"], "string", "context"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["context"].(string); localVarOk {
		localVarQueryParams.Add("context", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieves a list of groups the specified user is &lt;em&gt;not&lt;/em&gt; a member of.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;LICENSED_USER&lt;/strong&gt; permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "context" (string) the user which should be used to locate groups
	 @param "filter" (string) if specified only groups with names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) FindOtherGroupsForUser(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/users/more-non-members"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["context"], "string", "context"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["context"].(string); localVarOk {
		localVarQueryParams.Add("context", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieves a list of users that are members of a specified group.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;LICENSED_USER&lt;/strong&gt; permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "context" (string) the group which should be used to locate members
	 @param "filter" (string) if specified only users with usernames, display names or email addresses containing the                   supplied string will be returned
 @return */
func (a *DefaultApiService) FindUsersInGroup(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/groups/more-members"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["context"], "string", "context"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["context"].(string); localVarOk {
		localVarQueryParams.Add("context", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieves a list of users that are &lt;em&gt;not&lt;/em&gt; members of a specified group.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;LICENSED_USER&lt;/strong&gt; permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "context" (string) the group which should be used to locate non-members
	 @param "filter" (string) if specified only users with usernames, display names or email addresses containing the                   supplied string will be returned
 @return */
func (a *DefaultApiService) FindUsersNotInGroup(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/groups/more-non-members"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["context"], "string", "context"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["context"].(string); localVarOk {
		localVarQueryParams.Add("context", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Find webhooks in this repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "event" (string) list of {@link com.atlassian.webhooks.WebhookEvent} ids to filter for
	 @param "statistics" (bool) {@code true} if statistics should be provided for all found webhooks
 @return */
func (a *DefaultApiService) FindWebhooks(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["event"], "string", "event"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["statistics"], "bool", "statistics"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["event"].(string); localVarOk {
		localVarQueryParams.Add("event", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["statistics"].(bool); localVarOk {
		localVarQueryParams.Add("statistics", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Create a new repository forked from an existing repository.  &lt;p&gt;  The JSON body for this {@code POST} is not required to contain &lt;i&gt;any&lt;/i&gt; properties. Even the name may be  omitted. The following properties will be used, if provided:  &lt;ul&gt;      &lt;li&gt;{@code \&quot;name\&quot;:\&quot;Fork name\&quot;} - Specifies the forked repository&#39;s name      &lt;ul&gt;          &lt;li&gt;Defaults to the name of the origin repository if not specified&lt;/li&gt;      &lt;/ul&gt;      &lt;/li&gt;      &lt;li&gt;{@code \&quot;project\&quot;:{\&quot;key\&quot;:\&quot;TARGET_KEY\&quot;}} - Specifies the forked repository&#39;s target project by key      &lt;ul&gt;          &lt;li&gt;Defaults to the current user&#39;s personal project if not specified&lt;/li&gt;      &lt;/ul&gt;      &lt;/li&gt;  &lt;/ul&gt;  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository and  &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; on the target project to call this resource. Note that users &lt;i&gt;always&lt;/i&gt;  have &lt;b&gt;PROJECT_ADMIN&lt;/b&gt; permission on their personal projects.

@param projectKey the parent project key
@param repositorySlug the repository slug
@return */
func (a *DefaultApiService) ForkRepository(projectKey, repositorySlug string,
	localVarPostBody interface{},
	localVarHTTPContentTypes []string,
) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieves details about the current license, as well as the current status of the system with regards to the  installed license. The status includes the current number of users applied toward the license limit, as well  as any status messages about the license (warnings about expiry or user counts exceeding license limits).  &lt;p&gt;  The authenticated user must have &lt;b&gt;ADMIN&lt;/b&gt; permission. Unauthenticated users, and non-administrators, are  not permitted to access license details.

@return */
func (a *DefaultApiService) GetLicense() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/license"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of activity associated with a pull request.  &lt;p&gt;  Activity items include comments, approvals, rescopes (i.e. adding and removing of commits), merges and more.  &lt;p&gt;  Different types of activity items may be introduced in newer versions of Stash or by user installed plugins, so  clients should be flexible enough to handle unexpected entity shapes in the returned page.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

 @param pullRequestId the id of the pull request within the repository
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "fromId" (int64) (optional) the id of the activity item to use as the first item in the returned page
	 @param "fromType" (string) (required if &lt;strong&gt;fromId&lt;/strong&gt; is present) the type of the activity item specified by                  &lt;strong&gt;fromId&lt;/strong&gt; (either &lt;strong&gt;COMMENT&lt;/strong&gt; or &lt;strong&gt;ACTIVITY&lt;/strong&gt;)
 @return */
func (a *DefaultApiService) GetActivities(projectKey, repositorySlug string, pullRequestID int64, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/activities"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["fromId"], "int64", "fromId"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["fromType"], "string", "fromType"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["fromId"].(int64); localVarOk {
		localVarQueryParams.Add("fromId", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["fromType"].(string); localVarOk {
		localVarQueryParams.Add("fromType", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewRawAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve version information and other application properties.  &lt;p&gt;  No authentication is required to call this resource.

@return */
func (a *DefaultApiService) GetApplicationProperties() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/application-properties"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Streams an archive of the repository&#39;s contents at the requested commit. If no &lt;code&gt;at&#x3D;&lt;/code&gt; commit is  requested, an archive of the default branch is streamed.  &lt;p&gt;  The &lt;code&gt;filename&#x3D;&lt;/code&gt; query parameter may be used to specify the exact filename to include in the  &lt;code&gt;\&quot;Content-Disposition\&quot;&lt;/code&gt; header. If an explicit filename is not provided, one will be automatically  generated based on what is being archived. Its format depends on the &lt;code&gt;at&#x3D;&lt;/code&gt; value:  &lt;ul&gt;      &lt;li&gt;No &lt;code&gt;at&#x3D;&lt;/code&gt; commit:      &lt;code&gt;&amp;lt;slug&amp;gt;-&amp;lt;default-branch-name&amp;gt;@&amp;lt;commit&amp;gt;.&amp;lt;format&amp;gt;&lt;/code&gt;;      e.g. example-master@43c2f8a0fe8.zip&lt;/li&gt;      &lt;li&gt;&lt;code&gt;at&#x3D;sha&lt;/code&gt;: &lt;code&gt;&amp;lt;slug&amp;gt;-&amp;lt;at&amp;gt;.&amp;lt;format&amp;gt;&lt;/code&gt;; e.g.      example-09bcbb00100cfbb5310fb6834a1d5ce6cac253e9.tar.gz&lt;/li&gt;      &lt;li&gt;&lt;code&gt;at&#x3D;branchOrTag&lt;/code&gt;: &lt;code&gt;&amp;lt;slug&amp;gt;-&amp;lt;branchOrTag&amp;gt;@&amp;lt;commit&amp;gt;.&amp;lt;format&amp;gt;&lt;/code&gt;;      e.g. example-feature@bbb225f16e1.tar      &lt;ul&gt;          &lt;li&gt;If the branch or tag is qualified (e.g. &lt;code&gt;refs/heads/master&lt;/code&gt;, the short name          (&lt;code&gt;master&lt;/code&gt;) will be included in the filename&lt;/li&gt;          &lt;li&gt;If the branch or tag&#39;s &lt;i&gt;short name&lt;/i&gt; includes slashes (e.g. &lt;code&gt;release/4.6&lt;/code&gt;),          they will be converted to hyphens in the filename (&lt;code&gt;release-4.5&lt;/code&gt;)&lt;/li&gt;      &lt;/ul&gt;      &lt;/li&gt;  &lt;/ul&gt;  &lt;p&gt;  Archives may be requested in the following formats by adding the &lt;code&gt;format&#x3D;&lt;/code&gt; query parameter:  &lt;ul&gt;      &lt;li&gt;&lt;code&gt;zip&lt;/code&gt;: A zip file using standard compression (Default)&lt;/li&gt;      &lt;li&gt;&lt;code&gt;tar&lt;/code&gt;: An uncompressed tarball&lt;/li&gt;      &lt;li&gt;&lt;code&gt;tar.gz&lt;/code&gt; or &lt;code&gt;tgz&lt;/code&gt;: A GZip-compressed tarball&lt;/li&gt;  &lt;/ul&gt;  The contents of the archive may be filtered by using the &lt;code&gt;path&#x3D;&lt;/code&gt; query parameter to specify paths to  include. &lt;code&gt;path&#x3D;&lt;/code&gt; may be specified multiple times to include multiple paths.  &lt;p&gt;  The &lt;code&gt;prefix&#x3D;&lt;/code&gt; query parameter may be used to define a directory (or multiple directories) where  the archive&#39;s contents should be placed. If the prefix does not end with &lt;code&gt;/&lt;/code&gt;, one will be added  automatically. The prefix is &lt;i&gt;always&lt;/i&gt; treated as a directory; it is not possible to use it to prepend  characters to the entries in the archive.  &lt;p&gt;  Archives of public repositories may be streamed by any authenticated or anonymous user. Streaming archives for  non-public repositories requires an &lt;i&gt;authenticated user&lt;/i&gt; with at least &lt;b&gt;REPO_READ&lt;/b&gt; permission.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "at" (string) the commit to stream an archive of; if not supplied, an archive of the default branch is streamed
	 @param "filename" (string) a filename to include the \&quot;Content-Disposition\&quot; header
	 @param "format" (string) the format to stream the archive in; must be one of: zip, tar, tar.gz or tgz
	 @param "path" (string) paths to include in the streamed archive; may be repeated to include multiple paths
	 @param "prefix" (string) a prefix to apply to all entries in the streamed archive; if the supplied prefix does not end                  with a trailing &lt;code&gt;/&lt;/code&gt;, one will be added automatically
 @return */
func (a *DefaultApiService) GetArchive(project, repository string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/archive"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", project), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repository), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["at"], "string", "at"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["filename"], "string", "filename"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["format"], "string", "format"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["path"], "string", "path"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["prefix"], "string", "prefix"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["at"].(string); localVarOk {
		localVarQueryParams.Add("at", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filename"].(string); localVarOk {
		localVarQueryParams.Add("filename", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["format"].(string); localVarOk {
		localVarQueryParams.Add("format", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["path"].(string); localVarOk {
		localVarQueryParams.Add("path", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["prefix"].(string); localVarOk {
		localVarQueryParams.Add("prefix", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewRawAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve the avatar for the project matching the supplied &lt;strong&gt;moduleKey&lt;/strong&gt;.

 @param hookKey the complete module key of the hook module
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "version" (string) optional version used for HTTP caching only - any non-blank version will result in a large max-age Cache-Control header.                 Note that this does not affect the Last-Modified header.
 @return */
func (a *DefaultApiService) GetAvatar(hookKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/hooks/{hookKey}/avatar"
	localVarPath = strings.Replace(localVarPath, "{"+"hookKey"+"}", fmt.Sprintf("%v", hookKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["version"], "string", "version"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["version"].(string); localVarOk {
		localVarQueryParams.Add("version", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve the branches matching the supplied &lt;strong&gt;filterText&lt;/strong&gt; param.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "base" (string) base branch or tag to compare each branch to (for the metadata providers that uses that information)
	 @param "details" (bool) whether to retrieve plugin-provided metadata about each branch
	 @param "filterText" (string) the text to match on
	 @param "orderBy" (string) ordering of refs either ALPHABETICAL (by name) or MODIFICATION (last updated)
 @return */
func (a *DefaultApiService) GetBranches(project, repository string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", project), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repository), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["base"], "string", "base"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["details"], "bool", "details"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["filterText"], "string", "filterText"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["orderBy"], "string", "orderBy"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["base"].(string); localVarOk {
		localVarQueryParams.Add("base", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["details"].(bool); localVarOk {
		localVarQueryParams.Add("details", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filterText"].(string); localVarOk {
		localVarQueryParams.Add("filterText", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["orderBy"].(string); localVarOk {
		localVarQueryParams.Add("orderBy", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of changes made in a specified commit.  &lt;p&gt;  &lt;strong&gt;Note:&lt;/strong&gt; The implementation will apply a hard cap ({@code page.max.changes}) and it is not  possible to request subsequent content when that cap is exceeded.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "since" (string) the commit to which &lt;code&gt;until&lt;/code&gt; should be compared to produce a page of changes.                      If not specified the commit&#39;s first parent is assumed (if one exists)
	 @param "until" (string) the commit to retrieve changes for
 @return */
func (a *DefaultApiService) GetChanges(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/changes"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["since"], "string", "since"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["until"], "string", "until"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["since"].(string); localVarOk {
		localVarQueryParams.Add("since", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["until"].(string); localVarOk {
		localVarQueryParams.Add("until", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of changes made in a specified commit.  &lt;p&gt;  &lt;strong&gt;Note:&lt;/strong&gt; The implementation will apply a hard cap ({@code page.max.changes}) and it is not  possible to request subsequent content when that cap is exceeded.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param commitId the commit to retrieve changes for
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "since" (string) the commit to which &lt;code&gt;until&lt;/code&gt; should be compared to produce a page of changes.                       If not specified the commit&#39;s first parent is assumed (if one exists)
	 @param "withComments" (bool) {@code true} to apply comment counts in the changes (the default); otherwise, {@code false}                       to stream changes without comment counts
 @return */
func (a *DefaultApiService) GetChanges_5(projectKey, repositorySlug, commitId string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/changes"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["since"], "string", "since"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["withComments"], "bool", "withComments"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["since"].(string); localVarOk {
		localVarQueryParams.Add("since", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["withComments"].(bool); localVarOk {
		localVarQueryParams.Add("withComments", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieves a commit discussion comment.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that the commit  is in to call this resource.

@param commitId the commit to which the comments must be anchored
@param commentId the ID of the comment to retrieve
@param commitId2 the &lt;i&gt;full {@link Commit#getId() ID}&lt;/i&gt; of the commit within the repository
@return */
func (a *DefaultApiService) GetComment(projectKey, repositorySlug, commitId string, commentId int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commentId"+"}", fmt.Sprintf("%v", commentId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieves a pull request comment.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

@param commentId the id of the comment to retrieve
@return */
func (a *DefaultApiService) GetComment_6(projectKey, repositorySlug string, pullRequestId, commentId int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestId), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commentId"+"}", fmt.Sprintf("%v", commentId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieves the commit discussion comments that match the specified search criteria.  &lt;p&gt;  It is possible to retrieve commit discussion comments that are anchored to a range of commits by providing the  {@code sinceId} that the comments anchored from.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that the commit  is in to call this resource.

 @param commitId the commit to which the comments must be anchored
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "path" (string) the path to the file on which comments were made
	 @param "since" (string) For a merge commit, a parent can be provided to specify which diff the comments are on. For                       a commit range, a {@code sinceId} can be provided to specify where the comments are anchored                       from.
 @return */
func (a *DefaultApiService) GetComments(projectKey, repositorySlug, commitId string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["path"], "string", "path"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["since"], "string", "since"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["path"].(string); localVarOk {
		localVarQueryParams.Add("path", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["since"].(string); localVarOk {
		localVarQueryParams.Add("since", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Gets comments for the specified PullRequest.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "anchorState" (string) {@code ACTIVE} to stream the active comments;                     {@code ORPHANED} to stream the orphaned comments;                     {@code ALL} to stream both the active and the orphaned comments;
	 @param "diffType" (string) {@code EFFECTIVE} to stream the comments related to the effective diff of the pull request;                     {@code RANGE} to stream comments related to a commit range between two arbitrary commits                                   (requires {@code fromHash} and {@code toHash});                     {@code COMMIT} to stream comments related to a commit between two arbitrary commits (requires                         {@code fromHash} and {@code toHash})
	 @param "fromHash" (string) the from commit hash to stream comments for a {@code RANGE} or {@code COMMIT} arbitrary change scope
	 @param "path" (string) the path to stream comments for a given path
	 @param "toHash" (string) the to commit hash to stream comments for a {@code RANGE} or {@code COMMIT} arbitrary change scope
 @return */
func (a *DefaultApiService) GetComments_7(projectKey, repositorySlug string, pullRequestId int64, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["anchorState"], "string", "anchorState"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["diffType"], "string", "diffType"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["fromHash"], "string", "fromHash"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["path"], "string", "path"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["toHash"], "string", "toHash"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["anchorState"].(string); localVarOk {
		localVarQueryParams.Add("anchorState", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["diffType"].(string); localVarOk {
		localVarQueryParams.Add("diffType", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["fromHash"].(string); localVarOk {
		localVarQueryParams.Add("fromHash", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["path"].(string); localVarOk {
		localVarQueryParams.Add("path", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["toHash"].(string); localVarOk {
		localVarQueryParams.Add("toHash", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a single commit &lt;i&gt;identified by its ID&lt;/i&gt;&gt;. In general, that ID is a SHA1. &lt;u&gt;From 2.11, ref names  like \&quot;refs/heads/master\&quot; are no longer accepted by this resource.&lt;/u&gt;  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param commitId the commit ID to retrieve
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "path" (string) an optional path to filter the commit by. If supplied the details returned &lt;i&gt;may not&lt;/i&gt;              be for the specified commit. Instead, starting from the specified commit, they will be the              details for the first commit affecting the specified path.
 @return */
func (a *DefaultApiService) GetCommit(projectKey, repositorySlug, commitId string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["path"], "string", "path"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["path"].(string); localVarOk {
		localVarQueryParams.Add("path", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of commits from a given starting commit or \&quot;between\&quot; two commits. If no explicit commit is  specified, the tip of the repository&#39;s default branch is assumed. commits may be identified by branch or tag  name or by ID. A path may be supplied to restrict the returned commits to only those which affect that path.  &lt;p&gt;  The authenticated user must have &lt;b&gt;REPO_READ&lt;/b&gt; permission for the specified repository to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "followRenames" (bool) if &lt;code&gt;true&lt;/code&gt;, the commit history of the specified file will be followed past renames.                       Only valid for a path to a single file.
	 @param "ignoreMissing" (bool) &lt;code&gt;true&lt;/code&gt; to ignore missing commits, &lt;code&gt;false&lt;/code&gt; otherwise
	 @param "merges" (string) if present, controls how merge commits should be filtered. Can be either &lt;code&gt;exclude&lt;/code&gt;,                to exclude merge commits, &lt;code&gt;include&lt;/code&gt;, to include both merge commits and non-merge                commits or &lt;code&gt;only&lt;/code&gt;, to only return merge commits.
	 @param "path" (string) an optional path to filter commits by
	 @param "since" (string) the commit ID or ref (exclusively) to retrieve commits after
	 @param "until" (string) the commit ID (SHA1) or ref (inclusively) to retrieve commits before
	 @param "withCounts" (bool) optionally include the total number of commits and total number of unique authors
 @return */
func (a *DefaultApiService) GetCommits(project, repository string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := fmt.Sprintf("%s/api/1.0/projects/%s/repos/%s/commits", a.client.cfg.BasePath, project, repository)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["followRenames"], "bool", "followRenames"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["ignoreMissing"], "bool", "ignoreMissing"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["merges"], "string", "merges"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["path"], "string", "path"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["since"], "string", "since"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["until"], "string", "until"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["withCounts"], "bool", "withCounts"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["followRenames"].(bool); localVarOk {
		localVarQueryParams.Add("followRenames", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["ignoreMissing"].(bool); localVarOk {
		localVarQueryParams.Add("ignoreMissing", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["merges"].(string); localVarOk {
		localVarQueryParams.Add("merges", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["path"].(string); localVarOk {
		localVarQueryParams.Add("path", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["since"].(string); localVarOk {
		localVarQueryParams.Add("since", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["until"].(string); localVarOk {
		localVarQueryParams.Add("until", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["withCounts"].(bool); localVarOk {
		localVarQueryParams.Add("withCounts", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve commits for the specified pull request.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

 @param pullRequestId
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "withCounts" (bool) if set to true, the service will add \&quot;authorCount\&quot; and \&quot;totalCount\&quot; at the end of the page.                      \&quot;authorCount\&quot; is the number of different authors and \&quot;totalCount\&quot; is the total number of commits.
 @return */
func (a *DefaultApiService) GetCommits_8(projectKey, repositorySlug string, pullRequestID int64, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/commits"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["withCounts"], "bool", "withCounts"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["withCounts"].(bool); localVarOk {
		localVarQueryParams.Add("withCounts", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of content for a file path at a specified revision.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "at" (string) the commit ID or ref to retrieve the content for.
	 @param "type_" (bool) if true only the type will be returned for the file path instead of the contents.
	 @param "blame" (string) if present the blame will be returned for the file as well.
	 @param "noContent" (string) if present and used with blame only the blame is retrieved instead of the contents.
 @return */
func (a *DefaultApiService) GetContent(projectKey string, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	return a.getContentWithPath(projectKey, repositorySlug, "", localVarOptionals)
}

func (a *DefaultApiService) GetContent_0(projectKey string, repositorySlug string, path string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	return a.getContentWithPath(projectKey, repositorySlug, path, localVarOptionals)
}

func (a *DefaultApiService) getContentWithPath(projectKey string, repositorySlug string, path string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/browse"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	if path != "" {
		localVarPath = localVarPath + "/" + path
	}

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["at"], "string", "at"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["type_"], "bool", "type_"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["blame"], "string", "blame"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["noContent"], "string", "noContent"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["at"].(string); localVarOk {
		localVarQueryParams.Add("at", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["type_"].(bool); localVarOk {
		localVarQueryParams.Add("type", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["blame"].(string); localVarOk {
		localVarQueryParams.Add("blame", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["noContent"].(string); localVarOk {
		localVarQueryParams.Add("noContent", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of content for a file path at a specified revision.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param path the file path to retrieve content from
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "at" (string) the commit ID or ref to retrieve the content for.
	 @param "type_" (bool) if true only the type will be returned for the file path instead of the contents.
	 @param "blame" (string) if present the blame will be returned for the file as well.
	 @param "noContent" (string) if present and used with blame only the blame is retrieved instead of the contents.
 @return */
func (a *DefaultApiService) GetContent_9(projectKey, repositorySlug, path string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/browse/{path}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", fmt.Sprintf("%v", path), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["at"], "string", "at"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["type_"], "bool", "type_"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["blame"], "string", "blame"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["noContent"], "string", "noContent"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["at"].(string); localVarOk {
		localVarQueryParams.Add("at", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["type_"].(bool); localVarOk {
		localVarQueryParams.Add("type", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["blame"].(string); localVarOk {
		localVarQueryParams.Add("blame", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["noContent"].(string); localVarOk {
		localVarQueryParams.Add("noContent", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve the raw content for a file path at a specified revision.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "at" (string) the commit ID or ref to retrieve the content for.
	 @param "markup" (string) if present or &lt;code&gt;\&quot;true\&quot;&lt;/code&gt;, triggers the raw content to be markup-rendered and returned                    as HTML; otherwise, if not specified, or any value other than &lt;code&gt;\&quot;true\&quot;&lt;/code&gt;, the content                    is streamed without markup
	 @param "hardwrap" (bool) (Optional) Whether the markup implementation should convert newlines to breaks.                    If not specified, {@link MarkupService} will use the value of the                    &lt;code&gt;markup.render.hardwrap&lt;/code&gt; property, which is &lt;code&gt;true&lt;/code&gt; by default
	 @param "htmlEscape" (bool) (Optional) true if HTML should be escaped in the input markup, false otherwise.                    If not specified, {@link MarkupService} will use the value of the                    &lt;code&gt;markup.render.html.escape&lt;/code&gt; property, which is &lt;code&gt;true&lt;/code&gt; by default
 @return */
func (a *DefaultApiService) GetContent_10(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/raw"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["at"], "string", "at"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["markup"], "string", "markup"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["hardwrap"], "bool", "hardwrap"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["htmlEscape"], "bool", "htmlEscape"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["at"].(string); localVarOk {
		localVarQueryParams.Add("at", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["markup"].(string); localVarOk {
		localVarQueryParams.Add("markup", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["hardwrap"].(bool); localVarOk {
		localVarQueryParams.Add("hardwrap", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["htmlEscape"].(bool); localVarOk {
		localVarQueryParams.Add("htmlEscape", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve the raw content for a file path at a specified revision.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param path the file path to retrieve content from
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "at" (string) the commit ID or ref to retrieve the content for.
	 @param "markup" (string) if present or &lt;code&gt;\&quot;true\&quot;&lt;/code&gt;, triggers the raw content to be markup-rendered and returned                    as HTML; otherwise, if not specified, or any value other than &lt;code&gt;\&quot;true\&quot;&lt;/code&gt;, the content                    is streamed without markup
	 @param "hardwrap" (bool) (Optional) Whether the markup implementation should convert newlines to breaks.                    If not specified, {@link MarkupService} will use the value of the                    &lt;code&gt;markup.render.hardwrap&lt;/code&gt; property, which is &lt;code&gt;true&lt;/code&gt; by default
	 @param "htmlEscape" (bool) (Optional) true if HTML should be escaped in the input markup, false otherwise.                    If not specified, {@link MarkupService} will use the value of the                    &lt;code&gt;markup.render.html.escape&lt;/code&gt; property, which is &lt;code&gt;true&lt;/code&gt; by default
 @return */
func (a *DefaultApiService) GetContent_11(projectKey, repositorySlug, path string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/raw/{path}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", fmt.Sprintf("%v", path), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["at"], "string", "at"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["markup"], "string", "markup"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["hardwrap"], "bool", "hardwrap"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["htmlEscape"], "bool", "htmlEscape"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["at"].(string); localVarOk {
		localVarQueryParams.Add("at", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["markup"].(string); localVarOk {
		localVarQueryParams.Add("markup", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["hardwrap"].(bool); localVarOk {
		localVarQueryParams.Add("hardwrap", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["htmlEscape"].(bool); localVarOk {
		localVarQueryParams.Add("htmlEscape", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewRawAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Get the default branch of the repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

@return */
func (a *DefaultApiService) GetDefaultBranch(projectKey, repositorySlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches/default"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve repositories which have been forked from this one. Unlike {@link #getRelatedRepositories(Repository,  PageRequest) related repositories}, this only looks at a given repository&#39;s direct forks. If those forks have  themselves been the origin of more forks, such \&quot;grandchildren\&quot; repositories will not be retrieved.  &lt;p&gt;  Only repositories to which the authenticated user has &lt;b&gt;REPO_READ&lt;/b&gt; permission will be included, even  if other repositories have been forked from this one.

@param projectKey the parent project key
@return */
func (a *DefaultApiService) GetForkedRepositories(projectKey, repositorySlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/forks"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of groups.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;LICENSED_USER&lt;/strong&gt; permission or higher to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only group names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetGroups(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/groups"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of groups that have been granted at least one global permission.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only group names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetGroupsWithAnyPermission(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/permissions/groups"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of groups that have been granted at least one permission for the specified project.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project or a higher  global permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only group names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetGroupsWithAnyPermission_12(projectKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/permissions/groups"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of groups that have been granted at least one permission for the specified repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository or a higher  project or global permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only group names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetGroupsWithAnyPermission_13(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of groups that have no granted global permissions.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only group names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetGroupsWithoutAnyPermission(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/permissions/groups/none"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of groups that have no granted permissions for the specified project.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project or a higher  global permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only group names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetGroupsWithoutAnyPermission_14(projectKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/permissions/groups/none"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of groups that have no granted permissions for the specified repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository or a higher  project or global permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only group names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetGroupsWithoutAnyPermission_15(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups/none"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of group names.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission or higher to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only group names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetGroups_16(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/groups"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Gets information about the nodes that currently make up the stash cluster.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;SYS_ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) GetInformation() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/cluster"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Get the latest invocations for a specific webhook.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param webhookId id of the webhook
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "event" (string) the string id of a specific event to retrieve the last invocation for.
	 @param "outcome" (string) the outcome to filter for. Can be SUCCESS, FAILURE, ERROR. None specified means that the all                   will be considered
 @return */
func (a *DefaultApiService) GetLatestInvocation(projectKey, repositorySlug string, webhookId int32, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}/latest"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"webhookId"+"}", fmt.Sprintf("%v", webhookId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["event"], "string", "event"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["outcome"], "string", "outcome"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["event"].(string); localVarOk {
		localVarQueryParams.Add("event", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["outcome"].(string); localVarOk {
		localVarQueryParams.Add("outcome", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the current log level for a given logger.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher to call this resource.

@param loggerName the name of the logger.
@return */
func (a *DefaultApiService) GetLevel(loggerName string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/logs/logger/{loggerName}"
	localVarPath = strings.Replace(localVarPath, "{"+"loggerName"+"}", fmt.Sprintf("%v", loggerName), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieves the current mail configuration.   The authenticated user must have the &lt;strong&gt;SYS_ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) GetMailConfig() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/mail-server"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the merge strategies available for this instance.  &lt;p&gt;  The user must be authenticated to call this resource.

@param scmId the id of the scm to get strategies for
@return */
func (a *DefaultApiService) GetMergeConfig(scmId string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/pull-requests/{scmId}"
	localVarPath = strings.Replace(localVarPath, "{"+"scmId"+"}", fmt.Sprintf("%v", scmId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of pull requests to or from the specified repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call  this resource.   Optionally clients can specify PR participant filters. Each filter has a mandatory {@code username.N}  parameter, and the optional {@code role.N} and {@code approved.N} parameters.  &lt;ul&gt;      &lt;li&gt;          {@code username.N} - the \&quot;root\&quot; of a single participant filter, where \&quot;N\&quot; is a natural number          starting from 1. This allows clients to specify multiple participant filters, by providing consecutive          filters as {@code username.1}, {@code username.2} etc. Note that the filters numbering has to start          with 1 and be continuous for all filters to be processed. The total allowed number of participant          filters is 10 and all filters exceeding that limit will be dropped.      &lt;/li&gt;      &lt;li&gt;          {@code role.N}(optional) the role associated with {@code username.N}.          This must be one of {@code AUTHOR}, {@code REVIEWER}, or{@code PARTICIPANT}      &lt;/li&gt;      &lt;li&gt;          {@code approved.N}(optional) the approved status associated with {@code username.N}.          That is whether {@code username.N} has approved the PR. Either {@code true}, or {@code false}      &lt;/li&gt;  &lt;/ul&gt;

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "direction" (string) (optional, defaults to &lt;strong&gt;INCOMING&lt;/strong&gt;) the direction relative to the specified                   repository. Either &lt;strong&gt;INCOMING&lt;/strong&gt; or &lt;strong&gt;OUTGOING&lt;/strong&gt;.
	 @param "at" (string) (optional) a &lt;i&gt;fully-qualified&lt;/i&gt; branch ID to find pull requests to or from,            such as {@code refs/heads/master}
	 @param "state" (string) (optional, defaults to &lt;strong&gt;OPEN&lt;/strong&gt;). Supply &lt;strong&gt;ALL&lt;/strong&gt; to return pull request                in any state. If a state is supplied only pull requests in the specified state will be returned.                Either &lt;strong&gt;OPEN&lt;/strong&gt;, &lt;strong&gt;DECLINED&lt;/strong&gt; or &lt;strong&gt;MERGED&lt;/strong&gt;.
	 @param "order" (string) (optional, defaults to &lt;strong&gt;NEWEST&lt;/strong&gt;) the order to return pull requests in, either               &lt;strong&gt;OLDEST&lt;/strong&gt; (as in: \&quot;oldest first\&quot;) or &lt;strong&gt;NEWEST&lt;/strong&gt;.
	 @param "withAttributes" (bool) (optional) defaults to true, whether to return additional pull request attributes
	 @param "withProperties" (bool) (optional) defaults to true, whether to return additional pull request properties
 @return */
func (a *DefaultApiService) GetPullRequestsPage(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["direction"], "string", "direction"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["at"], "string", "at"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["state"], "string", "state"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["order"], "string", "order"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["withAttributes"], "bool", "withAttributes"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["withProperties"], "bool", "withProperties"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["direction"].(string); localVarOk {
		localVarQueryParams.Add("direction", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["at"].(string); localVarOk {
		localVarQueryParams.Add("at", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["state"].(string); localVarOk {
		localVarQueryParams.Add("state", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["order"].(string); localVarOk {
		localVarQueryParams.Add("order", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["withAttributes"].(bool); localVarOk {
		localVarQueryParams.Add("withAttributes", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["withProperties"].(bool); localVarOk {
		localVarQueryParams.Add("withProperties", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the project matching the supplied &lt;strong&gt;projectKey&lt;/strong&gt;.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_VIEW&lt;/strong&gt; permission for the specified project to call this  resource.

@return */
func (a *DefaultApiService) GetProject(projectKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve the avatar for the project matching the supplied &lt;strong&gt;projectKey&lt;/strong&gt;.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_VIEW&lt;/strong&gt; permission for the specified project to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "s" (int32) The desired size of the image. The server will return an image as close as possible to the specified              size.
 @return */
func (a *DefaultApiService) GetProjectAvatar(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/avatar.png"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["s"], "int32", "s"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["s"].(int32); localVarOk {
		localVarQueryParams.Add("s", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of projects.  &lt;p&gt;  Only projects for which the authenticated user has the &lt;strong&gt;PROJECT_VIEW&lt;/strong&gt; permission will be returned.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string)
	 @param "permission" (string)
 @return */
func (a *DefaultApiService) GetProjects(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["permission"], "string", "permission"); err != nil {
		return nil, err
	}

	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}

	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["permission"].(string); localVarOk {
		localVarQueryParams.Add("permission", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService

@return */
func (a *DefaultApiService) GetPullRequestCount() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/inbox/pull-requests/count"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the pull request settings for the context repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the context repository to call this  resource.  &lt;p&gt;  This resource will call all RestFragments that are registered with the key  &lt;strong&gt;bitbucket.repository.settings.pullRequests&lt;/strong&gt;. If any fragment fails validations by returning a  non-empty Map of errors, then no fragments will execute.  &lt;p&gt;  The property keys for the settings that are bundled with the application are  &lt;ul&gt;      &lt;li&gt;mergeConfig - the merge strategy configuration for pull requests&lt;/li&gt;      &lt;li&gt;requiredApprovers - (Deprecated, please use com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook instead) the number of approvals required on a pull request for it to be mergeable, or 0 if the merge check is disabled&lt;/li&gt;      &lt;li&gt;com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook - the merge check configuration for required approvers&lt;/li&gt;      &lt;li&gt;requiredAllApprovers - whether or not all approvers must approve a pull request for it to be mergeable&lt;/li&gt;      &lt;li&gt;requiredAllTasksComplete - whether or not all tasks on a pull request need to be completed for it to be mergeable&lt;/li&gt;      &lt;li&gt;requiredSuccessfulBuilds - (Deprecated, please use com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck instead) the number of successful builds on a pull request for it to be mergeable, or 0 if the merge check is disabled&lt;/li&gt;      &lt;li&gt;com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck - the merge check configuration for required builds&lt;/li&gt;  &lt;/ul&gt;

@return */
func (a *DefaultApiService) GetPullRequestSettings(projectKey, repositorySlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/pull-requests"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the merge strategy configuration for this project and SCM.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_READ&lt;/strong&gt; permission for the context repository to call this  resource.

@param scmId the SCM to get strategies for
@return */
func (a *DefaultApiService) GetPullRequestSettings_17(projectKey, repositorySlug string, scmId string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/settings/pull-requests/{scmId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"scmId"+"}", fmt.Sprintf("%v", scmId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieves a page of suggestions for pull requests that the currently authenticated user may wish to  raise. Such suggestions are based on ref changes occurring and so contain the ref change that  prompted the suggestion plus the time the change event occurred. Changes will be returned in  descending order based on the time the change that prompted the suggestion occurred.  &lt;p&gt;  Note that although the response is a page object, the interface does not support paging, however  a limit can be applied to the size of the returned page.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "changesSince" (string) restrict pull request suggestions to be based on events that occurred since some time                      in the past. This is expressed in seconds since \&quot;now\&quot;. So to return suggestions                      based only on activity within the past 48 hours, pass a value of 172800.
	 @param "limit" (int32) restricts the result set to return at most this many suggestions.
 @return */
func (a *DefaultApiService) GetPullRequestSuggestions(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/dashboard/pull-request-suggestions"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["changesSince"], "string", "changesSince"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int32", "limit"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["changesSince"].(string); localVarOk {
		localVarQueryParams.Add("changesSince", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int32); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the tasks associated with a pull request.

@return */
func (a *DefaultApiService) GetPullRequestTasks(projectKey, repositorySlug string, pullRequestId int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/tasks"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of pull requests where the current authenticated user is involved as either a reviewer, author  or a participant. The request may be filtered by pull request state, role or participant status.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "state" (string) (optional, defaults to returning pull requests in any state). If a state is supplied only pull               requests in the specified state will be returned. Either &lt;strong&gt;OPEN&lt;/strong&gt;,               &lt;strong&gt;DECLINED&lt;/strong&gt; or &lt;strong&gt;MERGED&lt;/strong&gt;.               Omit this parameter to return pull request in any state.
	 @param "role" (string) (optional, defaults to returning pull requests for any role). If a role is supplied only pull               requests where the authenticated user is a participant in the given role will be returned.               Either &lt;strong&gt;REVIEWER&lt;/strong&gt;, &lt;strong&gt;AUTHOR&lt;/strong&gt; or &lt;strong&gt;PARTICIPANT&lt;/strong&gt;.
	 @param "participantStatus" (string) (optional, defaults to returning pull requests with any participant status). A comma                           separated list of participant status. That is, one or more of                           &lt;strong&gt;UNAPPROVED&lt;/strong&gt;, &lt;strong&gt;NEEDS_WORK&lt;/strong&gt;, or &lt;strong&gt;APPROVED&lt;/strong&gt;.
	 @param "order" (string) (optional, defaults to &lt;strong&gt;NEWEST&lt;/strong&gt;) the order to return pull requests in, either               &lt;strong&gt;OLDEST&lt;/strong&gt; (as in: \&quot;oldest first\&quot;), &lt;strong&gt;NEWEST&lt;/strong&gt;,               &lt;strong&gt;PARTICIPANT_STATUS&lt;/strong&gt;, or &lt;strong&gt;CLOSED_DATE&lt;/strong&gt;. Where               &lt;strong&gt;CLOSED_DATE&lt;/strong&gt; is specified and the result set includes pull requests that are not in               the closed state, these pull requests will appear first in the result set, followed by most recently               closed pull requests.
	 @param "closedSince" (string) (optional, defaults to returning pull requests regardless of closed since date). Permits                       returning only pull requests with a closed timestamp set more recently that                       (now - closedSince). Units are in seconds. So for example if closed since 86400 is set only                       pull requests closed in the previous 24 hours will be returned.
 @return */
func (a *DefaultApiService) GetPullRequests(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/dashboard/pull-requests"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["state"], "string", "state"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["role"], "string", "role"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["participantStatus"], "string", "participantStatus"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["order"], "string", "order"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["closedSince"], "string", "closedSince"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["state"].(string); localVarOk {
		localVarQueryParams.Add("state", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["role"].(string); localVarOk {
		localVarQueryParams.Add("role", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["participantStatus"].(string); localVarOk {
		localVarQueryParams.Add("participantStatus", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["order"].(string); localVarOk {
		localVarQueryParams.Add("order", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["closedSince"].(string); localVarOk {
		localVarQueryParams.Add("closedSince", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "start" (int32)
	 @param "limit" (int32)
	 @param "role" (string)
 @return */
func (a *DefaultApiService) GetPullRequests_18(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/inbox/pull-requests"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["start"], "int32", "start"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int32", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["role"], "string", "role"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["start"].(int32); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int32); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["role"].(string); localVarOk {
		localVarQueryParams.Add("role", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve repositories which are related to this one. Related repositories are from the same  {@link Repository#getHierarchyId() hierarchy} as this repository.  &lt;p&gt;  Only repositories to which the authenticated user has &lt;b&gt;REPO_READ&lt;/b&gt; permission will be included, even  if more repositories are part of this repository&#39;s hierarchy.

@param projectKey the parent project key
@return */
func (a *DefaultApiService) GetRelatedRepositories(projectKey, repositorySlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/related"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve repositories from the project corresponding to the supplied &lt;strong&gt;projectKey&lt;/strong&gt;.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified project to call this  resource.

@param projectKey the parent project key
@return */
func (a *DefaultApiService) GetRepositories(projectKey string) (*APIResponse, error) {
	return a.GetRepositoriesWithOptions(projectKey, make(map[string]interface{}))
}

func (a *DefaultApiService) GetRepositoriesWithOptions(projectKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of recently accessed repositories for the currently authenticated user.  &lt;p&gt;  Repositories are ordered from most recently to least recently accessed.  &lt;p&gt;  Only authenticated users may call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "permission" (string) (optional) if specified, it must be a valid repository permission level name and will limit                    the resulting repository list to ones that the requesting user has the specified permission                    level to. If not specified, the default &lt;code&gt;REPO_READ&lt;/code&gt; permission level will be assumed.
 @return */
func (a *DefaultApiService) GetRepositoriesRecentlyAccessed(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/profile/recent/repos"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["permission"], "string", "permission"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["permission"].(string); localVarOk {
		localVarQueryParams.Add("permission", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of repositories based on query parameters that control the search. See the documentation of the  parameters for more details.  &lt;p&gt;  This resource is anonymously accessible.  &lt;p&gt;  &lt;b&gt;Note on permissions.&lt;/b&gt; In absence of the {@code permission} query parameter the implicit &#39;read&#39; permission  is assumed. Please note that this permission is lower than the REPO_READ permission rather than being equal to  it. The implicit &#39;read&#39; permission for a given repository is assigned to any user that has any of the higher  permissions, such as &lt;tt&gt;REPO_READ&lt;/tt&gt;, as well as to anonymous users if the repository is marked as public.  The important implication of the above is that an anonymous request to this resource with a permission level  &lt;tt&gt;REPO_READ&lt;/tt&gt; is guaranteed to receive an empty list of repositories as a result. For anonymous requests  it is therefore recommended to not specify the &lt;tt&gt;permission&lt;/tt&gt; parameter at all.
 *   @param  for authentication, logging, tracing, etc.
	 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) (optional) if specified, this will limit the resulting repository list to ones whose name                     matches this parameter&#39;s value. The match will be done case-insensitive and any leading                     and/or trailing whitespace characters on the &lt;code&gt;name&lt;/code&gt; parameter will be stripped.
	 @param "projectname" (string) (optional) if specified, this will limit the resulting repository list to ones whose project&#39;s                     name matches this parameter&#39;s value. The match will be done case-insensitive and any leading                     and/or trailing whitespace characters on the &lt;code&gt;projectname&lt;/code&gt; parameter will                     be stripped.
	 @param "permission" (string) (optional) if specified, it must be a valid repository permission level name and will limit                     the resulting repository list to ones that the requesting user has the specified permission                     level to. If not specified, the default implicit &#39;read&#39; permission level will be assumed. The                     currently supported explicit permission values are &lt;tt&gt;REPO_READ&lt;/tt&gt;, &lt;tt&gt;REPO_WRITE&lt;/tt&gt;                     and &lt;tt&gt;REPO_ADMIN&lt;/tt&gt;.
	 @param "visibility" (string) (optional) if specified, this will limit the resulting repository list based on the                     repositories visibility. Valid values are &lt;em&gt;public&lt;/em&gt; or &lt;em&gt;private&lt;/em&gt;.
	 @return */
func (a *DefaultApiService) GetRepositories_19(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/repos"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["projectname"], "string", "projectname"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["permission"], "string", "permission"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["visibility"], "string", "visibility"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["projectname"].(string); localVarOk {
		localVarQueryParams.Add("projectname", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["permission"].(string); localVarOk {
		localVarQueryParams.Add("permission", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["visibility"].(string); localVarOk {
		localVarQueryParams.Add("visibility", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the repository matching the supplied &lt;strong&gt;projectKey&lt;/strong&gt; and &lt;strong&gt;repositorySlug&lt;/strong&gt;.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

@param projectKey the parent project key
@param projectKey2 the parent project key
@param repositorySlug the repository slug
@return */
func (a *DefaultApiService) GetRepository(projectKey, repositorySlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the repository matching the supplied &lt;strong&gt;projectKey&lt;/strong&gt; and &lt;strong&gt;repositorySlug&lt;/strong&gt;.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

@param projectKey the parent project key
@param projectKey2 the parent project key
@param repositorySlug the repository slug
@return */
func (a *DefaultApiService) GetUserRepository(username, repositorySlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/users/{username}/repos/{repositorySlug}"
	localVarPath = strings.Replace(localVarPath, "{"+"username"+"}", fmt.Sprintf("%v", username), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the repository matching the supplied &lt;strong&gt;projectKey&lt;/strong&gt; and &lt;strong&gt;repositorySlug&lt;/strong&gt;.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.
@param projectKey the parent project key
@param repositorySlug the repository slug
@return */
func (a *DefaultApiService) GetPullRequest(projectKey, repositorySlug string, pullRequestID int) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the repository matching the supplied &lt;strong&gt;projectKey&lt;/strong&gt; and &lt;strong&gt;repositorySlug&lt;/strong&gt;.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.
@param projectKey the parent project key
@param repositorySlug the repository slug
@return */
func (a *DefaultApiService) GetPullRequestActivity(projectKey, repositorySlug string, pullRequestID int) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/activities"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the repository matching the supplied &lt;strong&gt;projectKey&lt;/strong&gt; and &lt;strong&gt;repositorySlug&lt;/strong&gt;.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.
@param projectKey the parent project key
@param repositorySlug the repository slug
@return */
func (a *DefaultApiService) GetPullRequestActivityWithOptions(projectKey, repositorySlug string, pullRequestID int, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/activities"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the repository matching the supplied &lt;strong&gt;projectKey&lt;/strong&gt; and &lt;strong&gt;repositorySlug&lt;/strong&gt;.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.
@param projectKey the parent project key
@param repositorySlug the repository slug
@return */
func (a *DefaultApiService) GetPullRequestCommits(projectKey, repositorySlug string, pullRequestID int) (*APIResponse, error) {
	return a.GetPullRequestCommitsWithOptions(projectKey, repositorySlug, pullRequestID, make(map[string]interface{}))
}

func (a *DefaultApiService) GetPullRequestCommitsWithOptions(projectKey, repositorySlug string, pullRequestID int, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/commits"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}

	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

func (a *DefaultApiService) GetCommitBuildStatuses(commitSHA string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/build-status/1.0/commits/{commitId}"
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitSHA), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve a repository hook for this repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

@param hookKey
@return */
func (a *DefaultApiService) GetRepositoryHook(projectKey, repositorySlug string, hookKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"hookKey"+"}", fmt.Sprintf("%v", hookKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve a repository hook for this project.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_READ&lt;/strong&gt; permission for the specified project to call this  resource.

@param hookKey
@return */
func (a *DefaultApiService) GetRepositoryHook_20(projectKey, repositorySlug string, hookKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/settings/hooks/{hookKey}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"hookKey"+"}", fmt.Sprintf("%v", hookKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of repository hooks for this repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "type_" (string) the optional type to filter by. Valid values are &lt;code&gt;PRE_RECEIVE&lt;/code&gt; or &lt;code&gt;POST_RECEIVE&lt;/code&gt;
 @return */
func (a *DefaultApiService) GetRepositoryHooks(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["type_"], "string", "type_"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["type_"].(string); localVarOk {
		localVarQueryParams.Add("type", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of repository hooks for this project.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_READ&lt;/strong&gt; permission for the specified project to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "type_" (string) the optional type to filter by. Valid values are &lt;code&gt;PRE_RECEIVE&lt;/code&gt; or &lt;code&gt;POST_RECEIVE&lt;/code&gt;
 @return */
func (a *DefaultApiService) GetRepositoryHooks_21(projectKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/settings/hooks"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["type_"], "string", "type_"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["type_"].(string); localVarOk {
		localVarQueryParams.Add("type", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the current log level for the root logger.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher to call this resource.

@return */
func (a *DefaultApiService) GetRootLevel() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/logs/rootLogger"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieves the server email address

@return */
func (a *DefaultApiService) GetSenderAddress() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/mail-server/sender-address"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the settings for a repository hook for this repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

@param hookKey
@return */
func (a *DefaultApiService) GetSettings(projectKey, repositorySlug string, hookKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/settings"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"hookKey"+"}", fmt.Sprintf("%v", hookKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the settings for a repository hook for this project.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_READ&lt;/strong&gt; permission for the specified project to call this  resource.

@param hookKey
@return */
func (a *DefaultApiService) GetSettings_22(projectKey, repositorySlug string, hookKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/settings"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"hookKey"+"}", fmt.Sprintf("%v", hookKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Get the statistics for a specific webhook.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param webhookId id of the webhook
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "event" (string) the string id of a specific event to retrieve the last invocation for. May be empty, in which                   case all events are considered
 @return */
func (a *DefaultApiService) GetStatistics(projectKey, repositorySlug string, webhookId int32, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}/statistics"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"webhookId"+"}", fmt.Sprintf("%v", webhookId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["event"], "string", "event"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["event"].(string); localVarOk {
		localVarQueryParams.Add("event", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Get the statistics summary for a specific webhook.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

@param webhookId id of the webhook
@return */
func (a *DefaultApiService) GetStatisticsSummary(projectKey, repositorySlug string, webhookId int32) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}/statistics/summary"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"webhookId"+"}", fmt.Sprintf("%v", webhookId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve a tag in the specified repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the context repository to call this  resource.

@param name the name of the tag to be retrieved
@return */
func (a *DefaultApiService) GetTag(projectKey, repositorySlug string, name string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/tags/{name}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"name"+"}", fmt.Sprintf("%v", name), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve the tags matching the supplied &lt;strong&gt;filterText&lt;/strong&gt; param.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the context repository to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filterText" (string) the text to match on
	 @param "orderBy" (string) ordering of refs either ALPHABETICAL (by name) or MODIFICATION (last updated)
 @return */
func (a *DefaultApiService) GetTags(project, repository string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/tags"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", project), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repository), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filterText"], "string", "filterText"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["orderBy"], "string", "orderBy"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["filterText"].(string); localVarOk {
		localVarQueryParams.Add("filterText", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["orderBy"].(string); localVarOk {
		localVarQueryParams.Add("orderBy", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve a existing task.

@param taskId the id identifying the task to delete
@return */
func (a *DefaultApiService) GetTask(taskId int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/tasks/{taskId}"
	localVarPath = strings.Replace(localVarPath, "{"+"taskId"+"}", fmt.Sprintf("%v", taskId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/*GetSSHKeys retrieve ssh keys per user, param */
func (a *DefaultApiService) GetSSHKeys(user string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/ssh/1.0/keys"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if len(user) != 0 {
		localVarQueryParams.Add("user", user)
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/*CreateSSHKey create ssh key for user, params user and text  */
func (a *DefaultApiService) CreateSSHKey(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/ssh/1.0/keys"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["user"], "string", "user"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["text"], "string", "text"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["user"].(string); localVarOk {
		localVarQueryParams.Add("user", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["text"].(string); localVarOk {
		localVarFormParams.Add("text", parameterToString(localVarTempParam, ""))
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve the user matching the supplied &lt;strong&gt;userSlug&lt;/strong&gt;.  &lt;p&gt;

@return */
func (a *DefaultApiService) GetUser(username string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/users/"

	localVarPath = fmt.Sprintf("%s%s", localVarPath, username)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve a map of user setting key values for a specific user identified by the user slug.  &lt;p&gt;

@return */
func (a *DefaultApiService) GetUserSettings(userSlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/users/{userSlug}/settings"
	localVarPath = strings.Replace(localVarPath, "{"+"userSlug"+"}", fmt.Sprintf("%v", userSlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of users.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;LICENSED_USER&lt;/strong&gt; permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only users with usernames, display name or email addresses containing the supplied                string will be returned
 @return */
func (a *DefaultApiService) GetUsers(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/users"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of users that have been granted at least one global permission.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only user names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetUsersWithAnyPermission(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/permissions/users"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of users that have been granted at least one permission for the specified project.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project or a higher  global permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only group names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetUsersWithAnyPermission_23(projectKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/permissions/users"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of users that have been granted at least one permission for the specified repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository or a higher  project or global permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only group names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetUsersWithAnyPermission_24(projectKey string, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of users that have no granted global permissions.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only user names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetUsersWithoutAnyPermission(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/permissions/users/none"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of &lt;i&gt;licensed&lt;/i&gt; users that have no granted permissions for the specified project.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project or a higher  global permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only group names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetUsersWithoutPermission(projectKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/permissions/users/none"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of &lt;i&gt;licensed&lt;/i&gt; users that have no granted permissions for the specified repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository or a higher  project or global permission to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "filter" (string) if specified only group names containing the supplied string will be returned
 @return */
func (a *DefaultApiService) GetUsersWithoutPermission_25(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users/none"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve a page of users, optionally run through provided filters.  &lt;p&gt;  Only authenticated users may call this resource.   &lt;h3&gt;Supported Filters&lt;/h3&gt;  &lt;p&gt;  Filters are provided in query parameters in a standard &lt;code&gt;name&#x3D;value&lt;/code&gt; fashion. The following filters are  currently supported:  &lt;ul&gt;      &lt;li&gt;          {@code filter} - return only users, whose username, name or email address &lt;i&gt;contain&lt;/i&gt; the          {@code filter} value      &lt;/li&gt;      &lt;li&gt;          {@code group} - return only users who are members of the given group      &lt;/li&gt;      &lt;li&gt;          {@code permission} - the \&quot;root\&quot; of a permission filter, whose value must be a valid global,          project, or repository permission. Additional filter parameters referring to this filter that specify the          resource (project or repository) to apply the filter to must be prefixed with &lt;code&gt;permission.&lt;/code&gt;. See the          section \&quot;Permission Filters\&quot; below for more details.      &lt;/li&gt;      &lt;li&gt;          {@code permission.N} - the \&quot;root\&quot; of a single permission filter, similar to the {@code permission}          parameter, where \&quot;N\&quot; is a natural number starting from 1. This allows clients to specify multiple permission          filters, by providing consecutive filters as {@code permission.1}, {@code permission.2} etc. Note that          the filters numbering has to start with 1 and be continuous for all filters to be processed. The total allowed          number of permission filters is 50 and all filters exceeding that limit will be dropped. See the section          \&quot;Permission Filters\&quot; below for more details on how the permission filters are processed.      &lt;/li&gt;  &lt;/ul&gt;     &lt;h3&gt;Permission Filters&lt;/h3&gt;  &lt;p&gt;  The following three sub-sections list parameters supported for permission filters (where &lt;code&gt;[root]&lt;/code&gt; is  the root permission filter name, e.g. {@code permission}, {@code permission.1} etc.) depending on the  permission resource. The system determines which filter to apply (Global, Project or Repository permission)  based on the &lt;code&gt;[root]&lt;/code&gt; permission value. E.g. {@code ADMIN} is a global permission,  {@code PROJECT_ADMIN} is a project permission and {@code REPO_ADMIN} is a repository permission. Note  that the parameters for a given resource will be looked up in the order as they are listed below, that is e.g.  for a project resource, if both {@code projectId} and {@code projectKey} are provided, the system will  use {@code projectId} for the lookup.  &lt;h4&gt;Global permissions&lt;/h4&gt;  &lt;p&gt;  The permission value under &lt;code&gt;[root]&lt;/code&gt; is the only required and recognized parameter, as global  permissions do not apply to a specific resource.  &lt;p&gt;  Example valid filter: &lt;code&gt;permission&#x3D;ADMIN&lt;/code&gt;.  &lt;h4&gt;Project permissions&lt;/h4&gt;  &lt;ul&gt;      &lt;li&gt;&lt;code&gt;[root]&lt;/code&gt;- specifies the project permission&lt;/li&gt;      &lt;li&gt;&lt;code&gt;[root].projectId&lt;/code&gt; - specifies the project ID to lookup the project by&lt;/li&gt;      &lt;li&gt;&lt;code&gt;[root].projectKey&lt;/code&gt; - specifies the project key to lookup the project by&lt;/li&gt;  &lt;/ul&gt;  &lt;p&gt;  Example valid filter: &lt;code&gt;permission.1&#x3D;PROJECT_ADMIN&amp;permission.1.projectKey&#x3D;TEST_PROJECT&lt;/code&gt;.  &lt;h4&gt;Repository permissions&lt;/h4&gt;  &lt;ul&gt;      &lt;li&gt;&lt;code&gt;[root]&lt;/code&gt;- specifies the repository permission&lt;/li&gt;      &lt;li&gt;&lt;code&gt;[root].projectId&lt;/code&gt; - specifies the repository ID to lookup the repository by&lt;/li&gt;      &lt;li&gt;&lt;code&gt;[root].projectKey&lt;/code&gt; and &lt;code&gt;[root].repositorySlug&lt;/code&gt;- specifies the project key and      repository slug to lookup the repository by; both values &lt;i&gt;need to&lt;/i&gt; be provided for this look up to be      triggered&lt;/li&gt;  &lt;/ul&gt;  Example valid filter: &lt;code&gt;permission.2&#x3D;REPO_ADMIN&amp;permission.2.projectKey&#x3D;TEST_PROJECT&amp;permission.2.repositorySlug&#x3D;test_repo&lt;/code&gt;.

@return */
func (a *DefaultApiService) GetUsers_26(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/users"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Get a webhook by id.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param webhookId the existing webhook id
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "statistics" (bool)
 @return */
func (a *DefaultApiService) GetWebhook(projectKey, repositorySlug string, webhookId int32, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"webhookId"+"}", fmt.Sprintf("%v", webhookId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["statistics"], "bool", "statistics"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["statistics"].(bool); localVarOk {
		localVarQueryParams.Add("statistics", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieve a pull request.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

@param pullRequestId the ID of the pull request within the repository
@return */
func (a *DefaultApiService) Get_27(projectKey, repositorySlug string, pullRequestID int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Check whether the specified permission is the default permission (granted to all users) for a project.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project or a higher  global permission to call this resource.

@param permission the permission to grant                        Available project permissions are:                        &lt;ul&gt;                            &lt;li&gt;PROJECT_READ&lt;/li&gt;                            &lt;li&gt;PROJECT_WRITE&lt;/li&gt;                            &lt;li&gt;PROJECT_ADMIN&lt;/li&gt;                        &lt;/ul&gt;
@return */
func (a *DefaultApiService) HasAllUserPermission(projectKey, permission string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/permissions/{permission}/all"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"permission"+"}", fmt.Sprintf("%v", permission), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Retrieves a page of the participants for a given pull request.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

@param pullRequestId the id of the pull request within the repository
@return */
func (a *DefaultApiService) ListParticipants(projectKey, repositorySlug string, pullRequestID int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Merge the specified pull request.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_WRITE&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

 @param pullRequestId the ID of the pull request within the repository
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "version" (int32) the current version of the pull request. If the server&#39;s version isn&#39;t the same as the specified                 version the operation will fail. To determine the current version of the pull request it should be                 fetched from the server prior to this operation. Look for the &#39;version&#39; attribute in the returned                 JSON structure.
 @return */
func (a *DefaultApiService) Merge(projectKey, repositorySlug string, pullRequestID int, localVarOptionals map[string]interface{}, localVarPostBody interface{}, localVarHTTPContentTypes []string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/merge"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["version"], "int32", "version"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["version"].(int32); localVarOk {
		localVarQueryParams.Add("version", parameterToString(localVarTempParam, ""))
	}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Grant or revoke a project permission to all users, i.e. set the default permission.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project or a higher  global permission to call this resource.

 @param permission the permission to grant                        Available project permissions are:                        &lt;ul&gt;                            &lt;li&gt;PROJECT_READ&lt;/li&gt;                            &lt;li&gt;PROJECT_WRITE&lt;/li&gt;                            &lt;li&gt;PROJECT_ADMIN&lt;/li&gt;                        &lt;/ul&gt;
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "allow" (bool) &lt;em&gt;true&lt;/em&gt; to grant the specified permission to all users, or &lt;em&gt;false&lt;/em&gt; to revoke it
 @return */
func (a *DefaultApiService) ModifyAllUserPermission(projectKey, repositorySlug string, permission string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/permissions/{permission}/all"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"permission"+"}", fmt.Sprintf("%v", permission), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["allow"], "bool", "allow"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["allow"].(bool); localVarOk {
		localVarQueryParams.Add("allow", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Preview the generated html for given markdown contents.  &lt;p&gt;  Only authenticated users may call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "urlMode" (string) (Optional) The UrlMode used when building the url. One of: ABSOLUTE, RELATIVE and CONFIGURED                       By default this is RELATIVE.
	 @param "hardwrap" (bool) (Optional) Whether the markup implementation should convert newlines to breaks.                       By default this is false which reflects the standard markdown specification.
	 @param "htmlEscape" (bool) (Optional) true if HTML should be escaped in the input markup, false otherwise.
 @return */
func (a *DefaultApiService) Preview(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/markup/preview"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["urlMode"], "string", "urlMode"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["hardwrap"], "bool", "hardwrap"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["htmlEscape"], "bool", "htmlEscape"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["urlMode"].(string); localVarOk {
		localVarQueryParams.Add("urlMode", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["hardwrap"].(bool); localVarOk {
		localVarQueryParams.Add("hardwrap", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["htmlEscape"].(bool); localVarOk {
		localVarQueryParams.Add("htmlEscape", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Remove a user from a group. This is very similar to &lt;code&gt;groups/remove-user&lt;/code&gt;, but with the &lt;em&gt;context&lt;/em&gt;  and &lt;em&gt;itemName&lt;/em&gt; attributes of the supplied request entity reversed. On the face of it this may appear  redundant, but it facilitates a specific UI component in Stash.  &lt;p&gt;  In the request entity, the &lt;em&gt;context&lt;/em&gt; attribute is the user and the &lt;em&gt;itemName&lt;/em&gt; is the group.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) RemoveGroupFromUser() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/users/remove-group"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
&lt;strong&gt;Deprecated since 2.10&lt;/strong&gt;. Use /rest/users/remove-groups instead.  &lt;p&gt;  Remove a user from a group.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.  &lt;p&gt;  In the request entity, the &lt;em&gt;context&lt;/em&gt; attribute is the group and the &lt;em&gt;itemName&lt;/em&gt; is the user.

@return */
func (a *DefaultApiService) RemoveUserFromGroup() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/groups/remove-user"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Rename a user.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) RenameUser() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/users/rename"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Re-open a declined pull request.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

 @param pullRequestId the id of the pull request within the repository
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "version" (int32) the current version of the pull request. If the server&#39;s version isn&#39;t the same as the specified                 version the operation will fail. To determine the current version of the pull request it should be                 fetched from the server prior to this operation. Look for the &#39;version&#39; attribute in the returned                 JSON structure.
 @return */
func (a *DefaultApiService) Reopen(projectKey, repositorySlug string, pullRequestID int64, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/reopen"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["version"], "int32", "version"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["version"].(int32); localVarOk {
		localVarQueryParams.Add("version", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
If a create or fork operation fails, calling this method will clean up the broken repository and try again. The  repository must be in an INITIALISATION_FAILED state.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project to call this  resource.

@param projectKey the parent project key
@return */
func (a *DefaultApiService) RetryCreateRepository(projectKey, repositorySlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/recreate"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Revoke all global permissions for a group.   &lt;p&gt;  The authenticated user must have:  &lt;ul&gt;      &lt;li&gt;&lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher; and&lt;/li&gt;      &lt;li&gt;greater or equal permissions than the current permission level of the group (a user may not demote the      permission level of a group with higher permissions than them)&lt;/li&gt;  &lt;/ul&gt;  to call this resource. In addition, a user may not revoke a group&#39;s permissions if their own permission level  would be reduced as a result.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) the name of the group
 @return */
func (a *DefaultApiService) RevokePermissionsForGroup(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/permissions/groups"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
 Revoke all permissions for the specified project for a group.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project or a higher  global permission to call this resource.  &lt;p&gt;  In addition, a user may not revoke a group&#39;s permissions if it will reduce their own permission level.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) the name of the group
 @return */
func (a *DefaultApiService) RevokePermissionsForGroup_28(projectKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/permissions/groups"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
 Revoke all permissions for the specified repository for a group.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository or a higher  project or global permission to call this resource.  &lt;p&gt;  In addition, a user may not revoke a group&#39;s permissions if it will reduce their own permission level.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) the name of the group
 @return */
func (a *DefaultApiService) RevokePermissionsForGroup_29(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
 Revoke all global permissions for a user.  &lt;p&gt;  The authenticated user must have:  &lt;ul&gt;      &lt;li&gt;&lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher; and&lt;/li&gt;      &lt;li&gt;greater or equal permissions than the current permission level of the user (a user may not demote the      permission level of a user with higher permissions than them)&lt;/li&gt;  &lt;/ul&gt;  to call this resource. In addition, a user may not demote their own permission level.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) the name of the user
 @return */
func (a *DefaultApiService) RevokePermissionsForUser(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/permissions/users"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
 Revoke all permissions for the specified project for a user.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project or a higher  global permission to call this resource.  &lt;p&gt;  In addition, a user may not revoke their own project permissions if they do not have a higher global permission.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) the name of the user
 @return */
func (a *DefaultApiService) RevokePermissionsForUser_30(projectKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/permissions/users"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
 Revoke all permissions for the specified repository for a user.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository or a higher  project or global permission to call this resource.  &lt;p&gt;  In addition, a user may not revoke their own repository permissions if they do not have a higher  project or global permission.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) the name of the user
 @return */
func (a *DefaultApiService) RevokePermissionsForUser_31(projectKey string, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
 Retrieve a page of participant users for all the pull requests to or from the specified repository.  &lt;p&gt;  &lt;p&gt;  Optionally clients can specify following filters.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "direction" (string) (optional, defaults to &lt;strong&gt;INCOMING&lt;/strong&gt;) the direction relative to the specified                   repository. Either &lt;strong&gt;INCOMING&lt;/strong&gt; or &lt;strong&gt;OUTGOING&lt;/strong&gt;.
	 @param "filter" (string) (optional) return only users, whose username, name or email address &lt;i&gt;contain&lt;/i&gt;                   the {@code filter} value
	 @param "role" (string) (optional) The role associated with the pull request participant.                   This must be one of {@code AUTHOR}, {@code REVIEWER}, or{@code PARTICIPANT}
 @return */
func (a *DefaultApiService) Search(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/participants"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["direction"], "string", "direction"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["filter"], "string", "filter"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["role"], "string", "role"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["direction"].(string); localVarOk {
		localVarQueryParams.Add("direction", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["filter"].(string); localVarOk {
		localVarQueryParams.Add("filter", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["role"].(string); localVarOk {
		localVarQueryParams.Add("role", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the default branch of a repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

@return */
func (a *DefaultApiService) SetDefaultBranch(projectKey, repositorySlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches/default"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Set the current log level for a given logger.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher to call this resource.

@param levelName the level to set the logger to. Either TRACE, DEBUG, INFO, WARN or ERROR
@param loggerName the name of the logger.
@return */
func (a *DefaultApiService) SetLevel(levelName string, loggerName string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/logs/logger/{loggerName}/{levelName}"
	localVarPath = strings.Replace(localVarPath, "{"+"levelName"+"}", fmt.Sprintf("%v", levelName), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"loggerName"+"}", fmt.Sprintf("%v", loggerName), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Updates the mail configuration   The authenticated user must have the &lt;strong&gt;SYS_ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) SetMailConfig() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/mail-server"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the pull request merge strategies for the context repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;ADMIN&lt;/strong&gt; permission for the context repository to call this  resource.  &lt;p&gt;  Only the strategies provided will be enabled, only one may be set to default  &lt;p&gt;  An explicitly set pull request merge strategy configuration can be deleted by POSTing a document with  an empty \&quot;mergeConfig\&quot; attribute. i.e:  &lt;pre&gt;  {      \&quot;mergeConfig\&quot;: {      }  }  &lt;/pre&gt;  Upon completion of this request, the effective configuration will be the default configuration.

@param scmId the id of the scm to get strategies for
@return */
func (a *DefaultApiService) SetMergeConfig(scmId string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/pull-requests/{scmId}"
	localVarPath = strings.Replace(localVarPath, "{"+"scmId"+"}", fmt.Sprintf("%v", scmId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Promote or demote a group&#39;s permission level for the specified repository. Available repository permissions are:  &lt;ul&gt;      &lt;li&gt;REPO_READ&lt;/li&gt;      &lt;li&gt;REPO_WRITE&lt;/li&gt;      &lt;li&gt;REPO_ADMIN&lt;/li&gt;  &lt;/ul&gt;  See the &lt;a href&#x3D;\&quot;https://confluence.atlassian.com/display/BitbucketServer/Using+repository+permissions\&quot;&gt;Bitbucket  Server documentation&lt;/a&gt; for a detailed explanation of what each permission entails.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository or a higher  project or global permission to call this resource. In addition, a user may not demote a group&#39;s permission level if their  own permission level would be reduced as a result.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "permission" (string) the permission to grant
	 @param "name" (string) the names of the groups
 @return */
func (a *DefaultApiService) SetPermissionForGroup(projectKey string, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["permission"], "string", "permission"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["permission"].(string); localVarOk {
		localVarQueryParams.Add("permission", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	// No body parsing (a successful 204 response has no content)
	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
 Promote or demote a user&#39;s global permission level. Available global permissions are:  &lt;ul&gt;      &lt;li&gt;LICENSED_USER&lt;/li&gt;      &lt;li&gt;PROJECT_CREATE&lt;/li&gt;      &lt;li&gt;ADMIN&lt;/li&gt;      &lt;li&gt;SYS_ADMIN&lt;/li&gt;  &lt;/ul&gt;  See the &lt;a href&#x3D;\&quot;https://confluence.atlassian.com/display/BitbucketServer/Global+permissions\&quot;&gt;Bitbucket Server  documentation&lt;/a&gt; for a detailed explanation of what each permission entails.  &lt;p&gt;  The authenticated user must have:  &lt;ul&gt;      &lt;li&gt;&lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher; and&lt;/li&gt;      &lt;li&gt;the permission they are attempting to grant or higher; and&lt;/li&gt;      &lt;li&gt;greater or equal permissions than the current permission level of the group (a user may not demote the      permission level of a group with higher permissions than them)&lt;/li&gt;  &lt;/ul&gt;  to call this resource. In addition, a user may not demote a group&#39;s permission level if their own permission  level would be reduced as a result.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "permission" (string) the permission to grant
	 @param "name" (string) the names of the groups
 @return */
func (a *DefaultApiService) SetPermissionForGroups(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/permissions/groups"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["permission"], "string", "permission"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["permission"].(string); localVarOk {
		localVarQueryParams.Add("permission", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Promote or demote a group&#39;s permission level for the specified project.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project or a higher  global permission to call this resource. In addition, a user may not demote a group&#39;s permission level if their  own permission level would be reduced as a result.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "permission" (string) The permission to grant.                        See the [permissions documentation](https://confluence.atlassian.com/display/BitbucketServer/Using+project+permissions)                        for a detailed explanation of what each permission entails.                        Available project permissions are:                        &lt;ul&gt;                            &lt;li&gt;PROJECT_READ&lt;/li&gt;                            &lt;li&gt;PROJECT_WRITE&lt;/li&gt;                            &lt;li&gt;PROJECT_ADMIN&lt;/li&gt;                        &lt;/ul&gt;
	 @param "name" (string) the names of the groups
 @return */
func (a *DefaultApiService) SetPermissionForGroups_32(projectKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/permissions/groups"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["permission"], "string", "permission"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["permission"].(string); localVarOk {
		localVarQueryParams.Add("permission", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
 Promote or demote a user&#39;s permission level for the specified repository. Available repository permissions are:  &lt;ul&gt;      &lt;li&gt;REPO_READ&lt;/li&gt;      &lt;li&gt;REPO_WRITE&lt;/li&gt;      &lt;li&gt;REPO_ADMIN&lt;/li&gt;  &lt;/ul&gt;  See the &lt;a href&#x3D;\&quot;https://confluence.atlassian.com/display/BitbucketServer/Using+repository+permissions\&quot;&gt;Bitbucket  Server documentation&lt;/a&gt; for a detailed explanation of what each permission entails.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository or a higher  project or global permission to call this resource. In addition, a user may not reduce their own permission level unless  they have a project or global permission that already implies that permission.

 @param "projectKey" (string) name of the project to grant permission to
 @param "repositorySlug" (string) repository slug
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) the names of the users
	 @param "permission" (string) the permission to grant
 @return */
func (a *DefaultApiService) SetPermissionForUser(projectKey string, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["permission"], "string", "permission"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["permission"].(string); localVarOk {
		localVarQueryParams.Add("permission", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
 Promote or demote the global permission level of a user. Available global permissions are:  &lt;ul&gt;      &lt;li&gt;LICENSED_USER&lt;/li&gt;      &lt;li&gt;PROJECT_CREATE&lt;/li&gt;      &lt;li&gt;ADMIN&lt;/li&gt;      &lt;li&gt;SYS_ADMIN&lt;/li&gt;  &lt;/ul&gt;  See the &lt;a href&#x3D;\&quot;https://confluence.atlassian.com/display/BitbucketServer/Global+permissions\&quot;&gt;Bitbucket Server  documentation&lt;/a&gt; for a detailed explanation of what each permission entails.  &lt;p&gt;  The authenticated user must have:  &lt;ul&gt;      &lt;li&gt;&lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher; and&lt;/li&gt;      &lt;li&gt;the permission they are attempting to grant; and&lt;/li&gt;      &lt;li&gt;greater or equal permissions than the current permission level of the user (a user may not demote the      permission level of a user with higher permissions than them)&lt;/li&gt;  &lt;/ul&gt;  to call this resource. In addition, a user may not demote their own permission level.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) the names of the users
	 @param "permission" (string) the permission to grant
 @return */
func (a *DefaultApiService) SetPermissionForUsers(localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/permissions/users"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["permission"], "string", "permission"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["permission"].(string); localVarOk {
		localVarQueryParams.Add("permission", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Promote or demote a user&#39;s permission level for the specified project.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project or a higher  global permission to call this resource. In addition, a user may not reduce their own permission level unless  they have a global permission that already implies that permission.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "name" (string) the names of the users
	 @param "permission" (string) the permission to grant. See the [permissions documentation](https://confluence.atlassian.com/display/BitbucketServer/Using+project+permissions)                        for a detailed explanation of what each permission entails.                        Available project permissions are:                        &lt;ul&gt;                            &lt;li&gt;PROJECT_READ&lt;/li&gt;                            &lt;li&gt;PROJECT_WRITE&lt;/li&gt;                            &lt;li&gt;PROJECT_ADMIN&lt;/li&gt;                        &lt;/ul&gt;
 @return */
func (a *DefaultApiService) SetPermissionForUsers_33(projectKey string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/permissions/users"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["name"], "string", "name"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["permission"], "string", "permission"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["name"].(string); localVarOk {
		localVarQueryParams.Add("name", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["permission"].(string); localVarOk {
		localVarQueryParams.Add("permission", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/* DefaultApiService
Set the current log level for the root logger.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;ADMIN&lt;/strong&gt; permission or higher to call this resource.

@param levelName the level to set the logger to. Either TRACE, DEBUG, INFO, WARN or ERROR
@return */
func (a *DefaultApiService) SetRootLevel(levelName string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/logs/rootLogger/{levelName}"
	localVarPath = strings.Replace(localVarPath, "{"+"levelName"+"}", fmt.Sprintf("%v", levelName), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Updates the server email address   The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) SetSenderAddress() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/mail-server/sender-address"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Modify the settings for a repository hook for this repository.  &lt;p&gt;  The service will reject any settings which are too large, the current limit is 32KB once serialized.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.  &lt;p&gt;  A JSON document can be provided to use as the settings for the hook. These structure and validity of the document  is decided by the plugin providing the hook.

@param hookKey
@return */
func (a *DefaultApiService) SetSettings(projectKey, repositorySlug string, hookKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/settings"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"hookKey"+"}", fmt.Sprintf("%v", hookKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Modify the settings for a repository hook for this project.  &lt;p&gt;  The service will reject any settings which are too large, the current limit is 32KB once serialized.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project to call this  resource.  &lt;p&gt;  A JSON document can be provided to use as the settings for the hook. These structure and validity of the document  is decided by the plugin providing the hook.

@param hookKey
@return */
func (a *DefaultApiService) SetSettings_34(projectKey, repositorySlug string, hookKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/settings"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"hookKey"+"}", fmt.Sprintf("%v", hookKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Streams files in the requested &lt;code&gt;path&lt;/code&gt; with the last commit to modify each file. Commit modifications  are traversed starting from the &lt;code&gt;at&lt;/code&gt; commit or, if not specified, from the tip of the default branch.  &lt;p&gt;  Unless the repository is public, the authenticated user must have &lt;b&gt;REPO_READ&lt;/b&gt; access to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "at" (string) the commit to use as the starting point when listing files and calculating modifications
 @return */
func (a *DefaultApiService) Stream(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/last-modified"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["at"], "string", "at"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["at"].(string); localVarOk {
		localVarQueryParams.Add("at", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Gets the file changes available in the {@code from} commit but not in the {@code to} commit.  &lt;p&gt;  If either the {@code from} or {@code to} commit are not specified, they will be replaced by the  default branch of their containing repository.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "from" (string) the source commit (can be a partial/full commit ID or qualified/unqualified ref name)
	 @param "to" (string) the target commit (can be a partial/full commit ID or qualified/unqualified ref name)
	 @param "fromRepo" (string) an optional parameter specifying the source repository containing the source commit                  if that commit is not present in the current repository; the repository can be specified                  by either its ID &lt;em&gt;fromRepo&#x3D;42&lt;/em&gt; or by its project key plus its repo slug separated by                  a slash: &lt;em&gt;fromRepo&#x3D;projectKey/repoSlug&lt;/em&gt;
 @return */
func (a *DefaultApiService) StreamChanges(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/compare/changes"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["from"], "string", "from"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["to"], "string", "to"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["fromRepo"], "string", "fromRepo"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["from"].(string); localVarOk {
		localVarQueryParams.Add("from", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["to"].(string); localVarOk {
		localVarQueryParams.Add("to", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["fromRepo"].(string); localVarOk {
		localVarQueryParams.Add("fromRepo", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Gets changes for the specified PullRequest.  &lt;p&gt;  If the {@code changeScope} query parameter is set to {@code unreviewed}, the application will attempt to stream  unreviewed changes based on the {@code lastReviewedCommit} of the current user, which are the changes between the  {@code lastReviewedCommit} and the latest commit of the source branch. The current user is considered to  &lt;i&gt;not&lt;/i&gt; have any unreviewed changes for the pull request when the {@code lastReviewedCommit} is either  {@code null} (everything is unreviewed, so all changes are streamed), equal to the latest commit of the source  branch (everything is reviewed), or no longer on the source branch (the source branch has been rebased). In these  cases, the application will fall back to streaming all changes (the default), which is the effective diff for the  pull request. The type of changes streamed can be determined by the {@code changeScope} parameter included in the  properties map of the response.  &lt;p&gt;  Note: This resource is currently &lt;i&gt;not paged&lt;/i&gt;. The server will return at most one page. The server will  truncate the number of changes to either the request&#39;s page limit or an internal maximum, whichever is smaller.  The start parameter of the page request is also ignored.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "changeScope" (string) {@code UNREVIEWED} to stream the unreviewed changes for the current user (if they exist);                     {@code RANGE} to stream changes between two arbitrary commits (requires {@code sinceId} and                     {@code untilId}); otherwise {@code ALL} to stream all changes (the default)
	 @param "sinceId" (string) the since commit hash to stream changes for a {@code RANGE} arbitrary change scope
	 @param "untilId" (string) the until commit hash to stream changes for a {@code RANGE} arbitrary change scope
	 @param "withComments" (bool) {@code true} to apply comment counts in the changes (the default); otherwise, {@code false}                      to stream changes without comment counts
 @return */
func (a *DefaultApiService) StreamChanges_35(projectKey, repositorySlug string, pullRequestID int64, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/changes"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["changeScope"], "string", "changeScope"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["sinceId"], "string", "sinceId"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["untilId"], "string", "untilId"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["withComments"], "bool", "withComments"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["changeScope"].(string); localVarOk {
		localVarQueryParams.Add("changeScope", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["sinceId"].(string); localVarOk {
		localVarQueryParams.Add("sinceId", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["untilId"].(string); localVarOk {
		localVarQueryParams.Add("untilId", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["withComments"].(bool); localVarOk {
		localVarQueryParams.Add("withComments", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Gets the commits accessible from the {@code from} commit but not in the {@code to} commit.  &lt;p&gt;  If either the {@code from} or {@code to} commit are not specified, they will be replaced by the  default branch of their containing repository.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "from" (string) the source commit (can be a partial/full commit ID or qualified/unqualified ref name)
	 @param "to" (string) the target commit (can be a partial/full commit ID or qualified/unqualified ref name)
	 @param "fromRepo" (string) an optional parameter specifying the source repository containing the source commit                  if that commit is not present in the current repository; the repository can be specified                  by either its ID &lt;em&gt;fromRepo&#x3D;42&lt;/em&gt; or by its project key plus its repo slug separated by                  a slash: &lt;em&gt;fromRepo&#x3D;projectKey/repoSlug&lt;/em&gt;
 @return */
func (a *DefaultApiService) StreamCommits(project, repository string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := fmt.Sprintf("%s/api/1.0/projects/%s/repos/%s/compare/commits", a.client.cfg.BasePath, project, repository)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["from"], "string", "from"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["to"], "string", "to"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["fromRepo"], "string", "fromRepo"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["from"].(string); localVarOk {
		localVarQueryParams.Add("from", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["to"].(string); localVarOk {
		localVarQueryParams.Add("to", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["fromRepo"].(string); localVarOk {
		localVarQueryParams.Add("fromRepo", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve the diff between two provided revisions.  &lt;p&gt;  &lt;strong&gt;Note:&lt;/strong&gt; This resource is currently &lt;i&gt;not paged&lt;/i&gt;. The server will internally apply a hard cap  to the streamed lines, and it is not possible to request subsequent pages if that cap is exceeded. In the event  that the cap is reached, the diff will be cut short and one or more {@code truncated} flags will be set to  {@code true} on the {@code \&quot;segments\&quot;}, {@code \&quot;hunks\&quot;} and {@code \&quot;diffs\&quot;} properties, as well as the top-level  object, in the returned JSON response.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param commitId
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "autoSrcPath" (bool) {@code true} to automatically try to find the source path when it&#39;s not provided,                       {@code false} otherwise. Requires the {@code path} to be provided.
	 @param "contextLines" (int32) the number of context lines to include around added/removed lines in the diff
	 @param "since" (string) the base revision to diff from. If omitted the parent revision of the until revision is used
	 @param "srcPath" (string) the source path for the file, if it was copied, moved or renamed
	 @param "whitespace" (string) optional whitespace flag which can be set to {@code ignore-all}
	 @param "withComments" (bool) {@code true} to embed comments in the diff (the default); otherwise {@code false}                       to stream the diff without comments
 @return */
func (a *DefaultApiService) StreamDiff(projectKey, repositorySlug string, commitId string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/diff"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["autoSrcPath"], "bool", "autoSrcPath"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["contextLines"], "int32", "contextLines"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["since"], "string", "since"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["srcPath"], "string", "srcPath"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["whitespace"], "string", "whitespace"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["withComments"], "bool", "withComments"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["autoSrcPath"].(bool); localVarOk {
		localVarQueryParams.Add("autoSrcPath", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["contextLines"].(int32); localVarOk {
		localVarQueryParams.Add("contextLines", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["since"].(string); localVarOk {
		localVarQueryParams.Add("since", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["srcPath"].(string); localVarOk {
		localVarQueryParams.Add("srcPath", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["whitespace"].(string); localVarOk {
		localVarQueryParams.Add("whitespace", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["withComments"].(bool); localVarOk {
		localVarQueryParams.Add("withComments", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve the diff between two provided revisions.  &lt;p&gt;  &lt;strong&gt;Note:&lt;/strong&gt; This resource is currently &lt;i&gt;not paged&lt;/i&gt;. The server will internally apply a hard cap  to the streamed lines, and it is not possible to request subsequent pages if that cap is exceeded. In the event  that the cap is reached, the diff will be cut short and one or more {@code truncated} flags will be set to  {@code true} on the {@code \&quot;segments\&quot;}, {@code \&quot;hunks\&quot;} and {@code \&quot;diffs\&quot;} properties, as well as the top-level  object, in the returned JSON response.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param commitId
 @param path the path to the file which should be diffed (optional)
 @param commitId2
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "autoSrcPath" (bool) {@code true} to automatically try to find the source path when it&#39;s not provided,                       {@code false} otherwise. Requires the {@code path} to be provided.
	 @param "contextLines" (int32) the number of context lines to include around added/removed lines in the diff
	 @param "since" (string) the base revision to diff from. If omitted the parent revision of the until revision is used
	 @param "srcPath" (string) the source path for the file, if it was copied, moved or renamed
	 @param "whitespace" (string) optional whitespace flag which can be set to {@code ignore-all}
	 @param "withComments" (bool) {@code true} to embed comments in the diff (the default); otherwise {@code false}                       to stream the diff without comments
 @return */
func (a *DefaultApiService) StreamDiff_36(projectKey, repositorySlug string, commitId string, path string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/diff/{path}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", fmt.Sprintf("%v", path), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["autoSrcPath"], "bool", "autoSrcPath"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["contextLines"], "int32", "contextLines"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["since"], "string", "since"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["srcPath"], "string", "srcPath"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["whitespace"], "string", "whitespace"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["withComments"], "bool", "withComments"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["autoSrcPath"].(bool); localVarOk {
		localVarQueryParams.Add("autoSrcPath", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["contextLines"].(int32); localVarOk {
		localVarQueryParams.Add("contextLines", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["since"].(string); localVarOk {
		localVarQueryParams.Add("since", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["srcPath"].(string); localVarOk {
		localVarQueryParams.Add("srcPath", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["whitespace"].(string); localVarOk {
		localVarQueryParams.Add("whitespace", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["withComments"].(bool); localVarOk {
		localVarQueryParams.Add("withComments", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Gets a diff of the changes available in the {@code from} commit but not in the {@code to} commit.  &lt;p&gt;  If either the {@code from} or {@code to} commit are not specified, they will be replaced by the  default branch of their containing repository.

 @param path the path to the file to diff (optional)
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "from" (string) the source commit (can be a partial/full commit ID or qualified/unqualified ref name)
	 @param "to" (string) the target commit (can be a partial/full commit ID or qualified/unqualified ref name)
	 @param "fromRepo" (string) an optional parameter specifying the source repository containing the source commit                  if that commit is not present in the current repository; the repository can be specified                  by either its ID &lt;em&gt;fromRepo&#x3D;42&lt;/em&gt; or by its project key plus its repo slug separated by                  a slash: &lt;em&gt;fromRepo&#x3D;projectKey/repoSlug&lt;/em&gt;
	 @param "srcPath" (string)
	 @param "contextLines" (int32) an optional number of context lines to include around each added or removed lines in the diff
	 @param "whitespace" (string) an optional whitespace flag which can be set to &lt;code&gt;ignore-all&lt;/code&gt;
 @return */
func (a *DefaultApiService) StreamDiff_37(project, repository, path string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := fmt.Sprintf("%s/api/1.0/projects/%s/repos/%s/compare/diff%s", a.client.cfg.BasePath, project, repository, path)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["from"], "string", "from"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["to"], "string", "to"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["fromRepo"], "string", "fromRepo"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["srcPath"], "string", "srcPath"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["contextLines"], "int32", "contextLines"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["whitespace"], "string", "whitespace"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["from"].(string); localVarOk {
		localVarQueryParams.Add("from", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["to"].(string); localVarOk {
		localVarQueryParams.Add("to", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["fromRepo"].(string); localVarOk {
		localVarQueryParams.Add("fromRepo", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["srcPath"].(string); localVarOk {
		localVarQueryParams.Add("srcPath", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["contextLines"].(int32); localVarOk {
		localVarQueryParams.Add("contextLines", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["whitespace"].(string); localVarOk {
		localVarQueryParams.Add("whitespace", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve the diff for a specified file path between two provided revisions.  &lt;p&gt;  &lt;strong&gt;Note:&lt;/strong&gt; This resource is currently &lt;i&gt;not paged&lt;/i&gt;. The server will internally apply a hard cap  to the streamed lines, and it is not possible to request subsequent pages if that cap is exceeded. In the event  that the cap is reached, the diff will be cut short and one or more &lt;code&gt;truncated&lt;/code&gt; flags will be set to  &lt;code&gt;true&lt;/code&gt; on the segments, hunks and diffs substructures in the returned JSON response.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "contextLines" (int32) the number of context lines to include around added/removed lines in the diff
	 @param "since" (string) the base revision to diff from. If omitted the parent revision of the until revision is used
	 @param "srcPath" (string) the source path for the file, if it was copied, moved or renamed
	 @param "until" (string) the target revision to diff to (required)
	 @param "whitespace" (string) optional whitespace flag which can be set to &lt;code&gt;ignore-all&lt;/code&gt;
 @return */
func (a *DefaultApiService) StreamDiff_38(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/diff"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["contextLines"], "int32", "contextLines"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["since"], "string", "since"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["srcPath"], "string", "srcPath"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["until"], "string", "until"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["whitespace"], "string", "whitespace"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["contextLines"].(int32); localVarOk {
		localVarQueryParams.Add("contextLines", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["since"].(string); localVarOk {
		localVarQueryParams.Add("since", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["srcPath"].(string); localVarOk {
		localVarQueryParams.Add("srcPath", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["until"].(string); localVarOk {
		localVarQueryParams.Add("until", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["whitespace"].(string); localVarOk {
		localVarQueryParams.Add("whitespace", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve the diff for a specified file path between two provided revisions.  &lt;p&gt;  &lt;strong&gt;Note:&lt;/strong&gt; This resource is currently &lt;i&gt;not paged&lt;/i&gt;. The server will internally apply a hard cap  to the streamed lines, and it is not possible to request subsequent pages if that cap is exceeded. In the event  that the cap is reached, the diff will be cut short and one or more &lt;code&gt;truncated&lt;/code&gt; flags will be set to  &lt;code&gt;true&lt;/code&gt; on the segments, hunks and diffs substructures in the returned JSON response.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param path the path to the file which should be diffed (required)
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "contextLines" (int32) the number of context lines to include around added/removed lines in the diff
	 @param "since" (string) the base revision to diff from. If omitted the parent revision of the until revision is used
	 @param "srcPath" (string) the source path for the file, if it was copied, moved or renamed
	 @param "until" (string) the target revision to diff to (required)
	 @param "whitespace" (string) optional whitespace flag which can be set to &lt;code&gt;ignore-all&lt;/code&gt;
 @return */
func (a *DefaultApiService) StreamDiff_39(projectKey, repositorySlug string, path string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/diff/{path}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", fmt.Sprintf("%v", path), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["contextLines"], "int32", "contextLines"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["since"], "string", "since"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["srcPath"], "string", "srcPath"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["until"], "string", "until"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["whitespace"], "string", "whitespace"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["contextLines"].(int32); localVarOk {
		localVarQueryParams.Add("contextLines", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["since"].(string); localVarOk {
		localVarQueryParams.Add("since", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["srcPath"].(string); localVarOk {
		localVarQueryParams.Add("srcPath", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["until"].(string); localVarOk {
		localVarQueryParams.Add("until", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["whitespace"].(string); localVarOk {
		localVarQueryParams.Add("whitespace", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Streams a diff within a pull request.  &lt;p&gt;  If the specified file has been copied, moved or renamed, the &lt;code&gt;srcPath&lt;/code&gt; must also be specified to  produce the correct diff.  &lt;p&gt;  Note: This RESTful endpoint is currently &lt;i&gt;not paged&lt;/i&gt;. The server will internally apply a hard cap to the  streamed lines, and it is not possible to request subsequent pages if that cap is exceeded.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "contextLines" (int32) the number of context lines to include around added/removed lines in the diff
	 @param "diffType" (string) the type of diff being requested. When {@code withComments} is {@code true}                      this works as a hint to the system to attach the correct set of comments to the diff
	 @param "sinceId" (string) the since commit hash to stream a diff between two arbitrary hashes
	 @param "srcPath" (string) the previous path to the file, if the file has been copied, moved or renamed
	 @param "untilId" (string) the until commit hash to stream a diff between two arbitrary hashes
	 @param "whitespace" (string) optional whitespace flag which can be set to &lt;code&gt;ignore-all&lt;/code&gt;
	 @param "withComments" (bool) &lt;code&gt;true&lt;/code&gt; to embed comments in the diff (the default); otherwise, &lt;code&gt;false&lt;/code&gt;                      to stream the diff without comments
 @return */
func (a *DefaultApiService) GetPullRequestDiffRaw(projectKey, repositorySlug string, pullRequestID int, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}.diff"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["contextLines"], "int32", "contextLines"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["whitespace"], "string", "whitespace"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["contextLines"].(int32); localVarOk {
		localVarQueryParams.Add("contextLines", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["whitespace"].(string); localVarOk {
		localVarQueryParams.Add("whitespace", parameterToString(localVarTempParam, ""))
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{""}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewRawAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Streams a diff within a pull request.  &lt;p&gt;  If the specified file has been copied, moved or renamed, the &lt;code&gt;srcPath&lt;/code&gt; must also be specified to  produce the correct diff.  &lt;p&gt;  Note: This RESTful endpoint is currently &lt;i&gt;not paged&lt;/i&gt;. The server will internally apply a hard cap to the  streamed lines, and it is not possible to request subsequent pages if that cap is exceeded.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "contextLines" (int32) the number of context lines to include around added/removed lines in the diff
	 @param "diffType" (string) the type of diff being requested. When {@code withComments} is {@code true}                      this works as a hint to the system to attach the correct set of comments to the diff
	 @param "sinceId" (string) the since commit hash to stream a diff between two arbitrary hashes
	 @param "srcPath" (string) the previous path to the file, if the file has been copied, moved or renamed
	 @param "untilId" (string) the until commit hash to stream a diff between two arbitrary hashes
	 @param "whitespace" (string) optional whitespace flag which can be set to &lt;code&gt;ignore-all&lt;/code&gt;
	 @param "withComments" (bool) &lt;code&gt;true&lt;/code&gt; to embed comments in the diff (the default); otherwise, &lt;code&gt;false&lt;/code&gt;                      to stream the diff without comments
 @return */
func (a *DefaultApiService) GetPullRequestDiff(projectKey, repositorySlug string, pullRequestID int, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/diff"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["contextLines"], "int32", "contextLines"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["diffType"], "string", "diffType"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["sinceId"], "string", "sinceId"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["srcPath"], "string", "srcPath"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["untilId"], "string", "untilId"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["whitespace"], "string", "whitespace"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["withComments"], "bool", "withComments"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["contextLines"].(int32); localVarOk {
		localVarQueryParams.Add("contextLines", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["diffType"].(string); localVarOk {
		localVarQueryParams.Add("diffType", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["sinceId"].(string); localVarOk {
		localVarQueryParams.Add("sinceId", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["srcPath"].(string); localVarOk {
		localVarQueryParams.Add("srcPath", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["untilId"].(string); localVarOk {
		localVarQueryParams.Add("untilId", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["whitespace"].(string); localVarOk {
		localVarQueryParams.Add("whitespace", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["withComments"].(bool); localVarOk {
		localVarQueryParams.Add("withComments", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Streams a diff within a pull request.  &lt;p&gt;  If the specified file has been copied, moved or renamed, the &lt;code&gt;srcPath&lt;/code&gt; must also be specified to  produce the correct diff.  &lt;p&gt;  Note: This RESTful endpoint is currently &lt;i&gt;not paged&lt;/i&gt;. The server will internally apply a hard cap to the  streamed lines, and it is not possible to request subsequent pages if that cap is exceeded.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

 @param path the path to the file which should be diffed (optional)
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "contextLines" (int32) the number of context lines to include around added/removed lines in the diff
	 @param "diffType" (string) the type of diff being requested. When {@code withComments} is {@code true}                      this works as a hint to the system to attach the correct set of comments to the diff
	 @param "sinceId" (string) the since commit hash to stream a diff between two arbitrary hashes
	 @param "srcPath" (string) the previous path to the file, if the file has been copied, moved or renamed
	 @param "untilId" (string) the until commit hash to stream a diff between two arbitrary hashes
	 @param "whitespace" (string) optional whitespace flag which can be set to &lt;code&gt;ignore-all&lt;/code&gt;
	 @param "withComments" (bool) &lt;code&gt;true&lt;/code&gt; to embed comments in the diff (the default); otherwise, &lt;code&gt;false&lt;/code&gt;                      to stream the diff without comments
 @return */
func (a *DefaultApiService) StreamDiff_41(projectKey, repositorySlug string, pullRequestID int64, path string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/diff/{path}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", fmt.Sprintf("%v", path), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["contextLines"], "int32", "contextLines"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["diffType"], "string", "diffType"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["sinceId"], "string", "sinceId"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["srcPath"], "string", "srcPath"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["untilId"], "string", "untilId"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["whitespace"], "string", "whitespace"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["withComments"], "bool", "withComments"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["contextLines"].(int32); localVarOk {
		localVarQueryParams.Add("contextLines", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["diffType"].(string); localVarOk {
		localVarQueryParams.Add("diffType", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["sinceId"].(string); localVarOk {
		localVarQueryParams.Add("sinceId", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["srcPath"].(string); localVarOk {
		localVarQueryParams.Add("srcPath", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["untilId"].(string); localVarOk {
		localVarQueryParams.Add("untilId", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["whitespace"].(string); localVarOk {
		localVarQueryParams.Add("whitespace", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["withComments"].(bool); localVarOk {
		localVarQueryParams.Add("withComments", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of files from particular directory of a repository. The search is done recursively, so all files  from any sub-directory of the specified directory will be returned.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "at" (string) the commit ID or ref (e.g. a branch or tag) to list the files at.              If not specified the default branch will be used instead.
 @return */
func (a *DefaultApiService) StreamFiles(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/files"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["at"], "string", "at"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["at"].(string); localVarOk {
		localVarQueryParams.Add("at", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Retrieve a page of files from particular directory of a repository. The search is done recursively, so all files  from any sub-directory of the specified directory will be returned.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param path the directory to list files for.
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "at" (string) the commit ID or ref (e.g. a branch or tag) to list the files at.              If not specified the default branch will be used instead.
 @return */
func (a *DefaultApiService) StreamFiles_42(projectKey, repositorySlug string, path string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/files/{path}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", fmt.Sprintf("%v", path), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["at"], "string", "at"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["limit"], "int", "limit"); err != nil {
		return nil, err
	}
	if err := typeCheckParameter(localVarOptionals["start"], "int", "start"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["limit"].(int); localVarOk {
		localVarQueryParams.Add("limit", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["start"].(int); localVarOk {
		localVarQueryParams.Add("start", parameterToString(localVarTempParam, ""))
	}
	if localVarTempParam, localVarOk := localVarOptionals["at"].(string); localVarOk {
		localVarQueryParams.Add("at", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Streams files in the requested &lt;code&gt;path&lt;/code&gt; with the last commit to modify each file. Commit modifications  are traversed starting from the &lt;code&gt;at&lt;/code&gt; commit or, if not specified, from the tip of the default branch.  &lt;p&gt;  Unless the repository is public, the authenticated user must have &lt;b&gt;REPO_READ&lt;/b&gt; access to call this resource.

 @param path the path within the repository whose files should be streamed
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "at" (string) the commit to use as the starting point when listing files and calculating modifications
 @return */
func (a *DefaultApiService) Stream_43(projectKey, repositorySlug string, path string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/last-modified/{path}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", fmt.Sprintf("%v", path), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["at"], "string", "at"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["at"].(string); localVarOk {
		localVarQueryParams.Add("at", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Test connectivity to a specific endpoint.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "url" (string) the url in which to connect to
 @return */
func (a *DefaultApiService) TestWebhook(projectKey, repositorySlug string, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/test"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["url"], "string", "url"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["url"].(string); localVarOk {
		localVarQueryParams.Add("url", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
 Unassigns a participant from the REVIEWER role they may have been given in a pull request.  &lt;p&gt;  If the participant has no explicit role this method has no effect.  &lt;p&gt;  Afterwards, the user will still remain a participant in the pull request but their role will be reduced to  PARTICIPANT. This is because once made a participant of a pull request,  a user will forever remain a participant. Only their role may be altered.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_WRITE&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.  &lt;p&gt;  &lt;strong&gt;Deprecated since 4.2&lt;/strong&gt;. Use  /rest/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug}  instead.

 @param pullRequestId the id of the pull request within the repository
 @param optional (nil or map[string]interface{}) with one or more of:
	 @param "username" (string) the participant&#39;s user name
 @return */
func (a *DefaultApiService) UnassignParticipantRole(projectKey, repositorySlug string, pullRequestID int64, localVarOptionals map[string]interface{}) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if err := typeCheckParameter(localVarOptionals["username"], "string", "username"); err != nil {
		return nil, err
	}

	if localVarTempParam, localVarOk := localVarOptionals["username"].(string); localVarOk {
		localVarQueryParams.Add("username", parameterToString(localVarTempParam, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* UnassignParticipantRole_44
Unassigns a participant from the REVIEWER role they may have been given in a pull request.  &lt;p&gt;  If the participant has no explicit role this method has no effect.  &lt;p&gt;  Afterwards, the user will still remain a participant in the pull request but their role will be reduced to  PARTICIPANT. This is because once made a participant of a pull request,  a user will forever remain a participant. Only their role may be altered.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_WRITE&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.  &lt;p&gt;  &lt;strong&gt;Deprecated since 4.2&lt;/strong&gt;. Use  /rest/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug}  instead.

 @param pullRequestId the id of the pull request within the repository
 @param userSlug the slug for the user changing their status
 @param pullRequestId2 the id of the pull request within the repository
 @return */
func (a *DefaultApiService) UnassignParticipantRole_44(projectKey, repositorySlug string, pullRequestID int64, userSlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"userSlug"+"}", fmt.Sprintf("%v", userSlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Removes the authenticated user as a watcher for the specified commit.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository containing the commit  to call this resource.

@param commitId the &lt;i&gt;full {@link Commit#getId() ID}&lt;/i&gt; of the commit within the repository
@return */
func (a *DefaultApiService) Unwatch(projectKey, repositorySlug string, commitId string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/watch"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Make the authenticated user stop watching the specified pull request.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

@param pullRequestId the id of the pull request within the repository
@return */
func (a *DefaultApiService) Unwatch_45(projectKey, repositorySlug string, pullRequestID int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/watch"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Decodes the provided encoded license and sets it as the active license. If no license was provided, a 400 is  returned. If the license cannot be decoded, or cannot be applied, a 409 is returned. Some possible reasons a  license may not be applied include:  &lt;ul&gt;      &lt;li&gt;It is for a different product&lt;/li&gt;      &lt;li&gt;It is already expired&lt;/li&gt;  &lt;/ul&gt;  Otherwise, if the license is updated successfully, details for the new license are returned with a 200 response.  &lt;p&gt;  &lt;b&gt;Warning&lt;/b&gt;: It is possible to downgrade the license during update, applying a license with a lower number  of permitted users. If the number of currently-licensed users exceeds the limits of the new license, pushing  will be disabled until the licensed user count is brought into compliance with the new license.  &lt;p&gt;  The authenticated user must have &lt;b&gt;SYS_ADMIN&lt;/b&gt; permission. &lt;b&gt;ADMIN&lt;/b&gt; users may &lt;i&gt;view&lt;/i&gt; the current  license details, but they may not &lt;i&gt;update&lt;/i&gt; the license.

@return */
func (a *DefaultApiService) Update() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/license"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the text of a comment. Only the user who created a comment may update it.  &lt;p&gt;  &lt;strong&gt;Note:&lt;/strong&gt; the supplied supplied JSON object must contain a &lt;code&gt;version&lt;/code&gt; that must match  the server&#39;s version of the comment or the update will fail. To determine the current version of the comment,  the comment should be fetched from the server prior to the update. Look for the &#39;version&#39; attribute in the  returned JSON structure.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that the commit  is in to call this resource.

@param commitId the commit to which the comments must be anchored
@param commentId the ID of the comment to retrieve
@param commitId2 the &lt;i&gt;full {@link Commit#getId() ID}&lt;/i&gt; of the commit within the repository
@return */
func (a *DefaultApiService) UpdateComment(projectKey, repositorySlug string, commitId string, commentId int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commentId"+"}", fmt.Sprintf("%v", commentId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the text of a comment. Only the user who created a comment may update it.  &lt;p&gt;  &lt;strong&gt;Note:&lt;/strong&gt; the supplied supplied JSON object must contain a &lt;code&gt;version&lt;/code&gt; that must match the  server&#39;s version of the comment or the update will fail. To determine the current version of  the comment, the comment should be fetched from the server prior to the update. Look for the  &#39;version&#39; attribute in the returned JSON structure.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

@param commentId the id of the comment to retrieve
@return */
func (a *DefaultApiService) UpdateComment_46(projectKey, repositorySlug string, pullRequestID, commentId int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commentId"+"}", fmt.Sprintf("%v", commentId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the project matching the &lt;strong&gt;projectKey&lt;/strong&gt; supplied in the resource path.  &lt;p&gt;  To include a custom avatar for the updated project, the project definition should contain an additional attribute  with the key &lt;code&gt;avatar&lt;/code&gt; and the value a data URI containing Base64-encoded image data. The URI should be  in the following format:  &lt;code&gt;      data:(content type, e.g. image/png);base64,(data)  &lt;/code&gt;  If the data is not Base64-encoded, or if a character set is defined in the URI, or the URI is otherwise invalid,  &lt;em&gt;project creation will fail&lt;/em&gt;.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project to call this  resource.

@return */
func (a *DefaultApiService) UpdateProject(projectKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the pull request settings for the context repository.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the context repository to call this  resource.  &lt;p&gt;  This resource will call all RestFragments that are registered with the key  &lt;strong&gt;bitbucket.repository.settings.pullRequests&lt;/strong&gt;. If any fragment fails validations by returning a  non-empty Map of errors, then no fragments will execute.  &lt;p&gt;  Only the settings that should be updated need to be included in the request.  &lt;p&gt;  The property keys for the settings that are bundled with the application are  &lt;ul&gt;      &lt;li&gt;mergeConfig - the merge strategy configuration for pull requests&lt;/li&gt;      &lt;li&gt;requiredApprovers - (Deprecated, please use com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook instead) the number of approvals required on a pull request for it to be mergeable, or 0 to disable the merge check&lt;/li&gt;      &lt;li&gt;com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook - a json map containing the keys &#39;enabled&#39; (a boolean to enable or disable this merge check) and &#39;count&#39; (an integer to set the number of required approvals)&lt;/li&gt;      &lt;li&gt;requiredAllApprovers - whether or not all approvers must approve a pull request for it to be mergeable&lt;/li&gt;      &lt;li&gt;requiredAllTasksComplete - whether or not all tasks on a pull request need to be completed for it to be mergeable&lt;/li&gt;      &lt;li&gt;requiredSuccessfulBuilds - (Deprecated, please use com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck instead) the number of successful s on a pull request for it to be mergeable, or 0 to disable the merge check&lt;/li&gt;      &lt;li&gt;com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck - a json map containing the keys &#39;enabled&#39; (a boolean to enable or disable this merge check) and &#39;count&#39; (an integer to set the number of required builds)&lt;/li&gt;  &lt;/ul&gt;  &lt;strong&gt;Merge strategy configuration deletion:&lt;/strong&gt;  &lt;p&gt;  An explicitly set pull request merge strategy configuration can be deleted by POSTing a document with an empty  \&quot;mergeConfig\&quot; attribute. i.e:  &lt;pre&gt;  {      \&quot;mergeConfig\&quot;: {      }  }  &lt;/pre&gt;  Upon completion of this request, the effective configuration will be:  &lt;ul&gt;      &lt;li&gt;The configuration set for this repository&#39;s SCM type as set at the project level, if present, otherwise&lt;/li&gt;      &lt;li&gt;the configuration set for this repository&#39;s SCM type as set at the instance level, if present, otherwise&lt;/li&gt;      &lt;li&gt;the default configuration for this repository&#39;s SCM type&lt;/li&gt;  &lt;ul&gt;

@return */
func (a *DefaultApiService) UpdatePullRequestSettings(projectKey, repositorySlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/pull-requests"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the pull request merge strategy configuration for this project and SCM.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the context repository to call this  resource.  &lt;p&gt;  Only the strategies provided will be enabled, the default must be set and included in the set of strategies.  &lt;p&gt;  An explicitly set pull request merge strategy configuration can be deleted by POSTing a document with  an empty \&quot;mergeConfig\&quot; attribute. i.e:  &lt;pre&gt;  {      \&quot;mergeConfig\&quot;: {      }  }  &lt;/pre&gt;  Upon completion of this request, the effective configuration will be the configuration explicitly set for  the SCM, or if no such explicit configuration is set then the default configuration will be used.

@param scmId the SCM to get strategies for
@return */
func (a *DefaultApiService) UpdatePullRequestSettings_47(projectKey, repositorySlug string, scmId string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/settings/pull-requests/{scmId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"scmId"+"}", fmt.Sprintf("%v", scmId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the repository matching the &lt;strong&gt;repositorySlug&lt;/strong&gt; supplied in the resource path.  &lt;p&gt;  The repository&#39;s slug is derived from its name. If the name changes the slug may also change.  &lt;p&gt;  This API can be used to move the repository to a different project by setting the new project in the request,  example: {@code {\&quot;project\&quot;:{\&quot;key\&quot;:\&quot;NEW_KEY\&quot;}}} .  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

@param projectKey the parent project key
@param projectKey2 the parent project key
@param repositorySlug the repository slug
@return */
func (a *DefaultApiService) UpdateRepository(projectKey, repositorySlug string) (*APIResponse, error) {
	return a.UpdateRepositoryWithOptions(projectKey, repositorySlug, nil, []string{})
}

func (a *DefaultApiService) UpdateRepositoryWithOptions(projectKey, repositorySlug string, localVarPostBody interface{}, localVarHTTPContentTypes []string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the entries of a map of user setting key/values for a specific user identified by the user slug.  &lt;p&gt;

@return */
func (a *DefaultApiService) UpdateSettings(userSlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/users/{userSlug}/settings"
	localVarPath = strings.Replace(localVarPath, "{"+"userSlug"+"}", fmt.Sprintf("%v", userSlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Change the current user&#39;s status for a pull request. Implicitly adds the user as a participant if they are not  already. If the current user is the author, this method will fail.  &lt;p&gt;  The possible values for {@code status} are &lt;strong&gt;UNAPPROVED&lt;/strong&gt;, &lt;strong&gt;NEEDS_WORK&lt;/strong&gt;, or  &lt;strong&gt;APPROVED&lt;/strong&gt;.  &lt;p&gt;  If the new {@code status} is &lt;strong&gt;NEEDS_WORK&lt;/strong&gt; or &lt;strong&gt;APPROVED&lt;/strong&gt; then the  {@code lastReviewedCommit} for the participant will be updated to the latest commit of the source branch of the  pull request.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

@param pullRequestId the id of the pull request within the repository
@param userSlug the slug for the user changing their status
@param pullRequestId2 the id of the pull request within the repository
@return */
func (a *DefaultApiService) UpdateStatus(projectKey, repositorySlug string, pullRequestID int64, userSlug string, participant UserWithMetadata) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	localVarPostBody, err := json.Marshal(participant)
	if err != nil {
		return nil, err
	}

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"userSlug"+"}", fmt.Sprintf("%v", userSlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update a existing task.  &lt;p&gt;  As of Stash 3.3, only the state and text of a task can be updated.  &lt;p&gt;  Updating the state of a task is allowed for any user having &lt;em&gt;READ&lt;/em&gt; access to the repository.  However only the task&#39;s creator, the context&#39;s author or an admin of the context&#39;s repository can update the  task&#39;s text. (For a pull request task, those are the task&#39;s creator, the pull request&#39;s author or an admin on the  repository containing the pull request). Additionally the task&#39;s text cannot be updated if it has been resolved.

@param taskId the id identifying the task to delete
@return */
func (a *DefaultApiService) UpdateTask(taskId int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/tasks/{taskId}"
	localVarPath = strings.Replace(localVarPath, "{"+"taskId"+"}", fmt.Sprintf("%v", taskId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update a user&#39;s details.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource.

@return */
func (a *DefaultApiService) UpdateUserDetails() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/users"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the currently authenticated user&#39;s details. The update will always be applied to the currently  authenticated user.

@return */
func (a *DefaultApiService) UpdateUserDetails_48() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/users"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update a user&#39;s password.  &lt;p&gt;  The authenticated user must have the &lt;strong&gt;ADMIN&lt;/strong&gt; permission to call this resource, and may not update  the password of a user with greater permissions than themselves.

@return */
func (a *DefaultApiService) UpdateUserPassword() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/admin/users/credentials"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the currently authenticated user&#39;s password.

@return */
func (a *DefaultApiService) UpdateUserPassword_49() (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/users/credentials"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update an existing webhook.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_ADMIN&lt;/strong&gt; permission for the specified repository to call this  resource.

@param webhookId the existing webhook id
@return */
func (a *DefaultApiService) UpdateWebhook(projectKey, repositorySlug string, webhookId int32, localVarPostBody interface{}, localVarHTTPContentTypes []string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"webhookId"+"}", fmt.Sprintf("%v", webhookId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the title, description, reviewers or destination branch of an existing pull request.  &lt;p&gt;  &lt;strong&gt;Note:&lt;/strong&gt; the &lt;em&gt;reviewers&lt;/em&gt; list may be updated using this resource. However the  &lt;em&gt;author&lt;/em&gt; and &lt;em&gt;participants&lt;/em&gt; list may not.  &lt;p&gt;  The authenticated user must either:  &lt;ul&gt;      &lt;li&gt;be the author of the pull request and have the &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository      that this pull request targets; or&lt;/li&gt;      &lt;li&gt;have the &lt;strong&gt;REPO_WRITE&lt;/strong&gt; permission for the repository that this pull request targets&lt;/li&gt;  &lt;/ul&gt;  to call this resource.

@param pullRequestId the ID of the pull request within the repository
@return */
func (a *DefaultApiService) Update_50(projectKey, repositorySlug string, pullRequestID int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Put")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the avatar for the project matching the supplied &lt;strong&gt;projectKey&lt;/strong&gt;.  &lt;p&gt;  This resource accepts POST multipart form data, containing a single image in a form-field named &#39;avatar&#39;.  &lt;p&gt;  There are configurable server limits on both the dimensions (1024x1024 pixels by default) and uploaded file size  (1MB by default). Several different image formats are supported, but &lt;strong&gt;PNG&lt;/strong&gt; and  &lt;strong&gt;JPEG&lt;/strong&gt; are preferred due to the file size limit.  &lt;p&gt;  This resource has Cross-Site Request Forgery (XSRF) protection. To allow the request to  pass the XSRF check the caller needs to send an &lt;code&gt;X-Atlassian-Token&lt;/code&gt; HTTP header with the  value &lt;code&gt;no-check&lt;/code&gt;.  &lt;p&gt;  An example &lt;a href&#x3D;\&quot;http://curl.haxx.se/\&quot;&gt;curl&lt;/a&gt; request to upload an image name &#39;avatar.png&#39; would be:  &lt;pre&gt;  curl -X POST -u username:password -H \&quot;X-Atlassian-Token: no-check\&quot; http://example.com/rest/api/1.0/projects/STASH/avatar.png -F avatar&#x3D;@avatar.png  &lt;/pre&gt;  &lt;p&gt;  The authenticated user must have &lt;strong&gt;PROJECT_ADMIN&lt;/strong&gt; permission for the specified project to call this  resource.

@return */
func (a *DefaultApiService) UploadAvatar(projectKey string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/avatar.png"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Update the avatar for the user with the supplied &lt;strong&gt;slug&lt;/strong&gt;.  &lt;p&gt;  This resource accepts POST multipart form data, containing a single image in a form-field named &#39;avatar&#39;.  &lt;p&gt;  There are configurable server limits on both the dimensions (1024x1024 pixels by default) and uploaded  file size (1MB by default). Several different image formats are supported, but &lt;strong&gt;PNG&lt;/strong&gt; and  &lt;strong&gt;JPEG&lt;/strong&gt; are preferred due to the file size limit.  &lt;p&gt;  This resource has Cross-Site Request Forgery (XSRF) protection. To allow the request to  pass the XSRF check the caller needs to send an &lt;code&gt;X-Atlassian-Token&lt;/code&gt; HTTP header with the  value &lt;code&gt;no-check&lt;/code&gt;.  &lt;p&gt;  An example &lt;a href&#x3D;\&quot;http://curl.haxx.se/\&quot;&gt;curl&lt;/a&gt; request to upload an image name &#39;avatar.png&#39; would be:  &lt;pre&gt;  curl -X POST -u username:password -H \&quot;X-Atlassian-Token: no-check\&quot; http://example.com/rest/api/latest/users/jdoe/avatar.png -F avatar&#x3D;@avatar.png  &lt;/pre&gt;  &lt;p&gt;  Users are always allowed to update their own avatar. To update someone else&#39;s avatar the authenticated user must  have global &lt;strong&gt;ADMIN&lt;/strong&gt; permission, or global &lt;strong&gt;SYS_ADMIN&lt;/strong&gt; permission to update a  &lt;strong&gt;SYS_ADMIN&lt;/strong&gt; user&#39;s avatar.

@return */
func (a *DefaultApiService) UploadAvatar_51(userSlug string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/users/{userSlug}/avatar.png"
	localVarPath = strings.Replace(localVarPath, "{"+"userSlug"+"}", fmt.Sprintf("%v", userSlug), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Adds the authenticated user as a watcher for the specified commit.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository containing the commit  to call this resource.

@param commitId the &lt;i&gt;full {@link Commit#getId() ID}&lt;/i&gt; of the commit within the repository
@return */
func (a *DefaultApiService) Watch(projectKey, repositorySlug string, commitId string) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/watch"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Make the authenticated user watch the specified pull request.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.

@param pullRequestId the id of the pull request within the repository
@return */
func (a *DefaultApiService) Watch_52(projectKey, repositorySlug string, pullRequestID int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/watch"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/* DefaultApiService
Remove approval from a pull request as the current user. This does not remove the user as a participant.  &lt;p&gt;  The authenticated user must have &lt;strong&gt;REPO_READ&lt;/strong&gt; permission for the repository that this pull request  targets to call this resource.  &lt;p&gt;  &lt;strong&gt;Deprecated since 4.2&lt;/strong&gt;. Use  /rest/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug} instead

@param pullRequestId the id of the pull request within the repository
@return */
func (a *DefaultApiService) WithdrawApproval(projectKey, repositorySlug string, pullRequestID int64) (*APIResponse, error) {
	var (
		localVarHTTPMethod = strings.ToUpper("Delete")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/approve"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", fmt.Sprintf("%v", projectKey), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", fmt.Sprintf("%v", repositorySlug), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"pullRequestId"+"}", fmt.Sprintf("%v", pullRequestID), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/*
DefaultApiService
Gets statistics regarding the builds associated with a commit.
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param commitId the commit Id


*/
func (a *DefaultApiService) GetCommitStats(commitId string) (*APIResponse, error) {
	var (
		localVarHttpMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/build-status/1.0/commits/stats/{commitId}"
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHttpContentTypes := []string{}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/*
DefaultApiService
Gets the build statuses associated with a commit.
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param commitId the commit Id


*/
func (a *DefaultApiService) GetCommitStatus(commitId string) (*APIResponse, error) {
	var (
		localVarHttpMethod = strings.ToUpper("Get")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/build-status/1.0/commits/{commitId}"
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHttpContentTypes := []string{}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/*
DefaultApiService
Produces a list of the build statistics for multiple commits. Commits without any builds associated with them will not be returned.  For example if the commit e00cf62997a027bbf785614a93e2e55bb331d268 does not have any build statuses associated with it, it will not be present in the response.
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param commits Array of commits.


*/
func (a *DefaultApiService) GetCommitsStats(commits []string) (*APIResponse, error) {
	var (
		localVarHttpMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/build-status/1.0/commits/stats"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHttpContentTypes := []string{}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	// body params
	localVarPostBody = &commits
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}

/*
DefaultApiService
Associates a build status with a commit. The state, the key and the url are mandatory. The name and description fields are optional. All fields (mandatory or optional) are limited to 255 characters, except for the url, which is limited to 450 characters. Supported values for the state are SUCCESSFUL, FAILED and INPROGRESS. The authenticated user must have LICENSED permission or higher to call this resource.
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param commitId the commit Id
 * @param buildStatus Array of commits.


*/
func (a *DefaultApiService) SetCommitStatus(commitId string, buildStatus BuildStatus) (*APIResponse, error) {
	var (
		localVarHttpMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/build-status/1.0/commits/{commitId}"
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", fmt.Sprintf("%v", commitId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHttpContentTypes := []string{}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	// body params
	localVarPostBody = &buildStatus
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewAPIResponse(localVarHTTPResponse), nil
}

/*
SearchCode

 * @param searchString Search string

*/
func (a *DefaultApiService) SearchCode(query SearchQuery) (*APIResponse, error) {
	var (
		localVarHttpMethod = strings.ToUpper("Post")
		localVarPostBody   interface{}
		localVarFileName   string
		localVarFileBytes  []byte
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/search/latest/search"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHttpContentTypes := []string{}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}

	// body params
	localVarPostBody = &query
	r, err := a.client.prepareRequest(a.client.ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(r)
	if err != nil || localVarHTTPResponse == nil {
		return NewAPIResponseWithError(localVarHTTPResponse, nil, err)
	}
	defer localVarHTTPResponse.Body.Close()
	if localVarHTTPResponse.StatusCode >= 300 {
		bodyBytes, _ := ioutil.ReadAll(localVarHTTPResponse.Body)
		return NewAPIResponseWithError(localVarHTTPResponse, bodyBytes, reportError("Status: %v, Body: %s", localVarHTTPResponse.Status, bodyBytes))
	}

	return NewBitbucketAPIResponse(localVarHTTPResponse)
}
