/*
Copyright the Velero contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/vmware-tanzu/velero/pkg/apis/velero/v1"
	scheme "github.com/vmware-tanzu/velero/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// PodVolumeBackupsGetter has a method to return a PodVolumeBackupInterface.
// A group's client should implement this interface.
type PodVolumeBackupsGetter interface {
	PodVolumeBackups(namespace string) PodVolumeBackupInterface
}

// PodVolumeBackupInterface has methods to work with PodVolumeBackup resources.
type PodVolumeBackupInterface interface {
	Create(ctx context.Context, podVolumeBackup *v1.PodVolumeBackup, opts metav1.CreateOptions) (*v1.PodVolumeBackup, error)
	Update(ctx context.Context, podVolumeBackup *v1.PodVolumeBackup, opts metav1.UpdateOptions) (*v1.PodVolumeBackup, error)
	UpdateStatus(ctx context.Context, podVolumeBackup *v1.PodVolumeBackup, opts metav1.UpdateOptions) (*v1.PodVolumeBackup, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.PodVolumeBackup, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.PodVolumeBackupList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.PodVolumeBackup, err error)
	PodVolumeBackupExpansion
}

// podVolumeBackups implements PodVolumeBackupInterface
type podVolumeBackups struct {
	client rest.Interface
	ns     string
}

// newPodVolumeBackups returns a PodVolumeBackups
func newPodVolumeBackups(c *VeleroV1Client, namespace string) *podVolumeBackups {
	return &podVolumeBackups{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the podVolumeBackup, and returns the corresponding podVolumeBackup object, and an error if there is any.
func (c *podVolumeBackups) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.PodVolumeBackup, err error) {
	result = &v1.PodVolumeBackup{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("podvolumebackups").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of PodVolumeBackups that match those selectors.
func (c *podVolumeBackups) List(ctx context.Context, opts metav1.ListOptions) (result *v1.PodVolumeBackupList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.PodVolumeBackupList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("podvolumebackups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested podVolumeBackups.
func (c *podVolumeBackups) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("podvolumebackups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a podVolumeBackup and creates it.  Returns the server's representation of the podVolumeBackup, and an error, if there is any.
func (c *podVolumeBackups) Create(ctx context.Context, podVolumeBackup *v1.PodVolumeBackup, opts metav1.CreateOptions) (result *v1.PodVolumeBackup, err error) {
	result = &v1.PodVolumeBackup{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("podvolumebackups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podVolumeBackup).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a podVolumeBackup and updates it. Returns the server's representation of the podVolumeBackup, and an error, if there is any.
func (c *podVolumeBackups) Update(ctx context.Context, podVolumeBackup *v1.PodVolumeBackup, opts metav1.UpdateOptions) (result *v1.PodVolumeBackup, err error) {
	result = &v1.PodVolumeBackup{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("podvolumebackups").
		Name(podVolumeBackup.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podVolumeBackup).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *podVolumeBackups) UpdateStatus(ctx context.Context, podVolumeBackup *v1.PodVolumeBackup, opts metav1.UpdateOptions) (result *v1.PodVolumeBackup, err error) {
	result = &v1.PodVolumeBackup{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("podvolumebackups").
		Name(podVolumeBackup.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podVolumeBackup).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the podVolumeBackup and deletes it. Returns an error if one occurs.
func (c *podVolumeBackups) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("podvolumebackups").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *podVolumeBackups) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("podvolumebackups").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched podVolumeBackup.
func (c *podVolumeBackups) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.PodVolumeBackup, err error) {
	result = &v1.PodVolumeBackup{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("podvolumebackups").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
