export var mergeFiles: MergeFilesFn;
/**
 * Describes a single file match which will be processed
 */
export type MatchInfo = {
    /**
     * Path to the file
     */
    filePath: string;
};
export type MergeFilesCallback = (matchInfo: MatchInfo) => void;
export type MergeFilesOptions = {
    /**
     * A callback function which will be called for the each match
     */
    onFileMatched?: MergeFilesCallback;
};
export type TMergeFilesCompletionCallback = (err?: Error) => void;
/**
 * Reads multiple files, merges their contents and write into the given file.
 */
export type MergeFilesCallbackStyle = (destFilePath: string, srcFilePathsOrGlobPatterns: string[], options: MergeFilesOptions, cb: TMergeFilesCompletionCallback) => void;
/**
 * Reads multiple files, merges their contents and write into the given file.
 */
export type MergeFilesPromiseStyle = (destFilePath: string, srcFilePathsOrGlobPatterns: string[], options?: MergeFilesOptions) => Promise<void>;
export type MergeFilesFn = MergeFilesCallbackStyle & MergeFilesPromiseStyle;
