import { ClusterClient } from './client';
import { ResponseType } from 'axios';
import { TokenExpiryHandler } from './resources/common';
export declare class ClientFactoryUnknownClusterError extends Error {
    constructor(clusterName: string);
}
export declare class ClientFactoryMissingUserError extends Error {
    constructor();
}
export declare class ClientFactoryMissingApiRoot extends Error {
    constructor();
}
interface IUser {
    access_token: string;
    expiry_time: number;
}
export declare const ClientFactory: {
    cluster: (user: IUser, clusterApi: string, customResponseType?: ResponseType) => ClusterClient;
};
export declare const setTokenExpiryHandler: (newExpiryHandler: TokenExpiryHandler) => void;
export {};
