'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var reactCore = require('@patternfly/react-core');
var reactTokens = require('@patternfly/react-tokens');

function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
        Object.keys(e).forEach(function (k) {
            if (k !== 'default') {
                var d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: function () {
                        return e[k];
                    }
                });
            }
        });
    }
    n['default'] = e;
    return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespace(React);

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

function __spreadArray(to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
}

var IconSize;
(function (IconSize) {
    IconSize["sm"] = "sm";
    IconSize["md"] = "md";
    IconSize["lg"] = "lg";
    IconSize["xl"] = "xl";
})(IconSize || (IconSize = {}));
const getSize = (size) => {
    switch (size) {
        case IconSize.sm:
            return '1em';
        case IconSize.md:
            return '1.5em';
        case IconSize.lg:
            return '2em';
        case IconSize.xl:
            return '3em';
        default:
            return '1em';
    }
};
let currentId = 0;
/**
 * Factory to create Icon class components for consumers
 */
function createIcon({ name, xOffset = 0, yOffset = 0, width, height, svgPath }) {
    var _a;
    return _a = class SVGIcon extends React__namespace.Component {
            constructor() {
                super(...arguments);
                this.id = `icon-title-${currentId++}`;
            }
            render() {
                const _a = this.props, { size, color, title, noVerticalAlign } = _a, props = __rest(_a, ["size", "color", "title", "noVerticalAlign"]);
                const hasTitle = Boolean(title);
                const heightWidth = getSize(size);
                const baseAlign = -0.125 * Number.parseFloat(heightWidth);
                const style = noVerticalAlign ? null : { verticalAlign: `${baseAlign}em` };
                const viewBox = [xOffset, yOffset, width, height].join(' ');
                return (React__namespace.createElement("svg", Object.assign({ style: style, fill: color, height: heightWidth, width: heightWidth, viewBox: viewBox, "aria-labelledby": hasTitle ? this.id : null, "aria-hidden": hasTitle ? null : true, role: "img" }, props),
                    hasTitle && React__namespace.createElement("title", { id: this.id }, title),
                    React__namespace.createElement("path", { d: svgPath })));
            }
        },
        _a.displayName = name,
        _a.defaultProps = {
            color: 'currentColor',
            size: IconSize.sm,
            noVerticalAlign: false
        },
        _a;
}

const CheckCircleIconConfig = {
  name: 'CheckCircleIcon',
  height: 512,
  width: 512,
  svgPath: 'M504 256c0 136.967-111.033 248-248 248S8 392.967 8 256 119.033 8 256 8s248 111.033 248 248zM227.314 387.314l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.249-16.379-6.249-22.628 0L216 308.118l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.249 16.379 6.249 22.628.001z',
  yOffset: 0,
  xOffset: 0,
};

const CheckCircleIcon = createIcon(CheckCircleIconConfig);

const ExclamationCircleIconConfig = {
  name: 'ExclamationCircleIcon',
  height: 512,
  width: 512,
  svgPath: 'M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zm-248 50c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z',
  yOffset: 0,
  xOffset: 0,
};

const ExclamationCircleIcon = createIcon(ExclamationCircleIconConfig);

const ExclamationTriangleIconConfig = {
  name: 'ExclamationTriangleIcon',
  height: 512,
  width: 576,
  svgPath: 'M569.517 440.013C587.975 472.007 564.806 512 527.94 512H48.054c-36.937 0-59.999-40.055-41.577-71.987L246.423 23.985c18.467-32.009 64.72-31.951 83.154 0l239.94 416.028zM288 354c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z',
  yOffset: 0,
  xOffset: 0,
};

const ExclamationTriangleIcon = createIcon(ExclamationTriangleIconConfig);

const InfoCircleIconConfig = {
  name: 'InfoCircleIcon',
  height: 512,
  width: 512,
  svgPath: 'M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z',
  yOffset: 0,
  xOffset: 0,
};

const InfoCircleIcon = createIcon(InfoCircleIconConfig);

const PauseCircleIconConfig = {
  name: 'PauseCircleIcon',
  height: 512,
  width: 512,
  svgPath: 'M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm-16 328c0 8.8-7.2 16-16 16h-48c-8.8 0-16-7.2-16-16V176c0-8.8 7.2-16 16-16h48c8.8 0 16 7.2 16 16v160zm112 0c0 8.8-7.2 16-16 16h-48c-8.8 0-16-7.2-16-16V176c0-8.8 7.2-16 16-16h48c8.8 0 16 7.2 16 16v160z',
  yOffset: 0,
  xOffset: 0,
};

const PauseCircleIcon = createIcon(PauseCircleIconConfig);

const QuestionCircleIconConfig = {
  name: 'QuestionCircleIcon',
  height: 512,
  width: 512,
  svgPath: 'M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zM262.655 90c-54.497 0-89.255 22.957-116.549 63.758-3.536 5.286-2.353 12.415 2.715 16.258l34.699 26.31c5.205 3.947 12.621 3.008 16.665-2.122 17.864-22.658 30.113-35.797 57.303-35.797 20.429 0 45.698 13.148 45.698 32.958 0 14.976-12.363 22.667-32.534 33.976C247.128 238.528 216 254.941 216 296v4c0 6.627 5.373 12 12 12h56c6.627 0 12-5.373 12-12v-1.333c0-28.462 83.186-29.647 83.186-106.667 0-58.002-60.165-102-116.531-102zM256 338c-25.365 0-46 20.635-46 46 0 25.364 20.635 46 46 46s46-20.636 46-46c0-25.365-20.635-46-46-46z',
  yOffset: 0,
  xOffset: 0,
};

const QuestionCircleIcon = createIcon(QuestionCircleIconConfig);

function styleInject(css, ref) {
  if ( ref === void 0 ) ref = {};
  var insertAt = ref.insertAt;

  if (!css || typeof document === 'undefined') { return; }

  var head = document.head || document.getElementsByTagName('head')[0];
  var style = document.createElement('style');
  style.type = 'text/css';

  if (insertAt === 'top') {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }

  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}

var css_248z = "span.pf-c-spinner.status-icon-loading-spinner {\n  --pf-c-spinner--diameter: 1em;\n}\n";
styleInject(css_248z);

var iconList = {
    Ok: {
        Icon: CheckCircleIcon,
        color: reactTokens.global_success_color_100,
    },
    Warning: {
        Icon: ExclamationTriangleIcon,
        color: reactTokens.global_warning_color_100,
    },
    Error: {
        Icon: ExclamationCircleIcon,
        color: reactTokens.global_danger_color_100,
    },
    Info: {
        Icon: InfoCircleIcon,
        color: reactTokens.global_info_color_100,
    },
    Loading: {
        Icon: reactCore.Spinner,
        color: reactTokens.global_info_color_200,
    },
    Paused: {
        Icon: PauseCircleIcon,
    },
    Unknown: {
        Icon: QuestionCircleIcon,
        color: reactTokens.global_Color_dark_200,
    },
};
var StatusIcon = function (_a) {
    var _b;
    var status = _a.status, label = _a.label, _c = _a.isDisabled, isDisabled = _c === void 0 ? false : _c, _d = _a.className, className = _d === void 0 ? '' : _d;
    var Icon = iconList[status].Icon;
    var icon = (React__namespace.createElement(Icon, { color: isDisabled ? reactTokens.global_disabled_color_200.value : ((_b = iconList[status].color) === null || _b === void 0 ? void 0 : _b.value) || '#151515', className: status === 'Loading' ? className + " status-icon-loading-spinner" : className }));
    if (label) {
        return (React__namespace.createElement(reactCore.Flex, { spaceItems: { default: 'spaceItemsSm' }, alignItems: { default: 'alignItemsCenter' }, flexWrap: { default: 'nowrap' }, style: { whiteSpace: 'nowrap' }, className: className },
            React__namespace.createElement(reactCore.FlexItem, null, icon),
            React__namespace.createElement(reactCore.FlexItem, null, label)));
    }
    return icon;
};

// ES6 Map
var map;
try {
  map = Map;
} catch (_) { }
var set;

// ES6 Set
try {
  set = Set;
} catch (_) { }

function baseClone (src, circulars, clones) {
  // Null/undefined/functions/etc
  if (!src || typeof src !== 'object' || typeof src === 'function') {
    return src
  }

  // DOM Node
  if (src.nodeType && 'cloneNode' in src) {
    return src.cloneNode(true)
  }

  // Date
  if (src instanceof Date) {
    return new Date(src.getTime())
  }

  // RegExp
  if (src instanceof RegExp) {
    return new RegExp(src)
  }

  // Arrays
  if (Array.isArray(src)) {
    return src.map(clone)
  }

  // ES6 Maps
  if (map && src instanceof map) {
    return new Map(Array.from(src.entries()))
  }

  // ES6 Sets
  if (set && src instanceof set) {
    return new Set(Array.from(src.values()))
  }

  // Object
  if (src instanceof Object) {
    circulars.push(src);
    var obj = Object.create(src);
    clones.push(obj);
    for (var key in src) {
      var idx = circulars.findIndex(function (i) {
        return i === src[key]
      });
      obj[key] = idx > -1 ? clones[idx] : baseClone(src[key], circulars, clones);
    }
    return obj
  }

  // ???
  return src
}

function clone (src) {
  return baseClone(src, [], [])
}

const toString$1 = Object.prototype.toString;
const errorToString = Error.prototype.toString;
const regExpToString = RegExp.prototype.toString;
const symbolToString$1 = typeof Symbol !== 'undefined' ? Symbol.prototype.toString : () => '';
const SYMBOL_REGEXP = /^Symbol\((.*)\)(.*)$/;

function printNumber(val) {
  if (val != +val) return 'NaN';
  const isNegativeZero = val === 0 && 1 / val < 0;
  return isNegativeZero ? '-0' : '' + val;
}

function printSimpleValue(val, quoteStrings = false) {
  if (val == null || val === true || val === false) return '' + val;
  const typeOf = typeof val;
  if (typeOf === 'number') return printNumber(val);
  if (typeOf === 'string') return quoteStrings ? `"${val}"` : val;
  if (typeOf === 'function') return '[Function ' + (val.name || 'anonymous') + ']';
  if (typeOf === 'symbol') return symbolToString$1.call(val).replace(SYMBOL_REGEXP, 'Symbol($1)');
  const tag = toString$1.call(val).slice(8, -1);
  if (tag === 'Date') return isNaN(val.getTime()) ? '' + val : val.toISOString(val);
  if (tag === 'Error' || val instanceof Error) return '[' + errorToString.call(val) + ']';
  if (tag === 'RegExp') return regExpToString.call(val);
  return null;
}

function printValue(value, quoteStrings) {
  let result = printSimpleValue(value, quoteStrings);
  if (result !== null) return result;
  return JSON.stringify(value, function (key, value) {
    let result = printSimpleValue(this[key], quoteStrings);
    if (result !== null) return result;
    return value;
  }, 2);
}

let mixed = {
  default: '${path} is invalid',
  required: '${path} is a required field',
  oneOf: '${path} must be one of the following values: ${values}',
  notOneOf: '${path} must not be one of the following values: ${values}',
  notType: ({
    path,
    type,
    value,
    originalValue
  }) => {
    let isCast = originalValue != null && originalValue !== value;
    let msg = `${path} must be a \`${type}\` type, ` + `but the final value was: \`${printValue(value, true)}\`` + (isCast ? ` (cast from the value \`${printValue(originalValue, true)}\`).` : '.');

    if (value === null) {
      msg += `\n If "null" is intended as an empty value be sure to mark the schema as \`.nullable()\``;
    }

    return msg;
  },
  defined: '${path} must be defined'
};
let string = {
  length: '${path} must be exactly ${length} characters',
  min: '${path} must be at least ${min} characters',
  max: '${path} must be at most ${max} characters',
  matches: '${path} must match the following: "${regex}"',
  email: '${path} must be a valid email',
  url: '${path} must be a valid URL',
  uuid: '${path} must be a valid UUID',
  trim: '${path} must be a trimmed string',
  lowercase: '${path} must be a lowercase string',
  uppercase: '${path} must be a upper case string'
};
let number = {
  min: '${path} must be greater than or equal to ${min}',
  max: '${path} must be less than or equal to ${max}',
  lessThan: '${path} must be less than ${less}',
  moreThan: '${path} must be greater than ${more}',
  positive: '${path} must be a positive number',
  negative: '${path} must be a negative number',
  integer: '${path} must be an integer'
};
let date = {
  min: '${path} field must be later than ${min}',
  max: '${path} field must be at earlier than ${max}'
};
let boolean = {
  isValue: '${path} field must be ${value}'
};
let object = {
  noUnknown: '${path} field has unspecified keys: ${unknown}'
};
let array$1 = {
  min: '${path} field must have at least ${min} items',
  max: '${path} field must have less than or equal to ${max} items',
  length: '${path} must be have ${length} items'
};
Object.assign(Object.create(null), {
  mixed,
  string,
  number,
  date,
  object,
  array: array$1,
  boolean
});

/** Used for built-in method references. */
var objectProto$c = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$9 = objectProto$c.hasOwnProperty;

/**
 * The base implementation of `_.has` without support for deep paths.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {Array|string} key The key to check.
 * @returns {boolean} Returns `true` if `key` exists, else `false`.
 */
function baseHas(object, key) {
  return object != null && hasOwnProperty$9.call(object, key);
}

var _baseHas = baseHas;

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

var isArray_1 = isArray;

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function createCommonjsModule(fn) {
  var module = { exports: {} };
	return fn(module, module.exports), module.exports;
}

/** Detect free variable `global` from Node.js. */

var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;

var _freeGlobal = freeGlobal;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = _freeGlobal || freeSelf || Function('return this')();

var _root = root;

/** Built-in value references. */
var Symbol$1 = _root.Symbol;

var _Symbol = Symbol$1;

/** Used for built-in method references. */
var objectProto$b = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$8 = objectProto$b.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString$1 = objectProto$b.toString;

/** Built-in value references. */
var symToStringTag$1 = _Symbol ? _Symbol.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty$8.call(value, symToStringTag$1),
      tag = value[symToStringTag$1];

  try {
    value[symToStringTag$1] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString$1.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag$1] = tag;
    } else {
      delete value[symToStringTag$1];
    }
  }
  return result;
}

var _getRawTag = getRawTag;

/** Used for built-in method references. */
var objectProto$a = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto$a.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

var _objectToString = objectToString;

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = _Symbol ? _Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? _getRawTag(value)
    : _objectToString(value);
}

var _baseGetTag = baseGetTag;

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

var isObjectLike_1 = isObjectLike;

/** `Object#toString` result references. */
var symbolTag$1 = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike_1(value) && _baseGetTag(value) == symbolTag$1);
}

var isSymbol_1 = isSymbol;

/** Used to match property names within property paths. */
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
    reIsPlainProp = /^\w*$/;

/**
 * Checks if `value` is a property name and not a property path.
 *
 * @private
 * @param {*} value The value to check.
 * @param {Object} [object] The object to query keys on.
 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
 */
function isKey(value, object) {
  if (isArray_1(value)) {
    return false;
  }
  var type = typeof value;
  if (type == 'number' || type == 'symbol' || type == 'boolean' ||
      value == null || isSymbol_1(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
    (object != null && value in Object(object));
}

var _isKey = isKey;

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject$1(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

var isObject_1 = isObject$1;

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag$1 = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject_1(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = _baseGetTag(value);
  return tag == funcTag$1 || tag == genTag || tag == asyncTag || tag == proxyTag;
}

var isFunction_1 = isFunction;

/** Used to detect overreaching core-js shims. */
var coreJsData = _root['__core-js_shared__'];

var _coreJsData = coreJsData;

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(_coreJsData && _coreJsData.keys && _coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

var _isMasked = isMasked;

/** Used for built-in method references. */
var funcProto$1 = Function.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString$1 = funcProto$1.toString;

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString$1.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

var _toSource = toSource;

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto$9 = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty$7 = objectProto$9.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty$7).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject_1(value) || _isMasked(value)) {
    return false;
  }
  var pattern = isFunction_1(value) ? reIsNative : reIsHostCtor;
  return pattern.test(_toSource(value));
}

var _baseIsNative = baseIsNative;

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

var _getValue = getValue;

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = _getValue(object, key);
  return _baseIsNative(value) ? value : undefined;
}

var _getNative = getNative;

/* Built-in method references that are verified to be native. */
var nativeCreate = _getNative(Object, 'create');

var _nativeCreate = nativeCreate;

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = _nativeCreate ? _nativeCreate(null) : {};
  this.size = 0;
}

var _hashClear = hashClear;

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

var _hashDelete = hashDelete;

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED$2 = '__lodash_hash_undefined__';

/** Used for built-in method references. */
var objectProto$8 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$6 = objectProto$8.hasOwnProperty;

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (_nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED$2 ? undefined : result;
  }
  return hasOwnProperty$6.call(data, key) ? data[key] : undefined;
}

var _hashGet = hashGet;

/** Used for built-in method references. */
var objectProto$7 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$5 = objectProto$7.hasOwnProperty;

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return _nativeCreate ? (data[key] !== undefined) : hasOwnProperty$5.call(data, key);
}

var _hashHas = hashHas;

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED$1 = '__lodash_hash_undefined__';

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (_nativeCreate && value === undefined) ? HASH_UNDEFINED$1 : value;
  return this;
}

var _hashSet = hashSet;

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = _hashClear;
Hash.prototype['delete'] = _hashDelete;
Hash.prototype.get = _hashGet;
Hash.prototype.has = _hashHas;
Hash.prototype.set = _hashSet;

var _Hash = Hash;

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

var _listCacheClear = listCacheClear;

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

var eq_1 = eq;

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq_1(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

var _assocIndexOf = assocIndexOf;

/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = _assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

var _listCacheDelete = listCacheDelete;

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = _assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

var _listCacheGet = listCacheGet;

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return _assocIndexOf(this.__data__, key) > -1;
}

var _listCacheHas = listCacheHas;

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = _assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

var _listCacheSet = listCacheSet;

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = _listCacheClear;
ListCache.prototype['delete'] = _listCacheDelete;
ListCache.prototype.get = _listCacheGet;
ListCache.prototype.has = _listCacheHas;
ListCache.prototype.set = _listCacheSet;

var _ListCache = ListCache;

/* Built-in method references that are verified to be native. */
var Map$1 = _getNative(_root, 'Map');

var _Map = Map$1;

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new _Hash,
    'map': new (_Map || _ListCache),
    'string': new _Hash
  };
}

var _mapCacheClear = mapCacheClear;

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

var _isKeyable = isKeyable;

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return _isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

var _getMapData = getMapData;

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = _getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

var _mapCacheDelete = mapCacheDelete;

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return _getMapData(this, key).get(key);
}

var _mapCacheGet = mapCacheGet;

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return _getMapData(this, key).has(key);
}

var _mapCacheHas = mapCacheHas;

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = _getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

var _mapCacheSet = mapCacheSet;

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = _mapCacheClear;
MapCache.prototype['delete'] = _mapCacheDelete;
MapCache.prototype.get = _mapCacheGet;
MapCache.prototype.has = _mapCacheHas;
MapCache.prototype.set = _mapCacheSet;

var _MapCache = MapCache;

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a function that memoizes the result of `func`. If `resolver` is
 * provided, it determines the cache key for storing the result based on the
 * arguments provided to the memoized function. By default, the first argument
 * provided to the memoized function is used as the map cache key. The `func`
 * is invoked with the `this` binding of the memoized function.
 *
 * **Note:** The cache is exposed as the `cache` property on the memoized
 * function. Its creation may be customized by replacing the `_.memoize.Cache`
 * constructor with one whose instances implement the
 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
 * method interface of `clear`, `delete`, `get`, `has`, and `set`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to have its output memoized.
 * @param {Function} [resolver] The function to resolve the cache key.
 * @returns {Function} Returns the new memoized function.
 * @example
 *
 * var object = { 'a': 1, 'b': 2 };
 * var other = { 'c': 3, 'd': 4 };
 *
 * var values = _.memoize(_.values);
 * values(object);
 * // => [1, 2]
 *
 * values(other);
 * // => [3, 4]
 *
 * object.a = 2;
 * values(object);
 * // => [1, 2]
 *
 * // Modify the result cache.
 * values.cache.set(object, ['a', 'b']);
 * values(object);
 * // => ['a', 'b']
 *
 * // Replace `_.memoize.Cache`.
 * _.memoize.Cache = WeakMap;
 */
function memoize(func, resolver) {
  if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments,
        key = resolver ? resolver.apply(this, args) : args[0],
        cache = memoized.cache;

    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result) || cache;
    return result;
  };
  memoized.cache = new (memoize.Cache || _MapCache);
  return memoized;
}

// Expose `MapCache`.
memoize.Cache = _MapCache;

var memoize_1 = memoize;

/** Used as the maximum memoize cache size. */
var MAX_MEMOIZE_SIZE = 500;

/**
 * A specialized version of `_.memoize` which clears the memoized function's
 * cache when it exceeds `MAX_MEMOIZE_SIZE`.
 *
 * @private
 * @param {Function} func The function to have its output memoized.
 * @returns {Function} Returns the new memoized function.
 */
function memoizeCapped(func) {
  var result = memoize_1(func, function(key) {
    if (cache.size === MAX_MEMOIZE_SIZE) {
      cache.clear();
    }
    return key;
  });

  var cache = result.cache;
  return result;
}

var _memoizeCapped = memoizeCapped;

/** Used to match property names within property paths. */
var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

/** Used to match backslashes in property paths. */
var reEscapeChar = /\\(\\)?/g;

/**
 * Converts `string` to a property path array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the property path array.
 */
var stringToPath = _memoizeCapped(function(string) {
  var result = [];
  if (string.charCodeAt(0) === 46 /* . */) {
    result.push('');
  }
  string.replace(rePropName, function(match, number, quote, subString) {
    result.push(quote ? subString.replace(reEscapeChar, '$1') : (number || match));
  });
  return result;
});

var _stringToPath = stringToPath;

/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

var _arrayMap = arrayMap;

/** Used as references for various `Number` constants. */
var INFINITY$1 = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto$1 = _Symbol ? _Symbol.prototype : undefined,
    symbolToString = symbolProto$1 ? symbolProto$1.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isArray_1(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return _arrayMap(value, baseToString) + '';
  }
  if (isSymbol_1(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY$1) ? '-0' : result;
}

var _baseToString = baseToString;

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : _baseToString(value);
}

var toString_1 = toString;

/**
 * Casts `value` to a path array if it's not one.
 *
 * @private
 * @param {*} value The value to inspect.
 * @param {Object} [object] The object to query keys on.
 * @returns {Array} Returns the cast property path array.
 */
function castPath(value, object) {
  if (isArray_1(value)) {
    return value;
  }
  return _isKey(value, object) ? [value] : _stringToPath(toString_1(value));
}

var _castPath = castPath;

/** `Object#toString` result references. */
var argsTag$2 = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike_1(value) && _baseGetTag(value) == argsTag$2;
}

var _baseIsArguments = baseIsArguments;

/** Used for built-in method references. */
var objectProto$6 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$4 = objectProto$6.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable$1 = objectProto$6.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = _baseIsArguments(function() { return arguments; }()) ? _baseIsArguments : function(value) {
  return isObjectLike_1(value) && hasOwnProperty$4.call(value, 'callee') &&
    !propertyIsEnumerable$1.call(value, 'callee');
};

var isArguments_1 = isArguments;

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER$1 = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER$1 : length;

  return !!length &&
    (type == 'number' ||
      (type != 'symbol' && reIsUint.test(value))) &&
        (value > -1 && value % 1 == 0 && value < length);
}

var _isIndex = isIndex;

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

var isLength_1 = isLength;

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/**
 * Converts `value` to a string key if it's not a string or symbol.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {string|symbol} Returns the key.
 */
function toKey(value) {
  if (typeof value == 'string' || isSymbol_1(value)) {
    return value;
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

var _toKey = toKey;

/**
 * Checks if `path` exists on `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @param {Function} hasFunc The function to check properties.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 */
function hasPath(object, path, hasFunc) {
  path = _castPath(path, object);

  var index = -1,
      length = path.length,
      result = false;

  while (++index < length) {
    var key = _toKey(path[index]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result || ++index != length) {
    return result;
  }
  length = object == null ? 0 : object.length;
  return !!length && isLength_1(length) && _isIndex(key, length) &&
    (isArray_1(object) || isArguments_1(object));
}

var _hasPath = hasPath;

/**
 * Checks if `path` is a direct property of `object`.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 * @example
 *
 * var object = { 'a': { 'b': 2 } };
 * var other = _.create({ 'a': _.create({ 'b': 2 }) });
 *
 * _.has(object, 'a');
 * // => true
 *
 * _.has(object, 'a.b');
 * // => true
 *
 * _.has(object, ['a', 'b']);
 * // => true
 *
 * _.has(other, 'a');
 * // => false
 */
function has(object, path) {
  return object != null && _hasPath(object, path, _baseHas);
}

var has_1 = has;

var isSchema = (obj => obj && obj.__isYupSchema__);

class Condition {
  constructor(refs, options) {
    this.refs = refs;
    this.refs = refs;

    if (typeof options === 'function') {
      this.fn = options;
      return;
    }

    if (!has_1(options, 'is')) throw new TypeError('`is:` is required for `when()` conditions');
    if (!options.then && !options.otherwise) throw new TypeError('either `then:` or `otherwise:` is required for `when()` conditions');
    let {
      is,
      then,
      otherwise
    } = options;
    let check = typeof is === 'function' ? is : (...values) => values.every(value => value === is);

    this.fn = function (...args) {
      let options = args.pop();
      let schema = args.pop();
      let branch = check(...args) ? then : otherwise;
      if (!branch) return undefined;
      if (typeof branch === 'function') return branch(schema);
      return schema.concat(branch.resolve(options));
    };
  }

  resolve(base, options) {
    let values = this.refs.map(ref => ref.getValue(options == null ? void 0 : options.value, options == null ? void 0 : options.parent, options == null ? void 0 : options.context));
    let schema = this.fn.apply(base, values.concat(base, options));
    if (schema === undefined || schema === base) return base;
    if (!isSchema(schema)) throw new TypeError('conditions must return a schema object');
    return schema.resolve(options);
  }

}

function toArray(value) {
  return value == null ? [] : [].concat(value);
}

function _extends$3() { _extends$3 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$3.apply(this, arguments); }
let strReg = /\$\{\s*(\w+)\s*\}/g;
class ValidationError extends Error {
  static formatError(message, params) {
    const path = params.label || params.path || 'this';
    if (path !== params.path) params = _extends$3({}, params, {
      path
    });
    if (typeof message === 'string') return message.replace(strReg, (_, key) => printValue(params[key]));
    if (typeof message === 'function') return message(params);
    return message;
  }

  static isError(err) {
    return err && err.name === 'ValidationError';
  }

  constructor(errorOrErrors, value, field, type) {
    super();
    this.name = 'ValidationError';
    this.value = value;
    this.path = field;
    this.type = type;
    this.errors = [];
    this.inner = [];
    toArray(errorOrErrors).forEach(err => {
      if (ValidationError.isError(err)) {
        this.errors.push(...err.errors);
        this.inner = this.inner.concat(err.inner.length ? err.inner : err);
      } else {
        this.errors.push(err);
      }
    });
    this.message = this.errors.length > 1 ? `${this.errors.length} errors occurred` : this.errors[0];
    if (Error.captureStackTrace) Error.captureStackTrace(this, ValidationError);
  }

}

const once = cb => {
  let fired = false;
  return (...args) => {
    if (fired) return;
    fired = true;
    cb(...args);
  };
};

function runTests(options, cb) {
  let {
    endEarly,
    tests,
    args,
    value,
    errors,
    sort,
    path
  } = options;
  let callback = once(cb);
  let count = tests.length;
  const nestedErrors = [];
  errors = errors ? errors : [];
  if (!count) return errors.length ? callback(new ValidationError(errors, value, path)) : callback(null, value);

  for (let i = 0; i < tests.length; i++) {
    const test = tests[i];
    test(args, function finishTestRun(err) {
      if (err) {
        // always return early for non validation errors
        if (!ValidationError.isError(err)) {
          return callback(err, value);
        }

        if (endEarly) {
          err.value = value;
          return callback(err, value);
        }

        nestedErrors.push(err);
      }

      if (--count <= 0) {
        if (nestedErrors.length) {
          if (sort) nestedErrors.sort(sort); //show parent errors after the nested ones: name.first, name

          if (errors.length) nestedErrors.push(...errors);
          errors = nestedErrors;
        }

        if (errors.length) {
          callback(new ValidationError(errors, value, path), value);
          return;
        }

        callback(null, value);
      }
    });
  }
}

var defineProperty = (function() {
  try {
    var func = _getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

var _defineProperty = defineProperty;

/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function baseAssignValue(object, key, value) {
  if (key == '__proto__' && _defineProperty) {
    _defineProperty(object, key, {
      'configurable': true,
      'enumerable': true,
      'value': value,
      'writable': true
    });
  } else {
    object[key] = value;
  }
}

var _baseAssignValue = baseAssignValue;

/**
 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index = -1,
        iterable = Object(object),
        props = keysFunc(object),
        length = props.length;

    while (length--) {
      var key = props[fromRight ? length : ++index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}

var _createBaseFor = createBaseFor;

/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = _createBaseFor();

var _baseFor = baseFor;

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

var _baseTimes = baseTimes;

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

var stubFalse_1 = stubFalse;

var isBuffer_1 = createCommonjsModule(function (module, exports) {
/** Detect free variable `exports`. */
var freeExports = exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? _root.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse_1;

module.exports = isBuffer;
});

/** `Object#toString` result references. */
var argsTag$1 = '[object Arguments]',
    arrayTag$1 = '[object Array]',
    boolTag$1 = '[object Boolean]',
    dateTag$1 = '[object Date]',
    errorTag$1 = '[object Error]',
    funcTag = '[object Function]',
    mapTag$2 = '[object Map]',
    numberTag$1 = '[object Number]',
    objectTag$2 = '[object Object]',
    regexpTag$1 = '[object RegExp]',
    setTag$2 = '[object Set]',
    stringTag$1 = '[object String]',
    weakMapTag$1 = '[object WeakMap]';

var arrayBufferTag$1 = '[object ArrayBuffer]',
    dataViewTag$2 = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag$1] = typedArrayTags[arrayTag$1] =
typedArrayTags[arrayBufferTag$1] = typedArrayTags[boolTag$1] =
typedArrayTags[dataViewTag$2] = typedArrayTags[dateTag$1] =
typedArrayTags[errorTag$1] = typedArrayTags[funcTag] =
typedArrayTags[mapTag$2] = typedArrayTags[numberTag$1] =
typedArrayTags[objectTag$2] = typedArrayTags[regexpTag$1] =
typedArrayTags[setTag$2] = typedArrayTags[stringTag$1] =
typedArrayTags[weakMapTag$1] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike_1(value) &&
    isLength_1(value.length) && !!typedArrayTags[_baseGetTag(value)];
}

var _baseIsTypedArray = baseIsTypedArray;

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

var _baseUnary = baseUnary;

var _nodeUtil = createCommonjsModule(function (module, exports) {
/** Detect free variable `exports`. */
var freeExports = exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports && _freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    // Use `util.types` for Node.js 10+.
    var types = freeModule && freeModule.require && freeModule.require('util').types;

    if (types) {
      return types;
    }

    // Legacy `process.binding('util')` for Node.js < 10.
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

module.exports = nodeUtil;
});

/* Node.js helper references. */
var nodeIsTypedArray = _nodeUtil && _nodeUtil.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? _baseUnary(nodeIsTypedArray) : _baseIsTypedArray;

var isTypedArray_1 = isTypedArray;

/** Used for built-in method references. */
var objectProto$5 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$3 = objectProto$5.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray_1(value),
      isArg = !isArr && isArguments_1(value),
      isBuff = !isArr && !isArg && isBuffer_1(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray_1(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? _baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty$3.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           _isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

var _arrayLikeKeys = arrayLikeKeys;

/** Used for built-in method references. */
var objectProto$4 = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto$4;

  return value === proto;
}

var _isPrototype = isPrototype;

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

var _overArg = overArg;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeKeys = _overArg(Object.keys, Object);

var _nativeKeys = nativeKeys;

/** Used for built-in method references. */
var objectProto$3 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$2 = objectProto$3.hasOwnProperty;

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!_isPrototype(object)) {
    return _nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty$2.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

var _baseKeys = baseKeys;

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength_1(value.length) && !isFunction_1(value);
}

var isArrayLike_1 = isArrayLike;

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return isArrayLike_1(object) ? _arrayLikeKeys(object) : _baseKeys(object);
}

var keys_1 = keys;

/**
 * The base implementation of `_.forOwn` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Object} Returns `object`.
 */
function baseForOwn(object, iteratee) {
  return object && _baseFor(object, iteratee, keys_1);
}

var _baseForOwn = baseForOwn;

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new _ListCache;
  this.size = 0;
}

var _stackClear = stackClear;

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
      result = data['delete'](key);

  this.size = data.size;
  return result;
}

var _stackDelete = stackDelete;

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

var _stackGet = stackGet;

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

var _stackHas = stackHas;

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof _ListCache) {
    var pairs = data.__data__;
    if (!_Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new _MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}

var _stackSet = stackSet;

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new _ListCache(entries);
  this.size = data.size;
}

// Add methods to `Stack`.
Stack.prototype.clear = _stackClear;
Stack.prototype['delete'] = _stackDelete;
Stack.prototype.get = _stackGet;
Stack.prototype.has = _stackHas;
Stack.prototype.set = _stackSet;

var _Stack = Stack;

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Adds `value` to the array cache.
 *
 * @private
 * @name add
 * @memberOf SetCache
 * @alias push
 * @param {*} value The value to cache.
 * @returns {Object} Returns the cache instance.
 */
function setCacheAdd(value) {
  this.__data__.set(value, HASH_UNDEFINED);
  return this;
}

var _setCacheAdd = setCacheAdd;

/**
 * Checks if `value` is in the array cache.
 *
 * @private
 * @name has
 * @memberOf SetCache
 * @param {*} value The value to search for.
 * @returns {number} Returns `true` if `value` is found, else `false`.
 */
function setCacheHas(value) {
  return this.__data__.has(value);
}

var _setCacheHas = setCacheHas;

/**
 *
 * Creates an array cache object to store unique values.
 *
 * @private
 * @constructor
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var index = -1,
      length = values == null ? 0 : values.length;

  this.__data__ = new _MapCache;
  while (++index < length) {
    this.add(values[index]);
  }
}

// Add methods to `SetCache`.
SetCache.prototype.add = SetCache.prototype.push = _setCacheAdd;
SetCache.prototype.has = _setCacheHas;

var _SetCache = SetCache;

/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

var _arraySome = arraySome;

/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}

var _cacheHas = cacheHas;

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG$5 = 1,
    COMPARE_UNORDERED_FLAG$3 = 2;

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG$5,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Check that cyclic values are equal.
  var arrStacked = stack.get(array);
  var othStacked = stack.get(other);
  if (arrStacked && othStacked) {
    return arrStacked == other && othStacked == array;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG$3) ? new _SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!_arraySome(other, function(othValue, othIndex) {
            if (!_cacheHas(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

var _equalArrays = equalArrays;

/** Built-in value references. */
var Uint8Array = _root.Uint8Array;

var _Uint8Array = Uint8Array;

/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

var _mapToArray = mapToArray;

/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

var _setToArray = setToArray;

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG$4 = 1,
    COMPARE_UNORDERED_FLAG$2 = 2;

/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    mapTag$1 = '[object Map]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    setTag$1 = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag$1 = '[object DataView]';

/** Used to convert symbols to primitives and strings. */
var symbolProto = _Symbol ? _Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag$1:
      if ((object.byteLength != other.byteLength) ||
          (object.byteOffset != other.byteOffset)) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;

    case arrayBufferTag:
      if ((object.byteLength != other.byteLength) ||
          !equalFunc(new _Uint8Array(object), new _Uint8Array(other))) {
        return false;
      }
      return true;

    case boolTag:
    case dateTag:
    case numberTag:
      // Coerce booleans to `1` or `0` and dates to milliseconds.
      // Invalid dates are coerced to `NaN`.
      return eq_1(+object, +other);

    case errorTag:
      return object.name == other.name && object.message == other.message;

    case regexpTag:
    case stringTag:
      // Coerce regexes to strings and treat strings, primitives and objects,
      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
      // for more details.
      return object == (other + '');

    case mapTag$1:
      var convert = _mapToArray;

    case setTag$1:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG$4;
      convert || (convert = _setToArray);

      if (object.size != other.size && !isPartial) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG$2;

      // Recursively compare objects (susceptible to call stack limits).
      stack.set(object, other);
      var result = _equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack['delete'](object);
      return result;

    case symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}

var _equalByTag = equalByTag;

/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

var _arrayPush = arrayPush;

/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray_1(object) ? result : _arrayPush(result, symbolsFunc(object));
}

var _baseGetAllKeys = baseGetAllKeys;

/**
 * A specialized version of `_.filter` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length,
      resIndex = 0,
      result = [];

  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}

var _arrayFilter = arrayFilter;

/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}

var stubArray_1 = stubArray;

/** Used for built-in method references. */
var objectProto$2 = Object.prototype;

/** Built-in value references. */
var propertyIsEnumerable = objectProto$2.propertyIsEnumerable;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? stubArray_1 : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return _arrayFilter(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable.call(object, symbol);
  });
};

var _getSymbols = getSymbols;

/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return _baseGetAllKeys(object, keys_1, _getSymbols);
}

var _getAllKeys = getAllKeys;

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG$3 = 1;

/** Used for built-in method references. */
var objectProto$1 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$1 = objectProto$1.hasOwnProperty;

/**
 * A specialized version of `baseIsEqualDeep` for objects with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG$3,
      objProps = _getAllKeys(object),
      objLength = objProps.length,
      othProps = _getAllKeys(other),
      othLength = othProps.length;

  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isPartial ? key in other : hasOwnProperty$1.call(other, key))) {
      return false;
    }
  }
  // Check that cyclic values are equal.
  var objStacked = stack.get(object);
  var othStacked = stack.get(other);
  if (objStacked && othStacked) {
    return objStacked == other && othStacked == object;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);

  var skipCtor = isPartial;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key],
        othValue = other[key];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, objValue, key, other, object, stack)
        : customizer(objValue, othValue, key, object, other, stack);
    }
    // Recursively compare objects (susceptible to call stack limits).
    if (!(compared === undefined
          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
          : compared
        )) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == 'constructor');
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor,
        othCtor = other.constructor;

    // Non `Object` object instances with different constructors are not equal.
    if (objCtor != othCtor &&
        ('constructor' in object && 'constructor' in other) &&
        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack['delete'](object);
  stack['delete'](other);
  return result;
}

var _equalObjects = equalObjects;

/* Built-in method references that are verified to be native. */
var DataView = _getNative(_root, 'DataView');

var _DataView = DataView;

/* Built-in method references that are verified to be native. */
var Promise$1 = _getNative(_root, 'Promise');

var _Promise = Promise$1;

/* Built-in method references that are verified to be native. */
var Set$1 = _getNative(_root, 'Set');

var _Set = Set$1;

/* Built-in method references that are verified to be native. */
var WeakMap = _getNative(_root, 'WeakMap');

var _WeakMap = WeakMap;

/** `Object#toString` result references. */
var mapTag = '[object Map]',
    objectTag$1 = '[object Object]',
    promiseTag = '[object Promise]',
    setTag = '[object Set]',
    weakMapTag = '[object WeakMap]';

var dataViewTag = '[object DataView]';

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = _toSource(_DataView),
    mapCtorString = _toSource(_Map),
    promiseCtorString = _toSource(_Promise),
    setCtorString = _toSource(_Set),
    weakMapCtorString = _toSource(_WeakMap);

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = _baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if ((_DataView && getTag(new _DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (_Map && getTag(new _Map) != mapTag) ||
    (_Promise && getTag(_Promise.resolve()) != promiseTag) ||
    (_Set && getTag(new _Set) != setTag) ||
    (_WeakMap && getTag(new _WeakMap) != weakMapTag)) {
  getTag = function(value) {
    var result = _baseGetTag(value),
        Ctor = result == objectTag$1 ? value.constructor : undefined,
        ctorString = Ctor ? _toSource(Ctor) : '';

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

var _getTag = getTag;

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG$2 = 1;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    objectTag = '[object Object]';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = isArray_1(object),
      othIsArr = isArray_1(other),
      objTag = objIsArr ? arrayTag : _getTag(object),
      othTag = othIsArr ? arrayTag : _getTag(other);

  objTag = objTag == argsTag ? objectTag : objTag;
  othTag = othTag == argsTag ? objectTag : othTag;

  var objIsObj = objTag == objectTag,
      othIsObj = othTag == objectTag,
      isSameTag = objTag == othTag;

  if (isSameTag && isBuffer_1(object)) {
    if (!isBuffer_1(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new _Stack);
    return (objIsArr || isTypedArray_1(object))
      ? _equalArrays(object, other, bitmask, customizer, equalFunc, stack)
      : _equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG$2)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object,
          othUnwrapped = othIsWrapped ? other.value() : other;

      stack || (stack = new _Stack);
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new _Stack);
  return _equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}

var _baseIsEqualDeep = baseIsEqualDeep;

/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Unordered comparison
 *  2 - Partial comparison
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!isObjectLike_1(value) && !isObjectLike_1(other))) {
    return value !== value && other !== other;
  }
  return _baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}

var _baseIsEqual = baseIsEqual;

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG$1 = 1,
    COMPARE_UNORDERED_FLAG$1 = 2;

/**
 * The base implementation of `_.isMatch` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to inspect.
 * @param {Object} source The object of property values to match.
 * @param {Array} matchData The property names, values, and compare flags to match.
 * @param {Function} [customizer] The function to customize comparisons.
 * @returns {boolean} Returns `true` if `object` is a match, else `false`.
 */
function baseIsMatch(object, source, matchData, customizer) {
  var index = matchData.length,
      length = index,
      noCustomizer = !customizer;

  if (object == null) {
    return !length;
  }
  object = Object(object);
  while (index--) {
    var data = matchData[index];
    if ((noCustomizer && data[2])
          ? data[1] !== object[data[0]]
          : !(data[0] in object)
        ) {
      return false;
    }
  }
  while (++index < length) {
    data = matchData[index];
    var key = data[0],
        objValue = object[key],
        srcValue = data[1];

    if (noCustomizer && data[2]) {
      if (objValue === undefined && !(key in object)) {
        return false;
      }
    } else {
      var stack = new _Stack;
      if (customizer) {
        var result = customizer(objValue, srcValue, key, object, source, stack);
      }
      if (!(result === undefined
            ? _baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG$1 | COMPARE_UNORDERED_FLAG$1, customizer, stack)
            : result
          )) {
        return false;
      }
    }
  }
  return true;
}

var _baseIsMatch = baseIsMatch;

/**
 * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` if suitable for strict
 *  equality comparisons, else `false`.
 */
function isStrictComparable(value) {
  return value === value && !isObject_1(value);
}

var _isStrictComparable = isStrictComparable;

/**
 * Gets the property names, values, and compare flags of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the match data of `object`.
 */
function getMatchData(object) {
  var result = keys_1(object),
      length = result.length;

  while (length--) {
    var key = result[length],
        value = object[key];

    result[length] = [key, value, _isStrictComparable(value)];
  }
  return result;
}

var _getMatchData = getMatchData;

/**
 * A specialized version of `matchesProperty` for source values suitable
 * for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function matchesStrictComparable(key, srcValue) {
  return function(object) {
    if (object == null) {
      return false;
    }
    return object[key] === srcValue &&
      (srcValue !== undefined || (key in Object(object)));
  };
}

var _matchesStrictComparable = matchesStrictComparable;

/**
 * The base implementation of `_.matches` which doesn't clone `source`.
 *
 * @private
 * @param {Object} source The object of property values to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatches(source) {
  var matchData = _getMatchData(source);
  if (matchData.length == 1 && matchData[0][2]) {
    return _matchesStrictComparable(matchData[0][0], matchData[0][1]);
  }
  return function(object) {
    return object === source || _baseIsMatch(object, source, matchData);
  };
}

var _baseMatches = baseMatches;

/**
 * The base implementation of `_.get` without support for default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path) {
  path = _castPath(path, object);

  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[_toKey(path[index++])];
  }
  return (index && index == length) ? object : undefined;
}

var _baseGet = baseGet;

/**
 * Gets the value at `path` of `object`. If the resolved value is
 * `undefined`, the `defaultValue` is returned in its place.
 *
 * @static
 * @memberOf _
 * @since 3.7.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @param {*} [defaultValue] The value returned for `undefined` resolved values.
 * @returns {*} Returns the resolved value.
 * @example
 *
 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
 *
 * _.get(object, 'a[0].b.c');
 * // => 3
 *
 * _.get(object, ['a', '0', 'b', 'c']);
 * // => 3
 *
 * _.get(object, 'a.b.c', 'default');
 * // => 'default'
 */
function get(object, path, defaultValue) {
  var result = object == null ? undefined : _baseGet(object, path);
  return result === undefined ? defaultValue : result;
}

var get_1 = get;

/**
 * The base implementation of `_.hasIn` without support for deep paths.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {Array|string} key The key to check.
 * @returns {boolean} Returns `true` if `key` exists, else `false`.
 */
function baseHasIn(object, key) {
  return object != null && key in Object(object);
}

var _baseHasIn = baseHasIn;

/**
 * Checks if `path` is a direct or inherited property of `object`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 * @example
 *
 * var object = _.create({ 'a': _.create({ 'b': 2 }) });
 *
 * _.hasIn(object, 'a');
 * // => true
 *
 * _.hasIn(object, 'a.b');
 * // => true
 *
 * _.hasIn(object, ['a', 'b']);
 * // => true
 *
 * _.hasIn(object, 'b');
 * // => false
 */
function hasIn(object, path) {
  return object != null && _hasPath(object, path, _baseHasIn);
}

var hasIn_1 = hasIn;

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
 *
 * @private
 * @param {string} path The path of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatchesProperty(path, srcValue) {
  if (_isKey(path) && _isStrictComparable(srcValue)) {
    return _matchesStrictComparable(_toKey(path), srcValue);
  }
  return function(object) {
    var objValue = get_1(object, path);
    return (objValue === undefined && objValue === srcValue)
      ? hasIn_1(object, path)
      : _baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
  };
}

var _baseMatchesProperty = baseMatchesProperty;

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

var identity_1 = identity;

/**
 * The base implementation of `_.property` without support for deep paths.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function baseProperty(key) {
  return function(object) {
    return object == null ? undefined : object[key];
  };
}

var _baseProperty = baseProperty;

/**
 * A specialized version of `baseProperty` which supports deep paths.
 *
 * @private
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function basePropertyDeep(path) {
  return function(object) {
    return _baseGet(object, path);
  };
}

var _basePropertyDeep = basePropertyDeep;

/**
 * Creates a function that returns the value at `path` of a given object.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 * @example
 *
 * var objects = [
 *   { 'a': { 'b': 2 } },
 *   { 'a': { 'b': 1 } }
 * ];
 *
 * _.map(objects, _.property('a.b'));
 * // => [2, 1]
 *
 * _.map(_.sortBy(objects, _.property(['a', 'b'])), 'a.b');
 * // => [1, 2]
 */
function property(path) {
  return _isKey(path) ? _baseProperty(_toKey(path)) : _basePropertyDeep(path);
}

var property_1 = property;

/**
 * The base implementation of `_.iteratee`.
 *
 * @private
 * @param {*} [value=_.identity] The value to convert to an iteratee.
 * @returns {Function} Returns the iteratee.
 */
function baseIteratee(value) {
  // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
  // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
  if (typeof value == 'function') {
    return value;
  }
  if (value == null) {
    return identity_1;
  }
  if (typeof value == 'object') {
    return isArray_1(value)
      ? _baseMatchesProperty(value[0], value[1])
      : _baseMatches(value);
  }
  return property_1(value);
}

var _baseIteratee = baseIteratee;

/**
 * Creates an object with the same keys as `object` and values generated
 * by running each own enumerable string keyed property of `object` thru
 * `iteratee`. The iteratee is invoked with three arguments:
 * (value, key, object).
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Object
 * @param {Object} object The object to iterate over.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @returns {Object} Returns the new mapped object.
 * @see _.mapKeys
 * @example
 *
 * var users = {
 *   'fred':    { 'user': 'fred',    'age': 40 },
 *   'pebbles': { 'user': 'pebbles', 'age': 1 }
 * };
 *
 * _.mapValues(users, function(o) { return o.age; });
 * // => { 'fred': 40, 'pebbles': 1 } (iteration order is not guaranteed)
 *
 * // The `_.property` iteratee shorthand.
 * _.mapValues(users, 'age');
 * // => { 'fred': 40, 'pebbles': 1 } (iteration order is not guaranteed)
 */
function mapValues(object, iteratee) {
  var result = {};
  iteratee = _baseIteratee(iteratee);

  _baseForOwn(object, function(value, key, object) {
    _baseAssignValue(result, key, iteratee(value, key, object));
  });
  return result;
}

var mapValues_1 = mapValues;

/**
 * Based on Kendo UI Core expression code <https://github.com/telerik/kendo-ui-core#license-information>
 */

function Cache(maxSize) {
  this._maxSize = maxSize;
  this.clear();
}
Cache.prototype.clear = function () {
  this._size = 0;
  this._values = Object.create(null);
};
Cache.prototype.get = function (key) {
  return this._values[key]
};
Cache.prototype.set = function (key, value) {
  this._size >= this._maxSize && this.clear();
  if (!(key in this._values)) this._size++;

  return (this._values[key] = value)
};

var SPLIT_REGEX = /[^.^\]^[]+|(?=\[\]|\.\.)/g,
  DIGIT_REGEX = /^\d+$/,
  LEAD_DIGIT_REGEX = /^\d/,
  SPEC_CHAR_REGEX = /[~`!#$%\^&*+=\-\[\]\\';,/{}|\\":<>\?]/g,
  CLEAN_QUOTES_REGEX = /^\s*(['"]?)(.*?)(\1)\s*$/,
  MAX_CACHE_SIZE = 512;

var pathCache = new Cache(MAX_CACHE_SIZE),
  setCache = new Cache(MAX_CACHE_SIZE),
  getCache = new Cache(MAX_CACHE_SIZE);

var propertyExpr = {
  Cache: Cache,

  split: split,

  normalizePath: normalizePath,

  setter: function (path) {
    var parts = normalizePath(path);

    return (
      setCache.get(path) ||
      setCache.set(path, function setter(obj, value) {
        var index = 0;
        var len = parts.length;
        var data = obj;

        while (index < len - 1) {
          var part = parts[index];
          if (
            part === '__proto__' ||
            part === 'constructor' ||
            part === 'prototype'
          ) {
            return obj
          }

          data = data[parts[index++]];
        }
        data[parts[index]] = value;
      })
    )
  },

  getter: function (path, safe) {
    var parts = normalizePath(path);
    return (
      getCache.get(path) ||
      getCache.set(path, function getter(data) {
        var index = 0,
          len = parts.length;
        while (index < len) {
          if (data != null || !safe) data = data[parts[index++]];
          else return
        }
        return data
      })
    )
  },

  join: function (segments) {
    return segments.reduce(function (path, part) {
      return (
        path +
        (isQuoted(part) || DIGIT_REGEX.test(part)
          ? '[' + part + ']'
          : (path ? '.' : '') + part)
      )
    }, '')
  },

  forEach: function (path, cb, thisArg) {
    forEach(Array.isArray(path) ? path : split(path), cb, thisArg);
  },
};

function normalizePath(path) {
  return (
    pathCache.get(path) ||
    pathCache.set(
      path,
      split(path).map(function (part) {
        return part.replace(CLEAN_QUOTES_REGEX, '$2')
      })
    )
  )
}

function split(path) {
  return path.match(SPLIT_REGEX)
}

function forEach(parts, iter, thisArg) {
  var len = parts.length,
    part,
    idx,
    isArray,
    isBracket;

  for (idx = 0; idx < len; idx++) {
    part = parts[idx];

    if (part) {
      if (shouldBeQuoted(part)) {
        part = '"' + part + '"';
      }

      isBracket = isQuoted(part);
      isArray = !isBracket && /^\d+$/.test(part);

      iter.call(thisArg, part, isBracket, isArray, idx, parts);
    }
  }
}

function isQuoted(str) {
  return (
    typeof str === 'string' && str && ["'", '"'].indexOf(str.charAt(0)) !== -1
  )
}

function hasLeadingNumber(part) {
  return part.match(LEAD_DIGIT_REGEX) && !part.match(DIGIT_REGEX)
}

function hasSpecialChars(part) {
  return SPEC_CHAR_REGEX.test(part)
}

function shouldBeQuoted(part) {
  return !isQuoted(part) && (hasLeadingNumber(part) || hasSpecialChars(part))
}

const prefixes = {
  context: '$',
  value: '.'
};
class Reference {
  constructor(key, options = {}) {
    if (typeof key !== 'string') throw new TypeError('ref must be a string, got: ' + key);
    this.key = key.trim();
    if (key === '') throw new TypeError('ref must be a non-empty string');
    this.isContext = this.key[0] === prefixes.context;
    this.isValue = this.key[0] === prefixes.value;
    this.isSibling = !this.isContext && !this.isValue;
    let prefix = this.isContext ? prefixes.context : this.isValue ? prefixes.value : '';
    this.path = this.key.slice(prefix.length);
    this.getter = this.path && propertyExpr.getter(this.path, true);
    this.map = options.map;
  }

  getValue(value, parent, context) {
    let result = this.isContext ? context : this.isValue ? value : parent;
    if (this.getter) result = this.getter(result || {});
    if (this.map) result = this.map(result);
    return result;
  }
  /**
   *
   * @param {*} value
   * @param {Object} options
   * @param {Object=} options.context
   * @param {Object=} options.parent
   */


  cast(value, options) {
    return this.getValue(value, options == null ? void 0 : options.parent, options == null ? void 0 : options.context);
  }

  resolve() {
    return this;
  }

  describe() {
    return {
      type: 'ref',
      key: this.key
    };
  }

  toString() {
    return `Ref(${this.key})`;
  }

  static isRef(value) {
    return value && value.__isYupRef;
  }

} // @ts-ignore

Reference.prototype.__isYupRef = true;

function _extends$2() { _extends$2 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2.apply(this, arguments); }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function createValidation(config) {
  function validate(_ref, cb) {
    let {
      value,
      path = '',
      label,
      options,
      originalValue,
      sync
    } = _ref,
        rest = _objectWithoutPropertiesLoose(_ref, ["value", "path", "label", "options", "originalValue", "sync"]);

    const {
      name,
      test,
      params,
      message
    } = config;
    let {
      parent,
      context
    } = options;

    function resolve(item) {
      return Reference.isRef(item) ? item.getValue(value, parent, context) : item;
    }

    function createError(overrides = {}) {
      const nextParams = mapValues_1(_extends$2({
        value,
        originalValue,
        label,
        path: overrides.path || path
      }, params, overrides.params), resolve);
      const error = new ValidationError(ValidationError.formatError(overrides.message || message, nextParams), value, nextParams.path, overrides.type || name);
      error.params = nextParams;
      return error;
    }

    let ctx = _extends$2({
      path,
      parent,
      type: name,
      createError,
      resolve,
      options,
      originalValue
    }, rest);

    if (!sync) {
      try {
        Promise.resolve(test.call(ctx, value, ctx)).then(validOrError => {
          if (ValidationError.isError(validOrError)) cb(validOrError);else if (!validOrError) cb(createError());else cb(null, validOrError);
        });
      } catch (err) {
        cb(err);
      }

      return;
    }

    let result;

    try {
      var _ref2;

      result = test.call(ctx, value, ctx);

      if (typeof ((_ref2 = result) == null ? void 0 : _ref2.then) === 'function') {
        throw new Error(`Validation test of type: "${ctx.type}" returned a Promise during a synchronous validate. ` + `This test will finish after the validate call has returned`);
      }
    } catch (err) {
      cb(err);
      return;
    }

    if (ValidationError.isError(result)) cb(result);else if (!result) cb(createError());else cb(null, result);
  }

  validate.OPTIONS = config;
  return validate;
}

let trim = part => part.substr(0, part.length - 1).substr(1);

function getIn(schema, path, value, context = value) {
  let parent, lastPart, lastPartDebug; // root path: ''

  if (!path) return {
    parent,
    parentPath: path,
    schema
  };
  propertyExpr.forEach(path, (_part, isBracket, isArray) => {
    let part = isBracket ? trim(_part) : _part;
    schema = schema.resolve({
      context,
      parent,
      value
    });

    if (schema.innerType) {
      let idx = isArray ? parseInt(part, 10) : 0;

      if (value && idx >= value.length) {
        throw new Error(`Yup.reach cannot resolve an array item at index: ${_part}, in the path: ${path}. ` + `because there is no value at that index. `);
      }

      parent = value;
      value = value && value[idx];
      schema = schema.innerType;
    } // sometimes the array index part of a path doesn't exist: "nested.arr.child"
    // in these cases the current part is the next schema and should be processed
    // in this iteration. For cases where the index signature is included this
    // check will fail and we'll handle the `child` part on the next iteration like normal


    if (!isArray) {
      if (!schema.fields || !schema.fields[part]) throw new Error(`The schema does not contain the path: ${path}. ` + `(failed at: ${lastPartDebug} which is a type: "${schema._type}")`);
      parent = value;
      value = value && value[part];
      schema = schema.fields[part];
    }

    lastPart = part;
    lastPartDebug = isBracket ? '[' + _part + ']' : '.' + _part;
  });
  return {
    schema,
    parent,
    parentPath: lastPart
  };
}

class ReferenceSet {
  constructor() {
    this.list = new Set();
    this.refs = new Map();
  }

  get size() {
    return this.list.size + this.refs.size;
  }

  describe() {
    const description = [];

    for (const item of this.list) description.push(item);

    for (const [, ref] of this.refs) description.push(ref.describe());

    return description;
  }

  toArray() {
    return Array.from(this.list).concat(Array.from(this.refs.values()));
  }

  add(value) {
    Reference.isRef(value) ? this.refs.set(value.key, value) : this.list.add(value);
  }

  delete(value) {
    Reference.isRef(value) ? this.refs.delete(value.key) : this.list.delete(value);
  }

  has(value, resolve) {
    if (this.list.has(value)) return true;
    let item,
        values = this.refs.values();

    while (item = values.next(), !item.done) if (resolve(item.value) === value) return true;

    return false;
  }

  clone() {
    const next = new ReferenceSet();
    next.list = new Set(this.list);
    next.refs = new Map(this.refs);
    return next;
  }

  merge(newItems, removeItems) {
    const next = this.clone();
    newItems.list.forEach(value => next.add(value));
    newItems.refs.forEach(value => next.add(value));
    removeItems.list.forEach(value => next.delete(value));
    removeItems.refs.forEach(value => next.delete(value));
    return next;
  }

}

function _extends$1() { _extends$1 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1.apply(this, arguments); }
class BaseSchema {
  constructor(options) {
    this.deps = [];
    this.conditions = [];
    this._whitelist = new ReferenceSet();
    this._blacklist = new ReferenceSet();
    this.exclusiveTests = Object.create(null);
    this.tests = [];
    this.transforms = [];
    this.withMutation(() => {
      this.typeError(mixed.notType);
    });
    this.type = (options == null ? void 0 : options.type) || 'mixed';
    this.spec = _extends$1({
      strip: false,
      strict: false,
      abortEarly: true,
      recursive: true,
      nullable: false,
      presence: 'optional'
    }, options == null ? void 0 : options.spec);
  } // TODO: remove


  get _type() {
    return this.type;
  }

  _typeCheck(_value) {
    return true;
  }

  clone(spec) {
    if (this._mutate) {
      if (spec) Object.assign(this.spec, spec);
      return this;
    } // if the nested value is a schema we can skip cloning, since
    // they are already immutable


    const next = Object.create(Object.getPrototypeOf(this)); // @ts-expect-error this is readonly

    next.type = this.type;
    next._typeError = this._typeError;
    next._whitelistError = this._whitelistError;
    next._blacklistError = this._blacklistError;
    next._whitelist = this._whitelist.clone();
    next._blacklist = this._blacklist.clone();
    next.exclusiveTests = _extends$1({}, this.exclusiveTests); // @ts-expect-error this is readonly

    next.deps = [...this.deps];
    next.conditions = [...this.conditions];
    next.tests = [...this.tests];
    next.transforms = [...this.transforms];
    next.spec = clone(_extends$1({}, this.spec, spec));
    return next;
  }

  label(label) {
    var next = this.clone();
    next.spec.label = label;
    return next;
  }

  meta(...args) {
    if (args.length === 0) return this.spec.meta;
    let next = this.clone();
    next.spec.meta = Object.assign(next.spec.meta || {}, args[0]);
    return next;
  } // withContext<TContext extends AnyObject>(): BaseSchema<
  //   TCast,
  //   TContext,
  //   TOutput
  // > {
  //   return this as any;
  // }


  withMutation(fn) {
    let before = this._mutate;
    this._mutate = true;
    let result = fn(this);
    this._mutate = before;
    return result;
  }

  concat(schema) {
    if (!schema || schema === this) return this;
    if (schema.type !== this.type && this.type !== 'mixed') throw new TypeError(`You cannot \`concat()\` schema's of different types: ${this.type} and ${schema.type}`);
    let base = this;
    let combined = schema.clone();

    const mergedSpec = _extends$1({}, base.spec, combined.spec); // if (combined.spec.nullable === UNSET)
    //   mergedSpec.nullable = base.spec.nullable;
    // if (combined.spec.presence === UNSET)
    //   mergedSpec.presence = base.spec.presence;


    combined.spec = mergedSpec;
    combined._typeError || (combined._typeError = base._typeError);
    combined._whitelistError || (combined._whitelistError = base._whitelistError);
    combined._blacklistError || (combined._blacklistError = base._blacklistError); // manually merge the blacklist/whitelist (the other `schema` takes
    // precedence in case of conflicts)

    combined._whitelist = base._whitelist.merge(schema._whitelist, schema._blacklist);
    combined._blacklist = base._blacklist.merge(schema._blacklist, schema._whitelist); // start with the current tests

    combined.tests = base.tests;
    combined.exclusiveTests = base.exclusiveTests; // manually add the new tests to ensure
    // the deduping logic is consistent

    combined.withMutation(next => {
      schema.tests.forEach(fn => {
        next.test(fn.OPTIONS);
      });
    });
    return combined;
  }

  isType(v) {
    if (this.spec.nullable && v === null) return true;
    return this._typeCheck(v);
  }

  resolve(options) {
    let schema = this;

    if (schema.conditions.length) {
      let conditions = schema.conditions;
      schema = schema.clone();
      schema.conditions = [];
      schema = conditions.reduce((schema, condition) => condition.resolve(schema, options), schema);
      schema = schema.resolve(options);
    }

    return schema;
  }
  /**
   *
   * @param {*} value
   * @param {Object} options
   * @param {*=} options.parent
   * @param {*=} options.context
   */


  cast(value, options = {}) {
    let resolvedSchema = this.resolve(_extends$1({
      value
    }, options));

    let result = resolvedSchema._cast(value, options);

    if (value !== undefined && options.assert !== false && resolvedSchema.isType(result) !== true) {
      let formattedValue = printValue(value);
      let formattedResult = printValue(result);
      throw new TypeError(`The value of ${options.path || 'field'} could not be cast to a value ` + `that satisfies the schema type: "${resolvedSchema._type}". \n\n` + `attempted value: ${formattedValue} \n` + (formattedResult !== formattedValue ? `result of cast: ${formattedResult}` : ''));
    }

    return result;
  }

  _cast(rawValue, _options) {
    let value = rawValue === undefined ? rawValue : this.transforms.reduce((value, fn) => fn.call(this, value, rawValue, this), rawValue);

    if (value === undefined) {
      value = this.getDefault();
    }

    return value;
  }

  _validate(_value, options = {}, cb) {
    let {
      sync,
      path,
      from = [],
      originalValue = _value,
      strict = this.spec.strict,
      abortEarly = this.spec.abortEarly
    } = options;
    let value = _value;

    if (!strict) {
      // this._validating = true;
      value = this._cast(value, _extends$1({
        assert: false
      }, options)); // this._validating = false;
    } // value is cast, we can check if it meets type requirements


    let args = {
      value,
      path,
      options,
      originalValue,
      schema: this,
      label: this.spec.label,
      sync,
      from
    };
    let initialTests = [];
    if (this._typeError) initialTests.push(this._typeError);
    if (this._whitelistError) initialTests.push(this._whitelistError);
    if (this._blacklistError) initialTests.push(this._blacklistError);
    runTests({
      args,
      value,
      path,
      sync,
      tests: initialTests,
      endEarly: abortEarly
    }, err => {
      if (err) return void cb(err, value);
      runTests({
        tests: this.tests,
        args,
        path,
        sync,
        value,
        endEarly: abortEarly
      }, cb);
    });
  }

  validate(value, options, maybeCb) {
    let schema = this.resolve(_extends$1({}, options, {
      value
    })); // callback case is for nested validations

    return typeof maybeCb === 'function' ? schema._validate(value, options, maybeCb) : new Promise((resolve, reject) => schema._validate(value, options, (err, value) => {
      if (err) reject(err);else resolve(value);
    }));
  }

  validateSync(value, options) {
    let schema = this.resolve(_extends$1({}, options, {
      value
    }));
    let result;

    schema._validate(value, _extends$1({}, options, {
      sync: true
    }), (err, value) => {
      if (err) throw err;
      result = value;
    });

    return result;
  }

  isValid(value, options) {
    return this.validate(value, options).then(() => true, err => {
      if (ValidationError.isError(err)) return false;
      throw err;
    });
  }

  isValidSync(value, options) {
    try {
      this.validateSync(value, options);
      return true;
    } catch (err) {
      if (ValidationError.isError(err)) return false;
      throw err;
    }
  }

  _getDefault() {
    let defaultValue = this.spec.default;

    if (defaultValue == null) {
      return defaultValue;
    }

    return typeof defaultValue === 'function' ? defaultValue.call(this) : clone(defaultValue);
  }

  getDefault(options) {
    let schema = this.resolve(options || {});
    return schema._getDefault();
  }

  default(def) {
    if (arguments.length === 0) {
      return this._getDefault();
    }

    let next = this.clone({
      default: def
    });
    return next;
  }

  strict(isStrict = true) {
    var next = this.clone();
    next.spec.strict = isStrict;
    return next;
  }

  _isPresent(value) {
    return value != null;
  }

  defined(message = mixed.defined) {
    return this.test({
      message,
      name: 'defined',
      exclusive: true,

      test(value) {
        return value !== undefined;
      }

    });
  }

  required(message = mixed.required) {
    return this.clone({
      presence: 'required'
    }).withMutation(s => s.test({
      message,
      name: 'required',
      exclusive: true,

      test(value) {
        return this.schema._isPresent(value);
      }

    }));
  }

  notRequired() {
    var next = this.clone({
      presence: 'optional'
    });
    next.tests = next.tests.filter(test => test.OPTIONS.name !== 'required');
    return next;
  }

  nullable(isNullable = true) {
    var next = this.clone({
      nullable: isNullable !== false
    });
    return next;
  }

  transform(fn) {
    var next = this.clone();
    next.transforms.push(fn);
    return next;
  }
  /**
   * Adds a test function to the schema's queue of tests.
   * tests can be exclusive or non-exclusive.
   *
   * - exclusive tests, will replace any existing tests of the same name.
   * - non-exclusive: can be stacked
   *
   * If a non-exclusive test is added to a schema with an exclusive test of the same name
   * the exclusive test is removed and further tests of the same name will be stacked.
   *
   * If an exclusive test is added to a schema with non-exclusive tests of the same name
   * the previous tests are removed and further tests of the same name will replace each other.
   */


  test(...args) {
    let opts;

    if (args.length === 1) {
      if (typeof args[0] === 'function') {
        opts = {
          test: args[0]
        };
      } else {
        opts = args[0];
      }
    } else if (args.length === 2) {
      opts = {
        name: args[0],
        test: args[1]
      };
    } else {
      opts = {
        name: args[0],
        message: args[1],
        test: args[2]
      };
    }

    if (opts.message === undefined) opts.message = mixed.default;
    if (typeof opts.test !== 'function') throw new TypeError('`test` is a required parameters');
    let next = this.clone();
    let validate = createValidation(opts);
    let isExclusive = opts.exclusive || opts.name && next.exclusiveTests[opts.name] === true;

    if (opts.exclusive) {
      if (!opts.name) throw new TypeError('Exclusive tests must provide a unique `name` identifying the test');
    }

    if (opts.name) next.exclusiveTests[opts.name] = !!opts.exclusive;
    next.tests = next.tests.filter(fn => {
      if (fn.OPTIONS.name === opts.name) {
        if (isExclusive) return false;
        if (fn.OPTIONS.test === validate.OPTIONS.test) return false;
      }

      return true;
    });
    next.tests.push(validate);
    return next;
  }

  when(keys, options) {
    if (!Array.isArray(keys) && typeof keys !== 'string') {
      options = keys;
      keys = '.';
    }

    let next = this.clone();
    let deps = toArray(keys).map(key => new Reference(key));
    deps.forEach(dep => {
      // @ts-ignore
      if (dep.isSibling) next.deps.push(dep.key);
    });
    next.conditions.push(new Condition(deps, options));
    return next;
  }

  typeError(message) {
    var next = this.clone();
    next._typeError = createValidation({
      message,
      name: 'typeError',

      test(value) {
        if (value !== undefined && !this.schema.isType(value)) return this.createError({
          params: {
            type: this.schema._type
          }
        });
        return true;
      }

    });
    return next;
  }

  oneOf(enums, message = mixed.oneOf) {
    var next = this.clone();
    enums.forEach(val => {
      next._whitelist.add(val);

      next._blacklist.delete(val);
    });
    next._whitelistError = createValidation({
      message,
      name: 'oneOf',

      test(value) {
        if (value === undefined) return true;
        let valids = this.schema._whitelist;
        return valids.has(value, this.resolve) ? true : this.createError({
          params: {
            values: valids.toArray().join(', ')
          }
        });
      }

    });
    return next;
  }

  notOneOf(enums, message = mixed.notOneOf) {
    var next = this.clone();
    enums.forEach(val => {
      next._blacklist.add(val);

      next._whitelist.delete(val);
    });
    next._blacklistError = createValidation({
      message,
      name: 'notOneOf',

      test(value) {
        let invalids = this.schema._blacklist;
        if (invalids.has(value, this.resolve)) return this.createError({
          params: {
            values: invalids.toArray().join(', ')
          }
        });
        return true;
      }

    });
    return next;
  }

  strip(strip = true) {
    let next = this.clone();
    next.spec.strip = strip;
    return next;
  }

  describe() {
    const next = this.clone();
    const {
      label,
      meta
    } = next.spec;
    const description = {
      meta,
      label,
      type: next.type,
      oneOf: next._whitelist.describe(),
      notOneOf: next._blacklist.describe(),
      tests: next.tests.map(fn => ({
        name: fn.OPTIONS.name,
        params: fn.OPTIONS.params
      })).filter((n, idx, list) => list.findIndex(c => c.name === n.name) === idx)
    };
    return description;
  }

}
// @ts-expect-error
BaseSchema.prototype.__isYupSchema__ = true;

for (const method of ['validate', 'validateSync']) BaseSchema.prototype[`${method}At`] = function (path, value, options = {}) {
  const {
    parent,
    parentPath,
    schema
  } = getIn(this, path, value, options.context);
  return schema[method](parent && parent[parentPath], _extends$1({}, options, {
    parent,
    path
  }));
};

for (const alias of ['equals', 'is']) BaseSchema.prototype[alias] = BaseSchema.prototype.oneOf;

for (const alias of ['not', 'nope']) BaseSchema.prototype[alias] = BaseSchema.prototype.notOneOf;

BaseSchema.prototype.optional = BaseSchema.prototype.notRequired;

({}).toString();
// String Interfaces
//

/**
 * A specialized version of `_.reduce` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {*} [accumulator] The initial value.
 * @param {boolean} [initAccum] Specify using the first element of `array` as
 *  the initial value.
 * @returns {*} Returns the accumulated value.
 */
function arrayReduce(array, iteratee, accumulator, initAccum) {
  var index = -1,
      length = array == null ? 0 : array.length;

  if (initAccum && length) {
    accumulator = array[++index];
  }
  while (++index < length) {
    accumulator = iteratee(accumulator, array[index], index, array);
  }
  return accumulator;
}

var _arrayReduce = arrayReduce;

/**
 * The base implementation of `_.propertyOf` without support for deep paths.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Function} Returns the new accessor function.
 */
function basePropertyOf(object) {
  return function(key) {
    return object == null ? undefined : object[key];
  };
}

var _basePropertyOf = basePropertyOf;

/** Used to map Latin Unicode letters to basic Latin letters. */
var deburredLetters = {
  // Latin-1 Supplement block.
  '\xc0': 'A',  '\xc1': 'A', '\xc2': 'A', '\xc3': 'A', '\xc4': 'A', '\xc5': 'A',
  '\xe0': 'a',  '\xe1': 'a', '\xe2': 'a', '\xe3': 'a', '\xe4': 'a', '\xe5': 'a',
  '\xc7': 'C',  '\xe7': 'c',
  '\xd0': 'D',  '\xf0': 'd',
  '\xc8': 'E',  '\xc9': 'E', '\xca': 'E', '\xcb': 'E',
  '\xe8': 'e',  '\xe9': 'e', '\xea': 'e', '\xeb': 'e',
  '\xcc': 'I',  '\xcd': 'I', '\xce': 'I', '\xcf': 'I',
  '\xec': 'i',  '\xed': 'i', '\xee': 'i', '\xef': 'i',
  '\xd1': 'N',  '\xf1': 'n',
  '\xd2': 'O',  '\xd3': 'O', '\xd4': 'O', '\xd5': 'O', '\xd6': 'O', '\xd8': 'O',
  '\xf2': 'o',  '\xf3': 'o', '\xf4': 'o', '\xf5': 'o', '\xf6': 'o', '\xf8': 'o',
  '\xd9': 'U',  '\xda': 'U', '\xdb': 'U', '\xdc': 'U',
  '\xf9': 'u',  '\xfa': 'u', '\xfb': 'u', '\xfc': 'u',
  '\xdd': 'Y',  '\xfd': 'y', '\xff': 'y',
  '\xc6': 'Ae', '\xe6': 'ae',
  '\xde': 'Th', '\xfe': 'th',
  '\xdf': 'ss',
  // Latin Extended-A block.
  '\u0100': 'A',  '\u0102': 'A', '\u0104': 'A',
  '\u0101': 'a',  '\u0103': 'a', '\u0105': 'a',
  '\u0106': 'C',  '\u0108': 'C', '\u010a': 'C', '\u010c': 'C',
  '\u0107': 'c',  '\u0109': 'c', '\u010b': 'c', '\u010d': 'c',
  '\u010e': 'D',  '\u0110': 'D', '\u010f': 'd', '\u0111': 'd',
  '\u0112': 'E',  '\u0114': 'E', '\u0116': 'E', '\u0118': 'E', '\u011a': 'E',
  '\u0113': 'e',  '\u0115': 'e', '\u0117': 'e', '\u0119': 'e', '\u011b': 'e',
  '\u011c': 'G',  '\u011e': 'G', '\u0120': 'G', '\u0122': 'G',
  '\u011d': 'g',  '\u011f': 'g', '\u0121': 'g', '\u0123': 'g',
  '\u0124': 'H',  '\u0126': 'H', '\u0125': 'h', '\u0127': 'h',
  '\u0128': 'I',  '\u012a': 'I', '\u012c': 'I', '\u012e': 'I', '\u0130': 'I',
  '\u0129': 'i',  '\u012b': 'i', '\u012d': 'i', '\u012f': 'i', '\u0131': 'i',
  '\u0134': 'J',  '\u0135': 'j',
  '\u0136': 'K',  '\u0137': 'k', '\u0138': 'k',
  '\u0139': 'L',  '\u013b': 'L', '\u013d': 'L', '\u013f': 'L', '\u0141': 'L',
  '\u013a': 'l',  '\u013c': 'l', '\u013e': 'l', '\u0140': 'l', '\u0142': 'l',
  '\u0143': 'N',  '\u0145': 'N', '\u0147': 'N', '\u014a': 'N',
  '\u0144': 'n',  '\u0146': 'n', '\u0148': 'n', '\u014b': 'n',
  '\u014c': 'O',  '\u014e': 'O', '\u0150': 'O',
  '\u014d': 'o',  '\u014f': 'o', '\u0151': 'o',
  '\u0154': 'R',  '\u0156': 'R', '\u0158': 'R',
  '\u0155': 'r',  '\u0157': 'r', '\u0159': 'r',
  '\u015a': 'S',  '\u015c': 'S', '\u015e': 'S', '\u0160': 'S',
  '\u015b': 's',  '\u015d': 's', '\u015f': 's', '\u0161': 's',
  '\u0162': 'T',  '\u0164': 'T', '\u0166': 'T',
  '\u0163': 't',  '\u0165': 't', '\u0167': 't',
  '\u0168': 'U',  '\u016a': 'U', '\u016c': 'U', '\u016e': 'U', '\u0170': 'U', '\u0172': 'U',
  '\u0169': 'u',  '\u016b': 'u', '\u016d': 'u', '\u016f': 'u', '\u0171': 'u', '\u0173': 'u',
  '\u0174': 'W',  '\u0175': 'w',
  '\u0176': 'Y',  '\u0177': 'y', '\u0178': 'Y',
  '\u0179': 'Z',  '\u017b': 'Z', '\u017d': 'Z',
  '\u017a': 'z',  '\u017c': 'z', '\u017e': 'z',
  '\u0132': 'IJ', '\u0133': 'ij',
  '\u0152': 'Oe', '\u0153': 'oe',
  '\u0149': "'n", '\u017f': 's'
};

/**
 * Used by `_.deburr` to convert Latin-1 Supplement and Latin Extended-A
 * letters to basic Latin letters.
 *
 * @private
 * @param {string} letter The matched letter to deburr.
 * @returns {string} Returns the deburred letter.
 */
var deburrLetter = _basePropertyOf(deburredLetters);

var _deburrLetter = deburrLetter;

/** Used to match Latin Unicode letters (excluding mathematical operators). */
var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;

/** Used to compose unicode character classes. */
var rsComboMarksRange$3 = '\\u0300-\\u036f',
    reComboHalfMarksRange$3 = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange$3 = '\\u20d0-\\u20ff',
    rsComboRange$3 = rsComboMarksRange$3 + reComboHalfMarksRange$3 + rsComboSymbolsRange$3;

/** Used to compose unicode capture groups. */
var rsCombo$2 = '[' + rsComboRange$3 + ']';

/**
 * Used to match [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks) and
 * [combining diacritical marks for symbols](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks_for_Symbols).
 */
var reComboMark = RegExp(rsCombo$2, 'g');

/**
 * Deburrs `string` by converting
 * [Latin-1 Supplement](https://en.wikipedia.org/wiki/Latin-1_Supplement_(Unicode_block)#Character_table)
 * and [Latin Extended-A](https://en.wikipedia.org/wiki/Latin_Extended-A)
 * letters to basic Latin letters and removing
 * [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks).
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to deburr.
 * @returns {string} Returns the deburred string.
 * @example
 *
 * _.deburr('déjà vu');
 * // => 'deja vu'
 */
function deburr(string) {
  string = toString_1(string);
  return string && string.replace(reLatin, _deburrLetter).replace(reComboMark, '');
}

var deburr_1 = deburr;

/** Used to match words composed of alphanumeric characters. */
var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;

/**
 * Splits an ASCII `string` into an array of its words.
 *
 * @private
 * @param {string} The string to inspect.
 * @returns {Array} Returns the words of `string`.
 */
function asciiWords(string) {
  return string.match(reAsciiWord) || [];
}

var _asciiWords = asciiWords;

/** Used to detect strings that need a more robust regexp to match words. */
var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;

/**
 * Checks if `string` contains a word composed of Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a word is found, else `false`.
 */
function hasUnicodeWord(string) {
  return reHasUnicodeWord.test(string);
}

var _hasUnicodeWord = hasUnicodeWord;

/** Used to compose unicode character classes. */
var rsAstralRange$2 = '\\ud800-\\udfff',
    rsComboMarksRange$2 = '\\u0300-\\u036f',
    reComboHalfMarksRange$2 = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange$2 = '\\u20d0-\\u20ff',
    rsComboRange$2 = rsComboMarksRange$2 + reComboHalfMarksRange$2 + rsComboSymbolsRange$2,
    rsDingbatRange = '\\u2700-\\u27bf',
    rsLowerRange = 'a-z\\xdf-\\xf6\\xf8-\\xff',
    rsMathOpRange = '\\xac\\xb1\\xd7\\xf7',
    rsNonCharRange = '\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf',
    rsPunctuationRange = '\\u2000-\\u206f',
    rsSpaceRange = ' \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000',
    rsUpperRange = 'A-Z\\xc0-\\xd6\\xd8-\\xde',
    rsVarRange$2 = '\\ufe0e\\ufe0f',
    rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;

/** Used to compose unicode capture groups. */
var rsApos$1 = "['\u2019]",
    rsBreak = '[' + rsBreakRange + ']',
    rsCombo$1 = '[' + rsComboRange$2 + ']',
    rsDigits = '\\d+',
    rsDingbat = '[' + rsDingbatRange + ']',
    rsLower = '[' + rsLowerRange + ']',
    rsMisc = '[^' + rsAstralRange$2 + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + ']',
    rsFitz$1 = '\\ud83c[\\udffb-\\udfff]',
    rsModifier$1 = '(?:' + rsCombo$1 + '|' + rsFitz$1 + ')',
    rsNonAstral$1 = '[^' + rsAstralRange$2 + ']',
    rsRegional$1 = '(?:\\ud83c[\\udde6-\\uddff]){2}',
    rsSurrPair$1 = '[\\ud800-\\udbff][\\udc00-\\udfff]',
    rsUpper = '[' + rsUpperRange + ']',
    rsZWJ$2 = '\\u200d';

/** Used to compose unicode regexes. */
var rsMiscLower = '(?:' + rsLower + '|' + rsMisc + ')',
    rsMiscUpper = '(?:' + rsUpper + '|' + rsMisc + ')',
    rsOptContrLower = '(?:' + rsApos$1 + '(?:d|ll|m|re|s|t|ve))?',
    rsOptContrUpper = '(?:' + rsApos$1 + '(?:D|LL|M|RE|S|T|VE))?',
    reOptMod$1 = rsModifier$1 + '?',
    rsOptVar$1 = '[' + rsVarRange$2 + ']?',
    rsOptJoin$1 = '(?:' + rsZWJ$2 + '(?:' + [rsNonAstral$1, rsRegional$1, rsSurrPair$1].join('|') + ')' + rsOptVar$1 + reOptMod$1 + ')*',
    rsOrdLower = '\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])',
    rsOrdUpper = '\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])',
    rsSeq$1 = rsOptVar$1 + reOptMod$1 + rsOptJoin$1,
    rsEmoji = '(?:' + [rsDingbat, rsRegional$1, rsSurrPair$1].join('|') + ')' + rsSeq$1;

/** Used to match complex or compound words. */
var reUnicodeWord = RegExp([
  rsUpper + '?' + rsLower + '+' + rsOptContrLower + '(?=' + [rsBreak, rsUpper, '$'].join('|') + ')',
  rsMiscUpper + '+' + rsOptContrUpper + '(?=' + [rsBreak, rsUpper + rsMiscLower, '$'].join('|') + ')',
  rsUpper + '?' + rsMiscLower + '+' + rsOptContrLower,
  rsUpper + '+' + rsOptContrUpper,
  rsOrdUpper,
  rsOrdLower,
  rsDigits,
  rsEmoji
].join('|'), 'g');

/**
 * Splits a Unicode `string` into an array of its words.
 *
 * @private
 * @param {string} The string to inspect.
 * @returns {Array} Returns the words of `string`.
 */
function unicodeWords(string) {
  return string.match(reUnicodeWord) || [];
}

var _unicodeWords = unicodeWords;

/**
 * Splits `string` into an array of its words.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to inspect.
 * @param {RegExp|string} [pattern] The pattern to match words.
 * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
 * @returns {Array} Returns the words of `string`.
 * @example
 *
 * _.words('fred, barney, & pebbles');
 * // => ['fred', 'barney', 'pebbles']
 *
 * _.words('fred, barney, & pebbles', /[^, ]+/g);
 * // => ['fred', 'barney', '&', 'pebbles']
 */
function words(string, pattern, guard) {
  string = toString_1(string);
  pattern = guard ? undefined : pattern;

  if (pattern === undefined) {
    return _hasUnicodeWord(string) ? _unicodeWords(string) : _asciiWords(string);
  }
  return string.match(pattern) || [];
}

var words_1 = words;

/** Used to compose unicode capture groups. */
var rsApos = "['\u2019]";

/** Used to match apostrophes. */
var reApos = RegExp(rsApos, 'g');

/**
 * Creates a function like `_.camelCase`.
 *
 * @private
 * @param {Function} callback The function to combine each word.
 * @returns {Function} Returns the new compounder function.
 */
function createCompounder(callback) {
  return function(string) {
    return _arrayReduce(words_1(deburr_1(string).replace(reApos, '')), callback, '');
  };
}

var _createCompounder = createCompounder;

/**
 * Converts `string` to
 * [snake case](https://en.wikipedia.org/wiki/Snake_case).
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to convert.
 * @returns {string} Returns the snake cased string.
 * @example
 *
 * _.snakeCase('Foo Bar');
 * // => 'foo_bar'
 *
 * _.snakeCase('fooBar');
 * // => 'foo_bar'
 *
 * _.snakeCase('--FOO-BAR--');
 * // => 'foo_bar'
 */
var snakeCase = _createCompounder(function(result, word, index) {
  return result + (index ? '_' : '') + word.toLowerCase();
});

var snakeCase_1 = snakeCase;

/**
 * The base implementation of `_.slice` without an iteratee call guard.
 *
 * @private
 * @param {Array} array The array to slice.
 * @param {number} [start=0] The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the slice of `array`.
 */
function baseSlice(array, start, end) {
  var index = -1,
      length = array.length;

  if (start < 0) {
    start = -start > length ? 0 : (length + start);
  }
  end = end > length ? length : end;
  if (end < 0) {
    end += length;
  }
  length = start > end ? 0 : ((end - start) >>> 0);
  start >>>= 0;

  var result = Array(length);
  while (++index < length) {
    result[index] = array[index + start];
  }
  return result;
}

var _baseSlice = baseSlice;

/**
 * Casts `array` to a slice if it's needed.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {number} start The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the cast slice.
 */
function castSlice(array, start, end) {
  var length = array.length;
  end = end === undefined ? length : end;
  return (!start && end >= length) ? array : _baseSlice(array, start, end);
}

var _castSlice = castSlice;

/** Used to compose unicode character classes. */
var rsAstralRange$1 = '\\ud800-\\udfff',
    rsComboMarksRange$1 = '\\u0300-\\u036f',
    reComboHalfMarksRange$1 = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange$1 = '\\u20d0-\\u20ff',
    rsComboRange$1 = rsComboMarksRange$1 + reComboHalfMarksRange$1 + rsComboSymbolsRange$1,
    rsVarRange$1 = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsZWJ$1 = '\\u200d';

/** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
var reHasUnicode = RegExp('[' + rsZWJ$1 + rsAstralRange$1  + rsComboRange$1 + rsVarRange$1 + ']');

/**
 * Checks if `string` contains Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a symbol is found, else `false`.
 */
function hasUnicode(string) {
  return reHasUnicode.test(string);
}

var _hasUnicode = hasUnicode;

/**
 * Converts an ASCII `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function asciiToArray(string) {
  return string.split('');
}

var _asciiToArray = asciiToArray;

/** Used to compose unicode character classes. */
var rsAstralRange = '\\ud800-\\udfff',
    rsComboMarksRange = '\\u0300-\\u036f',
    reComboHalfMarksRange = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange = '\\u20d0-\\u20ff',
    rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
    rsVarRange = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsAstral = '[' + rsAstralRange + ']',
    rsCombo = '[' + rsComboRange + ']',
    rsFitz = '\\ud83c[\\udffb-\\udfff]',
    rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
    rsNonAstral = '[^' + rsAstralRange + ']',
    rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
    rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
    rsZWJ = '\\u200d';

/** Used to compose unicode regexes. */
var reOptMod = rsModifier + '?',
    rsOptVar = '[' + rsVarRange + ']?',
    rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
    rsSeq = rsOptVar + reOptMod + rsOptJoin,
    rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

/** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

/**
 * Converts a Unicode `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function unicodeToArray(string) {
  return string.match(reUnicode) || [];
}

var _unicodeToArray = unicodeToArray;

/**
 * Converts `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function stringToArray(string) {
  return _hasUnicode(string)
    ? _unicodeToArray(string)
    : _asciiToArray(string);
}

var _stringToArray = stringToArray;

/**
 * Creates a function like `_.lowerFirst`.
 *
 * @private
 * @param {string} methodName The name of the `String` case method to use.
 * @returns {Function} Returns the new case function.
 */
function createCaseFirst(methodName) {
  return function(string) {
    string = toString_1(string);

    var strSymbols = _hasUnicode(string)
      ? _stringToArray(string)
      : undefined;

    var chr = strSymbols
      ? strSymbols[0]
      : string.charAt(0);

    var trailing = strSymbols
      ? _castSlice(strSymbols, 1).join('')
      : string.slice(1);

    return chr[methodName]() + trailing;
  };
}

var _createCaseFirst = createCaseFirst;

/**
 * Converts the first character of `string` to upper case.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category String
 * @param {string} [string=''] The string to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.upperFirst('fred');
 * // => 'Fred'
 *
 * _.upperFirst('FRED');
 * // => 'FRED'
 */
var upperFirst = _createCaseFirst('toUpperCase');

var upperFirst_1 = upperFirst;

/**
 * Converts the first character of `string` to upper case and the remaining
 * to lower case.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to capitalize.
 * @returns {string} Returns the capitalized string.
 * @example
 *
 * _.capitalize('FRED');
 * // => 'Fred'
 */
function capitalize(string) {
  return upperFirst_1(toString_1(string).toLowerCase());
}

var capitalize_1 = capitalize;

/**
 * Converts `string` to [camel case](https://en.wikipedia.org/wiki/CamelCase).
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to convert.
 * @returns {string} Returns the camel cased string.
 * @example
 *
 * _.camelCase('Foo Bar');
 * // => 'fooBar'
 *
 * _.camelCase('--foo-bar--');
 * // => 'fooBar'
 *
 * _.camelCase('__FOO_BAR__');
 * // => 'fooBar'
 */
var camelCase = _createCompounder(function(result, word, index) {
  word = word.toLowerCase();
  return result + (index ? capitalize_1(word) : word);
});

var camelCase_1 = camelCase;

/**
 * The opposite of `_.mapValues`; this method creates an object with the
 * same values as `object` and keys generated by running each own enumerable
 * string keyed property of `object` thru `iteratee`. The iteratee is invoked
 * with three arguments: (value, key, object).
 *
 * @static
 * @memberOf _
 * @since 3.8.0
 * @category Object
 * @param {Object} object The object to iterate over.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @returns {Object} Returns the new mapped object.
 * @see _.mapValues
 * @example
 *
 * _.mapKeys({ 'a': 1, 'b': 2 }, function(value, key) {
 *   return key + value;
 * });
 * // => { 'a1': 1, 'b2': 2 }
 */
function mapKeys(object, iteratee) {
  var result = {};
  iteratee = _baseIteratee(iteratee);

  _baseForOwn(object, function(value, key, object) {
    _baseAssignValue(result, iteratee(value, key, object), value);
  });
  return result;
}

var mapKeys_1 = mapKeys;

/**
 * Topological sorting function
 *
 * @param {Array} edges
 * @returns {Array}
 */

var toposort_1 = function(edges) {
  return toposort(uniqueNodes(edges), edges)
};

var array = toposort;

function toposort(nodes, edges) {
  var cursor = nodes.length
    , sorted = new Array(cursor)
    , visited = {}
    , i = cursor
    // Better data structures make algorithm much faster.
    , outgoingEdges = makeOutgoingEdges(edges)
    , nodesHash = makeNodesHash(nodes);

  // check for unknown nodes
  edges.forEach(function(edge) {
    if (!nodesHash.has(edge[0]) || !nodesHash.has(edge[1])) {
      throw new Error('Unknown node. There is an unknown node in the supplied edges.')
    }
  });

  while (i--) {
    if (!visited[i]) visit(nodes[i], i, new Set());
  }

  return sorted

  function visit(node, i, predecessors) {
    if(predecessors.has(node)) {
      var nodeRep;
      try {
        nodeRep = ", node was:" + JSON.stringify(node);
      } catch(e) {
        nodeRep = "";
      }
      throw new Error('Cyclic dependency' + nodeRep)
    }

    if (!nodesHash.has(node)) {
      throw new Error('Found unknown node. Make sure to provided all involved nodes. Unknown node: '+JSON.stringify(node))
    }

    if (visited[i]) return;
    visited[i] = true;

    var outgoing = outgoingEdges.get(node) || new Set();
    outgoing = Array.from(outgoing);

    if (i = outgoing.length) {
      predecessors.add(node);
      do {
        var child = outgoing[--i];
        visit(child, nodesHash.get(child), predecessors);
      } while (i)
      predecessors.delete(node);
    }

    sorted[--cursor] = node;
  }
}

function uniqueNodes(arr){
  var res = new Set();
  for (var i = 0, len = arr.length; i < len; i++) {
    var edge = arr[i];
    res.add(edge[0]);
    res.add(edge[1]);
  }
  return Array.from(res)
}

function makeOutgoingEdges(arr){
  var edges = new Map();
  for (var i = 0, len = arr.length; i < len; i++) {
    var edge = arr[i];
    if (!edges.has(edge[0])) edges.set(edge[0], new Set());
    if (!edges.has(edge[1])) edges.set(edge[1], new Set());
    edges.get(edge[0]).add(edge[1]);
  }
  return edges
}

function makeNodesHash(arr){
  var res = new Map();
  for (var i = 0, len = arr.length; i < len; i++) {
    res.set(arr[i], i);
  }
  return res
}
toposort_1.array = array;

function sortFields(fields, excludes = []) {
  let edges = [];
  let nodes = [];

  function addNode(depPath, key) {
    var node = propertyExpr.split(depPath)[0];
    if (!~nodes.indexOf(node)) nodes.push(node);
    if (!~excludes.indexOf(`${key}-${node}`)) edges.push([key, node]);
  }

  for (const key in fields) if (has_1(fields, key)) {
    let value = fields[key];
    if (!~nodes.indexOf(key)) nodes.push(key);
    if (Reference.isRef(value) && value.isSibling) addNode(value.path, key);else if (isSchema(value) && 'deps' in value) value.deps.forEach(path => addNode(path, key));
  }

  return toposort_1.array(nodes, edges).reverse();
}

function findIndex(arr, err) {
  let idx = Infinity;
  arr.some((key, ii) => {
    var _err$path;

    if (((_err$path = err.path) == null ? void 0 : _err$path.indexOf(key)) !== -1) {
      idx = ii;
      return true;
    }
  });
  return idx;
}

function sortByKeyOrder(keys) {
  return (a, b) => {
    return findIndex(keys, a) - findIndex(keys, b);
  };
}

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

let isObject = obj => Object.prototype.toString.call(obj) === '[object Object]';

function unknown(ctx, value) {
  let known = Object.keys(ctx.fields);
  return Object.keys(value).filter(key => known.indexOf(key) === -1);
}

const defaultSort = sortByKeyOrder([]);
class ObjectSchema extends BaseSchema {
  constructor(spec) {
    super({
      type: 'object'
    });
    this.fields = Object.create(null);
    this._sortErrors = defaultSort;
    this._nodes = [];
    this._excludedEdges = [];
    this.withMutation(() => {
      this.transform(function coerce(value) {
        if (typeof value === 'string') {
          try {
            value = JSON.parse(value);
          } catch (err) {
            value = null;
          }
        }

        if (this.isType(value)) return value;
        return null;
      });

      if (spec) {
        this.shape(spec);
      }
    });
  }

  _typeCheck(value) {
    return isObject(value) || typeof value === 'function';
  }

  _cast(_value, options = {}) {
    var _options$stripUnknown;

    let value = super._cast(_value, options); //should ignore nulls here


    if (value === undefined) return this.getDefault();
    if (!this._typeCheck(value)) return value;
    let fields = this.fields;
    let strip = (_options$stripUnknown = options.stripUnknown) != null ? _options$stripUnknown : this.spec.noUnknown;

    let props = this._nodes.concat(Object.keys(value).filter(v => this._nodes.indexOf(v) === -1));

    let intermediateValue = {}; // is filled during the transform below

    let innerOptions = _extends({}, options, {
      parent: intermediateValue,
      __validating: options.__validating || false
    });

    let isChanged = false;

    for (const prop of props) {
      let field = fields[prop];
      let exists = has_1(value, prop);

      if (field) {
        let fieldValue;
        let inputValue = value[prop]; // safe to mutate since this is fired in sequence

        innerOptions.path = (options.path ? `${options.path}.` : '') + prop; // innerOptions.value = value[prop];

        field = field.resolve({
          value: inputValue,
          context: options.context,
          parent: intermediateValue
        });
        let fieldSpec = 'spec' in field ? field.spec : undefined;
        let strict = fieldSpec == null ? void 0 : fieldSpec.strict;

        if (fieldSpec == null ? void 0 : fieldSpec.strip) {
          isChanged = isChanged || prop in value;
          continue;
        }

        fieldValue = !options.__validating || !strict ? // TODO: use _cast, this is double resolving
        field.cast(value[prop], innerOptions) : value[prop];

        if (fieldValue !== undefined) {
          intermediateValue[prop] = fieldValue;
        }
      } else if (exists && !strip) {
        intermediateValue[prop] = value[prop];
      }

      if (intermediateValue[prop] !== value[prop]) {
        isChanged = true;
      }
    }

    return isChanged ? intermediateValue : value;
  }

  _validate(_value, opts = {}, callback) {
    let errors = [];
    let {
      sync,
      from = [],
      originalValue = _value,
      abortEarly = this.spec.abortEarly,
      recursive = this.spec.recursive
    } = opts;
    from = [{
      schema: this,
      value: originalValue
    }, ...from]; // this flag is needed for handling `strict` correctly in the context of
    // validation vs just casting. e.g strict() on a field is only used when validating

    opts.__validating = true;
    opts.originalValue = originalValue;
    opts.from = from;

    super._validate(_value, opts, (err, value) => {
      if (err) {
        if (!ValidationError.isError(err) || abortEarly) {
          return void callback(err, value);
        }

        errors.push(err);
      }

      if (!recursive || !isObject(value)) {
        callback(errors[0] || null, value);
        return;
      }

      originalValue = originalValue || value;

      let tests = this._nodes.map(key => (_, cb) => {
        let path = key.indexOf('.') === -1 ? (opts.path ? `${opts.path}.` : '') + key : `${opts.path || ''}["${key}"]`;
        let field = this.fields[key];

        if (field && 'validate' in field) {
          field.validate(value[key], _extends({}, opts, {
            // @ts-ignore
            path,
            from,
            // inner fields are always strict:
            // 1. this isn't strict so the casting will also have cast inner values
            // 2. this is strict in which case the nested values weren't cast either
            strict: true,
            parent: value,
            originalValue: originalValue[key]
          }), cb);
          return;
        }

        cb(null);
      });

      runTests({
        sync,
        tests,
        value,
        errors,
        endEarly: abortEarly,
        sort: this._sortErrors,
        path: opts.path
      }, callback);
    });
  }

  clone(spec) {
    const next = super.clone(spec);
    next.fields = _extends({}, this.fields);
    next._nodes = this._nodes;
    next._excludedEdges = this._excludedEdges;
    next._sortErrors = this._sortErrors;
    return next;
  }

  concat(schema) {
    let next = super.concat(schema);
    let nextFields = next.fields;

    for (let [field, schemaOrRef] of Object.entries(this.fields)) {
      const target = nextFields[field];

      if (target === undefined) {
        nextFields[field] = schemaOrRef;
      } else if (target instanceof BaseSchema && schemaOrRef instanceof BaseSchema) {
        nextFields[field] = schemaOrRef.concat(target);
      }
    }

    return next.withMutation(() => next.shape(nextFields));
  }

  getDefaultFromShape() {
    let dft = {};

    this._nodes.forEach(key => {
      const field = this.fields[key];
      dft[key] = 'default' in field ? field.getDefault() : undefined;
    });

    return dft;
  }

  _getDefault() {
    if ('default' in this.spec) {
      return super._getDefault();
    } // if there is no default set invent one


    if (!this._nodes.length) {
      return undefined;
    }

    return this.getDefaultFromShape();
  }

  shape(additions, excludes = []) {
    let next = this.clone();
    let fields = Object.assign(next.fields, additions);
    next.fields = fields;
    next._sortErrors = sortByKeyOrder(Object.keys(fields));

    if (excludes.length) {
      if (!Array.isArray(excludes[0])) excludes = [excludes];
      let keys = excludes.map(([first, second]) => `${first}-${second}`);
      next._excludedEdges = next._excludedEdges.concat(keys);
    }

    next._nodes = sortFields(fields, next._excludedEdges);
    return next;
  }

  pick(keys) {
    const picked = {};

    for (const key of keys) {
      if (this.fields[key]) picked[key] = this.fields[key];
    }

    return this.clone().withMutation(next => {
      next.fields = {};
      return next.shape(picked);
    });
  }

  omit(keys) {
    const next = this.clone();
    const fields = next.fields;
    next.fields = {};

    for (const key of keys) {
      delete fields[key];
    }

    return next.withMutation(() => next.shape(fields));
  }

  from(from, to, alias) {
    let fromGetter = propertyExpr.getter(from, true);
    return this.transform(obj => {
      if (obj == null) return obj;
      let newObj = obj;

      if (has_1(obj, from)) {
        newObj = _extends({}, obj);
        if (!alias) delete newObj[from];
        newObj[to] = fromGetter(obj);
      }

      return newObj;
    });
  }

  noUnknown(noAllow = true, message = object.noUnknown) {
    if (typeof noAllow === 'string') {
      message = noAllow;
      noAllow = true;
    }

    let next = this.test({
      name: 'noUnknown',
      exclusive: true,
      message: message,

      test(value) {
        if (value == null) return true;
        const unknownKeys = unknown(this.schema, value);
        return !noAllow || unknownKeys.length === 0 || this.createError({
          params: {
            unknown: unknownKeys.join(', ')
          }
        });
      }

    });
    next.spec.noUnknown = noAllow;
    return next;
  }

  unknown(allow = true, message = object.noUnknown) {
    return this.noUnknown(!allow, message);
  }

  transformKeys(fn) {
    return this.transform(obj => obj && mapKeys_1(obj, (_, key) => fn(key)));
  }

  camelCase() {
    return this.transformKeys(camelCase_1);
  }

  snakeCase() {
    return this.transformKeys(snakeCase_1);
  }

  constantCase() {
    return this.transformKeys(key => snakeCase_1(key).toUpperCase());
  }

  describe() {
    let base = super.describe();
    base.fields = mapValues_1(this.fields, value => value.describe());
    return base;
  }

}
function create(spec) {
  return new ObjectSchema(spec);
}
create.prototype = ObjectSchema.prototype;

// do not edit .js files directly - edit src/index.jst



var fastDeepEqual = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;

    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }



    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;

    for (i = length; i-- !== 0;)
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      var key = keys[i];

      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  // true if both NaN, false otherwise
  return a!==a && b!==b;
};

// The generic T type variable is the type of the field's value (the T in IFormField<T>).
// It is optional, and can either be inferred from the type of the initialValue or explicitly passed.
// example (explicit):
//   useFormField<string>('', ...)
//     -> returns IFormField<string>
// example (implicit):
//   useFormField('', ...)
//     -> also returns IFormField<string>
var useFormField = function (initialValue, schema, options) {
    if (options === void 0) { options = {}; }
    var _a = React__namespace.useState(initialValue), defaultValue = _a[0], setDefaultValue = _a[1]; // The value used on clear()
    var _b = React__namespace.useState(initialValue), cleanValue = _b[0], setCleanValue = _b[1]; // The value considered "unchanged", determines isDirty and used on revert()
    var _c = React__namespace.useState(initialValue), value = _c[0], setValue = _c[1]; // The actual value in the field
    var _d = React__namespace.useState(options.initialTouched || false), isTouched = _d[0], setIsTouched = _d[1];
    return {
        value: value,
        setValue: setValue,
        defaultValue: defaultValue,
        cleanValue: cleanValue,
        reinitialize: function (value) {
            setDefaultValue(value);
            setCleanValue(value);
            setValue(value);
        },
        prefill: function (value) {
            setCleanValue(value);
            setValue(value);
        },
        clear: function () {
            setValue(defaultValue);
            setIsTouched(options.initialTouched || false);
        },
        revert: function () {
            setValue(cleanValue);
            setIsTouched(options.initialTouched || false);
        },
        isDirty: !fastDeepEqual(value, cleanValue),
        isTouched: isTouched,
        setIsTouched: setIsTouched,
        schema: schema.defined(),
    };
};
// The generic TFieldValues type variable is an interface of field value types (the T in IFormField<T>) by field key.
// It is optional, and can either be inferred from the types in the `fields` argument or explicitly passed.
// example (explicit):
//   interface IFormValues { foo: string, bar: number }
//   useFormState<IFormValues>({ foo: useFormField<string>(...), bar: useFormField<number>(...) })
//     -> returns IFormState<IFormValues>
// example (implicit):
//   useFormState({ foo: useFormField<string>(...), bar: useFormField<number>(...) })
//     -> returns IFormState<{ foo: string, bar: bumber }>
var useFormState = function (fields, yupOptions) {
    if (yupOptions === void 0) { yupOptions = {}; }
    var fieldKeys = Object.keys(fields);
    var values = fieldKeys.reduce(function (newObj, key) {
        var _a;
        return (__assign(__assign({}, newObj), (_a = {}, _a[key] = fields[key].value, _a)));
    }, {});
    var isDirty = fieldKeys.some(function (key) { return fields[key].isDirty; });
    var isTouched = fieldKeys.some(function (key) { return fields[key].isTouched; });
    // Memoize the validation, only recompute if the field values changed
    var _a = React__namespace.useState(null), validationError = _a[0], setValidationError = _a[1];
    var _b = React__namespace.useState(false), hasRunInitialValidation = _b[0], setHasRunInitialValidation = _b[1];
    var lastValuesRef = React__namespace.useRef(values);
    React__namespace.useEffect(function () {
        if (!hasRunInitialValidation || !fastDeepEqual(lastValuesRef.current, values)) {
            lastValuesRef.current = values;
            var schemaShape = fieldKeys.reduce(function (newObj, key) {
                var _a;
                return (__assign(__assign({}, newObj), (_a = {}, _a[key] = fields[key].schema, _a)));
            }, {});
            var schema = create().shape(schemaShape);
            setHasRunInitialValidation(true);
            schema
                .validate(values, __assign({ abortEarly: false }, yupOptions))
                .then(function () {
                if (lastValuesRef.current === values) {
                    setValidationError(null);
                }
            })
                .catch(function (e) {
                if (lastValuesRef.current === values) {
                    setValidationError(e);
                }
            });
        }
    }, [fieldKeys, fields, hasRunInitialValidation, validationError, values, yupOptions]);
    var errorsByField = (validationError === null || validationError === void 0 ? void 0 : validationError.inner.reduce(function (newObj, error) {
        var _a;
        return (__assign(__assign({}, newObj), (_a = {}, _a[error.path || ''] = error, _a)));
    }, {})) || {};
    var validatedFields = fieldKeys.reduce(function (newObj, key) {
        var _a;
        var field = fields[key];
        var error = errorsByField ? errorsByField[key] : null;
        var validatedField = __assign(__assign({}, field), { error: error, isValid: !error, shouldShowError: !!error && field.isTouched });
        return __assign(__assign({}, newObj), (_a = {}, _a[key] = validatedField, _a));
    }, {});
    return {
        fields: validatedFields,
        values: values,
        isDirty: isDirty,
        isTouched: isTouched,
        isValid: hasRunInitialValidation && !validationError,
        clear: function () { return fieldKeys.forEach(function (key) { return fields[key].clear(); }); },
        revert: function () { return fieldKeys.forEach(function (key) { return fields[key].revert(); }); },
    };
};
// PatternFly-specific rendering helpers for FormGroup and TextInput components:
var getFormGroupProps = function (field, greenWhenValid) {
    var _a;
    if (greenWhenValid === void 0) { greenWhenValid = false; }
    var validStyle = greenWhenValid ? 'success' : 'default';
    return {
        validated: field.shouldShowError ? 'error' : field.isValid ? validStyle : 'default',
        helperTextInvalid: (_a = field.error) === null || _a === void 0 ? void 0 : _a.message,
    };
};
var getTextFieldProps = function (field, greenWhenValid) {
    if (greenWhenValid === void 0) { greenWhenValid = false; }
    return ({
        value: field.value,
        onChange: field.setValue,
        onBlur: function () { return field.setIsTouched(true); },
        validated: getFormGroupProps(field, greenWhenValid).validated,
    });
};
var getTextInputProps = function (field, greenWhenValid) {
    if (greenWhenValid === void 0) { greenWhenValid = false; }
    return getTextFieldProps(field, greenWhenValid);
};
var getTextAreaProps = function (field, greenWhenValid) {
    if (greenWhenValid === void 0) { greenWhenValid = false; }
    return getTextFieldProps(field, greenWhenValid);
};

var ValidatedTextInput = function (_a) {
    var field = _a.field, _b = _a.component, component = _b === void 0 ? reactCore.TextInput : _b, label = _a.label, fieldId = _a.fieldId, isRequired = _a.isRequired, _c = _a.type, type = _c === void 0 ? 'text' : _c, _d = _a.greenWhenValid, greenWhenValid = _d === void 0 ? false : _d, _e = _a.formGroupProps, formGroupProps = _e === void 0 ? {} : _e, _f = _a.inputProps, inputProps = _f === void 0 ? {} : _f;
    return (React__namespace.createElement(reactCore.FormGroup, __assign({ label: label, isRequired: isRequired, fieldId: fieldId }, getFormGroupProps(field, greenWhenValid), formGroupProps), component === reactCore.TextInput ? (React__namespace.createElement(reactCore.TextInput, __assign({ id: fieldId, type: type }, getTextInputProps(field, greenWhenValid), inputProps))) : (React__namespace.createElement(reactCore.TextArea, __assign({ id: fieldId }, getTextAreaProps(field, greenWhenValid), inputProps, { ref: null })))));
};

var _default = {
  "mAuto": "pf-u-m-auto",
  "mAutoOnLg": "pf-u-m-auto-on-lg",
  "mAutoOnMd": "pf-u-m-auto-on-md",
  "mAutoOnSm": "pf-u-m-auto-on-sm",
  "mAutoOnXl": "pf-u-m-auto-on-xl",
  "mAutoOn_2xl": "pf-u-m-auto-on-2xl",
  "mLg": "pf-u-m-lg",
  "mLgOnLg": "pf-u-m-lg-on-lg",
  "mLgOnMd": "pf-u-m-lg-on-md",
  "mLgOnSm": "pf-u-m-lg-on-sm",
  "mLgOnXl": "pf-u-m-lg-on-xl",
  "mLgOn_2xl": "pf-u-m-lg-on-2xl",
  "mMd": "pf-u-m-md",
  "mMdOnLg": "pf-u-m-md-on-lg",
  "mMdOnMd": "pf-u-m-md-on-md",
  "mMdOnSm": "pf-u-m-md-on-sm",
  "mMdOnXl": "pf-u-m-md-on-xl",
  "mMdOn_2xl": "pf-u-m-md-on-2xl",
  "mSm": "pf-u-m-sm",
  "mSmOnLg": "pf-u-m-sm-on-lg",
  "mSmOnMd": "pf-u-m-sm-on-md",
  "mSmOnSm": "pf-u-m-sm-on-sm",
  "mSmOnXl": "pf-u-m-sm-on-xl",
  "mSmOn_2xl": "pf-u-m-sm-on-2xl",
  "mXl": "pf-u-m-xl",
  "mXlOnLg": "pf-u-m-xl-on-lg",
  "mXlOnMd": "pf-u-m-xl-on-md",
  "mXlOnSm": "pf-u-m-xl-on-sm",
  "mXlOnXl": "pf-u-m-xl-on-xl",
  "mXlOn_2xl": "pf-u-m-xl-on-2xl",
  "mXs": "pf-u-m-xs",
  "mXsOnLg": "pf-u-m-xs-on-lg",
  "mXsOnMd": "pf-u-m-xs-on-md",
  "mXsOnSm": "pf-u-m-xs-on-sm",
  "mXsOnXl": "pf-u-m-xs-on-xl",
  "mXsOn_2xl": "pf-u-m-xs-on-2xl",
  "m_0": "pf-u-m-0",
  "m_0OnLg": "pf-u-m-0-on-lg",
  "m_0OnMd": "pf-u-m-0-on-md",
  "m_0OnSm": "pf-u-m-0-on-sm",
  "m_0OnXl": "pf-u-m-0-on-xl",
  "m_0On_2xl": "pf-u-m-0-on-2xl",
  "m_2xl": "pf-u-m-2xl",
  "m_2xlOnLg": "pf-u-m-2xl-on-lg",
  "m_2xlOnMd": "pf-u-m-2xl-on-md",
  "m_2xlOnSm": "pf-u-m-2xl-on-sm",
  "m_2xlOnXl": "pf-u-m-2xl-on-xl",
  "m_2xlOn_2xl": "pf-u-m-2xl-on-2xl",
  "m_3xl": "pf-u-m-3xl",
  "m_3xlOnLg": "pf-u-m-3xl-on-lg",
  "m_3xlOnMd": "pf-u-m-3xl-on-md",
  "m_3xlOnSm": "pf-u-m-3xl-on-sm",
  "m_3xlOnXl": "pf-u-m-3xl-on-xl",
  "m_3xlOn_2xl": "pf-u-m-3xl-on-2xl",
  "m_4xl": "pf-u-m-4xl",
  "m_4xlOnLg": "pf-u-m-4xl-on-lg",
  "m_4xlOnMd": "pf-u-m-4xl-on-md",
  "m_4xlOnSm": "pf-u-m-4xl-on-sm",
  "m_4xlOnXl": "pf-u-m-4xl-on-xl",
  "m_4xlOn_2xl": "pf-u-m-4xl-on-2xl",
  "mbAuto": "pf-u-mb-auto",
  "mbAutoOnLg": "pf-u-mb-auto-on-lg",
  "mbAutoOnMd": "pf-u-mb-auto-on-md",
  "mbAutoOnSm": "pf-u-mb-auto-on-sm",
  "mbAutoOnXl": "pf-u-mb-auto-on-xl",
  "mbAutoOn_2xl": "pf-u-mb-auto-on-2xl",
  "mbLg": "pf-u-mb-lg",
  "mbLgOnLg": "pf-u-mb-lg-on-lg",
  "mbLgOnMd": "pf-u-mb-lg-on-md",
  "mbLgOnSm": "pf-u-mb-lg-on-sm",
  "mbLgOnXl": "pf-u-mb-lg-on-xl",
  "mbLgOn_2xl": "pf-u-mb-lg-on-2xl",
  "mbMd": "pf-u-mb-md",
  "mbMdOnLg": "pf-u-mb-md-on-lg",
  "mbMdOnMd": "pf-u-mb-md-on-md",
  "mbMdOnSm": "pf-u-mb-md-on-sm",
  "mbMdOnXl": "pf-u-mb-md-on-xl",
  "mbMdOn_2xl": "pf-u-mb-md-on-2xl",
  "mbSm": "pf-u-mb-sm",
  "mbSmOnLg": "pf-u-mb-sm-on-lg",
  "mbSmOnMd": "pf-u-mb-sm-on-md",
  "mbSmOnSm": "pf-u-mb-sm-on-sm",
  "mbSmOnXl": "pf-u-mb-sm-on-xl",
  "mbSmOn_2xl": "pf-u-mb-sm-on-2xl",
  "mbXl": "pf-u-mb-xl",
  "mbXlOnLg": "pf-u-mb-xl-on-lg",
  "mbXlOnMd": "pf-u-mb-xl-on-md",
  "mbXlOnSm": "pf-u-mb-xl-on-sm",
  "mbXlOnXl": "pf-u-mb-xl-on-xl",
  "mbXlOn_2xl": "pf-u-mb-xl-on-2xl",
  "mbXs": "pf-u-mb-xs",
  "mbXsOnLg": "pf-u-mb-xs-on-lg",
  "mbXsOnMd": "pf-u-mb-xs-on-md",
  "mbXsOnSm": "pf-u-mb-xs-on-sm",
  "mbXsOnXl": "pf-u-mb-xs-on-xl",
  "mbXsOn_2xl": "pf-u-mb-xs-on-2xl",
  "mb_0": "pf-u-mb-0",
  "mb_0OnLg": "pf-u-mb-0-on-lg",
  "mb_0OnMd": "pf-u-mb-0-on-md",
  "mb_0OnSm": "pf-u-mb-0-on-sm",
  "mb_0OnXl": "pf-u-mb-0-on-xl",
  "mb_0On_2xl": "pf-u-mb-0-on-2xl",
  "mb_2xl": "pf-u-mb-2xl",
  "mb_2xlOnLg": "pf-u-mb-2xl-on-lg",
  "mb_2xlOnMd": "pf-u-mb-2xl-on-md",
  "mb_2xlOnSm": "pf-u-mb-2xl-on-sm",
  "mb_2xlOnXl": "pf-u-mb-2xl-on-xl",
  "mb_2xlOn_2xl": "pf-u-mb-2xl-on-2xl",
  "mb_3xl": "pf-u-mb-3xl",
  "mb_3xlOnLg": "pf-u-mb-3xl-on-lg",
  "mb_3xlOnMd": "pf-u-mb-3xl-on-md",
  "mb_3xlOnSm": "pf-u-mb-3xl-on-sm",
  "mb_3xlOnXl": "pf-u-mb-3xl-on-xl",
  "mb_3xlOn_2xl": "pf-u-mb-3xl-on-2xl",
  "mb_4xl": "pf-u-mb-4xl",
  "mb_4xlOnLg": "pf-u-mb-4xl-on-lg",
  "mb_4xlOnMd": "pf-u-mb-4xl-on-md",
  "mb_4xlOnSm": "pf-u-mb-4xl-on-sm",
  "mb_4xlOnXl": "pf-u-mb-4xl-on-xl",
  "mb_4xlOn_2xl": "pf-u-mb-4xl-on-2xl",
  "mlAuto": "pf-u-ml-auto",
  "mlAutoOnLg": "pf-u-ml-auto-on-lg",
  "mlAutoOnMd": "pf-u-ml-auto-on-md",
  "mlAutoOnSm": "pf-u-ml-auto-on-sm",
  "mlAutoOnXl": "pf-u-ml-auto-on-xl",
  "mlAutoOn_2xl": "pf-u-ml-auto-on-2xl",
  "mlLg": "pf-u-ml-lg",
  "mlLgOnLg": "pf-u-ml-lg-on-lg",
  "mlLgOnMd": "pf-u-ml-lg-on-md",
  "mlLgOnSm": "pf-u-ml-lg-on-sm",
  "mlLgOnXl": "pf-u-ml-lg-on-xl",
  "mlLgOn_2xl": "pf-u-ml-lg-on-2xl",
  "mlMd": "pf-u-ml-md",
  "mlMdOnLg": "pf-u-ml-md-on-lg",
  "mlMdOnMd": "pf-u-ml-md-on-md",
  "mlMdOnSm": "pf-u-ml-md-on-sm",
  "mlMdOnXl": "pf-u-ml-md-on-xl",
  "mlMdOn_2xl": "pf-u-ml-md-on-2xl",
  "mlSm": "pf-u-ml-sm",
  "mlSmOnLg": "pf-u-ml-sm-on-lg",
  "mlSmOnMd": "pf-u-ml-sm-on-md",
  "mlSmOnSm": "pf-u-ml-sm-on-sm",
  "mlSmOnXl": "pf-u-ml-sm-on-xl",
  "mlSmOn_2xl": "pf-u-ml-sm-on-2xl",
  "mlXl": "pf-u-ml-xl",
  "mlXlOnLg": "pf-u-ml-xl-on-lg",
  "mlXlOnMd": "pf-u-ml-xl-on-md",
  "mlXlOnSm": "pf-u-ml-xl-on-sm",
  "mlXlOnXl": "pf-u-ml-xl-on-xl",
  "mlXlOn_2xl": "pf-u-ml-xl-on-2xl",
  "mlXs": "pf-u-ml-xs",
  "mlXsOnLg": "pf-u-ml-xs-on-lg",
  "mlXsOnMd": "pf-u-ml-xs-on-md",
  "mlXsOnSm": "pf-u-ml-xs-on-sm",
  "mlXsOnXl": "pf-u-ml-xs-on-xl",
  "mlXsOn_2xl": "pf-u-ml-xs-on-2xl",
  "ml_0": "pf-u-ml-0",
  "ml_0OnLg": "pf-u-ml-0-on-lg",
  "ml_0OnMd": "pf-u-ml-0-on-md",
  "ml_0OnSm": "pf-u-ml-0-on-sm",
  "ml_0OnXl": "pf-u-ml-0-on-xl",
  "ml_0On_2xl": "pf-u-ml-0-on-2xl",
  "ml_2xl": "pf-u-ml-2xl",
  "ml_2xlOnLg": "pf-u-ml-2xl-on-lg",
  "ml_2xlOnMd": "pf-u-ml-2xl-on-md",
  "ml_2xlOnSm": "pf-u-ml-2xl-on-sm",
  "ml_2xlOnXl": "pf-u-ml-2xl-on-xl",
  "ml_2xlOn_2xl": "pf-u-ml-2xl-on-2xl",
  "ml_3xl": "pf-u-ml-3xl",
  "ml_3xlOnLg": "pf-u-ml-3xl-on-lg",
  "ml_3xlOnMd": "pf-u-ml-3xl-on-md",
  "ml_3xlOnSm": "pf-u-ml-3xl-on-sm",
  "ml_3xlOnXl": "pf-u-ml-3xl-on-xl",
  "ml_3xlOn_2xl": "pf-u-ml-3xl-on-2xl",
  "ml_4xl": "pf-u-ml-4xl",
  "ml_4xlOnLg": "pf-u-ml-4xl-on-lg",
  "ml_4xlOnMd": "pf-u-ml-4xl-on-md",
  "ml_4xlOnSm": "pf-u-ml-4xl-on-sm",
  "ml_4xlOnXl": "pf-u-ml-4xl-on-xl",
  "ml_4xlOn_2xl": "pf-u-ml-4xl-on-2xl",
  "mrAuto": "pf-u-mr-auto",
  "mrAutoOnLg": "pf-u-mr-auto-on-lg",
  "mrAutoOnMd": "pf-u-mr-auto-on-md",
  "mrAutoOnSm": "pf-u-mr-auto-on-sm",
  "mrAutoOnXl": "pf-u-mr-auto-on-xl",
  "mrAutoOn_2xl": "pf-u-mr-auto-on-2xl",
  "mrLg": "pf-u-mr-lg",
  "mrLgOnLg": "pf-u-mr-lg-on-lg",
  "mrLgOnMd": "pf-u-mr-lg-on-md",
  "mrLgOnSm": "pf-u-mr-lg-on-sm",
  "mrLgOnXl": "pf-u-mr-lg-on-xl",
  "mrLgOn_2xl": "pf-u-mr-lg-on-2xl",
  "mrMd": "pf-u-mr-md",
  "mrMdOnLg": "pf-u-mr-md-on-lg",
  "mrMdOnMd": "pf-u-mr-md-on-md",
  "mrMdOnSm": "pf-u-mr-md-on-sm",
  "mrMdOnXl": "pf-u-mr-md-on-xl",
  "mrMdOn_2xl": "pf-u-mr-md-on-2xl",
  "mrSm": "pf-u-mr-sm",
  "mrSmOnLg": "pf-u-mr-sm-on-lg",
  "mrSmOnMd": "pf-u-mr-sm-on-md",
  "mrSmOnSm": "pf-u-mr-sm-on-sm",
  "mrSmOnXl": "pf-u-mr-sm-on-xl",
  "mrSmOn_2xl": "pf-u-mr-sm-on-2xl",
  "mrXl": "pf-u-mr-xl",
  "mrXlOnLg": "pf-u-mr-xl-on-lg",
  "mrXlOnMd": "pf-u-mr-xl-on-md",
  "mrXlOnSm": "pf-u-mr-xl-on-sm",
  "mrXlOnXl": "pf-u-mr-xl-on-xl",
  "mrXlOn_2xl": "pf-u-mr-xl-on-2xl",
  "mrXs": "pf-u-mr-xs",
  "mrXsOnLg": "pf-u-mr-xs-on-lg",
  "mrXsOnMd": "pf-u-mr-xs-on-md",
  "mrXsOnSm": "pf-u-mr-xs-on-sm",
  "mrXsOnXl": "pf-u-mr-xs-on-xl",
  "mrXsOn_2xl": "pf-u-mr-xs-on-2xl",
  "mr_0": "pf-u-mr-0",
  "mr_0OnLg": "pf-u-mr-0-on-lg",
  "mr_0OnMd": "pf-u-mr-0-on-md",
  "mr_0OnSm": "pf-u-mr-0-on-sm",
  "mr_0OnXl": "pf-u-mr-0-on-xl",
  "mr_0On_2xl": "pf-u-mr-0-on-2xl",
  "mr_2xl": "pf-u-mr-2xl",
  "mr_2xlOnLg": "pf-u-mr-2xl-on-lg",
  "mr_2xlOnMd": "pf-u-mr-2xl-on-md",
  "mr_2xlOnSm": "pf-u-mr-2xl-on-sm",
  "mr_2xlOnXl": "pf-u-mr-2xl-on-xl",
  "mr_2xlOn_2xl": "pf-u-mr-2xl-on-2xl",
  "mr_3xl": "pf-u-mr-3xl",
  "mr_3xlOnLg": "pf-u-mr-3xl-on-lg",
  "mr_3xlOnMd": "pf-u-mr-3xl-on-md",
  "mr_3xlOnSm": "pf-u-mr-3xl-on-sm",
  "mr_3xlOnXl": "pf-u-mr-3xl-on-xl",
  "mr_3xlOn_2xl": "pf-u-mr-3xl-on-2xl",
  "mr_4xl": "pf-u-mr-4xl",
  "mr_4xlOnLg": "pf-u-mr-4xl-on-lg",
  "mr_4xlOnMd": "pf-u-mr-4xl-on-md",
  "mr_4xlOnSm": "pf-u-mr-4xl-on-sm",
  "mr_4xlOnXl": "pf-u-mr-4xl-on-xl",
  "mr_4xlOn_2xl": "pf-u-mr-4xl-on-2xl",
  "mtAuto": "pf-u-mt-auto",
  "mtAutoOnLg": "pf-u-mt-auto-on-lg",
  "mtAutoOnMd": "pf-u-mt-auto-on-md",
  "mtAutoOnSm": "pf-u-mt-auto-on-sm",
  "mtAutoOnXl": "pf-u-mt-auto-on-xl",
  "mtAutoOn_2xl": "pf-u-mt-auto-on-2xl",
  "mtLg": "pf-u-mt-lg",
  "mtLgOnLg": "pf-u-mt-lg-on-lg",
  "mtLgOnMd": "pf-u-mt-lg-on-md",
  "mtLgOnSm": "pf-u-mt-lg-on-sm",
  "mtLgOnXl": "pf-u-mt-lg-on-xl",
  "mtLgOn_2xl": "pf-u-mt-lg-on-2xl",
  "mtMd": "pf-u-mt-md",
  "mtMdOnLg": "pf-u-mt-md-on-lg",
  "mtMdOnMd": "pf-u-mt-md-on-md",
  "mtMdOnSm": "pf-u-mt-md-on-sm",
  "mtMdOnXl": "pf-u-mt-md-on-xl",
  "mtMdOn_2xl": "pf-u-mt-md-on-2xl",
  "mtSm": "pf-u-mt-sm",
  "mtSmOnLg": "pf-u-mt-sm-on-lg",
  "mtSmOnMd": "pf-u-mt-sm-on-md",
  "mtSmOnSm": "pf-u-mt-sm-on-sm",
  "mtSmOnXl": "pf-u-mt-sm-on-xl",
  "mtSmOn_2xl": "pf-u-mt-sm-on-2xl",
  "mtXl": "pf-u-mt-xl",
  "mtXlOnLg": "pf-u-mt-xl-on-lg",
  "mtXlOnMd": "pf-u-mt-xl-on-md",
  "mtXlOnSm": "pf-u-mt-xl-on-sm",
  "mtXlOnXl": "pf-u-mt-xl-on-xl",
  "mtXlOn_2xl": "pf-u-mt-xl-on-2xl",
  "mtXs": "pf-u-mt-xs",
  "mtXsOnLg": "pf-u-mt-xs-on-lg",
  "mtXsOnMd": "pf-u-mt-xs-on-md",
  "mtXsOnSm": "pf-u-mt-xs-on-sm",
  "mtXsOnXl": "pf-u-mt-xs-on-xl",
  "mtXsOn_2xl": "pf-u-mt-xs-on-2xl",
  "mt_0": "pf-u-mt-0",
  "mt_0OnLg": "pf-u-mt-0-on-lg",
  "mt_0OnMd": "pf-u-mt-0-on-md",
  "mt_0OnSm": "pf-u-mt-0-on-sm",
  "mt_0OnXl": "pf-u-mt-0-on-xl",
  "mt_0On_2xl": "pf-u-mt-0-on-2xl",
  "mt_2xl": "pf-u-mt-2xl",
  "mt_2xlOnLg": "pf-u-mt-2xl-on-lg",
  "mt_2xlOnMd": "pf-u-mt-2xl-on-md",
  "mt_2xlOnSm": "pf-u-mt-2xl-on-sm",
  "mt_2xlOnXl": "pf-u-mt-2xl-on-xl",
  "mt_2xlOn_2xl": "pf-u-mt-2xl-on-2xl",
  "mt_3xl": "pf-u-mt-3xl",
  "mt_3xlOnLg": "pf-u-mt-3xl-on-lg",
  "mt_3xlOnMd": "pf-u-mt-3xl-on-md",
  "mt_3xlOnSm": "pf-u-mt-3xl-on-sm",
  "mt_3xlOnXl": "pf-u-mt-3xl-on-xl",
  "mt_3xlOn_2xl": "pf-u-mt-3xl-on-2xl",
  "mt_4xl": "pf-u-mt-4xl",
  "mt_4xlOnLg": "pf-u-mt-4xl-on-lg",
  "mt_4xlOnMd": "pf-u-mt-4xl-on-md",
  "mt_4xlOnSm": "pf-u-mt-4xl-on-sm",
  "mt_4xlOnXl": "pf-u-mt-4xl-on-xl",
  "mt_4xlOn_2xl": "pf-u-mt-4xl-on-2xl",
  "mxAuto": "pf-u-mx-auto",
  "mxAutoOnLg": "pf-u-mx-auto-on-lg",
  "mxAutoOnMd": "pf-u-mx-auto-on-md",
  "mxAutoOnSm": "pf-u-mx-auto-on-sm",
  "mxAutoOnXl": "pf-u-mx-auto-on-xl",
  "mxAutoOn_2xl": "pf-u-mx-auto-on-2xl",
  "mxLg": "pf-u-mx-lg",
  "mxLgOnLg": "pf-u-mx-lg-on-lg",
  "mxLgOnMd": "pf-u-mx-lg-on-md",
  "mxLgOnSm": "pf-u-mx-lg-on-sm",
  "mxLgOnXl": "pf-u-mx-lg-on-xl",
  "mxLgOn_2xl": "pf-u-mx-lg-on-2xl",
  "mxMd": "pf-u-mx-md",
  "mxMdOnLg": "pf-u-mx-md-on-lg",
  "mxMdOnMd": "pf-u-mx-md-on-md",
  "mxMdOnSm": "pf-u-mx-md-on-sm",
  "mxMdOnXl": "pf-u-mx-md-on-xl",
  "mxMdOn_2xl": "pf-u-mx-md-on-2xl",
  "mxSm": "pf-u-mx-sm",
  "mxSmOnLg": "pf-u-mx-sm-on-lg",
  "mxSmOnMd": "pf-u-mx-sm-on-md",
  "mxSmOnSm": "pf-u-mx-sm-on-sm",
  "mxSmOnXl": "pf-u-mx-sm-on-xl",
  "mxSmOn_2xl": "pf-u-mx-sm-on-2xl",
  "mxXl": "pf-u-mx-xl",
  "mxXlOnLg": "pf-u-mx-xl-on-lg",
  "mxXlOnMd": "pf-u-mx-xl-on-md",
  "mxXlOnSm": "pf-u-mx-xl-on-sm",
  "mxXlOnXl": "pf-u-mx-xl-on-xl",
  "mxXlOn_2xl": "pf-u-mx-xl-on-2xl",
  "mxXs": "pf-u-mx-xs",
  "mxXsOnLg": "pf-u-mx-xs-on-lg",
  "mxXsOnMd": "pf-u-mx-xs-on-md",
  "mxXsOnSm": "pf-u-mx-xs-on-sm",
  "mxXsOnXl": "pf-u-mx-xs-on-xl",
  "mxXsOn_2xl": "pf-u-mx-xs-on-2xl",
  "mx_0": "pf-u-mx-0",
  "mx_0OnLg": "pf-u-mx-0-on-lg",
  "mx_0OnMd": "pf-u-mx-0-on-md",
  "mx_0OnSm": "pf-u-mx-0-on-sm",
  "mx_0OnXl": "pf-u-mx-0-on-xl",
  "mx_0On_2xl": "pf-u-mx-0-on-2xl",
  "mx_2xl": "pf-u-mx-2xl",
  "mx_2xlOnLg": "pf-u-mx-2xl-on-lg",
  "mx_2xlOnMd": "pf-u-mx-2xl-on-md",
  "mx_2xlOnSm": "pf-u-mx-2xl-on-sm",
  "mx_2xlOnXl": "pf-u-mx-2xl-on-xl",
  "mx_2xlOn_2xl": "pf-u-mx-2xl-on-2xl",
  "mx_3xl": "pf-u-mx-3xl",
  "mx_3xlOnLg": "pf-u-mx-3xl-on-lg",
  "mx_3xlOnMd": "pf-u-mx-3xl-on-md",
  "mx_3xlOnSm": "pf-u-mx-3xl-on-sm",
  "mx_3xlOnXl": "pf-u-mx-3xl-on-xl",
  "mx_3xlOn_2xl": "pf-u-mx-3xl-on-2xl",
  "mx_4xl": "pf-u-mx-4xl",
  "mx_4xlOnLg": "pf-u-mx-4xl-on-lg",
  "mx_4xlOnMd": "pf-u-mx-4xl-on-md",
  "mx_4xlOnSm": "pf-u-mx-4xl-on-sm",
  "mx_4xlOnXl": "pf-u-mx-4xl-on-xl",
  "mx_4xlOn_2xl": "pf-u-mx-4xl-on-2xl",
  "myAuto": "pf-u-my-auto",
  "myAutoOnLg": "pf-u-my-auto-on-lg",
  "myAutoOnMd": "pf-u-my-auto-on-md",
  "myAutoOnSm": "pf-u-my-auto-on-sm",
  "myAutoOnXl": "pf-u-my-auto-on-xl",
  "myAutoOn_2xl": "pf-u-my-auto-on-2xl",
  "myLg": "pf-u-my-lg",
  "myLgOnLg": "pf-u-my-lg-on-lg",
  "myLgOnMd": "pf-u-my-lg-on-md",
  "myLgOnSm": "pf-u-my-lg-on-sm",
  "myLgOnXl": "pf-u-my-lg-on-xl",
  "myLgOn_2xl": "pf-u-my-lg-on-2xl",
  "myMd": "pf-u-my-md",
  "myMdOnLg": "pf-u-my-md-on-lg",
  "myMdOnMd": "pf-u-my-md-on-md",
  "myMdOnSm": "pf-u-my-md-on-sm",
  "myMdOnXl": "pf-u-my-md-on-xl",
  "myMdOn_2xl": "pf-u-my-md-on-2xl",
  "mySm": "pf-u-my-sm",
  "mySmOnLg": "pf-u-my-sm-on-lg",
  "mySmOnMd": "pf-u-my-sm-on-md",
  "mySmOnSm": "pf-u-my-sm-on-sm",
  "mySmOnXl": "pf-u-my-sm-on-xl",
  "mySmOn_2xl": "pf-u-my-sm-on-2xl",
  "myXl": "pf-u-my-xl",
  "myXlOnLg": "pf-u-my-xl-on-lg",
  "myXlOnMd": "pf-u-my-xl-on-md",
  "myXlOnSm": "pf-u-my-xl-on-sm",
  "myXlOnXl": "pf-u-my-xl-on-xl",
  "myXlOn_2xl": "pf-u-my-xl-on-2xl",
  "myXs": "pf-u-my-xs",
  "myXsOnLg": "pf-u-my-xs-on-lg",
  "myXsOnMd": "pf-u-my-xs-on-md",
  "myXsOnSm": "pf-u-my-xs-on-sm",
  "myXsOnXl": "pf-u-my-xs-on-xl",
  "myXsOn_2xl": "pf-u-my-xs-on-2xl",
  "my_0": "pf-u-my-0",
  "my_0OnLg": "pf-u-my-0-on-lg",
  "my_0OnMd": "pf-u-my-0-on-md",
  "my_0OnSm": "pf-u-my-0-on-sm",
  "my_0OnXl": "pf-u-my-0-on-xl",
  "my_0On_2xl": "pf-u-my-0-on-2xl",
  "my_2xl": "pf-u-my-2xl",
  "my_2xlOnLg": "pf-u-my-2xl-on-lg",
  "my_2xlOnMd": "pf-u-my-2xl-on-md",
  "my_2xlOnSm": "pf-u-my-2xl-on-sm",
  "my_2xlOnXl": "pf-u-my-2xl-on-xl",
  "my_2xlOn_2xl": "pf-u-my-2xl-on-2xl",
  "my_3xl": "pf-u-my-3xl",
  "my_3xlOnLg": "pf-u-my-3xl-on-lg",
  "my_3xlOnMd": "pf-u-my-3xl-on-md",
  "my_3xlOnSm": "pf-u-my-3xl-on-sm",
  "my_3xlOnXl": "pf-u-my-3xl-on-xl",
  "my_3xlOn_2xl": "pf-u-my-3xl-on-2xl",
  "my_4xl": "pf-u-my-4xl",
  "my_4xlOnLg": "pf-u-my-4xl-on-lg",
  "my_4xlOnMd": "pf-u-my-4xl-on-md",
  "my_4xlOnSm": "pf-u-my-4xl-on-sm",
  "my_4xlOnXl": "pf-u-my-4xl-on-xl",
  "my_4xlOn_2xl": "pf-u-my-4xl-on-2xl",
  "pAuto": "pf-u-p-auto",
  "pAutoOnLg": "pf-u-p-auto-on-lg",
  "pAutoOnMd": "pf-u-p-auto-on-md",
  "pAutoOnSm": "pf-u-p-auto-on-sm",
  "pAutoOnXl": "pf-u-p-auto-on-xl",
  "pAutoOn_2xl": "pf-u-p-auto-on-2xl",
  "pLg": "pf-u-p-lg",
  "pLgOnLg": "pf-u-p-lg-on-lg",
  "pLgOnMd": "pf-u-p-lg-on-md",
  "pLgOnSm": "pf-u-p-lg-on-sm",
  "pLgOnXl": "pf-u-p-lg-on-xl",
  "pLgOn_2xl": "pf-u-p-lg-on-2xl",
  "pMd": "pf-u-p-md",
  "pMdOnLg": "pf-u-p-md-on-lg",
  "pMdOnMd": "pf-u-p-md-on-md",
  "pMdOnSm": "pf-u-p-md-on-sm",
  "pMdOnXl": "pf-u-p-md-on-xl",
  "pMdOn_2xl": "pf-u-p-md-on-2xl",
  "pSm": "pf-u-p-sm",
  "pSmOnLg": "pf-u-p-sm-on-lg",
  "pSmOnMd": "pf-u-p-sm-on-md",
  "pSmOnSm": "pf-u-p-sm-on-sm",
  "pSmOnXl": "pf-u-p-sm-on-xl",
  "pSmOn_2xl": "pf-u-p-sm-on-2xl",
  "pXl": "pf-u-p-xl",
  "pXlOnLg": "pf-u-p-xl-on-lg",
  "pXlOnMd": "pf-u-p-xl-on-md",
  "pXlOnSm": "pf-u-p-xl-on-sm",
  "pXlOnXl": "pf-u-p-xl-on-xl",
  "pXlOn_2xl": "pf-u-p-xl-on-2xl",
  "pXs": "pf-u-p-xs",
  "pXsOnLg": "pf-u-p-xs-on-lg",
  "pXsOnMd": "pf-u-p-xs-on-md",
  "pXsOnSm": "pf-u-p-xs-on-sm",
  "pXsOnXl": "pf-u-p-xs-on-xl",
  "pXsOn_2xl": "pf-u-p-xs-on-2xl",
  "p_0": "pf-u-p-0",
  "p_0OnLg": "pf-u-p-0-on-lg",
  "p_0OnMd": "pf-u-p-0-on-md",
  "p_0OnSm": "pf-u-p-0-on-sm",
  "p_0OnXl": "pf-u-p-0-on-xl",
  "p_0On_2xl": "pf-u-p-0-on-2xl",
  "p_2xl": "pf-u-p-2xl",
  "p_2xlOnLg": "pf-u-p-2xl-on-lg",
  "p_2xlOnMd": "pf-u-p-2xl-on-md",
  "p_2xlOnSm": "pf-u-p-2xl-on-sm",
  "p_2xlOnXl": "pf-u-p-2xl-on-xl",
  "p_2xlOn_2xl": "pf-u-p-2xl-on-2xl",
  "p_3xl": "pf-u-p-3xl",
  "p_3xlOnLg": "pf-u-p-3xl-on-lg",
  "p_3xlOnMd": "pf-u-p-3xl-on-md",
  "p_3xlOnSm": "pf-u-p-3xl-on-sm",
  "p_3xlOnXl": "pf-u-p-3xl-on-xl",
  "p_3xlOn_2xl": "pf-u-p-3xl-on-2xl",
  "p_4xl": "pf-u-p-4xl",
  "p_4xlOnLg": "pf-u-p-4xl-on-lg",
  "p_4xlOnMd": "pf-u-p-4xl-on-md",
  "p_4xlOnSm": "pf-u-p-4xl-on-sm",
  "p_4xlOnXl": "pf-u-p-4xl-on-xl",
  "p_4xlOn_2xl": "pf-u-p-4xl-on-2xl",
  "pbAuto": "pf-u-pb-auto",
  "pbAutoOnLg": "pf-u-pb-auto-on-lg",
  "pbAutoOnMd": "pf-u-pb-auto-on-md",
  "pbAutoOnSm": "pf-u-pb-auto-on-sm",
  "pbAutoOnXl": "pf-u-pb-auto-on-xl",
  "pbAutoOn_2xl": "pf-u-pb-auto-on-2xl",
  "pbLg": "pf-u-pb-lg",
  "pbLgOnLg": "pf-u-pb-lg-on-lg",
  "pbLgOnMd": "pf-u-pb-lg-on-md",
  "pbLgOnSm": "pf-u-pb-lg-on-sm",
  "pbLgOnXl": "pf-u-pb-lg-on-xl",
  "pbLgOn_2xl": "pf-u-pb-lg-on-2xl",
  "pbMd": "pf-u-pb-md",
  "pbMdOnLg": "pf-u-pb-md-on-lg",
  "pbMdOnMd": "pf-u-pb-md-on-md",
  "pbMdOnSm": "pf-u-pb-md-on-sm",
  "pbMdOnXl": "pf-u-pb-md-on-xl",
  "pbMdOn_2xl": "pf-u-pb-md-on-2xl",
  "pbSm": "pf-u-pb-sm",
  "pbSmOnLg": "pf-u-pb-sm-on-lg",
  "pbSmOnMd": "pf-u-pb-sm-on-md",
  "pbSmOnSm": "pf-u-pb-sm-on-sm",
  "pbSmOnXl": "pf-u-pb-sm-on-xl",
  "pbSmOn_2xl": "pf-u-pb-sm-on-2xl",
  "pbXl": "pf-u-pb-xl",
  "pbXlOnLg": "pf-u-pb-xl-on-lg",
  "pbXlOnMd": "pf-u-pb-xl-on-md",
  "pbXlOnSm": "pf-u-pb-xl-on-sm",
  "pbXlOnXl": "pf-u-pb-xl-on-xl",
  "pbXlOn_2xl": "pf-u-pb-xl-on-2xl",
  "pbXs": "pf-u-pb-xs",
  "pbXsOnLg": "pf-u-pb-xs-on-lg",
  "pbXsOnMd": "pf-u-pb-xs-on-md",
  "pbXsOnSm": "pf-u-pb-xs-on-sm",
  "pbXsOnXl": "pf-u-pb-xs-on-xl",
  "pbXsOn_2xl": "pf-u-pb-xs-on-2xl",
  "pb_0": "pf-u-pb-0",
  "pb_0OnLg": "pf-u-pb-0-on-lg",
  "pb_0OnMd": "pf-u-pb-0-on-md",
  "pb_0OnSm": "pf-u-pb-0-on-sm",
  "pb_0OnXl": "pf-u-pb-0-on-xl",
  "pb_0On_2xl": "pf-u-pb-0-on-2xl",
  "pb_2xl": "pf-u-pb-2xl",
  "pb_2xlOnLg": "pf-u-pb-2xl-on-lg",
  "pb_2xlOnMd": "pf-u-pb-2xl-on-md",
  "pb_2xlOnSm": "pf-u-pb-2xl-on-sm",
  "pb_2xlOnXl": "pf-u-pb-2xl-on-xl",
  "pb_2xlOn_2xl": "pf-u-pb-2xl-on-2xl",
  "pb_3xl": "pf-u-pb-3xl",
  "pb_3xlOnLg": "pf-u-pb-3xl-on-lg",
  "pb_3xlOnMd": "pf-u-pb-3xl-on-md",
  "pb_3xlOnSm": "pf-u-pb-3xl-on-sm",
  "pb_3xlOnXl": "pf-u-pb-3xl-on-xl",
  "pb_3xlOn_2xl": "pf-u-pb-3xl-on-2xl",
  "pb_4xl": "pf-u-pb-4xl",
  "pb_4xlOnLg": "pf-u-pb-4xl-on-lg",
  "pb_4xlOnMd": "pf-u-pb-4xl-on-md",
  "pb_4xlOnSm": "pf-u-pb-4xl-on-sm",
  "pb_4xlOnXl": "pf-u-pb-4xl-on-xl",
  "pb_4xlOn_2xl": "pf-u-pb-4xl-on-2xl",
  "plAuto": "pf-u-pl-auto",
  "plAutoOnLg": "pf-u-pl-auto-on-lg",
  "plAutoOnMd": "pf-u-pl-auto-on-md",
  "plAutoOnSm": "pf-u-pl-auto-on-sm",
  "plAutoOnXl": "pf-u-pl-auto-on-xl",
  "plAutoOn_2xl": "pf-u-pl-auto-on-2xl",
  "plLg": "pf-u-pl-lg",
  "plLgOnLg": "pf-u-pl-lg-on-lg",
  "plLgOnMd": "pf-u-pl-lg-on-md",
  "plLgOnSm": "pf-u-pl-lg-on-sm",
  "plLgOnXl": "pf-u-pl-lg-on-xl",
  "plLgOn_2xl": "pf-u-pl-lg-on-2xl",
  "plMd": "pf-u-pl-md",
  "plMdOnLg": "pf-u-pl-md-on-lg",
  "plMdOnMd": "pf-u-pl-md-on-md",
  "plMdOnSm": "pf-u-pl-md-on-sm",
  "plMdOnXl": "pf-u-pl-md-on-xl",
  "plMdOn_2xl": "pf-u-pl-md-on-2xl",
  "plSm": "pf-u-pl-sm",
  "plSmOnLg": "pf-u-pl-sm-on-lg",
  "plSmOnMd": "pf-u-pl-sm-on-md",
  "plSmOnSm": "pf-u-pl-sm-on-sm",
  "plSmOnXl": "pf-u-pl-sm-on-xl",
  "plSmOn_2xl": "pf-u-pl-sm-on-2xl",
  "plXl": "pf-u-pl-xl",
  "plXlOnLg": "pf-u-pl-xl-on-lg",
  "plXlOnMd": "pf-u-pl-xl-on-md",
  "plXlOnSm": "pf-u-pl-xl-on-sm",
  "plXlOnXl": "pf-u-pl-xl-on-xl",
  "plXlOn_2xl": "pf-u-pl-xl-on-2xl",
  "plXs": "pf-u-pl-xs",
  "plXsOnLg": "pf-u-pl-xs-on-lg",
  "plXsOnMd": "pf-u-pl-xs-on-md",
  "plXsOnSm": "pf-u-pl-xs-on-sm",
  "plXsOnXl": "pf-u-pl-xs-on-xl",
  "plXsOn_2xl": "pf-u-pl-xs-on-2xl",
  "pl_0": "pf-u-pl-0",
  "pl_0OnLg": "pf-u-pl-0-on-lg",
  "pl_0OnMd": "pf-u-pl-0-on-md",
  "pl_0OnSm": "pf-u-pl-0-on-sm",
  "pl_0OnXl": "pf-u-pl-0-on-xl",
  "pl_0On_2xl": "pf-u-pl-0-on-2xl",
  "pl_2xl": "pf-u-pl-2xl",
  "pl_2xlOnLg": "pf-u-pl-2xl-on-lg",
  "pl_2xlOnMd": "pf-u-pl-2xl-on-md",
  "pl_2xlOnSm": "pf-u-pl-2xl-on-sm",
  "pl_2xlOnXl": "pf-u-pl-2xl-on-xl",
  "pl_2xlOn_2xl": "pf-u-pl-2xl-on-2xl",
  "pl_3xl": "pf-u-pl-3xl",
  "pl_3xlOnLg": "pf-u-pl-3xl-on-lg",
  "pl_3xlOnMd": "pf-u-pl-3xl-on-md",
  "pl_3xlOnSm": "pf-u-pl-3xl-on-sm",
  "pl_3xlOnXl": "pf-u-pl-3xl-on-xl",
  "pl_3xlOn_2xl": "pf-u-pl-3xl-on-2xl",
  "pl_4xl": "pf-u-pl-4xl",
  "pl_4xlOnLg": "pf-u-pl-4xl-on-lg",
  "pl_4xlOnMd": "pf-u-pl-4xl-on-md",
  "pl_4xlOnSm": "pf-u-pl-4xl-on-sm",
  "pl_4xlOnXl": "pf-u-pl-4xl-on-xl",
  "pl_4xlOn_2xl": "pf-u-pl-4xl-on-2xl",
  "prAuto": "pf-u-pr-auto",
  "prAutoOnLg": "pf-u-pr-auto-on-lg",
  "prAutoOnMd": "pf-u-pr-auto-on-md",
  "prAutoOnSm": "pf-u-pr-auto-on-sm",
  "prAutoOnXl": "pf-u-pr-auto-on-xl",
  "prAutoOn_2xl": "pf-u-pr-auto-on-2xl",
  "prLg": "pf-u-pr-lg",
  "prLgOnLg": "pf-u-pr-lg-on-lg",
  "prLgOnMd": "pf-u-pr-lg-on-md",
  "prLgOnSm": "pf-u-pr-lg-on-sm",
  "prLgOnXl": "pf-u-pr-lg-on-xl",
  "prLgOn_2xl": "pf-u-pr-lg-on-2xl",
  "prMd": "pf-u-pr-md",
  "prMdOnLg": "pf-u-pr-md-on-lg",
  "prMdOnMd": "pf-u-pr-md-on-md",
  "prMdOnSm": "pf-u-pr-md-on-sm",
  "prMdOnXl": "pf-u-pr-md-on-xl",
  "prMdOn_2xl": "pf-u-pr-md-on-2xl",
  "prSm": "pf-u-pr-sm",
  "prSmOnLg": "pf-u-pr-sm-on-lg",
  "prSmOnMd": "pf-u-pr-sm-on-md",
  "prSmOnSm": "pf-u-pr-sm-on-sm",
  "prSmOnXl": "pf-u-pr-sm-on-xl",
  "prSmOn_2xl": "pf-u-pr-sm-on-2xl",
  "prXl": "pf-u-pr-xl",
  "prXlOnLg": "pf-u-pr-xl-on-lg",
  "prXlOnMd": "pf-u-pr-xl-on-md",
  "prXlOnSm": "pf-u-pr-xl-on-sm",
  "prXlOnXl": "pf-u-pr-xl-on-xl",
  "prXlOn_2xl": "pf-u-pr-xl-on-2xl",
  "prXs": "pf-u-pr-xs",
  "prXsOnLg": "pf-u-pr-xs-on-lg",
  "prXsOnMd": "pf-u-pr-xs-on-md",
  "prXsOnSm": "pf-u-pr-xs-on-sm",
  "prXsOnXl": "pf-u-pr-xs-on-xl",
  "prXsOn_2xl": "pf-u-pr-xs-on-2xl",
  "pr_0": "pf-u-pr-0",
  "pr_0OnLg": "pf-u-pr-0-on-lg",
  "pr_0OnMd": "pf-u-pr-0-on-md",
  "pr_0OnSm": "pf-u-pr-0-on-sm",
  "pr_0OnXl": "pf-u-pr-0-on-xl",
  "pr_0On_2xl": "pf-u-pr-0-on-2xl",
  "pr_2xl": "pf-u-pr-2xl",
  "pr_2xlOnLg": "pf-u-pr-2xl-on-lg",
  "pr_2xlOnMd": "pf-u-pr-2xl-on-md",
  "pr_2xlOnSm": "pf-u-pr-2xl-on-sm",
  "pr_2xlOnXl": "pf-u-pr-2xl-on-xl",
  "pr_2xlOn_2xl": "pf-u-pr-2xl-on-2xl",
  "pr_3xl": "pf-u-pr-3xl",
  "pr_3xlOnLg": "pf-u-pr-3xl-on-lg",
  "pr_3xlOnMd": "pf-u-pr-3xl-on-md",
  "pr_3xlOnSm": "pf-u-pr-3xl-on-sm",
  "pr_3xlOnXl": "pf-u-pr-3xl-on-xl",
  "pr_3xlOn_2xl": "pf-u-pr-3xl-on-2xl",
  "pr_4xl": "pf-u-pr-4xl",
  "pr_4xlOnLg": "pf-u-pr-4xl-on-lg",
  "pr_4xlOnMd": "pf-u-pr-4xl-on-md",
  "pr_4xlOnSm": "pf-u-pr-4xl-on-sm",
  "pr_4xlOnXl": "pf-u-pr-4xl-on-xl",
  "pr_4xlOn_2xl": "pf-u-pr-4xl-on-2xl",
  "ptAuto": "pf-u-pt-auto",
  "ptAutoOnLg": "pf-u-pt-auto-on-lg",
  "ptAutoOnMd": "pf-u-pt-auto-on-md",
  "ptAutoOnSm": "pf-u-pt-auto-on-sm",
  "ptAutoOnXl": "pf-u-pt-auto-on-xl",
  "ptAutoOn_2xl": "pf-u-pt-auto-on-2xl",
  "ptLg": "pf-u-pt-lg",
  "ptLgOnLg": "pf-u-pt-lg-on-lg",
  "ptLgOnMd": "pf-u-pt-lg-on-md",
  "ptLgOnSm": "pf-u-pt-lg-on-sm",
  "ptLgOnXl": "pf-u-pt-lg-on-xl",
  "ptLgOn_2xl": "pf-u-pt-lg-on-2xl",
  "ptMd": "pf-u-pt-md",
  "ptMdOnLg": "pf-u-pt-md-on-lg",
  "ptMdOnMd": "pf-u-pt-md-on-md",
  "ptMdOnSm": "pf-u-pt-md-on-sm",
  "ptMdOnXl": "pf-u-pt-md-on-xl",
  "ptMdOn_2xl": "pf-u-pt-md-on-2xl",
  "ptSm": "pf-u-pt-sm",
  "ptSmOnLg": "pf-u-pt-sm-on-lg",
  "ptSmOnMd": "pf-u-pt-sm-on-md",
  "ptSmOnSm": "pf-u-pt-sm-on-sm",
  "ptSmOnXl": "pf-u-pt-sm-on-xl",
  "ptSmOn_2xl": "pf-u-pt-sm-on-2xl",
  "ptXl": "pf-u-pt-xl",
  "ptXlOnLg": "pf-u-pt-xl-on-lg",
  "ptXlOnMd": "pf-u-pt-xl-on-md",
  "ptXlOnSm": "pf-u-pt-xl-on-sm",
  "ptXlOnXl": "pf-u-pt-xl-on-xl",
  "ptXlOn_2xl": "pf-u-pt-xl-on-2xl",
  "ptXs": "pf-u-pt-xs",
  "ptXsOnLg": "pf-u-pt-xs-on-lg",
  "ptXsOnMd": "pf-u-pt-xs-on-md",
  "ptXsOnSm": "pf-u-pt-xs-on-sm",
  "ptXsOnXl": "pf-u-pt-xs-on-xl",
  "ptXsOn_2xl": "pf-u-pt-xs-on-2xl",
  "pt_0": "pf-u-pt-0",
  "pt_0OnLg": "pf-u-pt-0-on-lg",
  "pt_0OnMd": "pf-u-pt-0-on-md",
  "pt_0OnSm": "pf-u-pt-0-on-sm",
  "pt_0OnXl": "pf-u-pt-0-on-xl",
  "pt_0On_2xl": "pf-u-pt-0-on-2xl",
  "pt_2xl": "pf-u-pt-2xl",
  "pt_2xlOnLg": "pf-u-pt-2xl-on-lg",
  "pt_2xlOnMd": "pf-u-pt-2xl-on-md",
  "pt_2xlOnSm": "pf-u-pt-2xl-on-sm",
  "pt_2xlOnXl": "pf-u-pt-2xl-on-xl",
  "pt_2xlOn_2xl": "pf-u-pt-2xl-on-2xl",
  "pt_3xl": "pf-u-pt-3xl",
  "pt_3xlOnLg": "pf-u-pt-3xl-on-lg",
  "pt_3xlOnMd": "pf-u-pt-3xl-on-md",
  "pt_3xlOnSm": "pf-u-pt-3xl-on-sm",
  "pt_3xlOnXl": "pf-u-pt-3xl-on-xl",
  "pt_3xlOn_2xl": "pf-u-pt-3xl-on-2xl",
  "pt_4xl": "pf-u-pt-4xl",
  "pt_4xlOnLg": "pf-u-pt-4xl-on-lg",
  "pt_4xlOnMd": "pf-u-pt-4xl-on-md",
  "pt_4xlOnSm": "pf-u-pt-4xl-on-sm",
  "pt_4xlOnXl": "pf-u-pt-4xl-on-xl",
  "pt_4xlOn_2xl": "pf-u-pt-4xl-on-2xl",
  "pxAuto": "pf-u-px-auto",
  "pxAutoOnLg": "pf-u-px-auto-on-lg",
  "pxAutoOnMd": "pf-u-px-auto-on-md",
  "pxAutoOnSm": "pf-u-px-auto-on-sm",
  "pxAutoOnXl": "pf-u-px-auto-on-xl",
  "pxAutoOn_2xl": "pf-u-px-auto-on-2xl",
  "pxLg": "pf-u-px-lg",
  "pxLgOnLg": "pf-u-px-lg-on-lg",
  "pxLgOnMd": "pf-u-px-lg-on-md",
  "pxLgOnSm": "pf-u-px-lg-on-sm",
  "pxLgOnXl": "pf-u-px-lg-on-xl",
  "pxLgOn_2xl": "pf-u-px-lg-on-2xl",
  "pxMd": "pf-u-px-md",
  "pxMdOnLg": "pf-u-px-md-on-lg",
  "pxMdOnMd": "pf-u-px-md-on-md",
  "pxMdOnSm": "pf-u-px-md-on-sm",
  "pxMdOnXl": "pf-u-px-md-on-xl",
  "pxMdOn_2xl": "pf-u-px-md-on-2xl",
  "pxSm": "pf-u-px-sm",
  "pxSmOnLg": "pf-u-px-sm-on-lg",
  "pxSmOnMd": "pf-u-px-sm-on-md",
  "pxSmOnSm": "pf-u-px-sm-on-sm",
  "pxSmOnXl": "pf-u-px-sm-on-xl",
  "pxSmOn_2xl": "pf-u-px-sm-on-2xl",
  "pxXl": "pf-u-px-xl",
  "pxXlOnLg": "pf-u-px-xl-on-lg",
  "pxXlOnMd": "pf-u-px-xl-on-md",
  "pxXlOnSm": "pf-u-px-xl-on-sm",
  "pxXlOnXl": "pf-u-px-xl-on-xl",
  "pxXlOn_2xl": "pf-u-px-xl-on-2xl",
  "pxXs": "pf-u-px-xs",
  "pxXsOnLg": "pf-u-px-xs-on-lg",
  "pxXsOnMd": "pf-u-px-xs-on-md",
  "pxXsOnSm": "pf-u-px-xs-on-sm",
  "pxXsOnXl": "pf-u-px-xs-on-xl",
  "pxXsOn_2xl": "pf-u-px-xs-on-2xl",
  "px_0": "pf-u-px-0",
  "px_0OnLg": "pf-u-px-0-on-lg",
  "px_0OnMd": "pf-u-px-0-on-md",
  "px_0OnSm": "pf-u-px-0-on-sm",
  "px_0OnXl": "pf-u-px-0-on-xl",
  "px_0On_2xl": "pf-u-px-0-on-2xl",
  "px_2xl": "pf-u-px-2xl",
  "px_2xlOnLg": "pf-u-px-2xl-on-lg",
  "px_2xlOnMd": "pf-u-px-2xl-on-md",
  "px_2xlOnSm": "pf-u-px-2xl-on-sm",
  "px_2xlOnXl": "pf-u-px-2xl-on-xl",
  "px_2xlOn_2xl": "pf-u-px-2xl-on-2xl",
  "px_3xl": "pf-u-px-3xl",
  "px_3xlOnLg": "pf-u-px-3xl-on-lg",
  "px_3xlOnMd": "pf-u-px-3xl-on-md",
  "px_3xlOnSm": "pf-u-px-3xl-on-sm",
  "px_3xlOnXl": "pf-u-px-3xl-on-xl",
  "px_3xlOn_2xl": "pf-u-px-3xl-on-2xl",
  "px_4xl": "pf-u-px-4xl",
  "px_4xlOnLg": "pf-u-px-4xl-on-lg",
  "px_4xlOnMd": "pf-u-px-4xl-on-md",
  "px_4xlOnSm": "pf-u-px-4xl-on-sm",
  "px_4xlOnXl": "pf-u-px-4xl-on-xl",
  "px_4xlOn_2xl": "pf-u-px-4xl-on-2xl",
  "pyAuto": "pf-u-py-auto",
  "pyAutoOnLg": "pf-u-py-auto-on-lg",
  "pyAutoOnMd": "pf-u-py-auto-on-md",
  "pyAutoOnSm": "pf-u-py-auto-on-sm",
  "pyAutoOnXl": "pf-u-py-auto-on-xl",
  "pyAutoOn_2xl": "pf-u-py-auto-on-2xl",
  "pyLg": "pf-u-py-lg",
  "pyLgOnLg": "pf-u-py-lg-on-lg",
  "pyLgOnMd": "pf-u-py-lg-on-md",
  "pyLgOnSm": "pf-u-py-lg-on-sm",
  "pyLgOnXl": "pf-u-py-lg-on-xl",
  "pyLgOn_2xl": "pf-u-py-lg-on-2xl",
  "pyMd": "pf-u-py-md",
  "pyMdOnLg": "pf-u-py-md-on-lg",
  "pyMdOnMd": "pf-u-py-md-on-md",
  "pyMdOnSm": "pf-u-py-md-on-sm",
  "pyMdOnXl": "pf-u-py-md-on-xl",
  "pyMdOn_2xl": "pf-u-py-md-on-2xl",
  "pySm": "pf-u-py-sm",
  "pySmOnLg": "pf-u-py-sm-on-lg",
  "pySmOnMd": "pf-u-py-sm-on-md",
  "pySmOnSm": "pf-u-py-sm-on-sm",
  "pySmOnXl": "pf-u-py-sm-on-xl",
  "pySmOn_2xl": "pf-u-py-sm-on-2xl",
  "pyXl": "pf-u-py-xl",
  "pyXlOnLg": "pf-u-py-xl-on-lg",
  "pyXlOnMd": "pf-u-py-xl-on-md",
  "pyXlOnSm": "pf-u-py-xl-on-sm",
  "pyXlOnXl": "pf-u-py-xl-on-xl",
  "pyXlOn_2xl": "pf-u-py-xl-on-2xl",
  "pyXs": "pf-u-py-xs",
  "pyXsOnLg": "pf-u-py-xs-on-lg",
  "pyXsOnMd": "pf-u-py-xs-on-md",
  "pyXsOnSm": "pf-u-py-xs-on-sm",
  "pyXsOnXl": "pf-u-py-xs-on-xl",
  "pyXsOn_2xl": "pf-u-py-xs-on-2xl",
  "py_0": "pf-u-py-0",
  "py_0OnLg": "pf-u-py-0-on-lg",
  "py_0OnMd": "pf-u-py-0-on-md",
  "py_0OnSm": "pf-u-py-0-on-sm",
  "py_0OnXl": "pf-u-py-0-on-xl",
  "py_0On_2xl": "pf-u-py-0-on-2xl",
  "py_2xl": "pf-u-py-2xl",
  "py_2xlOnLg": "pf-u-py-2xl-on-lg",
  "py_2xlOnMd": "pf-u-py-2xl-on-md",
  "py_2xlOnSm": "pf-u-py-2xl-on-sm",
  "py_2xlOnXl": "pf-u-py-2xl-on-xl",
  "py_2xlOn_2xl": "pf-u-py-2xl-on-2xl",
  "py_3xl": "pf-u-py-3xl",
  "py_3xlOnLg": "pf-u-py-3xl-on-lg",
  "py_3xlOnMd": "pf-u-py-3xl-on-md",
  "py_3xlOnSm": "pf-u-py-3xl-on-sm",
  "py_3xlOnXl": "pf-u-py-3xl-on-xl",
  "py_3xlOn_2xl": "pf-u-py-3xl-on-2xl",
  "py_4xl": "pf-u-py-4xl",
  "py_4xlOnLg": "pf-u-py-4xl-on-lg",
  "py_4xlOnMd": "pf-u-py-4xl-on-md",
  "py_4xlOnSm": "pf-u-py-4xl-on-sm",
  "py_4xlOnXl": "pf-u-py-4xl-on-xl",
  "py_4xlOn_2xl": "pf-u-py-4xl-on-2xl"
};

var getAggregateQueryStatus = function (queryResults) {
    if (queryResults.some(function (result) { return result.isError; }))
        return 'error';
    if (queryResults.some(function (result) { return result.isLoading; }))
        return 'loading';
    if (queryResults.every(function (result) { return result.isIdle; }))
        return 'idle';
    return 'success';
};

var LoadingEmptyState = function (_a) {
    var _b = _a.className, className = _b === void 0 ? '' : _b, _c = _a.spinnerProps, spinnerProps = _c === void 0 ? {} : _c, _d = _a.body, body = _d === void 0 ? null : _d;
    return (React__namespace.createElement(reactCore.Bullseye, { className: className },
        React__namespace.createElement(reactCore.EmptyState, { variant: "large" },
            React__namespace.createElement("div", { className: "pf-c-empty-state__icon" },
                React__namespace.createElement(reactCore.Spinner, __assign({ "aria-labelledby": "loadingPrefLabel", size: "xl" }, spinnerProps))),
            React__namespace.createElement(reactCore.Title, { id: "loadingPrefLabel", headingLevel: "h2" }, "Loading..."),
            body ? React__namespace.createElement(reactCore.EmptyStateBody, null, body) : null)));
};

var ResolvedQueries = function (_a) {
    var resultsWithErrorTitles = _a.resultsWithErrorTitles, _b = _a.errorsInline, errorsInline = _b === void 0 ? true : _b, _c = _a.spinnerMode, spinnerMode = _c === void 0 ? 'emptyState' : _c, _d = _a.emptyStateBody, emptyStateBody = _d === void 0 ? null : _d, _e = _a.spinnerProps, spinnerProps = _e === void 0 ? {} : _e, _f = _a.alertProps, alertProps = _f === void 0 ? {} : _f, _g = _a.className, className = _g === void 0 ? '' : _g, _h = _a.forceLoadingState, forceLoadingState = _h === void 0 ? false : _h, _j = _a.children, children = _j === void 0 ? null : _j;
    var status = getAggregateQueryStatus(resultsWithErrorTitles.map(function (r) { return r.result; }));
    var erroredResults = resultsWithErrorTitles.filter(function (resultWithErrorTitle) { return resultWithErrorTitle.result.isError; });
    var spinner = null;
    if (spinnerMode === 'inline') {
        spinner = React__namespace.createElement(reactCore.Spinner, __assign({ size: "lg", className: className }, spinnerProps));
    }
    else if (spinnerMode === 'emptyState') {
        spinner = React__namespace.createElement(LoadingEmptyState, { spinnerProps: spinnerProps, body: emptyStateBody });
    }
    return (React__namespace.createElement(React__namespace.Fragment, null, status === 'loading' || forceLoadingState ? (spinner) : status === 'error' ? (React__namespace.createElement(reactCore.AlertGroup, { "aria-live": "assertive" }, erroredResults.map(function (resultWithErrorTitle, index) {
        var _a, _b;
        var result = resultWithErrorTitle.result, errorTitle = resultWithErrorTitle.errorTitle;
        return (React__namespace.createElement(reactCore.Alert, __assign({ key: "error-" + index, variant: "danger", isInline: errorsInline, title: errorTitle, className: (index !== erroredResults.length - 1 ? _default.mbMd : '') + " " + className, actionClose: result.reset ? (React__namespace.createElement(reactCore.AlertActionCloseButton, { "aria-label": "Dismiss error", onClose: result.reset })) : null }, alertProps), result.error ? (React__namespace.createElement(React__namespace.Fragment, null,
            result.error.message || null,
            result.error.response ? (React__namespace.createElement(React__namespace.Fragment, null,
                React__namespace.createElement("br", null), (_b = (_a = result.error.response) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 :
                _b.message)) : null,
            result.error.status
                ? result.error.status + ": " + result.error.statusText
                : null,
            typeof result.error === 'string' ? result.error : null)) : null));
    }))) : (children)));
};

var ResolvedQuery = function (_a) {
    var result = _a.result, errorTitle = _a.errorTitle, props = __rest(_a, ["result", "errorTitle"]);
    return (React__namespace.createElement(ResolvedQueries, __assign({}, props, { resultsWithErrorTitles: [{ result: result, errorTitle: errorTitle }] })));
};

var useSelectionState = function (_a) {
    var items = _a.items, _b = _a.initialSelected, initialSelected = _b === void 0 ? [] : _b, _c = _a.isEqual, isEqual = _c === void 0 ? function (a, b) { return a === b; } : _c, externalState = _a.externalState;
    var internalState = React__namespace.useState(initialSelected);
    var _d = externalState || internalState, selectedItems = _d[0], setSelectedItems = _d[1];
    var isItemSelected = function (item) { return selectedItems.some(function (i) { return isEqual(item, i); }); };
    var toggleItemSelected = function (item, isSelecting) {
        if (isSelecting === void 0) { isSelecting = !isItemSelected(item); }
        if (isSelecting) {
            setSelectedItems(__spreadArray(__spreadArray([], selectedItems), [item]));
        }
        else {
            setSelectedItems(selectedItems.filter(function (i) { return !isEqual(i, item); }));
        }
    };
    var selectMultiple = function (items, isSelecting) {
        var otherSelectedItems = selectedItems.filter(function (selected) { return !items.some(function (item) { return isEqual(selected, item); }); });
        if (isSelecting) {
            setSelectedItems(__spreadArray(__spreadArray([], otherSelectedItems), items));
        }
        else {
            setSelectedItems(otherSelectedItems);
        }
    };
    var selectAll = function (isSelecting) {
        if (isSelecting === void 0) { isSelecting = true; }
        return setSelectedItems(isSelecting ? items : []);
    };
    var areAllSelected = selectedItems.length === items.length;
    // Preserve original order of items
    var selectedItemsInOrder = [];
    if (areAllSelected) {
        selectedItemsInOrder = items;
    }
    else if (selectedItems.length > 0) {
        selectedItemsInOrder = items.filter(isItemSelected);
    }
    return {
        selectedItems: selectedItemsInOrder,
        isItemSelected: isItemSelected,
        toggleItemSelected: toggleItemSelected,
        selectMultiple: selectMultiple,
        areAllSelected: areAllSelected,
        selectAll: selectAll,
        setSelectedItems: setSelectedItems,
    };
};

function namedPath(listPath, name) {
    return [listPath, name].join('/');
}
var NamespacedResource = /** @class */ (function () {
    function NamespacedResource(namespace) {
        if (!namespace) {
            throw new Error('NamespacedResource must be passed a namespace, it was undefined');
        }
        this.namespace = namespace;
    }
    NamespacedResource.prototype.listPath = function () {
        return [
            '/apis',
            this.gvk().group,
            this.gvk().version,
            'namespaces',
            this.namespace,
            this.gvk().kindPlural,
        ].join('/');
    };
    NamespacedResource.prototype.namedPath = function (name) {
        return namedPath(this.listPath(), name);
    };
    return NamespacedResource;
}());
var ClusterResource = /** @class */ (function () {
    function ClusterResource() {
    }
    ClusterResource.prototype.listPath = function () {
        return ['/apis', this.gvk().group, this.gvk().version, this.gvk().kindPlural].join('/');
    };
    ClusterResource.prototype.namedPath = function (name) {
        return namedPath(this.listPath(), name);
    };
    return ClusterResource;
}());
var OAuthClient = /** @class */ (function () {
    function OAuthClient(token) {
        this._tokenExpiryTime = null;
        this._tokenExpiryHandler = null;
        this._token = token;
    }
    OAuthClient.prototype.getOAuthHeader = function () {
        return {
            Authorization: "Bearer " + this._token,
        };
    };
    OAuthClient.prototype.setTokenExpiryHandler = function (handler, tokenExpiryTime) {
        this._tokenExpiryHandler = handler;
        this._tokenExpiryTime = tokenExpiryTime;
    };
    OAuthClient.prototype.checkExpiry = function (err) {
        if (err.response && err.response.status === 401) {
            this._tokenExpiryHandler && this._tokenExpiryHandler(this._oldToken());
        }
    };
    OAuthClient.prototype._oldToken = function () {
        return {
            token: this._token,
            tokenExpiryTime: this._tokenExpiryTime,
        };
    };
    return OAuthClient;
}());

var axios;
try {
    axios = require('axios');
    // eslint-disable-next-line no-empty
}
catch (e) { }
var ClientTokenExpiredError = /** @class */ (function (_super) {
    __extends(ClientTokenExpiredError, _super);
    function ClientTokenExpiredError() {
        var _this = _super.call(this, 'The api token has expired') || this;
        Object.setPrototypeOf(_this, ClientTokenExpiredError.prototype);
        return _this;
    }
    return ClientTokenExpiredError;
}(Error));
var ClusterClient = /** @class */ (function (_super) {
    __extends(ClusterClient, _super);
    function ClusterClient(apiRoot, token, customResponseType) {
        if (customResponseType === void 0) { customResponseType = 'json'; }
        var _this = _super.call(this, token) || this;
        _this.list = function (resource, params) { return __awaiter(_this, void 0, void 0, function () {
            var err_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.requester.get(resource.listPath(), { params: params })];
                    case 1: return [2 /*return*/, _a.sent()];
                    case 2:
                        err_1 = _a.sent();
                        _super.prototype.checkExpiry.call(this, err_1);
                        throw err_1;
                    case 3: return [2 /*return*/];
                }
            });
        }); };
        _this.get = function (resource, name, params) { return __awaiter(_this, void 0, void 0, function () {
            var err_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.requester.get(resource.namedPath(name), { params: params })];
                    case 1: return [2 /*return*/, _a.sent()];
                    case 2:
                        err_2 = _a.sent();
                        _super.prototype.checkExpiry.call(this, err_2);
                        throw err_2;
                    case 3: return [2 /*return*/];
                }
            });
        }); };
        _this.put = function (resource, name, updatedObject, params) { return __awaiter(_this, void 0, void 0, function () {
            var err_3;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.requester.put(resource.namedPath(name), updatedObject, { params: params })];
                    case 1: return [2 /*return*/, _a.sent()];
                    case 2:
                        err_3 = _a.sent();
                        _super.prototype.checkExpiry.call(this, err_3);
                        throw err_3;
                    case 3: return [2 /*return*/];
                }
            });
        }); };
        _this.patch = function (resource, name, patch, params) { return __awaiter(_this, void 0, void 0, function () {
            var err_4;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.patchRequester.patch(resource.namedPath(name), patch, { params: params })];
                    case 1: return [2 /*return*/, _a.sent()];
                    case 2:
                        err_4 = _a.sent();
                        _super.prototype.checkExpiry.call(this, err_4);
                        throw err_4;
                    case 3: return [2 /*return*/];
                }
            });
        }); };
        _this.create = function (resource, newObject, params) { return __awaiter(_this, void 0, void 0, function () {
            var err_5;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.requester.post(resource.listPath(), newObject, { params: params })];
                    case 1: return [2 /*return*/, _a.sent()];
                    case 2:
                        err_5 = _a.sent();
                        _super.prototype.checkExpiry.call(this, err_5);
                        throw err_5;
                    case 3: return [2 /*return*/];
                }
            });
        }); };
        _this.delete = function (resource, name, params) { return __awaiter(_this, void 0, void 0, function () {
            var err_6;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.requester.delete(resource.namedPath(name), { params: params })];
                    case 1: return [2 /*return*/, _a.sent()];
                    case 2:
                        err_6 = _a.sent();
                        _super.prototype.checkExpiry.call(this, err_6);
                        throw err_6;
                    case 3: return [2 /*return*/];
                }
            });
        }); };
        _this.apiRoot = apiRoot;
        _this.requester = axios.create({
            baseURL: _this.apiRoot,
            headers: __assign(__assign({}, _super.prototype.getOAuthHeader.call(_this)), { 'Content-Type': 'application/json' }),
            transformResponse: undefined,
            responseType: customResponseType,
        });
        _this.patchRequester = axios.create({
            baseURL: _this.apiRoot,
            headers: __assign(__assign({}, _super.prototype.getOAuthHeader.call(_this)), { 'Content-Type': 'application/merge-patch+json' }),
            responseType: customResponseType,
        });
        return _this;
    }
    return ClusterClient;
}(OAuthClient));

var ClientFactoryUnknownClusterError = /** @class */ (function (_super) {
    __extends(ClientFactoryUnknownClusterError, _super);
    function ClientFactoryUnknownClusterError(clusterName) {
        var _this = _super.call(this, "Unknown cluster requested: " + clusterName) || this;
        Object.setPrototypeOf(_this, ClientFactoryUnknownClusterError.prototype);
        return _this;
    }
    return ClientFactoryUnknownClusterError;
}(Error));
var ClientFactoryMissingUserError = /** @class */ (function (_super) {
    __extends(ClientFactoryMissingUserError, _super);
    function ClientFactoryMissingUserError() {
        var _this = _super.call(this, 'Current user missing from client factory') || this;
        Object.setPrototypeOf(_this, ClientFactoryMissingUserError.prototype);
        return _this;
    }
    return ClientFactoryMissingUserError;
}(Error));
var ClientFactoryMissingApiRoot = /** @class */ (function (_super) {
    __extends(ClientFactoryMissingApiRoot, _super);
    function ClientFactoryMissingApiRoot() {
        var _this = _super.call(this, 'Cluster API URL missing from client factory') || this;
        Object.setPrototypeOf(_this, ClientFactoryMissingUserError.prototype);
        return _this;
    }
    return ClientFactoryMissingApiRoot;
}(Error));
var tokenExpiryHandler = null;
var ClientFactory = {
    cluster: function (user, clusterApi, customResponseType) {
        if (customResponseType === void 0) { customResponseType = 'json'; }
        if (!user) {
            throw new ClientFactoryMissingUserError();
        }
        if (!clusterApi) {
            throw new ClientFactoryMissingApiRoot();
        }
        var newClient = new ClusterClient(clusterApi, user.access_token, customResponseType);
        if (tokenExpiryHandler) {
            newClient.setTokenExpiryHandler(tokenExpiryHandler, user.expiry_time);
        }
        return newClient;
    },
};
var setTokenExpiryHandler = function (newExpiryHandler) {
    tokenExpiryHandler = newExpiryHandler;
};

var CoreNamespacedResource = /** @class */ (function (_super) {
    __extends(CoreNamespacedResource, _super);
    function CoreNamespacedResource(kind, namespace) {
        var _this = _super.call(this, namespace) || this;
        _this._gvk = {
            group: '',
            version: 'v1',
            kindPlural: kind,
        };
        return _this;
    }
    CoreNamespacedResource.prototype.gvk = function () {
        return this._gvk;
    };
    CoreNamespacedResource.prototype.listPath = function () {
        // The core resources live at a unique api path for legacy reasons, and do
        // not have an API group
        return ['/api', this.gvk().version, 'namespaces', this.namespace, this.gvk().kindPlural].join('/');
    };
    return CoreNamespacedResource;
}(NamespacedResource));
var ExtendedCoreNamespacedResource = /** @class */ (function (_super) {
    __extends(ExtendedCoreNamespacedResource, _super);
    function ExtendedCoreNamespacedResource(kind, namespace, operation) {
        var _this = _super.call(this, kind, namespace) || this;
        _this._operation = operation;
        return _this;
    }
    ExtendedCoreNamespacedResource.prototype.showOperation = function () {
        return this._operation;
    };
    ExtendedCoreNamespacedResource.prototype.namedPath = function (name) {
        return [this.listPath(), name, this._operation].join('/');
    };
    return ExtendedCoreNamespacedResource;
}(CoreNamespacedResource));
var CoreClusterResource = /** @class */ (function (_super) {
    __extends(CoreClusterResource, _super);
    function CoreClusterResource(kind) {
        var _this = _super.call(this) || this;
        _this._gvk = {
            group: '',
            version: 'v1',
            kindPlural: kind,
        };
        return _this;
    }
    CoreClusterResource.prototype.gvk = function () {
        return this._gvk;
    };
    CoreClusterResource.prototype.listPath = function () {
        // The core resources live at a unique api path for legacy reasons, and do
        // not have an API group
        return ['/api', this.gvk().version, this.gvk().kindPlural].join('/');
    };
    return CoreClusterResource;
}(ClusterResource));
exports.ExtendedCoreNamespacedResourceKind = void 0;
(function (ExtendedCoreNamespacedResourceKind) {
    ExtendedCoreNamespacedResourceKind["Log"] = "log";
})(exports.ExtendedCoreNamespacedResourceKind || (exports.ExtendedCoreNamespacedResourceKind = {}));
exports.CoreNamespacedResourceKind = void 0;
(function (CoreNamespacedResourceKind) {
    CoreNamespacedResourceKind["Pod"] = "pods";
    CoreNamespacedResourceKind["Secret"] = "secrets";
})(exports.CoreNamespacedResourceKind || (exports.CoreNamespacedResourceKind = {}));
exports.CoreClusterResourceKind = void 0;
(function (CoreClusterResourceKind) {
    CoreClusterResourceKind["Namespace"] = "namespaces";
    CoreClusterResourceKind["PV"] = "persistentvolumes";
})(exports.CoreClusterResourceKind || (exports.CoreClusterResourceKind = {}));

exports.ClientFactory = ClientFactory;
exports.ClientFactoryMissingApiRoot = ClientFactoryMissingApiRoot;
exports.ClientFactoryMissingUserError = ClientFactoryMissingUserError;
exports.ClientFactoryUnknownClusterError = ClientFactoryUnknownClusterError;
exports.ClientTokenExpiredError = ClientTokenExpiredError;
exports.ClusterClient = ClusterClient;
exports.ClusterResource = ClusterResource;
exports.CoreClusterResource = CoreClusterResource;
exports.CoreNamespacedResource = CoreNamespacedResource;
exports.ExtendedCoreNamespacedResource = ExtendedCoreNamespacedResource;
exports.NamespacedResource = NamespacedResource;
exports.OAuthClient = OAuthClient;
exports.ResolvedQueries = ResolvedQueries;
exports.ResolvedQuery = ResolvedQuery;
exports.StatusIcon = StatusIcon;
exports.ValidatedTextInput = ValidatedTextInput;
exports.getFormGroupProps = getFormGroupProps;
exports.getTextAreaProps = getTextAreaProps;
exports.getTextFieldProps = getTextFieldProps;
exports.getTextInputProps = getTextInputProps;
exports.setTokenExpiryHandler = setTokenExpiryHandler;
exports.useFormField = useFormField;
exports.useFormState = useFormState;
exports.useSelectionState = useSelectionState;
//# sourceMappingURL=index.js.map
