import * as React from 'react';
export interface ISelectionStateArgs<T> {
    items: T[];
    initialSelected?: T[];
    isEqual?: (a: T, b: T) => boolean;
    externalState?: [T[], React.Dispatch<React.SetStateAction<T[]>>];
}
export interface ISelectionState<T> {
    selectedItems: T[];
    isItemSelected: (item: T) => boolean;
    toggleItemSelected: (item: T, isSelecting?: boolean) => void;
    selectMultiple: (items: T[], isSelecting: boolean) => void;
    areAllSelected: boolean;
    selectAll: (isSelecting?: boolean) => void;
    setSelectedItems: (items: T[]) => void;
}
export declare const useSelectionState: <T>({ items, initialSelected, isEqual, externalState, }: ISelectionStateArgs<T>) => ISelectionState<T>;
