import { FormGroupProps, TextAreaProps, TextInputProps } from '@patternfly/react-core';
import * as React from 'react';
import * as yup from 'yup';
import { ValidateOptions } from 'yup/lib/types';
export interface IFormField<T> {
    value: T;
    setValue: React.Dispatch<React.SetStateAction<T>>;
    defaultValue: T;
    cleanValue: T;
    reinitialize: (value: T) => void;
    prefill: (value: T) => void;
    clear: () => void;
    revert: () => void;
    isDirty: boolean;
    isTouched: boolean;
    setIsTouched: (isTouched: boolean) => void;
    schema: yup.AnySchema<T>;
}
export interface IValidatedFormField<T> extends IFormField<T> {
    error: yup.ValidationError | null;
    isValid: boolean;
    shouldShowError: boolean;
}
declare type FormFields<TFieldValues> = {
    [key in keyof TFieldValues]: IFormField<TFieldValues[key]>;
};
declare type ValidatedFormFields<TFieldValues> = {
    [key in keyof TFieldValues]: IValidatedFormField<TFieldValues[key]>;
};
export interface IFormState<TFieldValues> {
    fields: ValidatedFormFields<TFieldValues>;
    values: TFieldValues;
    isDirty: boolean;
    isValid: boolean;
    isTouched: boolean;
    clear: () => void;
    revert: () => void;
}
export declare const useFormField: <T>(initialValue: T, schema: yup.AnySchema<T | undefined, any, any>, options?: {
    initialTouched?: boolean;
}) => IFormField<T>;
export declare const useFormState: <TFieldValues>(fields: FormFields<TFieldValues>, yupOptions?: ValidateOptions) => IFormState<TFieldValues>;
export declare const getFormGroupProps: <T>(field: Pick<IValidatedFormField<T>, "isTouched" | "isValid" | "error" | "shouldShowError">, greenWhenValid?: boolean) => Pick<FormGroupProps, 'validated' | 'helperTextInvalid'>;
export declare const getTextFieldProps: (field: IValidatedFormField<string> | IValidatedFormField<string | undefined>, greenWhenValid?: boolean) => Pick<TextInputProps | TextAreaProps, 'value' | 'onChange' | 'onBlur' | 'validated'>;
export declare const getTextInputProps: (field: IValidatedFormField<string> | IValidatedFormField<string | undefined>, greenWhenValid?: boolean) => Partial<TextInputProps>;
export declare const getTextAreaProps: (field: IValidatedFormField<string> | IValidatedFormField<string | undefined>, greenWhenValid?: boolean) => Partial<TextAreaProps>;
export {};
