<img src="https://static.scarf.sh/a.png?x-pxid=be2d8a11-9712-4c1d-9963-580b2d4fb133" />

![React Query Header](https://github.com/tannerlinsley/react-query/raw/master/media/repo-dark.png)

Hooks for fetching, caching and updating asynchronous data in React

<a href="https://twitter.com/intent/tweet?button_hashtag=TanStack" target="\_parent">
  <img alt="#TanStack" src="https://img.shields.io/twitter/url?color=%2308a0e9&label=%23TanStack&style=social&url=https%3A%2F%2Ftwitter.com%2Fintent%2Ftweet%3Fbutton_hashtag%3DTanStack">
</a><a href="https://discord.com/invite/WrRKjPJ" target="\_parent">
  <img alt="" src="https://img.shields.io/badge/Discord-TanStack-%235865F2" />
</a><a href="https://github.com/tannerlinsley/react-query/actions?query=workflow%3A%22react-query+tests%22">
<img src="https://github.com/tannerlinsley/react-query/workflows/react-query%20tests/badge.svg" />
</a><a href="https://npmjs.com/package/react-query" target="\_parent">
  <img alt="" src="https://img.shields.io/npm/dm/react-query.svg" />
</a><a href="https://bundlephobia.com/result?p=react-query@latest" target="\_parent">
  <img alt="" src="https://badgen.net/bundlephobia/minzip/react-query@latest" />
</a><a href="#badge">
    <img alt="semantic-release" src="https://img.shields.io/badge/%20%20%F0%9F%93%A6%F0%9F%9A%80-semantic--release-e10079.svg">
  </a><a href="https://github.com/tannerlinsley/react-query/discussions">
  <img alt="Join the discussion on Github" src="https://img.shields.io/badge/Github%20Discussions%20%26%20Support-Chat%20now!-blue" />
</a><a href="https://bestofjs.org/projects/react-query"><img alt="Best of JS" src="https://img.shields.io/endpoint?url=https://bestofjs-serverless.now.sh/api/project-badge?fullName=tannerlinsley%2Freact-query%26since=daily" /></a><a href="https://github.com/tannerlinsley/react-query" target="\_parent">
  <img alt="" src="https://img.shields.io/github/stars/tannerlinsley/react-query.svg?style=social&label=Star" />
</a><a href="https://twitter.com/tannerlinsley" target="\_parent">
  <img alt="" src="https://img.shields.io/twitter/follow/tannerlinsley.svg?style=social&label=Follow" />
</a> <a href="https://gitpod.io/from-referrer/">
  <img src="https://img.shields.io/badge/Gitpod-Ready--to--Code-blue?logo=gitpod" alt="Gitpod Ready-to-Code"/>
</a>

Enjoy this library? Try the entire [TanStack](https://tanstack.com)! [React Table](https://github.com/tannerlinsley/react-table), [React Form](https://github.com/tannerlinsley/react-form), [React Charts](https://github.com/tannerlinsley/react-charts)

## Visit [react-query.tanstack.com](https://react-query.tanstack.com) for docs, guides, API and more!

Still on **React Query v2**? No problem! Check out the v2 docs here: https://react-query-v2.tanstack.com/.
## Quick Features

- Transport/protocol/backend agnostic data fetching (REST, GraphQL, promises, whatever!)
- Auto Caching + Refetching (stale-while-revalidate, Window Refocus, Polling/Realtime)
- Parallel + Dependent Queries
- Mutations + Reactive Query Refetching
- Multi-layer Cache + Automatic Garbage Collection
- Paginated + Cursor-based Queries
- Load-More + Infinite Scroll Queries w/ Scroll Recovery
- Request Cancellation
- [React Suspense](https://reactjs.org/docs/concurrent-mode-suspense.html) + Fetch-As-You-Render Query Prefetching
- Dedicated Devtools
- <a href="https://bundlephobia.com/result?p=react-query@latest" target="\_parent">
  <img alt="" src="https://badgen.net/bundlephobia/minzip/react-query@latest" />
  </a> (depending on features imported)

### [Become a Sponsor!](https://github.com/sponsors/tannerlinsley/)

# Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://tannerlinsley.com"><img src="https://avatars0.githubusercontent.com/u/5580297?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Tanner Linsley</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=tannerlinsley" title="Code">💻</a> <a href="#ideas-tannerlinsley" title="Ideas, Planning, & Feedback">🤔</a> <a href="#example-tannerlinsley" title="Examples">💡</a> <a href="#maintenance-tannerlinsley" title="Maintenance">🚧</a> <a href="https://github.com/tannerlinsley/react-query/pulls?q=is%3Apr+reviewed-by%3Atannerlinsley" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="http://cherniavskii.com"><img src="https://avatars2.githubusercontent.com/u/13808724?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Andrew Cherniavskii</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=cherniavskii" title="Code">💻</a> <a href="https://github.com/tannerlinsley/react-query/issues?q=author%3Acherniavskii" title="Bug reports">🐛</a></td>
    <td align="center"><a href="http://twitter.com/tibotiber"><img src="https://avatars3.githubusercontent.com/u/5635553?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Thibaut Tiberghien</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=tibotiber" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/gargroh"><img src="https://avatars3.githubusercontent.com/u/42495927?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Rohit Garg</b></sub></a><br /><a href="#tool-gargroh" title="Tools">🔧</a></td>
    <td align="center"><a href="https://github.com/Avi98"><img src="https://avatars1.githubusercontent.com/u/26133749?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Avinash</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=Avi98" title="Code">💻</a> <a href="https://github.com/tannerlinsley/react-query/issues?q=author%3AAvi98" title="Bug reports">🐛</a></td>
    <td align="center"><a href="https://github.com/CreativeTechGuy"><img src="https://avatars1.githubusercontent.com/u/12002072?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jason O'Neill</b></sub></a><br /><a href="#maintenance-CreativeTechGuy" title="Maintenance">🚧</a> <a href="https://github.com/tannerlinsley/react-query/commits?author=CreativeTechGuy" title="Tests">⚠️</a></td>
    <td align="center"><a href="http://fb.me/yz"><img src="https://avatars3.githubusercontent.com/u/14841421?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jack Zhao</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=bugzpodder" title="Code">💻</a> <a href="https://github.com/tannerlinsley/react-query/issues?q=author%3Abugzpodder" title="Bug reports">🐛</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/dpyzo0o"><img src="https://avatars1.githubusercontent.com/u/24768249?v=4?s=100" width="100px;" alt=""/><br /><sub><b>dpyzo0o</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=dpyzo0o" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/jelteliekens"><img src="https://avatars1.githubusercontent.com/u/3418474?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jelte Liekens</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=jelteliekens" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/jgettings"><img src="https://avatars0.githubusercontent.com/u/4183742?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jen Gettings</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=jgettings" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/justincy"><img src="https://avatars2.githubusercontent.com/u/1037458?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Justin</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=justincy" title="Code">💻</a></td>
    <td align="center"><a href="http://www.marceloalves.com"><img src="https://avatars1.githubusercontent.com/u/216782?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Marcelo Alves</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=MarceloAlves" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/zorzysty"><img src="https://avatars0.githubusercontent.com/u/5398733?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Zorza</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=zorzysty" title="Documentation">📖</a></td>
    <td align="center"><a href="https://tkdodo.eu"><img src="https://avatars0.githubusercontent.com/u/1021430?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Dominik Dorfmeister</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=tkdodo" title="Code">💻</a> <a href="https://github.com/tannerlinsley/react-query/commits?author=tkdodo" title="Documentation">📖</a> <a href="#maintenance-tkdodo" title="Maintenance">🚧</a> <a href="#question-tkdodo" title="Answering Questions">💬</a> <a href="https://github.com/tannerlinsley/react-query/pulls?q=is%3Apr+reviewed-by%3Atkdodo" title="Reviewed Pull Requests">👀</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://katt.dev"><img src="https://avatars.githubusercontent.com/u/459267?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Alex Johansson</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=KATT" title="Code">💻</a></td>
    <td align="center"><a href="http://www.eddyvinck.nl"><img src="https://avatars.githubusercontent.com/u/23434753?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Eddy</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=EddyVinck" title="Code">💻</a></td>
    <td align="center"><a href="http://prateeksurana.me"><img src="https://avatars.githubusercontent.com/u/21277179?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Prateek Surana</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=prateek3255" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/babycourageous"><img src="https://avatars.githubusercontent.com/u/14936212?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Rene Dellefont</b></sub></a><br /><a href="https://github.com/tannerlinsley/react-query/commits?author=babycourageous" title="Code">💻</a> <a href="https://github.com/tannerlinsley/react-query/commits?author=babycourageous" title="Documentation">📖</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!

<!-- Force 3 -->
