import { NamedDiscoveryResource, DiscoveryResource, IDiscoveryParameters } from './common';
import { IDiscoveryClient } from '../discoveryClient';
export declare enum ClusterKind {
    source = "source",
    destination = "destination",
    controller = "controller"
}
export interface IPodContainer {
    name: string;
    log: string;
}
export interface IPodLogSource {
    name: string;
    namespace: string;
    containers: IPodContainer[];
}
export declare type IPlanLogSources = {
    [key in ClusterKind]: IPodLogSource[];
};
export interface IPlanReport extends IPlanLogSources {
    namespace: string;
    name: string;
}
export declare class NamespaceDiscovery extends DiscoveryResource {
    constructor(cluster: string, params?: IDiscoveryParameters);
    get(client: IDiscoveryClient): Promise<string[]>;
}
export declare class PersistentVolumesDiscovery extends DiscoveryResource {
    constructor(cluster: string, params?: IDiscoveryParameters);
    get(client: IDiscoveryClient): Promise<any>;
}
export declare class PersistentVolumeDiscovery extends NamedDiscoveryResource {
    constructor(name: string, cluster: string, params?: IDiscoveryParameters);
    get(client: IDiscoveryClient): Promise<any[]>;
}
export declare class PlanPodReportDiscovery extends DiscoveryResource {
    constructor(planName: string, params?: IDiscoveryParameters);
    get(client: IDiscoveryClient): Promise<IPlanReport>;
}
export declare class DebugTreeDiscoveryResource extends DiscoveryResource {
    constructor(planName: string, params?: IDiscoveryParameters);
}
