import { NamespacedResource, ClusterResource, IGroupVersionKindPlural } from './common';
export declare class CoreNamespacedResource extends NamespacedResource {
    private _gvk;
    constructor(kind: CoreNamespacedResourceKind, namespace: string);
    gvk(): IGroupVersionKindPlural;
    listPath(): string;
}
export declare class ExtendedCoreNamespacedResource extends CoreNamespacedResource {
    private _operation;
    constructor(kind: CoreNamespacedResourceKind, namespace: string, operation: ExtendedCoreNamespacedResourceKind);
    showOperation(): ExtendedCoreNamespacedResourceKind;
    namedPath(name: string): string;
}
export declare class CoreClusterResource extends ClusterResource {
    private _gvk;
    constructor(kind: CoreClusterResourceKind);
    gvk(): IGroupVersionKindPlural;
    listPath(): string;
}
export declare enum ExtendedCoreNamespacedResourceKind {
    Log = "log"
}
export declare enum CoreNamespacedResourceKind {
    Pod = "pods",
    Secret = "secrets"
}
export declare enum CoreClusterResourceKind {
    Namespace = "namespaces",
    PV = "persistentvolumes"
}
