// Code generated by entc, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"math"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/dexidp/dex/storage/ent/db/predicate"
	"github.com/dexidp/dex/storage/ent/db/refreshtoken"
)

// RefreshTokenQuery is the builder for querying RefreshToken entities.
type RefreshTokenQuery struct {
	config
	limit      *int
	offset     *int
	unique     *bool
	order      []OrderFunc
	fields     []string
	predicates []predicate.RefreshToken
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the RefreshTokenQuery builder.
func (rtq *RefreshTokenQuery) Where(ps ...predicate.RefreshToken) *RefreshTokenQuery {
	rtq.predicates = append(rtq.predicates, ps...)
	return rtq
}

// Limit adds a limit step to the query.
func (rtq *RefreshTokenQuery) Limit(limit int) *RefreshTokenQuery {
	rtq.limit = &limit
	return rtq
}

// Offset adds an offset step to the query.
func (rtq *RefreshTokenQuery) Offset(offset int) *RefreshTokenQuery {
	rtq.offset = &offset
	return rtq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (rtq *RefreshTokenQuery) Unique(unique bool) *RefreshTokenQuery {
	rtq.unique = &unique
	return rtq
}

// Order adds an order step to the query.
func (rtq *RefreshTokenQuery) Order(o ...OrderFunc) *RefreshTokenQuery {
	rtq.order = append(rtq.order, o...)
	return rtq
}

// First returns the first RefreshToken entity from the query.
// Returns a *NotFoundError when no RefreshToken was found.
func (rtq *RefreshTokenQuery) First(ctx context.Context) (*RefreshToken, error) {
	nodes, err := rtq.Limit(1).All(ctx)
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{refreshtoken.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (rtq *RefreshTokenQuery) FirstX(ctx context.Context) *RefreshToken {
	node, err := rtq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first RefreshToken ID from the query.
// Returns a *NotFoundError when no RefreshToken ID was found.
func (rtq *RefreshTokenQuery) FirstID(ctx context.Context) (id string, err error) {
	var ids []string
	if ids, err = rtq.Limit(1).IDs(ctx); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{refreshtoken.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (rtq *RefreshTokenQuery) FirstIDX(ctx context.Context) string {
	id, err := rtq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single RefreshToken entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when exactly one RefreshToken entity is not found.
// Returns a *NotFoundError when no RefreshToken entities are found.
func (rtq *RefreshTokenQuery) Only(ctx context.Context) (*RefreshToken, error) {
	nodes, err := rtq.Limit(2).All(ctx)
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{refreshtoken.Label}
	default:
		return nil, &NotSingularError{refreshtoken.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (rtq *RefreshTokenQuery) OnlyX(ctx context.Context) *RefreshToken {
	node, err := rtq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only RefreshToken ID in the query.
// Returns a *NotSingularError when exactly one RefreshToken ID is not found.
// Returns a *NotFoundError when no entities are found.
func (rtq *RefreshTokenQuery) OnlyID(ctx context.Context) (id string, err error) {
	var ids []string
	if ids, err = rtq.Limit(2).IDs(ctx); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{refreshtoken.Label}
	default:
		err = &NotSingularError{refreshtoken.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (rtq *RefreshTokenQuery) OnlyIDX(ctx context.Context) string {
	id, err := rtq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of RefreshTokens.
func (rtq *RefreshTokenQuery) All(ctx context.Context) ([]*RefreshToken, error) {
	if err := rtq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	return rtq.sqlAll(ctx)
}

// AllX is like All, but panics if an error occurs.
func (rtq *RefreshTokenQuery) AllX(ctx context.Context) []*RefreshToken {
	nodes, err := rtq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of RefreshToken IDs.
func (rtq *RefreshTokenQuery) IDs(ctx context.Context) ([]string, error) {
	var ids []string
	if err := rtq.Select(refreshtoken.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (rtq *RefreshTokenQuery) IDsX(ctx context.Context) []string {
	ids, err := rtq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (rtq *RefreshTokenQuery) Count(ctx context.Context) (int, error) {
	if err := rtq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return rtq.sqlCount(ctx)
}

// CountX is like Count, but panics if an error occurs.
func (rtq *RefreshTokenQuery) CountX(ctx context.Context) int {
	count, err := rtq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (rtq *RefreshTokenQuery) Exist(ctx context.Context) (bool, error) {
	if err := rtq.prepareQuery(ctx); err != nil {
		return false, err
	}
	return rtq.sqlExist(ctx)
}

// ExistX is like Exist, but panics if an error occurs.
func (rtq *RefreshTokenQuery) ExistX(ctx context.Context) bool {
	exist, err := rtq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the RefreshTokenQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (rtq *RefreshTokenQuery) Clone() *RefreshTokenQuery {
	if rtq == nil {
		return nil
	}
	return &RefreshTokenQuery{
		config:     rtq.config,
		limit:      rtq.limit,
		offset:     rtq.offset,
		order:      append([]OrderFunc{}, rtq.order...),
		predicates: append([]predicate.RefreshToken{}, rtq.predicates...),
		// clone intermediate query.
		sql:  rtq.sql.Clone(),
		path: rtq.path,
	}
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		ClientID string `json:"client_id,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.RefreshToken.Query().
//		GroupBy(refreshtoken.FieldClientID).
//		Aggregate(db.Count()).
//		Scan(ctx, &v)
//
func (rtq *RefreshTokenQuery) GroupBy(field string, fields ...string) *RefreshTokenGroupBy {
	group := &RefreshTokenGroupBy{config: rtq.config}
	group.fields = append([]string{field}, fields...)
	group.path = func(ctx context.Context) (prev *sql.Selector, err error) {
		if err := rtq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		return rtq.sqlQuery(ctx), nil
	}
	return group
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		ClientID string `json:"client_id,omitempty"`
//	}
//
//	client.RefreshToken.Query().
//		Select(refreshtoken.FieldClientID).
//		Scan(ctx, &v)
//
func (rtq *RefreshTokenQuery) Select(field string, fields ...string) *RefreshTokenSelect {
	rtq.fields = append([]string{field}, fields...)
	return &RefreshTokenSelect{RefreshTokenQuery: rtq}
}

func (rtq *RefreshTokenQuery) prepareQuery(ctx context.Context) error {
	for _, f := range rtq.fields {
		if !refreshtoken.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
		}
	}
	if rtq.path != nil {
		prev, err := rtq.path(ctx)
		if err != nil {
			return err
		}
		rtq.sql = prev
	}
	return nil
}

func (rtq *RefreshTokenQuery) sqlAll(ctx context.Context) ([]*RefreshToken, error) {
	var (
		nodes = []*RefreshToken{}
		_spec = rtq.querySpec()
	)
	_spec.ScanValues = func(columns []string) ([]interface{}, error) {
		node := &RefreshToken{config: rtq.config}
		nodes = append(nodes, node)
		return node.scanValues(columns)
	}
	_spec.Assign = func(columns []string, values []interface{}) error {
		if len(nodes) == 0 {
			return fmt.Errorf("db: Assign called without calling ScanValues")
		}
		node := nodes[len(nodes)-1]
		return node.assignValues(columns, values)
	}
	if err := sqlgraph.QueryNodes(ctx, rtq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	return nodes, nil
}

func (rtq *RefreshTokenQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := rtq.querySpec()
	return sqlgraph.CountNodes(ctx, rtq.driver, _spec)
}

func (rtq *RefreshTokenQuery) sqlExist(ctx context.Context) (bool, error) {
	n, err := rtq.sqlCount(ctx)
	if err != nil {
		return false, fmt.Errorf("db: check existence: %w", err)
	}
	return n > 0, nil
}

func (rtq *RefreshTokenQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := &sqlgraph.QuerySpec{
		Node: &sqlgraph.NodeSpec{
			Table:   refreshtoken.Table,
			Columns: refreshtoken.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeString,
				Column: refreshtoken.FieldID,
			},
		},
		From:   rtq.sql,
		Unique: true,
	}
	if unique := rtq.unique; unique != nil {
		_spec.Unique = *unique
	}
	if fields := rtq.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, refreshtoken.FieldID)
		for i := range fields {
			if fields[i] != refreshtoken.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
	}
	if ps := rtq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := rtq.limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := rtq.offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := rtq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (rtq *RefreshTokenQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(rtq.driver.Dialect())
	t1 := builder.Table(refreshtoken.Table)
	selector := builder.Select(t1.Columns(refreshtoken.Columns...)...).From(t1)
	if rtq.sql != nil {
		selector = rtq.sql
		selector.Select(selector.Columns(refreshtoken.Columns...)...)
	}
	for _, p := range rtq.predicates {
		p(selector)
	}
	for _, p := range rtq.order {
		p(selector)
	}
	if offset := rtq.offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := rtq.limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// RefreshTokenGroupBy is the group-by builder for RefreshToken entities.
type RefreshTokenGroupBy struct {
	config
	fields []string
	fns    []AggregateFunc
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Aggregate adds the given aggregation functions to the group-by query.
func (rtgb *RefreshTokenGroupBy) Aggregate(fns ...AggregateFunc) *RefreshTokenGroupBy {
	rtgb.fns = append(rtgb.fns, fns...)
	return rtgb
}

// Scan applies the group-by query and scans the result into the given value.
func (rtgb *RefreshTokenGroupBy) Scan(ctx context.Context, v interface{}) error {
	query, err := rtgb.path(ctx)
	if err != nil {
		return err
	}
	rtgb.sql = query
	return rtgb.sqlScan(ctx, v)
}

// ScanX is like Scan, but panics if an error occurs.
func (rtgb *RefreshTokenGroupBy) ScanX(ctx context.Context, v interface{}) {
	if err := rtgb.Scan(ctx, v); err != nil {
		panic(err)
	}
}

// Strings returns list of strings from group-by.
// It is only allowed when executing a group-by query with one field.
func (rtgb *RefreshTokenGroupBy) Strings(ctx context.Context) ([]string, error) {
	if len(rtgb.fields) > 1 {
		return nil, errors.New("db: RefreshTokenGroupBy.Strings is not achievable when grouping more than 1 field")
	}
	var v []string
	if err := rtgb.Scan(ctx, &v); err != nil {
		return nil, err
	}
	return v, nil
}

// StringsX is like Strings, but panics if an error occurs.
func (rtgb *RefreshTokenGroupBy) StringsX(ctx context.Context) []string {
	v, err := rtgb.Strings(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// String returns a single string from a group-by query.
// It is only allowed when executing a group-by query with one field.
func (rtgb *RefreshTokenGroupBy) String(ctx context.Context) (_ string, err error) {
	var v []string
	if v, err = rtgb.Strings(ctx); err != nil {
		return
	}
	switch len(v) {
	case 1:
		return v[0], nil
	case 0:
		err = &NotFoundError{refreshtoken.Label}
	default:
		err = fmt.Errorf("db: RefreshTokenGroupBy.Strings returned %d results when one was expected", len(v))
	}
	return
}

// StringX is like String, but panics if an error occurs.
func (rtgb *RefreshTokenGroupBy) StringX(ctx context.Context) string {
	v, err := rtgb.String(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Ints returns list of ints from group-by.
// It is only allowed when executing a group-by query with one field.
func (rtgb *RefreshTokenGroupBy) Ints(ctx context.Context) ([]int, error) {
	if len(rtgb.fields) > 1 {
		return nil, errors.New("db: RefreshTokenGroupBy.Ints is not achievable when grouping more than 1 field")
	}
	var v []int
	if err := rtgb.Scan(ctx, &v); err != nil {
		return nil, err
	}
	return v, nil
}

// IntsX is like Ints, but panics if an error occurs.
func (rtgb *RefreshTokenGroupBy) IntsX(ctx context.Context) []int {
	v, err := rtgb.Ints(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Int returns a single int from a group-by query.
// It is only allowed when executing a group-by query with one field.
func (rtgb *RefreshTokenGroupBy) Int(ctx context.Context) (_ int, err error) {
	var v []int
	if v, err = rtgb.Ints(ctx); err != nil {
		return
	}
	switch len(v) {
	case 1:
		return v[0], nil
	case 0:
		err = &NotFoundError{refreshtoken.Label}
	default:
		err = fmt.Errorf("db: RefreshTokenGroupBy.Ints returned %d results when one was expected", len(v))
	}
	return
}

// IntX is like Int, but panics if an error occurs.
func (rtgb *RefreshTokenGroupBy) IntX(ctx context.Context) int {
	v, err := rtgb.Int(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Float64s returns list of float64s from group-by.
// It is only allowed when executing a group-by query with one field.
func (rtgb *RefreshTokenGroupBy) Float64s(ctx context.Context) ([]float64, error) {
	if len(rtgb.fields) > 1 {
		return nil, errors.New("db: RefreshTokenGroupBy.Float64s is not achievable when grouping more than 1 field")
	}
	var v []float64
	if err := rtgb.Scan(ctx, &v); err != nil {
		return nil, err
	}
	return v, nil
}

// Float64sX is like Float64s, but panics if an error occurs.
func (rtgb *RefreshTokenGroupBy) Float64sX(ctx context.Context) []float64 {
	v, err := rtgb.Float64s(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Float64 returns a single float64 from a group-by query.
// It is only allowed when executing a group-by query with one field.
func (rtgb *RefreshTokenGroupBy) Float64(ctx context.Context) (_ float64, err error) {
	var v []float64
	if v, err = rtgb.Float64s(ctx); err != nil {
		return
	}
	switch len(v) {
	case 1:
		return v[0], nil
	case 0:
		err = &NotFoundError{refreshtoken.Label}
	default:
		err = fmt.Errorf("db: RefreshTokenGroupBy.Float64s returned %d results when one was expected", len(v))
	}
	return
}

// Float64X is like Float64, but panics if an error occurs.
func (rtgb *RefreshTokenGroupBy) Float64X(ctx context.Context) float64 {
	v, err := rtgb.Float64(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Bools returns list of bools from group-by.
// It is only allowed when executing a group-by query with one field.
func (rtgb *RefreshTokenGroupBy) Bools(ctx context.Context) ([]bool, error) {
	if len(rtgb.fields) > 1 {
		return nil, errors.New("db: RefreshTokenGroupBy.Bools is not achievable when grouping more than 1 field")
	}
	var v []bool
	if err := rtgb.Scan(ctx, &v); err != nil {
		return nil, err
	}
	return v, nil
}

// BoolsX is like Bools, but panics if an error occurs.
func (rtgb *RefreshTokenGroupBy) BoolsX(ctx context.Context) []bool {
	v, err := rtgb.Bools(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Bool returns a single bool from a group-by query.
// It is only allowed when executing a group-by query with one field.
func (rtgb *RefreshTokenGroupBy) Bool(ctx context.Context) (_ bool, err error) {
	var v []bool
	if v, err = rtgb.Bools(ctx); err != nil {
		return
	}
	switch len(v) {
	case 1:
		return v[0], nil
	case 0:
		err = &NotFoundError{refreshtoken.Label}
	default:
		err = fmt.Errorf("db: RefreshTokenGroupBy.Bools returned %d results when one was expected", len(v))
	}
	return
}

// BoolX is like Bool, but panics if an error occurs.
func (rtgb *RefreshTokenGroupBy) BoolX(ctx context.Context) bool {
	v, err := rtgb.Bool(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

func (rtgb *RefreshTokenGroupBy) sqlScan(ctx context.Context, v interface{}) error {
	for _, f := range rtgb.fields {
		if !refreshtoken.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("invalid field %q for group-by", f)}
		}
	}
	selector := rtgb.sqlQuery()
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := rtgb.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

func (rtgb *RefreshTokenGroupBy) sqlQuery() *sql.Selector {
	selector := rtgb.sql
	columns := make([]string, 0, len(rtgb.fields)+len(rtgb.fns))
	columns = append(columns, rtgb.fields...)
	for _, fn := range rtgb.fns {
		columns = append(columns, fn(selector))
	}
	return selector.Select(columns...).GroupBy(rtgb.fields...)
}

// RefreshTokenSelect is the builder for selecting fields of RefreshToken entities.
type RefreshTokenSelect struct {
	*RefreshTokenQuery
	// intermediate query (i.e. traversal path).
	sql *sql.Selector
}

// Scan applies the selector query and scans the result into the given value.
func (rts *RefreshTokenSelect) Scan(ctx context.Context, v interface{}) error {
	if err := rts.prepareQuery(ctx); err != nil {
		return err
	}
	rts.sql = rts.RefreshTokenQuery.sqlQuery(ctx)
	return rts.sqlScan(ctx, v)
}

// ScanX is like Scan, but panics if an error occurs.
func (rts *RefreshTokenSelect) ScanX(ctx context.Context, v interface{}) {
	if err := rts.Scan(ctx, v); err != nil {
		panic(err)
	}
}

// Strings returns list of strings from a selector. It is only allowed when selecting one field.
func (rts *RefreshTokenSelect) Strings(ctx context.Context) ([]string, error) {
	if len(rts.fields) > 1 {
		return nil, errors.New("db: RefreshTokenSelect.Strings is not achievable when selecting more than 1 field")
	}
	var v []string
	if err := rts.Scan(ctx, &v); err != nil {
		return nil, err
	}
	return v, nil
}

// StringsX is like Strings, but panics if an error occurs.
func (rts *RefreshTokenSelect) StringsX(ctx context.Context) []string {
	v, err := rts.Strings(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// String returns a single string from a selector. It is only allowed when selecting one field.
func (rts *RefreshTokenSelect) String(ctx context.Context) (_ string, err error) {
	var v []string
	if v, err = rts.Strings(ctx); err != nil {
		return
	}
	switch len(v) {
	case 1:
		return v[0], nil
	case 0:
		err = &NotFoundError{refreshtoken.Label}
	default:
		err = fmt.Errorf("db: RefreshTokenSelect.Strings returned %d results when one was expected", len(v))
	}
	return
}

// StringX is like String, but panics if an error occurs.
func (rts *RefreshTokenSelect) StringX(ctx context.Context) string {
	v, err := rts.String(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Ints returns list of ints from a selector. It is only allowed when selecting one field.
func (rts *RefreshTokenSelect) Ints(ctx context.Context) ([]int, error) {
	if len(rts.fields) > 1 {
		return nil, errors.New("db: RefreshTokenSelect.Ints is not achievable when selecting more than 1 field")
	}
	var v []int
	if err := rts.Scan(ctx, &v); err != nil {
		return nil, err
	}
	return v, nil
}

// IntsX is like Ints, but panics if an error occurs.
func (rts *RefreshTokenSelect) IntsX(ctx context.Context) []int {
	v, err := rts.Ints(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Int returns a single int from a selector. It is only allowed when selecting one field.
func (rts *RefreshTokenSelect) Int(ctx context.Context) (_ int, err error) {
	var v []int
	if v, err = rts.Ints(ctx); err != nil {
		return
	}
	switch len(v) {
	case 1:
		return v[0], nil
	case 0:
		err = &NotFoundError{refreshtoken.Label}
	default:
		err = fmt.Errorf("db: RefreshTokenSelect.Ints returned %d results when one was expected", len(v))
	}
	return
}

// IntX is like Int, but panics if an error occurs.
func (rts *RefreshTokenSelect) IntX(ctx context.Context) int {
	v, err := rts.Int(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Float64s returns list of float64s from a selector. It is only allowed when selecting one field.
func (rts *RefreshTokenSelect) Float64s(ctx context.Context) ([]float64, error) {
	if len(rts.fields) > 1 {
		return nil, errors.New("db: RefreshTokenSelect.Float64s is not achievable when selecting more than 1 field")
	}
	var v []float64
	if err := rts.Scan(ctx, &v); err != nil {
		return nil, err
	}
	return v, nil
}

// Float64sX is like Float64s, but panics if an error occurs.
func (rts *RefreshTokenSelect) Float64sX(ctx context.Context) []float64 {
	v, err := rts.Float64s(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Float64 returns a single float64 from a selector. It is only allowed when selecting one field.
func (rts *RefreshTokenSelect) Float64(ctx context.Context) (_ float64, err error) {
	var v []float64
	if v, err = rts.Float64s(ctx); err != nil {
		return
	}
	switch len(v) {
	case 1:
		return v[0], nil
	case 0:
		err = &NotFoundError{refreshtoken.Label}
	default:
		err = fmt.Errorf("db: RefreshTokenSelect.Float64s returned %d results when one was expected", len(v))
	}
	return
}

// Float64X is like Float64, but panics if an error occurs.
func (rts *RefreshTokenSelect) Float64X(ctx context.Context) float64 {
	v, err := rts.Float64(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Bools returns list of bools from a selector. It is only allowed when selecting one field.
func (rts *RefreshTokenSelect) Bools(ctx context.Context) ([]bool, error) {
	if len(rts.fields) > 1 {
		return nil, errors.New("db: RefreshTokenSelect.Bools is not achievable when selecting more than 1 field")
	}
	var v []bool
	if err := rts.Scan(ctx, &v); err != nil {
		return nil, err
	}
	return v, nil
}

// BoolsX is like Bools, but panics if an error occurs.
func (rts *RefreshTokenSelect) BoolsX(ctx context.Context) []bool {
	v, err := rts.Bools(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Bool returns a single bool from a selector. It is only allowed when selecting one field.
func (rts *RefreshTokenSelect) Bool(ctx context.Context) (_ bool, err error) {
	var v []bool
	if v, err = rts.Bools(ctx); err != nil {
		return
	}
	switch len(v) {
	case 1:
		return v[0], nil
	case 0:
		err = &NotFoundError{refreshtoken.Label}
	default:
		err = fmt.Errorf("db: RefreshTokenSelect.Bools returned %d results when one was expected", len(v))
	}
	return
}

// BoolX is like Bool, but panics if an error occurs.
func (rts *RefreshTokenSelect) BoolX(ctx context.Context) bool {
	v, err := rts.Bool(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

func (rts *RefreshTokenSelect) sqlScan(ctx context.Context, v interface{}) error {
	rows := &sql.Rows{}
	query, args := rts.sqlQuery().Query()
	if err := rts.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

func (rts *RefreshTokenSelect) sqlQuery() sql.Querier {
	selector := rts.sql
	selector.Select(selector.Columns(rts.fields...)...)
	return selector
}
