# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class DatabaseVulnerabilityAssessmentRuleBaseline(ProxyResource):
    """A database vulnerability assessment rule baseline.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param baseline_results: Required. The rule baseline result
    :type baseline_results:
     list[~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'baseline_results': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'baseline_results': {'key': 'properties.baselineResults', 'type': '[DatabaseVulnerabilityAssessmentRuleBaselineItem]'},
    }

    def __init__(self, **kwargs):
        super(DatabaseVulnerabilityAssessmentRuleBaseline, self).__init__(**kwargs)
        self.baseline_results = kwargs.get('baseline_results', None)
