# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource_py3 import ProxyOnlyResource


class ResourceHealthMetadata(ProxyOnlyResource):
    """Used for getting ResourceHealthCheck settings.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param category: The category that the resource matches in the RHC Policy
     File
    :type category: str
    :param signal_availability: Is there a health signal for the resource
    :type signal_availability: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'signal_availability': {'key': 'properties.signalAvailability', 'type': 'bool'},
    }

    def __init__(self, *, kind: str=None, category: str=None, signal_availability: bool=None, **kwargs) -> None:
        super(ResourceHealthMetadata, self).__init__(kind=kind, **kwargs)
        self.category = category
        self.signal_availability = signal_availability
