# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource import ProxyOnlyResource


class RecommendationRule(ProxyOnlyResource):
    """Represents a recommendation rule that the recommendation engine can
    perform.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param recommendation_name: Unique name of the rule.
    :type recommendation_name: str
    :param display_name: UI friendly name of the rule.
    :type display_name: str
    :param message: Localized name of the rule (Good for UI).
    :type message: str
    :param recommendation_id: Recommendation ID of an associated
     recommendation object tied to the rule, if exists.
     If such an object doesn't exist, it is set to null.
    :type recommendation_id: str
    :param description: Localized detailed description of the rule.
    :type description: str
    :param action_name: Name of action that is recommended by this rule in
     string.
    :type action_name: str
    :param level: Level of impact indicating how critical this rule is.
     Possible values include: 'Critical', 'Warning', 'Information',
     'NonUrgentSuggestion'
    :type level: str or ~azure.mgmt.web.models.NotificationLevel
    :param channels: List of available channels that this rule applies.
     Possible values include: 'Notification', 'Api', 'Email', 'Webhook', 'All'
    :type channels: str or ~azure.mgmt.web.models.Channels
    :ivar category_tags: The list of category tags that this recommendation
     rule belongs to.
    :vartype category_tags: list[str]
    :param is_dynamic: True if this is associated with a dynamically added
     rule
    :type is_dynamic: bool
    :param extension_name: Extension name of the portal if exists. Applicable
     to dynamic rule only.
    :type extension_name: str
    :param blade_name: Deep link to a blade on the portal. Applicable to
     dynamic rule only.
    :type blade_name: str
    :param forward_link: Forward link to an external document associated with
     the rule. Applicable to dynamic rule only.
    :type forward_link: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'category_tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'recommendation_name': {'key': 'properties.recommendationName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'recommendation_id': {'key': 'properties.recommendationId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'action_name': {'key': 'properties.actionName', 'type': 'str'},
        'level': {'key': 'properties.level', 'type': 'NotificationLevel'},
        'channels': {'key': 'properties.channels', 'type': 'Channels'},
        'category_tags': {'key': 'properties.categoryTags', 'type': '[str]'},
        'is_dynamic': {'key': 'properties.isDynamic', 'type': 'bool'},
        'extension_name': {'key': 'properties.extensionName', 'type': 'str'},
        'blade_name': {'key': 'properties.bladeName', 'type': 'str'},
        'forward_link': {'key': 'properties.forwardLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RecommendationRule, self).__init__(**kwargs)
        self.recommendation_name = kwargs.get('recommendation_name', None)
        self.display_name = kwargs.get('display_name', None)
        self.message = kwargs.get('message', None)
        self.recommendation_id = kwargs.get('recommendation_id', None)
        self.description = kwargs.get('description', None)
        self.action_name = kwargs.get('action_name', None)
        self.level = kwargs.get('level', None)
        self.channels = kwargs.get('channels', None)
        self.category_tags = None
        self.is_dynamic = kwargs.get('is_dynamic', None)
        self.extension_name = kwargs.get('extension_name', None)
        self.blade_name = kwargs.get('blade_name', None)
        self.forward_link = kwargs.get('forward_link', None)
