# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AutoHealActions(Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :param action_type: Predefined action to be taken. Possible values
     include: 'Recycle', 'LogEvent', 'CustomAction'
    :type action_type: str or ~azure.mgmt.web.models.AutoHealActionType
    :param custom_action: Custom action to be taken.
    :type custom_action: ~azure.mgmt.web.models.AutoHealCustomAction
    :param min_process_execution_time: Minimum time the process must execute
     before taking the action
    :type min_process_execution_time: str
    """

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'AutoHealActionType'},
        'custom_action': {'key': 'customAction', 'type': 'AutoHealCustomAction'},
        'min_process_execution_time': {'key': 'minProcessExecutionTime', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AutoHealActions, self).__init__(**kwargs)
        self.action_type = kwargs.get('action_type', None)
        self.custom_action = kwargs.get('custom_action', None)
        self.min_process_execution_time = kwargs.get('min_process_execution_time', None)
