# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class AppServicePlan(Resource):
    """App Service plan.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param worker_tier_name: Target worker tier assigned to the App Service
     plan.
    :type worker_tier_name: str
    :ivar status: App Service plan status. Possible values include: 'Ready',
     'Pending', 'Creating'
    :vartype status: str or ~azure.mgmt.web.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :param hosting_environment_profile: Specification for the App Service
     Environment to use for the App Service plan.
    :type hosting_environment_profile:
     ~azure.mgmt.web.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be
     assigned to this App Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :param per_site_scaling: If <code>true</code>, apps assigned to this App
     Service plan can be scaled independently.
     If <code>false</code>, apps assigned to this App Service plan will scale
     to all instances of the plan. Default value: False .
    :type per_site_scaling: bool
    :param maximum_elastic_worker_count: Maximum number of total workers
     allowed for this ElasticScaleEnabled App Service Plan
    :type maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :param is_spot: If <code>true</code>, this App Service Plan owns spot
     instances.
    :type is_spot: bool
    :param spot_expiration_time: The time when the server farm expires. Valid
     only if it is a spot server farm.
    :type spot_expiration_time: datetime
    :param free_offer_expiration_time: The time when the server farm free
     offer expires.
    :type free_offer_expiration_time: datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :param reserved: If Linux app service plan <code>true</code>,
     <code>false</code> otherwise. Default value: False .
    :type reserved: bool
    :param is_xenon: Obsolete: If Hyper-V container app service plan
     <code>true</code>, <code>false</code> otherwise. Default value: False .
    :type is_xenon: bool
    :param hyper_v: If Hyper-V container app service plan <code>true</code>,
     <code>false</code> otherwise. Default value: False .
    :type hyper_v: bool
    :param target_worker_count: Scaling worker count.
    :type target_worker_count: int
    :param target_worker_size_id: Scaling worker size ID.
    :type target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service
     Environment. Possible values include: 'Succeeded', 'Failed', 'Canceled',
     'InProgress', 'Deleting'
    :vartype provisioning_state: str or
     ~azure.mgmt.web.models.ProvisioningState
    :param sku:
    :type sku: ~azure.mgmt.web.models.SkuDescription
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'subscription': {'readonly': True},
        'maximum_number_of_workers': {'readonly': True},
        'geo_region': {'readonly': True},
        'number_of_sites': {'readonly': True},
        'resource_group': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'worker_tier_name': {'key': 'properties.workerTierName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'StatusOptions'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int'},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str'},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool'},
        'maximum_elastic_worker_count': {'key': 'properties.maximumElasticWorkerCount', 'type': 'int'},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'spot_expiration_time': {'key': 'properties.spotExpirationTime', 'type': 'iso-8601'},
        'free_offer_expiration_time': {'key': 'properties.freeOfferExpirationTime', 'type': 'iso-8601'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'target_worker_count': {'key': 'properties.targetWorkerCount', 'type': 'int'},
        'target_worker_size_id': {'key': 'properties.targetWorkerSizeId', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
    }

    def __init__(self, **kwargs):
        super(AppServicePlan, self).__init__(**kwargs)
        self.worker_tier_name = kwargs.get('worker_tier_name', None)
        self.status = None
        self.subscription = None
        self.hosting_environment_profile = kwargs.get('hosting_environment_profile', None)
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = kwargs.get('per_site_scaling', False)
        self.maximum_elastic_worker_count = kwargs.get('maximum_elastic_worker_count', None)
        self.number_of_sites = None
        self.is_spot = kwargs.get('is_spot', None)
        self.spot_expiration_time = kwargs.get('spot_expiration_time', None)
        self.free_offer_expiration_time = kwargs.get('free_offer_expiration_time', None)
        self.resource_group = None
        self.reserved = kwargs.get('reserved', False)
        self.is_xenon = kwargs.get('is_xenon', False)
        self.hyper_v = kwargs.get('hyper_v', False)
        self.target_worker_count = kwargs.get('target_worker_count', None)
        self.target_worker_size_id = kwargs.get('target_worker_size_id', None)
        self.provisioning_state = None
        self.sku = kwargs.get('sku', None)
