# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TenantBackfillStatusResult(Model):
    """The tenant backfill status.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar tenant_id: The AAD Tenant ID associated with the management group.
     For example, 00000000-0000-0000-0000-000000000000
    :vartype tenant_id: str
    :ivar status: The status of the Tenant Backfill. Possible values include:
     'NotStarted', 'NotStartedButGroupsExist', 'Started', 'Failed',
     'Cancelled', 'Completed'
    :vartype status: str or ~azure.mgmt.managementgroups.models.Status
    """

    _validation = {
        'tenant_id': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'Status'},
    }

    def __init__(self, **kwargs) -> None:
        super(TenantBackfillStatusResult, self).__init__(**kwargs)
        self.tenant_id = None
        self.status = None
