# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobStepAction(Model):
    """The action to be executed by a job step.

    All required parameters must be populated in order to send to Azure.

    :param type: Type of action being executed by the job step. Possible
     values include: 'TSql'. Default value: "TSql" .
    :type type: str or ~azure.mgmt.sql.models.JobStepActionType
    :param source: The source of the action to execute. Possible values
     include: 'Inline'. Default value: "Inline" .
    :type source: str or ~azure.mgmt.sql.models.JobStepActionSource
    :param value: Required. The action value, for example the text of the
     T-SQL script to execute.
    :type value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobStepAction, self).__init__(**kwargs)
        self.type = kwargs.get('type', "TSql")
        self.source = kwargs.get('source', "Inline")
        self.value = kwargs.get('value', None)
