# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class FirewallRule(ProxyResource):
    """Represents a server firewall rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of server that contains this firewall rule.
    :vartype kind: str
    :ivar location: Location of the server that contains this firewall rule.
    :vartype location: str
    :param start_ip_address: Required. The start IP address of the firewall
     rule. Must be IPv4 format. Use value '0.0.0.0' to represent all
     Azure-internal IP addresses.
    :type start_ip_address: str
    :param end_ip_address: Required. The end IP address of the firewall rule.
     Must be IPv4 format. Must be greater than or equal to startIpAddress. Use
     value '0.0.0.0' to represent all Azure-internal IP addresses.
    :type end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
        'start_ip_address': {'required': True},
        'end_ip_address': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FirewallRule, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.start_ip_address = kwargs.get('start_ip_address', None)
        self.end_ip_address = kwargs.get('end_ip_address', None)
