# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DenyAssignment(Model):
    """Deny Assignment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The deny assignment ID.
    :vartype id: str
    :ivar name: The deny assignment name.
    :vartype name: str
    :ivar type: The deny assignment type.
    :vartype type: str
    :param deny_assignment_name: The display name of the deny assignment.
    :type deny_assignment_name: str
    :param description: The description of the deny assignment.
    :type description: str
    :param permissions: An array of permissions that are denied by the deny
     assignment.
    :type permissions:
     list[~azure.mgmt.authorization.v2018_07_01_preview.models.DenyAssignmentPermission]
    :param scope: The deny assignment scope.
    :type scope: str
    :param do_not_apply_to_child_scopes: Determines if the deny assignment
     applies to child scopes. Default value is false.
    :type do_not_apply_to_child_scopes: bool
    :param principals: Array of principals to which the deny assignment
     applies.
    :type principals:
     list[~azure.mgmt.authorization.v2018_07_01_preview.models.Principal]
    :param exclude_principals: Array of principals to which the deny
     assignment does not apply.
    :type exclude_principals:
     list[~azure.mgmt.authorization.v2018_07_01_preview.models.Principal]
    :param is_system_protected: Specifies whether this deny assignment was
     created by Azure and cannot be edited or deleted.
    :type is_system_protected: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deny_assignment_name': {'key': 'properties.denyAssignmentName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'permissions': {'key': 'properties.permissions', 'type': '[DenyAssignmentPermission]'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'do_not_apply_to_child_scopes': {'key': 'properties.doNotApplyToChildScopes', 'type': 'bool'},
        'principals': {'key': 'properties.principals', 'type': '[Principal]'},
        'exclude_principals': {'key': 'properties.excludePrincipals', 'type': '[Principal]'},
        'is_system_protected': {'key': 'properties.isSystemProtected', 'type': 'bool'},
    }

    def __init__(self, *, deny_assignment_name: str=None, description: str=None, permissions=None, scope: str=None, do_not_apply_to_child_scopes: bool=None, principals=None, exclude_principals=None, is_system_protected: bool=None, **kwargs) -> None:
        super(DenyAssignment, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.deny_assignment_name = deny_assignment_name
        self.description = description
        self.permissions = permissions
        self.scope = scope
        self.do_not_apply_to_child_scopes = do_not_apply_to_child_scopes
        self.principals = principals
        self.exclude_principals = exclude_principals
        self.is_system_protected = is_system_protected
