# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Domain(Model):
    """Active Directory Domain information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar authentication_type: the type of the authentication into the domain.
    :vartype authentication_type: str
    :ivar is_default: if this is the default domain in the tenant.
    :vartype is_default: bool
    :ivar is_verified: if this domain's ownership is verified.
    :vartype is_verified: bool
    :param name: the domain name.
    :type name: str
    """

    _validation = {
        'authentication_type': {'readonly': True},
        'is_default': {'readonly': True},
        'is_verified': {'readonly': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, name, additional_properties=None):
        super(Domain, self).__init__()
        self.additional_properties = additional_properties
        self.authentication_type = None
        self.is_default = None
        self.is_verified = None
        self.name = name
