package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_AdmissionPluginConfig = map[string]string{
	"":              "AdmissionPluginConfig holds the necessary configuration options for admission plugins",
	"location":      "Location is the path to a configuration file that contains the plugin's configuration",
	"configuration": "Configuration is an embedded configuration object to be used as the plugin's configuration. If present, it will be used instead of the path to the configuration file.",
}

func (AdmissionPluginConfig) SwaggerDoc() map[string]string {
	return map_AdmissionPluginConfig
}

var map_AuditConfig = map[string]string{
	"":                         "AuditConfig holds configuration for the audit capabilities",
	"enabled":                  "If this flag is set, audit log will be printed in the logs. The logs contains, method, user and a requested URL.",
	"auditFilePath":            "All requests coming to the apiserver will be logged to this file.",
	"maximumFileRetentionDays": "Maximum number of days to retain old log files based on the timestamp encoded in their filename.",
	"maximumRetainedFiles":     "Maximum number of old log files to retain.",
	"maximumFileSizeMegabytes": "Maximum size in megabytes of the log file before it gets rotated. Defaults to 100MB.",
	"policyFile":               "PolicyFile is a path to the file that defines the audit policy configuration.",
	"policyConfiguration":      "PolicyConfiguration is an embedded policy configuration object to be used as the audit policy configuration. If present, it will be used instead of the path to the policy file.",
	"logFormat":                "Format of saved audits (legacy or json).",
	"webHookKubeConfig":        "Path to a .kubeconfig formatted file that defines the audit webhook configuration.",
	"webHookMode":              "Strategy for sending audit events (block or batch).",
}

func (AuditConfig) SwaggerDoc() map[string]string {
	return map_AuditConfig
}

var map_CertInfo = map[string]string{
	"":         "CertInfo relates a certificate with a private key",
	"certFile": "CertFile is a file containing a PEM-encoded certificate",
	"keyFile":  "KeyFile is a file containing a PEM-encoded private key for the certificate specified by CertFile",
}

func (CertInfo) SwaggerDoc() map[string]string {
	return map_CertInfo
}

var map_ClientConnectionOverrides = map[string]string{
	"acceptContentTypes": "acceptContentTypes defines the Accept header sent by clients when connecting to a server, overriding the default value of 'application/json'. This field will control all connections to the server used by a particular client.",
	"contentType":        "contentType is the content type used when sending data to the server from this client.",
	"qps":                "qps controls the number of queries per second allowed for this connection.",
	"burst":              "burst allows extra queries to accumulate when a client is exceeding its rate.",
}

func (ClientConnectionOverrides) SwaggerDoc() map[string]string {
	return map_ClientConnectionOverrides
}

var map_ConfigMapReference = map[string]string{
	"":    "ConfigMapReference references a configmap in the openshift-config namespace.",
	"key": "Key allows pointing to a specific key/value inside of the configmap.  This is useful for logical file references.",
}

func (ConfigMapReference) SwaggerDoc() map[string]string {
	return map_ConfigMapReference
}

var map_DelegatedAuthentication = map[string]string{
	"":         "DelegatedAuthentication allows authentication to be disabled.",
	"disabled": "disabled indicates that authentication should be disabled.  By default it will use delegated authentication.",
}

func (DelegatedAuthentication) SwaggerDoc() map[string]string {
	return map_DelegatedAuthentication
}

var map_DelegatedAuthorization = map[string]string{
	"":         "DelegatedAuthorization allows authorization to be disabled.",
	"disabled": "disabled indicates that authorization should be disabled.  By default it will use delegated authorization.",
}

func (DelegatedAuthorization) SwaggerDoc() map[string]string {
	return map_DelegatedAuthorization
}

var map_EtcdConnectionInfo = map[string]string{
	"":     "EtcdConnectionInfo holds information necessary for connecting to an etcd server",
	"urls": "URLs are the URLs for etcd",
	"ca":   "CA is a file containing trusted roots for the etcd server certificates",
}

func (EtcdConnectionInfo) SwaggerDoc() map[string]string {
	return map_EtcdConnectionInfo
}

var map_EtcdStorageConfig = map[string]string{
	"storagePrefix": "StoragePrefix is the path within etcd that the OpenShift resources will be rooted under. This value, if changed, will mean existing objects in etcd will no longer be located.",
}

func (EtcdStorageConfig) SwaggerDoc() map[string]string {
	return map_EtcdStorageConfig
}

var map_GenericAPIServerConfig = map[string]string{
	"":                   "GenericAPIServerConfig is an inline-able struct for aggregated apiservers that need to store data in etcd",
	"servingInfo":        "ServingInfo describes how to start serving",
	"corsAllowedOrigins": "CORSAllowedOrigins",
	"auditConfig":        "AuditConfig describes how to configure audit information",
	"storageConfig":      "StorageConfig contains information about how to use",
}

func (GenericAPIServerConfig) SwaggerDoc() map[string]string {
	return map_GenericAPIServerConfig
}

var map_GenericControllerConfig = map[string]string{
	"":               "GenericControllerConfig provides information to configure a controller",
	"servingInfo":    "ServingInfo is the HTTP serving information for the controller's endpoints",
	"leaderElection": "leaderElection provides information to elect a leader. Only override this if you have a specific need",
	"authentication": "authentication allows configuration of authentication for the endpoints",
	"authorization":  "authorization allows configuration of authentication for the endpoints",
}

func (GenericControllerConfig) SwaggerDoc() map[string]string {
	return map_GenericControllerConfig
}

var map_HTTPServingInfo = map[string]string{
	"": "HTTPServingInfo holds configuration for serving HTTP",
	"maxRequestsInFlight":   "MaxRequestsInFlight is the number of concurrent requests allowed to the server. If zero, no limit.",
	"requestTimeoutSeconds": "RequestTimeoutSeconds is the number of seconds before requests are timed out. The default is 60 minutes, if -1 there is no limit on requests.",
}

func (HTTPServingInfo) SwaggerDoc() map[string]string {
	return map_HTTPServingInfo
}

var map_KubeClientConfig = map[string]string{
	"kubeConfig":          "kubeConfig is a .kubeconfig filename for going to the owning kube-apiserver.  Empty uses an in-cluster-config",
	"connectionOverrides": "connectionOverrides specifies client overrides for system components to loop back to this master.",
}

func (KubeClientConfig) SwaggerDoc() map[string]string {
	return map_KubeClientConfig
}

var map_LeaderElection = map[string]string{
	"":              "LeaderElection provides information to elect a leader",
	"disable":       "disable allows leader election to be suspended while allowing a fully defaulted \"normal\" startup case.",
	"namespace":     "namespace indicates which namespace the resource is in",
	"name":          "name indicates what name to use for the resource",
	"leaseDuration": "leaseDuration is the duration that non-leader candidates will wait after observing a leadership renewal until attempting to acquire leadership of a led but unrenewed leader slot. This is effectively the maximum duration that a leader can be stopped before it is replaced by another candidate. This is only applicable if leader election is enabled.",
	"renewDeadline": "renewDeadline is the interval between attempts by the acting master to renew a leadership slot before it stops leading. This must be less than or equal to the lease duration. This is only applicable if leader election is enabled.",
	"retryPeriod":   "retryPeriod is the duration the clients should wait between attempting acquisition and renewal of a leadership. This is only applicable if leader election is enabled.",
}

func (LeaderElection) SwaggerDoc() map[string]string {
	return map_LeaderElection
}

var map_LocalSecretReference = map[string]string{
	"":     "LocalSecretReference references a secret within the local namespace",
	"name": "Name of the secret in the local namespace",
	"key":  "Key selects a specific key within the local secret. Must be a valid secret key.",
}

func (LocalSecretReference) SwaggerDoc() map[string]string {
	return map_LocalSecretReference
}

var map_NamedCertificate = map[string]string{
	"":      "NamedCertificate specifies a certificate/key, and the names it should be served for",
	"names": "Names is a list of DNS names this certificate should be used to secure A name can be a normal DNS name, or can contain leading wildcard segments.",
}

func (NamedCertificate) SwaggerDoc() map[string]string {
	return map_NamedCertificate
}

var map_RemoteConnectionInfo = map[string]string{
	"":    "RemoteConnectionInfo holds information necessary for establishing a remote connection",
	"url": "URL is the remote URL to connect to",
	"ca":  "CA is the CA for verifying TLS connections",
}

func (RemoteConnectionInfo) SwaggerDoc() map[string]string {
	return map_RemoteConnectionInfo
}

var map_ServingInfo = map[string]string{
	"":                  "ServingInfo holds information about serving web pages",
	"bindAddress":       "BindAddress is the ip:port to serve on",
	"bindNetwork":       "BindNetwork is the type of network to bind to - defaults to \"tcp4\", accepts \"tcp\", \"tcp4\", and \"tcp6\"",
	"clientCA":          "ClientCA is the certificate bundle for all the signers that you'll recognize for incoming client certificates",
	"namedCertificates": "NamedCertificates is a list of certificates to use to secure requests to specific hostnames",
	"minTLSVersion":     "MinTLSVersion is the minimum TLS version supported. Values must match version names from https://golang.org/pkg/crypto/tls/#pkg-constants",
	"cipherSuites":      "CipherSuites contains an overridden list of ciphers for the server to support. Values must match cipher suite IDs from https://golang.org/pkg/crypto/tls/#pkg-constants",
}

func (ServingInfo) SwaggerDoc() map[string]string {
	return map_ServingInfo
}

var map_StringSource = map[string]string{
	"": "StringSource allows specifying a string inline, or externally via env var or file. When it contains only a string value, it marshals to a simple JSON string.",
}

func (StringSource) SwaggerDoc() map[string]string {
	return map_StringSource
}

var map_StringSourceSpec = map[string]string{
	"":        "StringSourceSpec specifies a string value, or external location",
	"value":   "Value specifies the cleartext value, or an encrypted value if keyFile is specified.",
	"env":     "Env specifies an envvar containing the cleartext value, or an encrypted value if the keyFile is specified.",
	"file":    "File references a file containing the cleartext value, or an encrypted value if a keyFile is specified.",
	"keyFile": "KeyFile references a file containing the key to use to decrypt the value.",
}

func (StringSourceSpec) SwaggerDoc() map[string]string {
	return map_StringSourceSpec
}

var map_Authentication = map[string]string{
	"":         "Authentication holds cluster-wide information about Authentication.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Authentication) SwaggerDoc() map[string]string {
	return map_Authentication
}

var map_AuthenticationList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (AuthenticationList) SwaggerDoc() map[string]string {
	return map_AuthenticationList
}

var map_AuthenticationSpec = map[string]string{
	"oauthMetadata":              "oauthMetadata contains the discovery endpoint data for OAuth 2.0 Authorization Server Metadata for an external OAuth server. This discovery document can be viewed from its served location: oc get --raw '/.well-known/oauth-authorization-server' For further details, see the IETF Draft: https://tools.ietf.org/html/draft-ietf-oauth-discovery-04#section-2 If oauthMetadata.name is non-empty, this value has precedence over the observed value stored in status.oauthMetadata",
	"webhookTokenAuthenticators": "webhookTokenAuthenticators configures remote token reviewers. These remote authentication webhooks can be used to verify bearer tokens via the tokenreviews.authentication.k8s.io REST API.  This is required to honor bearer tokens that are provisioned by an external authentication service.",
}

func (AuthenticationSpec) SwaggerDoc() map[string]string {
	return map_AuthenticationSpec
}

var map_AuthenticationStatus = map[string]string{
	"oauthMetadata": "oauthMetadata contains the discovery endpoint data for OAuth 2.0 Authorization Server Metadata for an external OAuth server. This discovery document can be viewed from its served location: oc get --raw '/.well-known/oauth-authorization-server' For further details, see the IETF Draft: https://tools.ietf.org/html/draft-ietf-oauth-discovery-04#section-2 This contains the observed value based on cluster state. An explicitly set value in spec.oauthMetadata has precedence over this field.",
}

func (AuthenticationStatus) SwaggerDoc() map[string]string {
	return map_AuthenticationStatus
}

var map_WebhookTokenAuthenticator = map[string]string{
	"":           "webhookTokenAuthenticator holds the necessary configuration options for a remote token authenticator",
	"kubeConfig": "kubeConfig contains kube config file data which describes how to access the remote webhook service. For further details, see: https://kubernetes.io/docs/reference/access-authn-authz/authentication/#webhook-token-authentication",
}

func (WebhookTokenAuthenticator) SwaggerDoc() map[string]string {
	return map_WebhookTokenAuthenticator
}

var map_Build = map[string]string{
	"":     "Build holds cluster-wide information on how to handle builds. The canonical name is `cluster`",
	"spec": "Spec holds user-settable values for the build controller configuration",
}

func (Build) SwaggerDoc() map[string]string {
	return map_Build
}

var map_BuildDefaults = map[string]string{
	"defaultProxy": "DefaultProxy contains the default proxy settings for all build operations, including image pull/push and source download.\n\nValues can be overrode by setting the `HTTP_PROXY`, `HTTPS_PROXY`, and `NO_PROXY` environment variables in the build config's strategy.",
	"gitProxy":     "GitProxy contains the proxy settings for git operations only. If set, this will override any Proxy settings for all git commands, such as git clone.\n\nValues that are not set here will be inherited from DefaultProxy.",
	"env":          "Env is a set of default environment variables that will be applied to the build if the specified variables do not exist on the build",
	"imageLabels":  "ImageLabels is a list of docker labels that are applied to the resulting image. User can override a default label by providing a label with the same name in their Build/BuildConfig.",
	"resources":    "Resources defines resource requirements to execute the build.",
}

func (BuildDefaults) SwaggerDoc() map[string]string {
	return map_BuildDefaults
}

var map_BuildList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (BuildList) SwaggerDoc() map[string]string {
	return map_BuildList
}

var map_BuildOverrides = map[string]string{
	"imageLabels":  "ImageLabels is a list of docker labels that are applied to the resulting image. If user provided a label in their Build/BuildConfig with the same name as one in this list, the user's label will be overwritten.",
	"nodeSelector": "NodeSelector is a selector which must be true for the build pod to fit on a node",
	"tolerations":  "Tolerations is a list of Tolerations that will override any existing tolerations set on a build pod.",
}

func (BuildOverrides) SwaggerDoc() map[string]string {
	return map_BuildOverrides
}

var map_BuildSpec = map[string]string{
	"additionalTrustedCA": "AdditionalTrustedCA is a reference to a ConfigMap containing additional CAs that should be trusted for image pushes and pulls during builds.",
	"buildDefaults":       "BuildDefaults controls the default information for Builds",
	"buildOverrides":      "BuildOverrides controls override settings for builds",
}

func (BuildSpec) SwaggerDoc() map[string]string {
	return map_BuildSpec
}

var map_ImageLabel = map[string]string{
	"name":  "Name defines the name of the label. It must have non-zero length.",
	"value": "Value defines the literal value of the label.",
}

func (ImageLabel) SwaggerDoc() map[string]string {
	return map_ImageLabel
}

var map_ClusterOperator = map[string]string{
	"":       "ClusterOperator is the Custom Resource object which holds the current state of an operator. This object is used by operators to convey their state to the rest of the cluster.",
	"spec":   "spec hold the intent of how this operator should behave.",
	"status": "status holds the information about the state of an operator.  It is consistent with status information across the kube ecosystem.",
}

func (ClusterOperator) SwaggerDoc() map[string]string {
	return map_ClusterOperator
}

var map_ClusterOperatorList = map[string]string{
	"": "ClusterOperatorList is a list of OperatorStatus resources.",
}

func (ClusterOperatorList) SwaggerDoc() map[string]string {
	return map_ClusterOperatorList
}

var map_ClusterOperatorSpec = map[string]string{
	"": "ClusterOperatorSpec is empty for now, but you could imagine holding information like \"pause\".",
}

func (ClusterOperatorSpec) SwaggerDoc() map[string]string {
	return map_ClusterOperatorSpec
}

var map_ClusterOperatorStatus = map[string]string{
	"":           "ClusterOperatorStatus provides information about the status of the operator.",
	"conditions": "conditions describes the state of the operator's reconciliation functionality.",
	"version":    "version indicates which version of the operator updated the current status object.",
	"extension":  "extension contains any additional status information specific to the operator which owns this status object.",
}

func (ClusterOperatorStatus) SwaggerDoc() map[string]string {
	return map_ClusterOperatorStatus
}

var map_ClusterOperatorStatusCondition = map[string]string{
	"":                   "ClusterOperatorStatusCondition represents the state of the operator's reconciliation functionality.",
	"type":               "type specifies the state of the operator's reconciliation functionality.",
	"status":             "status of the condition, one of True, False, Unknown.",
	"lastTransitionTime": "lastTransitionTime is the time of the last update to the current status object.",
	"reason":             "reason is the reason for the condition's last transition.  Reasons are CamelCase",
	"message":            "message provides additional information about the current condition. This is only to be consumed by humans.",
}

func (ClusterOperatorStatusCondition) SwaggerDoc() map[string]string {
	return map_ClusterOperatorStatusCondition
}

var map_ClusterVersion = map[string]string{
	"":       "ClusterVersion is the configuration for the ClusterVersionOperator. This is where parameters related to automatic updates can be set.",
	"spec":   "spec is the desired state of the cluster version - the operator will work to ensure that the desired version is applied to the cluster.",
	"status": "status contains information about the available updates and any in-progress updates.",
}

func (ClusterVersion) SwaggerDoc() map[string]string {
	return map_ClusterVersion
}

var map_ClusterVersionList = map[string]string{
	"": "ClusterVersionList is a list of ClusterVersion resources.",
}

func (ClusterVersionList) SwaggerDoc() map[string]string {
	return map_ClusterVersionList
}

var map_ClusterVersionSpec = map[string]string{
	"":              "ClusterVersionSpec is the desired version state of the cluster. It includes the version the cluster should be at, how the cluster is identified, and where the cluster should look for version updates.",
	"clusterID":     "clusterID uniquely identifies this cluster. This is expected to be an RFC4122 UUID value (xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx in hexadecimal values). This is a required field.",
	"desiredUpdate": "desiredUpdate is an optional field that indicates the desired value of the cluster version. Setting this value will trigger an upgrade (if the current version does not match the desired version). The set of recommended update values is listed as part of available updates in status, and setting values outside that range may cause the upgrade to fail.\n\nIf an upgrade fails the operator will halt and report status about the failing component. Setting the desired update value back to the previous version will cause a rollback to be attempted. Not all rollbacks will succeed.",
	"upstream":      "upstream may be used to specify the preferred update server. By default it will use the appropriate update server for the cluster and region.",
	"channel":       "channel is an identifier for explicitly requesting that a non-default set of updates be applied to this cluster. The default channel will be contain stable updates that are appropriate for production clusters.",
	"overrides":     "overrides is list of overides for components that are managed by cluster version operator. Marking a component unmanaged will prevent the operator from creating or updating the object.",
}

func (ClusterVersionSpec) SwaggerDoc() map[string]string {
	return map_ClusterVersionSpec
}

var map_ClusterVersionStatus = map[string]string{
	"":                 "ClusterVersionStatus reports the status of the cluster versioning, including any upgrades that are in progress. The current field will be set to whichever version the cluster is reconciling to, and the conditions array will report whether the update succeeded, is in progress, or is failing.",
	"desired":          "desired is the version that the cluster is reconciling towards. If the cluster is not yet fully initialized desired will be set with the information available, which may be a payload or a tag.",
	"history":          "history contains a list of the most recent versions applied to the cluster. This value may be empty during cluster startup, and then will be updated when a new update is being applied. The newest update is first in the list and it is ordered by recency. Updates in the history have state Completed if the rollout completed - if an update was failing or halfway applied the state will be Partial. Only a limited amount of update history is preserved.",
	"generation":       "generation reports which version of the spec is being processed. If this value is not equal to metadata.generation, then the current and conditions fields have not yet been updated to reflect the latest request.",
	"versionHash":      "versionHash is a fingerprint of the content that the cluster will be updated with. It is used by the operator to avoid unnecessary work and is for internal use only.",
	"conditions":       "conditions provides information about the cluster version. The condition \"Available\" is set to true if the desiredUpdate has been reached. The condition \"Progressing\" is set to true if an update is being applied. The condition \"Failing\" is set to true if an update is currently blocked by a temporary or permanent error. Conditions are only valid for the current desiredUpdate when metadata.generation is equal to status.generation.",
	"availableUpdates": "availableUpdates contains the list of updates that are appropriate for this cluster. This list may be empty if no updates are recommended, if the update service is unavailable, or if an invalid channel has been specified.",
}

func (ClusterVersionStatus) SwaggerDoc() map[string]string {
	return map_ClusterVersionStatus
}

var map_ComponentOverride = map[string]string{
	"":          "ComponentOverride allows overriding cluster version operator's behavior for a component.",
	"kind":      "kind indentifies which object to override.",
	"group":     "group identifies the API group that the kind is in.",
	"namespace": "namespace is the component's namespace. If the resource is cluster scoped, the namespace should be empty.",
	"name":      "name is the component's name.",
	"unmanaged": "unmanaged controls if cluster version operator should stop managing the resources in this cluster. Default: false",
}

func (ComponentOverride) SwaggerDoc() map[string]string {
	return map_ComponentOverride
}

var map_Update = map[string]string{
	"":        "Update represents a release of the ClusterVersionOperator, referenced by the Payload member.",
	"version": "version is a semantic versioning identifying the update version. When this field is part of spec, version is optional if payload is specified.",
	"payload": "payload is a container image location that contains the update. When this field is part of spec, payload is optional if version is specified and the availableUpdates field contains a matching version.",
}

func (Update) SwaggerDoc() map[string]string {
	return map_Update
}

var map_UpdateHistory = map[string]string{
	"":               "UpdateHistory is a single attempted update to the cluster.",
	"state":          "state reflects whether the update was fully applied. The Partial state indicates the update is not fully applied, while the Completed state indicates the update was successfully rolled out at least once (all parts of the update successfully applied).",
	"startedTime":    "startedTime is the time at which the update was started.",
	"completionTime": "completionTime, if set, is when the update was fully applied. The update that is currently being applied will have a null completion time. Completion time will always be set for entries that are not the current update (usually to the started time of the next update).",
	"version":        "version is a semantic versioning identifying the update version. If the requested payload does not define a version, or if a failure occurs retrieving the payload, this value may be empty.",
	"payload":        "payload is a container image location that contains the update. This value is always populated.",
}

func (UpdateHistory) SwaggerDoc() map[string]string {
	return map_UpdateHistory
}

var map_Console = map[string]string{
	"":         "Console holds cluster-wide information about Console.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Console) SwaggerDoc() map[string]string {
	return map_Console
}

var map_ConsoleList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (ConsoleList) SwaggerDoc() map[string]string {
	return map_ConsoleList
}

var map_DNS = map[string]string{
	"":         "DNS holds cluster-wide information about DNS.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (DNS) SwaggerDoc() map[string]string {
	return map_DNS
}

var map_DNSList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (DNSList) SwaggerDoc() map[string]string {
	return map_DNSList
}

var map_DNSSpec = map[string]string{
	"baseDomain": "baseDomain is the base domain of the cluster. All managed DNS records will be sub-domains of this base.\n\nFor example, given the base domain `openshift.example.com`, an API server DNS record may be created for `cluster-api.openshift.example.com`.",
}

func (DNSSpec) SwaggerDoc() map[string]string {
	return map_DNSSpec
}

var map_IdentityProvider = map[string]string{
	"":         "IdentityProvider holds cluster-wide information about IdentityProvider.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (IdentityProvider) SwaggerDoc() map[string]string {
	return map_IdentityProvider
}

var map_IdentityProviderList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (IdentityProviderList) SwaggerDoc() map[string]string {
	return map_IdentityProviderList
}

var map_Image = map[string]string{
	"":         "Image holds cluster-wide information about how to handle images.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Image) SwaggerDoc() map[string]string {
	return map_Image
}

var map_ImageList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (ImageList) SwaggerDoc() map[string]string {
	return map_ImageList
}

var map_ImageSpec = map[string]string{
	"allowedRegistriesForImport": "AllowedRegistriesForImport limits the container image registries that normal users may import images from. Set this list to the registries that you trust to contain valid Docker images and that you want applications to be able to import from. Users with permission to create Images or ImageStreamMappings via the API are not affected by this policy - typically only administrators or system integrations will have those permissions.",
	"externalRegistryHostnames":  "externalRegistryHostnames provides the hostnames for the default external image registry. The external hostname should be set only when the image registry is exposed externally. The first value is used in 'publicDockerImageRepository' field in ImageStreams. The value must be in \"hostname[:port]\" format.",
	"additionalTrustedCA":        "AdditionalTrustedCA is a reference to a ConfigMap containing additional CAs that should be trusted during imagestream import.",
}

func (ImageSpec) SwaggerDoc() map[string]string {
	return map_ImageSpec
}

var map_ImageStatus = map[string]string{
	"internalRegistryHostname":  "this value is set by the image registry operator which controls the internal registry hostname InternalRegistryHostname sets the hostname for the default internal image registry. The value must be in \"hostname[:port]\" format. For backward compatibility, users can still use OPENSHIFT_DEFAULT_REGISTRY environment variable but this setting overrides the environment variable.",
	"externalRegistryHostnames": "externalRegistryHostnames provides the hostnames for the default external image registry. The external hostname should be set only when the image registry is exposed externally. The first value is used in 'publicDockerImageRepository' field in ImageStreams. The value must be in \"hostname[:port]\" format.",
}

func (ImageStatus) SwaggerDoc() map[string]string {
	return map_ImageStatus
}

var map_RegistryLocation = map[string]string{
	"":           "RegistryLocation contains a location of the registry specified by the registry domain name. The domain name might include wildcards, like '*' or '??'.",
	"domainName": "DomainName specifies a domain name for the registry In case the registry use non-standard (80 or 443) port, the port should be included in the domain name as well.",
	"insecure":   "Insecure indicates whether the registry is secure (https) or insecure (http) By default (if not specified) the registry is assumed as secure.",
}

func (RegistryLocation) SwaggerDoc() map[string]string {
	return map_RegistryLocation
}

var map_Infrastructure = map[string]string{
	"":         "Infrastructure holds cluster-wide information about Infrastructure.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Infrastructure) SwaggerDoc() map[string]string {
	return map_Infrastructure
}

var map_InfrastructureList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (InfrastructureList) SwaggerDoc() map[string]string {
	return map_InfrastructureList
}

var map_InfrastructureStatus = map[string]string{
	"platform": "platform is the underlying infrastructure provider for the cluster. This value controls whether infrastructure automation such as service load balancers, dynamic volume provisioning, machine creation and deletion, and other integrations are enabled. If None, no infrastructure automation is enabled.",
}

func (InfrastructureStatus) SwaggerDoc() map[string]string {
	return map_InfrastructureStatus
}

var map_Ingress = map[string]string{
	"":         "Ingress holds cluster-wide information about Ingress.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Ingress) SwaggerDoc() map[string]string {
	return map_Ingress
}

var map_IngressList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (IngressList) SwaggerDoc() map[string]string {
	return map_IngressList
}

var map_IngressSpec = map[string]string{
	"domain": "domain is used to generate a default host name for a route when the route's host name is empty.  The generated host name will follow this pattern: \"<route-name>.<route-namespace>.<domain>\".",
}

func (IngressSpec) SwaggerDoc() map[string]string {
	return map_IngressSpec
}

var map_ClusterNetworkEntry = map[string]string{
	"":           "ClusterNetworkEntry is a contiguous block of IP addresses from which pod IPs are allocated.",
	"cidr":       "The complete block for pod IPs.",
	"hostPrefix": "The size (prefix) of block to allocate to each node.",
}

func (ClusterNetworkEntry) SwaggerDoc() map[string]string {
	return map_ClusterNetworkEntry
}

var map_Network = map[string]string{
	"":         "Network holds cluster-wide information about Network.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration.",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Network) SwaggerDoc() map[string]string {
	return map_Network
}

var map_NetworkList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (NetworkList) SwaggerDoc() map[string]string {
	return map_NetworkList
}

var map_NetworkSpec = map[string]string{
	"":               "NetworkSpec is the desired network configuration. As a general rule, this SHOULD NOT be read directly. Instead, you should consume the NetworkStatus, as it indicates the currently deployed configuration. Currently, none of these fields may be changed after installation.",
	"clusterNetwork": "IP address pool to use for pod IPs.",
	"serviceNetwork": "IP address pool for services. Currently, we only support a single entry here.",
	"networkType":    "NetworkType is the plugin that is to be deployed (e.g. OpenShiftSDN). This should match a value that the cluster-network-operator understands, or else no networking will be installed. Currently supported values are: - OpenShiftSDN",
}

func (NetworkSpec) SwaggerDoc() map[string]string {
	return map_NetworkSpec
}

var map_NetworkStatus = map[string]string{
	"":                  "NetworkStatus is the current network configuration.",
	"clusterNetwork":    "IP address pool to use for pod IPs.",
	"serviceNetwork":    "IP address pool for services. Currently, we only support a single entry here.",
	"networkType":       "NetworkType is the plugin that is deployed (e.g. OpenShiftSDN).",
	"clusterNetworkMTU": "ClusterNetworkMTU is the MTU for inter-pod networking.",
}

func (NetworkStatus) SwaggerDoc() map[string]string {
	return map_NetworkStatus
}

var map_BasicAuthPasswordIdentityProvider = map[string]string{
	"": "BasicAuthPasswordIdentityProvider provides identities for users authenticating using HTTP basic auth credentials",
}

func (BasicAuthPasswordIdentityProvider) SwaggerDoc() map[string]string {
	return map_BasicAuthPasswordIdentityProvider
}

var map_GitHubIdentityProvider = map[string]string{
	"":              "GitHubIdentityProvider provides identities for users authenticating using GitHub credentials",
	"clientID":      "clientID is the oauth client ID",
	"clientSecret":  "clientSecret is is a reference to the secret containing the oauth client secret The secret referenced must contain a key named `clientSecret` containing the secret data.",
	"organizations": "organizations optionally restricts which organizations are allowed to log in",
	"teams":         "teams optionally restricts which teams are allowed to log in. Format is <org>/<team>.",
	"hostname":      "hostname is the optional domain (e.g. \"mycompany.com\") for use with a hosted instance of GitHub Enterprise. It must match the GitHub Enterprise settings value configured at /setup/settings#hostname.",
	"ca":            "ca is a reference to a ConfigMap containing an optional trusted certificate authority bundle to use when making requests to the server. If empty, the default system roots are used. This can only be configured when hostname is set to a non-empty value.",
}

func (GitHubIdentityProvider) SwaggerDoc() map[string]string {
	return map_GitHubIdentityProvider
}

var map_GitLabIdentityProvider = map[string]string{
	"":             "GitLabIdentityProvider provides identities for users authenticating using GitLab credentials",
	"ca":           "ca is a reference to a ConfigMap containing an optional trusted certificate authority bundle to use when making requests to the server. If empty, the default system roots are used.",
	"url":          "url is the oauth server base URL",
	"clientID":     "clientID is the oauth client ID",
	"clientSecret": "clientSecret is is a reference to the secret containing the oauth client secret The secret referenced must contain a key named `clientSecret` containing the secret data.",
	"legacy":       "legacy determines that OAuth2 should be used, not OIDC",
}

func (GitLabIdentityProvider) SwaggerDoc() map[string]string {
	return map_GitLabIdentityProvider
}

var map_GoogleIdentityProvider = map[string]string{
	"":             "GoogleIdentityProvider provides identities for users authenticating using Google credentials",
	"clientID":     "clientID is the oauth client ID",
	"clientSecret": "clientSecret is is a reference to the secret containing the oauth client secret The secret referenced must contain a key named `clientSecret` containing the secret data.",
	"hostedDomain": "hostedDomain is the optional Google App domain (e.g. \"mycompany.com\") to restrict logins to",
}

func (GoogleIdentityProvider) SwaggerDoc() map[string]string {
	return map_GoogleIdentityProvider
}

var map_HTPasswdPasswordIdentityProvider = map[string]string{
	"":         "HTPasswdPasswordIdentityProvider provides identities for users authenticating using htpasswd credentials",
	"fileData": "fileData is a reference to a secret containing the data to use as the htpasswd file Looks under the key `htpasswd` unless a lookup key is specified in the secret ref",
}

func (HTPasswdPasswordIdentityProvider) SwaggerDoc() map[string]string {
	return map_HTPasswdPasswordIdentityProvider
}

var map_IdentityProviderConfig = map[string]string{
	"":              "IdentityProviderConfig contains configuration for using a specific identity provider",
	"type":          "type identifies the identity provider type for this entry.",
	"basicAuth":     "basicAuth contains configuration options for the BasicAuth IdP",
	"allowAll":      "allowAll enables the AllowAllIdentityProvider which provides identities for users authenticating using non-empty passwords. Defaults to `false`, i.e. allowAll set to off",
	"denyAll":       "denyAll enables the DenyAllPasswordIdentityProvider which provides no identities for users Defaults to `false`, ie. denyAll set to off",
	"htpasswd":      "htpasswd enables user authentication using an HTPasswd file to validate credentials",
	"ldap":          "ldap enables user authentication using LDAP credentials",
	"keystone":      "keystone enables user authentication using keystone password credentials",
	"requestHeader": "requestHeader enables user authentication using request header credentials",
	"github":        "github enables  user authentication using GitHub credentials",
	"gitlab":        "gitlab enables user authentication using GitLab credentials",
	"google":        "google enables user authentication using Google credentials",
	"openID":        "openID enables user authentication using OpenID credentials",
}

func (IdentityProviderConfig) SwaggerDoc() map[string]string {
	return map_IdentityProviderConfig
}

var map_KeystonePasswordIdentityProvider = map[string]string{
	"":                    "KeystonePasswordIdentityProvider provides identities for users authenticating using keystone password credentials",
	"domainName":          "domainName is required for keystone v3",
	"useKeystoneIdentity": "useKeystoneIdentity flag indicates that user should be authenticated by username, not keystone ID DEPRECATED - only use this option for legacy systems to ensure backwards compatibiity",
}

func (KeystonePasswordIdentityProvider) SwaggerDoc() map[string]string {
	return map_KeystonePasswordIdentityProvider
}

var map_LDAPAttributeMapping = map[string]string{
	"":                  "LDAPAttributeMapping maps LDAP attributes to OpenShift identity fields",
	"id":                "id is the list of attributes whose values should be used as the user ID. Required. First non-empty attribute is used. At least one attribute is required. If none of the listed attribute have a value, authentication fails. LDAP standard identity attribute is \"dn\"",
	"preferredUsername": "preferredUsername is the list of attributes whose values should be used as the preferred username. LDAP standard login attribute is \"uid\"",
	"name":              "name is the list of attributes whose values should be used as the display name. Optional. If unspecified, no display name is set for the identity LDAP standard display name attribute is \"cn\"",
	"email":             "email is the list of attributes whose values should be used as the email address. Optional. If unspecified, no email is set for the identity",
}

func (LDAPAttributeMapping) SwaggerDoc() map[string]string {
	return map_LDAPAttributeMapping
}

var map_LDAPPasswordIdentityProvider = map[string]string{
	"":             "LDAPPasswordIdentityProvider provides identities for users authenticating using LDAP credentials",
	"url":          "url is an RFC 2255 URL which specifies the LDAP search parameters to use. The syntax of the URL is:\n   ldap://host:port/basedn?attribute?scope?filter",
	"bindDN":       "bindDN is an optional DN to bind with during the search phase.",
	"bindPassword": "bindPassword is a reference to the secret containing an optional password to bind with during the search phase. Looks under the key `bindPassword` unless a lookup key is specified in the secret ref",
	"insecure":     "insecure, if true, indicates the connection should not use TLS WARNING: Should not be set to `true` with the URL scheme \"ldaps://\" as \"ldaps://\" URLs always\n         attempt to connect using TLS, even when `insecure` is set to `true`\nWhen `true`, \"ldap://\" URLS connect insecurely. When `false`, \"ldap://\" URLs are upgraded to a TLS connection using StartTLS as specified in https://tools.ietf.org/html/rfc2830.",
	"ca":           "ca is a reference to a ConfigMap containing an optional trusted certificate authority bundle to use when making requests to the server. If empty, the default system roots are used.",
	"attributes":   "attributes maps LDAP attributes to identities",
}

func (LDAPPasswordIdentityProvider) SwaggerDoc() map[string]string {
	return map_LDAPPasswordIdentityProvider
}

var map_OAuth = map[string]string{
	"": "OAuth holds cluster-wide information about OAuth.  The canonical name is `cluster`",
}

func (OAuth) SwaggerDoc() map[string]string {
	return map_OAuth
}

var map_OAuthIdentityProvider = map[string]string{
	"":              "OAuthIdentityProvider provides identities for users authenticating using credentials",
	"name":          "name is used to qualify the identities returned by this provider. - It MUST be unique and not shared by any other identity provider used - It MUST be a vlid path segment: name cannot equal \".\" or \"..\" or contain \"/\" or \"%\"\n  Ref: https://godoc.org/k8s.io/apimachinery/pkg/api/validation/path#ValidatePathSegmentName",
	"challenge":     "challenge indicates whether to issue WWW-Authenticate challenges for this provider",
	"login":         "login indicates whether to use this identity provider for unauthenticated browsers to login against",
	"mappingMethod": "mappingMethod determines how identities from this provider are mapped to users Defaults to \"claim\"",
	"grantMethod":   "grantMethod: allow, deny, prompt This method will be used only if the specific OAuth client doesn't provide a strategy of their own. Valid grant handling methods are:\n - auto:   always approves grant requests, useful for trusted clients\n - prompt: prompts the end user for approval of grant requests, useful for third-party clients\n - deny:   always denies grant requests, useful for black-listed clients\nDefaults to \"prompt\" if not set.",
}

func (OAuthIdentityProvider) SwaggerDoc() map[string]string {
	return map_OAuthIdentityProvider
}

var map_OAuthRemoteConnectionInfo = map[string]string{
	"":              "RemoteConnectionInfo holds information necessary for establishing a remote connection",
	"url":           "url is the remote URL to connect to",
	"ca":            "ca is a reference to a ConfigMap containing the CA for verifying TLS connections",
	"tlsClientCert": "tlsClientCert references a secret containing the TLS client certificate to present when connecting to the server. Looks under the key \"tls.cert\" for the data unless a lookup key is specified in the secret ref",
	"tlsClientKey":  "tlsClientKey references a secret containing the TLS private key for the client certificate Looks under the key \"tls.key\" for the data unless a lookup key is specified in the secret ref",
}

func (OAuthRemoteConnectionInfo) SwaggerDoc() map[string]string {
	return map_OAuthRemoteConnectionInfo
}

var map_OAuthSpec = map[string]string{
	"":                  "OAuthSpec contains desired cluster auth configuration",
	"identityProviders": "identityProviders is an ordered list of ways for a user to identify themselves",
	"tokenConfig":       "tokenConfig contains options for authorization and access tokens",
	"templates":         "templates allow you to customize pages like the login page.",
}

func (OAuthSpec) SwaggerDoc() map[string]string {
	return map_OAuthSpec
}

var map_OAuthStatus = map[string]string{
	"": "OAuthStatus shows current known state of OAuth server in the cluster",
}

func (OAuthStatus) SwaggerDoc() map[string]string {
	return map_OAuthStatus
}

var map_OAuthTemplates = map[string]string{
	"":                  "OAuthTemplates allow for customization of pages like the login page",
	"login":             "login is a reference to a secret that specifies a go template to use to render the login page. If a key is not specified, the key `login.html` is used to locate the template data. If unspecified, the default login page is used.",
	"providerSelection": "providerSelection is a reference to a secret that specifies a go template to use to render the provider selection page. If a key is not specified, the key `providers.html` is used to locate the template data. If unspecified, the default provider selection page is used.",
	"error":             "error is a reference to a secret that specifies a go template to use to render error pages during the authentication or grant flow. If a key is not specified, the key `errrors.html` is used to locate the template data. If unspecified, the default error page is used.",
}

func (OAuthTemplates) SwaggerDoc() map[string]string {
	return map_OAuthTemplates
}

var map_OpenIDClaims = map[string]string{
	"":                  "OpenIDClaims contains a list of OpenID claims to use when authenticating with an OpenID identity provider",
	"preferredUsername": "preferredUsername is the list of claims whose values should be used as the preferred username. If unspecified, the preferred username is determined from the value of the id claim",
	"name":              "name is the list of claims whose values should be used as the display name. Optional. If unspecified, no display name is set for the identity",
	"email":             "email is the list of claims whose values should be used as the email address. Optional. If unspecified, no email is set for the identity",
}

func (OpenIDClaims) SwaggerDoc() map[string]string {
	return map_OpenIDClaims
}

var map_OpenIDIdentityProvider = map[string]string{
	"":                         "OpenIDIdentityProvider provides identities for users authenticating using OpenID credentials",
	"ca":                       "ca is a reference to a ConfigMap containing an optional trusted certificate authority bundle to use when making requests to the server. If empty, the default system roots are used.",
	"clientID":                 "clientID is the oauth client ID",
	"clientSecret":             "clientSecret is is a reference to the secret containing the oauth client secret The secret referenced must contain a key named `clientSecret` containing the secret data.",
	"extraScopes":              "extraScopes are any scopes to request in addition to the standard \"openid\" scope.",
	"extraAuthorizeParameters": "extraAuthorizeParameters are any custom parameters to add to the authorize request.",
	"urls":   "urls to use to authenticate",
	"claims": "claims mappings",
}

func (OpenIDIdentityProvider) SwaggerDoc() map[string]string {
	return map_OpenIDIdentityProvider
}

var map_OpenIDURLs = map[string]string{
	"":          "OpenIDURLs are URLs to use when authenticating with an OpenID identity provider",
	"authorize": "authorize is the oauth authorization URL",
	"token":     "token is the oauth token granting URL",
	"userInfo":  "userInfo is the optional userinfo URL. If present, a granted access_token is used to request claims If empty, a granted id_token is parsed for claims",
}

func (OpenIDURLs) SwaggerDoc() map[string]string {
	return map_OpenIDURLs
}

var map_RequestHeaderIdentityProvider = map[string]string{
	"":                         "RequestHeaderIdentityProvider provides identities for users authenticating using request header credentials",
	"loginURL":                 "loginURL is a URL to redirect unauthenticated /authorize requests to Unauthenticated requests from OAuth clients which expect interactive logins will be redirected here ${url} is replaced with the current URL, escaped to be safe in a query parameter\n  https://www.example.com/sso-login?then=${url}\n${query} is replaced with the current query string\n  https://www.example.com/auth-proxy/oauth/authorize?${query}\nRequired when UseAsLogin is set to true.",
	"challengeURL":             "challengeURL is a URL to redirect unauthenticated /authorize requests to Unauthenticated requests from OAuth clients which expect WWW-Authenticate challenges will be redirected here. ${url} is replaced with the current URL, escaped to be safe in a query parameter\n  https://www.example.com/sso-login?then=${url}\n${query} is replaced with the current query string\n  https://www.example.com/auth-proxy/oauth/authorize?${query}\nRequired when UseAsChallenger is set to true.",
	"ca":                       "clientCA is a reference to a configmap with the trusted signer certs. If empty, no request verification is done, and any direct request to the OAuth server can impersonate any identity from this provider, merely by setting a request header.",
	"clientCommonNames":        "clientCommonNames is an optional list of common names to require a match from. If empty, any client certificate validated against the clientCA bundle is considered authoritative.",
	"headers":                  "headers is the set of headers to check for identity information",
	"preferredUsernameHeaders": "preferredUsernameHeaders is the set of headers to check for the preferred username",
	"nameHeaders":              "nameHeaders is the set of headers to check for the display name",
	"emailHeaders":             "emailHeaders is the set of headers to check for the email address",
}

func (RequestHeaderIdentityProvider) SwaggerDoc() map[string]string {
	return map_RequestHeaderIdentityProvider
}

var map_TokenConfig = map[string]string{
	"": "TokenConfig holds the necessary configuration options for authorization and access tokens",
	"authorizeTokenMaxAgeSeconds":         "authorizeTokenMaxAgeSeconds defines the maximum age of authorize tokens",
	"accessTokenMaxAgeSeconds":            "accessTokenMaxAgeSeconds defines the maximum age of access tokens",
	"accessTokenInactivityTimeoutSeconds": "accessTokenInactivityTimeoutSeconds defines the default token inactivity timeout for tokens granted by any client. The value represents the maximum amount of time that can occur between consecutive uses of the token. Tokens become invalid if they are not used within this temporal window. The user will need to acquire a new token to regain access once a token times out. Valid values are integer values:\n  x < 0  Tokens time out is enabled but tokens never timeout unless configured per client (e.g. `-1`)\n  x = 0  Tokens time out is disabled (default)\n  x > 0  Tokens time out if there is no activity for x seconds\nThe current minimum allowed value for X is 300 (5 minutes)",
}

func (TokenConfig) SwaggerDoc() map[string]string {
	return map_TokenConfig
}

var map_Project = map[string]string{
	"":         "Project holds cluster-wide information about Project.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Project) SwaggerDoc() map[string]string {
	return map_Project
}

var map_ProjectList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (ProjectList) SwaggerDoc() map[string]string {
	return map_ProjectList
}

var map_Proxy = map[string]string{
	"":     "Proxy holds cluster-wide information on how to configure default proxies for the cluster. The canonical name is `cluster`",
	"spec": "Spec holds user-settable values for the proxy configuration",
}

func (Proxy) SwaggerDoc() map[string]string {
	return map_Proxy
}

var map_ProxyList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (ProxyList) SwaggerDoc() map[string]string {
	return map_ProxyList
}

var map_ProxySpec = map[string]string{
	"httpProxy":  "httpProxy is the URL of the proxy for HTTP requests.  Empty means unset and will not result in an env var.",
	"httpsProxy": "httpsProxy is the URL of the proxy for HTTPS requests.  Empty means unset and will not result in an env var.",
	"noProxy":    "noProxy is the list of domains for which the proxy should not be used.  Empty means unset and will not result in an env var.",
}

func (ProxySpec) SwaggerDoc() map[string]string {
	return map_ProxySpec
}

var map_Scheduling = map[string]string{
	"":         "Scheduling holds cluster-wide information about Scheduling.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Scheduling) SwaggerDoc() map[string]string {
	return map_Scheduling
}

var map_SchedulingList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (SchedulingList) SwaggerDoc() map[string]string {
	return map_SchedulingList
}

// AUTO-GENERATED FUNCTIONS END HERE
