/*
Copyright 2018 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was generated by "go run gen/main.go > gen.go". Do not edit
// directly.

package cloud

import (
	"context"
	"fmt"
	"net/http"
	"sync"

	"github.com/golang/glog"
	"google.golang.org/api/googleapi"

	"k8s.io/kubernetes/pkg/cloudprovider/providers/gce/cloud/filter"
	"k8s.io/kubernetes/pkg/cloudprovider/providers/gce/cloud/meta"

	alpha "google.golang.org/api/compute/v0.alpha"
	beta "google.golang.org/api/compute/v0.beta"
	ga "google.golang.org/api/compute/v1"
)

// Cloud is an interface for the GCE compute API.
type Cloud interface {
	Addresses() Addresses
	AlphaAddresses() AlphaAddresses
	BetaAddresses() BetaAddresses
	GlobalAddresses() GlobalAddresses
	BackendServices() BackendServices
	AlphaBackendServices() AlphaBackendServices
	RegionBackendServices() RegionBackendServices
	AlphaRegionBackendServices() AlphaRegionBackendServices
	Disks() Disks
	AlphaDisks() AlphaDisks
	AlphaRegionDisks() AlphaRegionDisks
	Firewalls() Firewalls
	ForwardingRules() ForwardingRules
	AlphaForwardingRules() AlphaForwardingRules
	GlobalForwardingRules() GlobalForwardingRules
	HealthChecks() HealthChecks
	AlphaHealthChecks() AlphaHealthChecks
	HttpHealthChecks() HttpHealthChecks
	HttpsHealthChecks() HttpsHealthChecks
	InstanceGroups() InstanceGroups
	Instances() Instances
	BetaInstances() BetaInstances
	AlphaInstances() AlphaInstances
	AlphaNetworkEndpointGroups() AlphaNetworkEndpointGroups
	Projects() Projects
	Regions() Regions
	Routes() Routes
	SslCertificates() SslCertificates
	TargetHttpProxies() TargetHttpProxies
	TargetHttpsProxies() TargetHttpsProxies
	TargetPools() TargetPools
	UrlMaps() UrlMaps
	Zones() Zones
}

// NewGCE returns a GCE.
func NewGCE(s *Service) *GCE {
	g := &GCE{
		gceAddresses:                  &GCEAddresses{s},
		gceAlphaAddresses:             &GCEAlphaAddresses{s},
		gceBetaAddresses:              &GCEBetaAddresses{s},
		gceGlobalAddresses:            &GCEGlobalAddresses{s},
		gceBackendServices:            &GCEBackendServices{s},
		gceAlphaBackendServices:       &GCEAlphaBackendServices{s},
		gceRegionBackendServices:      &GCERegionBackendServices{s},
		gceAlphaRegionBackendServices: &GCEAlphaRegionBackendServices{s},
		gceDisks:                      &GCEDisks{s},
		gceAlphaDisks:                 &GCEAlphaDisks{s},
		gceAlphaRegionDisks:           &GCEAlphaRegionDisks{s},
		gceFirewalls:                  &GCEFirewalls{s},
		gceForwardingRules:            &GCEForwardingRules{s},
		gceAlphaForwardingRules:       &GCEAlphaForwardingRules{s},
		gceGlobalForwardingRules:      &GCEGlobalForwardingRules{s},
		gceHealthChecks:               &GCEHealthChecks{s},
		gceAlphaHealthChecks:          &GCEAlphaHealthChecks{s},
		gceHttpHealthChecks:           &GCEHttpHealthChecks{s},
		gceHttpsHealthChecks:          &GCEHttpsHealthChecks{s},
		gceInstanceGroups:             &GCEInstanceGroups{s},
		gceInstances:                  &GCEInstances{s},
		gceBetaInstances:              &GCEBetaInstances{s},
		gceAlphaInstances:             &GCEAlphaInstances{s},
		gceAlphaNetworkEndpointGroups: &GCEAlphaNetworkEndpointGroups{s},
		gceProjects:                   &GCEProjects{s},
		gceRegions:                    &GCERegions{s},
		gceRoutes:                     &GCERoutes{s},
		gceSslCertificates:            &GCESslCertificates{s},
		gceTargetHttpProxies:          &GCETargetHttpProxies{s},
		gceTargetHttpsProxies:         &GCETargetHttpsProxies{s},
		gceTargetPools:                &GCETargetPools{s},
		gceUrlMaps:                    &GCEUrlMaps{s},
		gceZones:                      &GCEZones{s},
	}
	return g
}

// GCE implements Cloud.
var _ Cloud = (*GCE)(nil)

// GCE is the golang adapter for the compute APIs.
type GCE struct {
	gceAddresses                  *GCEAddresses
	gceAlphaAddresses             *GCEAlphaAddresses
	gceBetaAddresses              *GCEBetaAddresses
	gceGlobalAddresses            *GCEGlobalAddresses
	gceBackendServices            *GCEBackendServices
	gceAlphaBackendServices       *GCEAlphaBackendServices
	gceRegionBackendServices      *GCERegionBackendServices
	gceAlphaRegionBackendServices *GCEAlphaRegionBackendServices
	gceDisks                      *GCEDisks
	gceAlphaDisks                 *GCEAlphaDisks
	gceAlphaRegionDisks           *GCEAlphaRegionDisks
	gceFirewalls                  *GCEFirewalls
	gceForwardingRules            *GCEForwardingRules
	gceAlphaForwardingRules       *GCEAlphaForwardingRules
	gceGlobalForwardingRules      *GCEGlobalForwardingRules
	gceHealthChecks               *GCEHealthChecks
	gceAlphaHealthChecks          *GCEAlphaHealthChecks
	gceHttpHealthChecks           *GCEHttpHealthChecks
	gceHttpsHealthChecks          *GCEHttpsHealthChecks
	gceInstanceGroups             *GCEInstanceGroups
	gceInstances                  *GCEInstances
	gceBetaInstances              *GCEBetaInstances
	gceAlphaInstances             *GCEAlphaInstances
	gceAlphaNetworkEndpointGroups *GCEAlphaNetworkEndpointGroups
	gceProjects                   *GCEProjects
	gceRegions                    *GCERegions
	gceRoutes                     *GCERoutes
	gceSslCertificates            *GCESslCertificates
	gceTargetHttpProxies          *GCETargetHttpProxies
	gceTargetHttpsProxies         *GCETargetHttpsProxies
	gceTargetPools                *GCETargetPools
	gceUrlMaps                    *GCEUrlMaps
	gceZones                      *GCEZones
}

// Addresses returns the interface for the ga Addresses.
func (gce *GCE) Addresses() Addresses {
	return gce.gceAddresses
}

// AlphaAddresses returns the interface for the alpha Addresses.
func (gce *GCE) AlphaAddresses() AlphaAddresses {
	return gce.gceAlphaAddresses
}

// BetaAddresses returns the interface for the beta Addresses.
func (gce *GCE) BetaAddresses() BetaAddresses {
	return gce.gceBetaAddresses
}

// GlobalAddresses returns the interface for the ga GlobalAddresses.
func (gce *GCE) GlobalAddresses() GlobalAddresses {
	return gce.gceGlobalAddresses
}

// BackendServices returns the interface for the ga BackendServices.
func (gce *GCE) BackendServices() BackendServices {
	return gce.gceBackendServices
}

// AlphaBackendServices returns the interface for the alpha BackendServices.
func (gce *GCE) AlphaBackendServices() AlphaBackendServices {
	return gce.gceAlphaBackendServices
}

// RegionBackendServices returns the interface for the ga RegionBackendServices.
func (gce *GCE) RegionBackendServices() RegionBackendServices {
	return gce.gceRegionBackendServices
}

// AlphaRegionBackendServices returns the interface for the alpha RegionBackendServices.
func (gce *GCE) AlphaRegionBackendServices() AlphaRegionBackendServices {
	return gce.gceAlphaRegionBackendServices
}

// Disks returns the interface for the ga Disks.
func (gce *GCE) Disks() Disks {
	return gce.gceDisks
}

// AlphaDisks returns the interface for the alpha Disks.
func (gce *GCE) AlphaDisks() AlphaDisks {
	return gce.gceAlphaDisks
}

// AlphaRegionDisks returns the interface for the alpha RegionDisks.
func (gce *GCE) AlphaRegionDisks() AlphaRegionDisks {
	return gce.gceAlphaRegionDisks
}

// Firewalls returns the interface for the ga Firewalls.
func (gce *GCE) Firewalls() Firewalls {
	return gce.gceFirewalls
}

// ForwardingRules returns the interface for the ga ForwardingRules.
func (gce *GCE) ForwardingRules() ForwardingRules {
	return gce.gceForwardingRules
}

// AlphaForwardingRules returns the interface for the alpha ForwardingRules.
func (gce *GCE) AlphaForwardingRules() AlphaForwardingRules {
	return gce.gceAlphaForwardingRules
}

// GlobalForwardingRules returns the interface for the ga GlobalForwardingRules.
func (gce *GCE) GlobalForwardingRules() GlobalForwardingRules {
	return gce.gceGlobalForwardingRules
}

// HealthChecks returns the interface for the ga HealthChecks.
func (gce *GCE) HealthChecks() HealthChecks {
	return gce.gceHealthChecks
}

// AlphaHealthChecks returns the interface for the alpha HealthChecks.
func (gce *GCE) AlphaHealthChecks() AlphaHealthChecks {
	return gce.gceAlphaHealthChecks
}

// HttpHealthChecks returns the interface for the ga HttpHealthChecks.
func (gce *GCE) HttpHealthChecks() HttpHealthChecks {
	return gce.gceHttpHealthChecks
}

// HttpsHealthChecks returns the interface for the ga HttpsHealthChecks.
func (gce *GCE) HttpsHealthChecks() HttpsHealthChecks {
	return gce.gceHttpsHealthChecks
}

// InstanceGroups returns the interface for the ga InstanceGroups.
func (gce *GCE) InstanceGroups() InstanceGroups {
	return gce.gceInstanceGroups
}

// Instances returns the interface for the ga Instances.
func (gce *GCE) Instances() Instances {
	return gce.gceInstances
}

// BetaInstances returns the interface for the beta Instances.
func (gce *GCE) BetaInstances() BetaInstances {
	return gce.gceBetaInstances
}

// AlphaInstances returns the interface for the alpha Instances.
func (gce *GCE) AlphaInstances() AlphaInstances {
	return gce.gceAlphaInstances
}

// AlphaNetworkEndpointGroups returns the interface for the alpha NetworkEndpointGroups.
func (gce *GCE) AlphaNetworkEndpointGroups() AlphaNetworkEndpointGroups {
	return gce.gceAlphaNetworkEndpointGroups
}

// Projects returns the interface for the ga Projects.
func (gce *GCE) Projects() Projects {
	return gce.gceProjects
}

// Regions returns the interface for the ga Regions.
func (gce *GCE) Regions() Regions {
	return gce.gceRegions
}

// Routes returns the interface for the ga Routes.
func (gce *GCE) Routes() Routes {
	return gce.gceRoutes
}

// SslCertificates returns the interface for the ga SslCertificates.
func (gce *GCE) SslCertificates() SslCertificates {
	return gce.gceSslCertificates
}

// TargetHttpProxies returns the interface for the ga TargetHttpProxies.
func (gce *GCE) TargetHttpProxies() TargetHttpProxies {
	return gce.gceTargetHttpProxies
}

// TargetHttpsProxies returns the interface for the ga TargetHttpsProxies.
func (gce *GCE) TargetHttpsProxies() TargetHttpsProxies {
	return gce.gceTargetHttpsProxies
}

// TargetPools returns the interface for the ga TargetPools.
func (gce *GCE) TargetPools() TargetPools {
	return gce.gceTargetPools
}

// UrlMaps returns the interface for the ga UrlMaps.
func (gce *GCE) UrlMaps() UrlMaps {
	return gce.gceUrlMaps
}

// Zones returns the interface for the ga Zones.
func (gce *GCE) Zones() Zones {
	return gce.gceZones
}

// NewMockGCE returns a new mock for GCE.
func NewMockGCE(projectRouter ProjectRouter) *MockGCE {
	mockAddressesObjs := map[meta.Key]*MockAddressesObj{}
	mockBackendServicesObjs := map[meta.Key]*MockBackendServicesObj{}
	mockDisksObjs := map[meta.Key]*MockDisksObj{}
	mockFirewallsObjs := map[meta.Key]*MockFirewallsObj{}
	mockForwardingRulesObjs := map[meta.Key]*MockForwardingRulesObj{}
	mockGlobalAddressesObjs := map[meta.Key]*MockGlobalAddressesObj{}
	mockGlobalForwardingRulesObjs := map[meta.Key]*MockGlobalForwardingRulesObj{}
	mockHealthChecksObjs := map[meta.Key]*MockHealthChecksObj{}
	mockHttpHealthChecksObjs := map[meta.Key]*MockHttpHealthChecksObj{}
	mockHttpsHealthChecksObjs := map[meta.Key]*MockHttpsHealthChecksObj{}
	mockInstanceGroupsObjs := map[meta.Key]*MockInstanceGroupsObj{}
	mockInstancesObjs := map[meta.Key]*MockInstancesObj{}
	mockNetworkEndpointGroupsObjs := map[meta.Key]*MockNetworkEndpointGroupsObj{}
	mockProjectsObjs := map[meta.Key]*MockProjectsObj{}
	mockRegionBackendServicesObjs := map[meta.Key]*MockRegionBackendServicesObj{}
	mockRegionDisksObjs := map[meta.Key]*MockRegionDisksObj{}
	mockRegionsObjs := map[meta.Key]*MockRegionsObj{}
	mockRoutesObjs := map[meta.Key]*MockRoutesObj{}
	mockSslCertificatesObjs := map[meta.Key]*MockSslCertificatesObj{}
	mockTargetHttpProxiesObjs := map[meta.Key]*MockTargetHttpProxiesObj{}
	mockTargetHttpsProxiesObjs := map[meta.Key]*MockTargetHttpsProxiesObj{}
	mockTargetPoolsObjs := map[meta.Key]*MockTargetPoolsObj{}
	mockUrlMapsObjs := map[meta.Key]*MockUrlMapsObj{}
	mockZonesObjs := map[meta.Key]*MockZonesObj{}

	mock := &MockGCE{
		MockAddresses:                  NewMockAddresses(projectRouter, mockAddressesObjs),
		MockAlphaAddresses:             NewMockAlphaAddresses(projectRouter, mockAddressesObjs),
		MockBetaAddresses:              NewMockBetaAddresses(projectRouter, mockAddressesObjs),
		MockGlobalAddresses:            NewMockGlobalAddresses(projectRouter, mockGlobalAddressesObjs),
		MockBackendServices:            NewMockBackendServices(projectRouter, mockBackendServicesObjs),
		MockAlphaBackendServices:       NewMockAlphaBackendServices(projectRouter, mockBackendServicesObjs),
		MockRegionBackendServices:      NewMockRegionBackendServices(projectRouter, mockRegionBackendServicesObjs),
		MockAlphaRegionBackendServices: NewMockAlphaRegionBackendServices(projectRouter, mockRegionBackendServicesObjs),
		MockDisks:                      NewMockDisks(projectRouter, mockDisksObjs),
		MockAlphaDisks:                 NewMockAlphaDisks(projectRouter, mockDisksObjs),
		MockAlphaRegionDisks:           NewMockAlphaRegionDisks(projectRouter, mockRegionDisksObjs),
		MockFirewalls:                  NewMockFirewalls(projectRouter, mockFirewallsObjs),
		MockForwardingRules:            NewMockForwardingRules(projectRouter, mockForwardingRulesObjs),
		MockAlphaForwardingRules:       NewMockAlphaForwardingRules(projectRouter, mockForwardingRulesObjs),
		MockGlobalForwardingRules:      NewMockGlobalForwardingRules(projectRouter, mockGlobalForwardingRulesObjs),
		MockHealthChecks:               NewMockHealthChecks(projectRouter, mockHealthChecksObjs),
		MockAlphaHealthChecks:          NewMockAlphaHealthChecks(projectRouter, mockHealthChecksObjs),
		MockHttpHealthChecks:           NewMockHttpHealthChecks(projectRouter, mockHttpHealthChecksObjs),
		MockHttpsHealthChecks:          NewMockHttpsHealthChecks(projectRouter, mockHttpsHealthChecksObjs),
		MockInstanceGroups:             NewMockInstanceGroups(projectRouter, mockInstanceGroupsObjs),
		MockInstances:                  NewMockInstances(projectRouter, mockInstancesObjs),
		MockBetaInstances:              NewMockBetaInstances(projectRouter, mockInstancesObjs),
		MockAlphaInstances:             NewMockAlphaInstances(projectRouter, mockInstancesObjs),
		MockAlphaNetworkEndpointGroups: NewMockAlphaNetworkEndpointGroups(projectRouter, mockNetworkEndpointGroupsObjs),
		MockProjects:                   NewMockProjects(projectRouter, mockProjectsObjs),
		MockRegions:                    NewMockRegions(projectRouter, mockRegionsObjs),
		MockRoutes:                     NewMockRoutes(projectRouter, mockRoutesObjs),
		MockSslCertificates:            NewMockSslCertificates(projectRouter, mockSslCertificatesObjs),
		MockTargetHttpProxies:          NewMockTargetHttpProxies(projectRouter, mockTargetHttpProxiesObjs),
		MockTargetHttpsProxies:         NewMockTargetHttpsProxies(projectRouter, mockTargetHttpsProxiesObjs),
		MockTargetPools:                NewMockTargetPools(projectRouter, mockTargetPoolsObjs),
		MockUrlMaps:                    NewMockUrlMaps(projectRouter, mockUrlMapsObjs),
		MockZones:                      NewMockZones(projectRouter, mockZonesObjs),
	}
	return mock
}

// MockGCE implements Cloud.
var _ Cloud = (*MockGCE)(nil)

// MockGCE is the mock for the compute API.
type MockGCE struct {
	MockAddresses                  *MockAddresses
	MockAlphaAddresses             *MockAlphaAddresses
	MockBetaAddresses              *MockBetaAddresses
	MockGlobalAddresses            *MockGlobalAddresses
	MockBackendServices            *MockBackendServices
	MockAlphaBackendServices       *MockAlphaBackendServices
	MockRegionBackendServices      *MockRegionBackendServices
	MockAlphaRegionBackendServices *MockAlphaRegionBackendServices
	MockDisks                      *MockDisks
	MockAlphaDisks                 *MockAlphaDisks
	MockAlphaRegionDisks           *MockAlphaRegionDisks
	MockFirewalls                  *MockFirewalls
	MockForwardingRules            *MockForwardingRules
	MockAlphaForwardingRules       *MockAlphaForwardingRules
	MockGlobalForwardingRules      *MockGlobalForwardingRules
	MockHealthChecks               *MockHealthChecks
	MockAlphaHealthChecks          *MockAlphaHealthChecks
	MockHttpHealthChecks           *MockHttpHealthChecks
	MockHttpsHealthChecks          *MockHttpsHealthChecks
	MockInstanceGroups             *MockInstanceGroups
	MockInstances                  *MockInstances
	MockBetaInstances              *MockBetaInstances
	MockAlphaInstances             *MockAlphaInstances
	MockAlphaNetworkEndpointGroups *MockAlphaNetworkEndpointGroups
	MockProjects                   *MockProjects
	MockRegions                    *MockRegions
	MockRoutes                     *MockRoutes
	MockSslCertificates            *MockSslCertificates
	MockTargetHttpProxies          *MockTargetHttpProxies
	MockTargetHttpsProxies         *MockTargetHttpsProxies
	MockTargetPools                *MockTargetPools
	MockUrlMaps                    *MockUrlMaps
	MockZones                      *MockZones
}

// Addresses returns the interface for the ga Addresses.
func (mock *MockGCE) Addresses() Addresses {
	return mock.MockAddresses
}

// AlphaAddresses returns the interface for the alpha Addresses.
func (mock *MockGCE) AlphaAddresses() AlphaAddresses {
	return mock.MockAlphaAddresses
}

// BetaAddresses returns the interface for the beta Addresses.
func (mock *MockGCE) BetaAddresses() BetaAddresses {
	return mock.MockBetaAddresses
}

// GlobalAddresses returns the interface for the ga GlobalAddresses.
func (mock *MockGCE) GlobalAddresses() GlobalAddresses {
	return mock.MockGlobalAddresses
}

// BackendServices returns the interface for the ga BackendServices.
func (mock *MockGCE) BackendServices() BackendServices {
	return mock.MockBackendServices
}

// AlphaBackendServices returns the interface for the alpha BackendServices.
func (mock *MockGCE) AlphaBackendServices() AlphaBackendServices {
	return mock.MockAlphaBackendServices
}

// RegionBackendServices returns the interface for the ga RegionBackendServices.
func (mock *MockGCE) RegionBackendServices() RegionBackendServices {
	return mock.MockRegionBackendServices
}

// AlphaRegionBackendServices returns the interface for the alpha RegionBackendServices.
func (mock *MockGCE) AlphaRegionBackendServices() AlphaRegionBackendServices {
	return mock.MockAlphaRegionBackendServices
}

// Disks returns the interface for the ga Disks.
func (mock *MockGCE) Disks() Disks {
	return mock.MockDisks
}

// AlphaDisks returns the interface for the alpha Disks.
func (mock *MockGCE) AlphaDisks() AlphaDisks {
	return mock.MockAlphaDisks
}

// AlphaRegionDisks returns the interface for the alpha RegionDisks.
func (mock *MockGCE) AlphaRegionDisks() AlphaRegionDisks {
	return mock.MockAlphaRegionDisks
}

// Firewalls returns the interface for the ga Firewalls.
func (mock *MockGCE) Firewalls() Firewalls {
	return mock.MockFirewalls
}

// ForwardingRules returns the interface for the ga ForwardingRules.
func (mock *MockGCE) ForwardingRules() ForwardingRules {
	return mock.MockForwardingRules
}

// AlphaForwardingRules returns the interface for the alpha ForwardingRules.
func (mock *MockGCE) AlphaForwardingRules() AlphaForwardingRules {
	return mock.MockAlphaForwardingRules
}

// GlobalForwardingRules returns the interface for the ga GlobalForwardingRules.
func (mock *MockGCE) GlobalForwardingRules() GlobalForwardingRules {
	return mock.MockGlobalForwardingRules
}

// HealthChecks returns the interface for the ga HealthChecks.
func (mock *MockGCE) HealthChecks() HealthChecks {
	return mock.MockHealthChecks
}

// AlphaHealthChecks returns the interface for the alpha HealthChecks.
func (mock *MockGCE) AlphaHealthChecks() AlphaHealthChecks {
	return mock.MockAlphaHealthChecks
}

// HttpHealthChecks returns the interface for the ga HttpHealthChecks.
func (mock *MockGCE) HttpHealthChecks() HttpHealthChecks {
	return mock.MockHttpHealthChecks
}

// HttpsHealthChecks returns the interface for the ga HttpsHealthChecks.
func (mock *MockGCE) HttpsHealthChecks() HttpsHealthChecks {
	return mock.MockHttpsHealthChecks
}

// InstanceGroups returns the interface for the ga InstanceGroups.
func (mock *MockGCE) InstanceGroups() InstanceGroups {
	return mock.MockInstanceGroups
}

// Instances returns the interface for the ga Instances.
func (mock *MockGCE) Instances() Instances {
	return mock.MockInstances
}

// BetaInstances returns the interface for the beta Instances.
func (mock *MockGCE) BetaInstances() BetaInstances {
	return mock.MockBetaInstances
}

// AlphaInstances returns the interface for the alpha Instances.
func (mock *MockGCE) AlphaInstances() AlphaInstances {
	return mock.MockAlphaInstances
}

// AlphaNetworkEndpointGroups returns the interface for the alpha NetworkEndpointGroups.
func (mock *MockGCE) AlphaNetworkEndpointGroups() AlphaNetworkEndpointGroups {
	return mock.MockAlphaNetworkEndpointGroups
}

// Projects returns the interface for the ga Projects.
func (mock *MockGCE) Projects() Projects {
	return mock.MockProjects
}

// Regions returns the interface for the ga Regions.
func (mock *MockGCE) Regions() Regions {
	return mock.MockRegions
}

// Routes returns the interface for the ga Routes.
func (mock *MockGCE) Routes() Routes {
	return mock.MockRoutes
}

// SslCertificates returns the interface for the ga SslCertificates.
func (mock *MockGCE) SslCertificates() SslCertificates {
	return mock.MockSslCertificates
}

// TargetHttpProxies returns the interface for the ga TargetHttpProxies.
func (mock *MockGCE) TargetHttpProxies() TargetHttpProxies {
	return mock.MockTargetHttpProxies
}

// TargetHttpsProxies returns the interface for the ga TargetHttpsProxies.
func (mock *MockGCE) TargetHttpsProxies() TargetHttpsProxies {
	return mock.MockTargetHttpsProxies
}

// TargetPools returns the interface for the ga TargetPools.
func (mock *MockGCE) TargetPools() TargetPools {
	return mock.MockTargetPools
}

// UrlMaps returns the interface for the ga UrlMaps.
func (mock *MockGCE) UrlMaps() UrlMaps {
	return mock.MockUrlMaps
}

// Zones returns the interface for the ga Zones.
func (mock *MockGCE) Zones() Zones {
	return mock.MockZones
}

// MockAddressesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockAddressesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockAddressesObj) ToAlpha() *alpha.Address {
	if ret, ok := m.Obj.(*alpha.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *alpha.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockAddressesObj) ToBeta() *beta.Address {
	if ret, ok := m.Obj.(*beta.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *beta.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockAddressesObj) ToGA() *ga.Address {
	if ret, ok := m.Obj.(*ga.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockBackendServicesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockBackendServicesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockBackendServicesObj) ToAlpha() *alpha.BackendService {
	if ret, ok := m.Obj.(*alpha.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *alpha.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockBackendServicesObj) ToGA() *ga.BackendService {
	if ret, ok := m.Obj.(*ga.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockDisksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockDisksObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockDisksObj) ToAlpha() *alpha.Disk {
	if ret, ok := m.Obj.(*alpha.Disk); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.Disk{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *alpha.Disk via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockDisksObj) ToGA() *ga.Disk {
	if ret, ok := m.Obj.(*ga.Disk); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Disk{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.Disk via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockFirewallsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockFirewallsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockFirewallsObj) ToGA() *ga.Firewall {
	if ret, ok := m.Obj.(*ga.Firewall); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Firewall{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.Firewall via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockForwardingRulesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockForwardingRulesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockForwardingRulesObj) ToAlpha() *alpha.ForwardingRule {
	if ret, ok := m.Obj.(*alpha.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *alpha.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockForwardingRulesObj) ToGA() *ga.ForwardingRule {
	if ret, ok := m.Obj.(*ga.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockGlobalAddressesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockGlobalAddressesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockGlobalAddressesObj) ToGA() *ga.Address {
	if ret, ok := m.Obj.(*ga.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockGlobalForwardingRulesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockGlobalForwardingRulesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockGlobalForwardingRulesObj) ToGA() *ga.ForwardingRule {
	if ret, ok := m.Obj.(*ga.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockHealthChecksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockHealthChecksObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockHealthChecksObj) ToAlpha() *alpha.HealthCheck {
	if ret, ok := m.Obj.(*alpha.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *alpha.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockHealthChecksObj) ToGA() *ga.HealthCheck {
	if ret, ok := m.Obj.(*ga.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockHttpHealthChecksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockHttpHealthChecksObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockHttpHealthChecksObj) ToGA() *ga.HttpHealthCheck {
	if ret, ok := m.Obj.(*ga.HttpHealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.HttpHealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.HttpHealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockHttpsHealthChecksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockHttpsHealthChecksObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockHttpsHealthChecksObj) ToGA() *ga.HttpsHealthCheck {
	if ret, ok := m.Obj.(*ga.HttpsHealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.HttpsHealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.HttpsHealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockInstanceGroupsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockInstanceGroupsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockInstanceGroupsObj) ToGA() *ga.InstanceGroup {
	if ret, ok := m.Obj.(*ga.InstanceGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.InstanceGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.InstanceGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockInstancesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockInstancesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockInstancesObj) ToAlpha() *alpha.Instance {
	if ret, ok := m.Obj.(*alpha.Instance); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.Instance{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *alpha.Instance via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockInstancesObj) ToBeta() *beta.Instance {
	if ret, ok := m.Obj.(*beta.Instance); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &beta.Instance{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *beta.Instance via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockInstancesObj) ToGA() *ga.Instance {
	if ret, ok := m.Obj.(*ga.Instance); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Instance{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.Instance via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockNetworkEndpointGroupsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockNetworkEndpointGroupsObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockNetworkEndpointGroupsObj) ToAlpha() *alpha.NetworkEndpointGroup {
	if ret, ok := m.Obj.(*alpha.NetworkEndpointGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.NetworkEndpointGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *alpha.NetworkEndpointGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockProjectsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockProjectsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockProjectsObj) ToGA() *ga.Project {
	if ret, ok := m.Obj.(*ga.Project); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Project{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.Project via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionBackendServicesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionBackendServicesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionBackendServicesObj) ToAlpha() *alpha.BackendService {
	if ret, ok := m.Obj.(*alpha.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *alpha.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionBackendServicesObj) ToGA() *ga.BackendService {
	if ret, ok := m.Obj.(*ga.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionDisksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionDisksObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionDisksObj) ToAlpha() *alpha.Disk {
	if ret, ok := m.Obj.(*alpha.Disk); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &alpha.Disk{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *alpha.Disk via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockRegionsObj) ToGA() *ga.Region {
	if ret, ok := m.Obj.(*ga.Region); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Region{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.Region via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRoutesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRoutesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockRoutesObj) ToGA() *ga.Route {
	if ret, ok := m.Obj.(*ga.Route); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Route{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.Route via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockSslCertificatesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockSslCertificatesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockSslCertificatesObj) ToGA() *ga.SslCertificate {
	if ret, ok := m.Obj.(*ga.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockTargetHttpProxiesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockTargetHttpProxiesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockTargetHttpProxiesObj) ToGA() *ga.TargetHttpProxy {
	if ret, ok := m.Obj.(*ga.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockTargetHttpsProxiesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockTargetHttpsProxiesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockTargetHttpsProxiesObj) ToGA() *ga.TargetHttpsProxy {
	if ret, ok := m.Obj.(*ga.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockTargetPoolsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockTargetPoolsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockTargetPoolsObj) ToGA() *ga.TargetPool {
	if ret, ok := m.Obj.(*ga.TargetPool); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.TargetPool{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.TargetPool via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockUrlMapsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockUrlMapsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockUrlMapsObj) ToGA() *ga.UrlMap {
	if ret, ok := m.Obj.(*ga.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockZonesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockZonesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockZonesObj) ToGA() *ga.Zone {
	if ret, ok := m.Obj.(*ga.Zone); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &ga.Zone{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		glog.Errorf("Could not convert %T to *ga.Zone via JSON: %v", m.Obj, err)
	}
	return ret
}

// Addresses is an interface that allows for mocking of Addresses.
type Addresses interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Address, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*ga.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Address) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockAddresses returns a new mock for Addresses.
func NewMockAddresses(pr ProjectRouter, objs map[meta.Key]*MockAddressesObj) *MockAddresses {
	mock := &MockAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAddresses is the mock for Addresses.
type MockAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAddresses) (bool, *ga.Address, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockAddresses) (bool, []*ga.Address, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.Address, m *MockAddresses) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAddresses) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAddresses) Get(ctx context.Context, key *meta.Key) (*ga.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAddresses %v not found", key),
	}
	glog.V(5).Infof("MockAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAddresses) List(ctx context.Context, region string, fl *filter.F) ([]*ga.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			glog.V(5).Infof("MockAddresses.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockAddresses.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Address
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockAddresses.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAddresses) Insert(ctx context.Context, key *meta.Key, obj *ga.Address) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAddresses %v exists", key),
		}
		glog.V(5).Infof("MockAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "addresses")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "addresses", key)

	m.Objects[*key] = &MockAddressesObj{obj}
	glog.V(5).Infof("MockAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAddresses) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAddresses %v not found", key),
		}
		glog.V(5).Infof("MockAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAddresses) Obj(o *ga.Address) *MockAddressesObj {
	return &MockAddressesObj{o}
}

// GCEAddresses is a simplifying adapter for the GCE Addresses.
type GCEAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEAddresses) Get(ctx context.Context, key *meta.Key) (*ga.Address, error) {
	glog.V(5).Infof("GCEAddresses.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}
	glog.V(5).Infof("GCEAddresses.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Addresses.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Address objects.
func (g *GCEAddresses) List(ctx context.Context, region string, fl *filter.F) ([]*ga.Address, error) {
	glog.V(5).Infof("GCEAddresses.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEAddresses.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.GA.Addresses.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Address
	f := func(l *ga.AddressList) error {
		glog.V(5).Infof("GCEAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEAddresses) Insert(ctx context.Context, key *meta.Key, obj *ga.Address) error {
	glog.V(5).Infof("GCEAddresses.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}
	glog.V(5).Infof("GCEAddresses.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Addresses.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEAddresses) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEAddresses.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}
	glog.V(5).Infof("GCEAddresses.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Addresses.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AlphaAddresses is an interface that allows for mocking of Addresses.
type AlphaAddresses interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.Address, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.Address) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockAlphaAddresses returns a new mock for Addresses.
func NewMockAlphaAddresses(pr ProjectRouter, objs map[meta.Key]*MockAddressesObj) *MockAlphaAddresses {
	mock := &MockAlphaAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaAddresses is the mock for Addresses.
type MockAlphaAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaAddresses) (bool, *alpha.Address, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockAlphaAddresses) (bool, []*alpha.Address, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.Address, m *MockAlphaAddresses) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaAddresses) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaAddresses) Get(ctx context.Context, key *meta.Key) (*alpha.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockAlphaAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		glog.V(5).Infof("MockAlphaAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaAddresses %v not found", key),
	}
	glog.V(5).Infof("MockAlphaAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaAddresses) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			glog.V(5).Infof("MockAlphaAddresses.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockAlphaAddresses.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.Address
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	glog.V(5).Infof("MockAlphaAddresses.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaAddresses) Insert(ctx context.Context, key *meta.Key, obj *alpha.Address) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockAlphaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockAlphaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaAddresses %v exists", key),
		}
		glog.V(5).Infof("MockAlphaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "addresses")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "addresses", key)

	m.Objects[*key] = &MockAddressesObj{obj}
	glog.V(5).Infof("MockAlphaAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaAddresses) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaAddresses %v not found", key),
		}
		glog.V(5).Infof("MockAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockAlphaAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaAddresses) Obj(o *alpha.Address) *MockAddressesObj {
	return &MockAddressesObj{o}
}

// GCEAlphaAddresses is a simplifying adapter for the GCE Addresses.
type GCEAlphaAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEAlphaAddresses) Get(ctx context.Context, key *meta.Key) (*alpha.Address, error) {
	glog.V(5).Infof("GCEAlphaAddresses.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}
	glog.V(5).Infof("GCEAlphaAddresses.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Addresses.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEAlphaAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Address objects.
func (g *GCEAlphaAddresses) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Address, error) {
	glog.V(5).Infof("GCEAlphaAddresses.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEAlphaAddresses.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.Addresses.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.Address
	f := func(l *alpha.AddressList) error {
		glog.V(5).Infof("GCEAlphaAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEAlphaAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEAlphaAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEAlphaAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEAlphaAddresses) Insert(ctx context.Context, key *meta.Key, obj *alpha.Address) error {
	glog.V(5).Infof("GCEAlphaAddresses.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}
	glog.V(5).Infof("GCEAlphaAddresses.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Addresses.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEAlphaAddresses) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEAlphaAddresses.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}
	glog.V(5).Infof("GCEAlphaAddresses.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Addresses.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// BetaAddresses is an interface that allows for mocking of Addresses.
type BetaAddresses interface {
	Get(ctx context.Context, key *meta.Key) (*beta.Address, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*beta.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.Address) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockBetaAddresses returns a new mock for Addresses.
func NewMockBetaAddresses(pr ProjectRouter, objs map[meta.Key]*MockAddressesObj) *MockBetaAddresses {
	mock := &MockBetaAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaAddresses is the mock for Addresses.
type MockBetaAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaAddresses) (bool, *beta.Address, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockBetaAddresses) (bool, []*beta.Address, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *beta.Address, m *MockBetaAddresses) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaAddresses) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaAddresses) Get(ctx context.Context, key *meta.Key) (*beta.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockBetaAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockBetaAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		glog.V(5).Infof("MockBetaAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaAddresses %v not found", key),
	}
	glog.V(5).Infof("MockBetaAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaAddresses) List(ctx context.Context, region string, fl *filter.F) ([]*beta.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			glog.V(5).Infof("MockBetaAddresses.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockBetaAddresses.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.Address
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	glog.V(5).Infof("MockBetaAddresses.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaAddresses) Insert(ctx context.Context, key *meta.Key, obj *beta.Address) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockBetaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockBetaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaAddresses %v exists", key),
		}
		glog.V(5).Infof("MockBetaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "addresses")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "addresses", key)

	m.Objects[*key] = &MockAddressesObj{obj}
	glog.V(5).Infof("MockBetaAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaAddresses) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaAddresses %v not found", key),
		}
		glog.V(5).Infof("MockBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockBetaAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaAddresses) Obj(o *beta.Address) *MockAddressesObj {
	return &MockAddressesObj{o}
}

// GCEBetaAddresses is a simplifying adapter for the GCE Addresses.
type GCEBetaAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEBetaAddresses) Get(ctx context.Context, key *meta.Key) (*beta.Address, error) {
	glog.V(5).Infof("GCEBetaAddresses.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEBetaAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}
	glog.V(5).Infof("GCEBetaAddresses.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBetaAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Addresses.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEBetaAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Address objects.
func (g *GCEBetaAddresses) List(ctx context.Context, region string, fl *filter.F) ([]*beta.Address, error) {
	glog.V(5).Infof("GCEBetaAddresses.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEBetaAddresses.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Beta.Addresses.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.Address
	f := func(l *beta.AddressList) error {
		glog.V(5).Infof("GCEBetaAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEBetaAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEBetaAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEBetaAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEBetaAddresses) Insert(ctx context.Context, key *meta.Key, obj *beta.Address) error {
	glog.V(5).Infof("GCEBetaAddresses.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEBetaAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}
	glog.V(5).Infof("GCEBetaAddresses.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBetaAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Addresses.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEBetaAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEBetaAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEBetaAddresses) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEBetaAddresses.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEBetaAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Addresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}
	glog.V(5).Infof("GCEBetaAddresses.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBetaAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Addresses.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GlobalAddresses is an interface that allows for mocking of GlobalAddresses.
type GlobalAddresses interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Address, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Address) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockGlobalAddresses returns a new mock for GlobalAddresses.
func NewMockGlobalAddresses(pr ProjectRouter, objs map[meta.Key]*MockGlobalAddressesObj) *MockGlobalAddresses {
	mock := &MockGlobalAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockGlobalAddresses is the mock for GlobalAddresses.
type MockGlobalAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockGlobalAddresses) (bool, *ga.Address, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockGlobalAddresses) (bool, []*ga.Address, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.Address, m *MockGlobalAddresses) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockGlobalAddresses) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockGlobalAddresses) Get(ctx context.Context, key *meta.Key) (*ga.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockGlobalAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockGlobalAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockGlobalAddresses %v not found", key),
	}
	glog.V(5).Infof("MockGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockGlobalAddresses) List(ctx context.Context, fl *filter.F) ([]*ga.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockGlobalAddresses.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockGlobalAddresses.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Address
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockGlobalAddresses.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *ga.Address) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockGlobalAddresses %v exists", key),
		}
		glog.V(5).Infof("MockGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "addresses")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "addresses", key)

	m.Objects[*key] = &MockGlobalAddressesObj{obj}
	glog.V(5).Infof("MockGlobalAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockGlobalAddresses) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockGlobalAddresses %v not found", key),
		}
		glog.V(5).Infof("MockGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockGlobalAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockGlobalAddresses) Obj(o *ga.Address) *MockGlobalAddressesObj {
	return &MockGlobalAddressesObj{o}
}

// GCEGlobalAddresses is a simplifying adapter for the GCE GlobalAddresses.
type GCEGlobalAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEGlobalAddresses) Get(ctx context.Context, key *meta.Key) (*ga.Address, error) {
	glog.V(5).Infof("GCEGlobalAddresses.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEGlobalAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "GlobalAddresses",
	}
	glog.V(5).Infof("GCEGlobalAddresses.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEGlobalAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.GlobalAddresses.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEGlobalAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Address objects.
func (g *GCEGlobalAddresses) List(ctx context.Context, fl *filter.F) ([]*ga.Address, error) {
	glog.V(5).Infof("GCEGlobalAddresses.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "GlobalAddresses",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEGlobalAddresses.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.GlobalAddresses.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Address
	f := func(l *ga.AddressList) error {
		glog.V(5).Infof("GCEGlobalAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEGlobalAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *ga.Address) error {
	glog.V(5).Infof("GCEGlobalAddresses.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEGlobalAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "GlobalAddresses",
	}
	glog.V(5).Infof("GCEGlobalAddresses.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEGlobalAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.GlobalAddresses.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEGlobalAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEGlobalAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEGlobalAddresses) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEGlobalAddresses.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEGlobalAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalAddresses")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "GlobalAddresses",
	}
	glog.V(5).Infof("GCEGlobalAddresses.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEGlobalAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.GlobalAddresses.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// BackendServices is an interface that allows for mocking of BackendServices.
type BackendServices interface {
	Get(ctx context.Context, key *meta.Key) (*ga.BackendService, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.BackendService) error
	Delete(ctx context.Context, key *meta.Key) error
	GetHealth(context.Context, *meta.Key, *ga.ResourceGroupReference) (*ga.BackendServiceGroupHealth, error)
	Update(context.Context, *meta.Key, *ga.BackendService) error
}

// NewMockBackendServices returns a new mock for BackendServices.
func NewMockBackendServices(pr ProjectRouter, objs map[meta.Key]*MockBackendServicesObj) *MockBackendServices {
	mock := &MockBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBackendServices is the mock for BackendServices.
type MockBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockBackendServices) (bool, *ga.BackendService, error)
	ListHook      func(ctx context.Context, fl *filter.F, m *MockBackendServices) (bool, []*ga.BackendService, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *ga.BackendService, m *MockBackendServices) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockBackendServices) (bool, error)
	GetHealthHook func(context.Context, *meta.Key, *ga.ResourceGroupReference, *MockBackendServices) (*ga.BackendServiceGroupHealth, error)
	UpdateHook    func(context.Context, *meta.Key, *ga.BackendService, *MockBackendServices) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBackendServices) Get(ctx context.Context, key *meta.Key) (*ga.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBackendServices %v not found", key),
	}
	glog.V(5).Infof("MockBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBackendServices) List(ctx context.Context, fl *filter.F) ([]*ga.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockBackendServices.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockBackendServices.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.BackendService
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockBackendServices.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBackendServices) Insert(ctx context.Context, key *meta.Key, obj *ga.BackendService) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBackendServices %v exists", key),
		}
		glog.V(5).Infof("MockBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "backendServices")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "backendServices", key)

	m.Objects[*key] = &MockBackendServicesObj{obj}
	glog.V(5).Infof("MockBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBackendServices %v not found", key),
		}
		glog.V(5).Infof("MockBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBackendServices) Obj(o *ga.BackendService) *MockBackendServicesObj {
	return &MockBackendServicesObj{o}
}

// GetHealth is a mock for the corresponding method.
func (m *MockBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *ga.ResourceGroupReference) (*ga.BackendServiceGroupHealth, error) {
	if m.GetHealthHook != nil {
		return m.GetHealthHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("GetHealthHook must be set")
}

// Update is a mock for the corresponding method.
func (m *MockBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *ga.BackendService) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBackendServices is a simplifying adapter for the GCE BackendServices.
type GCEBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEBackendServices) Get(ctx context.Context, key *meta.Key) (*ga.BackendService, error) {
	glog.V(5).Infof("GCEBackendServices.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	glog.V(5).Infof("GCEBackendServices.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.BackendServices.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all BackendService objects.
func (g *GCEBackendServices) List(ctx context.Context, fl *filter.F) ([]*ga.BackendService, error) {
	glog.V(5).Infof("GCEBackendServices.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEBackendServices.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.BackendServices.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.BackendService
	f := func(l *ga.BackendServiceList) error {
		glog.V(5).Infof("GCEBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEBackendServices) Insert(ctx context.Context, key *meta.Key, obj *ga.BackendService) error {
	glog.V(5).Infof("GCEBackendServices.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	glog.V(5).Infof("GCEBackendServices.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.BackendServices.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEBackendServices.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	glog.V(5).Infof("GCEBackendServices.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.BackendServices.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GetHealth is a method on GCEBackendServices.
func (g *GCEBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *ga.ResourceGroupReference) (*ga.BackendServiceGroupHealth, error) {
	glog.V(5).Infof("GCEBackendServices.GetHealth(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEBackendServices.GetHealth(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "GetHealth",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	glog.V(5).Infof("GCEBackendServices.GetHealth(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBackendServices.GetHealth(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.BackendServices.GetHealth(projectID, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEBackendServices.GetHealth(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Update is a method on GCEBackendServices.
func (g *GCEBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *ga.BackendService) error {
	glog.V(5).Infof("GCEBackendServices.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEBackendServices.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	glog.V(5).Infof("GCEBackendServices.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.BackendServices.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaBackendServices is an interface that allows for mocking of BackendServices.
type AlphaBackendServices interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.BackendService, error)
	List(ctx context.Context, fl *filter.F) ([]*alpha.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.BackendService) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *alpha.BackendService) error
}

// NewMockAlphaBackendServices returns a new mock for BackendServices.
func NewMockAlphaBackendServices(pr ProjectRouter, objs map[meta.Key]*MockBackendServicesObj) *MockAlphaBackendServices {
	mock := &MockAlphaBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaBackendServices is the mock for BackendServices.
type MockAlphaBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaBackendServices) (bool, *alpha.BackendService, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockAlphaBackendServices) (bool, []*alpha.BackendService, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.BackendService, m *MockAlphaBackendServices) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaBackendServices) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *alpha.BackendService, *MockAlphaBackendServices) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaBackendServices) Get(ctx context.Context, key *meta.Key) (*alpha.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockAlphaBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		glog.V(5).Infof("MockAlphaBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaBackendServices %v not found", key),
	}
	glog.V(5).Infof("MockAlphaBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaBackendServices) List(ctx context.Context, fl *filter.F) ([]*alpha.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockAlphaBackendServices.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockAlphaBackendServices.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.BackendService
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	glog.V(5).Infof("MockAlphaBackendServices.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaBackendServices) Insert(ctx context.Context, key *meta.Key, obj *alpha.BackendService) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockAlphaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockAlphaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaBackendServices %v exists", key),
		}
		glog.V(5).Infof("MockAlphaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "backendServices")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "backendServices", key)

	m.Objects[*key] = &MockBackendServicesObj{obj}
	glog.V(5).Infof("MockAlphaBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaBackendServices %v not found", key),
		}
		glog.V(5).Infof("MockAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockAlphaBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaBackendServices) Obj(o *alpha.BackendService) *MockBackendServicesObj {
	return &MockBackendServicesObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockAlphaBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *alpha.BackendService) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaBackendServices is a simplifying adapter for the GCE BackendServices.
type GCEAlphaBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEAlphaBackendServices) Get(ctx context.Context, key *meta.Key) (*alpha.BackendService, error) {
	glog.V(5).Infof("GCEAlphaBackendServices.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	glog.V(5).Infof("GCEAlphaBackendServices.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.BackendServices.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEAlphaBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all BackendService objects.
func (g *GCEAlphaBackendServices) List(ctx context.Context, fl *filter.F) ([]*alpha.BackendService, error) {
	glog.V(5).Infof("GCEAlphaBackendServices.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEAlphaBackendServices.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Alpha.BackendServices.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.BackendService
	f := func(l *alpha.BackendServiceList) error {
		glog.V(5).Infof("GCEAlphaBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEAlphaBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEAlphaBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEAlphaBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEAlphaBackendServices) Insert(ctx context.Context, key *meta.Key, obj *alpha.BackendService) error {
	glog.V(5).Infof("GCEAlphaBackendServices.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	glog.V(5).Infof("GCEAlphaBackendServices.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.BackendServices.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEAlphaBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEAlphaBackendServices.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	glog.V(5).Infof("GCEAlphaBackendServices.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.BackendServices.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEAlphaBackendServices.
func (g *GCEAlphaBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *alpha.BackendService) error {
	glog.V(5).Infof("GCEAlphaBackendServices.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaBackendServices.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "BackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	glog.V(5).Infof("GCEAlphaBackendServices.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.BackendServices.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RegionBackendServices is an interface that allows for mocking of RegionBackendServices.
type RegionBackendServices interface {
	Get(ctx context.Context, key *meta.Key) (*ga.BackendService, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*ga.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.BackendService) error
	Delete(ctx context.Context, key *meta.Key) error
	GetHealth(context.Context, *meta.Key, *ga.ResourceGroupReference) (*ga.BackendServiceGroupHealth, error)
	Update(context.Context, *meta.Key, *ga.BackendService) error
}

// NewMockRegionBackendServices returns a new mock for RegionBackendServices.
func NewMockRegionBackendServices(pr ProjectRouter, objs map[meta.Key]*MockRegionBackendServicesObj) *MockRegionBackendServices {
	mock := &MockRegionBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockRegionBackendServices is the mock for RegionBackendServices.
type MockRegionBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockRegionBackendServices) (bool, *ga.BackendService, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockRegionBackendServices) (bool, []*ga.BackendService, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *ga.BackendService, m *MockRegionBackendServices) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockRegionBackendServices) (bool, error)
	GetHealthHook func(context.Context, *meta.Key, *ga.ResourceGroupReference, *MockRegionBackendServices) (*ga.BackendServiceGroupHealth, error)
	UpdateHook    func(context.Context, *meta.Key, *ga.BackendService, *MockRegionBackendServices) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRegionBackendServices) Get(ctx context.Context, key *meta.Key) (*ga.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockRegionBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockRegionBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRegionBackendServices %v not found", key),
	}
	glog.V(5).Infof("MockRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockRegionBackendServices) List(ctx context.Context, region string, fl *filter.F) ([]*ga.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			glog.V(5).Infof("MockRegionBackendServices.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockRegionBackendServices.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.BackendService
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockRegionBackendServices.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *ga.BackendService) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockRegionBackendServices %v exists", key),
		}
		glog.V(5).Infof("MockRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "backendServices")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "backendServices", key)

	m.Objects[*key] = &MockRegionBackendServicesObj{obj}
	glog.V(5).Infof("MockRegionBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockRegionBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockRegionBackendServices %v not found", key),
		}
		glog.V(5).Infof("MockRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockRegionBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockRegionBackendServices) Obj(o *ga.BackendService) *MockRegionBackendServicesObj {
	return &MockRegionBackendServicesObj{o}
}

// GetHealth is a mock for the corresponding method.
func (m *MockRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *ga.ResourceGroupReference) (*ga.BackendServiceGroupHealth, error) {
	if m.GetHealthHook != nil {
		return m.GetHealthHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("GetHealthHook must be set")
}

// Update is a mock for the corresponding method.
func (m *MockRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *ga.BackendService) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCERegionBackendServices is a simplifying adapter for the GCE RegionBackendServices.
type GCERegionBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCERegionBackendServices) Get(ctx context.Context, key *meta.Key) (*ga.BackendService, error) {
	glog.V(5).Infof("GCERegionBackendServices.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCERegionBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	glog.V(5).Infof("GCERegionBackendServices.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCERegionBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.RegionBackendServices.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCERegionBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all BackendService objects.
func (g *GCERegionBackendServices) List(ctx context.Context, region string, fl *filter.F) ([]*ga.BackendService, error) {
	glog.V(5).Infof("GCERegionBackendServices.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCERegionBackendServices.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.GA.RegionBackendServices.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.BackendService
	f := func(l *ga.BackendServiceList) error {
		glog.V(5).Infof("GCERegionBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCERegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCERegionBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCERegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCERegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *ga.BackendService) error {
	glog.V(5).Infof("GCERegionBackendServices.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCERegionBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	glog.V(5).Infof("GCERegionBackendServices.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCERegionBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.RegionBackendServices.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCERegionBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCERegionBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCERegionBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCERegionBackendServices.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCERegionBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	glog.V(5).Infof("GCERegionBackendServices.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCERegionBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionBackendServices.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCERegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCERegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GetHealth is a method on GCERegionBackendServices.
func (g *GCERegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *ga.ResourceGroupReference) (*ga.BackendServiceGroupHealth, error) {
	glog.V(5).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "GetHealth",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	glog.V(5).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.RegionBackendServices.GetHealth(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Update is a method on GCERegionBackendServices.
func (g *GCERegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *ga.BackendService) error {
	glog.V(5).Infof("GCERegionBackendServices.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCERegionBackendServices.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	glog.V(5).Infof("GCERegionBackendServices.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCERegionBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionBackendServices.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCERegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCERegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaRegionBackendServices is an interface that allows for mocking of RegionBackendServices.
type AlphaRegionBackendServices interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.BackendService, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.BackendService) error
	Delete(ctx context.Context, key *meta.Key) error
	GetHealth(context.Context, *meta.Key, *alpha.ResourceGroupReference) (*alpha.BackendServiceGroupHealth, error)
	Update(context.Context, *meta.Key, *alpha.BackendService) error
}

// NewMockAlphaRegionBackendServices returns a new mock for RegionBackendServices.
func NewMockAlphaRegionBackendServices(pr ProjectRouter, objs map[meta.Key]*MockRegionBackendServicesObj) *MockAlphaRegionBackendServices {
	mock := &MockAlphaRegionBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaRegionBackendServices is the mock for RegionBackendServices.
type MockAlphaRegionBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockAlphaRegionBackendServices) (bool, *alpha.BackendService, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockAlphaRegionBackendServices) (bool, []*alpha.BackendService, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *alpha.BackendService, m *MockAlphaRegionBackendServices) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockAlphaRegionBackendServices) (bool, error)
	GetHealthHook func(context.Context, *meta.Key, *alpha.ResourceGroupReference, *MockAlphaRegionBackendServices) (*alpha.BackendServiceGroupHealth, error)
	UpdateHook    func(context.Context, *meta.Key, *alpha.BackendService, *MockAlphaRegionBackendServices) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaRegionBackendServices) Get(ctx context.Context, key *meta.Key) (*alpha.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaRegionBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockAlphaRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		glog.V(5).Infof("MockAlphaRegionBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaRegionBackendServices %v not found", key),
	}
	glog.V(5).Infof("MockAlphaRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaRegionBackendServices) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			glog.V(5).Infof("MockAlphaRegionBackendServices.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockAlphaRegionBackendServices.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.BackendService
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	glog.V(5).Infof("MockAlphaRegionBackendServices.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *alpha.BackendService) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockAlphaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockAlphaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaRegionBackendServices %v exists", key),
		}
		glog.V(5).Infof("MockAlphaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "backendServices")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "backendServices", key)

	m.Objects[*key] = &MockRegionBackendServicesObj{obj}
	glog.V(5).Infof("MockAlphaRegionBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaRegionBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaRegionBackendServices %v not found", key),
		}
		glog.V(5).Infof("MockAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockAlphaRegionBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaRegionBackendServices) Obj(o *alpha.BackendService) *MockRegionBackendServicesObj {
	return &MockRegionBackendServicesObj{o}
}

// GetHealth is a mock for the corresponding method.
func (m *MockAlphaRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *alpha.ResourceGroupReference) (*alpha.BackendServiceGroupHealth, error) {
	if m.GetHealthHook != nil {
		return m.GetHealthHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("GetHealthHook must be set")
}

// Update is a mock for the corresponding method.
func (m *MockAlphaRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *alpha.BackendService) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaRegionBackendServices is a simplifying adapter for the GCE RegionBackendServices.
type GCEAlphaRegionBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEAlphaRegionBackendServices) Get(ctx context.Context, key *meta.Key) (*alpha.BackendService, error) {
	glog.V(5).Infof("GCEAlphaRegionBackendServices.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaRegionBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	glog.V(5).Infof("GCEAlphaRegionBackendServices.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaRegionBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionBackendServices.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEAlphaRegionBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all BackendService objects.
func (g *GCEAlphaRegionBackendServices) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.BackendService, error) {
	glog.V(5).Infof("GCEAlphaRegionBackendServices.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEAlphaRegionBackendServices.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.RegionBackendServices.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.BackendService
	f := func(l *alpha.BackendServiceList) error {
		glog.V(5).Infof("GCEAlphaRegionBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEAlphaRegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEAlphaRegionBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEAlphaRegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEAlphaRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *alpha.BackendService) error {
	glog.V(5).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	glog.V(5).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.RegionBackendServices.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEAlphaRegionBackendServices) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	glog.V(5).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionBackendServices.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GetHealth is a method on GCEAlphaRegionBackendServices.
func (g *GCEAlphaRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *alpha.ResourceGroupReference) (*alpha.BackendServiceGroupHealth, error) {
	glog.V(5).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "GetHealth",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	glog.V(5).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionBackendServices.GetHealth(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Update is a method on GCEAlphaRegionBackendServices.
func (g *GCEAlphaRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *alpha.BackendService) error {
	glog.V(5).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionBackendServices")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	glog.V(5).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionBackendServices.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Disks is an interface that allows for mocking of Disks.
type Disks interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Disk, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*ga.Disk, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Disk) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockDisks returns a new mock for Disks.
func NewMockDisks(pr ProjectRouter, objs map[meta.Key]*MockDisksObj) *MockDisks {
	mock := &MockDisks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockDisks is the mock for Disks.
type MockDisks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockDisksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockDisks) (bool, *ga.Disk, error)
	ListHook   func(ctx context.Context, zone string, fl *filter.F, m *MockDisks) (bool, []*ga.Disk, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.Disk, m *MockDisks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockDisks) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockDisks) Get(ctx context.Context, key *meta.Key) (*ga.Disk, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockDisks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockDisks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockDisks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockDisks %v not found", key),
	}
	glog.V(5).Infof("MockDisks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockDisks) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.Disk, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			glog.V(5).Infof("MockDisks.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockDisks.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Disk
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockDisks.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockDisks) Insert(ctx context.Context, key *meta.Key, obj *ga.Disk) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockDisks %v exists", key),
		}
		glog.V(5).Infof("MockDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "disks")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "disks", key)

	m.Objects[*key] = &MockDisksObj{obj}
	glog.V(5).Infof("MockDisks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockDisks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockDisks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockDisks %v not found", key),
		}
		glog.V(5).Infof("MockDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockDisks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockDisks) Obj(o *ga.Disk) *MockDisksObj {
	return &MockDisksObj{o}
}

// GCEDisks is a simplifying adapter for the GCE Disks.
type GCEDisks struct {
	s *Service
}

// Get the Disk named by key.
func (g *GCEDisks) Get(ctx context.Context, key *meta.Key) (*ga.Disk, error) {
	glog.V(5).Infof("GCEDisks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEDisks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}
	glog.V(5).Infof("GCEDisks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEDisks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Disks.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEDisks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Disk objects.
func (g *GCEDisks) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.Disk, error) {
	glog.V(5).Infof("GCEDisks.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEDisks.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.GA.Disks.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Disk
	f := func(l *ga.DiskList) error {
		glog.V(5).Infof("GCEDisks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEDisks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEDisks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEDisks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Disk with key of value obj.
func (g *GCEDisks) Insert(ctx context.Context, key *meta.Key, obj *ga.Disk) error {
	glog.V(5).Infof("GCEDisks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEDisks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}
	glog.V(5).Infof("GCEDisks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEDisks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Disks.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEDisks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEDisks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Disk referenced by key.
func (g *GCEDisks) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEDisks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEDisks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}
	glog.V(5).Infof("GCEDisks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEDisks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Disks.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEDisks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AlphaDisks is an interface that allows for mocking of Disks.
type AlphaDisks interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.Disk, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.Disk, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.Disk) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockAlphaDisks returns a new mock for Disks.
func NewMockAlphaDisks(pr ProjectRouter, objs map[meta.Key]*MockDisksObj) *MockAlphaDisks {
	mock := &MockAlphaDisks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaDisks is the mock for Disks.
type MockAlphaDisks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockDisksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaDisks) (bool, *alpha.Disk, error)
	ListHook   func(ctx context.Context, zone string, fl *filter.F, m *MockAlphaDisks) (bool, []*alpha.Disk, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.Disk, m *MockAlphaDisks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaDisks) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaDisks) Get(ctx context.Context, key *meta.Key) (*alpha.Disk, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaDisks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockAlphaDisks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		glog.V(5).Infof("MockAlphaDisks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaDisks %v not found", key),
	}
	glog.V(5).Infof("MockAlphaDisks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockAlphaDisks) List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.Disk, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			glog.V(5).Infof("MockAlphaDisks.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockAlphaDisks.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.Disk
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	glog.V(5).Infof("MockAlphaDisks.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaDisks) Insert(ctx context.Context, key *meta.Key, obj *alpha.Disk) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockAlphaDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockAlphaDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaDisks %v exists", key),
		}
		glog.V(5).Infof("MockAlphaDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "disks")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "disks", key)

	m.Objects[*key] = &MockDisksObj{obj}
	glog.V(5).Infof("MockAlphaDisks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaDisks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaDisks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockAlphaDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaDisks %v not found", key),
		}
		glog.V(5).Infof("MockAlphaDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockAlphaDisks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaDisks) Obj(o *alpha.Disk) *MockDisksObj {
	return &MockDisksObj{o}
}

// GCEAlphaDisks is a simplifying adapter for the GCE Disks.
type GCEAlphaDisks struct {
	s *Service
}

// Get the Disk named by key.
func (g *GCEAlphaDisks) Get(ctx context.Context, key *meta.Key) (*alpha.Disk, error) {
	glog.V(5).Infof("GCEAlphaDisks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaDisks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Disks",
	}
	glog.V(5).Infof("GCEAlphaDisks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaDisks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Disks.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEAlphaDisks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Disk objects.
func (g *GCEAlphaDisks) List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.Disk, error) {
	glog.V(5).Infof("GCEAlphaDisks.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Disks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEAlphaDisks.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.Alpha.Disks.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.Disk
	f := func(l *alpha.DiskList) error {
		glog.V(5).Infof("GCEAlphaDisks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEAlphaDisks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEAlphaDisks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEAlphaDisks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Disk with key of value obj.
func (g *GCEAlphaDisks) Insert(ctx context.Context, key *meta.Key, obj *alpha.Disk) error {
	glog.V(5).Infof("GCEAlphaDisks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaDisks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Disks",
	}
	glog.V(5).Infof("GCEAlphaDisks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaDisks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Disks.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaDisks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaDisks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Disk referenced by key.
func (g *GCEAlphaDisks) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEAlphaDisks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaDisks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Disks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Disks",
	}
	glog.V(5).Infof("GCEAlphaDisks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaDisks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Disks.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaDisks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AlphaRegionDisks is an interface that allows for mocking of RegionDisks.
type AlphaRegionDisks interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.Disk, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Disk, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.Disk) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockAlphaRegionDisks returns a new mock for RegionDisks.
func NewMockAlphaRegionDisks(pr ProjectRouter, objs map[meta.Key]*MockRegionDisksObj) *MockAlphaRegionDisks {
	mock := &MockAlphaRegionDisks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaRegionDisks is the mock for RegionDisks.
type MockAlphaRegionDisks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionDisksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaRegionDisks) (bool, *alpha.Disk, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockAlphaRegionDisks) (bool, []*alpha.Disk, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.Disk, m *MockAlphaRegionDisks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaRegionDisks) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaRegionDisks) Get(ctx context.Context, key *meta.Key) (*alpha.Disk, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaRegionDisks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockAlphaRegionDisks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		glog.V(5).Infof("MockAlphaRegionDisks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaRegionDisks %v not found", key),
	}
	glog.V(5).Infof("MockAlphaRegionDisks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaRegionDisks) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Disk, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			glog.V(5).Infof("MockAlphaRegionDisks.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockAlphaRegionDisks.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.Disk
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	glog.V(5).Infof("MockAlphaRegionDisks.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaRegionDisks) Insert(ctx context.Context, key *meta.Key, obj *alpha.Disk) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockAlphaRegionDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockAlphaRegionDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaRegionDisks %v exists", key),
		}
		glog.V(5).Infof("MockAlphaRegionDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "disks")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "disks", key)

	m.Objects[*key] = &MockRegionDisksObj{obj}
	glog.V(5).Infof("MockAlphaRegionDisks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaRegionDisks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaRegionDisks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockAlphaRegionDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaRegionDisks %v not found", key),
		}
		glog.V(5).Infof("MockAlphaRegionDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockAlphaRegionDisks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaRegionDisks) Obj(o *alpha.Disk) *MockRegionDisksObj {
	return &MockRegionDisksObj{o}
}

// GCEAlphaRegionDisks is a simplifying adapter for the GCE RegionDisks.
type GCEAlphaRegionDisks struct {
	s *Service
}

// Get the Disk named by key.
func (g *GCEAlphaRegionDisks) Get(ctx context.Context, key *meta.Key) (*alpha.Disk, error) {
	glog.V(5).Infof("GCEAlphaRegionDisks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaRegionDisks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionDisks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "RegionDisks",
	}
	glog.V(5).Infof("GCEAlphaRegionDisks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaRegionDisks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionDisks.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEAlphaRegionDisks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Disk objects.
func (g *GCEAlphaRegionDisks) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.Disk, error) {
	glog.V(5).Infof("GCEAlphaRegionDisks.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionDisks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "RegionDisks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEAlphaRegionDisks.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.RegionDisks.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.Disk
	f := func(l *alpha.DiskList) error {
		glog.V(5).Infof("GCEAlphaRegionDisks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEAlphaRegionDisks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEAlphaRegionDisks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEAlphaRegionDisks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Disk with key of value obj.
func (g *GCEAlphaRegionDisks) Insert(ctx context.Context, key *meta.Key, obj *alpha.Disk) error {
	glog.V(5).Infof("GCEAlphaRegionDisks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaRegionDisks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionDisks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "RegionDisks",
	}
	glog.V(5).Infof("GCEAlphaRegionDisks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaRegionDisks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.RegionDisks.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaRegionDisks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaRegionDisks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Disk referenced by key.
func (g *GCEAlphaRegionDisks) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEAlphaRegionDisks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaRegionDisks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "RegionDisks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "RegionDisks",
	}
	glog.V(5).Infof("GCEAlphaRegionDisks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaRegionDisks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionDisks.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaRegionDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaRegionDisks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Firewalls is an interface that allows for mocking of Firewalls.
type Firewalls interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Firewall, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.Firewall, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Firewall) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *ga.Firewall) error
}

// NewMockFirewalls returns a new mock for Firewalls.
func NewMockFirewalls(pr ProjectRouter, objs map[meta.Key]*MockFirewallsObj) *MockFirewalls {
	mock := &MockFirewalls{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockFirewalls is the mock for Firewalls.
type MockFirewalls struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockFirewallsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockFirewalls) (bool, *ga.Firewall, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockFirewalls) (bool, []*ga.Firewall, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.Firewall, m *MockFirewalls) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockFirewalls) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *ga.Firewall, *MockFirewalls) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockFirewalls) Get(ctx context.Context, key *meta.Key) (*ga.Firewall, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockFirewalls.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockFirewalls.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockFirewalls %v not found", key),
	}
	glog.V(5).Infof("MockFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockFirewalls) List(ctx context.Context, fl *filter.F) ([]*ga.Firewall, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockFirewalls.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockFirewalls.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Firewall
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockFirewalls.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockFirewalls) Insert(ctx context.Context, key *meta.Key, obj *ga.Firewall) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockFirewalls %v exists", key),
		}
		glog.V(5).Infof("MockFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "firewalls")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "firewalls", key)

	m.Objects[*key] = &MockFirewallsObj{obj}
	glog.V(5).Infof("MockFirewalls.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockFirewalls) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockFirewalls.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockFirewalls %v not found", key),
		}
		glog.V(5).Infof("MockFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockFirewalls.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockFirewalls) Obj(o *ga.Firewall) *MockFirewallsObj {
	return &MockFirewallsObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *ga.Firewall) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEFirewalls is a simplifying adapter for the GCE Firewalls.
type GCEFirewalls struct {
	s *Service
}

// Get the Firewall named by key.
func (g *GCEFirewalls) Get(ctx context.Context, key *meta.Key) (*ga.Firewall, error) {
	glog.V(5).Infof("GCEFirewalls.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEFirewalls.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	glog.V(5).Infof("GCEFirewalls.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEFirewalls.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Firewalls.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEFirewalls.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Firewall objects.
func (g *GCEFirewalls) List(ctx context.Context, fl *filter.F) ([]*ga.Firewall, error) {
	glog.V(5).Infof("GCEFirewalls.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEFirewalls.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.Firewalls.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Firewall
	f := func(l *ga.FirewallList) error {
		glog.V(5).Infof("GCEFirewalls.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEFirewalls.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Firewall with key of value obj.
func (g *GCEFirewalls) Insert(ctx context.Context, key *meta.Key, obj *ga.Firewall) error {
	glog.V(5).Infof("GCEFirewalls.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEFirewalls.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	glog.V(5).Infof("GCEFirewalls.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEFirewalls.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Firewalls.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEFirewalls.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEFirewalls.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Firewall referenced by key.
func (g *GCEFirewalls) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEFirewalls.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEFirewalls.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	glog.V(5).Infof("GCEFirewalls.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEFirewalls.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Firewalls.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEFirewalls.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEFirewalls.
func (g *GCEFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *ga.Firewall) error {
	glog.V(5).Infof("GCEFirewalls.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEFirewalls.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Firewalls")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	glog.V(5).Infof("GCEFirewalls.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEFirewalls.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Firewalls.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// ForwardingRules is an interface that allows for mocking of ForwardingRules.
type ForwardingRules interface {
	Get(ctx context.Context, key *meta.Key) (*ga.ForwardingRule, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*ga.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockForwardingRules returns a new mock for ForwardingRules.
func NewMockForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockForwardingRulesObj) *MockForwardingRules {
	mock := &MockForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockForwardingRules is the mock for ForwardingRules.
type MockForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockForwardingRules) (bool, *ga.ForwardingRule, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockForwardingRules) (bool, []*ga.ForwardingRule, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule, m *MockForwardingRules) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockForwardingRules) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockForwardingRules) Get(ctx context.Context, key *meta.Key) (*ga.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockForwardingRules %v not found", key),
	}
	glog.V(5).Infof("MockForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockForwardingRules) List(ctx context.Context, region string, fl *filter.F) ([]*ga.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			glog.V(5).Infof("MockForwardingRules.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockForwardingRules.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.ForwardingRule
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockForwardingRules.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockForwardingRules %v exists", key),
		}
		glog.V(5).Infof("MockForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "forwardingRules")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockForwardingRulesObj{obj}
	glog.V(5).Infof("MockForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockForwardingRules %v not found", key),
		}
		glog.V(5).Infof("MockForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockForwardingRules) Obj(o *ga.ForwardingRule) *MockForwardingRulesObj {
	return &MockForwardingRulesObj{o}
}

// GCEForwardingRules is a simplifying adapter for the GCE ForwardingRules.
type GCEForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEForwardingRules) Get(ctx context.Context, key *meta.Key) (*ga.ForwardingRule, error) {
	glog.V(5).Infof("GCEForwardingRules.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	glog.V(5).Infof("GCEForwardingRules.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.ForwardingRules.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all ForwardingRule objects.
func (g *GCEForwardingRules) List(ctx context.Context, region string, fl *filter.F) ([]*ga.ForwardingRule, error) {
	glog.V(5).Infof("GCEForwardingRules.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEForwardingRules.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.GA.ForwardingRules.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.ForwardingRule
	f := func(l *ga.ForwardingRuleList) error {
		glog.V(5).Infof("GCEForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule) error {
	glog.V(5).Infof("GCEForwardingRules.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	glog.V(5).Infof("GCEForwardingRules.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.ForwardingRules.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEForwardingRules.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	glog.V(5).Infof("GCEForwardingRules.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.ForwardingRules.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AlphaForwardingRules is an interface that allows for mocking of ForwardingRules.
type AlphaForwardingRules interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.ForwardingRule, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*alpha.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.ForwardingRule) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockAlphaForwardingRules returns a new mock for ForwardingRules.
func NewMockAlphaForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockForwardingRulesObj) *MockAlphaForwardingRules {
	mock := &MockAlphaForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaForwardingRules is the mock for ForwardingRules.
type MockAlphaForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaForwardingRules) (bool, *alpha.ForwardingRule, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockAlphaForwardingRules) (bool, []*alpha.ForwardingRule, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.ForwardingRule, m *MockAlphaForwardingRules) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaForwardingRules) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaForwardingRules) Get(ctx context.Context, key *meta.Key) (*alpha.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockAlphaForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		glog.V(5).Infof("MockAlphaForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaForwardingRules %v not found", key),
	}
	glog.V(5).Infof("MockAlphaForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaForwardingRules) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			glog.V(5).Infof("MockAlphaForwardingRules.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockAlphaForwardingRules.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.ForwardingRule
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	glog.V(5).Infof("MockAlphaForwardingRules.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *alpha.ForwardingRule) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockAlphaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockAlphaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaForwardingRules %v exists", key),
		}
		glog.V(5).Infof("MockAlphaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "forwardingRules")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockForwardingRulesObj{obj}
	glog.V(5).Infof("MockAlphaForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaForwardingRules %v not found", key),
		}
		glog.V(5).Infof("MockAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockAlphaForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaForwardingRules) Obj(o *alpha.ForwardingRule) *MockForwardingRulesObj {
	return &MockForwardingRulesObj{o}
}

// GCEAlphaForwardingRules is a simplifying adapter for the GCE ForwardingRules.
type GCEAlphaForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEAlphaForwardingRules) Get(ctx context.Context, key *meta.Key) (*alpha.ForwardingRule, error) {
	glog.V(5).Infof("GCEAlphaForwardingRules.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	glog.V(5).Infof("GCEAlphaForwardingRules.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.ForwardingRules.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEAlphaForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all ForwardingRule objects.
func (g *GCEAlphaForwardingRules) List(ctx context.Context, region string, fl *filter.F) ([]*alpha.ForwardingRule, error) {
	glog.V(5).Infof("GCEAlphaForwardingRules.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEAlphaForwardingRules.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.Alpha.ForwardingRules.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.ForwardingRule
	f := func(l *alpha.ForwardingRuleList) error {
		glog.V(5).Infof("GCEAlphaForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEAlphaForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEAlphaForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEAlphaForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEAlphaForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *alpha.ForwardingRule) error {
	glog.V(5).Infof("GCEAlphaForwardingRules.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	glog.V(5).Infof("GCEAlphaForwardingRules.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.ForwardingRules.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEAlphaForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEAlphaForwardingRules.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "ForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	glog.V(5).Infof("GCEAlphaForwardingRules.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.ForwardingRules.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GlobalForwardingRules is an interface that allows for mocking of GlobalForwardingRules.
type GlobalForwardingRules interface {
	Get(ctx context.Context, key *meta.Key) (*ga.ForwardingRule, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule) error
	Delete(ctx context.Context, key *meta.Key) error
	SetTarget(context.Context, *meta.Key, *ga.TargetReference) error
}

// NewMockGlobalForwardingRules returns a new mock for GlobalForwardingRules.
func NewMockGlobalForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockGlobalForwardingRulesObj) *MockGlobalForwardingRules {
	mock := &MockGlobalForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockGlobalForwardingRules is the mock for GlobalForwardingRules.
type MockGlobalForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockGlobalForwardingRules) (bool, *ga.ForwardingRule, error)
	ListHook      func(ctx context.Context, fl *filter.F, m *MockGlobalForwardingRules) (bool, []*ga.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule, m *MockGlobalForwardingRules) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockGlobalForwardingRules) (bool, error)
	SetTargetHook func(context.Context, *meta.Key, *ga.TargetReference, *MockGlobalForwardingRules) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockGlobalForwardingRules) Get(ctx context.Context, key *meta.Key) (*ga.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockGlobalForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockGlobalForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockGlobalForwardingRules %v not found", key),
	}
	glog.V(5).Infof("MockGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockGlobalForwardingRules) List(ctx context.Context, fl *filter.F) ([]*ga.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockGlobalForwardingRules.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockGlobalForwardingRules.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.ForwardingRule
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockGlobalForwardingRules.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockGlobalForwardingRules %v exists", key),
		}
		glog.V(5).Infof("MockGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "forwardingRules")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockGlobalForwardingRulesObj{obj}
	glog.V(5).Infof("MockGlobalForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockGlobalForwardingRules %v not found", key),
		}
		glog.V(5).Infof("MockGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockGlobalForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockGlobalForwardingRules) Obj(o *ga.ForwardingRule) *MockGlobalForwardingRulesObj {
	return &MockGlobalForwardingRulesObj{o}
}

// SetTarget is a mock for the corresponding method.
func (m *MockGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *ga.TargetReference) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEGlobalForwardingRules is a simplifying adapter for the GCE GlobalForwardingRules.
type GCEGlobalForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEGlobalForwardingRules) Get(ctx context.Context, key *meta.Key) (*ga.ForwardingRule, error) {
	glog.V(5).Infof("GCEGlobalForwardingRules.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEGlobalForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	glog.V(5).Infof("GCEGlobalForwardingRules.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEGlobalForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.GlobalForwardingRules.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEGlobalForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all ForwardingRule objects.
func (g *GCEGlobalForwardingRules) List(ctx context.Context, fl *filter.F) ([]*ga.ForwardingRule, error) {
	glog.V(5).Infof("GCEGlobalForwardingRules.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEGlobalForwardingRules.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.GlobalForwardingRules.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.ForwardingRule
	f := func(l *ga.ForwardingRuleList) error {
		glog.V(5).Infof("GCEGlobalForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEGlobalForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *ga.ForwardingRule) error {
	glog.V(5).Infof("GCEGlobalForwardingRules.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEGlobalForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	glog.V(5).Infof("GCEGlobalForwardingRules.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEGlobalForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.GlobalForwardingRules.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEGlobalForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEGlobalForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEGlobalForwardingRules.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEGlobalForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	glog.V(5).Infof("GCEGlobalForwardingRules.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEGlobalForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.GlobalForwardingRules.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEGlobalForwardingRules.
func (g *GCEGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *ga.TargetReference) error {
	glog.V(5).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "GlobalForwardingRules")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	glog.V(5).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.GlobalForwardingRules.SetTarget(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// HealthChecks is an interface that allows for mocking of HealthChecks.
type HealthChecks interface {
	Get(ctx context.Context, key *meta.Key) (*ga.HealthCheck, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.HealthCheck) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *ga.HealthCheck) error
}

// NewMockHealthChecks returns a new mock for HealthChecks.
func NewMockHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHealthChecksObj) *MockHealthChecks {
	mock := &MockHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockHealthChecks is the mock for HealthChecks.
type MockHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockHealthChecks) (bool, *ga.HealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockHealthChecks) (bool, []*ga.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.HealthCheck, m *MockHealthChecks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockHealthChecks) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *ga.HealthCheck, *MockHealthChecks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockHealthChecks %v not found", key),
	}
	glog.V(5).Infof("MockHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockHealthChecks) List(ctx context.Context, fl *filter.F) ([]*ga.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.HealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HealthCheck) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockHealthChecks %v exists", key),
		}
		glog.V(5).Infof("MockHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "healthChecks")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "healthChecks", key)

	m.Objects[*key] = &MockHealthChecksObj{obj}
	glog.V(5).Infof("MockHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockHealthChecks %v not found", key),
		}
		glog.V(5).Infof("MockHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockHealthChecks) Obj(o *ga.HealthCheck) *MockHealthChecksObj {
	return &MockHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HealthCheck) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEHealthChecks is a simplifying adapter for the GCE HealthChecks.
type GCEHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCEHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HealthCheck, error) {
	glog.V(5).Infof("GCEHealthChecks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	glog.V(5).Infof("GCEHealthChecks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.HealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all HealthCheck objects.
func (g *GCEHealthChecks) List(ctx context.Context, fl *filter.F) ([]*ga.HealthCheck, error) {
	glog.V(5).Infof("GCEHealthChecks.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEHealthChecks.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.HealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.HealthCheck
	f := func(l *ga.HealthCheckList) error {
		glog.V(5).Infof("GCEHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCEHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HealthCheck) error {
	glog.V(5).Infof("GCEHealthChecks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	glog.V(5).Infof("GCEHealthChecks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.HealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCEHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEHealthChecks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	glog.V(5).Infof("GCEHealthChecks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEHealthChecks.
func (g *GCEHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HealthCheck) error {
	glog.V(5).Infof("GCEHealthChecks.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEHealthChecks.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	glog.V(5).Infof("GCEHealthChecks.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaHealthChecks is an interface that allows for mocking of HealthChecks.
type AlphaHealthChecks interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.HealthCheck, error)
	List(ctx context.Context, fl *filter.F) ([]*alpha.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.HealthCheck) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *alpha.HealthCheck) error
}

// NewMockAlphaHealthChecks returns a new mock for HealthChecks.
func NewMockAlphaHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHealthChecksObj) *MockAlphaHealthChecks {
	mock := &MockAlphaHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaHealthChecks is the mock for HealthChecks.
type MockAlphaHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaHealthChecks) (bool, *alpha.HealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockAlphaHealthChecks) (bool, []*alpha.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *alpha.HealthCheck, m *MockAlphaHealthChecks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaHealthChecks) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *alpha.HealthCheck, *MockAlphaHealthChecks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaHealthChecks) Get(ctx context.Context, key *meta.Key) (*alpha.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockAlphaHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		glog.V(5).Infof("MockAlphaHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaHealthChecks %v not found", key),
	}
	glog.V(5).Infof("MockAlphaHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaHealthChecks) List(ctx context.Context, fl *filter.F) ([]*alpha.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockAlphaHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockAlphaHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.HealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	glog.V(5).Infof("MockAlphaHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *alpha.HealthCheck) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockAlphaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockAlphaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaHealthChecks %v exists", key),
		}
		glog.V(5).Infof("MockAlphaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "healthChecks")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "healthChecks", key)

	m.Objects[*key] = &MockHealthChecksObj{obj}
	glog.V(5).Infof("MockAlphaHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaHealthChecks %v not found", key),
		}
		glog.V(5).Infof("MockAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockAlphaHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaHealthChecks) Obj(o *alpha.HealthCheck) *MockHealthChecksObj {
	return &MockHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockAlphaHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *alpha.HealthCheck) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaHealthChecks is a simplifying adapter for the GCE HealthChecks.
type GCEAlphaHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCEAlphaHealthChecks) Get(ctx context.Context, key *meta.Key) (*alpha.HealthCheck, error) {
	glog.V(5).Infof("GCEAlphaHealthChecks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	glog.V(5).Infof("GCEAlphaHealthChecks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.HealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEAlphaHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all HealthCheck objects.
func (g *GCEAlphaHealthChecks) List(ctx context.Context, fl *filter.F) ([]*alpha.HealthCheck, error) {
	glog.V(5).Infof("GCEAlphaHealthChecks.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEAlphaHealthChecks.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.Alpha.HealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.HealthCheck
	f := func(l *alpha.HealthCheckList) error {
		glog.V(5).Infof("GCEAlphaHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEAlphaHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEAlphaHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEAlphaHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCEAlphaHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *alpha.HealthCheck) error {
	glog.V(5).Infof("GCEAlphaHealthChecks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	glog.V(5).Infof("GCEAlphaHealthChecks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.HealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCEAlphaHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEAlphaHealthChecks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	glog.V(5).Infof("GCEAlphaHealthChecks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.HealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEAlphaHealthChecks.
func (g *GCEAlphaHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *alpha.HealthCheck) error {
	glog.V(5).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "HealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	glog.V(5).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.HealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// HttpHealthChecks is an interface that allows for mocking of HttpHealthChecks.
type HttpHealthChecks interface {
	Get(ctx context.Context, key *meta.Key) (*ga.HttpHealthCheck, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.HttpHealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.HttpHealthCheck) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *ga.HttpHealthCheck) error
}

// NewMockHttpHealthChecks returns a new mock for HttpHealthChecks.
func NewMockHttpHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHttpHealthChecksObj) *MockHttpHealthChecks {
	mock := &MockHttpHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockHttpHealthChecks is the mock for HttpHealthChecks.
type MockHttpHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHttpHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockHttpHealthChecks) (bool, *ga.HttpHealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockHttpHealthChecks) (bool, []*ga.HttpHealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.HttpHealthCheck, m *MockHttpHealthChecks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockHttpHealthChecks) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *ga.HttpHealthCheck, *MockHttpHealthChecks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockHttpHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HttpHealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockHttpHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockHttpHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockHttpHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockHttpHealthChecks %v not found", key),
	}
	glog.V(5).Infof("MockHttpHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockHttpHealthChecks) List(ctx context.Context, fl *filter.F) ([]*ga.HttpHealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockHttpHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockHttpHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.HttpHealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockHttpHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockHttpHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HttpHealthCheck) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockHttpHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockHttpHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockHttpHealthChecks %v exists", key),
		}
		glog.V(5).Infof("MockHttpHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "httpHealthChecks")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "httpHealthChecks", key)

	m.Objects[*key] = &MockHttpHealthChecksObj{obj}
	glog.V(5).Infof("MockHttpHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockHttpHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockHttpHealthChecks %v not found", key),
		}
		glog.V(5).Infof("MockHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockHttpHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockHttpHealthChecks) Obj(o *ga.HttpHealthCheck) *MockHttpHealthChecksObj {
	return &MockHttpHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockHttpHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HttpHealthCheck) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEHttpHealthChecks is a simplifying adapter for the GCE HttpHealthChecks.
type GCEHttpHealthChecks struct {
	s *Service
}

// Get the HttpHealthCheck named by key.
func (g *GCEHttpHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HttpHealthCheck, error) {
	glog.V(5).Infof("GCEHttpHealthChecks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEHttpHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	glog.V(5).Infof("GCEHttpHealthChecks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEHttpHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.HttpHealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEHttpHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all HttpHealthCheck objects.
func (g *GCEHttpHealthChecks) List(ctx context.Context, fl *filter.F) ([]*ga.HttpHealthCheck, error) {
	glog.V(5).Infof("GCEHttpHealthChecks.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEHttpHealthChecks.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.HttpHealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.HttpHealthCheck
	f := func(l *ga.HttpHealthCheckList) error {
		glog.V(5).Infof("GCEHttpHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEHttpHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEHttpHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEHttpHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HttpHealthCheck with key of value obj.
func (g *GCEHttpHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HttpHealthCheck) error {
	glog.V(5).Infof("GCEHttpHealthChecks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEHttpHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	glog.V(5).Infof("GCEHttpHealthChecks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEHttpHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.HttpHealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEHttpHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEHttpHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HttpHealthCheck referenced by key.
func (g *GCEHttpHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEHttpHealthChecks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEHttpHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	glog.V(5).Infof("GCEHttpHealthChecks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEHttpHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HttpHealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEHttpHealthChecks.
func (g *GCEHttpHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HttpHealthCheck) error {
	glog.V(5).Infof("GCEHttpHealthChecks.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEHttpHealthChecks.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	glog.V(5).Infof("GCEHttpHealthChecks.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEHttpHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HttpHealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEHttpHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEHttpHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// HttpsHealthChecks is an interface that allows for mocking of HttpsHealthChecks.
type HttpsHealthChecks interface {
	Get(ctx context.Context, key *meta.Key) (*ga.HttpsHealthCheck, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.HttpsHealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.HttpsHealthCheck) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *ga.HttpsHealthCheck) error
}

// NewMockHttpsHealthChecks returns a new mock for HttpsHealthChecks.
func NewMockHttpsHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHttpsHealthChecksObj) *MockHttpsHealthChecks {
	mock := &MockHttpsHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockHttpsHealthChecks is the mock for HttpsHealthChecks.
type MockHttpsHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHttpsHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockHttpsHealthChecks) (bool, *ga.HttpsHealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockHttpsHealthChecks) (bool, []*ga.HttpsHealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.HttpsHealthCheck, m *MockHttpsHealthChecks) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockHttpsHealthChecks) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *ga.HttpsHealthCheck, *MockHttpsHealthChecks) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockHttpsHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HttpsHealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockHttpsHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockHttpsHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockHttpsHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockHttpsHealthChecks %v not found", key),
	}
	glog.V(5).Infof("MockHttpsHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockHttpsHealthChecks) List(ctx context.Context, fl *filter.F) ([]*ga.HttpsHealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockHttpsHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockHttpsHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.HttpsHealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockHttpsHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockHttpsHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HttpsHealthCheck) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockHttpsHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockHttpsHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockHttpsHealthChecks %v exists", key),
		}
		glog.V(5).Infof("MockHttpsHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "httpsHealthChecks")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "httpsHealthChecks", key)

	m.Objects[*key] = &MockHttpsHealthChecksObj{obj}
	glog.V(5).Infof("MockHttpsHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockHttpsHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockHttpsHealthChecks %v not found", key),
		}
		glog.V(5).Infof("MockHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockHttpsHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockHttpsHealthChecks) Obj(o *ga.HttpsHealthCheck) *MockHttpsHealthChecksObj {
	return &MockHttpsHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockHttpsHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HttpsHealthCheck) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEHttpsHealthChecks is a simplifying adapter for the GCE HttpsHealthChecks.
type GCEHttpsHealthChecks struct {
	s *Service
}

// Get the HttpsHealthCheck named by key.
func (g *GCEHttpsHealthChecks) Get(ctx context.Context, key *meta.Key) (*ga.HttpsHealthCheck, error) {
	glog.V(5).Infof("GCEHttpsHealthChecks.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEHttpsHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpsHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	glog.V(5).Infof("GCEHttpsHealthChecks.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEHttpsHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.HttpsHealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEHttpsHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all HttpsHealthCheck objects.
func (g *GCEHttpsHealthChecks) List(ctx context.Context, fl *filter.F) ([]*ga.HttpsHealthCheck, error) {
	glog.V(5).Infof("GCEHttpsHealthChecks.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpsHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEHttpsHealthChecks.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.HttpsHealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.HttpsHealthCheck
	f := func(l *ga.HttpsHealthCheckList) error {
		glog.V(5).Infof("GCEHttpsHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEHttpsHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEHttpsHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEHttpsHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HttpsHealthCheck with key of value obj.
func (g *GCEHttpsHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *ga.HttpsHealthCheck) error {
	glog.V(5).Infof("GCEHttpsHealthChecks.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEHttpsHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpsHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	glog.V(5).Infof("GCEHttpsHealthChecks.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEHttpsHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.HttpsHealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEHttpsHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEHttpsHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HttpsHealthCheck referenced by key.
func (g *GCEHttpsHealthChecks) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEHttpsHealthChecks.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEHttpsHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpsHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	glog.V(5).Infof("GCEHttpsHealthChecks.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEHttpsHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HttpsHealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEHttpsHealthChecks.
func (g *GCEHttpsHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *ga.HttpsHealthCheck) error {
	glog.V(5).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "HttpsHealthChecks")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	glog.V(5).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HttpsHealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// InstanceGroups is an interface that allows for mocking of InstanceGroups.
type InstanceGroups interface {
	Get(ctx context.Context, key *meta.Key) (*ga.InstanceGroup, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*ga.InstanceGroup, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.InstanceGroup) error
	Delete(ctx context.Context, key *meta.Key) error
	AddInstances(context.Context, *meta.Key, *ga.InstanceGroupsAddInstancesRequest) error
	ListInstances(context.Context, *meta.Key, *ga.InstanceGroupsListInstancesRequest, *filter.F) ([]*ga.InstanceWithNamedPorts, error)
	RemoveInstances(context.Context, *meta.Key, *ga.InstanceGroupsRemoveInstancesRequest) error
	SetNamedPorts(context.Context, *meta.Key, *ga.InstanceGroupsSetNamedPortsRequest) error
}

// NewMockInstanceGroups returns a new mock for InstanceGroups.
func NewMockInstanceGroups(pr ProjectRouter, objs map[meta.Key]*MockInstanceGroupsObj) *MockInstanceGroups {
	mock := &MockInstanceGroups{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockInstanceGroups is the mock for InstanceGroups.
type MockInstanceGroups struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstanceGroupsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook             func(ctx context.Context, key *meta.Key, m *MockInstanceGroups) (bool, *ga.InstanceGroup, error)
	ListHook            func(ctx context.Context, zone string, fl *filter.F, m *MockInstanceGroups) (bool, []*ga.InstanceGroup, error)
	InsertHook          func(ctx context.Context, key *meta.Key, obj *ga.InstanceGroup, m *MockInstanceGroups) (bool, error)
	DeleteHook          func(ctx context.Context, key *meta.Key, m *MockInstanceGroups) (bool, error)
	AddInstancesHook    func(context.Context, *meta.Key, *ga.InstanceGroupsAddInstancesRequest, *MockInstanceGroups) error
	ListInstancesHook   func(context.Context, *meta.Key, *ga.InstanceGroupsListInstancesRequest, *filter.F, *MockInstanceGroups) ([]*ga.InstanceWithNamedPorts, error)
	RemoveInstancesHook func(context.Context, *meta.Key, *ga.InstanceGroupsRemoveInstancesRequest, *MockInstanceGroups) error
	SetNamedPortsHook   func(context.Context, *meta.Key, *ga.InstanceGroupsSetNamedPortsRequest, *MockInstanceGroups) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockInstanceGroups) Get(ctx context.Context, key *meta.Key) (*ga.InstanceGroup, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockInstanceGroups.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockInstanceGroups.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockInstanceGroups.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockInstanceGroups %v not found", key),
	}
	glog.V(5).Infof("MockInstanceGroups.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockInstanceGroups) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.InstanceGroup, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			glog.V(5).Infof("MockInstanceGroups.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockInstanceGroups.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.InstanceGroup
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockInstanceGroups.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockInstanceGroups) Insert(ctx context.Context, key *meta.Key, obj *ga.InstanceGroup) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockInstanceGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockInstanceGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockInstanceGroups %v exists", key),
		}
		glog.V(5).Infof("MockInstanceGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "instanceGroups")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "instanceGroups", key)

	m.Objects[*key] = &MockInstanceGroupsObj{obj}
	glog.V(5).Infof("MockInstanceGroups.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockInstanceGroups) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockInstanceGroups %v not found", key),
		}
		glog.V(5).Infof("MockInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockInstanceGroups.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockInstanceGroups) Obj(o *ga.InstanceGroup) *MockInstanceGroupsObj {
	return &MockInstanceGroupsObj{o}
}

// AddInstances is a mock for the corresponding method.
func (m *MockInstanceGroups) AddInstances(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsAddInstancesRequest) error {
	if m.AddInstancesHook != nil {
		return m.AddInstancesHook(ctx, key, arg0, m)
	}
	return nil
}

// ListInstances is a mock for the corresponding method.
func (m *MockInstanceGroups) ListInstances(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsListInstancesRequest, fl *filter.F) ([]*ga.InstanceWithNamedPorts, error) {
	if m.ListInstancesHook != nil {
		return m.ListInstancesHook(ctx, key, arg0, fl, m)
	}
	return nil, nil
}

// RemoveInstances is a mock for the corresponding method.
func (m *MockInstanceGroups) RemoveInstances(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsRemoveInstancesRequest) error {
	if m.RemoveInstancesHook != nil {
		return m.RemoveInstancesHook(ctx, key, arg0, m)
	}
	return nil
}

// SetNamedPorts is a mock for the corresponding method.
func (m *MockInstanceGroups) SetNamedPorts(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsSetNamedPortsRequest) error {
	if m.SetNamedPortsHook != nil {
		return m.SetNamedPortsHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEInstanceGroups is a simplifying adapter for the GCE InstanceGroups.
type GCEInstanceGroups struct {
	s *Service
}

// Get the InstanceGroup named by key.
func (g *GCEInstanceGroups) Get(ctx context.Context, key *meta.Key) (*ga.InstanceGroup, error) {
	glog.V(5).Infof("GCEInstanceGroups.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEInstanceGroups.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	glog.V(5).Infof("GCEInstanceGroups.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEInstanceGroups.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.InstanceGroups.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEInstanceGroups.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all InstanceGroup objects.
func (g *GCEInstanceGroups) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.InstanceGroup, error) {
	glog.V(5).Infof("GCEInstanceGroups.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEInstanceGroups.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.GA.InstanceGroups.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.InstanceGroup
	f := func(l *ga.InstanceGroupList) error {
		glog.V(5).Infof("GCEInstanceGroups.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEInstanceGroups.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEInstanceGroups.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEInstanceGroups.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert InstanceGroup with key of value obj.
func (g *GCEInstanceGroups) Insert(ctx context.Context, key *meta.Key, obj *ga.InstanceGroup) error {
	glog.V(5).Infof("GCEInstanceGroups.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEInstanceGroups.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	glog.V(5).Infof("GCEInstanceGroups.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEInstanceGroups.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.InstanceGroups.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEInstanceGroups.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEInstanceGroups.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the InstanceGroup referenced by key.
func (g *GCEInstanceGroups) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEInstanceGroups.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEInstanceGroups.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	glog.V(5).Infof("GCEInstanceGroups.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEInstanceGroups.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroups.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AddInstances is a method on GCEInstanceGroups.
func (g *GCEInstanceGroups) AddInstances(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsAddInstancesRequest) error {
	glog.V(5).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AddInstances",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	glog.V(5).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroups.AddInstances(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// ListInstances is a method on GCEInstanceGroups.
func (g *GCEInstanceGroups) ListInstances(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsListInstancesRequest, fl *filter.F) ([]*ga.InstanceWithNamedPorts, error) {
	glog.V(5).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "ListInstances",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	glog.V(5).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.InstanceGroups.ListInstances(projectID, key.Zone, key.Name, arg0)
	var all []*ga.InstanceWithNamedPorts
	f := func(l *ga.InstanceGroupsListInstances) error {
		glog.V(5).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): page %+v", ctx, key, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...) = %v, %v", ctx, key, nil, err)
		return nil, err
	}
	if glog.V(4) {
		glog.V(4).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...) = [%v items], %v", ctx, key, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...) = %v, %v", ctx, key, asStr, nil)
	}
	return all, nil
}

// RemoveInstances is a method on GCEInstanceGroups.
func (g *GCEInstanceGroups) RemoveInstances(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsRemoveInstancesRequest) error {
	glog.V(5).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "RemoveInstances",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	glog.V(5).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroups.RemoveInstances(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetNamedPorts is a method on GCEInstanceGroups.
func (g *GCEInstanceGroups) SetNamedPorts(ctx context.Context, key *meta.Key, arg0 *ga.InstanceGroupsSetNamedPortsRequest) error {
	glog.V(5).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "InstanceGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetNamedPorts",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	glog.V(5).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroups.SetNamedPorts(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Instances is an interface that allows for mocking of Instances.
type Instances interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Instance, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*ga.Instance, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Instance) error
	Delete(ctx context.Context, key *meta.Key) error
	AttachDisk(context.Context, *meta.Key, *ga.AttachedDisk) error
	DetachDisk(context.Context, *meta.Key, string) error
}

// NewMockInstances returns a new mock for Instances.
func NewMockInstances(pr ProjectRouter, objs map[meta.Key]*MockInstancesObj) *MockInstances {
	mock := &MockInstances{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockInstances is the mock for Instances.
type MockInstances struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstancesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook        func(ctx context.Context, key *meta.Key, m *MockInstances) (bool, *ga.Instance, error)
	ListHook       func(ctx context.Context, zone string, fl *filter.F, m *MockInstances) (bool, []*ga.Instance, error)
	InsertHook     func(ctx context.Context, key *meta.Key, obj *ga.Instance, m *MockInstances) (bool, error)
	DeleteHook     func(ctx context.Context, key *meta.Key, m *MockInstances) (bool, error)
	AttachDiskHook func(context.Context, *meta.Key, *ga.AttachedDisk, *MockInstances) error
	DetachDiskHook func(context.Context, *meta.Key, string, *MockInstances) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockInstances) Get(ctx context.Context, key *meta.Key) (*ga.Instance, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockInstances.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockInstances.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockInstances.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockInstances %v not found", key),
	}
	glog.V(5).Infof("MockInstances.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockInstances) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.Instance, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			glog.V(5).Infof("MockInstances.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockInstances.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Instance
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockInstances.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockInstances) Insert(ctx context.Context, key *meta.Key, obj *ga.Instance) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockInstances %v exists", key),
		}
		glog.V(5).Infof("MockInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "instances")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "instances", key)

	m.Objects[*key] = &MockInstancesObj{obj}
	glog.V(5).Infof("MockInstances.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockInstances) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockInstances.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockInstances %v not found", key),
		}
		glog.V(5).Infof("MockInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockInstances.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockInstances) Obj(o *ga.Instance) *MockInstancesObj {
	return &MockInstancesObj{o}
}

// AttachDisk is a mock for the corresponding method.
func (m *MockInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *ga.AttachedDisk) error {
	if m.AttachDiskHook != nil {
		return m.AttachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachDisk is a mock for the corresponding method.
func (m *MockInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string) error {
	if m.DetachDiskHook != nil {
		return m.DetachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEInstances is a simplifying adapter for the GCE Instances.
type GCEInstances struct {
	s *Service
}

// Get the Instance named by key.
func (g *GCEInstances) Get(ctx context.Context, key *meta.Key) (*ga.Instance, error) {
	glog.V(5).Infof("GCEInstances.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEInstances.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEInstances.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEInstances.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Instances.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEInstances.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Instance objects.
func (g *GCEInstances) List(ctx context.Context, zone string, fl *filter.F) ([]*ga.Instance, error) {
	glog.V(5).Infof("GCEInstances.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEInstances.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.GA.Instances.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Instance
	f := func(l *ga.InstanceList) error {
		glog.V(5).Infof("GCEInstances.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEInstances.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEInstances.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEInstances.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Instance with key of value obj.
func (g *GCEInstances) Insert(ctx context.Context, key *meta.Key, obj *ga.Instance) error {
	glog.V(5).Infof("GCEInstances.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEInstances.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEInstances.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEInstances.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Instances.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEInstances.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEInstances.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Instance referenced by key.
func (g *GCEInstances) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEInstances.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEInstances.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEInstances.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEInstances.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Instances.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEInstances.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AttachDisk is a method on GCEInstances.
func (g *GCEInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *ga.AttachedDisk) error {
	glog.V(5).Infof("GCEInstances.AttachDisk(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEInstances.AttachDisk(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AttachDisk",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEInstances.AttachDisk(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEInstances.AttachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Instances.AttachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachDisk is a method on GCEInstances.
func (g *GCEInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string) error {
	glog.V(5).Infof("GCEInstances.DetachDisk(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEInstances.DetachDisk(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "DetachDisk",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEInstances.DetachDisk(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEInstances.DetachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Instances.DetachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaInstances is an interface that allows for mocking of Instances.
type BetaInstances interface {
	Get(ctx context.Context, key *meta.Key) (*beta.Instance, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*beta.Instance, error)
	Insert(ctx context.Context, key *meta.Key, obj *beta.Instance) error
	Delete(ctx context.Context, key *meta.Key) error
	AttachDisk(context.Context, *meta.Key, *beta.AttachedDisk) error
	DetachDisk(context.Context, *meta.Key, string) error
	UpdateNetworkInterface(context.Context, *meta.Key, string, *beta.NetworkInterface) error
}

// NewMockBetaInstances returns a new mock for Instances.
func NewMockBetaInstances(pr ProjectRouter, objs map[meta.Key]*MockInstancesObj) *MockBetaInstances {
	mock := &MockBetaInstances{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaInstances is the mock for Instances.
type MockBetaInstances struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstancesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                    func(ctx context.Context, key *meta.Key, m *MockBetaInstances) (bool, *beta.Instance, error)
	ListHook                   func(ctx context.Context, zone string, fl *filter.F, m *MockBetaInstances) (bool, []*beta.Instance, error)
	InsertHook                 func(ctx context.Context, key *meta.Key, obj *beta.Instance, m *MockBetaInstances) (bool, error)
	DeleteHook                 func(ctx context.Context, key *meta.Key, m *MockBetaInstances) (bool, error)
	AttachDiskHook             func(context.Context, *meta.Key, *beta.AttachedDisk, *MockBetaInstances) error
	DetachDiskHook             func(context.Context, *meta.Key, string, *MockBetaInstances) error
	UpdateNetworkInterfaceHook func(context.Context, *meta.Key, string, *beta.NetworkInterface, *MockBetaInstances) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaInstances) Get(ctx context.Context, key *meta.Key) (*beta.Instance, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockBetaInstances.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockBetaInstances.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		glog.V(5).Infof("MockBetaInstances.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaInstances %v not found", key),
	}
	glog.V(5).Infof("MockBetaInstances.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockBetaInstances) List(ctx context.Context, zone string, fl *filter.F) ([]*beta.Instance, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			glog.V(5).Infof("MockBetaInstances.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockBetaInstances.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*beta.Instance
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	glog.V(5).Infof("MockBetaInstances.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaInstances) Insert(ctx context.Context, key *meta.Key, obj *beta.Instance) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockBetaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockBetaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaInstances %v exists", key),
		}
		glog.V(5).Infof("MockBetaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "beta", "instances")
	obj.SelfLink = SelfLink(meta.VersionBeta, projectID, "instances", key)

	m.Objects[*key] = &MockInstancesObj{obj}
	glog.V(5).Infof("MockBetaInstances.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaInstances) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaInstances %v not found", key),
		}
		glog.V(5).Infof("MockBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockBetaInstances.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaInstances) Obj(o *beta.Instance) *MockInstancesObj {
	return &MockInstancesObj{o}
}

// AttachDisk is a mock for the corresponding method.
func (m *MockBetaInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *beta.AttachedDisk) error {
	if m.AttachDiskHook != nil {
		return m.AttachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachDisk is a mock for the corresponding method.
func (m *MockBetaInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string) error {
	if m.DetachDiskHook != nil {
		return m.DetachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// UpdateNetworkInterface is a mock for the corresponding method.
func (m *MockBetaInstances) UpdateNetworkInterface(ctx context.Context, key *meta.Key, arg0 string, arg1 *beta.NetworkInterface) error {
	if m.UpdateNetworkInterfaceHook != nil {
		return m.UpdateNetworkInterfaceHook(ctx, key, arg0, arg1, m)
	}
	return nil
}

// GCEBetaInstances is a simplifying adapter for the GCE Instances.
type GCEBetaInstances struct {
	s *Service
}

// Get the Instance named by key.
func (g *GCEBetaInstances) Get(ctx context.Context, key *meta.Key) (*beta.Instance, error) {
	glog.V(5).Infof("GCEBetaInstances.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEBetaInstances.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEBetaInstances.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBetaInstances.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Instances.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEBetaInstances.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Instance objects.
func (g *GCEBetaInstances) List(ctx context.Context, zone string, fl *filter.F) ([]*beta.Instance, error) {
	glog.V(5).Infof("GCEBetaInstances.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEBetaInstances.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.Beta.Instances.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*beta.Instance
	f := func(l *beta.InstanceList) error {
		glog.V(5).Infof("GCEBetaInstances.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEBetaInstances.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEBetaInstances.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEBetaInstances.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Instance with key of value obj.
func (g *GCEBetaInstances) Insert(ctx context.Context, key *meta.Key, obj *beta.Instance) error {
	glog.V(5).Infof("GCEBetaInstances.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEBetaInstances.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEBetaInstances.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBetaInstances.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Instances.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEBetaInstances.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEBetaInstances.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Instance referenced by key.
func (g *GCEBetaInstances) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEBetaInstances.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEBetaInstances.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEBetaInstances.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBetaInstances.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Instances.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AttachDisk is a method on GCEBetaInstances.
func (g *GCEBetaInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *beta.AttachedDisk) error {
	glog.V(5).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AttachDisk",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Instances.AttachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachDisk is a method on GCEBetaInstances.
func (g *GCEBetaInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string) error {
	glog.V(5).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "DetachDisk",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Instances.DetachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// UpdateNetworkInterface is a method on GCEBetaInstances.
func (g *GCEBetaInstances) UpdateNetworkInterface(ctx context.Context, key *meta.Key, arg0 string, arg1 *beta.NetworkInterface) error {
	glog.V(5).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "beta", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "UpdateNetworkInterface",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Instances.UpdateNetworkInterface(projectID, key.Zone, key.Name, arg0, arg1)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaInstances is an interface that allows for mocking of Instances.
type AlphaInstances interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.Instance, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.Instance, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.Instance) error
	Delete(ctx context.Context, key *meta.Key) error
	AttachDisk(context.Context, *meta.Key, *alpha.AttachedDisk) error
	DetachDisk(context.Context, *meta.Key, string) error
	UpdateNetworkInterface(context.Context, *meta.Key, string, *alpha.NetworkInterface) error
}

// NewMockAlphaInstances returns a new mock for Instances.
func NewMockAlphaInstances(pr ProjectRouter, objs map[meta.Key]*MockInstancesObj) *MockAlphaInstances {
	mock := &MockAlphaInstances{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaInstances is the mock for Instances.
type MockAlphaInstances struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstancesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                    func(ctx context.Context, key *meta.Key, m *MockAlphaInstances) (bool, *alpha.Instance, error)
	ListHook                   func(ctx context.Context, zone string, fl *filter.F, m *MockAlphaInstances) (bool, []*alpha.Instance, error)
	InsertHook                 func(ctx context.Context, key *meta.Key, obj *alpha.Instance, m *MockAlphaInstances) (bool, error)
	DeleteHook                 func(ctx context.Context, key *meta.Key, m *MockAlphaInstances) (bool, error)
	AttachDiskHook             func(context.Context, *meta.Key, *alpha.AttachedDisk, *MockAlphaInstances) error
	DetachDiskHook             func(context.Context, *meta.Key, string, *MockAlphaInstances) error
	UpdateNetworkInterfaceHook func(context.Context, *meta.Key, string, *alpha.NetworkInterface, *MockAlphaInstances) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaInstances) Get(ctx context.Context, key *meta.Key) (*alpha.Instance, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaInstances.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockAlphaInstances.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		glog.V(5).Infof("MockAlphaInstances.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaInstances %v not found", key),
	}
	glog.V(5).Infof("MockAlphaInstances.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockAlphaInstances) List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.Instance, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			glog.V(5).Infof("MockAlphaInstances.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockAlphaInstances.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.Instance
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	glog.V(5).Infof("MockAlphaInstances.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaInstances) Insert(ctx context.Context, key *meta.Key, obj *alpha.Instance) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockAlphaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockAlphaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaInstances %v exists", key),
		}
		glog.V(5).Infof("MockAlphaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "instances")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "instances", key)

	m.Objects[*key] = &MockInstancesObj{obj}
	glog.V(5).Infof("MockAlphaInstances.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaInstances) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaInstances %v not found", key),
		}
		glog.V(5).Infof("MockAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockAlphaInstances.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaInstances) Obj(o *alpha.Instance) *MockInstancesObj {
	return &MockInstancesObj{o}
}

// AttachDisk is a mock for the corresponding method.
func (m *MockAlphaInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *alpha.AttachedDisk) error {
	if m.AttachDiskHook != nil {
		return m.AttachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachDisk is a mock for the corresponding method.
func (m *MockAlphaInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string) error {
	if m.DetachDiskHook != nil {
		return m.DetachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// UpdateNetworkInterface is a mock for the corresponding method.
func (m *MockAlphaInstances) UpdateNetworkInterface(ctx context.Context, key *meta.Key, arg0 string, arg1 *alpha.NetworkInterface) error {
	if m.UpdateNetworkInterfaceHook != nil {
		return m.UpdateNetworkInterfaceHook(ctx, key, arg0, arg1, m)
	}
	return nil
}

// GCEAlphaInstances is a simplifying adapter for the GCE Instances.
type GCEAlphaInstances struct {
	s *Service
}

// Get the Instance named by key.
func (g *GCEAlphaInstances) Get(ctx context.Context, key *meta.Key) (*alpha.Instance, error) {
	glog.V(5).Infof("GCEAlphaInstances.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaInstances.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEAlphaInstances.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaInstances.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Instances.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEAlphaInstances.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Instance objects.
func (g *GCEAlphaInstances) List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.Instance, error) {
	glog.V(5).Infof("GCEAlphaInstances.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEAlphaInstances.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.Alpha.Instances.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.Instance
	f := func(l *alpha.InstanceList) error {
		glog.V(5).Infof("GCEAlphaInstances.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEAlphaInstances.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEAlphaInstances.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEAlphaInstances.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Instance with key of value obj.
func (g *GCEAlphaInstances) Insert(ctx context.Context, key *meta.Key, obj *alpha.Instance) error {
	glog.V(5).Infof("GCEAlphaInstances.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaInstances.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEAlphaInstances.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaInstances.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Instances.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaInstances.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaInstances.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Instance referenced by key.
func (g *GCEAlphaInstances) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEAlphaInstances.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaInstances.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEAlphaInstances.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaInstances.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Instances.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AttachDisk is a method on GCEAlphaInstances.
func (g *GCEAlphaInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *alpha.AttachedDisk) error {
	glog.V(5).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AttachDisk",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Instances.AttachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachDisk is a method on GCEAlphaInstances.
func (g *GCEAlphaInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string) error {
	glog.V(5).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "DetachDisk",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Instances.DetachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// UpdateNetworkInterface is a method on GCEAlphaInstances.
func (g *GCEAlphaInstances) UpdateNetworkInterface(ctx context.Context, key *meta.Key, arg0 string, arg1 *alpha.NetworkInterface) error {
	glog.V(5).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "Instances")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "UpdateNetworkInterface",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	glog.V(5).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Instances.UpdateNetworkInterface(projectID, key.Zone, key.Name, arg0, arg1)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaNetworkEndpointGroups is an interface that allows for mocking of NetworkEndpointGroups.
type AlphaNetworkEndpointGroups interface {
	Get(ctx context.Context, key *meta.Key) (*alpha.NetworkEndpointGroup, error)
	List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.NetworkEndpointGroup, error)
	Insert(ctx context.Context, key *meta.Key, obj *alpha.NetworkEndpointGroup) error
	Delete(ctx context.Context, key *meta.Key) error
	AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.NetworkEndpointGroup, error)
	AttachNetworkEndpoints(context.Context, *meta.Key, *alpha.NetworkEndpointGroupsAttachEndpointsRequest) error
	DetachNetworkEndpoints(context.Context, *meta.Key, *alpha.NetworkEndpointGroupsDetachEndpointsRequest) error
	ListNetworkEndpoints(context.Context, *meta.Key, *alpha.NetworkEndpointGroupsListEndpointsRequest, *filter.F) ([]*alpha.NetworkEndpointWithHealthStatus, error)
}

// NewMockAlphaNetworkEndpointGroups returns a new mock for NetworkEndpointGroups.
func NewMockAlphaNetworkEndpointGroups(pr ProjectRouter, objs map[meta.Key]*MockNetworkEndpointGroupsObj) *MockAlphaNetworkEndpointGroups {
	mock := &MockAlphaNetworkEndpointGroups{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaNetworkEndpointGroups is the mock for NetworkEndpointGroups.
type MockAlphaNetworkEndpointGroups struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworkEndpointGroupsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                    func(ctx context.Context, key *meta.Key, m *MockAlphaNetworkEndpointGroups) (bool, *alpha.NetworkEndpointGroup, error)
	ListHook                   func(ctx context.Context, zone string, fl *filter.F, m *MockAlphaNetworkEndpointGroups) (bool, []*alpha.NetworkEndpointGroup, error)
	InsertHook                 func(ctx context.Context, key *meta.Key, obj *alpha.NetworkEndpointGroup, m *MockAlphaNetworkEndpointGroups) (bool, error)
	DeleteHook                 func(ctx context.Context, key *meta.Key, m *MockAlphaNetworkEndpointGroups) (bool, error)
	AggregatedListHook         func(ctx context.Context, fl *filter.F, m *MockAlphaNetworkEndpointGroups) (bool, map[string][]*alpha.NetworkEndpointGroup, error)
	AttachNetworkEndpointsHook func(context.Context, *meta.Key, *alpha.NetworkEndpointGroupsAttachEndpointsRequest, *MockAlphaNetworkEndpointGroups) error
	DetachNetworkEndpointsHook func(context.Context, *meta.Key, *alpha.NetworkEndpointGroupsDetachEndpointsRequest, *MockAlphaNetworkEndpointGroups) error
	ListNetworkEndpointsHook   func(context.Context, *meta.Key, *alpha.NetworkEndpointGroupsListEndpointsRequest, *filter.F, *MockAlphaNetworkEndpointGroups) ([]*alpha.NetworkEndpointWithHealthStatus, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaNetworkEndpointGroups) Get(ctx context.Context, key *meta.Key) (*alpha.NetworkEndpointGroup, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaNetworkEndpointGroups.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockAlphaNetworkEndpointGroups.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		glog.V(5).Infof("MockAlphaNetworkEndpointGroups.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaNetworkEndpointGroups %v not found", key),
	}
	glog.V(5).Infof("MockAlphaNetworkEndpointGroups.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockAlphaNetworkEndpointGroups) List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.NetworkEndpointGroup, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m); intercept {
			glog.V(5).Infof("MockAlphaNetworkEndpointGroups.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockAlphaNetworkEndpointGroups.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*alpha.NetworkEndpointGroup
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	glog.V(5).Infof("MockAlphaNetworkEndpointGroups.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaNetworkEndpointGroups) Insert(ctx context.Context, key *meta.Key, obj *alpha.NetworkEndpointGroup) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaNetworkEndpointGroups %v exists", key),
		}
		glog.V(5).Infof("MockAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "alpha", "networkEndpointGroups")
	obj.SelfLink = SelfLink(meta.VersionAlpha, projectID, "networkEndpointGroups", key)

	m.Objects[*key] = &MockNetworkEndpointGroupsObj{obj}
	glog.V(5).Infof("MockAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaNetworkEndpointGroups) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaNetworkEndpointGroups %v not found", key),
		}
		glog.V(5).Infof("MockAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockAlphaNetworkEndpointGroups.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockAlphaNetworkEndpointGroups) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.NetworkEndpointGroup, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		glog.V(5).Infof("MockAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*alpha.NetworkEndpointGroup{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToAlpha().SelfLink)
		location := res.Key.Zone
		if err != nil {
			glog.V(5).Infof("MockAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs[location] = append(objs[location], obj.ToAlpha())
	}
	glog.V(5).Infof("MockAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaNetworkEndpointGroups) Obj(o *alpha.NetworkEndpointGroup) *MockNetworkEndpointGroupsObj {
	return &MockNetworkEndpointGroupsObj{o}
}

// AttachNetworkEndpoints is a mock for the corresponding method.
func (m *MockAlphaNetworkEndpointGroups) AttachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *alpha.NetworkEndpointGroupsAttachEndpointsRequest) error {
	if m.AttachNetworkEndpointsHook != nil {
		return m.AttachNetworkEndpointsHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachNetworkEndpoints is a mock for the corresponding method.
func (m *MockAlphaNetworkEndpointGroups) DetachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *alpha.NetworkEndpointGroupsDetachEndpointsRequest) error {
	if m.DetachNetworkEndpointsHook != nil {
		return m.DetachNetworkEndpointsHook(ctx, key, arg0, m)
	}
	return nil
}

// ListNetworkEndpoints is a mock for the corresponding method.
func (m *MockAlphaNetworkEndpointGroups) ListNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *alpha.NetworkEndpointGroupsListEndpointsRequest, fl *filter.F) ([]*alpha.NetworkEndpointWithHealthStatus, error) {
	if m.ListNetworkEndpointsHook != nil {
		return m.ListNetworkEndpointsHook(ctx, key, arg0, fl, m)
	}
	return nil, nil
}

// GCEAlphaNetworkEndpointGroups is a simplifying adapter for the GCE NetworkEndpointGroups.
type GCEAlphaNetworkEndpointGroups struct {
	s *Service
}

// Get the NetworkEndpointGroup named by key.
func (g *GCEAlphaNetworkEndpointGroups) Get(ctx context.Context, key *meta.Key) (*alpha.NetworkEndpointGroup, error) {
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.NetworkEndpointGroups.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all NetworkEndpointGroup objects.
func (g *GCEAlphaNetworkEndpointGroups) List(ctx context.Context, zone string, fl *filter.F) ([]*alpha.NetworkEndpointGroup, error) {
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.List(%v, %v, %v) called", ctx, zone, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, zone, fl, projectID, rk)
	call := g.s.Alpha.NetworkEndpointGroups.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*alpha.NetworkEndpointGroup
	f := func(l *alpha.NetworkEndpointGroupList) error {
		glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert NetworkEndpointGroup with key of value obj.
func (g *GCEAlphaNetworkEndpointGroups) Insert(ctx context.Context, key *meta.Key, obj *alpha.NetworkEndpointGroup) error {
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.NetworkEndpointGroups.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the NetworkEndpointGroup referenced by key.
func (g *GCEAlphaNetworkEndpointGroups) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkEndpointGroups.Delete(projectID, key.Zone, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEAlphaNetworkEndpointGroups) AggregatedList(ctx context.Context, fl *filter.F) (map[string][]*alpha.NetworkEndpointGroup, error) {
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v) called", ctx, fl)

	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}

	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Alpha.NetworkEndpointGroups.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*alpha.NetworkEndpointGroup{}
	f := func(l *alpha.NetworkEndpointGroupAggregatedList) error {
		for k, v := range l.Items {
			glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.NetworkEndpointGroups...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	if glog.V(4) {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AttachNetworkEndpoints is a method on GCEAlphaNetworkEndpointGroups.
func (g *GCEAlphaNetworkEndpointGroups) AttachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *alpha.NetworkEndpointGroupsAttachEndpointsRequest) error {
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AttachNetworkEndpoints",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkEndpointGroups.AttachNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachNetworkEndpoints is a method on GCEAlphaNetworkEndpointGroups.
func (g *GCEAlphaNetworkEndpointGroups) DetachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *alpha.NetworkEndpointGroupsDetachEndpointsRequest) error {
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "DetachNetworkEndpoints",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkEndpointGroups.DetachNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// ListNetworkEndpoints is a method on GCEAlphaNetworkEndpointGroups.
func (g *GCEAlphaNetworkEndpointGroups) ListNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *alpha.NetworkEndpointGroupsListEndpointsRequest, fl *filter.F) ([]*alpha.NetworkEndpointWithHealthStatus, error) {
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "alpha", "NetworkEndpointGroups")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "ListNetworkEndpoints",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.NetworkEndpointGroups.ListNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	var all []*alpha.NetworkEndpointWithHealthStatus
	f := func(l *alpha.NetworkEndpointGroupsListNetworkEndpoints) error {
		glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): page %+v", ctx, key, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = %v, %v", ctx, key, nil, err)
		return nil, err
	}
	if glog.V(4) {
		glog.V(4).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = [%v items], %v", ctx, key, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = %v, %v", ctx, key, asStr, nil)
	}
	return all, nil
}

// Projects is an interface that allows for mocking of Projects.
type Projects interface {
	// ProjectsOps is an interface with additional non-CRUD type methods.
	// This interface is expected to be implemented by hand (non-autogenerated).
	ProjectsOps
}

// NewMockProjects returns a new mock for Projects.
func NewMockProjects(pr ProjectRouter, objs map[meta.Key]*MockProjectsObj) *MockProjects {
	mock := &MockProjects{
		ProjectRouter: pr,

		Objects: objs,
	}
	return mock
}

// MockProjects is the mock for Projects.
type MockProjects struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockProjectsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Obj wraps the object for use in the mock.
func (m *MockProjects) Obj(o *ga.Project) *MockProjectsObj {
	return &MockProjectsObj{o}
}

// GCEProjects is a simplifying adapter for the GCE Projects.
type GCEProjects struct {
	s *Service
}

// Regions is an interface that allows for mocking of Regions.
type Regions interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Region, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.Region, error)
}

// NewMockRegions returns a new mock for Regions.
func NewMockRegions(pr ProjectRouter, objs map[meta.Key]*MockRegionsObj) *MockRegions {
	mock := &MockRegions{
		ProjectRouter: pr,

		Objects:  objs,
		GetError: map[meta.Key]error{},
	}
	return mock
}

// MockRegions is the mock for Regions.
type MockRegions struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError  map[meta.Key]error
	ListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook  func(ctx context.Context, key *meta.Key, m *MockRegions) (bool, *ga.Region, error)
	ListHook func(ctx context.Context, fl *filter.F, m *MockRegions) (bool, []*ga.Region, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRegions) Get(ctx context.Context, key *meta.Key) (*ga.Region, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockRegions.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockRegions.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockRegions.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRegions %v not found", key),
	}
	glog.V(5).Infof("MockRegions.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockRegions) List(ctx context.Context, fl *filter.F) ([]*ga.Region, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockRegions.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockRegions.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Region
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockRegions.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockRegions) Obj(o *ga.Region) *MockRegionsObj {
	return &MockRegionsObj{o}
}

// GCERegions is a simplifying adapter for the GCE Regions.
type GCERegions struct {
	s *Service
}

// Get the Region named by key.
func (g *GCERegions) Get(ctx context.Context, key *meta.Key) (*ga.Region, error) {
	glog.V(5).Infof("GCERegions.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCERegions.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Regions")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Regions",
	}
	glog.V(5).Infof("GCERegions.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCERegions.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Regions.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCERegions.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Region objects.
func (g *GCERegions) List(ctx context.Context, fl *filter.F) ([]*ga.Region, error) {
	glog.V(5).Infof("GCERegions.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Regions")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Regions",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCERegions.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.Regions.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Region
	f := func(l *ga.RegionList) error {
		glog.V(5).Infof("GCERegions.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCERegions.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCERegions.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCERegions.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Routes is an interface that allows for mocking of Routes.
type Routes interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Route, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.Route, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.Route) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockRoutes returns a new mock for Routes.
func NewMockRoutes(pr ProjectRouter, objs map[meta.Key]*MockRoutesObj) *MockRoutes {
	mock := &MockRoutes{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockRoutes is the mock for Routes.
type MockRoutes struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRoutesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockRoutes) (bool, *ga.Route, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockRoutes) (bool, []*ga.Route, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.Route, m *MockRoutes) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockRoutes) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRoutes) Get(ctx context.Context, key *meta.Key) (*ga.Route, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockRoutes.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockRoutes.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockRoutes.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRoutes %v not found", key),
	}
	glog.V(5).Infof("MockRoutes.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockRoutes) List(ctx context.Context, fl *filter.F) ([]*ga.Route, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockRoutes.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockRoutes.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Route
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockRoutes.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockRoutes) Insert(ctx context.Context, key *meta.Key, obj *ga.Route) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockRoutes.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockRoutes.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockRoutes %v exists", key),
		}
		glog.V(5).Infof("MockRoutes.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "routes")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "routes", key)

	m.Objects[*key] = &MockRoutesObj{obj}
	glog.V(5).Infof("MockRoutes.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockRoutes) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockRoutes.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockRoutes.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockRoutes %v not found", key),
		}
		glog.V(5).Infof("MockRoutes.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockRoutes.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockRoutes) Obj(o *ga.Route) *MockRoutesObj {
	return &MockRoutesObj{o}
}

// GCERoutes is a simplifying adapter for the GCE Routes.
type GCERoutes struct {
	s *Service
}

// Get the Route named by key.
func (g *GCERoutes) Get(ctx context.Context, key *meta.Key) (*ga.Route, error) {
	glog.V(5).Infof("GCERoutes.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCERoutes.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routes")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Routes",
	}
	glog.V(5).Infof("GCERoutes.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCERoutes.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Routes.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCERoutes.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Route objects.
func (g *GCERoutes) List(ctx context.Context, fl *filter.F) ([]*ga.Route, error) {
	glog.V(5).Infof("GCERoutes.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routes")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Routes",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCERoutes.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.Routes.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Route
	f := func(l *ga.RouteList) error {
		glog.V(5).Infof("GCERoutes.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCERoutes.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCERoutes.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCERoutes.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Route with key of value obj.
func (g *GCERoutes) Insert(ctx context.Context, key *meta.Key, obj *ga.Route) error {
	glog.V(5).Infof("GCERoutes.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCERoutes.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routes")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Routes",
	}
	glog.V(5).Infof("GCERoutes.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCERoutes.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Routes.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCERoutes.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCERoutes.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Route referenced by key.
func (g *GCERoutes) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCERoutes.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCERoutes.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Routes")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Routes",
	}
	glog.V(5).Infof("GCERoutes.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCERoutes.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Routes.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCERoutes.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCERoutes.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SslCertificates is an interface that allows for mocking of SslCertificates.
type SslCertificates interface {
	Get(ctx context.Context, key *meta.Key) (*ga.SslCertificate, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.SslCertificate, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.SslCertificate) error
	Delete(ctx context.Context, key *meta.Key) error
}

// NewMockSslCertificates returns a new mock for SslCertificates.
func NewMockSslCertificates(pr ProjectRouter, objs map[meta.Key]*MockSslCertificatesObj) *MockSslCertificates {
	mock := &MockSslCertificates{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockSslCertificates is the mock for SslCertificates.
type MockSslCertificates struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockSslCertificatesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockSslCertificates) (bool, *ga.SslCertificate, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockSslCertificates) (bool, []*ga.SslCertificate, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.SslCertificate, m *MockSslCertificates) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockSslCertificates) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockSslCertificates) Get(ctx context.Context, key *meta.Key) (*ga.SslCertificate, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockSslCertificates.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockSslCertificates.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockSslCertificates %v not found", key),
	}
	glog.V(5).Infof("MockSslCertificates.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockSslCertificates) List(ctx context.Context, fl *filter.F) ([]*ga.SslCertificate, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockSslCertificates.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockSslCertificates.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.SslCertificate
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockSslCertificates.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockSslCertificates) Insert(ctx context.Context, key *meta.Key, obj *ga.SslCertificate) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockSslCertificates %v exists", key),
		}
		glog.V(5).Infof("MockSslCertificates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "sslCertificates")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "sslCertificates", key)

	m.Objects[*key] = &MockSslCertificatesObj{obj}
	glog.V(5).Infof("MockSslCertificates.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockSslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockSslCertificates %v not found", key),
		}
		glog.V(5).Infof("MockSslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockSslCertificates.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockSslCertificates) Obj(o *ga.SslCertificate) *MockSslCertificatesObj {
	return &MockSslCertificatesObj{o}
}

// GCESslCertificates is a simplifying adapter for the GCE SslCertificates.
type GCESslCertificates struct {
	s *Service
}

// Get the SslCertificate named by key.
func (g *GCESslCertificates) Get(ctx context.Context, key *meta.Key) (*ga.SslCertificate, error) {
	glog.V(5).Infof("GCESslCertificates.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCESslCertificates.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "SslCertificates",
	}
	glog.V(5).Infof("GCESslCertificates.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCESslCertificates.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.SslCertificates.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCESslCertificates.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all SslCertificate objects.
func (g *GCESslCertificates) List(ctx context.Context, fl *filter.F) ([]*ga.SslCertificate, error) {
	glog.V(5).Infof("GCESslCertificates.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "SslCertificates",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCESslCertificates.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.SslCertificates.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.SslCertificate
	f := func(l *ga.SslCertificateList) error {
		glog.V(5).Infof("GCESslCertificates.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCESslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCESslCertificates.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCESslCertificates.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert SslCertificate with key of value obj.
func (g *GCESslCertificates) Insert(ctx context.Context, key *meta.Key, obj *ga.SslCertificate) error {
	glog.V(5).Infof("GCESslCertificates.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCESslCertificates.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "SslCertificates",
	}
	glog.V(5).Infof("GCESslCertificates.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCESslCertificates.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.SslCertificates.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCESslCertificates.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCESslCertificates.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the SslCertificate referenced by key.
func (g *GCESslCertificates) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCESslCertificates.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCESslCertificates.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "SslCertificates")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "SslCertificates",
	}
	glog.V(5).Infof("GCESslCertificates.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCESslCertificates.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.SslCertificates.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCESslCertificates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCESslCertificates.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// TargetHttpProxies is an interface that allows for mocking of TargetHttpProxies.
type TargetHttpProxies interface {
	Get(ctx context.Context, key *meta.Key) (*ga.TargetHttpProxy, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.TargetHttpProxy, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.TargetHttpProxy) error
	Delete(ctx context.Context, key *meta.Key) error
	SetUrlMap(context.Context, *meta.Key, *ga.UrlMapReference) error
}

// NewMockTargetHttpProxies returns a new mock for TargetHttpProxies.
func NewMockTargetHttpProxies(pr ProjectRouter, objs map[meta.Key]*MockTargetHttpProxiesObj) *MockTargetHttpProxies {
	mock := &MockTargetHttpProxies{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockTargetHttpProxies is the mock for TargetHttpProxies.
type MockTargetHttpProxies struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockTargetHttpProxiesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockTargetHttpProxies) (bool, *ga.TargetHttpProxy, error)
	ListHook      func(ctx context.Context, fl *filter.F, m *MockTargetHttpProxies) (bool, []*ga.TargetHttpProxy, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *ga.TargetHttpProxy, m *MockTargetHttpProxies) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockTargetHttpProxies) (bool, error)
	SetUrlMapHook func(context.Context, *meta.Key, *ga.UrlMapReference, *MockTargetHttpProxies) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockTargetHttpProxies) Get(ctx context.Context, key *meta.Key) (*ga.TargetHttpProxy, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockTargetHttpProxies.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockTargetHttpProxies.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockTargetHttpProxies.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockTargetHttpProxies %v not found", key),
	}
	glog.V(5).Infof("MockTargetHttpProxies.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockTargetHttpProxies) List(ctx context.Context, fl *filter.F) ([]*ga.TargetHttpProxy, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockTargetHttpProxies.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockTargetHttpProxies.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.TargetHttpProxy
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockTargetHttpProxies.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockTargetHttpProxies) Insert(ctx context.Context, key *meta.Key, obj *ga.TargetHttpProxy) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockTargetHttpProxies %v exists", key),
		}
		glog.V(5).Infof("MockTargetHttpProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "targetHttpProxies")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "targetHttpProxies", key)

	m.Objects[*key] = &MockTargetHttpProxiesObj{obj}
	glog.V(5).Infof("MockTargetHttpProxies.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockTargetHttpProxies) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockTargetHttpProxies %v not found", key),
		}
		glog.V(5).Infof("MockTargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockTargetHttpProxies.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockTargetHttpProxies) Obj(o *ga.TargetHttpProxy) *MockTargetHttpProxiesObj {
	return &MockTargetHttpProxiesObj{o}
}

// SetUrlMap is a mock for the corresponding method.
func (m *MockTargetHttpProxies) SetUrlMap(ctx context.Context, key *meta.Key, arg0 *ga.UrlMapReference) error {
	if m.SetUrlMapHook != nil {
		return m.SetUrlMapHook(ctx, key, arg0, m)
	}
	return nil
}

// GCETargetHttpProxies is a simplifying adapter for the GCE TargetHttpProxies.
type GCETargetHttpProxies struct {
	s *Service
}

// Get the TargetHttpProxy named by key.
func (g *GCETargetHttpProxies) Get(ctx context.Context, key *meta.Key) (*ga.TargetHttpProxy, error) {
	glog.V(5).Infof("GCETargetHttpProxies.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCETargetHttpProxies.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpProxies",
	}
	glog.V(5).Infof("GCETargetHttpProxies.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetHttpProxies.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.TargetHttpProxies.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCETargetHttpProxies.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all TargetHttpProxy objects.
func (g *GCETargetHttpProxies) List(ctx context.Context, fl *filter.F) ([]*ga.TargetHttpProxy, error) {
	glog.V(5).Infof("GCETargetHttpProxies.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpProxies",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCETargetHttpProxies.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.TargetHttpProxies.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.TargetHttpProxy
	f := func(l *ga.TargetHttpProxyList) error {
		glog.V(5).Infof("GCETargetHttpProxies.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCETargetHttpProxies.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCETargetHttpProxies.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCETargetHttpProxies.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert TargetHttpProxy with key of value obj.
func (g *GCETargetHttpProxies) Insert(ctx context.Context, key *meta.Key, obj *ga.TargetHttpProxy) error {
	glog.V(5).Infof("GCETargetHttpProxies.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCETargetHttpProxies.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpProxies",
	}
	glog.V(5).Infof("GCETargetHttpProxies.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetHttpProxies.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.TargetHttpProxies.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCETargetHttpProxies.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCETargetHttpProxies.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the TargetHttpProxy referenced by key.
func (g *GCETargetHttpProxies) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCETargetHttpProxies.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCETargetHttpProxies.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpProxies",
	}
	glog.V(5).Infof("GCETargetHttpProxies.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetHttpProxies.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.TargetHttpProxies.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCETargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCETargetHttpProxies.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetUrlMap is a method on GCETargetHttpProxies.
func (g *GCETargetHttpProxies) SetUrlMap(ctx context.Context, key *meta.Key, arg0 *ga.UrlMapReference) error {
	glog.V(5).Infof("GCETargetHttpProxies.SetUrlMap(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCETargetHttpProxies.SetUrlMap(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetUrlMap",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpProxies",
	}
	glog.V(5).Infof("GCETargetHttpProxies.SetUrlMap(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetHttpProxies.SetUrlMap(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.TargetHttpProxies.SetUrlMap(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCETargetHttpProxies.SetUrlMap(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCETargetHttpProxies.SetUrlMap(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// TargetHttpsProxies is an interface that allows for mocking of TargetHttpsProxies.
type TargetHttpsProxies interface {
	Get(ctx context.Context, key *meta.Key) (*ga.TargetHttpsProxy, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.TargetHttpsProxy, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.TargetHttpsProxy) error
	Delete(ctx context.Context, key *meta.Key) error
	SetSslCertificates(context.Context, *meta.Key, *ga.TargetHttpsProxiesSetSslCertificatesRequest) error
	SetUrlMap(context.Context, *meta.Key, *ga.UrlMapReference) error
}

// NewMockTargetHttpsProxies returns a new mock for TargetHttpsProxies.
func NewMockTargetHttpsProxies(pr ProjectRouter, objs map[meta.Key]*MockTargetHttpsProxiesObj) *MockTargetHttpsProxies {
	mock := &MockTargetHttpsProxies{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockTargetHttpsProxies is the mock for TargetHttpsProxies.
type MockTargetHttpsProxies struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockTargetHttpsProxiesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                func(ctx context.Context, key *meta.Key, m *MockTargetHttpsProxies) (bool, *ga.TargetHttpsProxy, error)
	ListHook               func(ctx context.Context, fl *filter.F, m *MockTargetHttpsProxies) (bool, []*ga.TargetHttpsProxy, error)
	InsertHook             func(ctx context.Context, key *meta.Key, obj *ga.TargetHttpsProxy, m *MockTargetHttpsProxies) (bool, error)
	DeleteHook             func(ctx context.Context, key *meta.Key, m *MockTargetHttpsProxies) (bool, error)
	SetSslCertificatesHook func(context.Context, *meta.Key, *ga.TargetHttpsProxiesSetSslCertificatesRequest, *MockTargetHttpsProxies) error
	SetUrlMapHook          func(context.Context, *meta.Key, *ga.UrlMapReference, *MockTargetHttpsProxies) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockTargetHttpsProxies) Get(ctx context.Context, key *meta.Key) (*ga.TargetHttpsProxy, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockTargetHttpsProxies.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockTargetHttpsProxies.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockTargetHttpsProxies.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockTargetHttpsProxies %v not found", key),
	}
	glog.V(5).Infof("MockTargetHttpsProxies.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockTargetHttpsProxies) List(ctx context.Context, fl *filter.F) ([]*ga.TargetHttpsProxy, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockTargetHttpsProxies.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockTargetHttpsProxies.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.TargetHttpsProxy
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockTargetHttpsProxies.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockTargetHttpsProxies) Insert(ctx context.Context, key *meta.Key, obj *ga.TargetHttpsProxy) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockTargetHttpsProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockTargetHttpsProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockTargetHttpsProxies %v exists", key),
		}
		glog.V(5).Infof("MockTargetHttpsProxies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "targetHttpsProxies")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "targetHttpsProxies", key)

	m.Objects[*key] = &MockTargetHttpsProxiesObj{obj}
	glog.V(5).Infof("MockTargetHttpsProxies.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockTargetHttpsProxies) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockTargetHttpsProxies.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockTargetHttpsProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockTargetHttpsProxies %v not found", key),
		}
		glog.V(5).Infof("MockTargetHttpsProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockTargetHttpsProxies.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockTargetHttpsProxies) Obj(o *ga.TargetHttpsProxy) *MockTargetHttpsProxiesObj {
	return &MockTargetHttpsProxiesObj{o}
}

// SetSslCertificates is a mock for the corresponding method.
func (m *MockTargetHttpsProxies) SetSslCertificates(ctx context.Context, key *meta.Key, arg0 *ga.TargetHttpsProxiesSetSslCertificatesRequest) error {
	if m.SetSslCertificatesHook != nil {
		return m.SetSslCertificatesHook(ctx, key, arg0, m)
	}
	return nil
}

// SetUrlMap is a mock for the corresponding method.
func (m *MockTargetHttpsProxies) SetUrlMap(ctx context.Context, key *meta.Key, arg0 *ga.UrlMapReference) error {
	if m.SetUrlMapHook != nil {
		return m.SetUrlMapHook(ctx, key, arg0, m)
	}
	return nil
}

// GCETargetHttpsProxies is a simplifying adapter for the GCE TargetHttpsProxies.
type GCETargetHttpsProxies struct {
	s *Service
}

// Get the TargetHttpsProxy named by key.
func (g *GCETargetHttpsProxies) Get(ctx context.Context, key *meta.Key) (*ga.TargetHttpsProxy, error) {
	glog.V(5).Infof("GCETargetHttpsProxies.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCETargetHttpsProxies.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpsProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpsProxies",
	}
	glog.V(5).Infof("GCETargetHttpsProxies.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetHttpsProxies.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.TargetHttpsProxies.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCETargetHttpsProxies.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all TargetHttpsProxy objects.
func (g *GCETargetHttpsProxies) List(ctx context.Context, fl *filter.F) ([]*ga.TargetHttpsProxy, error) {
	glog.V(5).Infof("GCETargetHttpsProxies.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpsProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpsProxies",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCETargetHttpsProxies.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.TargetHttpsProxies.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.TargetHttpsProxy
	f := func(l *ga.TargetHttpsProxyList) error {
		glog.V(5).Infof("GCETargetHttpsProxies.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCETargetHttpsProxies.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCETargetHttpsProxies.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCETargetHttpsProxies.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert TargetHttpsProxy with key of value obj.
func (g *GCETargetHttpsProxies) Insert(ctx context.Context, key *meta.Key, obj *ga.TargetHttpsProxy) error {
	glog.V(5).Infof("GCETargetHttpsProxies.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCETargetHttpsProxies.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpsProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpsProxies",
	}
	glog.V(5).Infof("GCETargetHttpsProxies.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetHttpsProxies.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.TargetHttpsProxies.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCETargetHttpsProxies.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCETargetHttpsProxies.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the TargetHttpsProxy referenced by key.
func (g *GCETargetHttpsProxies) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCETargetHttpsProxies.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCETargetHttpsProxies.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpsProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpsProxies",
	}
	glog.V(5).Infof("GCETargetHttpsProxies.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetHttpsProxies.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.TargetHttpsProxies.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCETargetHttpsProxies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCETargetHttpsProxies.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetSslCertificates is a method on GCETargetHttpsProxies.
func (g *GCETargetHttpsProxies) SetSslCertificates(ctx context.Context, key *meta.Key, arg0 *ga.TargetHttpsProxiesSetSslCertificatesRequest) error {
	glog.V(5).Infof("GCETargetHttpsProxies.SetSslCertificates(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCETargetHttpsProxies.SetSslCertificates(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpsProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetSslCertificates",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpsProxies",
	}
	glog.V(5).Infof("GCETargetHttpsProxies.SetSslCertificates(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetHttpsProxies.SetSslCertificates(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.TargetHttpsProxies.SetSslCertificates(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCETargetHttpsProxies.SetSslCertificates(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCETargetHttpsProxies.SetSslCertificates(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetUrlMap is a method on GCETargetHttpsProxies.
func (g *GCETargetHttpsProxies) SetUrlMap(ctx context.Context, key *meta.Key, arg0 *ga.UrlMapReference) error {
	glog.V(5).Infof("GCETargetHttpsProxies.SetUrlMap(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCETargetHttpsProxies.SetUrlMap(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetHttpsProxies")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "SetUrlMap",
		Version:   meta.Version("ga"),
		Service:   "TargetHttpsProxies",
	}
	glog.V(5).Infof("GCETargetHttpsProxies.SetUrlMap(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetHttpsProxies.SetUrlMap(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.TargetHttpsProxies.SetUrlMap(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCETargetHttpsProxies.SetUrlMap(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCETargetHttpsProxies.SetUrlMap(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// TargetPools is an interface that allows for mocking of TargetPools.
type TargetPools interface {
	Get(ctx context.Context, key *meta.Key) (*ga.TargetPool, error)
	List(ctx context.Context, region string, fl *filter.F) ([]*ga.TargetPool, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.TargetPool) error
	Delete(ctx context.Context, key *meta.Key) error
	AddInstance(context.Context, *meta.Key, *ga.TargetPoolsAddInstanceRequest) error
	RemoveInstance(context.Context, *meta.Key, *ga.TargetPoolsRemoveInstanceRequest) error
}

// NewMockTargetPools returns a new mock for TargetPools.
func NewMockTargetPools(pr ProjectRouter, objs map[meta.Key]*MockTargetPoolsObj) *MockTargetPools {
	mock := &MockTargetPools{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockTargetPools is the mock for TargetPools.
type MockTargetPools struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockTargetPoolsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook            func(ctx context.Context, key *meta.Key, m *MockTargetPools) (bool, *ga.TargetPool, error)
	ListHook           func(ctx context.Context, region string, fl *filter.F, m *MockTargetPools) (bool, []*ga.TargetPool, error)
	InsertHook         func(ctx context.Context, key *meta.Key, obj *ga.TargetPool, m *MockTargetPools) (bool, error)
	DeleteHook         func(ctx context.Context, key *meta.Key, m *MockTargetPools) (bool, error)
	AddInstanceHook    func(context.Context, *meta.Key, *ga.TargetPoolsAddInstanceRequest, *MockTargetPools) error
	RemoveInstanceHook func(context.Context, *meta.Key, *ga.TargetPoolsRemoveInstanceRequest, *MockTargetPools) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockTargetPools) Get(ctx context.Context, key *meta.Key) (*ga.TargetPool, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockTargetPools.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockTargetPools.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockTargetPools.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockTargetPools %v not found", key),
	}
	glog.V(5).Infof("MockTargetPools.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockTargetPools) List(ctx context.Context, region string, fl *filter.F) ([]*ga.TargetPool, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m); intercept {
			glog.V(5).Infof("MockTargetPools.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockTargetPools.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.TargetPool
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockTargetPools.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockTargetPools) Insert(ctx context.Context, key *meta.Key, obj *ga.TargetPool) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockTargetPools.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockTargetPools.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockTargetPools %v exists", key),
		}
		glog.V(5).Infof("MockTargetPools.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "targetPools")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "targetPools", key)

	m.Objects[*key] = &MockTargetPoolsObj{obj}
	glog.V(5).Infof("MockTargetPools.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockTargetPools) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockTargetPools.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockTargetPools.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockTargetPools %v not found", key),
		}
		glog.V(5).Infof("MockTargetPools.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockTargetPools.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockTargetPools) Obj(o *ga.TargetPool) *MockTargetPoolsObj {
	return &MockTargetPoolsObj{o}
}

// AddInstance is a mock for the corresponding method.
func (m *MockTargetPools) AddInstance(ctx context.Context, key *meta.Key, arg0 *ga.TargetPoolsAddInstanceRequest) error {
	if m.AddInstanceHook != nil {
		return m.AddInstanceHook(ctx, key, arg0, m)
	}
	return nil
}

// RemoveInstance is a mock for the corresponding method.
func (m *MockTargetPools) RemoveInstance(ctx context.Context, key *meta.Key, arg0 *ga.TargetPoolsRemoveInstanceRequest) error {
	if m.RemoveInstanceHook != nil {
		return m.RemoveInstanceHook(ctx, key, arg0, m)
	}
	return nil
}

// GCETargetPools is a simplifying adapter for the GCE TargetPools.
type GCETargetPools struct {
	s *Service
}

// Get the TargetPool named by key.
func (g *GCETargetPools) Get(ctx context.Context, key *meta.Key) (*ga.TargetPool, error) {
	glog.V(5).Infof("GCETargetPools.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCETargetPools.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetPools")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "TargetPools",
	}
	glog.V(5).Infof("GCETargetPools.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetPools.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.TargetPools.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCETargetPools.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all TargetPool objects.
func (g *GCETargetPools) List(ctx context.Context, region string, fl *filter.F) ([]*ga.TargetPool, error) {
	glog.V(5).Infof("GCETargetPools.List(%v, %v, %v) called", ctx, region, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetPools")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "TargetPools",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCETargetPools.List(%v, %v, %v): projectID = %v, rk = %+v", ctx, region, fl, projectID, rk)
	call := g.s.GA.TargetPools.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.TargetPool
	f := func(l *ga.TargetPoolList) error {
		glog.V(5).Infof("GCETargetPools.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCETargetPools.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCETargetPools.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCETargetPools.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert TargetPool with key of value obj.
func (g *GCETargetPools) Insert(ctx context.Context, key *meta.Key, obj *ga.TargetPool) error {
	glog.V(5).Infof("GCETargetPools.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCETargetPools.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetPools")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "TargetPools",
	}
	glog.V(5).Infof("GCETargetPools.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetPools.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.TargetPools.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCETargetPools.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCETargetPools.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the TargetPool referenced by key.
func (g *GCETargetPools) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCETargetPools.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCETargetPools.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetPools")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "TargetPools",
	}
	glog.V(5).Infof("GCETargetPools.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetPools.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.TargetPools.Delete(projectID, key.Region, key.Name)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCETargetPools.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCETargetPools.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AddInstance is a method on GCETargetPools.
func (g *GCETargetPools) AddInstance(ctx context.Context, key *meta.Key, arg0 *ga.TargetPoolsAddInstanceRequest) error {
	glog.V(5).Infof("GCETargetPools.AddInstance(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCETargetPools.AddInstance(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetPools")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "AddInstance",
		Version:   meta.Version("ga"),
		Service:   "TargetPools",
	}
	glog.V(5).Infof("GCETargetPools.AddInstance(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetPools.AddInstance(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.TargetPools.AddInstance(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCETargetPools.AddInstance(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCETargetPools.AddInstance(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RemoveInstance is a method on GCETargetPools.
func (g *GCETargetPools) RemoveInstance(ctx context.Context, key *meta.Key, arg0 *ga.TargetPoolsRemoveInstanceRequest) error {
	glog.V(5).Infof("GCETargetPools.RemoveInstance(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCETargetPools.RemoveInstance(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "TargetPools")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "RemoveInstance",
		Version:   meta.Version("ga"),
		Service:   "TargetPools",
	}
	glog.V(5).Infof("GCETargetPools.RemoveInstance(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCETargetPools.RemoveInstance(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.TargetPools.RemoveInstance(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCETargetPools.RemoveInstance(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCETargetPools.RemoveInstance(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// UrlMaps is an interface that allows for mocking of UrlMaps.
type UrlMaps interface {
	Get(ctx context.Context, key *meta.Key) (*ga.UrlMap, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.UrlMap, error)
	Insert(ctx context.Context, key *meta.Key, obj *ga.UrlMap) error
	Delete(ctx context.Context, key *meta.Key) error
	Update(context.Context, *meta.Key, *ga.UrlMap) error
}

// NewMockUrlMaps returns a new mock for UrlMaps.
func NewMockUrlMaps(pr ProjectRouter, objs map[meta.Key]*MockUrlMapsObj) *MockUrlMaps {
	mock := &MockUrlMaps{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockUrlMaps is the mock for UrlMaps.
type MockUrlMaps struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockUrlMapsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockUrlMaps) (bool, *ga.UrlMap, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockUrlMaps) (bool, []*ga.UrlMap, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *ga.UrlMap, m *MockUrlMaps) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockUrlMaps) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *ga.UrlMap, *MockUrlMaps) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockUrlMaps) Get(ctx context.Context, key *meta.Key) (*ga.UrlMap, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockUrlMaps.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockUrlMaps.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockUrlMaps.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockUrlMaps %v not found", key),
	}
	glog.V(5).Infof("MockUrlMaps.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockUrlMaps) List(ctx context.Context, fl *filter.F) ([]*ga.UrlMap, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockUrlMaps.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockUrlMaps.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.UrlMap
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockUrlMaps.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockUrlMaps) Insert(ctx context.Context, key *meta.Key, obj *ga.UrlMap) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m); intercept {
			glog.V(5).Infof("MockUrlMaps.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		glog.V(5).Infof("MockUrlMaps.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockUrlMaps %v exists", key),
		}
		glog.V(5).Infof("MockUrlMaps.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := m.ProjectRouter.ProjectID(ctx, "ga", "urlMaps")
	obj.SelfLink = SelfLink(meta.VersionGA, projectID, "urlMaps", key)

	m.Objects[*key] = &MockUrlMapsObj{obj}
	glog.V(5).Infof("MockUrlMaps.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockUrlMaps) Delete(ctx context.Context, key *meta.Key) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockUrlMaps.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		glog.V(5).Infof("MockUrlMaps.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockUrlMaps %v not found", key),
		}
		glog.V(5).Infof("MockUrlMaps.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	glog.V(5).Infof("MockUrlMaps.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockUrlMaps) Obj(o *ga.UrlMap) *MockUrlMapsObj {
	return &MockUrlMapsObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockUrlMaps) Update(ctx context.Context, key *meta.Key, arg0 *ga.UrlMap) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEUrlMaps is a simplifying adapter for the GCE UrlMaps.
type GCEUrlMaps struct {
	s *Service
}

// Get the UrlMap named by key.
func (g *GCEUrlMaps) Get(ctx context.Context, key *meta.Key) (*ga.UrlMap, error) {
	glog.V(5).Infof("GCEUrlMaps.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEUrlMaps.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "UrlMaps")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "UrlMaps",
	}
	glog.V(5).Infof("GCEUrlMaps.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEUrlMaps.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.UrlMaps.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEUrlMaps.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all UrlMap objects.
func (g *GCEUrlMaps) List(ctx context.Context, fl *filter.F) ([]*ga.UrlMap, error) {
	glog.V(5).Infof("GCEUrlMaps.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "UrlMaps")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "UrlMaps",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEUrlMaps.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.UrlMaps.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.UrlMap
	f := func(l *ga.UrlMapList) error {
		glog.V(5).Infof("GCEUrlMaps.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEUrlMaps.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEUrlMaps.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEUrlMaps.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert UrlMap with key of value obj.
func (g *GCEUrlMaps) Insert(ctx context.Context, key *meta.Key, obj *ga.UrlMap) error {
	glog.V(5).Infof("GCEUrlMaps.Insert(%v, %v, %+v): called", ctx, key, obj)
	if !key.Valid() {
		glog.V(2).Infof("GCEUrlMaps.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "UrlMaps")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "UrlMaps",
	}
	glog.V(5).Infof("GCEUrlMaps.Insert(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEUrlMaps.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.UrlMaps.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEUrlMaps.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEUrlMaps.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the UrlMap referenced by key.
func (g *GCEUrlMaps) Delete(ctx context.Context, key *meta.Key) error {
	glog.V(5).Infof("GCEUrlMaps.Delete(%v, %v): called", ctx, key)
	if !key.Valid() {
		glog.V(2).Infof("GCEUrlMaps.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "UrlMaps")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "UrlMaps",
	}
	glog.V(5).Infof("GCEUrlMaps.Delete(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEUrlMaps.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.UrlMaps.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEUrlMaps.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEUrlMaps.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEUrlMaps.
func (g *GCEUrlMaps) Update(ctx context.Context, key *meta.Key, arg0 *ga.UrlMap) error {
	glog.V(5).Infof("GCEUrlMaps.Update(%v, %v, ...): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEUrlMaps.Update(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "UrlMaps")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "UrlMaps",
	}
	glog.V(5).Infof("GCEUrlMaps.Update(%v, %v, ...): projectID = %v, rk = %+v", ctx, key, projectID, rk)

	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEUrlMaps.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.UrlMaps.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()
	if err != nil {
		glog.V(4).Infof("GCEUrlMaps.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}
	err = g.s.WaitForCompletion(ctx, op)
	glog.V(4).Infof("GCEUrlMaps.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Zones is an interface that allows for mocking of Zones.
type Zones interface {
	Get(ctx context.Context, key *meta.Key) (*ga.Zone, error)
	List(ctx context.Context, fl *filter.F) ([]*ga.Zone, error)
}

// NewMockZones returns a new mock for Zones.
func NewMockZones(pr ProjectRouter, objs map[meta.Key]*MockZonesObj) *MockZones {
	mock := &MockZones{
		ProjectRouter: pr,

		Objects:  objs,
		GetError: map[meta.Key]error{},
	}
	return mock
}

// MockZones is the mock for Zones.
type MockZones struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockZonesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError  map[meta.Key]error
	ListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook  func(ctx context.Context, key *meta.Key, m *MockZones) (bool, *ga.Zone, error)
	ListHook func(ctx context.Context, fl *filter.F, m *MockZones) (bool, []*ga.Zone, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockZones) Get(ctx context.Context, key *meta.Key) (*ga.Zone, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m); intercept {
			glog.V(5).Infof("MockZones.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		glog.V(5).Infof("MockZones.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		glog.V(5).Infof("MockZones.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockZones %v not found", key),
	}
	glog.V(5).Infof("MockZones.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockZones) List(ctx context.Context, fl *filter.F) ([]*ga.Zone, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m); intercept {
			glog.V(5).Infof("MockZones.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		glog.V(5).Infof("MockZones.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*ga.Zone
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	glog.V(5).Infof("MockZones.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockZones) Obj(o *ga.Zone) *MockZonesObj {
	return &MockZonesObj{o}
}

// GCEZones is a simplifying adapter for the GCE Zones.
type GCEZones struct {
	s *Service
}

// Get the Zone named by key.
func (g *GCEZones) Get(ctx context.Context, key *meta.Key) (*ga.Zone, error) {
	glog.V(5).Infof("GCEZones.Get(%v, %v): called", ctx, key)

	if !key.Valid() {
		glog.V(2).Infof("GCEZones.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Zones")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Zones",
	}
	glog.V(5).Infof("GCEZones.Get(%v, %v): projectID = %v, rk = %+v", ctx, key, projectID, rk)
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		glog.V(4).Infof("GCEZones.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Zones.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	glog.V(4).Infof("GCEZones.Get(%v, %v) = %+v, %v", ctx, key, v, err)
	return v, err
}

// List all Zone objects.
func (g *GCEZones) List(ctx context.Context, fl *filter.F) ([]*ga.Zone, error) {
	glog.V(5).Infof("GCEZones.List(%v, %v) called", ctx, fl)
	projectID := g.s.ProjectRouter.ProjectID(ctx, "ga", "Zones")
	rk := &RateLimitKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Zones",
	}
	if err := g.s.RateLimiter.Accept(ctx, rk); err != nil {
		return nil, err
	}
	glog.V(5).Infof("GCEZones.List(%v, %v): projectID = %v, rk = %+v", ctx, fl, projectID, rk)
	call := g.s.GA.Zones.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}
	var all []*ga.Zone
	f := func(l *ga.ZoneList) error {
		glog.V(5).Infof("GCEZones.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		glog.V(4).Infof("GCEZones.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	if glog.V(4) {
		glog.V(4).Infof("GCEZones.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if glog.V(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		glog.V(5).Infof("GCEZones.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}
