'use strict'

var compareCell = require('compare-cell')
var compareOrientedCell = require('compare-oriented-cell')
var orientation = require('cell-orientation')

module.exports = reduceCellComplex

function reduceCellComplex(cells) {
  cells.sort(compareOrientedCell)
  var n = cells.length
  var ptr = 0
  for(var i=0; i<n; ++i) {
    var c = cells[i]
    var o = orientation(c)
    if(o === 0) {
      continue
    }
    if(ptr > 0) {
      var f = cells[ptr-1]
      if(compareCell(c, f) === 0 &&
         orientation(f)    !== o) {
        ptr -= 1
        continue
      }
    }
    cells[ptr++] = c
  }
  cells.length = ptr
  return cells
}
