'use strict'

require('enable-mobile')
const optics = require('./')

document.body.style.padding = '2rem'

let inputEl = document.body.appendChild(document.createElement('input'))
inputEl.style.display = 'block'
inputEl.style.width = '4rem'
inputEl.style.fontSize = '1.5rem'
inputEl.style.marginBottom = '1rem'
inputEl.maxlength = 1
inputEl.value = '◌'
inputEl.onchange = e => {
	let v = inputEl.value[0]
	inputEl.value = v

	update(v)
}



//create canvases
let w = 300
let h = 300
let fs = 150

let canvasIn = document.body.appendChild(document.createElement('canvas'))
let ctxIn = canvasIn.getContext('2d')
canvasIn.width = w
canvasIn.height = h
canvasIn.style.marginRight = '1rem'

let canvasOut = document.body.appendChild(document.createElement('canvas'))
let ctxOut = canvasOut.getContext('2d')
canvasOut.width = w
canvasOut.height = h

update(inputEl.value)

function update (char) {
	ctxIn.fillStyle = 'black'
	ctxIn.fillRect(0, 0, w, h)

	ctxIn.fillStyle = 'rgba(0, 150, 250, .25)'
	ctxIn.fillRect(w/2, 0, 1, h)
	ctxIn.fillRect(0, h/2, w, 1)

	ctxIn.textBaseline = 'middle'
	ctxIn.textAlign = 'center'
	ctxIn.font = fs + 'px sans-serif'
	ctxIn.fillStyle = 'white'
	ctxIn.fillText(char, w/2, h/2)


	console.time(char + ' time')
	let props = optics(char, {size: w, fontSize: fs})
	console.timeEnd(char + ' time')
	console.log(char + ' properties:', props)

	let {bounds: box, center, radius} = props
	let scale = h*.25/radius
	let diff = [Math.floor(w/2 - center[0]), h/2 - center[1]]

	//center of mass cross
	ctxIn.fillStyle = 'rgba(250, 150, 0, .5)'
	ctxIn.fillRect(center[0], 0, 1, h)
	ctxIn.fillRect(0, center[1], w, 1)

	//bounding box
	ctxIn.strokeStyle = 'rgba(0, 250, 150, .5)'
	ctxIn.strokeRect(box[0], box[1], box[2] - box[0], box[3] - box[1])

	//render output
	ctxOut.fillStyle = 'black'
	ctxOut.fillRect(0, 0, w, h)

	//real center cross
	ctxOut.fillStyle = 'rgba(0, 150, 250, .25)'
	ctxOut.fillRect(w/2, 0, 1, h)
	ctxOut.fillRect(0, h/2, w, 1)

	//font
	ctxOut.fillStyle = 'white'
	ctxOut.textBaseline = 'middle'
	ctxOut.textAlign = 'center'
	ctxOut.font = fs*scale + 'px sans-serif'
	ctxOut.fillText(char, w/2 + diff[0]*scale, h/2 + diff[1]*scale)
}



//draw set of letters
(function () {
	let canvas = document.body.appendChild(document.createElement('canvas'))
	canvas.width = 720
	canvas.height = 200
	canvas.style.marginTop = '1rem'
	let ctx = canvas.getContext('2d')

	let w = canvas.width, h = canvas.height
	let chars = '●✝+×✕▲▼_▇◌◦□⧖⧓◆✦✶❇'
	let step = 40
	let fs = 20

	// ctx.fillStyle = 'black'
	// ctx.fillRect(0, 0, w, h)

	ctx.textBaseline = 'middle'
	ctx.textAlign = 'center'

	for (let i = 0; i < chars.length; i++) {
		let char = chars[i]

		ctx.fillStyle = 'rgba(0, 150, 250, .25)'
		ctx.fillRect(i*step + step/2, 0, 1, step)
		ctx.fillRect(i*step, step/2, step, 1)

		ctx.font = fs + 'px sans-serif'
		ctx.fillStyle = 'black'
		ctx.fillText(chars[i], i*step + step/2, step/2)

		let {center, bounds, radius} = optics(chars[i], {size: step*10, fontSize: fs*10})
		center[0] /= 10, center[1] /= 10, radius /= 10, bounds[3] /= 10, bounds[1] /= 10
		let scale = step*.25/radius
		let diff = [Math.floor(step/2 - center[0]), step/2 - center[1]]
		let off = (.5*(bounds[3] + bounds[1]) - h*.5)

		ctx.fillStyle = 'rgba(250, 150, 0, .25)'
		ctx.fillRect(i*step + step/2, step, 1, step)
		ctx.fillRect(i*step, step + step/2, step, 1)

		ctx.fillStyle = 'black'
		ctx.font = fs*scale + 'px sans-serif'
		ctx.fillText(chars[i], i*step + step/2 + diff[0]*scale + .5, step + step/2 + diff[1]*scale + .5)
	}
})()
