"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = exports.getMigrationName = void 0;

var _models = require("../models");

var _selectors = require("../utils/selectors");

var _selectors2 = require("./selectors");

var _utils = require("../utils/utils");

class Migration {
  constructor() {
    this.data = {
      apiVersion: (0, _selectors2.getModelApi)(_models.VirtualMachineInstanceMigrationModel),
      kind: _models.VirtualMachineInstanceMigrationModel.kind,
      metadata: {
        name: null,
        namespace: null
      },
      spec: {
        vmiName: null
      }
    };
  }

  setName(name) {
    this.data.metadata.name = name;
  }

  setVmi(vmi) {
    this.data.metadata.namespace = (0, _selectors.getNamespace)(vmi);
    this.data.spec.vmiName = (0, _selectors.getName)(vmi);
  }

  build() {
    return this.data;
  }

}

const getMigrationName = vmi => (0, _utils.prefixedId)((0, _selectors.getName)(vmi), 'migration');

exports.getMigrationName = getMigrationName;

const migrate = (k8sCreate, vmi) => {
  const migration = new Migration();
  migration.setName(getMigrationName(vmi));
  migration.setVmi(vmi);
  return k8sCreate(_models.VirtualMachineInstanceMigrationModel, migration.build());
};

exports.migrate = migrate;