"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudInit = void 0;

var _jsYaml = require("js-yaml");

var _constants = require("../constants");

const resolveScriptHeader = userData => {
  const validScriptHeaders = ['Content-Type', '#include', '#!', '#cloud-config', '#upstart-job', '#part-handler', '#cloud-boothook'];

  if (typeof userData !== 'string' || userData.length === 0 || validScriptHeaders.find(header => userData.startsWith(header))) {
    return userData;
  }

  return `#cloud-config\n${userData}`;
};

class CloudInit {
  constructor(props) {
    this.disk = props && props.disk || {
      name: _constants.CLOUDINIT_DISK
    };
    this.volume = props && props.volume || {
      name: _constants.CLOUDINIT_DISK,
      cloudInitNoCloud: {}
    };
  }

  setUserData(userData) {
    this.volume.cloudInitNoCloud.userData = userData;
  }

  setPredefinedUserData({
    hostname,
    sshAuthorizedKeys
  }) {
    const userDataObject = {};

    if (sshAuthorizedKeys) {
      userDataObject.users = [{
        name: 'default',
        // root account might not be enabled
        'ssh-authorized-keys': sshAuthorizedKeys
      }];
    }

    if (hostname) {
      userDataObject.hostname = hostname;
    }

    this.volume.cloudInitNoCloud.userData = (0, _jsYaml.safeDump)(userDataObject);
  }

  build() {
    const cloudInitNoCloud = this.volume.cloudInitNoCloud;
    cloudInitNoCloud.userData = resolveScriptHeader(cloudInitNoCloud.userData);
    return {
      disk: this.disk,
      volume: this.volume
    };
  }

}

exports.CloudInit = CloudInit;