"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMinus = exports.INPUT_NAVIGATION_KEYS = exports.KEY_CODES = void 0;
const KEY_CODES = {
  BACKSPACE: 8,
  SHIFT: 16,
  LEFT_KEY: 37,
  RIGHT_KEY: 39,
  DELETE_KEY: 46,
  0: 48,
  1: 49,
  9: 57,
  NUMPAD: {
    0: 96,
    1: 97,
    9: 105,
    SUBTRACT: 109
  },
  HYPHEN_MINUS: 173,
  MINUS: 189
};
exports.KEY_CODES = KEY_CODES;
const INPUT_NAVIGATION_KEYS = [KEY_CODES.BACKSPACE, KEY_CODES.SHIFT, KEY_CODES.LEFT_KEY, KEY_CODES.RIGHT_KEY, KEY_CODES.DELETE_KEY];
exports.INPUT_NAVIGATION_KEYS = INPUT_NAVIGATION_KEYS;

const isMinus = keyCode => {
  switch (keyCode) {
    case KEY_CODES.HYPHEN_MINUS:
    case KEY_CODES.MINUS:
    case KEY_CODES.NUMPAD.SUBTRACT:
      return true;

    default:
      return false;
  }
};

exports.isMinus = isMinus;