"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.importProviders = void 0;

var _lodash = require("lodash");

var _constants = require("../constants");

var _selectors = require("../../../../k8s/selectors");

var _constants2 = require("../../../../constants");

var _vmware = require("./vmware");

var _v2vvmwareController = require("./v2vvmwareController");

var _strings = require("../strings");

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const providerList = [_constants.PROVIDER_VMWARE];

const getProviderHelp = basicSettings => {
  const provider = (0, _selectors.settingsValue)(basicSettings, _constants.PROVIDER_KEY);

  switch (provider) {
    case _constants.PROVIDER_VMWARE:
      return _strings.HELP_PROVIDER_VMWARE;

    default:
      return null;
  }
};

const importProviders = (basicSettings, WithResources, k8sCreate, k8sGet, k8sPatch) => _objectSpread({
  [_constants.PROVIDER_KEY]: {
    id: 'provider-dropdown',
    title: 'Provider',
    type: 'dropdown',
    defaultValue: '--- Select Provider ---',
    choices: providerList,
    required: true,
    onChange: (...opts) => onProviderChanged(k8sCreate, k8sGet, ...opts),
    isVisible: basicVmSettings => (0, _selectors.isImageSourceType)(basicVmSettings, _constants2.PROVISION_SOURCE_IMPORT),
    help: getProviderHelp(basicSettings)
  }
}, (0, _vmware.getVMWareSection)(basicSettings, WithResources, k8sCreate, k8sGet, k8sPatch));

exports.importProviders = importProviders;

const onProviderChanged = (k8sCreate, k8sGet, valueValidationPair, key, formValid, prevBasicSettings) => {
  (0, _v2vvmwareController.startV2VVMWareController)({
    k8sCreate,
    k8sGet,
    namespace: (0, _lodash.get)(prevBasicSettings[_constants.NAMESPACE_KEY], 'value')
  });
};