"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _lodash = require("lodash");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _patternflyReact = require("patternfly-react");

var _constants = require("../constants");

var _utils = require("../../../../utils");

var _models = require("../../../../models");

var _selectors = require("../../../../k8s/selectors");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Following constants conform v2vvmware_controller.go
const PhaseConnecting = 'Connecting';
const PhaseConnectionSuccessful = 'ConnectionVerified';
const PhaseConnectionFailed = 'Failed';
const PhaseLoadingVmsList = 'LoadingVmsList';
const PhaseLoadingVmsListFailed = 'LoadingVmsList';
const PhaseLoadingVmDetail = 'LoadingVmDetail';
const PhaseLoadingVmDetailFailed = 'LoadingVmDetailFailed';

const StatusField = ({
  children
}) => _react.default.createElement("div", {
  className: "kubevirt-create-vm-wizard__import-vmware-connection-status"
}, children);

StatusField.propTypes = {
  children: _propTypes.default.node.isRequired
};

const CheckingCredentials = () => _react.default.createElement(StatusField, null, "Checking vCenter Credentials...", _react.default.createElement(_patternflyReact.Spinner, {
  loading: true,
  size: "sm"
}));

const LoadingData = () => _react.default.createElement(StatusField, null, "Connection successful. Loading data...", _react.default.createElement(_patternflyReact.Spinner, {
  loading: true,
  size: "sm"
}));

const ConnectionFailed = () => _react.default.createElement(StatusField, null, _react.default.createElement(_patternflyReact.Alert, {
  type: "warning"
}, "Could not connect to vCenter using the provided credentials."));

const ConnectionFailedInfra = () => _react.default.createElement(StatusField, null, _react.default.createElement(_patternflyReact.Alert, {
  type: "warning"
}, "Can not verify vCenter credentials, connection to the V2V VMWare failed."));

const ConnectionSuccessful = () => _react.default.createElement(StatusField, null, "Connection successful");

const ReadVmsListFailed = () => _react.default.createElement(StatusField, null, _react.default.createElement(_patternflyReact.Alert, {
  type: "warning"
}, "Connection succeeded but could not read list of virtual machines from the vCenter instance."));

const ReadVmDetailFailed = () => _react.default.createElement(StatusField, null, _react.default.createElement(_patternflyReact.Alert, {
  type: "warning"
}, "Connection succeeded but could not read details of the virtual machine from the vCenter instance.")); // Determine status of the "check-connection" user action from the 'status.phase' of the V2V VMWare object


const VMWareProviderStatusByPhase = ({
  phase
}) => {
  if (!phase || phase === PhaseConnecting) {
    return _react.default.createElement(CheckingCredentials, null);
  }

  if (phase === PhaseConnectionSuccessful) {
    return _react.default.createElement(ConnectionSuccessful, null);
  }

  if ([PhaseLoadingVmsList, PhaseLoadingVmDetail].includes(phase)) {
    return _react.default.createElement(LoadingData, null);
  }

  if (phase === PhaseConnectionFailed) {
    return _react.default.createElement(ConnectionFailed, null);
  }

  if (phase === PhaseLoadingVmsListFailed) {
    return _react.default.createElement(ReadVmsListFailed, null);
  }

  if (phase === PhaseLoadingVmDetailFailed) {
    return _react.default.createElement(ReadVmDetailFailed, null);
  } // eslint-disable-next-line no-console


  console.warn('VMWareProviderStatusByPhase unrecognized phase found within the V2V VMWare object: ', phase);
  return null;
};

VMWareProviderStatusByPhase.defaultProps = {
  phase: undefined
};
VMWareProviderStatusByPhase.propTypes = {
  phase: _propTypes.default.string
}; // see onVmwareCheckConnection() for details

const VMWareProviderStatus = ({
  connValue,
  extraProps
}) => {
  if (!connValue) {
    return null;
  }

  const providerStatus = connValue.providerStatus,
        V2VVmwareName = connValue.V2VVmwareName;

  if (!V2VVmwareName) {
    return null;
  }

  const WithResources = extraProps.WithResources,
        basicSettings = extraProps.basicSettings;

  if (providerStatus === _constants.PROVIDER_STATUS_CONNECTION_FAILED) {
    return _react.default.createElement(ConnectionFailedInfra, null);
  }

  if (providerStatus === _constants.PROVIDER_STATUS_CONNECTING && !V2VVmwareName) {
    return _react.default.createElement(CheckingCredentials, null);
  }

  const resourceMap = {
    v2vvmware: {
      resource: (0, _utils.getResource)(_models.V2VVMwareModel, {
        name: V2VVmwareName,
        namespace: (0, _selectors.settingsValue)(basicSettings, _constants.NAMESPACE_KEY),
        isList: false
      })
    }
  };

  const resourceToProps = ({
    v2vvmware
  }) => ({
    // TODO: handle the case when V2VVmwareName is set but the object is missing in API (404)
    // means: it was garbage collected (so rare case)
    phase: (0, _lodash.get)(v2vvmware, 'status.phase') // value set by the controller

  });

  return _react.default.createElement(WithResources, {
    resourceMap: resourceMap,
    resourceToProps: resourceToProps
  }, _react.default.createElement(VMWareProviderStatusByPhase, null));
};

VMWareProviderStatus.defaultProps = {
  connValue: null
};
VMWareProviderStatus.propTypes = {
  extraProps: _propTypes.default.object.isRequired,
  connValue: _propTypes.default.object
};
var _default = VMWareProviderStatus;
exports.default = _default;