"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _lodash = require("lodash");

var _Form = require("../../../Form");

var _selectors = require("../../../../k8s/selectors");

var _constants = require("../constants");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class VCenterVmsWithPrefill extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      lastName: undefined,
      // last prefilled VM name value
      lastDescription: undefined
    });
  }

  prefillVmName(basicSettings, onFormChange, vmVmware) {
    const value = (0, _lodash.get)(vmVmware, ['Config', 'Name']);
    const formName = (0, _selectors.settingsValue)(basicSettings, _constants.NAME_KEY);

    if (!formName || formName === this.state.lastName) {
      if (this.state.lastName !== value) {
        // avoid infinite loop
        this.setState({
          lastName: value
        });
        return {
          value,
          target: _constants.NAME_KEY
        };
      }
    }

    return undefined;
  }

  prefillVmDescription(basicSettings, onFormChange, vmVmware) {
    const value = (0, _lodash.get)(vmVmware, ['Config', 'Annotation']);
    const formValue = (0, _selectors.settingsValue)(basicSettings, _constants.DESCRIPTION_KEY);

    if (!formValue || formValue === this.state.lastDescription) {
      if (this.state.lastDescription !== value) {
        // avoid infinite loop
        this.setState({
          lastDescription: value
        });
        return {
          value,
          target: _constants.DESCRIPTION_KEY
        };
      }
    }

    return undefined;
  }

  prefillValues(basicSettings, onFormChange, vmVmware) {
    const result = [];
    const namePair = this.prefillVmName(basicSettings, onFormChange, vmVmware);

    if (namePair) {
      result.push(namePair);
    }

    const descrPair = this.prefillVmDescription(basicSettings, onFormChange, vmVmware);

    if (descrPair) {
      result.push(descrPair);
    }

    if (result.length > 0) {
      onFormChange({
        value: result
      }, _constants.BATCH_CHANGES_KEY);
    }
  }

  componentDidUpdate() {
    const _this$props = this.props,
          onFormChange = _this$props.onFormChange,
          v2vvmware = _this$props.v2vvmware,
          basicSettings = _this$props.basicSettings;

    if (v2vvmware) {
      const selectedVmName = (0, _selectors.settingsValue)(basicSettings, _constants.PROVIDER_VMWARE_VM_KEY);

      if (this.state.lastName !== selectedVmName) {
        // just once
        const vms = (0, _lodash.get)(v2vvmware, 'spec.vms');
        const vmWithDetail = (vms || []).find(vm => vm.name === selectedVmName && vm.detail && vm.detail.raw);

        if (vmWithDetail) {
          const vmVmware = JSON.parse(vmWithDetail.detail.raw);
          this.prefillValues(basicSettings, onFormChange, vmVmware);
        }
      }
    }
  }

  render() {
    const _this$props2 = this.props,
          id = _this$props2.id,
          value = _this$props2.value,
          onChange = _this$props2.onChange,
          choices = _this$props2.choices,
          disabled = _this$props2.disabled;
    return _react.default.createElement(_Form.Dropdown, {
      id: id,
      value: value,
      onChange: onChange,
      choices: choices,
      disabled: disabled
    });
  }

}

VCenterVmsWithPrefill.defaultProps = {
  value: undefined,
  choices: [],
  disabled: true,
  v2vvmware: undefined
};
VCenterVmsWithPrefill.propTypes = {
  id: _propTypes.default.string.isRequired,
  onChange: _propTypes.default.func.isRequired,
  onFormChange: _propTypes.default.func.isRequired,
  basicSettings: _propTypes.default.object.isRequired,
  v2vvmware: _propTypes.default.object,
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object]),
  choices: _propTypes.default.array,
  disabled: _propTypes.default.bool
};
var _default = VCenterVmsWithPrefill;
exports.default = _default;